/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;

public class UnitVector3D
implements UnitVector3DBasics,
Settable<UnitVector3D> {
    public static final double ZERO_TEST_EPSILON = 1.0E-16;
    private boolean dirty = true;
    private double x;
    private double y;
    private double z;

    public UnitVector3D() {
        this.setToZero();
    }

    public UnitVector3D(double x, double y, double z) {
        this.set(x, y, z);
    }

    public UnitVector3D(double[] vectorArray) {
        this.set(vectorArray);
    }

    public UnitVector3D(Tuple2DReadOnly tuple2DReadOnly) {
        this.set(tuple2DReadOnly);
    }

    public UnitVector3D(Tuple3DReadOnly other) {
        this.set(other);
    }

    @Override
    public void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
    }

    @Override
    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    @Override
    public void normalize() {
        if (this.dirty) {
            if (EuclidCoreTools.areAllZero(this.x, this.y, this.z, 1.0E-16)) {
                this.setToZero();
            } else {
                double lengthInverse = 1.0 / EuclidCoreTools.fastNorm(this.x, this.y, this.z);
                this.x *= lengthInverse;
                this.y *= lengthInverse;
                this.z *= lengthInverse;
            }
            this.dirty = false;
        }
    }

    @Override
    public void markAsDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void set(UnitVector3D other) {
        this.set((UnitVector3DReadOnly)other);
    }

    @Override
    public void set(UnitVector3DReadOnly other) {
        this.x = other.getRawX();
        this.y = other.getRawY();
        this.z = other.getRawZ();
        this.dirty = other.isDirty();
    }

    @Override
    public void setX(double x) {
        if (this.x != x) {
            this.x = x;
            this.markAsDirty();
        }
    }

    @Override
    public void setY(double y) {
        if (this.y != y) {
            this.y = y;
            this.markAsDirty();
        }
    }

    @Override
    public void setZ(double z) {
        if (this.z != z) {
            this.z = z;
            this.markAsDirty();
        }
    }

    @Override
    public double getRawX() {
        return this.x;
    }

    @Override
    public double getRawY() {
        return this.y;
    }

    @Override
    public double getRawZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple3DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
    }
}

