/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.matrix.interfaces.LinearTransform3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface AffineTransformBasics
extends AffineTransformReadOnly,
Clearable {
    @Override
    public LinearTransform3DBasics getLinearTransform();

    @Override
    public Vector3DBasics getTranslation();

    default public void setIdentity() {
        this.getLinearTransform().setIdentity();
        this.getTranslation().setToZero();
    }

    @Override
    default public void setToZero() {
        this.getLinearTransform().setToZero();
        this.getTranslation().setToZero();
    }

    default public void setLinearTransformToIdentity() {
        this.getLinearTransform().setIdentity();
    }

    default public void resetScale() {
        this.getLinearTransform().resetScale();
    }

    default public void setTranslationToZero() {
        this.getTranslation().setToZero();
    }

    @Override
    default public void setToNaN() {
        this.getLinearTransform().setToNaN();
        this.getTranslation().setToNaN();
    }

    @Override
    default public boolean containsNaN() {
        return this.getLinearTransform().containsNaN() || this.getTranslation().containsNaN();
    }

    default public void invert() {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().invert();
            if (this.hasTranslation()) {
                this.getLinearTransform().transform(this.getTranslation());
            }
        }
        this.getTranslation().negate();
    }

    default public void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.getLinearTransform().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    default public void set(AffineTransformReadOnly other) {
        this.getLinearTransform().set(other.getLinearTransform());
        this.getTranslation().set(other.getTranslation());
    }

    default public void set(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.getLinearTransform().set(rigidBodyTransform.getRotation());
        this.getTranslation().set(rigidBodyTransform.getTranslation());
    }

    default public void set(DMatrix matrix) {
        this.getLinearTransform().set(matrix);
        this.getTranslation().set(0, 3, matrix);
    }

    default public void set(DMatrix matrix, int startRow, int startColumn) {
        this.getLinearTransform().set(startRow, startColumn, matrix);
        this.getTranslation().set(startRow, startColumn + 3, matrix);
    }

    default public void set(double[] transformArray) {
        double m00 = transformArray[0];
        double m01 = transformArray[1];
        double m02 = transformArray[2];
        double m03 = transformArray[3];
        double m10 = transformArray[4];
        double m11 = transformArray[5];
        double m12 = transformArray[6];
        double m13 = transformArray[7];
        double m20 = transformArray[8];
        double m21 = transformArray[9];
        double m22 = transformArray[10];
        double m23 = transformArray[11];
        this.getLinearTransform().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    default public void set(Matrix3DReadOnly linearTransform, Tuple3DReadOnly translation) {
        this.getLinearTransform().set(linearTransform);
        this.getTranslation().set(translation);
    }

    default public void set(DMatrix linearTransform, Tuple3DReadOnly translation) {
        this.getLinearTransform().set(linearTransform);
        this.getTranslation().set(translation);
    }

    default public void set(RotationMatrixReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.getLinearTransform().set(rotationMatrix);
        this.getTranslation().set(translation);
    }

    default public void set(Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.getLinearTransform().set(orientation);
        this.getTranslation().set(translation);
    }

    default public void setTranslationX(double x) {
        this.getTranslation().setX(x);
    }

    default public void setTranslationY(double y) {
        this.getTranslation().setY(y);
    }

    default public void setTranslationZ(double z) {
        this.getTranslation().setZ(z);
    }

    default public void setTranslation(double x, double y, double z) {
        this.getTranslation().set(x, y, z);
    }

    default public void setTranslation(Tuple3DReadOnly translation) {
        this.getTranslation().set(translation);
    }

    default public void setLinearTransform(Matrix3DReadOnly linearTransform) {
        this.getLinearTransform().set(linearTransform);
    }

    default public void setLinearTransform(DMatrix linearTransform) {
        this.getLinearTransform().set(linearTransform);
    }

    default public void setLinearTransform(RotationMatrixReadOnly rotationMatrix) {
        this.getLinearTransform().set(rotationMatrix);
    }

    default public void setLinearTransform(Orientation3DReadOnly orientation) {
        this.getLinearTransform().set(orientation);
    }

    default public void multiply(AffineTransformReadOnly other) {
        if (other.hasTranslation()) {
            this.getLinearTransform().addTransform(other.getTranslation(), this.getTranslation());
        }
        this.getLinearTransform().multiply(other.getLinearTransform());
    }

    default public void multiply(RigidBodyTransformReadOnly rigidBodyTransform) {
        if (rigidBodyTransform.hasTranslation()) {
            this.getLinearTransform().addTransform(rigidBodyTransform.getTranslation(), this.getTranslation());
        }
        this.getLinearTransform().appendRotation(rigidBodyTransform.getRotation());
    }

    default public void multiplyInvertThis(AffineTransformReadOnly other) {
        this.invert();
        this.multiply(other);
    }

    default public void multiplyInvertOther(AffineTransformReadOnly other) {
        this.getLinearTransform().multiplyInvertOther(other.getLinearTransform());
        if (other.hasTranslation()) {
            this.getLinearTransform().subTransform(other.getTranslation(), this.getTranslation());
        }
    }

    default public void multiplyInvertThis(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.invert();
        this.multiply(rigidBodyTransform);
    }

    default public void multiplyInvertOther(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.getLinearTransform().appendRotationInvertOther(rigidBodyTransform.getRotation());
        if (rigidBodyTransform.hasTranslation()) {
            this.getLinearTransform().subTransform(rigidBodyTransform.getTranslation(), this.getTranslation());
        } else {
            this.getTranslation().negate();
        }
    }

    default public void appendTranslation(Tuple3DReadOnly translation) {
        this.getLinearTransform().addTransform(translation, this.getTranslation());
    }

    default public void appendTranslation(double x, double y, double z) {
        if (this.getLinearTransform().isIdentity()) {
            this.getTranslation().add(x, y, z);
        } else {
            double thisX = this.getTranslation().getX();
            double thisY = this.getTranslation().getY();
            double thisZ = this.getTranslation().getZ();
            this.getTranslation().set(x, y, z);
            this.getLinearTransform().transform(this.getTranslation());
            this.getTranslation().add(thisX, thisY, thisZ);
        }
    }

    default public void appendOrientation(Orientation3DReadOnly orientation) {
        this.getLinearTransform().appendRotation(orientation);
    }

    default public void appendYawRotation(double yaw) {
        this.getLinearTransform().appendYawRotation(yaw);
    }

    default public void appendPitchRotation(double pitch) {
        this.getLinearTransform().appendPitchRotation(pitch);
    }

    default public void appendRollRotation(double roll) {
        this.getLinearTransform().appendRollRotation(roll);
    }

    default public void appendScale(double scale) {
        this.appendScale(scale, scale, scale);
    }

    default public void appendScale(Tuple3DReadOnly scale) {
        this.appendScale(scale.getX(), scale.getY(), scale.getZ());
    }

    default public void appendScale(double x, double y, double z) {
        this.getLinearTransform().appendScale(x, y, z);
    }

    default public void preMultiply(AffineTransformReadOnly other) {
        if (this.hasTranslation()) {
            other.getLinearTransform().transform(this.getTranslation());
        }
        this.getTranslation().add(other.getTranslation());
        this.getLinearTransform().preMultiply(other.getLinearTransform());
    }

    default public void preMultiply(RigidBodyTransformReadOnly rigidBodyTransform) {
        if (this.hasTranslation()) {
            rigidBodyTransform.transform(this.getTranslation());
        }
        this.getTranslation().add(rigidBodyTransform.getTranslation());
        this.getLinearTransform().prependRotation(rigidBodyTransform.getRotation());
    }

    default public void preMultiplyInvertThis(AffineTransformReadOnly other) {
        this.getLinearTransform().preMultiplyInvertThis(other.getLinearTransform());
        if (this.hasTranslation()) {
            this.getLinearTransform().transform(this.getTranslation());
        }
        this.getTranslation().sub(other.getTranslation(), this.getTranslation());
    }

    default public void preMultiplyInvertOther(AffineTransformReadOnly other) {
        this.getTranslation().sub(other.getTranslation());
        if (this.hasTranslation()) {
            other.getLinearTransform().inverseTransform(this.getTranslation());
        }
        this.getLinearTransform().preMultiplyInvertOther(other.getLinearTransform());
    }

    default public void preMultiplyInvertThis(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.invert();
        this.preMultiply(rigidBodyTransform);
    }

    default public void preMultiplyInvertOther(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.getTranslation().sub(rigidBodyTransform.getTranslation());
        if (this.hasTranslation()) {
            rigidBodyTransform.getRotation().inverseTransform(this.getTranslation());
        }
        this.getLinearTransform().prependRotationInvertOther(rigidBodyTransform.getRotation());
    }

    default public void prependTranslation(Tuple3DReadOnly translation) {
        this.getTranslation().add(translation);
    }

    default public void prependTranslation(double x, double y, double z) {
        this.getTranslation().add(x, y, z);
    }

    default public void prependOrientation(Orientation3DReadOnly orientation) {
        orientation.transform(this.getTranslation());
        this.getLinearTransform().prependRotation(orientation);
    }

    default public void prependYawRotation(double yaw) {
        RotationMatrixTools.applyYawRotation(yaw, this.getTranslation(), this.getTranslation());
        this.getLinearTransform().prependYawRotation(yaw);
    }

    default public void prependPitchRotation(double pitch) {
        RotationMatrixTools.applyPitchRotation(pitch, this.getTranslation(), this.getTranslation());
        this.getLinearTransform().prependPitchRotation(pitch);
    }

    default public void prependRollRotation(double roll) {
        RotationMatrixTools.applyRollRotation(roll, this.getTranslation(), this.getTranslation());
        this.getLinearTransform().prependRollRotation(roll);
    }

    default public void prependScale(double scale) {
        this.prependScale(scale, scale, scale);
    }

    default public void prependScale(Tuple3DReadOnly scale) {
        this.prependScale(scale.getX(), scale.getY(), scale.getZ());
    }

    default public void prependScale(double x, double y, double z) {
        this.getTranslation().scale(x, y, z);
        this.getLinearTransform().prependScale(x, y, z);
    }
}

