/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.exceptions.NotAPositiveDefiniteMatrixException;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;

public class Matrix3DFeatures {
    public static final double EPS_CHECK_IDENTITY = 1.0E-12;
    public static final double EPS_CHECK_ROTATION = 1.0E-7;
    public static final double EPS_CHECK_2D = 1.0E-8;
    public static final double EPS_CHECK_SKEW = 1.0E-8;
    public static final double EPS_CHECK_SYMMETRIC = 1.0E-8;

    private Matrix3DFeatures() {
    }

    public static double determinant(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double det = m00 * (m11 * m22 - m12 * m21);
        det += m01 * (m12 * m20 - m10 * m22);
        return det += m02 * (m10 * m21 - m11 * m20);
    }

    public static void checkIfPositiveDefiniteMatrix(DMatrix matrix) {
        Matrix3DFeatures.checkMatrixSize(matrix);
        double m00 = matrix.unsafe_get(0, 0);
        double m01 = matrix.unsafe_get(0, 1);
        double m02 = matrix.unsafe_get(0, 2);
        double m10 = matrix.unsafe_get(1, 0);
        double m11 = matrix.unsafe_get(1, 1);
        double m12 = matrix.unsafe_get(1, 2);
        double m20 = matrix.unsafe_get(2, 0);
        double m21 = matrix.unsafe_get(2, 1);
        double m22 = matrix.unsafe_get(2, 2);
        Matrix3DFeatures.checkIfPositiveDefiniteMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void checkIfPositiveDefiniteMatrix(double[] matrixArray) {
        Matrix3DFeatures.checkIfPositiveDefiniteMatrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5], matrixArray[6], matrixArray[7], matrixArray[8]);
    }

    public static void checkIfPositiveDefiniteMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        boolean isPositiveDefiniteMatrix = Matrix3DFeatures.isPositiveDefiniteMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        if (!isPositiveDefiniteMatrix) {
            throw new NotAPositiveDefiniteMatrixException(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    public static void checkIfRotationMatrix(DMatrix matrix) {
        Matrix3DFeatures.checkMatrixSize(matrix);
        double m00 = matrix.unsafe_get(0, 0);
        double m01 = matrix.unsafe_get(0, 1);
        double m02 = matrix.unsafe_get(0, 2);
        double m10 = matrix.unsafe_get(1, 0);
        double m11 = matrix.unsafe_get(1, 1);
        double m12 = matrix.unsafe_get(1, 2);
        double m20 = matrix.unsafe_get(2, 0);
        double m21 = matrix.unsafe_get(2, 1);
        double m22 = matrix.unsafe_get(2, 2);
        Matrix3DFeatures.checkIfRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void checkIfRotationMatrix(double[] matrixArray) {
        Matrix3DFeatures.checkIfRotationMatrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5], matrixArray[6], matrixArray[7], matrixArray[8]);
    }

    public static void checkIfRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        boolean isRotationMatrix = Matrix3DFeatures.isRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-7);
        if (!isRotationMatrix) {
            throw new NotARotationMatrixException(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    public static void checkMatrixSize(DMatrix matrix) {
        if (matrix.getNumRows() != 3 || matrix.getNumCols() != 3) {
            throw new MatrixDimensionException("Unexpected matrix size: " + matrix.getNumRows() + "-by-" + matrix.getNumCols() + ". Must be 3-by-3.");
        }
    }

    public static boolean isIdentity(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return Matrix3DFeatures.isIdentity(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-12);
    }

    public static boolean isIdentity(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m00 - 1.0) <= epsilon && Math.abs(m11 - 1.0) <= epsilon && Math.abs(m22 - 1.0) <= epsilon && Math.abs(m01) <= epsilon && Math.abs(m02) <= epsilon && Math.abs(m12) <= epsilon && Math.abs(m10) <= epsilon && Math.abs(m20) <= epsilon && Math.abs(m21) <= epsilon;
    }

    public static boolean isZero(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return Matrix3DFeatures.isZero(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-12);
    }

    public static boolean isZero(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m00) <= epsilon && Math.abs(m01) <= epsilon && Math.abs(m02) <= epsilon && Math.abs(m10) <= epsilon && Math.abs(m11) <= epsilon && Math.abs(m12) <= epsilon && Math.abs(m20) <= epsilon && Math.abs(m21) <= epsilon && Math.abs(m22) <= epsilon;
    }

    public static boolean isPositiveDefiniteMatrix(DMatrix matrix) {
        Matrix3DFeatures.checkMatrixSize(matrix);
        return Matrix3DFeatures.isPositiveDefiniteMatrix(matrix.unsafe_get(0, 0), matrix.unsafe_get(0, 1), matrix.unsafe_get(0, 2), matrix.unsafe_get(1, 0), matrix.unsafe_get(1, 1), matrix.unsafe_get(1, 2), matrix.unsafe_get(2, 0), matrix.unsafe_get(2, 1), matrix.unsafe_get(2, 2));
    }

    public static boolean isPositiveDefiniteMatrix(double[] matrixArray) {
        return Matrix3DFeatures.isPositiveDefiniteMatrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5], matrixArray[6], matrixArray[7], matrixArray[8]);
    }

    public static boolean isPositiveDefiniteMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double firstPrincipalMinorDeterminant = m00;
        double secondPrincipalMinorDeterminant = m00 * m11 - m01 * m10;
        double thirdPrincipalMinorDeterminant = Matrix3DFeatures.determinant(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        return firstPrincipalMinorDeterminant > 0.0 && secondPrincipalMinorDeterminant > 0.0 && thirdPrincipalMinorDeterminant > 0.0;
    }

    public static boolean isRotationMatrix(DMatrix matrix) {
        Matrix3DFeatures.checkMatrixSize(matrix);
        return Matrix3DFeatures.isRotationMatrix(matrix.unsafe_get(0, 0), matrix.unsafe_get(0, 1), matrix.unsafe_get(0, 2), matrix.unsafe_get(1, 0), matrix.unsafe_get(1, 1), matrix.unsafe_get(1, 2), matrix.unsafe_get(2, 0), matrix.unsafe_get(2, 1), matrix.unsafe_get(2, 2));
    }

    public static boolean isRotationMatrix(double[] matrixArray) {
        return Matrix3DFeatures.isRotationMatrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5], matrixArray[6], matrixArray[7], matrixArray[8]);
    }

    public static boolean isRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return Matrix3DFeatures.isRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-7);
    }

    public static boolean isRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        double xzDot;
        double xyDot = m00 * m10 + m01 * m11 + m02 * m12;
        if (Math.abs(xyDot) <= epsilon && Math.abs(xzDot = m00 * m20 + m01 * m21 + m02 * m22) <= epsilon) {
            double yzDot = m10 * m20 + m11 * m21 + m12 * m22;
            if (Math.abs(yzDot) > epsilon) {
                return false;
            }
            double xNormSquared = m00 * m00 + m01 * m01 + m02 * m02;
            if (Math.abs(xNormSquared - 1.0) > epsilon) {
                return false;
            }
            double yNormSquared = m10 * m10 + m11 * m11 + m12 * m12;
            if (Math.abs(yNormSquared - 1.0) > epsilon) {
                return false;
            }
            double zNormSquared = m20 * m20 + m21 * m21 + m22 * m22;
            if (Math.abs(zNormSquared - 1.0) > epsilon) {
                return false;
            }
            double determinant = Matrix3DFeatures.determinant(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            return !(Math.abs(determinant - 1.0) > epsilon);
        }
        return false;
    }

    public static boolean isMatrix2D(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m20) <= epsilon && Math.abs(m02) <= epsilon && Math.abs(m21) <= epsilon && Math.abs(m12) <= epsilon && Math.abs(m22 - 1.0) <= epsilon;
    }

    public static boolean isMatrixSkewSymmetric(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return Matrix3DFeatures.isMatrixSkewSymmetric(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-8);
    }

    public static boolean isMatrixSkewSymmetric(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m00) <= epsilon && Math.abs(m11) <= epsilon && Math.abs(m22) <= epsilon && Math.abs(m01 + m10) <= epsilon && Math.abs(m02 + m20) <= epsilon && Math.abs(m12 + m21) <= epsilon;
    }

    public static boolean isMatrixSymmetric(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return Matrix3DFeatures.isMatrixSymmetric(m00, m01, m02, m10, m11, m12, m20, m21, m22, 1.0E-8);
    }

    public static boolean isMatrixSymmetric(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m01 - m10) <= epsilon && Math.abs(m02 - m20) <= epsilon && Math.abs(m12 - m21) <= epsilon;
    }

    public static double maxElement(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double r0 = EuclidCoreTools.max(m00, m01, m02);
        double r1 = EuclidCoreTools.max(m10, m11, m12);
        double r2 = EuclidCoreTools.max(m20, m21, m22);
        return EuclidCoreTools.max(r0, r1, r2);
    }

    public static double maxAbsElement(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double r0 = EuclidCoreTools.max(Math.abs(m00), Math.abs(m01), Math.abs(m02));
        double r1 = EuclidCoreTools.max(Math.abs(m10), Math.abs(m11), Math.abs(m12));
        double r2 = EuclidCoreTools.max(Math.abs(m20), Math.abs(m21), Math.abs(m22));
        return EuclidCoreTools.max(r0, r1, r2);
    }

    public static double minElement(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double r0 = EuclidCoreTools.min(m00, m01, m02);
        double r1 = EuclidCoreTools.min(m10, m11, m12);
        double r2 = EuclidCoreTools.min(m20, m21, m22);
        return EuclidCoreTools.min(r0, r1, r2);
    }

    public static double minAbsElement(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double r0 = EuclidCoreTools.min(Math.abs(m00), Math.abs(m01), Math.abs(m02));
        double r1 = EuclidCoreTools.min(Math.abs(m10), Math.abs(m11), Math.abs(m12));
        double r2 = EuclidCoreTools.min(Math.abs(m20), Math.abs(m21), Math.abs(m22));
        return EuclidCoreTools.min(r0, r1, r2);
    }

    public static boolean epsilonEquals(Matrix3DReadOnly m1, Matrix3DReadOnly m2, double epsilon) {
        double diff = m1.getM00() - m2.getM00();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM01() - m2.getM01();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM02() - m2.getM02();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM10() - m2.getM10();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM11() - m2.getM11();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM12() - m2.getM12();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM20() - m2.getM20();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM21() - m2.getM21();
        if (Double.isNaN(diff) || Math.abs(diff) > epsilon) {
            return false;
        }
        diff = m1.getM22() - m2.getM22();
        return !Double.isNaN(diff) && !(Math.abs(diff) > epsilon);
    }

    public static boolean equals(Matrix3DReadOnly m1, Matrix3DReadOnly m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM00(), m2.getM00())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM01(), m2.getM01())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM02(), m2.getM02())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM10(), m2.getM10())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM11(), m2.getM11())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM12(), m2.getM12())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM20(), m2.getM20())) {
            return false;
        }
        if (!EuclidCoreTools.equals(m1.getM21(), m2.getM21())) {
            return false;
        }
        return EuclidCoreTools.equals(m1.getM22(), m2.getM22());
    }
}

