/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation;

import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;

public class Orientation2D
implements Orientation2DBasics,
Settable<Orientation2D> {
    private double yaw = 0.0;
    private final Vector2D xVector = new Vector2D(Axis2D.X);

    public Orientation2D() {
        this.setToZero();
    }

    public Orientation2D(double yaw) {
        this.setYaw(yaw);
    }

    public Orientation2D(Orientation2DReadOnly other) {
        this.set(other);
    }

    @Override
    public void set(Orientation2DReadOnly other) {
        Orientation2DBasics.super.set(other);
    }

    @Override
    public void set(Orientation2D other) {
        Orientation2DBasics.super.set(other);
    }

    @Override
    public void setYaw(double yaw) {
        this.yaw = EuclidCoreTools.trimAngleMinusPiToPi(yaw);
    }

    @Override
    public double getYaw() {
        return this.yaw;
    }

    @Override
    public void applyTransform(Transform transform) {
        this.xVector.set(Axis2D.X);
        transform.transform(this.xVector);
        double deltaYaw = EuclidCoreTools.atan2(this.xVector.getY(), this.xVector.getX());
        if (Double.isNaN(deltaYaw) || Double.isInfinite(deltaYaw)) {
            deltaYaw = 0.0;
        }
        this.add(deltaYaw);
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        this.xVector.set(Axis2D.X);
        transform.inverseTransform(this.xVector);
        double deltaYaw = EuclidCoreTools.atan2(this.xVector.getY(), this.xVector.getX());
        if (Double.isNaN(deltaYaw) || Double.isInfinite(deltaYaw)) {
            deltaYaw = 0.0;
        }
        this.add(deltaYaw);
    }

    public boolean equals(Object object) {
        if (object instanceof Orientation2DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.yaw);
    }
}

