/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.LinearTransform3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface LinearTransform3DBasics
extends LinearTransform3DReadOnly,
Matrix3DBasics {
    public void resetScale();

    default public void setRotationVector(Vector3DReadOnly rotationVector) {
        RotationMatrixConversion.convertRotationVectorToMatrix(rotationVector, this);
    }

    default public void setEuler(Tuple3DReadOnly eulerAngles) {
        this.setEuler(eulerAngles.getX(), eulerAngles.getY(), eulerAngles.getZ());
    }

    default public void setEuler(double rotX, double rotY, double rotZ) {
        RotationMatrixConversion.convertYawPitchRollToMatrix(rotZ, rotY, rotX, this);
    }

    default public void setScale(double scale) {
        this.setScale(scale, scale, scale);
    }

    default public void setScale(Tuple3DReadOnly scale) {
        this.setScale(scale.getX(), scale.getY(), scale.getZ());
    }

    default public void setScale(double x, double y, double z) {
        this.resetScale();
        this.appendScale(x, y, z);
    }

    default public void appendRotation(Orientation3DReadOnly orientation) {
        Matrix3DTools.multiply(this, false, false, orientation, false, (CommonMatrix3DBasics)this);
    }

    default public void appendRotationInvertOther(Orientation3DReadOnly orientation) {
        Matrix3DTools.multiply(this, false, false, orientation, true, (CommonMatrix3DBasics)this);
    }

    default public void appendRotationInvertThis(Orientation3DReadOnly orientation) {
        this.invert();
        this.appendRotation(orientation);
    }

    default public void appendRotationInvertBoth(Orientation3DReadOnly orientation) {
        this.invert();
        this.appendRotationInvertOther(orientation);
    }

    default public void appendYawRotation(double yaw) {
        RotationMatrixTools.appendYawRotation(this, yaw, this);
    }

    default public void appendPitchRotation(double pitch) {
        RotationMatrixTools.appendPitchRotation(this, pitch, this);
    }

    default public void appendRollRotation(double roll) {
        RotationMatrixTools.appendRollRotation(this, roll, this);
    }

    default public void appendScale(double scale) {
        this.scale(scale);
    }

    default public void appendScale(Tuple3DReadOnly scale) {
        this.appendScale(scale.getX(), scale.getY(), scale.getZ());
    }

    default public void appendScale(double x, double y, double z) {
        this.scaleColumns(x, y, z);
    }

    default public void prependRotation(Orientation3DReadOnly orientation) {
        Matrix3DTools.multiply(orientation, false, this, false, false, (CommonMatrix3DBasics)this);
    }

    default public void prependRotationInvertOther(Orientation3DReadOnly orientation) {
        Matrix3DTools.multiply(orientation, true, this, false, false, (CommonMatrix3DBasics)this);
    }

    default public void prependRotationInvertThis(Orientation3DReadOnly orientation) {
        this.invert();
        this.prependRotation(orientation);
    }

    default public void prependRotationInvertBoth(Orientation3DReadOnly orientation) {
        this.invert();
        this.prependRotationInvertOther(orientation);
    }

    default public void prependYawRotation(double yaw) {
        RotationMatrixTools.prependYawRotation(yaw, this, this);
    }

    default public void prependPitchRotation(double pitch) {
        RotationMatrixTools.prependPitchRotation(pitch, this, this);
    }

    default public void prependRollRotation(double roll) {
        RotationMatrixTools.prependRollRotation(roll, this, this);
    }

    default public void prependScale(double scale) {
        this.prependScale(scale, scale, scale);
    }

    default public void prependScale(Tuple3DReadOnly scale) {
        this.prependScale(scale.getX(), scale.getY(), scale.getZ());
    }

    default public void prependScale(double x, double y, double z) {
        this.scaleRows(x, y, z);
    }
}

