/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public class RigidBodyTransform
implements RigidBodyTransformBasics,
Settable<RigidBodyTransform> {
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    private final Vector3D translationVector = new Vector3D();

    public RigidBodyTransform() {
    }

    public RigidBodyTransform(RigidBodyTransformReadOnly other) {
        this.set(other);
    }

    public RigidBodyTransform(DMatrix matrix) {
        this.set(matrix);
    }

    public RigidBodyTransform(double[] transformArray) {
        this.set(transformArray);
    }

    public RigidBodyTransform(Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.set(orientation, translation);
    }

    public RigidBodyTransform(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
    }

    public void setIdentity() {
        RigidBodyTransformBasics.super.setToZero();
    }

    public void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    public void setUnsafe(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    @Override
    public void set(RigidBodyTransform other) {
        this.set((RigidBodyTransformReadOnly)other);
    }

    @Override
    public void set(DMatrix matrix) {
        this.getRotation().set(matrix);
        this.getTranslation().set(0, 3, matrix);
    }

    public void set(DMatrix matrix, int startRow, int startColumn) {
        this.getRotation().set(startRow, startColumn, matrix);
        this.getTranslation().set(startRow, startColumn + 3, matrix);
    }

    @Override
    public void set(double[] transformArray) {
        double m00 = transformArray[0];
        double m01 = transformArray[1];
        double m02 = transformArray[2];
        double m03 = transformArray[3];
        double m10 = transformArray[4];
        double m11 = transformArray[5];
        double m12 = transformArray[6];
        double m13 = transformArray[7];
        double m20 = transformArray[8];
        double m21 = transformArray[9];
        double m22 = transformArray[10];
        double m23 = transformArray[11];
        this.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    public void setAsTranspose(double[] transformArray) {
        double m00 = transformArray[0];
        double m01 = transformArray[4];
        double m02 = transformArray[8];
        double m03 = transformArray[12];
        double m10 = transformArray[1];
        double m11 = transformArray[5];
        double m12 = transformArray[9];
        double m13 = transformArray[13];
        double m20 = transformArray[2];
        double m21 = transformArray[6];
        double m22 = transformArray[10];
        double m23 = transformArray[14];
        this.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    @Override
    public void set(float[] transformArray) {
        double m00 = transformArray[0];
        double m01 = transformArray[1];
        double m02 = transformArray[2];
        double m03 = transformArray[3];
        double m10 = transformArray[4];
        double m11 = transformArray[5];
        double m12 = transformArray[6];
        double m13 = transformArray[7];
        double m20 = transformArray[8];
        double m21 = transformArray[9];
        double m22 = transformArray[10];
        double m23 = transformArray[11];
        this.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    public void setAsTranspose(float[] transformArray) {
        double m00 = transformArray[0];
        double m01 = transformArray[4];
        double m02 = transformArray[8];
        double m03 = transformArray[12];
        double m10 = transformArray[1];
        double m11 = transformArray[5];
        double m12 = transformArray[9];
        double m13 = transformArray[13];
        double m20 = transformArray[2];
        double m21 = transformArray[6];
        double m22 = transformArray[10];
        double m23 = transformArray[14];
        this.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.getTranslation().set(m03, m13, m23);
    }

    public void set(Matrix3DReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.getRotation().set(rotationMatrix);
        this.getTranslation().set(translation);
    }

    public void setRotationAndZeroTranslation(DMatrix rotationMatrix) {
        this.getRotation().set(rotationMatrix);
        this.setTranslationToZero();
    }

    public void setRotationAndZeroTranslation(Matrix3DReadOnly rotationMatrix) {
        this.getRotation().set(rotationMatrix);
        this.setTranslationToZero();
    }

    public void interpolate(RigidBodyTransform other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    public void interpolate(RigidBodyTransform transform1, RigidBodyTransform transform2, double alpha) {
        this.getRotation().interpolate(transform1.getRotation(), transform2.getRotation(), alpha);
        this.getTranslation().interpolate(transform1.getTranslation(), transform2.getTranslation(), alpha);
    }

    public void get(DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(4, 4, (Matrix)matrixToPack);
        this.getRotation().get(matrixToPack);
        this.getTranslation().get(0, 3, matrixToPack);
        matrixToPack.unsafe_set(3, 0, 0.0);
        matrixToPack.unsafe_set(3, 1, 0.0);
        matrixToPack.unsafe_set(3, 2, 0.0);
        matrixToPack.unsafe_set(3, 3, 1.0);
    }

    public void get(int startRow, int startColumn, DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 4, startColumn + 4, (Matrix)matrixToPack);
        this.getRotation().get(startRow, startColumn, matrixToPack);
        this.getTranslation().get(startRow, startColumn + 3, matrixToPack);
        matrixToPack.unsafe_set(startRow += 3, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn, 1.0);
    }

    public void get(double[] transformArrayToPack) {
        transformArrayToPack[0] = this.getM00();
        transformArrayToPack[1] = this.getM01();
        transformArrayToPack[2] = this.getM02();
        transformArrayToPack[3] = this.getM03();
        transformArrayToPack[4] = this.getM10();
        transformArrayToPack[5] = this.getM11();
        transformArrayToPack[6] = this.getM12();
        transformArrayToPack[7] = this.getM13();
        transformArrayToPack[8] = this.getM20();
        transformArrayToPack[9] = this.getM21();
        transformArrayToPack[10] = this.getM22();
        transformArrayToPack[11] = this.getM23();
        transformArrayToPack[12] = this.getM30();
        transformArrayToPack[13] = this.getM31();
        transformArrayToPack[14] = this.getM32();
        transformArrayToPack[15] = this.getM33();
    }

    public void get(float[] transformArrayToPack) {
        transformArrayToPack[0] = (float)this.getM00();
        transformArrayToPack[1] = (float)this.getM01();
        transformArrayToPack[2] = (float)this.getM02();
        transformArrayToPack[3] = (float)this.getM03();
        transformArrayToPack[4] = (float)this.getM10();
        transformArrayToPack[5] = (float)this.getM11();
        transformArrayToPack[6] = (float)this.getM12();
        transformArrayToPack[7] = (float)this.getM13();
        transformArrayToPack[8] = (float)this.getM20();
        transformArrayToPack[9] = (float)this.getM21();
        transformArrayToPack[10] = (float)this.getM22();
        transformArrayToPack[11] = (float)this.getM23();
        transformArrayToPack[12] = (float)this.getM30();
        transformArrayToPack[13] = (float)this.getM31();
        transformArrayToPack[14] = (float)this.getM32();
        transformArrayToPack[15] = (float)this.getM33();
    }

    public void get(CommonMatrix3DBasics rotationMarixToPack, Tuple3DBasics translationToPack) {
        rotationMarixToPack.set(this.getRotation());
        translationToPack.set(this.getTranslation());
    }

    @Override
    public RotationMatrixBasics getRotation() {
        return this.rotationMatrix;
    }

    @Override
    public Vector3DBasics getTranslation() {
        return this.translationVector;
    }

    public double getElement(int row, int column) {
        if (row < 3) {
            if (column < 3) {
                return this.getRotation().getElement(row, column);
            }
            if (column < 4) {
                return this.getTranslation().getElement(row);
            }
            throw Matrix3DTools.columnOutOfBoundsException(3, column);
        }
        if (row < 4) {
            if (column < 3) {
                return 0.0;
            }
            if (column < 4) {
                return 1.0;
            }
            throw Matrix3DTools.columnOutOfBoundsException(3, column);
        }
        throw Matrix3DTools.rowOutOfBoundsException(3, row);
    }

    public double getM00() {
        return this.getRotation().getM00();
    }

    public double getM01() {
        return this.getRotation().getM01();
    }

    public double getM02() {
        return this.getRotation().getM02();
    }

    public double getM03() {
        return this.getTranslation().getX();
    }

    public double getM10() {
        return this.getRotation().getM10();
    }

    public double getM11() {
        return this.getRotation().getM11();
    }

    public double getM12() {
        return this.getRotation().getM12();
    }

    public double getM13() {
        return this.getTranslation().getY();
    }

    public double getM20() {
        return this.getRotation().getM20();
    }

    public double getM21() {
        return this.getRotation().getM21();
    }

    public double getM22() {
        return this.getRotation().getM22();
    }

    public double getM23() {
        return this.getTranslation().getZ();
    }

    public double getM30() {
        return 0.0;
    }

    public double getM31() {
        return 0.0;
    }

    public double getM32() {
        return 0.0;
    }

    public double getM33() {
        return 1.0;
    }

    public boolean equals(Object object) {
        if (object instanceof RigidBodyTransform) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    @Override
    public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof RigidBodyTransform)) {
            return false;
        }
        RigidBodyTransform other = (RigidBodyTransform)geometry;
        return this.getRotation().equals(other.getRotation()) && this.getTranslation().equals(other.getTranslation());
    }

    @Override
    public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof RigidBodyTransformReadOnly)) {
            return false;
        }
        RigidBodyTransformReadOnly other = (RigidBodyTransformReadOnly)geometry;
        return this.getRotation().epsilonEquals(other.getRotation(), epsilon) && this.getTranslation().epsilonEquals(other.getTranslation(), epsilon);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    @Override
    public String toString(String format) {
        return EuclidCoreIOTools.getRigidBodyTransformString(format, this);
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)this.getRotation().hashCode(), this.getTranslation().hashCode());
        return EuclidHashCodeTools.toIntHashCode(bits);
    }
}

