/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationMatrixTools {
    static final double EPS = 1.0E-12;

    private RotationMatrixTools() {
    }

    public static void multiply(RotationMatrixReadOnly m1, RotationMatrixReadOnly m2, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixTools.multiplyImpl(m1, false, m2, false, matrixToPack);
    }

    public static void multiplyTransposeBoth(RotationMatrixReadOnly m1, RotationMatrixReadOnly m2, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixTools.multiplyImpl(m1, true, m2, true, matrixToPack);
    }

    public static void multiplyTransposeLeft(RotationMatrixReadOnly m1, RotationMatrixReadOnly m2, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixTools.multiplyImpl(m1, true, m2, false, matrixToPack);
    }

    public static void multiplyTransposeRight(RotationMatrixReadOnly m1, RotationMatrixReadOnly m2, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixTools.multiplyImpl(m1, false, m2, true, matrixToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, CommonMatrix3DBasics matrixToPack) {
        double b22;
        double b21;
        double b20;
        double b12;
        double b11;
        double b10;
        double b02;
        double b01;
        double b00;
        if (orientation1 instanceof RotationMatrixReadOnly) {
            RotationMatrixTools.multiply((RotationMatrixReadOnly)orientation1, inverse1, orientation2, inverse2, matrixToPack);
            return;
        }
        if (orientation1.isZeroOrientation()) {
            if (orientation2.isZeroOrientation()) {
                matrixToPack.setIdentity();
            } else if (inverse2) {
                matrixToPack.set(orientation2);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation2);
            }
            return;
        }
        if (orientation2.isZeroOrientation()) {
            if (inverse1) {
                matrixToPack.set(orientation1);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation1);
            }
            return;
        }
        if (orientation2 instanceof RotationMatrixReadOnly) {
            RotationMatrixReadOnly b = (RotationMatrixReadOnly)orientation2;
            b00 = b.getM00();
            b01 = b.getM01();
            b02 = b.getM02();
            b10 = b.getM10();
            b11 = b.getM11();
            b12 = b.getM12();
            b20 = b.getM20();
            b21 = b.getM21();
            b22 = b.getM22();
        } else {
            matrixToPack.set(orientation2);
            b00 = matrixToPack.getM00();
            b01 = matrixToPack.getM01();
            b02 = matrixToPack.getM02();
            b10 = matrixToPack.getM10();
            b11 = matrixToPack.getM11();
            b12 = matrixToPack.getM12();
            b20 = matrixToPack.getM20();
            b21 = matrixToPack.getM21();
            b22 = matrixToPack.getM22();
        }
        matrixToPack.set(orientation1);
        double a00 = matrixToPack.getM00();
        double a01 = matrixToPack.getM01();
        double a02 = matrixToPack.getM02();
        double a10 = matrixToPack.getM10();
        double a11 = matrixToPack.getM11();
        double a12 = matrixToPack.getM12();
        double a20 = matrixToPack.getM20();
        double a21 = matrixToPack.getM21();
        double a22 = matrixToPack.getM22();
        RotationMatrixTools.multiplyImpl(a00, a01, a02, a10, a11, a12, a20, a21, a22, inverse1, b00, b01, b02, b10, b11, b12, b20, b21, b22, inverse2, matrixToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, RotationMatrixReadOnly orientation2, boolean inverse2, CommonMatrix3DBasics matrixToPack) {
        if (orientation1 instanceof RotationMatrixReadOnly) {
            RotationMatrixTools.multiplyImpl((RotationMatrixReadOnly)orientation1, inverse1, orientation2, inverse2, matrixToPack);
            return;
        }
        if (orientation1.isZeroOrientation()) {
            if (orientation2.isZeroOrientation()) {
                matrixToPack.setIdentity();
            } else if (inverse2) {
                matrixToPack.set(orientation2);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation2);
            }
            return;
        }
        if (orientation2.isZeroOrientation()) {
            if (inverse1) {
                matrixToPack.set(orientation1);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation1);
            }
            return;
        }
        double b00 = orientation2.getM00();
        double b01 = orientation2.getM01();
        double b02 = orientation2.getM02();
        double b10 = orientation2.getM10();
        double b11 = orientation2.getM11();
        double b12 = orientation2.getM12();
        double b20 = orientation2.getM20();
        double b21 = orientation2.getM21();
        double b22 = orientation2.getM22();
        matrixToPack.set(orientation1);
        double a00 = matrixToPack.getM00();
        double a01 = matrixToPack.getM01();
        double a02 = matrixToPack.getM02();
        double a10 = matrixToPack.getM10();
        double a11 = matrixToPack.getM11();
        double a12 = matrixToPack.getM12();
        double a20 = matrixToPack.getM20();
        double a21 = matrixToPack.getM21();
        double a22 = matrixToPack.getM22();
        RotationMatrixTools.multiplyImpl(a00, a01, a02, a10, a11, a12, a20, a21, a22, inverse1, b00, b01, b02, b10, b11, b12, b20, b21, b22, inverse2, matrixToPack);
    }

    public static void multiply(RotationMatrixReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, CommonMatrix3DBasics matrixToPack) {
        if (orientation2 instanceof RotationMatrixReadOnly) {
            RotationMatrixTools.multiplyImpl(orientation1, inverse1, (RotationMatrixReadOnly)orientation2, inverse2, matrixToPack);
            return;
        }
        if (orientation1.isZeroOrientation()) {
            if (orientation2.isZeroOrientation()) {
                matrixToPack.setIdentity();
            } else if (inverse2) {
                matrixToPack.set(orientation2);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation2);
            }
            return;
        }
        if (orientation2.isZeroOrientation()) {
            if (inverse1) {
                matrixToPack.set(orientation1);
                matrixToPack.transpose();
            } else {
                matrixToPack.set(orientation1);
            }
            return;
        }
        double a00 = orientation1.getM00();
        double a01 = orientation1.getM01();
        double a02 = orientation1.getM02();
        double a10 = orientation1.getM10();
        double a11 = orientation1.getM11();
        double a12 = orientation1.getM12();
        double a20 = orientation1.getM20();
        double a21 = orientation1.getM21();
        double a22 = orientation1.getM22();
        matrixToPack.set(orientation2);
        double b00 = matrixToPack.getM00();
        double b01 = matrixToPack.getM01();
        double b02 = matrixToPack.getM02();
        double b10 = matrixToPack.getM10();
        double b11 = matrixToPack.getM11();
        double b12 = matrixToPack.getM12();
        double b20 = matrixToPack.getM20();
        double b21 = matrixToPack.getM21();
        double b22 = matrixToPack.getM22();
        RotationMatrixTools.multiplyImpl(a00, a01, a02, a10, a11, a12, a20, a21, a22, inverse1, b00, b01, b02, b10, b11, b12, b20, b21, b22, inverse2, matrixToPack);
    }

    private static void multiplyImpl(RotationMatrixReadOnly a, boolean transposeA, RotationMatrixReadOnly b, boolean transposeB, CommonMatrix3DBasics matrixToPack) {
        if (a.isZeroOrientation()) {
            if (b.isZeroOrientation()) {
                matrixToPack.setIdentity();
            } else if (transposeB) {
                matrixToPack.setAndTranspose(b);
            } else {
                matrixToPack.set(b);
            }
            return;
        }
        if (b.isZeroOrientation()) {
            if (transposeA) {
                matrixToPack.setAndTranspose(a);
            } else {
                matrixToPack.set(a);
            }
            return;
        }
        RotationMatrixTools.multiplyImpl(a.getM00(), a.getM01(), a.getM02(), a.getM10(), a.getM11(), a.getM12(), a.getM20(), a.getM21(), a.getM22(), transposeA, b.getM00(), b.getM01(), b.getM02(), b.getM10(), b.getM11(), b.getM12(), b.getM20(), b.getM21(), b.getM22(), transposeB, matrixToPack);
    }

    private static void multiplyImpl(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22, boolean transposeA, double b00, double b01, double b02, double b10, double b11, double b12, double b20, double b21, double b22, boolean transposeB, CommonMatrix3DBasics matrixToPack) {
        double c22;
        double c21;
        double c20;
        double c12;
        double c11;
        double c10;
        double c02;
        double c01;
        double c00;
        if (transposeA) {
            if (transposeB) {
                c00 = a00 * b00 + a10 * b01 + a20 * b02;
                c01 = a00 * b10 + a10 * b11 + a20 * b12;
                c02 = a00 * b20 + a10 * b21 + a20 * b22;
                c10 = a01 * b00 + a11 * b01 + a21 * b02;
                c11 = a01 * b10 + a11 * b11 + a21 * b12;
                c12 = a01 * b20 + a11 * b21 + a21 * b22;
                c20 = a02 * b00 + a12 * b01 + a22 * b02;
                c21 = a02 * b10 + a12 * b11 + a22 * b12;
                c22 = a02 * b20 + a12 * b21 + a22 * b22;
            } else {
                c00 = a00 * b00 + a10 * b10 + a20 * b20;
                c01 = a00 * b01 + a10 * b11 + a20 * b21;
                c02 = a00 * b02 + a10 * b12 + a20 * b22;
                c10 = a01 * b00 + a11 * b10 + a21 * b20;
                c11 = a01 * b01 + a11 * b11 + a21 * b21;
                c12 = a01 * b02 + a11 * b12 + a21 * b22;
                c20 = a02 * b00 + a12 * b10 + a22 * b20;
                c21 = a02 * b01 + a12 * b11 + a22 * b21;
                c22 = a02 * b02 + a12 * b12 + a22 * b22;
            }
        } else if (transposeB) {
            c00 = a00 * b00 + a01 * b01 + a02 * b02;
            c01 = a00 * b10 + a01 * b11 + a02 * b12;
            c02 = a00 * b20 + a01 * b21 + a02 * b22;
            c10 = a10 * b00 + a11 * b01 + a12 * b02;
            c11 = a10 * b10 + a11 * b11 + a12 * b12;
            c12 = a10 * b20 + a11 * b21 + a12 * b22;
            c20 = a20 * b00 + a21 * b01 + a22 * b02;
            c21 = a20 * b10 + a21 * b11 + a22 * b12;
            c22 = a20 * b20 + a21 * b21 + a22 * b22;
        } else {
            c00 = a00 * b00 + a01 * b10 + a02 * b20;
            c01 = a00 * b01 + a01 * b11 + a02 * b21;
            c02 = a00 * b02 + a01 * b12 + a02 * b22;
            c10 = a10 * b00 + a11 * b10 + a12 * b20;
            c11 = a10 * b01 + a11 * b11 + a12 * b21;
            c12 = a10 * b02 + a11 * b12 + a12 * b22;
            c20 = a20 * b00 + a21 * b10 + a22 * b20;
            c21 = a20 * b01 + a21 * b11 + a22 * b21;
            c22 = a20 * b02 + a21 * b12 + a22 * b22;
        }
        matrixToPack.set(c00, c01, c02, c10, c11, c12, c20, c21, c22);
    }

    public static void prependYawRotation(double yaw, Matrix3DReadOnly matrixOriginal, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computeYawMatrix(yaw, matrixToPack);
            return;
        }
        double cYaw = EuclidCoreTools.cos(yaw);
        double sYaw = EuclidCoreTools.sin(yaw);
        double m00 = cYaw * matrixOriginal.getM00() - sYaw * matrixOriginal.getM10();
        double m01 = cYaw * matrixOriginal.getM01() - sYaw * matrixOriginal.getM11();
        double m02 = cYaw * matrixOriginal.getM02() - sYaw * matrixOriginal.getM12();
        double m10 = sYaw * matrixOriginal.getM00() + cYaw * matrixOriginal.getM10();
        double m11 = sYaw * matrixOriginal.getM01() + cYaw * matrixOriginal.getM11();
        double m12 = sYaw * matrixOriginal.getM02() + cYaw * matrixOriginal.getM12();
        double m20 = matrixOriginal.getM20();
        double m21 = matrixOriginal.getM21();
        double m22 = matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void appendYawRotation(Matrix3DReadOnly matrixOriginal, double yaw, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computeYawMatrix(yaw, matrixToPack);
            return;
        }
        double cYaw = EuclidCoreTools.cos(yaw);
        double sYaw = EuclidCoreTools.sin(yaw);
        double m00 = cYaw * matrixOriginal.getM00() + sYaw * matrixOriginal.getM01();
        double m01 = -sYaw * matrixOriginal.getM00() + cYaw * matrixOriginal.getM01();
        double m02 = matrixOriginal.getM02();
        double m10 = cYaw * matrixOriginal.getM10() + sYaw * matrixOriginal.getM11();
        double m11 = -sYaw * matrixOriginal.getM10() + cYaw * matrixOriginal.getM11();
        double m12 = matrixOriginal.getM12();
        double m20 = cYaw * matrixOriginal.getM20() + sYaw * matrixOriginal.getM21();
        double m21 = -sYaw * matrixOriginal.getM20() + cYaw * matrixOriginal.getM21();
        double m22 = matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void prependPitchRotation(double pitch, Matrix3DReadOnly matrixOriginal, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computePitchMatrix(pitch, matrixToPack);
            return;
        }
        double cPitch = EuclidCoreTools.cos(pitch);
        double sPitch = EuclidCoreTools.sin(pitch);
        double m00 = cPitch * matrixOriginal.getM00() + sPitch * matrixOriginal.getM20();
        double m01 = cPitch * matrixOriginal.getM01() + sPitch * matrixOriginal.getM21();
        double m02 = cPitch * matrixOriginal.getM02() + sPitch * matrixOriginal.getM22();
        double m10 = matrixOriginal.getM10();
        double m11 = matrixOriginal.getM11();
        double m12 = matrixOriginal.getM12();
        double m20 = -sPitch * matrixOriginal.getM00() + cPitch * matrixOriginal.getM20();
        double m21 = -sPitch * matrixOriginal.getM01() + cPitch * matrixOriginal.getM21();
        double m22 = -sPitch * matrixOriginal.getM02() + cPitch * matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void appendPitchRotation(Matrix3DReadOnly matrixOriginal, double pitch, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computePitchMatrix(pitch, matrixToPack);
            return;
        }
        double cPitch = EuclidCoreTools.cos(pitch);
        double sPitch = EuclidCoreTools.sin(pitch);
        double m00 = cPitch * matrixOriginal.getM00() - sPitch * matrixOriginal.getM02();
        double m01 = matrixOriginal.getM01();
        double m02 = sPitch * matrixOriginal.getM00() + cPitch * matrixOriginal.getM02();
        double m10 = cPitch * matrixOriginal.getM10() - sPitch * matrixOriginal.getM12();
        double m11 = matrixOriginal.getM11();
        double m12 = sPitch * matrixOriginal.getM10() + cPitch * matrixOriginal.getM12();
        double m20 = cPitch * matrixOriginal.getM20() - sPitch * matrixOriginal.getM22();
        double m21 = matrixOriginal.getM21();
        double m22 = sPitch * matrixOriginal.getM20() + cPitch * matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void prependRollRotation(double roll, Matrix3DReadOnly matrixOriginal, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computeRollMatrix(roll, matrixToPack);
            return;
        }
        double cRoll = EuclidCoreTools.cos(roll);
        double sRoll = EuclidCoreTools.sin(roll);
        double m00 = matrixOriginal.getM00();
        double m01 = matrixOriginal.getM01();
        double m02 = matrixOriginal.getM02();
        double m10 = cRoll * matrixOriginal.getM10() - sRoll * matrixOriginal.getM20();
        double m11 = cRoll * matrixOriginal.getM11() - sRoll * matrixOriginal.getM21();
        double m12 = cRoll * matrixOriginal.getM12() - sRoll * matrixOriginal.getM22();
        double m20 = sRoll * matrixOriginal.getM10() + cRoll * matrixOriginal.getM20();
        double m21 = sRoll * matrixOriginal.getM11() + cRoll * matrixOriginal.getM21();
        double m22 = sRoll * matrixOriginal.getM12() + cRoll * matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void appendRollRotation(Matrix3DReadOnly matrixOriginal, double roll, CommonMatrix3DBasics matrixToPack) {
        if (matrixOriginal.isIdentity()) {
            RotationMatrixConversion.computeRollMatrix(roll, matrixToPack);
            return;
        }
        double cRoll = EuclidCoreTools.cos(roll);
        double sRoll = EuclidCoreTools.sin(roll);
        double m00 = matrixOriginal.getM00();
        double m01 = cRoll * matrixOriginal.getM01() + sRoll * matrixOriginal.getM02();
        double m02 = -sRoll * matrixOriginal.getM01() + cRoll * matrixOriginal.getM02();
        double m10 = matrixOriginal.getM10();
        double m11 = cRoll * matrixOriginal.getM11() + sRoll * matrixOriginal.getM12();
        double m12 = -sRoll * matrixOriginal.getM11() + cRoll * matrixOriginal.getM12();
        double m20 = matrixOriginal.getM20();
        double m21 = cRoll * matrixOriginal.getM21() + sRoll * matrixOriginal.getM22();
        double m22 = -sRoll * matrixOriginal.getM21() + cRoll * matrixOriginal.getM22();
        matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void applyYawRotation(double yaw, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double cYaw = EuclidCoreTools.cos(yaw);
        double sYaw = EuclidCoreTools.sin(yaw);
        double x = tupleOriginal.getX() * cYaw - tupleOriginal.getY() * sYaw;
        double y = tupleOriginal.getX() * sYaw + tupleOriginal.getY() * cYaw;
        double z = tupleOriginal.getZ();
        tupleTransformed.set(x, y, z);
    }

    public static void applyYawRotation(double yaw, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        double cYaw = EuclidCoreTools.cos(yaw);
        double sYaw = EuclidCoreTools.sin(yaw);
        double x = tupleOriginal.getX() * cYaw - tupleOriginal.getY() * sYaw;
        double y = tupleOriginal.getX() * sYaw + tupleOriginal.getY() * cYaw;
        tupleTransformed.set(x, y);
    }

    public static void applyPitchRotation(double pitch, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double cPitch = EuclidCoreTools.cos(pitch);
        double sPitch = EuclidCoreTools.sin(pitch);
        double x = tupleOriginal.getX() * cPitch + tupleOriginal.getZ() * sPitch;
        double y = tupleOriginal.getY();
        double z = -tupleOriginal.getX() * sPitch + tupleOriginal.getZ() * cPitch;
        tupleTransformed.set(x, y, z);
    }

    public static void applyRollRotation(double roll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double cRoll = EuclidCoreTools.cos(roll);
        double sRoll = EuclidCoreTools.sin(roll);
        double x = tupleOriginal.getX();
        double y = tupleOriginal.getY() * cRoll - tupleOriginal.getZ() * sRoll;
        double z = tupleOriginal.getY() * sRoll + tupleOriginal.getZ() * cRoll;
        tupleTransformed.set(x, y, z);
    }

    public static void interpolate(RotationMatrixReadOnly r0, RotationMatrixReadOnly rf, double alpha, RotationMatrixBasics matrixToPack) {
        double yz;
        double angle;
        if (r0.isZeroOrientation() && rf.isZeroOrientation()) {
            matrixToPack.setIdentity();
            return;
        }
        if (r0.containsNaN() || rf.containsNaN()) {
            matrixToPack.setToNaN();
            return;
        }
        if (r0.epsilonEquals(rf, 1.0E-12)) {
            matrixToPack.set(r0);
            return;
        }
        double m00 = r0.getM00() * rf.getM00() + r0.getM10() * rf.getM10() + r0.getM20() * rf.getM20();
        double m01 = r0.getM00() * rf.getM01() + r0.getM10() * rf.getM11() + r0.getM20() * rf.getM21();
        double m02 = r0.getM00() * rf.getM02() + r0.getM10() * rf.getM12() + r0.getM20() * rf.getM22();
        double m10 = r0.getM01() * rf.getM00() + r0.getM11() * rf.getM10() + r0.getM21() * rf.getM20();
        double m11 = r0.getM01() * rf.getM01() + r0.getM11() * rf.getM11() + r0.getM21() * rf.getM21();
        double m12 = r0.getM01() * rf.getM02() + r0.getM11() * rf.getM12() + r0.getM21() * rf.getM22();
        double m20 = r0.getM02() * rf.getM00() + r0.getM12() * rf.getM10() + r0.getM22() * rf.getM20();
        double m21 = r0.getM02() * rf.getM01() + r0.getM12() * rf.getM11() + r0.getM22() * rf.getM21();
        double m22 = r0.getM02() * rf.getM02() + r0.getM12() * rf.getM12() + r0.getM22() * rf.getM22();
        double x = m21 - m12;
        double y = m02 - m20;
        double z = m10 - m01;
        double s = EuclidCoreTools.norm(x, y, z);
        if (s > 1.0E-12) {
            double sin = 0.5 * s;
            double cos = 0.5 * (m00 + m11 + m22 - 1.0);
            angle = EuclidCoreTools.atan2(sin, cos);
            x /= s;
            y /= s;
            z /= s;
        } else {
            angle = Math.PI;
            double xx = 0.5 * (m00 + 1.0);
            double yy = 0.5 * (m11 + 1.0);
            double zz = 0.5 * (m22 + 1.0);
            double xy = 0.25 * (m01 + m10);
            double xz = 0.25 * (m02 + m20);
            yz = 0.25 * (m12 + m21);
            if (xx > yy && xx > zz) {
                x = EuclidCoreTools.squareRoot(xx);
                y = xy / x;
                z = xz / x;
            } else if (yy > zz) {
                y = EuclidCoreTools.squareRoot(yy);
                x = xy / y;
                z = yz / y;
            } else {
                z = EuclidCoreTools.squareRoot(zz);
                x = xz / z;
                y = yz / z;
            }
        }
        double sinTheta = EuclidCoreTools.sin(angle *= alpha);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double xz = x * z;
        double xy = x * y;
        yz = y * z;
        m00 = t * x * x + cosTheta;
        m01 = t * xy - sinTheta * z;
        m02 = t * xz + sinTheta * y;
        m10 = t * xy + sinTheta * z;
        m11 = t * y * y + cosTheta;
        m12 = t * yz - sinTheta * x;
        m20 = t * xz - sinTheta * y;
        m21 = t * yz + sinTheta * x;
        m22 = t * z * z + cosTheta;
        double r00 = r0.getM00() * m00 + r0.getM01() * m10 + r0.getM02() * m20;
        double r01 = r0.getM00() * m01 + r0.getM01() * m11 + r0.getM02() * m21;
        double r02 = r0.getM00() * m02 + r0.getM01() * m12 + r0.getM02() * m22;
        double r10 = r0.getM10() * m00 + r0.getM11() * m10 + r0.getM12() * m20;
        double r11 = r0.getM10() * m01 + r0.getM11() * m11 + r0.getM12() * m21;
        double r12 = r0.getM10() * m02 + r0.getM11() * m12 + r0.getM12() * m22;
        double r20 = r0.getM20() * m00 + r0.getM21() * m10 + r0.getM22() * m20;
        double r21 = r0.getM20() * m01 + r0.getM21() * m11 + r0.getM22() * m21;
        double r22 = r0.getM20() * m02 + r0.getM21() * m12 + r0.getM22() * m22;
        matrixToPack.set(r00, r01, r02, r10, r11, r12, r20, r21, r22);
    }

    public static double distance(RotationMatrixReadOnly rotationMatrix, Orientation3DReadOnly orientation3D) {
        if (orientation3D instanceof QuaternionReadOnly) {
            return RotationMatrixTools.distance(rotationMatrix, (QuaternionReadOnly)orientation3D);
        }
        if (orientation3D instanceof YawPitchRollReadOnly) {
            return RotationMatrixTools.distance(rotationMatrix, (YawPitchRollReadOnly)orientation3D);
        }
        if (orientation3D instanceof AxisAngleReadOnly) {
            return RotationMatrixTools.distance(rotationMatrix, (AxisAngleReadOnly)orientation3D);
        }
        if (orientation3D instanceof RotationMatrixReadOnly) {
            return RotationMatrixTools.distance(rotationMatrix, (RotationMatrixReadOnly)orientation3D);
        }
        throw new UnsupportedOperationException("Unsupported type: " + orientation3D.getClass().getSimpleName());
    }

    public static double distance(RotationMatrixReadOnly rotationMatrix, QuaternionReadOnly quaternion) {
        return QuaternionTools.distance(quaternion, rotationMatrix);
    }

    public static double distance(RotationMatrixReadOnly rotationMatrix, AxisAngleReadOnly axisAngle) {
        return AxisAngleTools.distance(axisAngle, rotationMatrix);
    }

    public static double distance(RotationMatrixReadOnly rotationMatrix, YawPitchRollReadOnly yawPitchRoll) {
        if (rotationMatrix.containsNaN() || yawPitchRoll.containsNaN()) {
            return Double.NaN;
        }
        if (rotationMatrix.isZeroOrientation(1.0E-12)) {
            return YawPitchRollTools.angle(yawPitchRoll);
        }
        if (yawPitchRoll.isZeroOrientation(1.0E-12)) {
            return RotationMatrixTools.angle(rotationMatrix);
        }
        double yaw = yawPitchRoll.getYaw();
        double pitch = yawPitchRoll.getPitch();
        double roll = yawPitchRoll.getRoll();
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        double m00 = cosc * cosb;
        double m01 = cosc * sinb * sina - sinc * cosa;
        double m02 = cosc * sinb * cosa + sinc * sina;
        double m10 = sinc * cosb;
        double m11 = sinc * sinb * sina + cosc * cosa;
        double m12 = sinc * sinb * cosa - cosc * sina;
        double m20 = -sinb;
        double m21 = cosb * sina;
        double m22 = cosb * cosa;
        return RotationMatrixTools.distance(rotationMatrix, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static double distance(RotationMatrixReadOnly a, RotationMatrixReadOnly b) {
        double b00 = b.getM00();
        double b01 = b.getM01();
        double b02 = b.getM02();
        double b10 = b.getM10();
        double b11 = b.getM11();
        double b12 = b.getM12();
        double b20 = b.getM20();
        double b21 = b.getM21();
        double b22 = b.getM22();
        return RotationMatrixTools.distance(a, b00, b01, b02, b10, b11, b12, b20, b21, b22);
    }

    static double distance(RotationMatrixReadOnly a, double b00, double b01, double b02, double b10, double b11, double b12, double b20, double b21, double b22) {
        double m00 = a.getM00() * b00 + a.getM01() * b01 + a.getM02() * b02;
        double m01 = a.getM00() * b10 + a.getM01() * b11 + a.getM02() * b12;
        double m02 = a.getM00() * b20 + a.getM01() * b21 + a.getM02() * b22;
        double m10 = a.getM10() * b00 + a.getM11() * b01 + a.getM12() * b02;
        double m11 = a.getM10() * b10 + a.getM11() * b11 + a.getM12() * b12;
        double m12 = a.getM10() * b20 + a.getM11() * b21 + a.getM12() * b22;
        double m20 = a.getM20() * b00 + a.getM21() * b01 + a.getM22() * b02;
        double m21 = a.getM20() * b10 + a.getM21() * b11 + a.getM22() * b12;
        double m22 = a.getM20() * b20 + a.getM21() * b21 + a.getM22() * b22;
        return RotationMatrixTools.angle(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static double angle(RotationMatrixReadOnly m) {
        double m00 = m.getM00();
        double m01 = m.getM01();
        double m02 = m.getM02();
        double m10 = m.getM10();
        double m11 = m.getM11();
        double m12 = m.getM12();
        double m20 = m.getM20();
        double m21 = m.getM21();
        double m22 = m.getM22();
        return RotationMatrixTools.angle(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static double angle(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double angle;
        double x = m21 - m12;
        double y = m02 - m20;
        double z = m10 - m01;
        double s = EuclidCoreTools.fastNorm(x, y, z);
        if (s > 1.0E-12) {
            double sin = 0.5 * s;
            double cos = 0.5 * (m00 + m11 + m22 - 1.0);
            angle = EuclidCoreTools.atan2(sin, cos);
        } else {
            if (m00 + m11 + m22 > 2.9999999) {
                return 0.0;
            }
            angle = Math.PI;
        }
        return angle;
    }
}

