/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationVectorConversion {
    public static final double EPS = 1.0E-12;

    private RotationVectorConversion() {
    }

    public static void convertAxisAngleToRotationVector(AxisAngleReadOnly axisAngle, Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl(axisAngle.getX(), axisAngle.getY(), axisAngle.getZ(), axisAngle.getAngle(), rotationVectorToPack);
    }

    public static void convertAxisAngleToRotationVectorImpl(double ux, double uy, double uz, double angle, Vector3DBasics rotationVectorToPack) {
        if (EuclidCoreTools.containsNaN(ux, uy, uz, angle)) {
            rotationVectorToPack.setToNaN();
            return;
        }
        double uNorm = EuclidCoreTools.fastNorm(ux, uy, uz);
        if (uNorm > 1.0E-12) {
            uNorm = 1.0 / uNorm;
            rotationVectorToPack.set(ux * uNorm * angle, uy * uNorm * angle, uz * uNorm * angle);
        } else {
            rotationVectorToPack.setToZero();
        }
    }

    public static void convertQuaternionToRotationVector(QuaternionReadOnly quaternion, Vector3DBasics rotationVectorToPack) {
        if (quaternion.containsNaN()) {
            rotationVectorToPack.setToNaN();
            return;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double uNorm = EuclidCoreTools.norm(qx, qy, qz);
        if (uNorm > 1.0E-12) {
            double angle = 2.0 * EuclidCoreTools.atan2(uNorm, qs) / uNorm;
            rotationVectorToPack.set(qx * angle, qy * angle, qz * angle);
        } else {
            double sign = Math.signum(qs);
            rotationVectorToPack.set(sign * qx, sign * qy, sign * qz);
        }
    }

    public static void convertMatrixToRotationVector(RotationMatrixReadOnly rotationMatrix, Vector3DBasics rotationVectorToPack) {
        double m00 = rotationMatrix.getM00();
        double m01 = rotationMatrix.getM01();
        double m02 = rotationMatrix.getM02();
        double m10 = rotationMatrix.getM10();
        double m11 = rotationMatrix.getM11();
        double m12 = rotationMatrix.getM12();
        double m20 = rotationMatrix.getM20();
        double m21 = rotationMatrix.getM21();
        double m22 = rotationMatrix.getM22();
        RotationVectorConversion.convertMatrixToRotationVectorImpl(m00, m01, m02, m10, m11, m12, m20, m21, m22, rotationVectorToPack);
    }

    static void convertMatrixToRotationVectorImpl(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Vector3DBasics rotationVectorToPack) {
        double angle;
        if (EuclidCoreTools.containsNaN(m00, m01, m02, m10, m11, m12, m20, m21, m22)) {
            rotationVectorToPack.setToNaN();
            return;
        }
        double x = m21 - m12;
        double y = m02 - m20;
        double z = m10 - m01;
        double s = EuclidCoreTools.norm(x, y, z);
        if (s > 1.0E-12) {
            double sin = 0.5 * s;
            double cos = 0.5 * (m00 + m11 + m22 - 1.0);
            angle = EuclidCoreTools.atan2(sin, cos);
            x /= s;
            y /= s;
            z /= s;
        } else {
            if (Matrix3DFeatures.isIdentity(m00, m01, m02, m10, m11, m12, m20, m21, m22)) {
                rotationVectorToPack.setToZero();
                return;
            }
            angle = Math.PI;
            double xx = 0.5 * (m00 + 1.0);
            double yy = 0.5 * (m11 + 1.0);
            double zz = 0.5 * (m22 + 1.0);
            double xy = 0.25 * (m01 + m10);
            double xz = 0.25 * (m02 + m20);
            double yz = 0.25 * (m12 + m21);
            if (xx > yy && xx > zz) {
                x = EuclidCoreTools.squareRoot(xx);
                y = xy / x;
                z = xz / x;
            } else if (yy > zz) {
                y = EuclidCoreTools.squareRoot(yy);
                x = xy / y;
                z = yz / y;
            } else {
                z = EuclidCoreTools.squareRoot(zz);
                x = xz / z;
                y = yz / z;
            }
        }
        rotationVectorToPack.set(x * angle, y * angle, z * angle);
    }

    public static void convertYawPitchRollToRotationVector(YawPitchRollReadOnly yawPitchRoll, Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertYawPitchRollToRotationVector(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), rotationVectorToPack);
    }

    public static void convertYawPitchRollToRotationVector(double yaw, double pitch, double roll, Vector3DBasics rotationVectorToPack) {
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            rotationVectorToPack.setToNaN();
            return;
        }
        double halfYaw = yaw / 2.0;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = pitch / 2.0;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = roll / 2.0;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        double uNorm = EuclidCoreTools.norm(qx, qy, qz);
        if (uNorm > 1.0E-12) {
            double angle = 2.0 * EuclidCoreTools.atan2(uNorm, qs) / uNorm;
            rotationVectorToPack.set(qx * angle, qy * angle, qz * angle);
        } else {
            rotationVectorToPack.setToZero();
        }
    }
}

