/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class YawPitchRollTools {
    public static final double ZERO_EPS = 1.0E-12;

    private YawPitchRollTools() {
    }

    public static boolean isZero(double yaw, double pitch, double roll, double epsilon) {
        return EuclidCoreTools.isAngleZero(yaw, epsilon) && EuclidCoreTools.isAngleZero(pitch, epsilon) && EuclidCoreTools.isAngleZero(roll, epsilon);
    }

    public static boolean isOrientation2D(double yaw, double pitch, double roll, double epsilon) {
        return Math.abs(pitch) <= epsilon && Math.abs(roll) <= epsilon;
    }

    public static double angle(YawPitchRollReadOnly yawPitchRoll, boolean limitToPi) {
        return YawPitchRollTools.angle(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), limitToPi);
    }

    public static double angle(double yaw, double pitch, double roll, boolean limitToPi) {
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            return Double.NaN;
        }
        double halfYaw = 0.5 * yaw;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * pitch;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * roll;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        return QuaternionTools.angle(qx, qy, qz, qs, limitToPi);
    }

    public static double angle(YawPitchRollReadOnly yawPitchRoll) {
        return YawPitchRollTools.angle(yawPitchRoll, false);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll, Orientation3DReadOnly orientation3D, boolean limitToPi) {
        if (orientation3D instanceof QuaternionReadOnly) {
            return YawPitchRollTools.distance(yawPitchRoll, (QuaternionReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof YawPitchRollReadOnly) {
            return YawPitchRollTools.distance(yawPitchRoll, (YawPitchRollReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof AxisAngleReadOnly) {
            return YawPitchRollTools.distance(yawPitchRoll, (AxisAngleReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof RotationMatrixReadOnly) {
            return YawPitchRollTools.distance(yawPitchRoll, (RotationMatrixReadOnly)orientation3D);
        }
        throw new UnsupportedOperationException("Unsupported type: " + orientation3D.getClass().getSimpleName());
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll, QuaternionReadOnly quaternion, boolean limitToPi) {
        return QuaternionTools.distance(quaternion, yawPitchRoll, limitToPi);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll, RotationMatrixReadOnly rotationMatrix) {
        return RotationMatrixTools.distance(rotationMatrix, yawPitchRoll);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll, AxisAngleReadOnly axisAngle, boolean limitToPi) {
        return AxisAngleTools.distance(axisAngle, yawPitchRoll, limitToPi);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll, AxisAngleReadOnly axisAngle) {
        return YawPitchRollTools.distance(yawPitchRoll, axisAngle, false);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll1, YawPitchRollReadOnly yawPitchRoll2, boolean limitToPi) {
        return YawPitchRollTools.distance(yawPitchRoll1.getYaw(), yawPitchRoll1.getPitch(), yawPitchRoll1.getRoll(), yawPitchRoll2.getYaw(), yawPitchRoll2.getPitch(), yawPitchRoll2.getRoll(), limitToPi);
    }

    public static double distance(YawPitchRollReadOnly yawPitchRoll1, YawPitchRollReadOnly yawPitchRoll2) {
        return YawPitchRollTools.distance(yawPitchRoll1, yawPitchRoll2, false);
    }

    public static double distance(double yaw1, double pitch1, double roll1, double yaw2, double pitch2, double roll2, boolean limitToPi) {
        if (EuclidCoreTools.containsNaN(yaw1, pitch1, roll1)) {
            return Double.NaN;
        }
        if (EuclidCoreTools.containsNaN(yaw2, pitch2, roll2)) {
            return Double.NaN;
        }
        if (EuclidCoreTools.areAllZero(yaw1, pitch1, roll1, 1.0E-12)) {
            return YawPitchRollTools.angle(yaw1, pitch1, roll1, limitToPi);
        }
        if (EuclidCoreTools.areAllZero(yaw2, pitch2, roll2, 1.0E-12)) {
            return YawPitchRollTools.angle(yaw2, pitch2, roll2, limitToPi);
        }
        double halfYaw = 0.5 * yaw1;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * pitch1;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * roll1;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double q1s = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double q1x = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double q1y = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double q1z = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        double halfYaw2 = 0.5 * yaw2;
        double cYaw2 = EuclidCoreTools.cos(halfYaw2);
        double sYaw2 = EuclidCoreTools.sin(halfYaw2);
        double halfPitch2 = 0.5 * pitch2;
        double cPitch2 = EuclidCoreTools.cos(halfPitch2);
        double sPitch2 = EuclidCoreTools.sin(halfPitch2);
        double halfRoll2 = 0.5 * roll2;
        double cRoll2 = EuclidCoreTools.cos(halfRoll2);
        double sRoll2 = EuclidCoreTools.sin(halfRoll2);
        double q2s = cYaw2 * cPitch2 * cRoll2 + sYaw2 * sPitch2 * sRoll2;
        double q2x = cYaw2 * cPitch2 * sRoll2 - sYaw2 * sPitch2 * cRoll2;
        double q2y = sYaw2 * cPitch2 * sRoll2 + cYaw2 * sPitch2 * cRoll2;
        double q2z = sYaw2 * cPitch2 * cRoll2 - cYaw2 * sPitch2 * sRoll2;
        double x = q1s * q2x - q1x * q2s - q1y * q2z + q1z * q2y;
        double y = q1s * q2y + q1x * q2z - q1y * q2s - q1z * q2x;
        double z = q1s * q2z - q1x * q2y + q1y * q2x - q1z * q2s;
        double s = q1s * q2s + q1x * q2x + q1y * q2y + q1z * q2z;
        return QuaternionTools.angle(x, y, z, s, limitToPi);
    }

    public static double distance(double yaw1, double pitch1, double roll1, double yaw2, double pitch2, double roll2) {
        return YawPitchRollTools.distance(yaw1, pitch1, roll1, yaw2, pitch2, roll2, false);
    }

    public static void invert(double yaw, double pitch, double roll, Orientation3DBasics orientationToPack) {
        double halfYaw = 0.5 * yaw;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * pitch;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * roll;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        orientationToPack.setQuaternion(-qx, -qy, -qz, qs);
    }

    public static void transform(double yaw, double pitch, double roll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, false, tupleOriginal, tupleTransformed);
    }

    public static void transform(YawPitchRollReadOnly yawPitchRoll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.transform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), tupleOriginal, tupleTransformed);
    }

    public static void inverseTransform(double yaw, double pitch, double roll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, true, tupleOriginal, tupleTransformed);
    }

    public static void inverseTransform(YawPitchRollReadOnly yawPitchRoll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.inverseTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), tupleOriginal, tupleTransformed);
    }

    private static void transformImpl(double yaw, double pitch, double roll, boolean inverseTransform, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            tupleTransformed.set(tupleOriginal);
            return;
        }
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            tupleTransformed.setToNaN();
            return;
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        double m00 = cosc * cosb;
        double m01 = cosc * sinb * sina - sinc * cosa;
        double m02 = cosc * sinb * cosa + sinc * sina;
        double m10 = sinc * cosb;
        double m11 = sinc * sinb * sina + cosc * cosa;
        double m12 = sinc * sinb * cosa - cosc * sina;
        double m20 = -sinb;
        double m21 = cosb * sina;
        double m22 = cosb * cosa;
        if (inverseTransform) {
            double x = m00 * tupleOriginal.getX() + m10 * tupleOriginal.getY() + m20 * tupleOriginal.getZ();
            double y = m01 * tupleOriginal.getX() + m11 * tupleOriginal.getY() + m21 * tupleOriginal.getZ();
            double z = m02 * tupleOriginal.getX() + m12 * tupleOriginal.getY() + m22 * tupleOriginal.getZ();
            tupleTransformed.set(x, y, z);
        } else {
            double x = m00 * tupleOriginal.getX() + m01 * tupleOriginal.getY() + m02 * tupleOriginal.getZ();
            double y = m10 * tupleOriginal.getX() + m11 * tupleOriginal.getY() + m12 * tupleOriginal.getZ();
            double z = m20 * tupleOriginal.getX() + m21 * tupleOriginal.getY() + m22 * tupleOriginal.getZ();
            tupleTransformed.set(x, y, z);
        }
    }

    public static void addTransform(double yaw, double pitch, double roll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = tupleTransformed.getX();
        double y = tupleTransformed.getY();
        double z = tupleTransformed.getZ();
        YawPitchRollTools.transform(yaw, pitch, roll, tupleOriginal, tupleTransformed);
        tupleTransformed.add(x, y, z);
    }

    public static void addTransform(YawPitchRollReadOnly yawPitchRoll, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.addTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), tupleOriginal, tupleTransformed);
    }

    public static void transform(double yaw, double pitch, double roll, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, false, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    public static void transform(YawPitchRollReadOnly yawPitchRoll, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        YawPitchRollTools.transform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    public static void inverseTransform(double yaw, double pitch, double roll, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, true, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    public static void inverseTransform(YawPitchRollReadOnly yawPitchRoll, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        YawPitchRollTools.inverseTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    private static void transformImpl(double yaw, double pitch, double roll, boolean inverseTransform, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            tupleTransformed.set(tupleOriginal);
            return;
        }
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            tupleTransformed.setToNaN();
            return;
        }
        if (checkIfTransformInXYPlane && !YawPitchRollTools.isOrientation2D(yaw, pitch, roll, 1.0E-12)) {
            throw new NotAnOrientation2DException("The orientation is not in XY plane: \n" + EuclidCoreIOTools.getYawPitchRollString(yaw, pitch, roll));
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        double m00 = cosc * cosb;
        double m01 = cosc * sinb * sina - sinc * cosa;
        double m10 = sinc * cosb;
        double m11 = sinc * sinb * sina + cosc * cosa;
        if (inverseTransform) {
            double x = m00 * tupleOriginal.getX() + m10 * tupleOriginal.getY();
            double y = m01 * tupleOriginal.getX() + m11 * tupleOriginal.getY();
            tupleTransformed.set(x, y);
        } else {
            double x = m00 * tupleOriginal.getX() + m01 * tupleOriginal.getY();
            double y = m10 * tupleOriginal.getX() + m11 * tupleOriginal.getY();
            tupleTransformed.set(x, y);
        }
    }

    public static void transform(double yaw, double pitch, double roll, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, false, matrixOriginal, matrixTransformed);
    }

    public static void transform(YawPitchRollReadOnly yawPitchRoll, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.transform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), matrixOriginal, matrixTransformed);
    }

    public static void inverseTransform(double yaw, double pitch, double roll, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, true, matrixOriginal, matrixTransformed);
    }

    public static void inverseTransform(YawPitchRollReadOnly yawPitchRoll, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.inverseTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), matrixOriginal, matrixTransformed);
    }

    private static void transformImpl(double yaw, double pitch, double roll, boolean inverseTransform, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        double ypr22;
        double ypr12;
        double ypr02;
        double ypr21;
        double ypr11;
        double ypr01;
        double ypr20;
        double ypr10;
        double ypr00;
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            matrixTransformed.set(matrixOriginal);
            return;
        }
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            matrixTransformed.setToNaN();
            return;
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        if (inverseTransform) {
            ypr00 = cosc * cosb;
            ypr10 = cosc * sinb * sina - sinc * cosa;
            ypr20 = cosc * sinb * cosa + sinc * sina;
            ypr01 = sinc * cosb;
            ypr11 = sinc * sinb * sina + cosc * cosa;
            ypr21 = sinc * sinb * cosa - cosc * sina;
            ypr02 = -sinb;
            ypr12 = cosb * sina;
            ypr22 = cosb * cosa;
        } else {
            ypr00 = cosc * cosb;
            ypr01 = cosc * sinb * sina - sinc * cosa;
            ypr02 = cosc * sinb * cosa + sinc * sina;
            ypr10 = sinc * cosb;
            ypr11 = sinc * sinb * sina + cosc * cosa;
            ypr12 = sinc * sinb * cosa - cosc * sina;
            ypr20 = -sinb;
            ypr21 = cosb * sina;
            ypr22 = cosb * cosa;
        }
        double yprM00 = ypr00 * matrixOriginal.getM00() + ypr01 * matrixOriginal.getM10() + ypr02 * matrixOriginal.getM20();
        double yprM01 = ypr00 * matrixOriginal.getM01() + ypr01 * matrixOriginal.getM11() + ypr02 * matrixOriginal.getM21();
        double yprM02 = ypr00 * matrixOriginal.getM02() + ypr01 * matrixOriginal.getM12() + ypr02 * matrixOriginal.getM22();
        double yprM10 = ypr10 * matrixOriginal.getM00() + ypr11 * matrixOriginal.getM10() + ypr12 * matrixOriginal.getM20();
        double yprM11 = ypr10 * matrixOriginal.getM01() + ypr11 * matrixOriginal.getM11() + ypr12 * matrixOriginal.getM21();
        double yprM12 = ypr10 * matrixOriginal.getM02() + ypr11 * matrixOriginal.getM12() + ypr12 * matrixOriginal.getM22();
        double yprM20 = ypr20 * matrixOriginal.getM00() + ypr21 * matrixOriginal.getM10() + ypr22 * matrixOriginal.getM20();
        double yprM21 = ypr20 * matrixOriginal.getM01() + ypr21 * matrixOriginal.getM11() + ypr22 * matrixOriginal.getM21();
        double yprM22 = ypr20 * matrixOriginal.getM02() + ypr21 * matrixOriginal.getM12() + ypr22 * matrixOriginal.getM22();
        double yprMrpy00 = yprM00 * ypr00 + yprM01 * ypr01 + yprM02 * ypr02;
        double yprMrpy01 = yprM00 * ypr10 + yprM01 * ypr11 + yprM02 * ypr12;
        double yprMrpy02 = yprM00 * ypr20 + yprM01 * ypr21 + yprM02 * ypr22;
        double yprMrpy10 = yprM10 * ypr00 + yprM11 * ypr01 + yprM12 * ypr02;
        double yprMrpy11 = yprM10 * ypr10 + yprM11 * ypr11 + yprM12 * ypr12;
        double yprMrpy12 = yprM10 * ypr20 + yprM11 * ypr21 + yprM12 * ypr22;
        double yprMrpy20 = yprM20 * ypr00 + yprM21 * ypr01 + yprM22 * ypr02;
        double yprMrpy21 = yprM20 * ypr10 + yprM21 * ypr11 + yprM22 * ypr12;
        double yprMrpy22 = yprM20 * ypr20 + yprM21 * ypr21 + yprM22 * ypr22;
        matrixTransformed.set(yprMrpy00, yprMrpy01, yprMrpy02, yprMrpy10, yprMrpy11, yprMrpy12, yprMrpy20, yprMrpy21, yprMrpy22);
    }

    public static void transform(double yaw, double pitch, double roll, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, false, rotationMatrixOriginal, rotationMatrixTransformed);
    }

    public static void transform(YawPitchRollReadOnly yawPitchRoll, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        YawPitchRollTools.transform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), rotationMatrixOriginal, rotationMatrixTransformed);
    }

    public static void inverseTransform(double yaw, double pitch, double roll, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, true, rotationMatrixOriginal, rotationMatrixTransformed);
    }

    public static void inverseTransform(YawPitchRollReadOnly yawPitchRoll, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        YawPitchRollTools.inverseTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), rotationMatrixOriginal, rotationMatrixTransformed);
    }

    private static void transformImpl(double yaw, double pitch, double roll, boolean inverseTransform, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        double ypr22;
        double ypr12;
        double ypr02;
        double ypr21;
        double ypr11;
        double ypr01;
        double ypr20;
        double ypr10;
        double ypr00;
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            rotationMatrixTransformed.set(rotationMatrixOriginal);
            return;
        }
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            rotationMatrixTransformed.setToNaN();
            return;
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        if (inverseTransform) {
            ypr00 = cosc * cosb;
            ypr10 = cosc * sinb * sina - sinc * cosa;
            ypr20 = cosc * sinb * cosa + sinc * sina;
            ypr01 = sinc * cosb;
            ypr11 = sinc * sinb * sina + cosc * cosa;
            ypr21 = sinc * sinb * cosa - cosc * sina;
            ypr02 = -sinb;
            ypr12 = cosb * sina;
            ypr22 = cosb * cosa;
        } else {
            ypr00 = cosc * cosb;
            ypr01 = cosc * sinb * sina - sinc * cosa;
            ypr02 = cosc * sinb * cosa + sinc * sina;
            ypr10 = sinc * cosb;
            ypr11 = sinc * sinb * sina + cosc * cosa;
            ypr12 = sinc * sinb * cosa - cosc * sina;
            ypr20 = -sinb;
            ypr21 = cosb * sina;
            ypr22 = cosb * cosa;
        }
        double yprM00 = ypr00 * rotationMatrixOriginal.getM00() + ypr01 * rotationMatrixOriginal.getM10() + ypr02 * rotationMatrixOriginal.getM20();
        double yprM01 = ypr00 * rotationMatrixOriginal.getM01() + ypr01 * rotationMatrixOriginal.getM11() + ypr02 * rotationMatrixOriginal.getM21();
        double yprM02 = ypr00 * rotationMatrixOriginal.getM02() + ypr01 * rotationMatrixOriginal.getM12() + ypr02 * rotationMatrixOriginal.getM22();
        double yprM10 = ypr10 * rotationMatrixOriginal.getM00() + ypr11 * rotationMatrixOriginal.getM10() + ypr12 * rotationMatrixOriginal.getM20();
        double yprM11 = ypr10 * rotationMatrixOriginal.getM01() + ypr11 * rotationMatrixOriginal.getM11() + ypr12 * rotationMatrixOriginal.getM21();
        double yprM12 = ypr10 * rotationMatrixOriginal.getM02() + ypr11 * rotationMatrixOriginal.getM12() + ypr12 * rotationMatrixOriginal.getM22();
        double yprM20 = ypr20 * rotationMatrixOriginal.getM00() + ypr21 * rotationMatrixOriginal.getM10() + ypr22 * rotationMatrixOriginal.getM20();
        double yprM21 = ypr20 * rotationMatrixOriginal.getM01() + ypr21 * rotationMatrixOriginal.getM11() + ypr22 * rotationMatrixOriginal.getM21();
        double yprM22 = ypr20 * rotationMatrixOriginal.getM02() + ypr21 * rotationMatrixOriginal.getM12() + ypr22 * rotationMatrixOriginal.getM22();
        rotationMatrixTransformed.set(yprM00, yprM01, yprM02, yprM10, yprM11, yprM12, yprM20, yprM21, yprM22);
    }

    public static void transform(double yaw, double pitch, double roll, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, false, vectorOriginal, vectorTransformed);
    }

    public static void transform(YawPitchRollReadOnly yawPitchRoll, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.transform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), vectorOriginal, vectorTransformed);
    }

    public static void inverseTransform(double yaw, double pitch, double roll, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.transformImpl(yaw, pitch, roll, true, vectorOriginal, vectorTransformed);
    }

    public static void inverseTransform(YawPitchRollReadOnly yawPitchRoll, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.inverseTransform(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), vectorOriginal, vectorTransformed);
    }

    private static void transformImpl(double yaw, double pitch, double roll, boolean inverseTransform, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            vectorTransformed.set(vectorOriginal);
            return;
        }
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            vectorTransformed.setToNaN();
            return;
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        double m00 = cosc * cosb;
        double m01 = cosc * sinb * sina - sinc * cosa;
        double m02 = cosc * sinb * cosa + sinc * sina;
        double m10 = sinc * cosb;
        double m11 = sinc * sinb * sina + cosc * cosa;
        double m12 = sinc * sinb * cosa - cosc * sina;
        double m20 = -sinb;
        double m21 = cosb * sina;
        double m22 = cosb * cosa;
        if (inverseTransform) {
            double x = m00 * vectorOriginal.getX() + m10 * vectorOriginal.getY() + m20 * vectorOriginal.getZ();
            double y = m01 * vectorOriginal.getX() + m11 * vectorOriginal.getY() + m21 * vectorOriginal.getZ();
            double z = m02 * vectorOriginal.getX() + m12 * vectorOriginal.getY() + m22 * vectorOriginal.getZ();
            vectorTransformed.set(x, y, z, vectorOriginal.getS());
        } else {
            double x = m00 * vectorOriginal.getX() + m01 * vectorOriginal.getY() + m02 * vectorOriginal.getZ();
            double y = m10 * vectorOriginal.getX() + m11 * vectorOriginal.getY() + m12 * vectorOriginal.getZ();
            double z = m20 * vectorOriginal.getX() + m21 * vectorOriginal.getY() + m22 * vectorOriginal.getZ();
            vectorTransformed.set(x, y, z, vectorOriginal.getS());
        }
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, YawPitchRollBasics yawPitchRollToPack) {
        double q2z;
        double q2y;
        double q2x;
        double q2s;
        double q1z;
        double q1y;
        double q1x;
        double q1s;
        if (orientation1 instanceof QuaternionReadOnly) {
            QuaternionReadOnly quaternion1 = (QuaternionReadOnly)orientation1;
            q1s = quaternion1.getS();
            q1x = quaternion1.getX();
            q1y = quaternion1.getY();
            q1z = quaternion1.getZ();
        } else if (orientation1 instanceof AxisAngleReadOnly) {
            AxisAngleReadOnly axisAngle1 = (AxisAngleReadOnly)orientation1;
            double halfTheta = 0.5 * axisAngle1.getAngle();
            double sinHalfTheta = EuclidCoreTools.sin(halfTheta) / axisAngle1.axisNorm();
            q1x = axisAngle1.getX() * sinHalfTheta;
            q1y = axisAngle1.getY() * sinHalfTheta;
            q1z = axisAngle1.getZ() * sinHalfTheta;
            q1s = EuclidCoreTools.cos(halfTheta);
        } else {
            double halfYaw = 0.5 * orientation1.getYaw();
            double cYaw = EuclidCoreTools.cos(halfYaw);
            double sYaw = EuclidCoreTools.sin(halfYaw);
            double halfPitch = 0.5 * orientation1.getPitch();
            double cPitch = EuclidCoreTools.cos(halfPitch);
            double sPitch = EuclidCoreTools.sin(halfPitch);
            double halfRoll = 0.5 * orientation1.getRoll();
            double cRoll = EuclidCoreTools.cos(halfRoll);
            double sRoll = EuclidCoreTools.sin(halfRoll);
            q1s = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
            q1x = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
            q1y = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
            q1z = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        }
        if (orientation2 instanceof QuaternionReadOnly) {
            QuaternionReadOnly quaternion2 = (QuaternionReadOnly)orientation2;
            q2s = quaternion2.getS();
            q2x = quaternion2.getX();
            q2y = quaternion2.getY();
            q2z = quaternion2.getZ();
        } else if (orientation2 instanceof AxisAngleReadOnly) {
            AxisAngleReadOnly axisAngle2 = (AxisAngleReadOnly)orientation2;
            double halfTheta = 0.5 * axisAngle2.getAngle();
            double sinHalfTheta = EuclidCoreTools.sin(halfTheta) / axisAngle2.axisNorm();
            q2x = axisAngle2.getX() * sinHalfTheta;
            q2y = axisAngle2.getY() * sinHalfTheta;
            q2z = axisAngle2.getZ() * sinHalfTheta;
            q2s = EuclidCoreTools.cos(halfTheta);
        } else {
            double halfYaw = 0.5 * orientation2.getYaw();
            double cYaw = EuclidCoreTools.cos(halfYaw);
            double sYaw = EuclidCoreTools.sin(halfYaw);
            double halfPitch = 0.5 * orientation2.getPitch();
            double cPitch = EuclidCoreTools.cos(halfPitch);
            double sPitch = EuclidCoreTools.sin(halfPitch);
            double halfRoll = 0.5 * orientation2.getRoll();
            double cRoll = EuclidCoreTools.cos(halfRoll);
            double sRoll = EuclidCoreTools.sin(halfRoll);
            q2s = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
            q2x = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
            q2y = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
            q2z = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        }
        QuaternionTools.multiplyImpl(q1x, q1y, q1z, q1s, inverse1, q2x, q2y, q2z, q2s, inverse2, yawPitchRollToPack);
    }

    public static void prependYawRotation(YawPitchRollReadOnly yawPitchRollOriginal, double yaw, YawPitchRollBasics yawPitchRollToPack) {
        yaw = EuclidCoreTools.trimAngleMinusPiToPi(yawPitchRollOriginal.getYaw() + yaw);
        double pitch = yawPitchRollOriginal.getPitch();
        double roll = yawPitchRollOriginal.getRoll();
        yawPitchRollToPack.set(yaw, pitch, roll);
    }

    public static void appendYawRotation(YawPitchRollReadOnly yawPitchRollOriginal, double yaw, YawPitchRollBasics yawPitchRollToPack) {
        double halfYaw = 0.5 * yawPitchRollOriginal.getYaw();
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * yawPitchRollOriginal.getPitch();
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * yawPitchRollOriginal.getRoll();
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        halfYaw = 0.5 * yaw;
        cYaw = EuclidCoreTools.cos(halfYaw);
        sYaw = EuclidCoreTools.sin(halfYaw);
        double x = qx * cYaw + qy * sYaw;
        double y = -qx * sYaw + qy * cYaw;
        double z = qs * sYaw + qz * cYaw;
        double s = qs * cYaw - qz * sYaw;
        yawPitchRollToPack.setQuaternion(x, y, z, s);
    }

    public static void prependPitchRotation(YawPitchRollReadOnly yawPitchRollOriginal, double pitch, YawPitchRollBasics yawPitchRollToPack) {
        if (Math.abs(yawPitchRollOriginal.getRoll()) < 1.0E-12) {
            double yaw = yawPitchRollOriginal.getYaw();
            pitch = EuclidCoreTools.trimAngleMinusPiToPi(pitch + yawPitchRollOriginal.getPitch());
            double roll = yawPitchRollOriginal.getRoll();
            yawPitchRollToPack.set(yaw, pitch, roll);
        } else {
            double halfYaw = 0.5 * yawPitchRollOriginal.getYaw();
            double cYaw = EuclidCoreTools.cos(halfYaw);
            double sYaw = EuclidCoreTools.sin(halfYaw);
            double halfPitch = 0.5 * yawPitchRollOriginal.getPitch();
            double cPitch = EuclidCoreTools.cos(halfPitch);
            double sPitch = EuclidCoreTools.sin(halfPitch);
            double halfRoll = 0.5 * yawPitchRollOriginal.getRoll();
            double cRoll = EuclidCoreTools.cos(halfRoll);
            double sRoll = EuclidCoreTools.sin(halfRoll);
            double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
            double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
            double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
            double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
            double halfPitch2 = 0.5 * pitch;
            double cPitch2 = EuclidCoreTools.cos(halfPitch2);
            double sPitch2 = EuclidCoreTools.sin(halfPitch2);
            double x = cPitch2 * qx + sPitch2 * qz;
            double y = cPitch2 * qy + sPitch2 * qs;
            double z = cPitch2 * qz - sPitch2 * qx;
            double s = cPitch2 * qs - sPitch2 * qy;
            yawPitchRollToPack.setQuaternion(x, y, z, s);
        }
    }

    public static void appendPitchRotation(YawPitchRollReadOnly yawPitchRollOriginal, double pitch, YawPitchRollBasics yawPitchRollToPack) {
        if (Math.abs(yawPitchRollOriginal.getRoll()) < 1.0E-12) {
            double yaw = yawPitchRollOriginal.getYaw();
            pitch = EuclidCoreTools.trimAngleMinusPiToPi(pitch + yawPitchRollOriginal.getPitch());
            double roll = yawPitchRollOriginal.getRoll();
            yawPitchRollToPack.set(yaw, pitch, roll);
        } else {
            double halfYaw = 0.5 * yawPitchRollOriginal.getYaw();
            double cYaw = EuclidCoreTools.cos(halfYaw);
            double sYaw = EuclidCoreTools.sin(halfYaw);
            double halfPitch = 0.5 * yawPitchRollOriginal.getPitch();
            double cPitch = EuclidCoreTools.cos(halfPitch);
            double sPitch = EuclidCoreTools.sin(halfPitch);
            double halfRoll = 0.5 * yawPitchRollOriginal.getRoll();
            double cRoll = EuclidCoreTools.cos(halfRoll);
            double sRoll = EuclidCoreTools.sin(halfRoll);
            double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
            double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
            double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
            double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
            double halfPitch2 = 0.5 * pitch;
            double cPitch2 = EuclidCoreTools.cos(halfPitch2);
            double sPitch2 = EuclidCoreTools.sin(halfPitch2);
            double x = qx * cPitch2 - qz * sPitch2;
            double y = qs * sPitch2 + qy * cPitch2;
            double z = qx * sPitch2 + qz * cPitch2;
            double s = qs * cPitch2 - qy * sPitch2;
            yawPitchRollToPack.setQuaternion(x, y, z, s);
        }
    }

    public static void prependRollRotation(YawPitchRollReadOnly yawPitchRollOriginal, double roll, YawPitchRollBasics yawPitchRollToPack) {
        double halfYaw = 0.5 * yawPitchRollOriginal.getYaw();
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * yawPitchRollOriginal.getPitch();
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * yawPitchRollOriginal.getRoll();
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        double halfRoll2 = 0.5 * roll;
        double cRoll2 = EuclidCoreTools.cos(halfRoll2);
        double sRoll2 = EuclidCoreTools.sin(halfRoll2);
        double x = cRoll2 * qx + sRoll2 * qs;
        double y = cRoll2 * qy - sRoll2 * qz;
        double z = cRoll2 * qz + sRoll2 * qy;
        double s = cRoll2 * qs - sRoll2 * qx;
        yawPitchRollToPack.setQuaternion(x, y, z, s);
    }

    public static void appendRollRotation(YawPitchRollReadOnly yawPitchRollOriginal, double roll, YawPitchRollBasics yawPitchRollToPack) {
        double yaw = yawPitchRollOriginal.getYaw();
        double pitch = yawPitchRollOriginal.getPitch();
        roll = EuclidCoreTools.trimAngleMinusPiToPi(roll + yawPitchRollOriginal.getRoll());
        yawPitchRollToPack.set(yaw, pitch, roll);
    }
}

