/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class Quaternion32
implements QuaternionBasics {
    private float x;
    private float y;
    private float z;
    private float s;

    public Quaternion32() {
        this.setToZero();
    }

    public Quaternion32(float x, float y, float z, float s) {
        this.set(x, y, z, s);
    }

    public Quaternion32(float[] quaternionArray) {
        this.set(quaternionArray);
    }

    public Quaternion32(Orientation3DReadOnly orientation) {
        this.set(orientation);
    }

    public Quaternion32(Vector3DReadOnly rotationVector) {
        this.setRotationVector(rotationVector);
    }

    public Quaternion32(double yaw, double pitch, double roll) {
        this.setYawPitchRoll(yaw, pitch, roll);
    }

    @Override
    public void setUnsafe(double qx, double qy, double qz, double qs) {
        this.x = (float)qx;
        this.y = (float)qy;
        this.z = (float)qz;
        this.s = (float)qs;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getS() {
        return this.s;
    }

    @Override
    public float getX32() {
        return this.x;
    }

    @Override
    public float getY32() {
        return this.y;
    }

    @Override
    public float getZ32() {
        return this.z;
    }

    @Override
    public float getS32() {
        return this.s;
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple4DReadOnly) {
            return this.equals((Tuple4DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.x, this.y, this.z, this.s);
    }
}

