/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public interface Point2DReadOnly
extends Tuple2DReadOnly {
    default public double distance(Point2DReadOnly other) {
        return this.differenceNorm(other);
    }

    default public double distanceSquared(Point2DReadOnly other) {
        return this.differenceNormSquared(other);
    }

    default public double distanceXY(Point3DReadOnly point3DReadOnly) {
        return EuclidCoreTools.squareRoot(this.distanceXYSquared(point3DReadOnly));
    }

    default public double distanceXYSquared(Point3DReadOnly point3DReadOnly) {
        double dx = this.getX() - point3DReadOnly.getX();
        double dy = this.getY() - point3DReadOnly.getY();
        return EuclidCoreTools.normSquared(dx, dy);
    }

    default public double distanceFromOrigin() {
        return EuclidCoreTools.squareRoot(this.distanceFromOriginSquared());
    }

    default public double distanceFromOriginSquared() {
        return EuclidCoreTools.normSquared(this.getX(), this.getY());
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Point2DReadOnly)) {
            return false;
        }
        Point2DReadOnly other = (Point2DReadOnly)geometry;
        return this.distance(other) <= epsilon;
    }
}

