/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class UnitVector2D
implements UnitVector2DBasics {
    public static final double ZERO_TEST_EPSILON = 1.0E-16;
    private boolean dirty = true;
    private double x;
    private double y;

    public UnitVector2D() {
        this.setToZero();
    }

    public UnitVector2D(double x, double y) {
        this.set(x, y);
    }

    public UnitVector2D(double[] vectorArray) {
        this.set(vectorArray);
    }

    public UnitVector2D(Tuple3DReadOnly tuple3DReadOnly) {
        this.set(tuple3DReadOnly);
    }

    public UnitVector2D(Tuple2DReadOnly other) {
        this.set(other);
    }

    @Override
    public void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
    }

    @Override
    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    @Override
    public void normalize() {
        if (this.dirty) {
            if (EuclidCoreTools.areAllZero(this.x, this.y, 1.0E-16)) {
                this.setToZero();
            } else {
                double lengthInverse = 1.0 / EuclidCoreTools.fastNorm(this.x, this.y);
                this.x *= lengthInverse;
                this.y *= lengthInverse;
            }
            this.dirty = false;
        }
    }

    @Override
    public void markAsDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void set(UnitVector2DReadOnly other) {
        this.x = other.getRawX();
        this.y = other.getRawY();
        this.dirty = other.isDirty();
    }

    @Override
    public void setX(double x) {
        if (this.x != x) {
            this.x = x;
            this.markAsDirty();
        }
    }

    @Override
    public void setY(double y) {
        if (this.y != y) {
            this.y = y;
            this.markAsDirty();
        }
    }

    @Override
    public double getRawX() {
        return this.x;
    }

    @Override
    public double getRawY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple2DReadOnly) {
            return UnitVector2DBasics.super.equals((Tuple2DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
    }
}

