/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class AffineTransform
implements AffineTransformBasics {
    private final LinearTransform3D linearTransform = new LinearTransform3D();
    private final Vector3D translationVector = new Vector3D();

    public AffineTransform() {
        this.setIdentity();
    }

    public AffineTransform(AffineTransformReadOnly other) {
        this.set(other);
    }

    public AffineTransform(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.set(rigidBodyTransform);
    }

    public AffineTransform(Matrix3DReadOnly linearTransform, Tuple3DReadOnly translation) {
        this.set(linearTransform, translation);
    }

    public AffineTransform(DMatrix linearTransform, Tuple3DReadOnly translation) {
        this.set(linearTransform, translation);
    }

    public AffineTransform(RotationMatrix rotationMatrix, Tuple3DReadOnly translation) {
        this.set(rotationMatrix, translation);
    }

    public AffineTransform(Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.set(orientation, translation);
    }

    public QuaternionReadOnly getRotationView() {
        return this.linearTransform.getAsQuaternion();
    }

    @Override
    public LinearTransform3D getLinearTransform() {
        return this.linearTransform;
    }

    @Override
    public Vector3DBasics getTranslation() {
        return this.translationVector;
    }

    public double getElement(int row, int column) {
        if (row < 3) {
            if (column < 3) {
                return this.linearTransform.getElement(row, column);
            }
            if (column < 4) {
                return this.translationVector.getElement(row);
            }
            throw Matrix3DTools.columnOutOfBoundsException(3, column);
        }
        if (row < 4) {
            if (column < 3) {
                return 0.0;
            }
            if (column < 4) {
                return 1.0;
            }
            throw Matrix3DTools.columnOutOfBoundsException(3, column);
        }
        throw Matrix3DTools.rowOutOfBoundsException(3, row);
    }

    public double getM00() {
        return this.linearTransform.getM00();
    }

    public double getM01() {
        return this.linearTransform.getM01();
    }

    public double getM02() {
        return this.linearTransform.getM02();
    }

    public double getM03() {
        return this.translationVector.getX();
    }

    public double getM10() {
        return this.linearTransform.getM10();
    }

    public double getM11() {
        return this.linearTransform.getM11();
    }

    public double getM12() {
        return this.linearTransform.getM12();
    }

    public double getM13() {
        return this.translationVector.getY();
    }

    public double getM20() {
        return this.linearTransform.getM20();
    }

    public double getM21() {
        return this.linearTransform.getM21();
    }

    public double getM22() {
        return this.linearTransform.getM22();
    }

    public double getM23() {
        return this.translationVector.getZ();
    }

    public double getM30() {
        return 0.0;
    }

    public double getM31() {
        return 0.0;
    }

    public double getM32() {
        return 0.0;
    }

    public double getM33() {
        return 1.0;
    }

    public boolean equals(Object object) {
        if (object instanceof AffineTransformReadOnly) {
            return this.equals((AffineTransformReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)this.linearTransform.hashCode(), this.translationVector.hashCode());
        return EuclidHashCodeTools.toIntHashCode(bits);
    }
}

