/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import org.ejml.MatrixDimensionException;
import org.ejml.data.Matrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class EuclidCoreTools {
    public static final double TwoPI = Math.PI * 2;
    public static final double EPS_NORM_FAST_SQRT = 2.107342E-8;
    public static final double EPS_ANGLE_SHIFT = 1.0E-12;
    public static final double CLAMP_EPS = 1.0E-10;
    public static final Point2DReadOnly origin2D = new Point2DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple2DReadOnly) {
                return Point2DReadOnly.super.equals((Tuple2DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Point3DReadOnly origin3D = new Point3DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple3DReadOnly) {
                return Point3DReadOnly.super.equals((Tuple3DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Vector2DReadOnly zeroVector2D = new Vector2DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple2DReadOnly) {
                return Vector2DReadOnly.super.equals((Tuple2DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Vector3DReadOnly zeroVector3D = new Vector3DReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple3DReadOnly) {
                return Vector3DReadOnly.super.equals((Tuple3DReadOnly)object);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final QuaternionReadOnly neutralQuaternion = new QuaternionReadOnly(){

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public double getZ() {
            return 0.0;
        }

        @Override
        public double getS() {
            return 1.0;
        }

        public int hashCode() {
            return -1106247679;
        }

        public boolean equals(Object object) {
            if (object instanceof QuaternionReadOnly) {
                return this.equals((QuaternionReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };
    public static final Matrix3DReadOnly zeroMatrix3D = new Matrix3DReadOnly(){

        @Override
        public double getM00() {
            return 0.0;
        }

        @Override
        public double getM01() {
            return 0.0;
        }

        @Override
        public double getM02() {
            return 0.0;
        }

        @Override
        public double getM10() {
            return 0.0;
        }

        @Override
        public double getM11() {
            return 0.0;
        }

        @Override
        public double getM12() {
            return 0.0;
        }

        @Override
        public double getM20() {
            return 0.0;
        }

        @Override
        public double getM21() {
            return 0.0;
        }

        @Override
        public double getM22() {
            return 0.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Matrix3DReadOnly) {
                return Matrix3DReadOnly.super.equals((Matrix3DReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }

        public int hashCode() {
            return 1;
        }
    };
    public static final Matrix3DReadOnly identityMatrix3D = new Matrix3DReadOnly(){

        @Override
        public double getM00() {
            return 1.0;
        }

        @Override
        public double getM01() {
            return 0.0;
        }

        @Override
        public double getM02() {
            return 0.0;
        }

        @Override
        public double getM10() {
            return 0.0;
        }

        @Override
        public double getM11() {
            return 1.0;
        }

        @Override
        public double getM12() {
            return 0.0;
        }

        @Override
        public double getM20() {
            return 0.0;
        }

        @Override
        public double getM21() {
            return 0.0;
        }

        @Override
        public double getM22() {
            return 1.0;
        }

        public boolean equals(Object object) {
            if (object instanceof Matrix3DReadOnly) {
                return Matrix3DReadOnly.super.equals((Matrix3DReadOnly)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }

        public int hashCode() {
            return 976224257;
        }
    };

    private EuclidCoreTools() {
    }

    public static double squareRoot(double value) {
        return Math.sqrt(value);
    }

    public static double fastSquareRoot(double squaredValueClosedToOne) {
        squaredValueClosedToOne = Math.abs(1.0 - squaredValueClosedToOne) < 2.107342E-8 ? 0.5 * (1.0 + squaredValueClosedToOne) : EuclidCoreTools.squareRoot(squaredValueClosedToOne);
        return squaredValueClosedToOne;
    }

    public static boolean containsNaN(double a, double b) {
        return Double.isNaN(a) || Double.isNaN(b);
    }

    public static boolean containsNaN(double a, double b, double c) {
        return Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c);
    }

    public static boolean containsNaN(double a, double b, double c, double d) {
        return Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c) || Double.isNaN(d);
    }

    public static boolean containsNaN(double a0, double a1, double a2, double a3, double a4, double a5, double a6, double a7, double a8) {
        if (Double.isNaN(a0) || Double.isNaN(a1) || Double.isNaN(a2)) {
            return true;
        }
        if (Double.isNaN(a3) || Double.isNaN(a4) || Double.isNaN(a5)) {
            return true;
        }
        return Double.isNaN(a6) || Double.isNaN(a7) || Double.isNaN(a8);
    }

    public static boolean containsNaN(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Double.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static double square(double value) {
        return value * value;
    }

    public static double normSquared(double x, double y) {
        return x * x + y * y;
    }

    public static double normSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double normSquared(double x, double y, double z, double s) {
        return x * x + y * y + z * z + s * s;
    }

    public static double norm(double x, double y) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y));
    }

    public static double norm(double x, double y, double z) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y, z));
    }

    public static double norm(double x, double y, double z, double s) {
        return EuclidCoreTools.squareRoot(EuclidCoreTools.normSquared(x, y, z, s));
    }

    public static double fastNorm(double x, double y) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y));
    }

    public static double fastNorm(double x, double y, double z) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y, z));
    }

    public static double fastNorm(double x, double y, double z, double s) {
        return EuclidCoreTools.fastSquareRoot(EuclidCoreTools.normSquared(x, y, z, s));
    }

    public static double trimAngleMinusPiToPi(double angleToShift) {
        return EuclidCoreTools.shiftAngleInRange(angleToShift, -Math.PI);
    }

    public static double angleDifferenceMinusPiToPi(double angleA, double angleB) {
        return EuclidCoreTools.trimAngleMinusPiToPi(angleA - angleB);
    }

    public static double shiftAngleInRange(double angleToShift, double angleStart) {
        double deltaFromStart = (angleToShift - (angleStart -= 1.0E-12)) % (Math.PI * 2);
        if (deltaFromStart < 0.0) {
            deltaFromStart += Math.PI * 2;
        }
        return angleStart + deltaFromStart;
    }

    public static final double max(double a, double b, double c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    public static final double max(double a, double b, double c, double d) {
        if (a > b) {
            if (a > c) {
                return a > d ? a : d;
            }
            return c > d ? c : d;
        }
        if (b > c) {
            return b > d ? b : d;
        }
        return c > d ? c : d;
    }

    public static final double min(double a, double b, double c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static final double min(double a, double b, double c, double d) {
        if (a < b) {
            if (a < c) {
                return a < d ? a : d;
            }
            return c < d ? c : d;
        }
        if (b < c) {
            return b < d ? b : d;
        }
        return c < d ? c : d;
    }

    public static final double med(double a, double b, double c) {
        if (a > b) {
            if (a > c) {
                return b > c ? b : c;
            }
            return a;
        }
        if (b > c) {
            return a > c ? a : c;
        }
        return b;
    }

    public static boolean equals(double expectedValue, double actualValue) {
        if (expectedValue == actualValue) {
            return true;
        }
        return Double.isNaN(expectedValue) && Double.isNaN(actualValue);
    }

    public static boolean epsilonEquals(double expectedValue, double actualValue, double epsilon) {
        return Math.abs(expectedValue - actualValue) <= epsilon;
    }

    public static boolean isZero(double value, double epsilon) {
        return Math.abs(value) <= epsilon;
    }

    public static boolean areAllZero(double x, double y, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon);
    }

    public static boolean areAllZero(double x, double y, double z, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon) && EuclidCoreTools.isZero(z, epsilon);
    }

    public static boolean areAllZero(double x, double y, double z, double s, double epsilon) {
        return EuclidCoreTools.isZero(x, epsilon) && EuclidCoreTools.isZero(y, epsilon) && EuclidCoreTools.isZero(z, epsilon) && EuclidCoreTools.isZero(s, epsilon);
    }

    public static boolean angleGeometricallyEquals(double expectedAngle, double actualAngle, double epsilon) {
        return Math.abs(EuclidCoreTools.angleDifferenceMinusPiToPi(expectedAngle, actualAngle)) <= epsilon;
    }

    public static boolean isAngleZero(double angle, double epsilon) {
        if ((angle = Math.abs(angle) % (Math.PI * 2)) > Math.PI) {
            angle -= Math.PI * 2;
        }
        return Math.abs(angle) <= epsilon;
    }

    public static double clamp(double value, double minMax) {
        return EuclidCoreTools.clamp(value, -minMax, minMax);
    }

    public static double clamp(double value, double min, double max) {
        if (min > max + 1.0E-10) {
            throw new RuntimeException(EuclidCoreTools.class.getSimpleName() + ".clamp(double, double, double): min > max (" + min + " > " + max + ")");
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double interpolate(double a, double b, double alpha) {
        return (1.0 - alpha) * a + alpha * b;
    }

    public static double tan(double a) {
        return StrictMath.tan(a);
    }

    public static double atan(double a) {
        return StrictMath.atan(a);
    }

    public static double atan2(double y, double x) {
        return StrictMath.atan2(y, x);
    }

    public static double cos(double a) {
        return StrictMath.cos(a);
    }

    public static double sin(double a) {
        return StrictMath.sin(a);
    }

    public static double acos(double a) {
        return StrictMath.acos(a);
    }

    public static double fastAcos(double cosX) {
        if (cosX == -1.0) {
            return Math.PI;
        }
        return 2.0 * EuclidCoreTools.atan2(EuclidCoreTools.squareRoot(1.0 - cosX * cosX), 1.0 + cosX);
    }

    public static double asin(double a) {
        return StrictMath.asin(a);
    }

    public static void checkMatrixMinimumSize(int minRows, int minColumns, Matrix matrixToTest) {
        if (matrixToTest.getNumCols() < minColumns || matrixToTest.getNumRows() < minRows) {
            throw new MatrixDimensionException("The matrix is too small, expected: [nRows >= " + minRows + ", nColumns >= " + minColumns + "], was: [nRows = " + matrixToTest.getNumRows() + ", nCols = " + matrixToTest.getNumCols() + "].");
        }
    }
}

