/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class AxisAngle
implements AxisAngleBasics {
    private final UnitVector3D axis = new UnitVector3D(Axis3D.X);
    private double angle;

    public AxisAngle() {
        this.setToZero();
    }

    public AxisAngle(Orientation3DReadOnly orientation) {
        this.set(orientation);
    }

    public AxisAngle(double x, double y, double z, double angle) {
        this.set(x, y, z, angle);
    }

    public AxisAngle(double[] axisAngleArray) {
        this.set(axisAngleArray);
    }

    public AxisAngle(Vector3DReadOnly axis, double angle) {
        this.set(axis, angle);
    }

    public AxisAngle(Vector3DReadOnly rotationVector) {
        this.setRotationVector(rotationVector);
    }

    public AxisAngle(double yaw, double pitch, double roll) {
        this.setYawPitchRoll(yaw, pitch, roll);
    }

    @Override
    public UnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public final void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public final double getAngle() {
        return this.angle;
    }

    public boolean equals(Object object) {
        if (object instanceof AxisAngleReadOnly) {
            return AxisAngleBasics.super.equals((AxisAngleReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode(1L, this.axis);
        bits = EuclidHashCodeTools.addToHashCode(bits, this.angle);
        return EuclidHashCodeTools.toIntHashCode(bits);
    }
}

