/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public interface Vector4DBasics
extends Vector4DReadOnly,
Tuple4DBasics {
    public void setX(double var1);

    public void setY(double var1);

    public void setZ(double var1);

    public void setS(double var1);

    @Override
    default public void setToZero() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        this.scale(1.0 / this.norm());
    }

    default public void clipToMax(double max) {
        this.set(Math.min(max, this.getX()), Math.min(max, this.getY()), Math.min(max, this.getZ()), Math.min(max, this.getS()));
    }

    default public void clipToMin(double min) {
        this.set(Math.max(min, this.getX()), Math.max(min, this.getY()), Math.max(min, this.getZ()), Math.max(min, this.getS()));
    }

    default public void clipToMinMax(double min, double max) {
        this.setAndClipToMinMax(min, max, this);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
                break;
            }
            case 2: {
                this.setZ(value);
                break;
            }
            case 3: {
                this.setS(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    @Override
    default public void set(double x, double y, double z, double s) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setS(s);
    }

    default public void set(Vector3DReadOnly vector3D) {
        this.set(vector3D.getX(), vector3D.getY(), vector3D.getZ(), 0.0);
    }

    default public void set(Point3DReadOnly point3D) {
        this.set(point3D.getX(), point3D.getY(), point3D.getZ(), 1.0);
    }

    default public void setAndScale(double scalar, Tuple4DReadOnly tupleReadOnly) {
        this.set(scalar * tupleReadOnly.getX(), scalar * tupleReadOnly.getY(), scalar * tupleReadOnly.getZ(), scalar * tupleReadOnly.getS());
    }

    default public void setAndClipToMax(double max, Tuple4DReadOnly tupleReadOnly) {
        this.set(Math.min(max, tupleReadOnly.getX()), Math.min(max, tupleReadOnly.getY()), Math.min(max, tupleReadOnly.getZ()), Math.min(max, tupleReadOnly.getS()));
    }

    default public void setAndClipToMin(double min, Tuple4DReadOnly tupleReadOnly) {
        this.set(Math.max(min, tupleReadOnly.getX()), Math.max(min, tupleReadOnly.getY()), Math.max(min, tupleReadOnly.getZ()), Math.max(min, tupleReadOnly.getS()));
    }

    default public void setAndClipToMinMax(double min, double max, Tuple4DReadOnly tupleReadOnly) {
        double x = tupleReadOnly.getX();
        double y = tupleReadOnly.getY();
        double z = tupleReadOnly.getZ();
        double s = tupleReadOnly.getS();
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        if (y < min) {
            y = min;
        } else if (y > max) {
            y = max;
        }
        if (z < min) {
            z = min;
        } else if (z > max) {
            z = max;
        }
        if (s < min) {
            s = min;
        } else if (s > max) {
            s = max;
        }
        this.set(x, y, z, s);
    }

    default public void addX(double x) {
        this.setX(this.getX() + x);
    }

    default public void addY(double y) {
        this.setY(this.getY() + y);
    }

    default public void addZ(double z) {
        this.setZ(this.getZ() + z);
    }

    default public void addS(double s) {
        this.setS(this.getS() + s);
    }

    default public void add(double x, double y, double z, double s) {
        this.set(this.getX() + x, this.getY() + y, this.getZ() + z, this.getS() + s);
    }

    default public void add(Tuple4DReadOnly tupleReadOnly) {
        this.add(tupleReadOnly.getX(), tupleReadOnly.getY(), tupleReadOnly.getZ(), tupleReadOnly.getS());
    }

    default public void add(Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2) {
        this.set(tuple1.getX() + tuple2.getX(), tuple1.getY() + tuple2.getY(), tuple1.getZ() + tuple2.getZ(), tuple1.getS() + tuple2.getS());
    }

    default public void subX(double x) {
        this.setX(this.getX() - x);
    }

    default public void subY(double y) {
        this.setY(this.getY() - y);
    }

    default public void subZ(double z) {
        this.setZ(this.getZ() - z);
    }

    default public void subS(double s) {
        this.setS(this.getS() - s);
    }

    default public void sub(double x, double y, double z, double s) {
        this.set(this.getX() - x, this.getY() - y, this.getZ() - z, this.getS() - s);
    }

    default public void sub(Tuple4DReadOnly tupleReadOnly) {
        this.sub(tupleReadOnly.getX(), tupleReadOnly.getY(), tupleReadOnly.getZ(), tupleReadOnly.getS());
    }

    default public void sub(Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2) {
        this.set(tuple1.getX() - tuple2.getX(), tuple1.getY() - tuple2.getY(), tuple1.getZ() - tuple2.getZ(), tuple1.getS() - tuple2.getS());
    }

    default public void scale(double scalar) {
        this.scale(scalar, scalar, scalar, scalar);
    }

    default public void scale(double scalarX, double scalarY, double scalarZ, double scalarS) {
        this.set(scalarX * this.getX(), scalarY * this.getY(), scalarZ * this.getZ(), scalarS * this.getS());
    }

    default public void scaleAdd(double scalar, Tuple4DReadOnly tupleReadOnly) {
        this.scale(scalar);
        this.add(tupleReadOnly);
    }

    default public void scaleAdd(double scalar, Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2) {
        double x = scalar * tuple1.getX() + tuple2.getX();
        double y = scalar * tuple1.getY() + tuple2.getY();
        double z = scalar * tuple1.getZ() + tuple2.getZ();
        double s = scalar * tuple1.getS() + tuple2.getS();
        this.set(x, y, z, s);
    }

    default public void scaleSub(double scalar, Tuple4DReadOnly tupleReadOnly) {
        this.scale(scalar);
        this.sub(tupleReadOnly);
    }

    default public void scaleSub(double scalar, Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2) {
        double x = scalar * tuple1.getX() - tuple2.getX();
        double y = scalar * tuple1.getY() - tuple2.getY();
        double z = scalar * tuple1.getZ() - tuple2.getZ();
        double s = scalar * tuple1.getS() - tuple2.getS();
        this.set(x, y, z, s);
    }

    default public void interpolate(Tuple4DReadOnly tupleReadOnly, double alpha) {
        this.interpolate(this, tupleReadOnly, alpha);
    }

    default public void interpolate(Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2, double alpha) {
        double x = EuclidCoreTools.interpolate(tuple1.getX(), tuple2.getX(), alpha);
        double y = EuclidCoreTools.interpolate(tuple1.getY(), tuple2.getY(), alpha);
        double z = EuclidCoreTools.interpolate(tuple1.getZ(), tuple2.getZ(), alpha);
        double s = EuclidCoreTools.interpolate(tuple1.getS(), tuple2.getS(), alpha);
        this.set(x, y, z, s);
    }

    @Override
    default public void applyTransform(Transform transform) {
        transform.transform(this);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this);
    }
}

