/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public interface Tuple4DBasics
extends Tuple4DReadOnly,
Clearable,
Transformable {
    public void set(double var1, double var3, double var5, double var7);

    public void normalize();

    @Override
    default public void setToNaN() {
        this.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return Tuple4DReadOnly.super.containsNaN();
    }

    default public void absolute() {
        this.set(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()), Math.abs(this.getS()));
    }

    default public void negate() {
        this.set(-this.getX(), -this.getY(), -this.getZ(), -this.getS());
    }

    default public void set(Tuple4DReadOnly other) {
        this.set(other.getX(), other.getY(), other.getZ(), other.getS());
    }

    default public void set(double[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1], tupleArray[2], tupleArray[3]);
    }

    default public void set(int startIndex, double[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(float[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1], tupleArray[2], tupleArray[3]);
    }

    default public void set(int startIndex, float[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(4, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(0, 0), matrix.unsafe_get(1, 0), matrix.unsafe_get(2, 0), matrix.unsafe_get(3, 0));
    }

    default public void set(int startRow, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 4, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow, 0));
    }

    default public void set(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 4, column + 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow, column));
    }

    default public void setAndAbsolute(Tuple4DReadOnly other) {
        this.set(Math.abs(other.getX()), Math.abs(other.getY()), Math.abs(other.getZ()), Math.abs(other.getS()));
    }

    default public void setAndNegate(Tuple4DReadOnly other) {
        this.set(-other.getX(), -other.getY(), -other.getZ(), -other.getS());
    }

    default public void setAndNormalize(Tuple4DReadOnly other) {
        this.set(other);
        this.normalize();
    }
}

