/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface UnitVector3DBasics
extends UnitVector3DReadOnly,
Vector3DBasics {
    @Override
    public void setX(double var1);

    @Override
    public void setY(double var1);

    @Override
    public void setZ(double var1);

    @Override
    default public double getX() {
        this.normalize();
        return this.getRawX();
    }

    @Override
    default public double getY() {
        this.normalize();
        return this.getRawY();
    }

    @Override
    default public double getZ() {
        this.normalize();
        return this.getRawZ();
    }

    public void markAsDirty();

    @Override
    public void negate();

    @Override
    public void absolute();

    @Override
    public void normalize();

    public void set(UnitVector3DReadOnly var1);

    @Override
    default public void setToZero() {
        this.set(Axis3D.X);
    }

    @Override
    default public void set(Tuple3DReadOnly tupleReadOnly) {
        if (tupleReadOnly instanceof UnitVector3DReadOnly) {
            this.set((UnitVector3DReadOnly)tupleReadOnly);
        } else {
            Vector3DBasics.super.set(tupleReadOnly);
        }
    }

    @Override
    default public void setAndNegate(Tuple3DReadOnly tupleReadOnly) {
        if (tupleReadOnly instanceof UnitVector3DReadOnly) {
            this.set((UnitVector3DReadOnly)tupleReadOnly);
            this.negate();
        } else {
            Vector3DBasics.super.setAndNegate(tupleReadOnly);
        }
    }

    @Override
    default public void setAndAbsolute(Tuple3DReadOnly other) {
        if (other instanceof UnitVector3DReadOnly) {
            this.set((UnitVector3DReadOnly)other);
            this.absolute();
        } else {
            Vector3DBasics.super.setAndAbsolute(other);
        }
    }

    @Override
    default public void addX(double x) {
        this.setX(this.getRawX() + x);
    }

    @Override
    default public void addY(double y) {
        this.setY(this.getRawY() + y);
    }

    @Override
    default public void addZ(double z) {
        this.setZ(this.getRawZ() + z);
    }

    @Override
    default public void add(double x, double y, double z) {
        this.set(this.getRawX() + x, this.getRawY() + y, this.getRawZ() + z);
    }

    @Override
    default public void subX(double x) {
        this.setX(this.getRawX() - x);
    }

    @Override
    default public void subY(double y) {
        this.setY(this.getRawY() - y);
    }

    @Override
    default public void subZ(double z) {
        this.setZ(this.getRawZ() - z);
    }

    @Override
    default public void sub(double x, double y, double z) {
        this.set(this.getRawX() - x, this.getRawY() - y, this.getRawZ() - z);
    }

    @Override
    default public void scale(double scalar) {
    }

    @Override
    default public void scaleAdd(double scalar, Tuple3DReadOnly other) {
        Vector3DBasics.super.add(other);
    }

    @Override
    default public void scaleAdd(double scalar, Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        if (tuple1 == this) {
            this.add(tuple1, tuple2);
        } else if (tuple2 == this) {
            double x = scalar * tuple1.getX() + this.getRawX();
            double y = scalar * tuple1.getY() + this.getRawY();
            double z = scalar * tuple1.getZ() + this.getRawZ();
            this.set(x, y, z);
        } else {
            Vector3DBasics.super.scaleAdd(scalar, tuple1, tuple2);
        }
    }

    @Override
    default public void scaleSub(double scalar, Tuple3DReadOnly other) {
        Vector3DBasics.super.sub(other);
    }

    @Override
    default public void scaleSub(double scalar, Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        if (tuple1 == this) {
            this.sub(tuple1, tuple2);
        } else if (tuple2 == this) {
            double x = scalar * tuple1.getX() - this.getRawX();
            double y = scalar * tuple1.getY() - this.getRawY();
            double z = scalar * tuple1.getZ() - this.getRawZ();
            this.set(x, y, z);
        } else {
            Vector3DBasics.super.scaleSub(scalar, tuple1, tuple2);
        }
    }

    @Override
    default public boolean clipToMaxLength(double maxLength) {
        return false;
    }
}

