/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public class YawPitchRollConversion {
    public static final double SAFE_THRESHOLD_PITCH = Math.toRadians(1.82);
    public static final double MAX_SAFE_PITCH_ANGLE = 1.5707963267948966 - SAFE_THRESHOLD_PITCH;
    public static final double MIN_SAFE_PITCH_ANGLE = -MAX_SAFE_PITCH_ANGLE;
    private static final double EPS = 1.0E-12;

    private YawPitchRollConversion() {
    }

    static double computeYawImpl(double m00, double m10) {
        if (EuclidCoreTools.containsNaN(m00, m10)) {
            return Double.NaN;
        }
        return EuclidCoreTools.atan2(m10, m00);
    }

    static double computePitchImpl(double m20) {
        if (Double.isNaN(m20)) {
            return Double.NaN;
        }
        if (m20 > 1.0) {
            m20 = 1.0;
        } else if (m20 < -1.0) {
            m20 = -1.0;
        }
        return EuclidCoreTools.asin(-m20);
    }

    static double computeRollImpl(double m21, double m22) {
        if (EuclidCoreTools.containsNaN(m21, m22)) {
            return Double.NaN;
        }
        return EuclidCoreTools.atan2(m21, m22);
    }

    public static double computeYaw(RotationMatrixReadOnly rotationMatrix) {
        return rotationMatrix.isZeroOrientation() ? 0.0 : YawPitchRollConversion.computeYawImpl(rotationMatrix.getM00(), rotationMatrix.getM10());
    }

    public static double computePitch(RotationMatrixReadOnly rotationMatrix) {
        return rotationMatrix.isZeroOrientation() ? 0.0 : YawPitchRollConversion.computePitchImpl(rotationMatrix.getM20());
    }

    public static double computeRoll(RotationMatrixReadOnly rotationMatrix) {
        return rotationMatrix.isZeroOrientation() ? 0.0 : YawPitchRollConversion.computeRollImpl(rotationMatrix.getM21(), rotationMatrix.getM22());
    }

    public static void convertMatrixToYawPitchRoll(RotationMatrixReadOnly rotationMatrix, YawPitchRollBasics yawPitchRollToPack) {
        double m00 = rotationMatrix.getM00();
        double m01 = rotationMatrix.getM01();
        double m02 = rotationMatrix.getM02();
        double m10 = rotationMatrix.getM10();
        double m11 = rotationMatrix.getM11();
        double m12 = rotationMatrix.getM12();
        double m20 = rotationMatrix.getM20();
        double m21 = rotationMatrix.getM21();
        double m22 = rotationMatrix.getM22();
        YawPitchRollConversion.convertMatrixToYawPitchRoll(m00, m01, m02, m10, m11, m12, m20, m21, m22, yawPitchRollToPack);
    }

    public static void convertMatrixToYawPitchRoll(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, YawPitchRollBasics yawPitchRollToPack) {
        double yaw = YawPitchRollConversion.computeYawImpl(m00, m10);
        double pitch = YawPitchRollConversion.computePitchImpl(m20);
        double roll = YawPitchRollConversion.computeRollImpl(m21, m22);
        yawPitchRollToPack.set(yaw, pitch, roll);
    }

    public static void convertMatrixToYawPitchRoll(RotationMatrixReadOnly rotationMatrix, Tuple3DBasics eulerAnglesToPack) {
        eulerAnglesToPack.set(YawPitchRollConversion.computeRollImpl(rotationMatrix.getM21(), rotationMatrix.getM22()), YawPitchRollConversion.computePitchImpl(rotationMatrix.getM20()), YawPitchRollConversion.computeYawImpl(rotationMatrix.getM00(), rotationMatrix.getM10()));
    }

    static double computeYawFromQuaternionImpl(double qx, double qy, double qz, double qs) {
        return EuclidCoreTools.atan2(2.0 * (qx * qy + qz * qs), 1.0 - 2.0 * (qy * qy + qz * qz));
    }

    static double computePitchFromQuaternionImpl(double qx, double qy, double qz, double qs) {
        double pitchArgument = 2.0 * (qs * qy - qx * qz);
        if (pitchArgument > 1.0) {
            pitchArgument = 1.0;
        } else if (pitchArgument < -1.0) {
            pitchArgument = -1.0;
        }
        return EuclidCoreTools.asin(pitchArgument);
    }

    static double computeRollFromQuaternionImpl(double qx, double qy, double qz, double qs) {
        return EuclidCoreTools.atan2(2.0 * (qy * qz + qx * qs), 1.0 - 2.0 * (qx * qx + qy * qy));
    }

    public static double computeYaw(QuaternionReadOnly quaternion) {
        if (quaternion.containsNaN()) {
            return Double.NaN;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double norm = quaternion.norm();
        if (norm < 1.0E-12) {
            return 0.0;
        }
        norm = 1.0 / norm;
        return YawPitchRollConversion.computeYawFromQuaternionImpl(qx *= norm, qy *= norm, qz *= norm, qs *= norm);
    }

    public static double computePitch(QuaternionReadOnly quaternion) {
        if (quaternion.containsNaN()) {
            return Double.NaN;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double norm = quaternion.norm();
        if (norm < 1.0E-12) {
            return 0.0;
        }
        norm = 1.0 / norm;
        return YawPitchRollConversion.computePitchFromQuaternionImpl(qx *= norm, qy *= norm, qz *= norm, qs *= norm);
    }

    public static double computeRoll(QuaternionReadOnly quaternion) {
        if (quaternion.containsNaN()) {
            return Double.NaN;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double norm = quaternion.norm();
        if (norm < 1.0E-12) {
            return 0.0;
        }
        norm = 1.0 / norm;
        return YawPitchRollConversion.computeRollFromQuaternionImpl(qx *= norm, qy *= norm, qz *= norm, qs *= norm);
    }

    public static void convertQuaternionToYawPitchRoll(QuaternionReadOnly quaternion, YawPitchRollBasics yawPitchRollToPack) {
        YawPitchRollConversion.convertQuaternionToYawPitchRoll(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS(), yawPitchRollToPack);
    }

    public static void convertQuaternionToYawPitchRoll(double qx, double qy, double qz, double qs, YawPitchRollBasics yawPitchRollToPack) {
        if (EuclidCoreTools.containsNaN(qx, qy, qz, qs)) {
            yawPitchRollToPack.setToNaN();
            return;
        }
        double norm = EuclidCoreTools.fastNorm(qx, qy, qz, qs);
        if (norm < 1.0E-12) {
            yawPitchRollToPack.setToZero();
            return;
        }
        norm = 1.0 / norm;
        double yaw = YawPitchRollConversion.computeYawFromQuaternionImpl(qx *= norm, qy *= norm, qz *= norm, qs *= norm);
        double pitch = YawPitchRollConversion.computePitchFromQuaternionImpl(qx, qy, qz, qs);
        double roll = YawPitchRollConversion.computeRollFromQuaternionImpl(qx, qy, qz, qs);
        yawPitchRollToPack.set(yaw, pitch, roll);
    }

    public static void convertQuaternionToYawPitchRoll(QuaternionReadOnly quaternion, Tuple3DBasics eulerAnglesToPack) {
        if (quaternion.containsNaN()) {
            eulerAnglesToPack.setToNaN();
            return;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double norm = quaternion.norm();
        if (norm < 1.0E-12) {
            eulerAnglesToPack.setToZero();
            return;
        }
        norm = 1.0 / norm;
        eulerAnglesToPack.set(YawPitchRollConversion.computeRollFromQuaternionImpl(qx *= norm, qy *= norm, qz *= norm, qs *= norm), YawPitchRollConversion.computePitchFromQuaternionImpl(qx, qy, qz, qs), YawPitchRollConversion.computeYawFromQuaternionImpl(qx, qy, qz, qs));
    }

    static double computeYawFromAxisAngleImpl(double ux, double uy, double uz, double angle) {
        double sinTheta = EuclidCoreTools.sin(angle);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double m10 = t * ux * uy + sinTheta * uz;
        double m00 = t * ux * ux + cosTheta;
        return YawPitchRollConversion.computeYawImpl(m00, m10);
    }

    static double computePitchFromAxisAngleImpl(double ux, double uy, double uz, double angle) {
        double m20 = (1.0 - EuclidCoreTools.cos(angle)) * ux * uz - EuclidCoreTools.sin(angle) * uy;
        return YawPitchRollConversion.computePitchImpl(m20);
    }

    static double computeRollFromAxisAngleImpl(double ux, double uy, double uz, double angle) {
        double sinTheta = EuclidCoreTools.sin(angle);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double m21 = t * uy * uz + sinTheta * ux;
        double m22 = t * uz * uz + cosTheta;
        return YawPitchRollConversion.computeRollImpl(m21, m22);
    }

    public static double computeYaw(AxisAngleReadOnly axisAngle) {
        if (axisAngle.containsNaN()) {
            return Double.NaN;
        }
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        double uNorm = axisAngle.axisNorm();
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computeYawFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static double computePitch(AxisAngleReadOnly axisAngle) {
        if (axisAngle.containsNaN()) {
            return Double.NaN;
        }
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        double uNorm = axisAngle.axisNorm();
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computePitchFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static double computeRoll(AxisAngleReadOnly axisAngle) {
        if (axisAngle.containsNaN()) {
            return Double.NaN;
        }
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        double uNorm = axisAngle.axisNorm();
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computeRollFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static void convertAxisAngleToYawPitchRoll(AxisAngleReadOnly axisAngle, YawPitchRollBasics yawPitchRollToPack) {
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll(ux, uy, uz, angle, yawPitchRollToPack);
    }

    public static void convertAxisAngleToYawPitchRoll(double ux, double uy, double uz, double angle, YawPitchRollBasics yawPitchRollToPack) {
        if (EuclidCoreTools.containsNaN(ux, uy, uz, angle)) {
            yawPitchRollToPack.setToNaN();
            return;
        }
        double uNorm = EuclidCoreTools.fastNorm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            yawPitchRollToPack.setToZero();
            return;
        }
        uNorm = 1.0 / uNorm;
        double sinTheta = EuclidCoreTools.sin(angle);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double m20 = t * (ux *= uNorm) * (uz *= uNorm) - sinTheta * (uy *= uNorm);
        double m10 = t * ux * uy + sinTheta * uz;
        double m00 = t * ux * ux + cosTheta;
        double m21 = t * uy * uz + sinTheta * ux;
        double m22 = t * uz * uz + cosTheta;
        double yaw = YawPitchRollConversion.computeYawImpl(m00, m10);
        double pitch = YawPitchRollConversion.computePitchImpl(m20);
        double roll = YawPitchRollConversion.computeRollImpl(m21, m22);
        yawPitchRollToPack.set(yaw, pitch, roll);
    }

    public static void convertAxisAngleToYawPitchRoll(AxisAngleReadOnly axisAngle, Tuple3DBasics eulerAnglesToPack) {
        if (axisAngle.containsNaN()) {
            eulerAnglesToPack.setToNaN();
            return;
        }
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        double uNorm = EuclidCoreTools.fastNorm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            eulerAnglesToPack.setToZero();
            return;
        }
        uNorm = 1.0 / uNorm;
        YawPitchRollConversion.convertAxisAngleToYawPitchRollImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle, eulerAnglesToPack);
    }

    static void convertAxisAngleToYawPitchRollImpl(double ux, double uy, double uz, double angle, Tuple3DBasics eulerAnglesToPack) {
        double sinTheta = EuclidCoreTools.sin(angle);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double m20 = t * ux * uz - sinTheta * uy;
        double m10 = t * ux * uy + sinTheta * uz;
        double m00 = t * ux * ux + cosTheta;
        double m21 = t * uy * uz + sinTheta * ux;
        double m22 = t * uz * uz + cosTheta;
        eulerAnglesToPack.set(YawPitchRollConversion.computeRollImpl(m21, m22), YawPitchRollConversion.computePitchImpl(m20), YawPitchRollConversion.computeYawImpl(m00, m10));
    }

    public static double computeYaw(Vector3DReadOnly rotationVector) {
        if (rotationVector.containsNaN()) {
            return Double.NaN;
        }
        double ux = rotationVector.getX();
        double uy = rotationVector.getY();
        double uz = rotationVector.getZ();
        double angle = 0.0;
        double uNorm = EuclidCoreTools.norm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        angle = uNorm;
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computeYawFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static double computePitch(Vector3DReadOnly rotationVector) {
        double uNorm;
        if (rotationVector.containsNaN()) {
            return Double.NaN;
        }
        double ux = rotationVector.getX();
        double uy = rotationVector.getY();
        double uz = rotationVector.getZ();
        double angle = 0.0;
        angle = uNorm = EuclidCoreTools.norm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computePitchFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static double computeRoll(Vector3DReadOnly rotationVector) {
        if (rotationVector.containsNaN()) {
            return Double.NaN;
        }
        double ux = rotationVector.getX();
        double uy = rotationVector.getY();
        double uz = rotationVector.getZ();
        double angle = 0.0;
        double uNorm = EuclidCoreTools.norm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            return 0.0;
        }
        angle = uNorm;
        uNorm = 1.0 / uNorm;
        return YawPitchRollConversion.computeRollFromAxisAngleImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle);
    }

    public static void convertRotationVectorToYawPitchRoll(Vector3DReadOnly rotationVector, YawPitchRollBasics yawPitchRollToPack) {
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll(rotationVector.getX(), rotationVector.getY(), rotationVector.getZ(), yawPitchRollToPack);
    }

    public static void convertRotationVectorToYawPitchRoll(double rx, double ry, double rz, YawPitchRollBasics yawPitchRollToPack) {
        if (EuclidCoreTools.containsNaN(rx, ry, rz)) {
            yawPitchRollToPack.setToNaN();
            return;
        }
        double angle = EuclidCoreTools.norm(rx, ry, rz);
        if (angle < 1.0E-12) {
            yawPitchRollToPack.setToZero();
            return;
        }
        double uNorm = 1.0 / angle;
        double ux = rx * uNorm;
        double uy = ry * uNorm;
        double uz = rz * uNorm;
        double sinTheta = EuclidCoreTools.sin(angle);
        double cosTheta = EuclidCoreTools.cos(angle);
        double t = 1.0 - cosTheta;
        double m20 = t * ux * uz - sinTheta * uy;
        double m10 = t * ux * uy + sinTheta * uz;
        double m00 = t * ux * ux + cosTheta;
        double m21 = t * uy * uz + sinTheta * ux;
        double m22 = t * uz * uz + cosTheta;
        double yaw = YawPitchRollConversion.computeYawImpl(m00, m10);
        double pitch = YawPitchRollConversion.computePitchImpl(m20);
        double roll = YawPitchRollConversion.computeRollImpl(m21, m22);
        yawPitchRollToPack.set(yaw, pitch, roll);
    }

    public static void convertRotationVectorToYawPitchRoll(Vector3DReadOnly rotationVector, Vector3DBasics eulerAnglesToPack) {
        if (rotationVector.containsNaN()) {
            eulerAnglesToPack.setToNaN();
            return;
        }
        double ux = rotationVector.getX();
        double uy = rotationVector.getY();
        double uz = rotationVector.getZ();
        double angle = 0.0;
        double uNorm = EuclidCoreTools.norm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            eulerAnglesToPack.setToZero();
            return;
        }
        angle = uNorm;
        uNorm = 1.0 / uNorm;
        YawPitchRollConversion.convertAxisAngleToYawPitchRollImpl(ux *= uNorm, uy *= uNorm, uz *= uNorm, angle, eulerAnglesToPack);
    }
}

