/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameTuple2DBasicsTest;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FrameVector2DTest
extends FrameTuple2DBasicsTest<FrameVector2D> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Override
    public Tuple2DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextVector2D((Random)random);
    }

    @Override
    public FrameVector2D createFrameTuple(ReferenceFrame referenceFrame, double x, double y) {
        return new FrameVector2D(referenceFrame, x, y);
    }

    @Test
    public void testConstructors() throws Exception {
        FrameVector2D frameVector2D;
        Vector2D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FrameVector2D frameVector2D2 = new FrameVector2D();
        Assertions.assertTrue((frameVector2D2.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)frameVector2D2);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector2D frameVector2D3 = new FrameVector2D(randomFrame);
            Assertions.assertTrue((frameVector2D3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)frameVector2D3);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector2D = new FrameVector2D(randomFrame, (randomTuple = EuclidCoreRandomTools.nextVector2D((Random)random)).getX(), randomTuple.getY());
            Assertions.assertTrue((frameVector2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            FrameVector2D frameVector2D4 = new FrameVector2D(randomFrame, array);
            Assertions.assertTrue((frameVector2D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector2D4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector2D = new FrameVector2D(randomFrame, (Tuple3DReadOnly)(randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random)));
            Assertions.assertTrue((frameVector2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D((Tuple3DReadOnly)randomTuple), (EuclidGeometry)frameVector2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D randomTuple2D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector2D = new FrameVector2D(randomFrame, (Tuple2DReadOnly)(randomTuple2D = EuclidCoreRandomTools.nextVector2D((Random)random)));
            Assertions.assertTrue((frameVector2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple2D, (EuclidGeometry)frameVector2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector2D randomFrameTuple2D = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)randomFrame);
            frameVector2D = new FrameVector2D((FrameTuple2DReadOnly)randomFrameTuple2D);
            Assertions.assertTrue((frameVector2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomFrameTuple2D, (EuclidGeometry)frameVector2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            frameVector2D = new FrameVector2D((FrameTuple3DReadOnly)randomTuple);
            Assertions.assertTrue((frameVector2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D((Tuple3DReadOnly)randomTuple), (EuclidGeometry)frameVector2D, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector2D, 10);
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FramePoint2D source = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector2D actual = (FrameVector2D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source);
            FrameVector2D expected = new FrameVector2D((FrameTuple2DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            double x = EuclidCoreRandomTools.nextDouble((Random)random);
            double y = EuclidCoreRandomTools.nextDouble((Random)random);
            FrameVector2D actual = (FrameVector2D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame(sourceFrame, x, y);
            FrameVector2D expected = new FrameVector2D();
            expected.setIncludingFrame(sourceFrame, x, y);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
    }

    @Override
    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector2D, 10);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (boolean)true);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            FrameVector2D actual = new FrameVector2D(initialFrame, (Tuple2DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testChangeFrameAndProjectToXYPlane() throws Exception {
        Random random = new Random(345345L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            FrameVector2D actual = new FrameVector2D(initialFrame, (Tuple2DReadOnly)expected);
            expected.applyTransform((Transform)initialFrame.getTransformToDesiredFrame(newFrame), false);
            actual.changeFrameAndProjectToXYPlane(newFrame);
            Assertions.assertTrue((newFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FrameVector2D frameVector1 = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)worldFrame);
            FrameVector2D frameVector2 = new FrameVector2D(worldFrame);
            double epsilon = random.nextDouble();
            Vector2D difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            frameVector2.add((FrameTuple2DReadOnly)frameVector1, (Tuple2DReadOnly)difference);
            Assertions.assertTrue((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
            difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            frameVector2.add((FrameTuple2DReadOnly)frameVector1, (Tuple2DReadOnly)difference);
            Assertions.assertFalse((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FrameVector2D tuple = new FrameVector2D();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setReferenceFrame(frames[random.nextInt(frames.length)]);
        int newHashCode = tuple.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple.hashCode());
        int previousHashCode = tuple.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple.setElement(i % 2, random.nextDouble());
            newHashCode = tuple.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = tuple.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            tuple.setReferenceFrame(newFrame);
            newHashCode = tuple.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Vector2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Vector2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Vector2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameVector2D.class, Vector2D.class, true, 1, methodFilter);
    }
}

