/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple2DBasicsTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePoint2DTest
extends FrameTuple2DBasicsTest<FramePoint2D> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Override
    public Tuple2DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint2D((Random)random);
    }

    @Override
    public FramePoint2D createFrameTuple(ReferenceFrame referenceFrame, double x, double y) {
        return new FramePoint2D(referenceFrame, x, y);
    }

    @Override
    @Test
    public void testConsistencyWithTuple2D() throws Exception {
        super.testConsistencyWithTuple2D();
    }

    @Test
    public void testConstructors() throws Exception {
        FramePoint2D framePoint2D;
        Point2D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FramePoint2D framePoint2D2 = new FramePoint2D();
        Assertions.assertTrue((framePoint2D2.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)framePoint2D2);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint2D framePoint2D3 = new FramePoint2D(randomFrame);
            Assertions.assertTrue((framePoint2D3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)framePoint2D3);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint2D = new FramePoint2D(randomFrame, (randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random)).getX(), randomTuple.getY());
            Assertions.assertTrue((framePoint2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)framePoint2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            FramePoint2D framePoint2D4 = new FramePoint2D(randomFrame, array);
            Assertions.assertTrue((framePoint2D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)framePoint2D4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint2D = new FramePoint2D(randomFrame, (Tuple2DReadOnly)(randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random)));
            Assertions.assertTrue((framePoint2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)framePoint2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D randomTuple3D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint2D = new FramePoint2D(randomFrame, (Tuple3DReadOnly)(randomTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random)));
            Assertions.assertTrue((framePoint2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D((Tuple3DReadOnly)randomTuple3D), (EuclidGeometry)framePoint2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint3D randomFrameTuple3D = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomFrame);
            framePoint2D = new FramePoint2D((FrameTuple3DReadOnly)randomFrameTuple3D);
            Assertions.assertTrue((framePoint2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D((Tuple3DReadOnly)randomFrameTuple3D), (EuclidGeometry)framePoint2D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)randomFrame);
            framePoint2D = new FramePoint2D((FrameTuple2DReadOnly)randomTuple);
            Assertions.assertTrue((framePoint2D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)framePoint2D, (double)1.0E-15);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)randomTuple, (EuclidFrameGeometry)framePoint2D, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePoint2D, 10);
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FramePoint2D source = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)sourceFrame);
            FramePoint2D actual = (FramePoint2D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source);
            FramePoint2D expected = new FramePoint2D((FrameTuple2DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            double x = EuclidCoreRandomTools.nextDouble((Random)random);
            double y = EuclidCoreRandomTools.nextDouble((Random)random);
            FramePoint2D actual = (FramePoint2D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame(sourceFrame, x, y);
            FramePoint2D expected = new FramePoint2D();
            expected.setIncludingFrame(sourceFrame, x, y);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (boolean)true);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Point2D expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
            FramePoint2D actual = new FramePoint2D(initialFrame, (Tuple2DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testChangeFrameAndProjectToXYPlane() throws Exception {
        Random random = new Random(345345L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Point2D expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
            FramePoint2D actual = new FramePoint2D(initialFrame, (Tuple2DReadOnly)expected);
            expected.applyTransform((Transform)initialFrame.getTransformToDesiredFrame(newFrame), false);
            actual.changeFrameAndProjectToXYPlane(newFrame);
            Assertions.assertTrue((newFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (boolean)true);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FramePoint2D expected = (FramePoint2D)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            FramePoint2D actual = (FramePoint2D)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FramePoint2D framePoint1 = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame);
            FramePoint2D framePoint2 = new FramePoint2D(worldFrame);
            double epsilon = random.nextDouble();
            Vector2D difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            framePoint2.add((FrameTuple2DReadOnly)framePoint1, (Tuple2DReadOnly)difference);
            Assertions.assertTrue((boolean)framePoint1.geometricallyEquals((EuclidFrameGeometry)framePoint2, epsilon));
            difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            framePoint2.add((FrameTuple2DReadOnly)framePoint1, (Tuple2DReadOnly)difference);
            Assertions.assertFalse((boolean)framePoint1.geometricallyEquals((EuclidFrameGeometry)framePoint2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FramePoint2D tuple = new FramePoint2D();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setReferenceFrame(frames[random.nextInt(frames.length)]);
        int newHashCode = tuple.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple.hashCode());
        int previousHashCode = tuple.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple.setElement(i % 2, random.nextDouble());
            newHashCode = tuple.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = tuple.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            tuple.setReferenceFrame(newFrame);
            newHashCode = tuple.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Point2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Point2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Point2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePoint2D.class, Point2D.class, true, 1, methodFilter);
    }

    @Override
    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePoint2D, 10);
    }
}

