/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.AxisAngleBasicsTest;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class AxisAngleTest
extends AxisAngleBasicsTest<AxisAngle> {
    public static final double EPS = 1.0E-15;

    @Test
    public void testAxisAngle() {
        AxisAngle expected;
        int i;
        Random random = new Random(613615L);
        AxisAngle axisAngle = new AxisAngle();
        Assertions.assertTrue((axisAngle.getX() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            axisAngle = expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle axisAngle2 = new AxisAngle((Orientation3DReadOnly)axisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)axisAngle2, (double)1.0E-15);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            axisAngle = new AxisAngle(expected.getX(), expected.getY(), expected.getZ(), expected.getAngle());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            double[] axisAngleArrayCopy = new double[]{expected.getX(), expected.getY(), expected.getZ(), expected.getAngle()};
            double[] axisAngleArray = axisAngleArrayCopy;
            axisAngle = new AxisAngle(axisAngleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-15);
            for (int j = 0; j < axisAngleArray.length; ++j) {
                Assertions.assertTrue((axisAngleArray[j] == axisAngleArrayCopy[j] ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            double angle;
            UnitVector3D vectorAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            axisAngle = new AxisAngle((Vector3DReadOnly)vectorAxis, angle = random.nextDouble());
            Assertions.assertTrue((axisAngle.getX() == vectorAxis.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY() == vectorAxis.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ() == vectorAxis.getZ() ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle() == angle ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternionCopy;
            Quaternion quaternion = quaternionCopy = EuclidCoreRandomTools.nextQuaternion((Random)random);
            axisAngle = new AxisAngle((Orientation3DReadOnly)quaternion);
            AxisAngle expectedAxisAngle = new AxisAngle();
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle, (double)1.0E-15);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)quaternionCopy, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            double angleCopy;
            RotationMatrix matrixCopy;
            RotationMatrix matrix = matrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double angle = angleCopy = random.nextDouble();
            axisAngle = new AxisAngle((Orientation3DReadOnly)matrix);
            AxisAngle expectedAxisAngle = new AxisAngle();
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)matrix, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle, (double)1.0E-15);
            Assertions.assertTrue((angle == angleCopy ? 1 : 0) != 0);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrixCopy, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVectorCopy;
            Vector3D rotationVector = rotationVectorCopy = EuclidCoreRandomTools.nextRotationVector((Random)random);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationVector);
            AxisAngle expectedAxisAngle = new AxisAngle();
            AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)rotationVector, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle, (double)1.0E-15);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)rotationVector, (Vector3DReadOnly)rotationVectorCopy, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            axisAngle = new AxisAngle(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
            AxisAngle expectedAxisAngle = new AxisAngle();
            AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yawPitchRoll.getYaw(), (double)yawPitchRoll.getPitch(), (double)yawPitchRoll.getRoll(), (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle, (double)1.0E-15);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        int newHashCode = axisAngle.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)axisAngle.hashCode());
        int previousHashCode = axisAngle.hashCode();
        for (int i = 0; i < 1000; ++i) {
            axisAngle.setElement(random.nextInt(4), random.nextDouble());
            newHashCode = axisAngle.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(35454L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            AxisAngle aabA = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), epsilon + random.nextDouble() - random.nextDouble());
            AxisAngle aabB = new AxisAngle((Orientation3DReadOnly)aa);
            aabB.preMultiply((AxisAngleReadOnly)aabA);
            if (aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon)) {
                Assertions.assertTrue((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
                continue;
            }
            Assertions.assertFalse((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
        }
    }

    @Override
    public AxisAngle createEmptyAxisAngle() {
        return new AxisAngle();
    }

    @Override
    public AxisAngle createAxisAngle(Vector3DReadOnly axis, double angle) {
        return new AxisAngle(axis, angle);
    }

    @Override
    public AxisAngle createAxisAngle(double ux, double uy, double uz, double angle) {
        return new AxisAngle(ux, uy, uz, angle);
    }

    @Override
    public AxisAngle createRandomAxisAngle(Random random) {
        return EuclidCoreRandomTools.nextAxisAngle((Random)random);
    }

    @Override
    public double getEpsilon() {
        return 1.1E-12;
    }

    @Override
    public double getSmallestEpsilon() {
        return 1.0E-15;
    }
}

