/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class EuclidCoreToolsTest {
    private static final int iters = 1000;

    @Test
    public void testConstants() {
        Point2D expectedOrigin2D = new Point2D();
        Assertions.assertEquals((Object)expectedOrigin2D, (Object)EuclidCoreTools.origin2D);
        Assertions.assertEquals((int)expectedOrigin2D.hashCode(), (int)EuclidCoreTools.origin2D.hashCode());
        Assertions.assertEquals((Object)expectedOrigin2D.toString(), (Object)EuclidCoreTools.origin2D.toString());
        Point3D expectedOrigin3D = new Point3D();
        Assertions.assertEquals((Object)expectedOrigin3D, (Object)EuclidCoreTools.origin3D);
        Assertions.assertEquals((int)expectedOrigin3D.hashCode(), (int)EuclidCoreTools.origin3D.hashCode());
        Assertions.assertEquals((Object)expectedOrigin3D.toString(), (Object)EuclidCoreTools.origin3D.toString());
        Vector2D expectedZeroVector2D = new Vector2D();
        Assertions.assertEquals((Object)expectedZeroVector2D, (Object)EuclidCoreTools.zeroVector2D);
        Assertions.assertEquals((int)expectedZeroVector2D.hashCode(), (int)EuclidCoreTools.zeroVector2D.hashCode());
        Assertions.assertEquals((Object)expectedZeroVector2D.toString(), (Object)EuclidCoreTools.zeroVector2D.toString());
        Vector3D expectedZeroVector3D = new Vector3D();
        Assertions.assertEquals((Object)expectedZeroVector3D, (Object)EuclidCoreTools.zeroVector3D);
        Assertions.assertEquals((int)expectedZeroVector3D.hashCode(), (int)EuclidCoreTools.zeroVector3D.hashCode());
        Assertions.assertEquals((Object)expectedZeroVector3D.toString(), (Object)EuclidCoreTools.zeroVector3D.toString());
        Vector4D expectedQuaternion = new Vector4D();
        expectedQuaternion.setElement(3, 1.0);
        Assertions.assertEquals((Object)expectedQuaternion, (Object)EuclidCoreTools.neutralQuaternion);
        Assertions.assertEquals((int)expectedQuaternion.hashCode(), (int)EuclidCoreTools.neutralQuaternion.hashCode());
        Assertions.assertEquals((Object)expectedQuaternion.toString(), (Object)EuclidCoreTools.neutralQuaternion.toString());
        Matrix3D expectedZeroMatrix3D = new Matrix3D();
        expectedZeroMatrix3D.setToZero();
        Assertions.assertEquals((Object)expectedZeroMatrix3D, (Object)EuclidCoreTools.zeroMatrix3D);
        Assertions.assertEquals((Object)expectedZeroMatrix3D.toString(), (Object)EuclidCoreTools.zeroMatrix3D.toString());
        Assertions.assertEquals((int)expectedZeroMatrix3D.hashCode(), (int)EuclidCoreTools.zeroMatrix3D.hashCode());
        Matrix3D expectedIdentity3D = new Matrix3D();
        expectedIdentity3D.setIdentity();
        Assertions.assertEquals((Object)expectedIdentity3D, (Object)EuclidCoreTools.identityMatrix3D);
        Assertions.assertEquals((Object)expectedIdentity3D.toString(), (Object)EuclidCoreTools.identityMatrix3D.toString());
        Assertions.assertEquals((int)expectedIdentity3D.hashCode(), (int)EuclidCoreTools.identityMatrix3D.hashCode());
    }

    @Test
    public void testFastSquareRoot() {
        double expectedValue;
        double actualValue;
        double squaredValue;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            squaredValue = 1.5 * random.nextDouble();
            squaredValue = Math.min(squaredValue, 0.99999997892658);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
        for (i = 0; i < 1000; ++i) {
            squaredValue = 0.8 + 1.5 * random.nextDouble();
            squaredValue = Math.max(squaredValue, 1.00000002107342);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
        for (i = 0; i < 1000; ++i) {
            squaredValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.99999997892658, (double)1.00000002107342);
            squaredValue = Math.max(squaredValue, 1.00000002107342);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testContainsNaNWith2Elements() {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith3Elements() {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith4Elements() {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith9Elements() {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWithArray() {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double[])new double[0]));
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN}));
    }

    @Test
    public void testNormSquaredWith2Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-1.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)2.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)-2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-2.0));
    }

    @Test
    public void testNormSquaredWith3Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-2.0));
    }

    @Test
    public void testNormSquaredWith4Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)-1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)-2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)4.0, (double)EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)-2.0));
    }

    @Test
    public void testNormWith2Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)-2.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-2.0));
    }

    @Test
    public void testNormWith3Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-2.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-2.0));
    }

    @Test
    public void testNormWith4Elements() {
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)-1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)-2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)-2.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        Assertions.assertEquals((double)0.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)-1.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-1.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-1.0, (double)0.0));
        Assertions.assertEquals((double)1.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)-1.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)2.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)-2.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)-2.0, (double)0.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-2.0, (double)0.0));
        Assertions.assertEquals((double)2.0, (double)EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)-2.0));
    }

    @Test
    public void testTrimAngleMinusPiToPi() {
        Random random = new Random(2323L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = -Math.PI;
            double endOfRange = Math.PI;
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12, (String)("iteration: " + i));
            expectedAngle = startOfRange;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
            expectedAngle = endOfRange - 1.0E-9;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleDifferenceMinusPiToPi() {
        Random random = new Random(2323L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = -Math.PI;
            double endOfRange = Math.PI;
            double expectedDifference = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double untrimmedDifference = expectedDifference + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            double angleB = angleA - untrimmedDifference;
            double actualDifference = EuclidCoreTools.angleDifferenceMinusPiToPi((double)angleA, (double)angleB);
            Assertions.assertEquals((double)expectedDifference, (double)actualDifference, (double)1.0E-12, (String)("iteration: " + i));
        }
    }

    @Test
    public void testShiftAngleInRange() {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            double endOfRange = startOfRange + Math.PI * 2;
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12, (String)("iteration: " + i));
            expectedAngle = startOfRange;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
            expectedAngle = endOfRange - 1.0E-9;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleGeometricallyEquals() {
        double angleA;
        double epsilon;
        int i;
        Random random = new Random(35635L);
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 10));
            double angleNotEqual = angleA + (random.nextBoolean() ? -1.01 : 1.01) * epsilon;
            double angleEqual = angleA + (random.nextBoolean() ? -0.99 : 0.99) * epsilon;
            Assertions.assertFalse((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleNotEqual, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleEqual, (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 10));
            double twoPIMutiple = (double)random.nextInt(15) * 2.0 * Math.PI;
            if (random.nextBoolean()) {
                twoPIMutiple = -twoPIMutiple;
            }
            double angleNotEqual = angleA + (random.nextBoolean() ? -1.01 : 1.01) * epsilon + twoPIMutiple;
            double angleEqual = angleA + (random.nextBoolean() ? -0.99 : 0.99) * epsilon + twoPIMutiple;
            Assertions.assertFalse((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleNotEqual, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleEqual, (double)epsilon));
        }
    }

    @Test
    public void testIsAngleZero() {
        Random random = new Random(35635L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            double twoPIMutiple = (double)random.nextInt(15) * 2.0 * Math.PI;
            double zeroAngle = 0.99 * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            double nonZeroAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(1.01 * epsilon), (double)Math.PI);
            if (random.nextBoolean()) {
                nonZeroAngle = -nonZeroAngle;
            }
            Assertions.assertTrue((boolean)EuclidCoreTools.isAngleZero((double)zeroAngle, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.isAngleZero((double)(zeroAngle + twoPIMutiple), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.isAngleZero((double)nonZeroAngle, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.isAngleZero((double)(nonZeroAngle + twoPIMutiple), (double)epsilon));
        }
    }

    @Test
    public void testMax() {
        double c;
        double b;
        double a;
        int i;
        Random random = new Random(45645L);
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.max(a, Math.max(b, c));
            double actual = EuclidCoreTools.max((double)a, (double)b, (double)c);
            Assertions.assertEquals((double)expected, (double)actual);
        }
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.max(a, Math.max(b, Math.max(c, d)));
            double actual = EuclidCoreTools.max((double)a, (double)b, (double)c, (double)d);
            Assertions.assertEquals((double)expected, (double)actual);
        }
    }

    @Test
    public void testMin() {
        double c;
        double b;
        double a;
        int i;
        Random random = new Random(45645L);
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.min(a, Math.min(b, c));
            double actual = EuclidCoreTools.min((double)a, (double)b, (double)c);
            Assertions.assertEquals((double)expected, (double)actual);
        }
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.min(a, Math.min(b, Math.min(c, d)));
            double actual = EuclidCoreTools.min((double)a, (double)b, (double)c, (double)d);
            Assertions.assertEquals((double)expected, (double)actual);
        }
    }

    @Test
    public void testMed() {
        Random random = new Random(45645L);
        for (int i = 0; i < 1000; ++i) {
            double a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double[] sorted = new double[]{a, b, c};
            Arrays.sort(sorted);
            double expected = sorted[1];
            double actual = EuclidCoreTools.med((double)a, (double)b, (double)c);
            if (expected != actual) {
                EuclidCoreTools.med((double)a, (double)b, (double)c);
            }
            Assertions.assertEquals((double)expected, (double)actual, (String)("a = " + a + ", b = " + b + ", c = " + c));
        }
    }

    @Test
    public void testEpsilonEquals() {
        double epsilon;
        int i;
        Random random = new Random(34235L);
        for (i = 0; i < 1000; ++i) {
            epsilon = 0.0;
            double value = EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)value, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)Math.nextUp(value), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)Math.nextDown(value), (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            double expectedValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32);
            double actualValue = expectedValue + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)epsilon);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)epsilon);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue + EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(10.0 * epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue - EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(10.0 * epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NaN, (double)Double.NaN, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NaN, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.NaN, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.POSITIVE_INFINITY, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.POSITIVE_INFINITY, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NEGATIVE_INFINITY, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.NEGATIVE_INFINITY, (double)epsilon));
        }
    }

    @Test
    public void testInterpolate() {
        Random random = new Random(3665L);
        for (int i = 0; i < 1000; ++i) {
            double a = random.nextDouble();
            double b = random.nextDouble();
            double alpha = random.nextDouble();
            double result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            double expected = a + alpha * (b - a);
            Assertions.assertEquals((double)result, (double)expected, (double)1.0E-10);
            alpha = 0.5;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertEquals((double)result, (double)(0.5 * a + 0.5 * b));
            alpha = 0.0;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertEquals((double)result, (double)a);
            alpha = 1.0;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertEquals((double)result, (double)b);
            for (alpha = -2.0; alpha <= 2.0; alpha += 0.1) {
                result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
                Assertions.assertEquals((double)result, (double)(a + alpha * (b - a)), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testClamp() {
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            double minMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)minMax);
            double valueUnder = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)0.0) - minMax;
            double valueOver = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0) + minMax;
            Assertions.assertEquals((double)valueInside, (double)EuclidCoreTools.clamp((double)valueInside, (double)minMax));
            Assertions.assertEquals((double)(-minMax), (double)EuclidCoreTools.clamp((double)valueUnder, (double)minMax));
            Assertions.assertEquals((double)minMax, (double)EuclidCoreTools.clamp((double)valueOver, (double)minMax));
        }
        EuclidCoreTestTools.assertExceptionIsThrown(() -> EuclidCoreTools.clamp((double)0.0, (double)-1.01E-10), (Class[])new Class[]{RuntimeException.class});
        for (i = 0; i < 1000; ++i) {
            double min = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)100.0);
            double max = min + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max);
            double valueUnder = min - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueOver = max + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            Assertions.assertEquals((double)valueInside, (double)EuclidCoreTools.clamp((double)valueInside, (double)min, (double)max));
            Assertions.assertEquals((double)min, (double)EuclidCoreTools.clamp((double)valueUnder, (double)min, (double)max));
            Assertions.assertEquals((double)max, (double)EuclidCoreTools.clamp((double)valueOver, (double)min, (double)max));
        }
        double min = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)100.0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> EuclidCoreTools.clamp((double)0.0, (double)min, (double)(min - 1.0E-10 - 1.0E-12)), (Class[])new Class[]{RuntimeException.class});
    }

    @Test
    public void testFastAcos() {
        double error;
        double actual;
        double expected;
        double x;
        double epsilon = 1.0E-14;
        double maxError = 0.0;
        double maxErrorX = 0.0;
        for (x = -1.0; x < 1.0; x += 1.0E-6) {
            expected = Math.acos(x);
            actual = EuclidCoreTools.fastAcos((double)x);
            Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
            error = Math.abs(actual - expected);
            if (!(error > maxError)) continue;
            maxError = error;
            maxErrorX = x;
        }
        x = -1.0;
        expected = Math.acos(x);
        actual = EuclidCoreTools.fastAcos((double)x);
        Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
        error = Math.abs(actual - expected);
        if (error > maxError) {
            maxError = error;
            maxErrorX = x;
        }
        x = 1.0;
        expected = Math.acos(x);
        actual = EuclidCoreTools.fastAcos((double)x);
        Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
        error = Math.abs(actual - expected);
        if (error > maxError) {
            maxError = error;
            maxErrorX = x;
        }
        System.out.println("EuclidCoreToolsTest.testFastAcos: max error=" + maxError + " at x=" + maxErrorX);
    }

    @Test
    public void testReverse() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Integer> originalList = new ArrayList<Integer>();
            int size = random.nextInt(20);
            while (originalList.size() < size) {
                originalList.add(originalList.size());
            }
            int fromIndex = size == 0 ? 0 : random.nextInt(size);
            int toIndex = size == 0 ? 0 : fromIndex + random.nextInt(originalList.size() - fromIndex);
            ArrayList expected = new ArrayList(originalList);
            Collections.reverse(expected.subList(fromIndex, toIndex));
            ArrayList actual = new ArrayList(originalList);
            EuclidCoreTools.reverse(actual, (int)fromIndex, (int)toIndex);
            Assertions.assertEquals(expected, actual);
        }
    }

    @Test
    public void testRotate() {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Integer> originalList = new ArrayList<Integer>();
            int shift = random.nextInt(100);
            int size = random.nextInt(100);
            while (originalList.size() < size) {
                originalList.add(originalList.size());
            }
            int fromIndex = size == 0 ? 0 : random.nextInt(size);
            int toIndex = size == 0 ? 0 : fromIndex + random.nextInt(originalList.size() - fromIndex);
            int subSize = toIndex - fromIndex;
            ArrayList<Integer> expectedList = new ArrayList<Integer>(originalList);
            for (int j = fromIndex; j < toIndex; ++j) {
                int originalIndex = EuclidCoreTools.wrap((int)(j - fromIndex - shift), (int)subSize) + fromIndex;
                expectedList.set(j, (Integer)originalList.get(originalIndex));
            }
            ArrayList actualList = new ArrayList(originalList);
            EuclidCoreTools.rotate(actualList, (int)fromIndex, (int)toIndex, (int)shift);
            Assertions.assertEquals(expectedList, actualList);
            expectedList = new ArrayList(originalList);
            Collections.rotate(expectedList.subList(fromIndex, toIndex), shift);
            Assertions.assertEquals(expectedList, actualList);
        }
        List<Integer> list = Arrays.asList(0, 1, 2, 3, 4);
        EuclidCoreTools.rotate(list, (int)0, (int)list.size(), (int)-1);
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 0), list);
        list = Arrays.asList(0, 1, 2, 3, 4);
        EuclidCoreTools.rotate(list, (int)0, (int)list.size(), (int)1);
        Assertions.assertEquals(Arrays.asList(4, 0, 1, 2, 3), list);
        list = Arrays.asList(9, 0, 1, 2, 9);
        EuclidCoreTools.rotate(list, (int)1, (int)4, (int)-1);
        Assertions.assertEquals(Arrays.asList(9, 1, 2, 0, 9), list);
        list = Arrays.asList(9, 0, 1, 2, 9);
        EuclidCoreTools.rotate(list, (int)1, (int)4, (int)1);
        Assertions.assertEquals(Arrays.asList(9, 2, 0, 1, 9), list);
    }

    @Test
    public void testFiniteDifference() {
        Vector2D actualVelocity;
        Vector2D expectedVelocity;
        double actualVelocity2;
        double expectedVelocity2;
        double dt;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double prevDouble = random.nextDouble();
            expectedVelocity2 = EuclidCoreRandomTools.nextDouble((Random)random);
            double nextDouble = prevDouble + dt * expectedVelocity2;
            actualVelocity2 = EuclidCoreTools.finiteDifference((double)prevDouble, (double)nextDouble, (double)dt);
            Assertions.assertEquals((double)expectedVelocity2, (double)actualVelocity2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double prevAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            expectedVelocity2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            double nextAngle = prevAngle + dt * expectedVelocity2;
            actualVelocity2 = EuclidCoreTools.finiteDifference((double)prevAngle, (double)nextAngle, (double)dt);
            Assertions.assertEquals((double)expectedVelocity2, (double)actualVelocity2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D prevTuple = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedVelocity = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D nextTuple = new Point2D();
            nextTuple.scaleAdd(dt, (Tuple2DReadOnly)expectedVelocity, (Tuple2DReadOnly)prevTuple);
            actualVelocity = new Vector2D();
            EuclidCoreTools.finiteDifference((Tuple2DReadOnly)prevTuple, (Tuple2DReadOnly)nextTuple, (double)dt, (Vector2DBasics)actualVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVelocity, (EuclidGeometry)actualVelocity, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D prevTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expectedVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D nextTuple = new Point3D();
            nextTuple.scaleAdd(dt, (Tuple3DReadOnly)expectedVelocity, (Tuple3DReadOnly)prevTuple);
            actualVelocity = new Vector3D();
            EuclidCoreTools.finiteDifference((Tuple3DReadOnly)prevTuple, (Tuple3DReadOnly)nextTuple, (double)dt, (Vector3DBasics)actualVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVelocity, (EuclidGeometry)actualVelocity, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Vector4D prevTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            expectedVelocity = EuclidCoreRandomTools.nextVector4D((Random)random);
            Vector4D nextTuple = new Vector4D();
            nextTuple.scaleAdd(dt, (Tuple4DReadOnly)expectedVelocity, (Tuple4DReadOnly)prevTuple);
            actualVelocity = new Vector4D();
            EuclidCoreTools.finiteDifference((Tuple4DReadOnly)prevTuple, (Tuple4DReadOnly)nextTuple, (double)dt, (Vector4DBasics)actualVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVelocity, (EuclidGeometry)actualVelocity, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Orientation2D previousOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            Orientation2D currentOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            double expectedAngularVelocity = EuclidCoreTools.finiteDifferenceAngle((double)previousOrientation.getYaw(), (double)currentOrientation.getYaw(), (double)dt);
            double actualAngularVelocity = EuclidCoreTools.finiteDifference((Orientation2DReadOnly)previousOrientation, (Orientation2DReadOnly)currentOrientation, (double)dt);
            Assertions.assertEquals((double)expectedAngularVelocity, (double)actualAngularVelocity, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Quaternion currentOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion nextOrientation = new Quaternion();
            Vector3D expectedAngularVelocityWorld = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expectedAngularVelocityLocalCurrent = new Vector3D();
            currentOrientation.inverseTransform((Tuple3DReadOnly)expectedAngularVelocityWorld, (Tuple3DBasics)expectedAngularVelocityLocalCurrent);
            AxisAngle diff = new AxisAngle();
            diff.setAngle(expectedAngularVelocityLocalCurrent.norm() * dt);
            diff.getAxis().set((Tuple3DReadOnly)expectedAngularVelocityLocalCurrent);
            nextOrientation.set((QuaternionReadOnly)currentOrientation);
            nextOrientation.append((Orientation3DReadOnly)diff);
            Vector3D expectedAngularVelocityLocalNext = new Vector3D();
            nextOrientation.inverseTransform((Tuple3DReadOnly)expectedAngularVelocityWorld, (Tuple3DBasics)expectedAngularVelocityLocalNext);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocityLocalNext, (EuclidGeometry)expectedAngularVelocityLocalCurrent, (double)1.0E-12);
            Vector3D actualAngularVelocity = new Vector3D();
            QuaternionTools.finiteDifference((QuaternionReadOnly)currentOrientation, (QuaternionReadOnly)nextOrientation, (double)dt, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i + ", angular distance: " + nextOrientation.distance((Orientation3DReadOnly)currentOrientation) + ", velocity error: " + actualAngularVelocity.differenceNorm((Tuple3DReadOnly)expectedAngularVelocityLocalNext)), (EuclidGeometry)expectedAngularVelocityLocalNext, (EuclidGeometry)actualAngularVelocity, (double)2.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), dt, 1.0E-11, i);
            EuclidCoreToolsTest.compareFiniteDifference((Orientation3DReadOnly)EuclidCoreRandomTools.nextOrientation3D((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextOrientation3D((Random)random), dt, 1.0E-11, i);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            RigidBodyTransform prevTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform diff = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform currTransform = new RigidBodyTransform();
            currTransform.set(prevTransform);
            currTransform.multiply((RigidBodyTransformReadOnly)diff);
            Vector3D expectedLinearVelocity = new Vector3D();
            expectedLinearVelocity.set((Tuple3DReadOnly)diff.getTranslation());
            expectedLinearVelocity.scale(1.0 / dt);
            prevTransform.transform((Vector3DBasics)expectedLinearVelocity);
            Vector3D expectedAngularVelocity = new Vector3D();
            diff.getRotation().getRotationVector((Vector3DBasics)expectedAngularVelocity);
            expectedAngularVelocity.scale(1.0 / dt);
            Vector3D actualLinearVelocity = new Vector3D();
            Vector3D actualAngularVelocity = new Vector3D();
            EuclidCoreTools.finiteDifference((RigidBodyTransformReadOnly)prevTransform, (RigidBodyTransformReadOnly)currTransform, (double)dt, (Vector3DBasics)actualAngularVelocity, (Vector3DBasics)actualLinearVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualLinearVelocity, (double)1.0E-11);
        }
    }

    private static void compareFiniteDifference(Orientation3DReadOnly prevOrientation, Orientation3DReadOnly currOrientation, double dt, double epsilon, int iteration) {
        Vector3D actualAngularVelocity = new Vector3D();
        Vector3D expectedAngularVelocity = new Vector3D();
        Quaternion prevQuaternion = new Quaternion(prevOrientation);
        Quaternion currQuaternion = new Quaternion(currOrientation);
        if (prevQuaternion.distance((Orientation3DReadOnly)currQuaternion) > Math.PI && prevOrientation.distance(currOrientation) < Math.PI) {
            prevQuaternion.negate();
        }
        QuaternionTools.finiteDifference((QuaternionReadOnly)prevQuaternion, (QuaternionReadOnly)currQuaternion, (double)dt, (Vector3DBasics)actualAngularVelocity);
        EuclidCoreTools.finiteDifference((Orientation3DReadOnly)prevOrientation, (Orientation3DReadOnly)currOrientation, (double)dt, (Vector3DBasics)expectedAngularVelocity);
        double toleranceScale = Math.max(1.0, expectedAngularVelocity.norm());
        EuclidCoreTestTools.assertEquals((String)"Iteration: %d, prev type: %s, curr type: %s, error norm rel: %s".formatted(iteration, prevOrientation.getClass().getSimpleName(), currOrientation.getClass().getSimpleName(), actualAngularVelocity.differenceNorm((Tuple3DReadOnly)expectedAngularVelocity) / toleranceScale), (EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)(epsilon * toleranceScale));
    }

    @Test
    public void testIntegrate() {
        Orientation2D expectedCurrOrientation;
        Point2D actualCurrTuple;
        Point2D expectedCurrTuple;
        double derivative;
        double dt;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double prevValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expectedCurrValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            derivative = EuclidCoreTools.finiteDifference((double)prevValue, (double)expectedCurrValue, (double)dt);
            double actualCurrValue = EuclidCoreTools.integrate((double)prevValue, (double)derivative, (double)dt);
            Assertions.assertEquals((double)expectedCurrValue, (double)actualCurrValue, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double prevAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            double expectedCurrAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            derivative = EuclidCoreTools.finiteDifferenceAngle((double)prevAngle, (double)expectedCurrAngle, (double)dt);
            double actualCurrAngle = EuclidCoreTools.integrateAngle((double)prevAngle, (double)derivative, (double)dt);
            Assertions.assertEquals((double)expectedCurrAngle, (double)actualCurrAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D prevTuple = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedCurrTuple = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D derivative2 = new Vector2D();
            EuclidCoreTools.finiteDifference((Tuple2DReadOnly)prevTuple, (Tuple2DReadOnly)expectedCurrTuple, (double)dt, (Vector2DBasics)derivative2);
            actualCurrTuple = new Point2D();
            EuclidCoreTools.integrate((Tuple2DReadOnly)prevTuple, (Vector2DReadOnly)derivative2, (double)dt, (Tuple2DBasics)actualCurrTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCurrTuple, (EuclidGeometry)actualCurrTuple, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D prevTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expectedCurrTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D derivative3 = new Vector3D();
            EuclidCoreTools.finiteDifference((Tuple3DReadOnly)prevTuple, (Tuple3DReadOnly)expectedCurrTuple, (double)dt, (Vector3DBasics)derivative3);
            actualCurrTuple = new Point3D();
            EuclidCoreTools.integrate((Tuple3DReadOnly)prevTuple, (Vector3DReadOnly)derivative3, (double)dt, (Tuple3DBasics)actualCurrTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCurrTuple, (EuclidGeometry)actualCurrTuple, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Vector4D prevTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            expectedCurrTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            Vector4D derivative4 = new Vector4D();
            EuclidCoreTools.finiteDifference((Tuple4DReadOnly)prevTuple, (Tuple4DReadOnly)expectedCurrTuple, (double)dt, (Vector4DBasics)derivative4);
            actualCurrTuple = new Vector4D();
            EuclidCoreTools.integrate((Tuple4DReadOnly)prevTuple, (Vector4DReadOnly)derivative4, (double)dt, (Tuple4DBasics)actualCurrTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCurrTuple, (EuclidGeometry)actualCurrTuple, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Orientation2D prevOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            expectedCurrOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            double derivative5 = EuclidCoreTools.finiteDifference((double)prevOrientation.getYaw(), (double)expectedCurrOrientation.getYaw(), (double)dt);
            Orientation2D actualCurrOrientation = new Orientation2D();
            EuclidCoreTools.integrate((Orientation2DReadOnly)prevOrientation, (double)derivative5, (double)dt, (Orientation2DBasics)actualCurrOrientation);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCurrOrientation, (EuclidGeometry)actualCurrOrientation, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Orientation3DBasics prevOrientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            expectedCurrOrientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Vector3D derivative6 = new Vector3D();
            EuclidCoreTools.finiteDifference((Orientation3DReadOnly)prevOrientation, (Orientation3DReadOnly)expectedCurrOrientation, (double)dt, (Vector3DBasics)derivative6);
            Orientation3DBasics actualCurrOrientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            EuclidCoreTools.integrate((Orientation3DReadOnly)prevOrientation, (Vector3DReadOnly)derivative6, (double)dt, (Orientation3DBasics)actualCurrOrientation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedCurrOrientation, (EuclidGeometry)actualCurrOrientation, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0);
            RigidBodyTransform prevTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform diff = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expectedCurrTransform = new RigidBodyTransform();
            expectedCurrTransform.set(prevTransform);
            expectedCurrTransform.multiply((RigidBodyTransformReadOnly)diff);
            Vector3D expectedLinearVelocity = new Vector3D();
            expectedLinearVelocity.set((Tuple3DReadOnly)diff.getTranslation());
            expectedLinearVelocity.scale(1.0 / dt);
            prevTransform.transform((Vector3DBasics)expectedLinearVelocity);
            Vector3D expectedAngularVelocity = new Vector3D();
            diff.getRotation().getRotationVector((Vector3DBasics)expectedAngularVelocity);
            expectedAngularVelocity.scale(1.0 / dt);
            RigidBodyTransform actualCurrTransform = new RigidBodyTransform();
            EuclidCoreTools.integrate((RigidBodyTransformReadOnly)prevTransform, (Vector3DReadOnly)expectedAngularVelocity, (Vector3DReadOnly)expectedLinearVelocity, (double)dt, (RigidBodyTransformBasics)actualCurrTransform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCurrTransform, (EuclidGeometry)actualCurrTransform, (double)1.0E-12);
        }
    }

    @Test
    public void testProjectRotationOnAxis() {
        Random random = new Random(9429424L);
        Quaternion fullRotation = new Quaternion();
        Quaternion actualRotation = new Quaternion();
        for (int i = 0; i < 10000; ++i) {
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            Quaternion expectedRotation = new Quaternion((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            Vector3D orthogonalAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)axis, (boolean)true);
            double orthogonalAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            Quaternion orthogonalRotation = new Quaternion((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonalAxis, orthogonalAngle));
            fullRotation.multiply((QuaternionReadOnly)orthogonalRotation, (QuaternionReadOnly)expectedRotation);
            EuclidCoreTools.projectRotationOnAxis((QuaternionReadOnly)fullRotation, (Vector3DReadOnly)axis, (QuaternionBasics)actualRotation);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedRotation, (Orientation3DReadOnly)actualRotation, (double)1.0E-10);
        }
    }

    @Test
    public void testRotationMatrix3DFromFirstToSecondVector3D() {
        Random random = new Random(43634L);
        for (int i = 0; i < 10000; ++i) {
            Vector3D firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D secondVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            RotationMatrix actualRotationMatrix = new RotationMatrix();
            AxisAngle actualAxisAngle = new AxisAngle();
            AxisAngle expectedAxisAngle = new AxisAngle();
            EuclidGeometryTools.rotationMatrix3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (CommonMatrix3DBasics)actualRotationMatrix);
            actualAxisAngle.set((Orientation3DReadOnly)actualRotationMatrix);
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-7);
        }
    }

    @Test
    public void testDistanceBetweenTwoLineSegment2Ds() {
        Vector2D shiftVector;
        Vector2D oppositeOflineSegmentDirection1;
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        int i;
        Point2D closestPointOnLineSegment1 = new Point2D();
        Point2D closestPointOnLineSegment2 = new Point2D();
        Vector2D lineSegmentDirection1 = new Vector2D();
        Vector2D lineSegmentDirection2 = new Vector2D();
        Random random = new Random(11762L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            double expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            closestPointOnLineSegment2.scaleAdd(expectedMinimumDistance, (Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2.set(lineSegmentDirection1);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            double shiftStartFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-10.0);
            double shiftEndFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(shiftStartFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(shiftEndFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            closestPointOnLineSegment2.set(lineSegmentEnd2);
            expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            shiftVector = new Vector2D();
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2 = EuclidCoreToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)shiftVector, true);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            shiftVector = new Vector2D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, alpha);
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)closestPointOnLineSegment1);
            Point2D lineSegmentStart22 = new Point2D((Tuple2DReadOnly)closestPointOnLineSegment2);
            Vector2D orthogonalToShiftVector = EuclidCoreToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)shiftVector, true);
            lineSegmentDirection2.interpolate((Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)orthogonalToShiftVector, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            lineSegmentEnd22.scaleAdd(alpha2, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testExtractNormalPart() {
        Random random = new Random(6457L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            Vector3D normalPart = new Vector3D();
            Vector3D tangentialPart = new Vector3D();
            double normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            Vector3D input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            Vector3D actualNormalPart = new Vector3D();
            EuclidCoreTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualNormalPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)normalPart, (EuclidGeometry)actualNormalPart, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualNormalPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)normalPart, (EuclidGeometry)actualNormalPart, (double)1.0E-12);
        }
    }

    @Test
    public void testExtractTangentialPart() {
        Vector3D actualTangentialPart;
        Vector3D input;
        double tangentialMagnitude;
        double normalMagnitude;
        Vector3D tangentialPart;
        Vector3D normalPart;
        Axis3D tangentialAxis;
        Axis3D normalAxis;
        int i;
        Random random = new Random(63457L);
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextAxis3D((Random)random);
            tangentialAxis = random.nextBoolean() ? normalAxis.next() : normalAxis.previous();
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            actualTangentialPart = new Vector3D();
            EuclidCoreTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            actualTangentialPart = new Vector3D();
            EuclidCoreTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndLine2D() {
        Point2D rayOrigin = new Point2D(8.689, 0.5687);
        Point2D pointOnRay = new Point2D(8.6432, 0.4951);
        Vector2D rayDirection = new Vector2D();
        rayDirection.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin);
        Point2D lineStart = new Point2D(8.4521, 0.4323);
        Point2D lineEnd = new Point2D(8.776, 0.5267);
        Vector2D lineDirection = new Vector2D();
        lineDirection.sub((Tuple2DReadOnly)lineEnd, (Tuple2DReadOnly)lineStart);
        Point2D intersectionToPac = new Point2D();
        Assertions.assertTrue((boolean)EuclidGeometryTools.intersectionBetweenRay2DAndLine2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineStart, (Vector2DReadOnly)lineDirection, (Point2DBasics)intersectionToPac));
        Point2D intersectionExpected = new Point2D();
        EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineStart, (Point2DReadOnly)lineEnd, (Point2DBasics)intersectionExpected);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)intersectionExpected, (Point2DReadOnly)intersectionToPac, (double)1.0E-5);
    }

    @Test
    public void testSetNormalPart() {
        Vector3D expected;
        Vector3D tupleToModify;
        Point3D input;
        double tangentialMagnitude;
        double normalMagnitude;
        Vector3D tangentialPart;
        Vector3D normalPart;
        Axis3D tangentialAxis;
        Axis3D normalAxis;
        int i;
        Random random = new Random(897632L);
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextAxis3D((Random)random);
            tangentialAxis = random.nextBoolean() ? normalAxis.next() : normalAxis.previous();
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Point3D((Tuple3DReadOnly)normalPart);
            input.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)tangentialPart, (Tuple3DReadOnly)input);
            tupleToModify = new Vector3D((Tuple3DReadOnly)tangentialPart);
            tupleToModify.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tupleToModify);
            expected = new Vector3D();
            expected.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            EuclidCoreTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Point3D((Tuple3DReadOnly)normalPart);
            input.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)tangentialPart, (Tuple3DReadOnly)input);
            tupleToModify = new Vector3D((Tuple3DReadOnly)tangentialPart);
            tupleToModify.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tupleToModify);
            expected = new Vector3D();
            expected.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            EuclidCoreTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
        }
    }

    @Test
    public void testDifferentiateOrientation() {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion qStart = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double duration = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.01);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI);
            UnitVector3D velocityAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            Vector3D expectedAngularVelocity = new Vector3D();
            expectedAngularVelocity.setAndScale(angle / duration, (Tuple3DReadOnly)velocityAxis);
            Quaternion qEnd = new Quaternion();
            qEnd.setRotationVector(velocityAxis.getX() * angle, velocityAxis.getY() * angle, velocityAxis.getZ() * angle);
            qEnd.prepend((Orientation3DReadOnly)qStart);
            Vector3D actualAngularVelocity = new Vector3D();
            EuclidCoreTools.differentiateOrientation((QuaternionReadOnly)qStart, (QuaternionReadOnly)qEnd, (double)duration, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)(1.0E-12 * Math.max(1.0, expectedAngularVelocity.norm())));
        }
    }

    public static Vector2D nextOrthogonalVector2D(Random random, Vector2DReadOnly vectorToBeOrthogonalTo, boolean normalize) {
        Vector2D v1 = new Vector2D(vectorToBeOrthogonalTo.getY(), -vectorToBeOrthogonalTo.getX());
        Vector2D randomPerpendicular = new Vector2D();
        double a = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
        randomPerpendicular.scaleAdd(a, (Tuple2DReadOnly)v1, (Tuple2DReadOnly)randomPerpendicular);
        if (normalize) {
            randomPerpendicular.normalize();
        }
        return randomPerpendicular;
    }
}

