/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision;

import java.util.Random;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.FrameCylinder3D;
import us.ihmc.euclid.referenceFrame.FrameEllipsoid3D;
import us.ihmc.euclid.referenceFrame.FramePointShape3D;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShapeCollisionTools;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.FrameConvexPolytope3D;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.EuclidShapeCollisionTools;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;

public class EuclidFrameShapeCollisionToolsTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-12;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    private <A extends FrameShape3DReadOnly, B extends FrameShape3DReadOnly> void performAssertionsForCollisionEvaluator(Random random, FrameShape3DCollisionEvaluator<A, B> evaluatorToTest, Shape3DCollisionEvaluator<A, B> referenceForTesting, BiFunction<Random, ReferenceFrame, A> shapeARandomGenerator, BiFunction<Random, ReferenceFrame, B> shapeBRandomGenerator, boolean testNormal, double epsilon) {
        FrameShape3DReadOnly shapeB;
        FrameShape3DReadOnly shapeA;
        ReferenceFrame frameB;
        ReferenceFrame frameA;
        EuclidShape3DCollisionResult expected;
        EuclidFrameShape3DCollisionResult actual;
        int i;
        for (i = 0; i < 10000; ++i) {
            actual = new EuclidFrameShape3DCollisionResult();
            expected = new EuclidShape3DCollisionResult();
            FrameShape3DReadOnly shapeA2 = (FrameShape3DReadOnly)shapeARandomGenerator.apply(random, worldFrame);
            FrameShape3DReadOnly shapeB2 = (FrameShape3DReadOnly)shapeBRandomGenerator.apply(random, worldFrame);
            evaluatorToTest.evaluateCollision(shapeA2, shapeB2, (EuclidFrameShape3DCollisionResultBasics)actual);
            referenceForTesting.evaluateCollision(shapeA2, shapeB2, (EuclidShape3DCollisionResultBasics)expected);
            EuclidFrameShapeCollisionToolsTest.assertCollisionResultsEqual(expected, actual, testNormal, epsilon);
        }
        for (i = 0; i < 10000; ++i) {
            actual = new EuclidFrameShape3DCollisionResult();
            expected = new EuclidShape3DCollisionResult();
            frameB = frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
            shapeA = (FrameShape3DReadOnly)shapeARandomGenerator.apply(random, frameA);
            shapeB = (FrameShape3DReadOnly)shapeBRandomGenerator.apply(random, frameB);
            evaluatorToTest.evaluateCollision(shapeA, shapeB, (EuclidFrameShape3DCollisionResultBasics)actual);
            referenceForTesting.evaluateCollision(EuclidFrameShapeCollisionToolsTest.changeFrame(shapeA, worldFrame), EuclidFrameShapeCollisionToolsTest.changeFrame(shapeB, worldFrame), (EuclidShape3DCollisionResultBasics)expected);
            expected.setShapeA((Shape3DReadOnly)shapeA);
            expected.setShapeB((Shape3DReadOnly)shapeB);
            actual.getPointOnA().changeFrame(worldFrame);
            actual.getPointOnB().changeFrame(worldFrame);
            actual.getNormalOnA().changeFrame(worldFrame);
            actual.getNormalOnB().changeFrame(worldFrame);
            EuclidFrameShapeCollisionToolsTest.assertCollisionResultsEqual(expected, actual, testNormal, epsilon);
        }
        for (i = 0; i < 10000; ++i) {
            actual = new EuclidFrameShape3DCollisionResult();
            expected = new EuclidShape3DCollisionResult();
            frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
            frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
            shapeA = (FrameShape3DReadOnly)shapeARandomGenerator.apply(random, frameA);
            shapeB = (FrameShape3DReadOnly)shapeBRandomGenerator.apply(random, frameB);
            evaluatorToTest.evaluateCollision(shapeA, shapeB, (EuclidFrameShape3DCollisionResultBasics)actual);
            referenceForTesting.evaluateCollision(EuclidFrameShapeCollisionToolsTest.changeFrame(shapeA, worldFrame), EuclidFrameShapeCollisionToolsTest.changeFrame(shapeB, worldFrame), (EuclidShape3DCollisionResultBasics)expected);
            expected.setShapeA((Shape3DReadOnly)shapeA);
            expected.setShapeB((Shape3DReadOnly)shapeB);
            actual.getPointOnA().changeFrame(worldFrame);
            actual.getPointOnB().changeFrame(worldFrame);
            actual.getNormalOnA().changeFrame(worldFrame);
            actual.getNormalOnB().changeFrame(worldFrame);
            EuclidFrameShapeCollisionToolsTest.assertCollisionResultsEqual(expected, actual, testNormal, epsilon);
        }
    }

    private static void assertCollisionResultsEqual(EuclidShape3DCollisionResult expected, EuclidFrameShape3DCollisionResult actual, boolean testNormal, double epsilon) {
        if (!testNormal) {
            expected.getNormalOnA().setToNaN();
            expected.getNormalOnB().setToNaN();
        } else {
            expected.getNormalOnA().normalize();
            expected.getNormalOnB().normalize();
            actual.getNormalOnA().normalize();
            actual.getNormalOnB().normalize();
        }
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)epsilon);
    }

    @Test
    public void testEvaluatePointShape3DBox3DCollision() {
        Random random = new Random(5165L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DBox3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DBox3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameBox3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DBox3DCollision() {
        Random random = new Random(5165L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DBox3DCollision, EuclidShapeCollisionTools::evaluateSphere3DBox3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameBox3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DCapsule3DCollision() {
        Random random = new Random(54687L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DCapsule3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DCapsule3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameCapsule3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateCapsule3DCapsule3DCollision() {
        Random random = new Random(345L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateCapsule3DCapsule3DCollision, EuclidShapeCollisionTools::evaluateCapsule3DCapsule3DCollision, EuclidFrameShapeRandomTools::nextFrameCapsule3D, EuclidFrameShapeRandomTools::nextFrameCapsule3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DCapsule3DCollision() {
        Random random = new Random(54687L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DCapsule3DCollision, EuclidShapeCollisionTools::evaluateSphere3DCapsule3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameCapsule3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DCylinder3DCollision() {
        Random random = new Random(86L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DCylinder3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DCylinder3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameCylinder3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DCylinder3DCollision() {
        Random random = new Random(86L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DCylinder3DCollision, EuclidShapeCollisionTools::evaluateSphere3DCylinder3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameCylinder3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DEllipsoid3DCollision() {
        Random random = new Random(285L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DEllipsoid3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DEllipsoid3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameEllipsoid3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DEllipsoid3DCollision() {
        Random random = new Random(285L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DEllipsoid3DCollision, EuclidShapeCollisionTools::evaluateSphere3DEllipsoid3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameEllipsoid3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DPointShape3DCollision() {
        Random random = new Random(6L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DPointShape3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DPointShape3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFramePointShape3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DRamp3DCollision() {
        Random random = new Random(98587621L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DRamp3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DRamp3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameRamp3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DRamp3DCollision() {
        Random random = new Random(98587621L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DRamp3DCollision, EuclidShapeCollisionTools::evaluateSphere3DRamp3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameRamp3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluatePointShape3DSphere3DCollision() {
        Random random = new Random(74275L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluatePointShape3DSphere3DCollision, EuclidShapeCollisionTools::evaluatePointShape3DSphere3DCollision, EuclidFrameShapeRandomTools::nextFramePointShape3D, EuclidFrameShapeRandomTools::nextFrameSphere3D, true, 1.0E-12);
    }

    @Test
    public void testEvaluateSphere3DSphere3DCollision() {
        Random random = new Random(74275L);
        this.performAssertionsForCollisionEvaluator(random, EuclidFrameShapeCollisionTools::evaluateSphere3DSphere3DCollision, EuclidShapeCollisionTools::evaluateSphere3DSphere3DCollision, EuclidFrameShapeRandomTools::nextFrameSphere3D, EuclidFrameShapeRandomTools::nextFrameSphere3D, true, 1.0E-12);
    }

    private static <S extends FrameShape3DReadOnly> S changeFrame(S shape3D, ReferenceFrame desiredFrame) {
        S clone = EuclidFrameShapeCollisionToolsTest.clone(shape3D);
        ((FrameChangeable)clone).changeFrame(desiredFrame);
        return clone;
    }

    private static <S extends FrameShape3DReadOnly> S clone(S shape3D) {
        if (shape3D instanceof FrameBox3DReadOnly) {
            return (S)new FrameBox3D((FrameBox3DReadOnly)shape3D);
        }
        if (shape3D instanceof FrameCapsule3DReadOnly) {
            return (S)new FrameCapsule3D((FrameCapsule3DReadOnly)shape3D);
        }
        if (shape3D instanceof FrameCylinder3DReadOnly) {
            return (S)new FrameCylinder3D((FrameCylinder3DReadOnly)shape3D);
        }
        if (shape3D instanceof FrameEllipsoid3DReadOnly) {
            return (S)new FrameEllipsoid3D((FrameEllipsoid3DReadOnly)shape3D);
        }
        if (shape3D instanceof FramePointShape3DReadOnly) {
            return (S)new FramePointShape3D((FrameTuple3DReadOnly)((FramePointShape3DReadOnly)shape3D));
        }
        if (shape3D instanceof FrameRamp3DReadOnly) {
            return (S)new FrameRamp3D((FrameRamp3DReadOnly)shape3D);
        }
        if (shape3D instanceof FrameSphere3DReadOnly) {
            return (S)new FrameSphere3D((FrameSphere3DReadOnly)shape3D);
        }
        if (shape3D instanceof FrameConvexPolytope3DReadOnly) {
            return (S)new FrameConvexPolytope3D((FrameConvexPolytope3DReadOnly)shape3D);
        }
        throw new IllegalStateException("Unhandled type of frame shape: " + String.valueOf(shape3D));
    }

    static interface FrameShape3DCollisionEvaluator<A extends FrameShape3DReadOnly, B extends FrameShape3DReadOnly> {
        public void evaluateCollision(A var1, B var2, EuclidFrameShape3DCollisionResultBasics var3);
    }

    static interface Shape3DCollisionEvaluator<A extends Shape3DReadOnly, B extends Shape3DReadOnly> {
        public void evaluateCollision(A var1, B var2, EuclidShape3DCollisionResultBasics var3);
    }
}

