/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Triangle3DBasics;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Triangle3DBasicsTest<T extends Triangle3DBasics> {
    public abstract T newEmptyTriangle3D();

    public abstract T newRandomTriangle3D(Random var1);

    public abstract T newTriangle3D(Point3DReadOnly var1, Point3DReadOnly var2, Point3DReadOnly var3);

    public abstract double getEpsilon();

    @Test
    public void testSetter() {
        Random random = new Random(24323L);
        for (int i = 0; i < 1000; ++i) {
            T firstTriangle = this.newRandomTriangle3D(random);
            T secondTriangle = this.newRandomTriangle3D(random);
            T thirdTriangle = this.newEmptyTriangle3D();
            Assertions.assertFalse((boolean)firstTriangle.equals(secondTriangle));
            firstTriangle.set(secondTriangle);
            Assertions.assertEquals(firstTriangle, secondTriangle);
            Assertions.assertFalse((boolean)firstTriangle.equals(thirdTriangle));
            thirdTriangle.set((Point3DReadOnly)firstTriangle.getA(), (Point3DReadOnly)firstTriangle.getB(), (Point3DReadOnly)firstTriangle.getC());
            Assertions.assertEquals(firstTriangle, thirdTriangle);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Point3D pointA = new Point3D(1.0, 2.0, 3.0);
        Point3D pointB = new Point3D(4.0, 5.0, 6.0);
        Point3D pointC = new Point3D(7.0, 8.0, 9.0);
        T triangle = this.newTriangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        triangle.setToZero();
        Assertions.assertTrue((0.0 == triangle.getA().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getA().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getA().getZ() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getZ() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getZ() ? 1 : 0) != 0);
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(32423L);
        T triangle = this.newRandomTriangle3D(random);
        Assertions.assertFalse((boolean)triangle.containsNaN());
        triangle.setToNaN();
        Assertions.assertTrue((boolean)triangle.containsNaN());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)triangle.getA());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)triangle.getB());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)triangle.getC());
    }

    @Test
    public void testContainsNaN() throws Exception {
        Point3D pointA = new Point3D(1.0, 2.0, 3.0);
        Point3D pointB = new Point3D(4.0, 5.0, 6.0);
        Point3D pointC = new Point3D(7.0, 8.0, 9.0);
        T triangle = this.newEmptyTriangle3D();
        Assertions.assertFalse((boolean)triangle.containsNaN());
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertFalse((boolean)triangle.containsNaN());
        pointA.setX(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointA.setX(0.0);
        pointA.setY(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointA.setY(0.0);
        pointA.setZ(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointA.setZ(1.0);
        pointB.setX(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointB.setX(0.0);
        pointB.setY(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointB.setY(0.0);
        pointB.setZ(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointB.setZ(1.0);
        pointC.setX(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointC.setX(0.0);
        pointC.setY(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointC.setY(0.0);
        pointC.setZ(Double.NaN);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertTrue((boolean)triangle.containsNaN());
        pointC.setZ(1.0);
        triangle.set((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Assertions.assertFalse((boolean)triangle.containsNaN());
    }

    @Test
    public void testApplyTransform() throws Exception {
        T expected;
        T original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(25613L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(expected, original);
            transform.transform(expected.getA());
            transform.transform(expected.getB());
            transform.transform(expected.getC());
            Assertions.assertFalse((boolean)expected.equals(original));
            original.applyTransform((Transform)transform);
            Assertions.assertEquals(expected, original);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(expected, original);
            transform.transform(expected.getA());
            transform.transform(expected.getB());
            transform.transform(expected.getC());
            Assertions.assertFalse((boolean)expected.equals(original));
            original.applyTransform((Transform)transform);
            Assertions.assertEquals(expected, original);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(expected, original);
            transform.transform(expected.getA());
            transform.transform(expected.getB());
            transform.transform(expected.getC());
            Assertions.assertFalse((boolean)expected.equals(original));
            original.applyTransform((Transform)transform);
            Assertions.assertEquals(expected, original);
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        T expected;
        T original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(original, expected);
            expected.applyTransform((Transform)transform);
            Assertions.assertFalse((boolean)expected.equals(original));
            expected.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expected.epsilonEquals(original, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(original, expected);
            expected.applyTransform((Transform)transform);
            Assertions.assertFalse((boolean)expected.equals(original));
            expected.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expected.epsilonEquals(original, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = this.newRandomTriangle3D(random);
            expected = this.newEmptyTriangle3D();
            expected.set(original);
            Assertions.assertEquals(original, expected);
            expected.applyTransform((Transform)transform);
            Assertions.assertFalse((boolean)expected.equals(original));
            expected.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expected.epsilonEquals(original, this.getEpsilon()));
        }
    }
}

