/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.ConvexPolygon2DBasicsTest;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ConvexPolygon2DTest
extends ConvexPolygon2DBasicsTest<ConvexPolygon2D> {
    @Override
    public ConvexPolygon2D createEmptyConvexPolygon2D() {
        return new ConvexPolygon2D();
    }

    @Override
    public ConvexPolygon2D createRandomConvexPolygon2D(Random random) {
        return EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)2.0, (int)50);
    }

    @Override
    public ConvexPolygon2D createConvexPolygon2D(Vertex2DSupplier supplier) {
        return new ConvexPolygon2D(supplier);
    }

    @Test
    public void testIssueWithGiftWrappingFromFootstepSnapping() {
        Random random = new Random(1738L);
        ConvexPolygon2D basePolygon = new ConvexPolygon2D();
        basePolygon.addVertex(-0.108, 0.048);
        basePolygon.addVertex(0.108, 0.03);
        basePolygon.addVertex(-0.108, -0.03);
        basePolygon.addVertex(-0.108, -0.048);
        basePolygon.update();
        double gridSizeXY = 0.02;
        int yawDivisions = 36;
        double gridSizeYaw = Math.PI * 2 / (double)yawDivisions;
        double snapAreaResolution = 0.2;
        RigidBodyTransform transform = new RigidBodyTransform();
        int gridXIndex = -50;
        int gridYIndex = -31;
        int yawIndex = 19;
        transform.getTranslation().set(gridSizeXY * (double)gridXIndex, gridSizeXY * (double)gridYIndex, 0.0);
        transform.getRotation().appendYawRotation((double)yawIndex * gridSizeYaw);
        ConvexPolygon2D transformedPolygon = new ConvexPolygon2D((Vertex2DSupplier)basePolygon);
        transformedPolygon.applyTransform((Transform)transform);
        ArrayList<Point3D> footPointsInEnvironment = new ArrayList<Point3D>();
        Point2DReadOnly corner0 = transformedPolygon.getVertex(0);
        Point2DReadOnly corner1 = transformedPolygon.getVertex(1);
        Point2DReadOnly corner2 = transformedPolygon.getVertex(2);
        Point2DReadOnly corner3 = transformedPolygon.getVertex(3);
        Point2D pointOnEdge1 = new Point2D();
        Point2D pointOnEdge2 = new Point2D();
        Point2D footPointToSnap = new Point2D();
        double height = RandomNumbers.nextDouble((Random)random, (double)1.0);
        for (double edgeAlpha = 0.0; edgeAlpha <= 1.0; edgeAlpha += snapAreaResolution) {
            pointOnEdge1.interpolate((Tuple2DReadOnly)corner0, (Tuple2DReadOnly)corner1, edgeAlpha);
            pointOnEdge2.interpolate((Tuple2DReadOnly)corner3, (Tuple2DReadOnly)corner2, edgeAlpha);
            for (double interiorAlpha = 0.0; interiorAlpha <= 1.0; interiorAlpha += snapAreaResolution) {
                footPointToSnap.interpolate((Tuple2DReadOnly)pointOnEdge1, (Tuple2DReadOnly)pointOnEdge2, interiorAlpha);
                Point3D point2 = new Point3D(footPointToSnap.getX(), footPointToSnap.getY(), height);
                footPointsInEnvironment.add(point2);
            }
        }
        ConvexPolygon2D croppedFootholdOf3D = new ConvexPolygon2D(Vertex3DSupplier.asVertex3DSupplier(footPointsInEnvironment));
        List sortedPoints = footPointsInEnvironment.stream().map(Point2D::new).collect(Collectors.toList());
        ConvexPolygon2D croppedFootholdOf2D = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(sortedPoints));
        Assertions.assertEquals((int)croppedFootholdOf2D.getNumberOfVertices(), (int)croppedFootholdOf3D.getNumberOfVertices());
        ConvexPolygon2DTest.assertPointsInside((ConvexPolygon2DReadOnly)croppedFootholdOf3D, footPointsInEnvironment, 1.0E-7);
        List<Point2D> footPointsInFoot = footPointsInEnvironment.stream().map(point -> {
            Point3D transformedPoint = new Point3D((Tuple3DReadOnly)point);
            transformedPoint.applyInverseTransform((Transform)transform);
            return new Point2D((Tuple3DReadOnly)transformedPoint);
        }).toList();
        ConvexPolygon2D polygon2D = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(footPointsInFoot));
        ConvexPolygon2DTest.assertPoint2DsInside((ConvexPolygon2DReadOnly)polygon2D, footPointsInFoot, 1.0E-7);
    }

    @Test
    public void testIssueWithGiftWrappingFromFootstepSnappingWithManyAttempts() {
        Random random = new Random(1738L);
        ConvexPolygon2D basePolygon = new ConvexPolygon2D();
        basePolygon.addVertex(-0.108, 0.048);
        basePolygon.addVertex(0.108, 0.03);
        basePolygon.addVertex(-0.108, -0.03);
        basePolygon.addVertex(-0.108, -0.048);
        basePolygon.update();
        double gridSizeXY = 0.02;
        int yawDivisions = 36;
        double gridSizeYaw = Math.PI * 2 / (double)yawDivisions;
        double snapAreaResolution = 0.2;
        int iters = 100000;
        for (int iter = 0; iter < iters; ++iter) {
            RigidBodyTransform transform = new RigidBodyTransform();
            int gridXIndex = RandomNumbers.nextInt((Random)random, (int)-100, (int)100);
            int gridYIndex = RandomNumbers.nextInt((Random)random, (int)-100, (int)100);
            int yawIndex = RandomNumbers.nextInt((Random)random, (int)0, (int)yawDivisions);
            transform.getTranslation().set(gridSizeXY * (double)gridXIndex, gridSizeXY * (double)gridYIndex, 0.0);
            transform.getRotation().appendYawRotation((double)yawIndex * gridSizeYaw);
            ConvexPolygon2D transformedPolygon = new ConvexPolygon2D((Vertex2DSupplier)basePolygon);
            transformedPolygon.applyTransform((Transform)transform);
            ArrayList<Point3D> footPointsInEnvironment = new ArrayList<Point3D>();
            Point2DReadOnly corner0 = transformedPolygon.getVertex(0);
            Point2DReadOnly corner1 = transformedPolygon.getVertex(1);
            Point2DReadOnly corner2 = transformedPolygon.getVertex(2);
            Point2DReadOnly corner3 = transformedPolygon.getVertex(3);
            Point2D pointOnEdge1 = new Point2D();
            Point2D pointOnEdge2 = new Point2D();
            Point2D footPointToSnap = new Point2D();
            double height = RandomNumbers.nextDouble((Random)random, (double)1.0);
            for (double edgeAlpha = 0.0; edgeAlpha <= 1.0; edgeAlpha += snapAreaResolution) {
                pointOnEdge1.interpolate((Tuple2DReadOnly)corner0, (Tuple2DReadOnly)corner1, edgeAlpha);
                pointOnEdge2.interpolate((Tuple2DReadOnly)corner3, (Tuple2DReadOnly)corner2, edgeAlpha);
                for (double interiorAlpha = 0.0; interiorAlpha <= 1.0; interiorAlpha += snapAreaResolution) {
                    footPointToSnap.interpolate((Tuple2DReadOnly)pointOnEdge1, (Tuple2DReadOnly)pointOnEdge2, interiorAlpha);
                    Point3D point2 = new Point3D(footPointToSnap.getX(), footPointToSnap.getY(), height);
                    footPointsInEnvironment.add(point2);
                }
            }
            List<Point2D> footPointsInFoot = footPointsInEnvironment.stream().map(point -> {
                Point3D transformedPoint = new Point3D((Tuple3DReadOnly)point);
                transformedPoint.applyInverseTransform((Transform)transform);
                return new Point2D((Tuple3DReadOnly)transformedPoint);
            }).toList();
            ConvexPolygon2D croppedFoothold = new ConvexPolygon2D(Vertex3DSupplier.asVertex3DSupplier(footPointsInEnvironment));
            ConvexPolygon2DTest.assertPointsInside((ConvexPolygon2DReadOnly)croppedFoothold, footPointsInEnvironment, 1.0E-7);
            ConvexPolygon2D polygon2D = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(footPointsInFoot));
            ConvexPolygon2DTest.assertPoint2DsInside((ConvexPolygon2DReadOnly)polygon2D, footPointsInFoot, 1.0E-7);
        }
    }

    private static void assertPointsInside(ConvexPolygon2DReadOnly polygonToCheck, List<Point3D> points, double epsilon) {
        for (Point3D point : points) {
            double distance = polygonToCheck.signedDistance((Point2DReadOnly)new Point2D((Tuple3DReadOnly)point));
            Assertions.assertTrue((distance < epsilon ? 1 : 0) != 0, (String)("Point " + String.valueOf(point) + " is not inside the polygon. Distance was " + distance));
            Assertions.assertTrue((boolean)polygonToCheck.isPointInside((Point2DReadOnly)new Point2D((Tuple3DReadOnly)point), epsilon), (String)("Point " + String.valueOf(point) + " is not inside the polygon. Distance was " + distance));
        }
    }

    private static void assertPoint2DsInside(ConvexPolygon2DReadOnly polygonToCheck, List<Point2D> points, double epsilon) {
        for (Point2D point : points) {
            double distance = polygonToCheck.signedDistance((Point2DReadOnly)point);
            Assertions.assertTrue((boolean)polygonToCheck.isPointInside((Point2DReadOnly)point, epsilon), (String)("Point " + String.valueOf(point) + " is not inside the polygon. Distance was " + distance));
            Assertions.assertTrue((distance < epsilon ? 1 : 0) != 0, (String)("Point " + String.valueOf(point) + " is not inside the polygon. Distance was " + distance));
        }
    }

    @Test
    public void testIssue17() throws Exception {
        ConvexPolygon2D polygon;
        Point2D pointB;
        Point2D pointA;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            polygon = new ConvexPolygon2D();
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            polygon.addVertex((Point2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            polygon = new ConvexPolygon2D();
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
    }

    @Test
    public void testConstructors() {
        ConvexPolygon2D defaultConstructor = new ConvexPolygon2D();
        Assertions.assertEquals((double)0.0, (double)defaultConstructor.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be zero");
        Assertions.assertTrue((boolean)defaultConstructor.isUpToDate());
        int numberOfVertices = 4;
        ArrayList<Point2D> verticesList = new ArrayList<Point2D>();
        verticesList.add(new Point2D(0.0, 0.0));
        verticesList.add(new Point2D(0.0, 1.0));
        verticesList.add(new Point2D(1.0, 0.0));
        verticesList.add(new Point2D(1.0, 1.0));
        ConvexPolygon2D listInt = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList, (int)numberOfVertices));
        Assertions.assertEquals((double)4.0, (double)listInt.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        ConvexPolygon2D list = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList));
        Assertions.assertEquals((double)4.0, (double)list.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        ConvexPolygon2D doubleInt = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray, (int)numberOfVertices));
        Assertions.assertEquals((double)4.0, (double)doubleInt.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)doubleInt.isUpToDate());
        ConvexPolygon2D doubles = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        Assertions.assertEquals((double)4.0, (double)doubles.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)doubles.isUpToDate());
        ConvexPolygon2D polygon = new ConvexPolygon2D((Vertex2DSupplier)doubles);
        Assertions.assertEquals((double)4.0, (double)polygon.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)polygon.isUpToDate());
        ConvexPolygon2D polygonPolygon = new ConvexPolygon2D((Vertex2DSupplier)doubleInt, (Vertex2DSupplier)doubles);
        Assertions.assertEquals((double)4.0, (double)polygonPolygon.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)polygonPolygon.isUpToDate());
    }

    @Test
    public void geometricallyEquals() {
        int numberOfVertices = 4;
        ArrayList<Point2D> verticesList = new ArrayList<Point2D>();
        verticesList.add(new Point2D(0.0, 0.0));
        verticesList.add(new Point2D(0.0, 1.0));
        verticesList.add(new Point2D(1.0, 0.0));
        verticesList.add(new Point2D(1.0, 1.0));
        int numberOfVertices2 = 4;
        ArrayList<Point2D> verticesList2 = new ArrayList<Point2D>();
        verticesList2.add(new Point2D(1.0, 0.0));
        verticesList2.add(new Point2D(1.0, 1.0));
        verticesList2.add(new Point2D(0.0, 1.0));
        verticesList2.add(new Point2D(0.0, 0.0));
        ConvexPolygon2D polygonA = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList, (int)numberOfVertices));
        ConvexPolygon2D polygonB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList2, (int)numberOfVertices2));
        Assertions.assertEquals((int)polygonA.getNumberOfVertices(), (int)polygonB.getNumberOfVertices());
        for (int i = 0; i < numberOfVertices; ++i) {
            boolean foundMatchingVertex = false;
            for (int j = 0; j < numberOfVertices2; ++j) {
                if (!polygonA.getVertex(i).equals((EuclidGeometry)polygonB.getVertex(j))) continue;
                Assertions.assertEquals((Object)polygonA.getVertex(i), (Object)polygonB.getVertex(j));
                foundMatchingVertex = true;
                break;
            }
            Assertions.assertTrue((boolean)foundMatchingVertex, (String)("No matching vertex found in polygonB for vertex" + String.valueOf(polygonA.getVertex(i))));
        }
    }
}

