/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public abstract class ConvexPolygon2DBasicsTest<T extends ConvexPolygon2DBasics> {
    public static final boolean VERBOSE = false;
    public static final double EPSILON = 1.0E-10;

    public abstract T createEmptyConvexPolygon2D();

    public abstract T createRandomConvexPolygon2D(Random var1);

    public abstract T createConvexPolygon2D(Vertex2DSupplier var1);

    @Test
    public void testUpdateBoundingBox() throws Exception {
        Random random = new Random(432536L);
        T polygon = this.createEmptyConvexPolygon2D();
        Point2DReadOnly maxPoint = polygon.getBoundingBox().getMaxPoint();
        Point2DReadOnly minPoint = polygon.getBoundingBox().getMinPoint();
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)maxPoint);
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)minPoint);
        polygon.addVertex((Point2DReadOnly)new Point2D());
        polygon.update();
        polygon.getBoundingBox();
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)maxPoint);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)minPoint);
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        polygon.getBoundingBox();
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)minPoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, 1.0), (EuclidGeometry)maxPoint, (double)1.0E-10);
        polygon.translate(1.0, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, 1.0), (EuclidGeometry)minPoint, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(2.0, 2.0), (EuclidGeometry)maxPoint, (double)1.0E-10);
        for (int i = 0; i < 1000; ++i) {
            T polygon2 = this.createEmptyConvexPolygon2D();
            List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)0.0, (double)1.0, (int)100);
            polygon2.set(Vertex2DSupplier.asVertex2DSupplier((List)points));
            for (Point2D point : points) {
                Assertions.assertTrue((boolean)polygon2.getBoundingBox().isInsideInclusive((Point2DReadOnly)point));
            }
            polygon2.translate(10.0, 10.0);
            for (Point2D point : points) {
                Assertions.assertFalse((boolean)polygon2.getBoundingBox().isInsideInclusive((Point2DReadOnly)point));
            }
            polygon2.clearAndUpdate();
            Point2DReadOnly maxPoint2 = polygon2.getBoundingBox().getMaxPoint();
            Point2DReadOnly minPoint2 = polygon2.getBoundingBox().getMinPoint();
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)maxPoint2);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)minPoint2);
            polygon2.clear();
            polygon2.update();
            polygon2.getBoundingBox();
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)maxPoint2);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)minPoint2);
        }
    }

    @Test
    public void testTranslate() {
        T actualPolygon;
        T expectedPolygon;
        Vector2D translate;
        int i;
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.update();
        Vector2D translation1 = new Vector2D(-0.1, 0.0);
        polygon.translate((Tuple2DReadOnly)translation1);
        Assertions.assertTrue((boolean)polygon.getVertex(0).epsilonEquals((EuclidGeometry)translation1, 1.0E-10));
        Random random = new Random(234L);
        for (i = 0; i < 1000; ++i) {
            translate = EuclidCoreRandomTools.nextVector2D((Random)random);
            T originalPolygon = this.createRandomConvexPolygon2D(random);
            Vertex2DSupplier transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(v -> v.add((Tuple2DReadOnly)translate)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            if (random.nextBoolean()) {
                actualPolygon.getBoundingBox();
                actualPolygon.getCentroid();
            }
            actualPolygon.translate((Tuple2DReadOnly)translate);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            translate = EuclidCoreRandomTools.nextVector2D((Random)random);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set((Tuple2DReadOnly)translate);
            T originalPolygon = this.createRandomConvexPolygon2D(random);
            expectedPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            if (random.nextBoolean()) {
                expectedPolygon.getBoundingBox();
                expectedPolygon.getCentroid();
            }
            expectedPolygon.applyTransform((Transform)transform);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            if (random.nextBoolean()) {
                actualPolygon.getBoundingBox();
                actualPolygon.getCentroid();
            }
            actualPolygon.translate((Tuple2DReadOnly)translate);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
    }

    @Test
    public void testClear() {
        ArrayList<Point2D> verticesList = new ArrayList<Point2D>();
        verticesList.add(new Point2D(0.0, 0.0));
        verticesList.add(new Point2D(0.0, 1.0));
        verticesList.add(new Point2D(1.0, 0.0));
        verticesList.add(new Point2D(1.0, 1.0));
        T list = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList));
        Assertions.assertEquals((double)4.0, (double)list.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        Assertions.assertTrue((boolean)list.isUpToDate());
        list.clearAndUpdate();
        Assertions.assertEquals((double)0.0, (double)list.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 0");
        Assertions.assertTrue((boolean)list.isUpToDate());
        list.clear();
        Assertions.assertFalse((boolean)list.isUpToDate());
        list.clearAndUpdate();
        Assertions.assertTrue((boolean)list.isUpToDate());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)list.getBoundingBox().getMinPoint());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)list.getBoundingBox().getMaxPoint());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)list.getCentroid());
        Assertions.assertTrue((boolean)Double.isNaN(list.getArea()));
    }

    @Test
    public void testSetAndUpdates() {
        T doubleInt = this.createEmptyConvexPolygon2D();
        int numberOfVertices = 4;
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        doubleInt.set(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray, (int)numberOfVertices));
        Assertions.assertEquals((double)4.0, (double)doubleInt.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        Assertions.assertTrue((boolean)doubleInt.isUpToDate());
    }

    @Test
    public void testGetCentroid() {
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        T doubles = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        Point2D centroid = new Point2D();
        centroid.set((Tuple2DReadOnly)doubles.getCentroid());
        Assertions.assertEquals((Object)centroid, (Object)doubles.getCentroid(), (String)"Centroids should be equal");
    }

    @Test
    public void testGetBoundingBox() {
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        T doubles = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        BoundingBox2DReadOnly box = doubles.getBoundingBox();
        Assertions.assertEquals((double)box.getMinPoint().getX(), (double)0.0, (double)1.0E-10, (String)"Bounding boxes should be equal");
        Assertions.assertEquals((double)box.getMinPoint().getX(), (double)0.0, (double)1.0E-10, (String)"Bounding boxes should be equal");
        Assertions.assertEquals((double)box.getMaxPoint().getY(), (double)1.0, (double)1.0E-10, (String)"Bounding boxes should be equal");
        Assertions.assertEquals((double)box.getMaxPoint().getY(), (double)1.0, (double)1.0E-10, (String)"Bounding boxes should be equal");
    }

    @Test
    public void testGetNextVertexCCWGetPreviousVertexCCW() {
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        T doubles = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        Point2DReadOnly oneNext = doubles.getNextVertexCCW(0);
        Point2DReadOnly twoNext = doubles.getNextVertexCCW(1);
        Point2DReadOnly threeNext = doubles.getNextVertexCCW(2);
        Point2DReadOnly fourNext = doubles.getNextVertexCCW(3);
        Point2DReadOnly onePrev = doubles.getPreviousVertexCCW(0);
        Point2DReadOnly twoPrev = doubles.getPreviousVertexCCW(1);
        Point2DReadOnly threePrev = doubles.getPreviousVertexCCW(2);
        Point2DReadOnly fourPrev = doubles.getPreviousVertexCCW(3);
        EuclidCoreTestTools.assertEquals((String)"Points should be equal", (EuclidGeometry)oneNext, (EuclidGeometry)threePrev, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"Points should be equal", (EuclidGeometry)twoNext, (EuclidGeometry)fourPrev, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"Points should be equal", (EuclidGeometry)threeNext, (EuclidGeometry)onePrev, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"Points should be equal", (EuclidGeometry)fourNext, (EuclidGeometry)twoPrev, (double)1.0E-10);
    }

    @Test
    public void testScale() {
        double scaleFactor = 2.0;
        double[][] verticesArray = new double[][]{{-1.0, 1.0}, {1.0, 1.0}, {1.0, -1.0}, {-1.0, -1.0}};
        T polygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        polygon.scale(scaleFactor);
        Point2DReadOnly oneNext = polygon.getNextVertexCCW(0);
        Point2DReadOnly twoNext = polygon.getNextVertexCCW(1);
        Point2DReadOnly threeNext = polygon.getNextVertexCCW(2);
        Point2DReadOnly fourNext = polygon.getNextVertexCCW(3);
        Point2D one = new Point2D(2.0, -2.0);
        Point2D two = new Point2D(2.0, 2.0);
        Point2D three = new Point2D(-2.0, 2.0);
        Point2D four = new Point2D(-2.0, -2.0);
        EuclidCoreTestTools.assertEquals((String)"These should be equal", (EuclidGeometry)oneNext, (EuclidGeometry)one, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"These should be equal", (EuclidGeometry)twoNext, (EuclidGeometry)two, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"These should be equal", (EuclidGeometry)threeNext, (EuclidGeometry)three, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((String)"These should be equal", (EuclidGeometry)fourNext, (EuclidGeometry)four, (double)1.0E-10);
    }

    @Test
    public void testIsPointInside() {
        Random random = new Random(4564656L);
        double[][] verticesArray = new double[][]{{-10.0, 10.0}, {10.0, 10.0}, {10.0, -10.0}, {-10.0, -10.0}};
        T doubles = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        for (int i = 0; i < 10; ++i) {
            int x = random.nextInt(10);
            int y = random.nextInt(10);
            Assertions.assertTrue((boolean)doubles.isPointInside((double)x, (double)y));
        }
    }

    @Test
    public void testConstructorWithRepeatedPoints() {
        ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
        listOfPoints.add(new Point2D(0.0, 0.0));
        listOfPoints.add(new Point2D(1.0, 1.0));
        listOfPoints.add(new Point2D(1.0, 1.0));
        listOfPoints.add(new Point2D(1.0, 1.0));
        listOfPoints.add(new Point2D(1.0, 0.0));
        listOfPoints.add(new Point2D(0.0, 0.0));
        T convexPolygon2d = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        Assertions.assertEquals((int)3, (int)convexPolygon2d.getNumberOfVertices());
    }

    @Test
    public void testGetClosestPointToRay1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(2.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -1.0));
        polygon.update();
        Line2D ray1 = new Line2D((Point2DReadOnly)new Point2D(5.0, -3.0), (Vector2DReadOnly)new Vector2D(0.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(2.0, 0.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray1), (double)1.0E-10);
        Line2D ray2 = new Line2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Vector2DReadOnly)new Vector2D(0.5, 0.5));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.8, 0.6), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray2), (double)1.0E-10);
        Line2D ray3 = new Line2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Vector2DReadOnly)new Vector2D(-0.5, 0.1));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.0, 1.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray3), (double)1.0E-10);
        Line2D ray4 = new Line2D((Point2DReadOnly)new Point2D(-0.75, 0.75), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.5, 0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray4), (double)1.0E-10);
        Line2D ray5 = new Line2D((Point2DReadOnly)new Point2D(-0.75, 0.75), (Vector2DReadOnly)new Vector2D(0.3, 0.3));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.5, 0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray5), (double)1.0E-10);
        Line2D ray6 = new Line2D((Point2DReadOnly)new Point2D(-0.75, 0.75), (Vector2DReadOnly)new Vector2D(-0.3, -0.3));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.5, 0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray6), (double)1.0E-10);
        Line2D ray7 = new Line2D((Point2DReadOnly)new Point2D(-0.75, 0.75), (Vector2DReadOnly)new Vector2D(0.3, 0.31));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.5, 0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray7), (double)1.0E-10);
        Line2D ray8 = new Line2D((Point2DReadOnly)new Point2D(-0.75, 0.75), (Vector2DReadOnly)new Vector2D(0.3, 0.29));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.0, 1.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray8), (double)1.0E-10);
        Line2D ray9 = new Line2D((Point2DReadOnly)new Point2D(1.75, -0.75), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray9), (double)1.0E-10);
        Line2D ray10 = new Line2D((Point2DReadOnly)new Point2D(1.75, -0.75), (Vector2DReadOnly)new Vector2D(-0.3, -0.3));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray10), (double)1.0E-10);
        Line2D ray11 = new Line2D((Point2DReadOnly)new Point2D(1.0, -1.2), (Vector2DReadOnly)new Vector2D(-2.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray11), (double)1.0E-10);
        Line2D ray12 = new Line2D((Point2DReadOnly)new Point2D(1.0, -1.2), (Vector2DReadOnly)new Vector2D(2.0, -1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray12), (double)1.0E-10);
        Line2D ray13 = new Line2D((Point2DReadOnly)new Point2D(-0.1, -0.7), (Vector2DReadOnly)new Vector2D(-2.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.0, -0.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray13), (double)1.0E-10);
    }

    @Test
    public void testGetClosestPointToRay2() {
        T polygon = this.createEmptyConvexPolygon2D();
        Assertions.assertTrue((polygon.getClosestPointWithRay((Line2DReadOnly)new Line2D(0.0, 0.0, 1.0, 0.0)) == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetClosestPointToRay3() {
        Point2D vertex = new Point2D(1.0, -1.0);
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex);
        polygon.update();
        Line2D ray1 = new Line2D((Point2DReadOnly)new Point2D(5.0, -3.0), (Vector2DReadOnly)new Vector2D(0.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray1), (double)1.0E-10);
        Line2D ray2 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray2), (double)1.0E-10);
    }

    @Test
    public void testGetClosestPointToRay4() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(2.0, -5.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -6.0));
        polygon.update();
        Line2D ray1 = new Line2D((Point2DReadOnly)new Point2D(1.0, -5.0), (Vector2DReadOnly)new Vector2D(1.0, 0.1));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(2.0, -5.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray1), (double)1.0E-10);
        Line2D ray2 = new Line2D((Point2DReadOnly)new Point2D(1.25, -5.25), (Vector2DReadOnly)new Vector2D(0.75, 0.3));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(2.0, -5.0), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray2), (double)1.0E-10);
        Line2D ray3 = new Line2D((Point2DReadOnly)new Point2D(1.25, -5.25), (Vector2DReadOnly)new Vector2D(0.75, 0.8));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -5.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray3), (double)1.0E-10);
        Line2D ray4 = new Line2D((Point2DReadOnly)new Point2D(1.25, -5.25), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -5.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray4), (double)1.0E-10);
        Line2D ray5 = new Line2D((Point2DReadOnly)new Point2D(1.25, -5.25), (Vector2DReadOnly)new Vector2D(-1.0, -1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -5.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray5), (double)1.0E-10);
        Line2D ray6 = new Line2D((Point2DReadOnly)new Point2D(1.75, -5.75), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -5.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray6), (double)1.0E-10);
        Line2D ray7 = new Line2D((Point2DReadOnly)new Point2D(1.75, -5.75), (Vector2DReadOnly)new Vector2D(-1.0, -1.0));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.5, -5.5), (EuclidGeometry)polygon.getClosestPointWithRay((Line2DReadOnly)ray7), (double)1.0E-10);
    }

    @Test
    public void testNANRay() {
        ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
        listOfPoints.add(new Point2D(0.11429999999999998, 0.1397));
        listOfPoints.add(new Point2D(0.11429999999999998, 0.04444999999999999));
        listOfPoints.add(new Point2D(-0.047625, 0.04444999999999999));
        listOfPoints.add(new Point2D(-0.047625, 0.1397));
        T convexPolygon2d = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        Point2D pont2d = new Point2D(Double.NaN, Double.NaN);
        Vector2D vector2d = new Vector2D(Double.NaN, Double.NaN);
        Line2D line2d = new Line2D((Point2DReadOnly)pont2d, (Vector2DReadOnly)vector2d);
        convexPolygon2d.intersectionWithRay((Line2DReadOnly)line2d);
    }

    @Test
    public void testIntersectionWithLine1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D result1 = new Point2D(0.6, 0.4);
        Point2D result2 = new Point2D(0.1, 0.9);
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.5), (Vector2DReadOnly)new Vector2D(0.1, 0.0));
        Point2D[] expected1 = new Point2D[]{new Point2D(-0.5, 0.5), new Point2D(0.5, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line1), false);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Vector2DReadOnly)new Vector2D(0.0, -8.0));
        Point2D[] expected2 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line2), false);
        Assertions.assertTrue((polygon.intersectionWith((Line2DReadOnly)line2, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2[0], (EuclidGeometry)result1, (double)1.0E-10);
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.0, 1.0), (Vector2DReadOnly)new Vector2D(0.5, 0.0));
        Point2D[] expected3 = new Point2D[]{new Point2D(0.0, 1.0), new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected3, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line3), false);
        Assertions.assertTrue((polygon.intersectionWith((Line2DReadOnly)line3, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected3[0], (EuclidGeometry)result1, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected3[1], (EuclidGeometry)result2, (double)1.0E-10);
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(0.5, 10.0), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        Point2D[] expected4 = new Point2D[]{new Point2D(0.5, 1.0), new Point2D(0.5, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected4, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line4), false);
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(-1.0, -0.5), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        Point2D[] expected5 = new Point2D[]{new Point2D(-0.5, 0.0), new Point2D(0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected5, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line5), false);
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(0.0, -1.5), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        Point2DReadOnly[] expected6 = null;
        result1.set(0.0, 0.0);
        result2.set(0.0, 0.0);
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected6, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line6), false);
        Assertions.assertTrue((polygon.intersectionWith((Line2DReadOnly)line6, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        Line2D line7 = new Line2D((Point2DReadOnly)new Point2D(0.0, -1.5), (Vector2DReadOnly)new Vector2D(0.0, 2.0));
        Point2D[] expected7 = new Point2D[]{new Point2D(0.0, 0.0), new Point2D(0.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected7, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line7), false);
    }

    @Test
    public void testIntersectionWithLine2() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 0.0));
        polygon.update();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(-1.0, 1.0), (Vector2DReadOnly)new Vector2D(0.0, -0.8));
        Point2D[] expected1 = new Point2D[]{new Point2D(-1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line1), false);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(-0.5, 1.0), (Vector2DReadOnly)new Vector2D(0.0, -0.8));
        Point2D[] expected2 = new Point2D[]{new Point2D(-0.5, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line2), false);
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(1.5, 1.0), (Vector2DReadOnly)new Vector2D(0.0, -0.8));
        Point2DReadOnly[] expected3 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected3, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line3), false);
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(-0.8, 0.0), (Vector2DReadOnly)new Vector2D(0.1, 0.0));
        Point2D[] expected4 = new Point2D[]{new Point2D(-1.0, 0.0), new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected4, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line4), false);
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Vector2DReadOnly)new Vector2D(0.0, -0.1));
        Point2D[] expected5 = new Point2D[]{new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected5, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line5), false);
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(-1.0, 0.0), (Vector2DReadOnly)new Vector2D(0.0, -0.1));
        Point2D[] expected6 = new Point2D[]{new Point2D(-1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected6, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line6), false);
    }

    @Test
    public void testIntersectionWithLine3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.update();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(3.0, 1.0), (Vector2DReadOnly)new Vector2D(-2.0, -1.0));
        Point2D[] expected1 = new Point2D[]{new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line1), false);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(2.0, 1.0), (Vector2DReadOnly)new Vector2D(-1.3, -0.8));
        Point2DReadOnly[] expected2 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected2, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line2), false);
    }

    @Test
    public void testIntersectionWithLine4() {
        T polygon = this.createEmptyConvexPolygon2D();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(3.0, 1.0), (Vector2DReadOnly)new Vector2D(-1.6, -0.8));
        Point2DReadOnly[] expected1 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected1, (Point2DReadOnly[])polygon.intersectionWith((Line2DReadOnly)line1), false);
    }

    @Test
    public void testIntersectionWithRay1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D result1 = new Point2D();
        Point2D result2 = new Point2D();
        Line2D ray1 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(0.2, 0.0));
        Point2D[] expected1 = new Point2D[]{new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray1), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray1, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray2 = new Line2D((Point2DReadOnly)new Point2D(-1.0, 0.0), (Vector2DReadOnly)new Vector2D(0.2, 0.0));
        Point2D[] expected2 = new Point2D[]{new Point2D(1.0, 0.0), new Point2D(-1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray2), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray2, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        Line2D ray3 = new Line2D((Point2DReadOnly)new Point2D(2.0, 0.0), (Vector2DReadOnly)new Vector2D(0.2, 0.0));
        Point2DReadOnly[] expected3 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected3, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray3), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray3, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        Line2D ray4 = new Line2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Vector2DReadOnly)new Vector2D(0.2, -0.1));
        Point2D[] expected4 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected4, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray4), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray4, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray5 = new Line2D((Point2DReadOnly)new Point2D(1.5, 1.0), (Vector2DReadOnly)new Vector2D(0.2, -0.1));
        Point2DReadOnly[] expected5 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected5, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray5), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray5, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        Line2D ray6 = new Line2D((Point2DReadOnly)new Point2D(-1.0, -2.0), (Vector2DReadOnly)new Vector2D(0.3, 0.3));
        Point2D[] expected6 = new Point2D[]{new Point2D(0.0, -1.0), new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected6, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray6), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray6, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        Line2D ray7 = new Line2D((Point2DReadOnly)new Point2D(-1.0, -2.0), (Vector2DReadOnly)new Vector2D(0.0, 1.7));
        Point2D[] expected7 = new Point2D[]{new Point2D(-1.0, -1.0), new Point2D(-1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected7, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray7), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray7, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        Line2D ray8 = new Line2D((Point2DReadOnly)new Point2D(-0.5, 0.5), (Vector2DReadOnly)new Vector2D(-0.3, -0.3));
        Point2D[] expected8 = new Point2D[]{new Point2D(-1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected8, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray8), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray8, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray9 = new Line2D((Point2DReadOnly)new Point2D(-0.5, 0.5), (Vector2DReadOnly)new Vector2D(0.15, 0.3));
        Point2D[] expected9 = new Point2D[]{new Point2D(-0.25, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected9, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray9), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray9, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray10 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(-0.15, 0.3));
        Point2D[] expected10 = new Point2D[]{new Point2D(0.25, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected10, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray10), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray10, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray11 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(0.15, 0.3));
        Point2D[] expected11 = new Point2D[]{new Point2D(0.75, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected11, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray11), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray11, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray12 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(0.15, -0.3));
        Point2D[] expected12 = new Point2D[]{new Point2D(1.0, -0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected12, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray12), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray12, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray13 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(0.0, -0.3));
        Point2D[] expected13 = new Point2D[]{new Point2D(0.5, -1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected13, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray13), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray13, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray14 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(0.0, 0.3));
        Point2D[] expected14 = new Point2D[]{new Point2D(0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected14, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray14), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray14, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        Line2D ray15 = new Line2D((Point2DReadOnly)new Point2D(1.5, 1.5), (Vector2DReadOnly)new Vector2D(0.0, 0.3));
        Point2DReadOnly[] expected15 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected15, (Point2DReadOnly[])polygon.intersectionWithRay((Line2DReadOnly)ray15), false);
        Assertions.assertTrue((polygon.intersectionWithRay((Line2DReadOnly)ray15, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsInside() {
        double[][] polygonPoints = new double[][]{{-0.05107802536335158, 0.04155594197133163}, {-0.05052044462374434, 0.1431544119584275}, {0.12219695435431863, 0.14220652470109518}, {0.12219695435431865, -0.041946248489056696}, {0.12163937361471142, -0.1435447184761526}, {-0.05107802536335154, -0.14259683121882027}};
        Point2D testPoint = new Point2D(-0.04907805548171582, 2.6934439541712686E-4);
        T polygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])polygonPoints));
        boolean isInside = polygon.isPointInside((Point2DReadOnly)testPoint);
        Assertions.assertTrue((boolean)isInside);
        Random random = new Random(435657L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolygon2D convexPolygon2D = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random);
            for (Point2DReadOnly vertex : convexPolygon2D.getPolygonVerticesView()) {
                Assertions.assertTrue((boolean)convexPolygon2D.isPointInside(vertex));
            }
        }
    }

    @Test
    public void testIsPointInside1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D point1 = new Point2D(1.0, 1.0);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point1, 1.0E-10));
        Point2D point2 = new Point2D(0.8, 0.9);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point2));
        Point2D point3 = new Point2D(0.8, 1.1);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point3, 0.3));
        Point2D point4 = new Point2D(1.0, 0.9);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point4));
        Point2D point5 = new Point2D(2.0, 1.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point5));
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point5, 1.0));
        Point2D point6 = new Point2D(1.0, 2.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point6));
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point6, 1.0));
    }

    @Test
    public void testIsPointInside2() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.update();
        Assertions.assertTrue((boolean)polygon.isPointInside(0.1, 0.0, 1.0E-10));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.5, 0.0, 1.0E-10));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.9, 0.0, 1.0E-10));
        Assertions.assertFalse((boolean)polygon.isPointInside(0.1, 0.1, 1.0E-10));
        Assertions.assertFalse((boolean)polygon.isPointInside(1.5, 0.0, 1.0E-10));
        Assertions.assertTrue((boolean)polygon.isPointInside(1.0, 0.0));
        Assertions.assertFalse((boolean)polygon.isPointInside(1.0, 1.0000000000000001E-11));
        Assertions.assertTrue((boolean)polygon.isPointInside(1.0, 1.0000000000000001E-11, 1.0E-10));
        Assertions.assertTrue((boolean)polygon.isPointInside(1.5, 0.0, 0.5));
        polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Assertions.assertFalse((boolean)polygon.isPointInside(0.1, 0.0));
        Assertions.assertFalse((boolean)polygon.isPointInside(0.5, 0.0));
        Assertions.assertFalse((boolean)polygon.isPointInside(0.9, 0.0));
        Assertions.assertFalse((boolean)polygon.isPointInside(-0.1, -0.1));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.1, 0.1));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.5, 0.5));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.9, 0.9));
        Assertions.assertTrue((boolean)polygon.isPointInside(0.0, 0.0));
        Assertions.assertTrue((boolean)polygon.isPointInside(1.0, 1.0));
    }

    @Test
    public void testIsPointInside3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(5.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(3.0, 5.0));
        polygon.update();
        Point2D point1 = new Point2D(0.3, 0.0);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point1, 1.0E-10));
        Point2D point2 = new Point2D(0.0, 0.0);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point2, 1.0E-10));
        Point2D point3 = new Point2D(2.0, 2.0);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point3));
        Point2D point4 = new Point2D(1.0, 0.3);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point4, 1.0E-10));
        Point2D point5 = new Point2D(-1.0, 4.0);
        Assertions.assertFalse((boolean)polygon.isPointInside(point5.getX(), point5.getY(), 1.0E-10));
        Point2D point6 = new Point2D(6.0, 7.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point6, 1.0E-10));
        Point2D point7 = new Point2D(10.0, 0.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point7, 1.0E-10));
        Point2D point8 = new Point2D(0.1, 0.2);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point8));
        Point2D point9 = new Point2D(3.5, 4.9);
        Assertions.assertFalse((boolean)polygon.isPointInside(point9.getX(), point9.getY(), 1.0E-10));
        Point2D point10 = new Point2D(3.5, -1.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point10));
    }

    @Test
    public void testIsPointInside4() {
        T polygon = this.createEmptyConvexPolygon2D();
        Point2D point1 = new Point2D(10.0, 0.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point1, 1.0E-10));
    }

    @Test
    public void testIsPointInside5() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-0.06, -0.08));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.14, -0.08));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.14, -0.19));
        polygon.addVertex((Point2DReadOnly)new Point2D(-0.06, -0.19));
        polygon.update();
        Point2D point1 = new Point2D(0.03, 0.0);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point1, 0.02));
        Point2D point2 = new Point2D(0.03, -0.09);
        Assertions.assertTrue((boolean)polygon.isPointInside((Point2DReadOnly)point2));
    }

    @Test
    public void testDistancePoint2dConvexPolygon2d() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D());
        points.add(new Point2D());
        points.add(new Point2D());
        T test = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
        test.distance((Point2DReadOnly)new Point2D());
    }

    @Test
    public void testOrthogonalProjection1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 1.0));
        polygon.update();
        Point2D point1 = new Point2D(0.5, 0.5);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.0, 0.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point1), (double)1.0E-10);
        Point2D point2 = new Point2D(-0.25, -0.25);
        Assertions.assertNull((Object)polygon.orthogonalProjectionCopy((Point2DReadOnly)point2));
        Point2D point3 = new Point2D(-2.0, -2.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point3), (double)1.0E-10);
        Point2D point4 = new Point2D(-0.9, -2.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.9, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point4), (double)1.0E-10);
        Point2D point5 = new Point2D(-1.1, -2.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point5), (double)1.0E-10);
        Point2D point6 = new Point2D(1.8, -1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point6), (double)1.0E-10);
        Point2D point7 = new Point2D(1.8, -0.8);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point7), (double)1.0E-10);
        Point2D point8 = new Point2D(0.5, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.25, -0.25), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point8), (double)1.0E-10);
        Point2D point9 = new Point2D(0.0, 0.5);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-0.25, 0.25), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point9), (double)1.0E-10);
        Point2D point10 = new Point2D(0.0, 0.0);
        Assertions.assertNull((Object)polygon.orthogonalProjectionCopy((Point2DReadOnly)point10));
        Point2D point11 = new Point2D(1.0, -1.0);
        Assertions.assertNull((Object)polygon.orthogonalProjectionCopy((Point2DReadOnly)point11));
        Point2D point12 = new Point2D(-1.1, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, 0.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point12), (double)1.0E-10);
        Point2D point13 = new Point2D(-1.5, 3.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, 1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point13), (double)1.0E-10);
        Point2D point14 = new Point2D(3.0, -1.5);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point14), (double)1.0E-10);
        Point2D point15 = new Point2D(1.6, -1.5);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, -1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point15), (double)1.0E-10);
        Point2D point16 = new Point2D(-2.0, 0.9);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, 0.9), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point16), (double)1.0E-10);
        Point2D point17 = new Point2D(-2.0, -0.9);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(-1.0, -0.9), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point17), (double)1.0E-10);
    }

    @Test
    public void testOrthogonalProjection2() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.orthogonalProjectionCopy((Point2DReadOnly)new Point2D());
    }

    @Test
    public void testOrthogonalProjection3() {
        Point2D vertex = new Point2D(1.0, 2.0);
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex);
        polygon.update();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)new Point2D(0.0, 0.0)), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)new Point2D(1.0, -0.2)), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)new Point2D(1.0, 2.0)), (double)1.0E-10);
    }

    @Test
    public void testOrthogonalProjection4() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 2.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D point1 = new Point2D(1.0, -1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, 1.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point1), (double)1.0E-10);
        Point2D point2 = new Point2D(3.0, 2.1);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, 2.0), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point2), (double)1.0E-10);
        Point2D point3 = new Point2D(0.2, 1.2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(1.0, 1.2), (EuclidGeometry)polygon.orthogonalProjectionCopy((Point2DReadOnly)point3), (double)1.0E-10);
    }

    @Test
    public void testGetClosestEdge() {
        T polygon = this.createSomeValidPolygon();
        Point2D point = new Point2D(1.314592, 6.0221415);
        Assertions.assertFalse((boolean)polygon.isPointInside((Point2DReadOnly)point));
        LineSegment2DBasics closestEdge = polygon.getClosestEdgeCopy((Point2DReadOnly)point);
        Point2DBasics closestVertex = polygon.getClosestVertexCopy((Point2DReadOnly)point);
        int otherEdgeVertexIndex = 0;
        boolean isClosestVertexPartOfClosestEdge = false;
        Point2DReadOnly[] segmentVertices = new Point2DReadOnly[]{closestEdge.getFirstEndpoint(), closestEdge.getSecondEndpoint()};
        for (int i = 0; i < 2; ++i) {
            Point2DReadOnly segmentVertex = segmentVertices[i];
            if (!this.arePointsAtExactlyEqualPosition((Point2DReadOnly)closestVertex, segmentVertex)) continue;
            isClosestVertexPartOfClosestEdge = true;
            if (i != 0) continue;
            otherEdgeVertexIndex = 1;
        }
        Assertions.assertTrue((boolean)isClosestVertexPartOfClosestEdge);
        int numberOfVertices = polygon.getNumberOfVertices();
        int prevIndex = numberOfVertices - 1;
        int nextIndex = 0;
        int i = 0;
        while (i < numberOfVertices) {
            Point2DReadOnly currentPoint = polygon.getVertex(i);
            if (this.arePointsAtExactlyEqualPosition((Point2DReadOnly)closestVertex, currentPoint)) {
                if (i >= numberOfVertices - 1) break;
                nextIndex = i + 1;
                break;
            }
            prevIndex = i++;
        }
        Point2DReadOnly[] neighbourPoints = new Point2DReadOnly[]{polygon.getVertex(prevIndex), polygon.getVertex(nextIndex)};
        int neighbourIndex = 1;
        int wrongNeighbourIndex = 0;
        boolean isClosestEdgeVertexThatIsNotClosestVertexNeighbourOfClosestVertex = false;
        for (int i2 = 0; i2 < 2; ++i2) {
            Point2DReadOnly closestEdgeVertexThatIsNotClosest = segmentVertices[otherEdgeVertexIndex];
            Point2DReadOnly neighbourPoint = neighbourPoints[i2];
            if (!this.arePointsAtExactlyEqualPosition(closestEdgeVertexThatIsNotClosest, neighbourPoint)) continue;
            isClosestEdgeVertexThatIsNotClosestVertexNeighbourOfClosestVertex = true;
            neighbourIndex = i2;
            if (i2 != 0) continue;
            wrongNeighbourIndex = 1;
        }
        Assertions.assertTrue((boolean)isClosestEdgeVertexThatIsNotClosestVertexNeighbourOfClosestVertex);
        Line2D segmentLine = new Line2D(neighbourPoints[neighbourIndex], (Point2DReadOnly)closestVertex);
        Line2D otherLine = new Line2D(neighbourPoints[wrongNeighbourIndex], (Point2DReadOnly)closestVertex);
        Line2DBasics interiorBiSector = segmentLine.interiorBisector((Line2DReadOnly)otherLine);
        boolean isPointBehindLine = interiorBiSector.isPointBehindLine((Point2DReadOnly)point);
        boolean isOtherEdgeVertexBehindLine = interiorBiSector.isPointBehindLine(segmentVertices[otherEdgeVertexIndex]);
        Assertions.assertEquals((Object)isPointBehindLine, (Object)isOtherEdgeVertexBehindLine);
    }

    private boolean arePointsAtExactlyEqualPosition(Point2DReadOnly point1, Point2DReadOnly point2) {
        return point1.getX() == point2.getX() && point1.getY() == point2.getY();
    }

    private T createSomeValidPolygon() {
        double[][] polygonPoints = new double[][]{{-0.05107802536335158, 0.04155594197133163}, {-0.05052044462374434, 0.1431544119584275}, {0.12219695435431863, 0.14220652470109518}, {0.12219695435431865, -0.041946248489056696}, {0.12163937361471142, -0.1435447184761526}, {-0.05107802536335154, -0.14259683121882027}};
        T polygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])polygonPoints));
        return polygon;
    }

    @Test
    public void testOrthogonalProjectionPointConvexPolygon2d() {
        Random random = new Random(32L);
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        Point2D testPoint = new Point2D();
        for (int i = 4; i < 10; ++i) {
            pointList.clear();
            for (int j = 0; j < i; ++j) {
                pointList.add(new Point2D(random.nextDouble(), random.nextDouble()));
            }
            T convexPolygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(pointList));
            for (int k = 0; k < 100; ++k) {
                testPoint.set(random.nextDouble(), random.nextDouble());
                Point2DBasics projectedPoint = convexPolygon.orthogonalProjectionCopy((Point2DReadOnly)testPoint);
                if (convexPolygon.isPointInside((Point2DReadOnly)testPoint)) {
                    Assertions.assertNull((Object)projectedPoint);
                    continue;
                }
                Assertions.assertTrue((boolean)convexPolygon.isPointInside((Point2DReadOnly)projectedPoint, 1.0E-10), (String)("Projected point was not inside the polygon for point\n" + String.valueOf(projectedPoint) + "\nand convex polygon \n" + String.valueOf(convexPolygon)));
            }
        }
    }

    @Test
    public void testGetSignedDistance1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.update();
        Point2D point = new Point2D(2.5, 1.0);
        double distance = polygon.signedDistance((Point2DReadOnly)point);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(EuclidCoreTools.norm((double)2.5, (double)1.0), distance);
    }

    @Test
    public void testGetSignedDistance2() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.update();
        Point2D point1 = new Point2D(2.5, 1.0);
        double distance1 = polygon.signedDistance((Point2DReadOnly)point1);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(EuclidCoreTools.norm((double)1.5, (double)1.0), distance1);
        Point2D point2 = new Point2D(0.5, 1.0);
        double distance2 = polygon.signedDistance((Point2DReadOnly)point2);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(1.0, distance2);
    }

    @Test
    public void testGetSignedDistance3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(10.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 10.0));
        polygon.update();
        Point2D point1 = new Point2D(10.0, 10.0);
        double distance1 = polygon.signedDistance((Point2DReadOnly)point1);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(5.0 * EuclidCoreTools.squareRoot((double)2.0), distance1);
        Point2D point2 = new Point2D(1.2, 1.1);
        double distance2 = polygon.signedDistance((Point2DReadOnly)point2);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(-1.1, distance2);
        Point2D point3 = new Point2D(0.05, 9.8);
        double distance3 = polygon.signedDistance((Point2DReadOnly)point3);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(-0.05, distance3);
        Point2D point4 = new Point2D(9.8, 0.15);
        double distance4 = polygon.signedDistance((Point2DReadOnly)point4);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(-0.5 * EuclidCoreTools.squareRoot((double)0.005000000000000001), distance4);
        Point2D point5 = new Point2D(5.0, -0.15);
        double distance5 = polygon.signedDistance((Point2DReadOnly)point5);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(0.15, distance5);
        Point2D point6 = new Point2D(15.0, -0.15);
        double distance6 = polygon.signedDistance((Point2DReadOnly)point6);
        ConvexPolygon2DBasicsTest.assertDistanceCorrect(EuclidCoreTools.norm((double)5.0, (double)0.15), distance6);
    }

    private static void assertDistanceCorrect(double expected, double actual) {
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-10, (String)"Distance does not equal expected.");
    }

    @Test
    public void testGetClosestEdge1() {
        Point2D vertex1 = new Point2D(0.0, 0.0);
        Point2D vertex2 = new Point2D(-1.0, 0.0);
        Point2D vertex3 = new Point2D(0.0, 1.0);
        Point2D vertex4 = new Point2D(1.0, 1.0);
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.addVertex((Point2DReadOnly)vertex3);
        polygon.addVertex((Point2DReadOnly)vertex4);
        polygon.update();
        LineSegment2D edge1 = new LineSegment2D((Point2DReadOnly)vertex1, (Point2DReadOnly)vertex2);
        LineSegment2D edge2 = new LineSegment2D((Point2DReadOnly)vertex2, (Point2DReadOnly)vertex3);
        LineSegment2D edge3 = new LineSegment2D((Point2DReadOnly)vertex3, (Point2DReadOnly)vertex4);
        LineSegment2D edge4 = new LineSegment2D((Point2DReadOnly)vertex4, (Point2DReadOnly)vertex1);
        Point2D point1 = new Point2D(0.5, 0.1);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge4, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point1), (double)1.0E-10);
        Point2D point2 = new Point2D(-0.5, -0.5);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge1, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point2), (double)1.0E-10);
        Point2D point3 = new Point2D(-0.5, 0.5);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge2, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point3), (double)1.0E-10);
        Point2D point4 = new Point2D(-0.5, 0.25);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge2, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point4), (double)1.0E-10);
        Point2D point5 = new Point2D(-0.1, 3.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge2, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point5), (double)1.0E-10);
        Point2D point6 = new Point2D(0.1, 0.8);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge3, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point6), (double)1.0E-10);
        Point2D point7 = new Point2D(-0.11, 0.2);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge1, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point7), (double)1.0E-10);
    }

    @Test
    public void testGetClosestEdge2() {
        Point2D vertex1 = new Point2D(2.0, 2.0);
        Point2D vertex2 = new Point2D(3.0, 3.0);
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.update();
        LineSegment2D edge1 = new LineSegment2D((Point2DReadOnly)vertex1, (Point2DReadOnly)vertex2);
        Point2D point1 = new Point2D(0.5, 0.1);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge1, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point1), (double)1.0E-10);
        Point2D point2 = new Point2D(4.0, 4.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge1, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point2), (double)1.0E-10);
        Point2D point3 = new Point2D(1.0, 1.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)edge1, (EuclidGeometry)polygon.getClosestEdgeCopy((Point2DReadOnly)point3), (double)1.0E-10);
    }

    @Test
    public void testGetClosestEdge3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D());
        polygon.update();
        Assertions.assertTrue((polygon.getClosestEdgeCopy((Point2DReadOnly)new Point2D()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetClosestEdge4() {
        T polygon = this.createEmptyConvexPolygon2D();
        Assertions.assertTrue((polygon.getClosestEdgeCopy((Point2DReadOnly)new Point2D()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetClosestVertexPoint1() {
        Point2D vertex1 = new Point2D(0.0, 0.0);
        Point2D vertex2 = new Point2D(10.0, 0.0);
        Point2D vertex3 = new Point2D(0.0, 10.0);
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.addVertex((Point2DReadOnly)vertex3);
        polygon.update();
        Point2D point1 = new Point2D(-1.0, -1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex1, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point1), (double)1.0E-10);
        Point2D point2 = new Point2D(1.0, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex1, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point2), (double)1.0E-10);
        Point2D point3 = new Point2D(10.0, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex2, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point3), (double)1.0E-10);
        Point2D point4 = new Point2D(9.8, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex2, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point4), (double)1.0E-10);
        Point2D point5 = new Point2D(10.0, 11.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex3, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point5), (double)1.0E-10);
        Point2D point6 = new Point2D(-3.0, 8.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex3, (EuclidGeometry)polygon.getClosestVertexCopy((Point2DReadOnly)point6), (double)1.0E-10);
    }

    @Test
    public void testGetClosestVertexPoint2() {
        T polygon = this.createEmptyConvexPolygon2D();
        Point2D closestVertex = new Point2D();
        Assertions.assertFalse((boolean)polygon.getClosestVertex((Point2DReadOnly)new Point2D(), (Point2DBasics)closestVertex));
        Assertions.assertTrue((polygon.getClosestVertexCopy((Point2DReadOnly)new Point2D()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testCanObserverSeeEdge1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D observer1 = new Point2D(0.5, 0.5);
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Assertions.assertFalse((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer1));
        }
        Point2D observer2 = new Point2D(-0.5, 0.5);
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            if (polygon.getVertex(i).epsilonEquals((EuclidGeometry)new Point2D(0.0, 0.0), 1.0E-10)) {
                Assertions.assertTrue((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer2));
                continue;
            }
            Assertions.assertFalse((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer2));
        }
        Point2D observer3 = new Point2D(1.5, 1.5);
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            if (polygon.getVertex(i).epsilonEquals((EuclidGeometry)new Point2D(0.0, 1.0), 1.0E-10)) {
                Assertions.assertTrue((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer3));
                continue;
            }
            if (polygon.getVertex(i).epsilonEquals((EuclidGeometry)new Point2D(1.0, 1.0), 1.0E-10)) {
                Assertions.assertTrue((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer3));
                continue;
            }
            Assertions.assertFalse((boolean)polygon.canObserverSeeEdge(i, (Point2DReadOnly)observer3));
        }
    }

    @Test
    public void testCanObserverSeeEdge2() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.update();
        Point2D observer1 = new Point2D(0.0, 0.0);
        boolean seeEdge1 = polygon.canObserverSeeEdge(0, (Point2DReadOnly)observer1);
        boolean seeEdge2 = polygon.canObserverSeeEdge(1, (Point2DReadOnly)observer1);
        Assertions.assertTrue((!(!seeEdge1 && !seeEdge2 || seeEdge1 && seeEdge2) ? 1 : 0) != 0);
    }

    @Test
    public void testCanObserverSeeEdge3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D observer1 = new Point2D(0.0, 0.0);
        Assertions.assertFalse((boolean)polygon.canObserverSeeEdge(0, (Point2DReadOnly)observer1));
    }

    @Test
    public void testIntersectionWithLineSegment1() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D result1 = new Point2D();
        Point2D result2 = new Point2D();
        LineSegment2D segment1 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(2.0, 0.0));
        Point2D[] expected1 = new Point2D[]{new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment1), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment1, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment2 = new LineSegment2D((Point2DReadOnly)new Point2D(-2.0, 0.0), (Point2DReadOnly)new Point2D(2.0, 0.0));
        Point2D[] expected2 = new Point2D[]{new Point2D(-1.0, 0.0), new Point2D(1.0, 0.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment2), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment2, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment3 = new LineSegment2D((Point2DReadOnly)new Point2D(-0.5, 0.0), (Point2DReadOnly)new Point2D(0.5, 0.0));
        Point2DReadOnly[] expected3 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected3, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment3), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment3, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment4 = new LineSegment2D((Point2DReadOnly)new Point2D(-3.5, 0.0), (Point2DReadOnly)new Point2D(-1.5, 0.0));
        Point2DReadOnly[] expected4 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected4, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment4), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment4, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment5 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.5, 0.0), (Point2DReadOnly)new Point2D(0.0, 1.5));
        Point2D[] expected5 = new Point2D[]{new Point2D(-1.0, 0.5), new Point2D(-0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected5, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment5), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment5, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment6 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.0, 0.5), (Point2DReadOnly)new Point2D(-0.5, 1.0));
        Point2D[] expected6 = new Point2D[]{new Point2D(-1.0, 0.5), new Point2D(-0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected6, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment6), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment6, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment7 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.5, 1.0), (Point2DReadOnly)new Point2D(1.5, 1.0));
        Point2D[] expected7 = new Point2D[]{new Point2D(-1.0, 1.0), new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected7, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment7), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment7, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment8 = new LineSegment2D((Point2DReadOnly)new Point2D(-2.5, 1.0), (Point2DReadOnly)new Point2D(-1.5, 1.0));
        Point2DReadOnly[] expected8 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected8, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment8), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment8, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment9 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(1.0, 2.0));
        Point2D[] expected9 = new Point2D[]{new Point2D(1.0, 0.0), new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected9, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment9), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment9, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment10 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(1.0, 0.5));
        Point2D[] expected10 = new Point2D[]{new Point2D(1.0, 0.0), new Point2D(1.0, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected10, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment10), false);
        result1.set(expected10[0]);
        result2.set(expected10[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment10, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected10[1]);
        result2.set(expected10[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment10, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment11 = new LineSegment2D((Point2DReadOnly)new Point2D(-0.5, 1.0), (Point2DReadOnly)new Point2D(-1.0, 0.5));
        Point2D[] expected11 = new Point2D[]{new Point2D(-1.0, 0.5), new Point2D(-0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected11, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment11), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment11, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment12 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.5, 0.5), (Point2DReadOnly)new Point2D(1.5, 0.5));
        Point2D[] expected12 = new Point2D[]{new Point2D(-1.0, 0.5), new Point2D(1.0, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected12, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment12), false);
        result1.set(expected12[0]);
        result2.set(expected12[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment12, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected12[1]);
        result2.set(expected12[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment12, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment13 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, -1.5), (Point2DReadOnly)new Point2D(1.5, -1.5));
        Point2DReadOnly[] expected13 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected13, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment13), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment13, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment14 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, 1.5), (Point2DReadOnly)new Point2D(1.5, 1.5));
        Point2DReadOnly[] expected14 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected14, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment14), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment14, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment15 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(0.5, 1.0));
        Point2D[] expected15 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected15, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment15), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment15, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment16 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(1.0, 0.5));
        Point2D[] expected16 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(1.0, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected16, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment16), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment16, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment17 = new LineSegment2D((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected17 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected17, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment17), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment17, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment18 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 0.5), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected18 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(1.0, 0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected18, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment18), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment18, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment19 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.5, 1.0), (Point2DReadOnly)new Point2D(-0.5, 1.0));
        Point2D[] expected19 = new Point2D[]{new Point2D(-1.0, 1.0), new Point2D(-0.5, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected19, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment19), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment19, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment20 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.5, 1.0), (Point2DReadOnly)new Point2D(-1.0, 1.0));
        Point2D[] expected20 = new Point2D[]{new Point2D(-1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected20, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment20), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment20, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment21 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)new Point2D(-1.5, 1.0));
        Point2D[] expected21 = new Point2D[]{new Point2D(-1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected21, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment21), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment21, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment22 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(1.5, 1.0));
        Point2D[] expected22 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected22, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment22), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment22, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment23 = new LineSegment2D((Point2DReadOnly)new Point2D(1.5, 1.0), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected23 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected23, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment23), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment23, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment24 = new LineSegment2D((Point2DReadOnly)new Point2D(1.5, 1.5), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected24 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected24, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment24), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment24, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment25 = new LineSegment2D((Point2DReadOnly)new Point2D(0.5, 1.5), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected25 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected25, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment25), false);
        result1.set(expected25[0]);
        result2.set(expected25[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment25, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment26 = new LineSegment2D((Point2DReadOnly)new Point2D(-1.0, -1.0), (Point2DReadOnly)new Point2D(0.8, 1.0));
        Point2D[] expected26 = new Point2D[]{new Point2D(0.8, 1.0), new Point2D(-1.0, -1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected26, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment26), false);
        result1.set(expected26[0]);
        result2.set(expected26[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment26, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected26[1]);
        result2.set(expected26[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment26, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment27 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(-1.0, -1.0));
        Point2D[] expected27 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(-1.0, -1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected27, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment27), false);
        result1.set(expected27[0]);
        result2.set(expected27[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment27, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected27[1]);
        result2.set(expected27[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment27, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment28 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, -0.5), (Point2DReadOnly)new Point2D(1.0, 0.0));
        Point2D[] expected28 = new Point2D[]{new Point2D(1.0, 0.0), new Point2D(1.0, -0.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected28, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment28), false);
        result1.set(expected28[0]);
        result2.set(expected28[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment28, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected28[1]);
        result2.set(expected28[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment28, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment29 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, -1.5), (Point2DReadOnly)new Point2D(1.0, 0.5));
        Point2D[] expected29 = new Point2D[]{new Point2D(1.0, 0.5), new Point2D(1.0, -1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected29, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment29), false);
        result1.set(expected29[0]);
        result2.set(expected29[0]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment29, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        result1.set(expected29[1]);
        result2.set(expected29[1]);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment29, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionWithLineSegment2() {
        T polygon = this.createEmptyConvexPolygon2D();
        Point2D result1 = new Point2D();
        Point2D result2 = new Point2D();
        LineSegment2D segment1 = new LineSegment2D();
        Point2DReadOnly[] expected1 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected1, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment1), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment1, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionWithLineSegment3() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D result1 = new Point2D();
        Point2D result2 = new Point2D();
        LineSegment2D segment1 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(2.0, 0.0));
        Point2DReadOnly[] expected1 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected1, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment1), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment1, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment2 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(2.0, 0.0));
        Point2D[] expected2 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment2), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment2, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment3 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected3 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected3, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment3), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment3, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionWithLineSegment4() {
        T polygon = this.createEmptyConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(3.0, 3.0));
        polygon.update();
        Point2D result1 = new Point2D();
        Point2D result2 = new Point2D();
        LineSegment2D segment1 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(3.0, 3.0));
        Point2D[] expected1 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(3.0, 3.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected1, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment1), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment1, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment2 = new LineSegment2D((Point2DReadOnly)new Point2D(1.5, 1.5), (Point2DReadOnly)new Point2D(2.5, 2.5));
        Point2D[] expected2 = new Point2D[]{new Point2D(1.5, 1.5), new Point2D(2.5, 2.5)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected2, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment2), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment2, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment3 = new LineSegment2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Point2DReadOnly)new Point2D(3.5, 3.5));
        Point2D[] expected3 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(3.0, 3.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected3, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment3), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment3, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment4 = new LineSegment2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(3.0, 3.0));
        Point2D[] expected4 = new Point2D[]{new Point2D(1.0, 1.0), new Point2D(3.0, 3.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected4, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment4), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment4, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
        LineSegment2D segment5 = new LineSegment2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(0.5, 0.5));
        Point2DReadOnly[] expected5 = null;
        ConvexPolygon2DBasicsTest.assertPointsEqual(expected5, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment5), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment5, (Point2DBasics)result1, (Point2DBasics)result2) == 0 ? 1 : 0) != 0);
        LineSegment2D segment6 = new LineSegment2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected6 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected6, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment6), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment6, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment7 = new LineSegment2D((Point2DReadOnly)new Point2D(2.0, 0.5), (Point2DReadOnly)new Point2D(2.0, 5.0));
        Point2D[] expected7 = new Point2D[]{new Point2D(2.0, 2.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected7, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment7), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment7, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment8 = new LineSegment2D((Point2DReadOnly)new Point2D(2.0, 0.5), (Point2DReadOnly)new Point2D(1.0, 1.0));
        Point2D[] expected8 = new Point2D[]{new Point2D(1.0, 1.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected8, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment8), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment8, (Point2DBasics)result1, (Point2DBasics)result2) == 1 ? 1 : 0) != 0);
        LineSegment2D segment9 = new LineSegment2D((Point2DReadOnly)new Point2D(4.0, 4.0), (Point2DReadOnly)new Point2D(2.0, 2.0));
        Point2D[] expected9 = new Point2D[]{new Point2D(3.0, 3.0), new Point2D(2.0, 2.0)};
        ConvexPolygon2DBasicsTest.assertPointsEqual((Point2DReadOnly[])expected9, (Point2DReadOnly[])polygon.intersectionWith((LineSegment2DReadOnly)segment9), false);
        Assertions.assertTrue((polygon.intersectionWith((LineSegment2DReadOnly)segment9, (Point2DBasics)result1, (Point2DBasics)result2) == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(89762L);
        int numberOfVertices = 3 + random.nextInt(10);
        T firstPolygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)0.0, (double)0.5, (int)numberOfVertices)));
        T secondPolygon = this.createConvexPolygon2D((Vertex2DSupplier)firstPolygon);
        Assertions.assertTrue((boolean)firstPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
        Assertions.assertTrue((boolean)secondPolygon.geometricallyEquals(firstPolygon, 1.0E-10));
        Assertions.assertTrue((boolean)firstPolygon.geometricallyEquals(firstPolygon, 1.0E-10));
        Assertions.assertTrue((boolean)secondPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = 3 + random.nextInt(10);
            firstPolygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)0.0, (double)0.5, (int)numberOfVertices)));
            firstPolygon.scale(10.0);
            secondPolygon = this.createConvexPolygon2D((Vertex2DSupplier)firstPolygon);
            secondPolygon.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), 1.0000000000000001E-11), (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)firstPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
            secondPolygon = this.createConvexPolygon2D((Vertex2DSupplier)firstPolygon);
            secondPolygon.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), 1.0000000000000001E-7), (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)firstPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = 3 + random.nextInt(10);
            firstPolygon = this.createConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)0.0, (double)0.5, (int)numberOfVertices)));
            firstPolygon.scale(10.0);
            secondPolygon = this.createConvexPolygon2D((Vertex2DSupplier)firstPolygon);
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.900000000000001E-11);
            secondPolygon.translate((Tuple2DReadOnly)translation);
            Assertions.assertTrue((boolean)firstPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
            secondPolygon = this.createConvexPolygon2D((Vertex2DSupplier)firstPolygon);
            translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-10);
            secondPolygon.translate((Tuple2DReadOnly)translation);
            Assertions.assertFalse((boolean)firstPolygon.geometricallyEquals(secondPolygon, 1.0E-10));
        }
    }

    private static void assertPointsEqual(Point2DReadOnly[] expected, Point2DReadOnly[] actual, boolean enforceOrder) {
        if (expected == null || actual == null) {
            Assertions.assertTrue((expected == actual ? 1 : 0) != 0, (String)"Expected did not equal actual. One of them was null.");
            return;
        }
        Assertions.assertEquals((int)expected.length, (int)actual.length, (String)"Array lengths are not equal.");
        int points = expected.length;
        for (int i = 0; i < points; ++i) {
            if (enforceOrder) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected[i], (EuclidGeometry)actual[i], (double)1.0E-10);
                continue;
            }
            boolean foundPoint = false;
            for (int j = 0; j < points; ++j) {
                if (!expected[i].epsilonEquals((EuclidGeometry)actual[j], 1.0E-10)) continue;
                foundPoint = true;
            }
            Assertions.assertTrue((boolean)foundPoint, (String)"Did not find point.");
        }
    }

    @Test
    public void testRemoveVertex() {
        Random random = new Random(6325L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            ArrayList vertices = new ArrayList();
            T polygon = this.createRandomConvexPolygon2D(random);
            polygon.getPolygonVerticesView().forEach(vertex -> vertices.add(new Point2D((Tuple2DReadOnly)vertex)));
            int numberOfVerticesToRemove = random.nextInt(polygon.getNumberOfVertices());
            for (j = 0; j < numberOfVerticesToRemove; ++j) {
                int indexToRemove = random.nextInt(polygon.getNumberOfVertices());
                polygon.removeVertex(indexToRemove);
                Collections.swap(vertices, indexToRemove, vertices.size() - 1);
                vertices.remove(vertices.size() - 1);
            }
            Assertions.assertEquals((int)polygon.getNumberOfVertices(), (int)vertices.size());
            for (j = 0; j < vertices.size(); ++j) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)vertices.get(j)), (EuclidGeometry)polygon.getVertexUnsafe(j), (double)0.0);
            }
        }
    }

    @Test
    public void testApplyTransform() {
        T actualPolygon;
        T expectedPolygon;
        Vertex2DSupplier transformedVertices;
        T originalPolygon;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(234L);
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(v -> v.applyTransform((Transform)transform)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            transform = new AffineTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(arg_0 -> ConvexPolygon2DBasicsTest.lambda$testApplyTransform$3((AffineTransform)transform, arg_0)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            transform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(v -> v.applyTransform((Transform)transform)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            transform = new AffineTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            transform.getLinearTransform().setToYawMatrix(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            transform.getLinearTransform().appendScale(EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random), 1.0);
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(arg_0 -> ConvexPolygon2DBasicsTest.lambda$testApplyTransform$5((AffineTransform)transform, arg_0)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(v -> v.applyTransform((Transform)transform, false)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform, false);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            originalPolygon = this.createRandomConvexPolygon2D(random);
            transformedVertices = Vertex2DSupplier.asVertex2DSupplier(originalPolygon.getPolygonVerticesView().stream().map(Point2D::new).peek(arg_0 -> ConvexPolygon2DBasicsTest.lambda$testApplyTransform$7((AffineTransform)transform, arg_0)).collect(Collectors.toList()));
            expectedPolygon = this.createConvexPolygon2D(transformedVertices);
            actualPolygon = this.createConvexPolygon2D((Vertex2DSupplier)originalPolygon);
            actualPolygon.getBoundingBox();
            actualPolygon.getCentroid();
            actualPolygon.applyTransform((Transform)transform, false);
            EuclidCoreTestTools.assertEquals(expectedPolygon, actualPolygon, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getCentroid(), (EuclidGeometry)actualPolygon.getCentroid(), (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolygon.getBoundingBox(), (EuclidGeometry)actualPolygon.getBoundingBox(), (double)1.0E-10);
        }
    }

    private static /* synthetic */ void lambda$testApplyTransform$7(AffineTransform transform, Point2D v) {
        v.applyTransform((Transform)transform, false);
    }

    private static /* synthetic */ void lambda$testApplyTransform$5(AffineTransform transform, Point2D v) {
        v.applyTransform((Transform)transform);
    }

    private static /* synthetic */ void lambda$testApplyTransform$3(AffineTransform transform, Point2D v) {
        v.applyTransform((Transform)transform);
    }
}

