/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Tuple3DReadOnlyTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Tuple3DBasicsTest<T extends Tuple3DBasics>
extends Tuple3DReadOnlyTest<T> {
    @Test
    public void testSetters() throws Exception {
        double expectedZ;
        double z;
        double y;
        double x;
        Tuple3DBasics tuple1;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            double y2 = random.nextDouble();
            tuple1.setY(y2);
            Assertions.assertEquals((double)tuple1.getY(), (double)y2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            double z2 = random.nextDouble();
            tuple1.setZ(z2);
            Assertions.assertEquals((double)tuple1.getZ(), (double)z2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.setElement(0, x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            tuple1.setElement(1, y);
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
            tuple1.setElement(2, z);
            Assertions.assertEquals((double)tuple1.getZ(), (double)z, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(-1, random.nextDouble()));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(3, random.nextDouble()));
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.setElement(Axis3D.X, x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            tuple1.setElement(Axis3D.Y, y);
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
            tuple1.setElement(Axis3D.Z, z);
            Assertions.assertEquals((double)tuple1.getZ(), (double)z, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(-1, random.nextDouble()));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(3, random.nextDouble()));
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.set(x, y, z);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)z, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.set((Tuple3DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.set((Tuple3DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            Point2D tuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedZ = tuple1.getZ();
            tuple1.set((Tuple2DReadOnly)tuple2D);
            Assertions.assertEquals((double)tuple2D.getX(), (double)tuple1.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2D.getY(), (double)tuple1.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple1.getZ(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            Point2D tuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedZ = random.nextDouble();
            tuple1.set((Tuple2DReadOnly)tuple2D, expectedZ);
            Assertions.assertEquals((double)tuple2D.getX(), (double)tuple1.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2D.getY(), (double)tuple1.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple1.getZ(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple1.set(tupleArray);
            Assertions.assertEquals((double)tuple1.getX(), (double)tupleArray[0], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)tupleArray[1], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)tupleArray[2], (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple1.set(2, tupleArray);
            Assertions.assertEquals((double)tuple1.getX(), (double)tupleArray[2], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)tupleArray[3], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)tupleArray[4], (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple1.set(tupleArray);
            Assertions.assertTrue((tuple1.getX() == (double)tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getY() == (double)tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getZ() == (double)tupleArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple1.set(2, tupleArray);
            Assertions.assertTrue((tuple1.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getY32() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getZ32() == tupleArray[4] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(5, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set((DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(0, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(1, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)matrix.get(2, 0), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set(5, (DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(5, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(6, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)matrix.get(7, 0), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple3DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set(5, 2, (DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(5, 2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(6, 2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)matrix.get(7, 2), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Tuple3DBasics tuple = (Tuple3DBasics)this.createEmptyTuple();
            tuple.setX(random.nextDouble());
            tuple.setY(random.nextDouble());
            tuple.setZ(random.nextDouble());
            tuple.setToNaN();
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getX()));
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getY()));
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getZ()));
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Tuple3DBasics tuple = (Tuple3DBasics)this.createEmptyTuple();
            tuple.setX(random.nextDouble());
            tuple.setY(random.nextDouble());
            tuple.setZ(random.nextDouble());
            tuple.setToZero();
            Assertions.assertTrue((tuple.getX() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAbsolute() throws Exception {
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                for (double signZ = -1.0; signZ <= 1.0; signZ += 2.0) {
                    double xPos = random.nextDouble();
                    double yPos = random.nextDouble();
                    double zPos = random.nextDouble();
                    tuple1.setX(signX * xPos);
                    tuple1.setY(signY * yPos);
                    tuple1.setZ(signZ * zPos);
                    tuple2.setAndAbsolute((Tuple3DReadOnly)tuple1);
                    Assertions.assertEquals((double)tuple2.getX(), (double)xPos, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple2.getY(), (double)yPos, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple2.getZ(), (double)zPos, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getX(), (double)(signX * xPos), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getY(), (double)(signY * yPos), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getZ(), (double)(signZ * zPos), (double)this.getEpsilon());
                    tuple1.absolute();
                    Assertions.assertEquals((double)tuple1.getX(), (double)xPos, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getY(), (double)yPos, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getZ(), (double)zPos, (double)this.getEpsilon());
                }
            }
        }
    }

    @Test
    public void testNegate() throws Exception {
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                for (double signZ = -1.0; signZ <= 1.0; signZ += 2.0) {
                    double xOriginal = signX * random.nextDouble();
                    double yOriginal = signY * random.nextDouble();
                    double zOriginal = signZ * random.nextDouble();
                    tuple1.setX(xOriginal);
                    tuple1.setY(yOriginal);
                    tuple1.setZ(zOriginal);
                    tuple2.setAndNegate((Tuple3DReadOnly)tuple1);
                    Assertions.assertEquals((double)tuple2.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple2.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple2.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getX(), (double)xOriginal, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getY(), (double)yOriginal, (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getZ(), (double)zOriginal, (double)this.getEpsilon());
                    tuple1.negate();
                    Assertions.assertEquals((double)tuple1.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                    Assertions.assertEquals((double)tuple1.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                }
            }
        }
    }

    @Test
    public void testClip() throws Exception {
        double max;
        double min;
        double max2;
        int i;
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(max2 + random.nextDouble());
            tuple1.setY(max2 + random.nextDouble());
            tuple1.setZ(max2 + random.nextDouble());
            tuple1.clipToMax(max2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple1.setX(max2 - random.nextDouble());
            tuple1.setY(max2 - random.nextDouble());
            tuple1.setZ(max2 - random.nextDouble());
            tuple1.set((Tuple3DReadOnly)tuple2);
            tuple1.clipToMax(max2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(max2 + random.nextDouble());
            tuple2.setY(max2 + random.nextDouble());
            tuple2.setZ(max2 + random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple2.setX(max2 - random.nextDouble());
            tuple2.setY(max2 - random.nextDouble());
            tuple2.setZ(max2 - random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple3DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.setZ(min - random.nextDouble());
            tuple1.clipToMin(min);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple1.set((Tuple3DReadOnly)tuple2);
            tuple1.clipToMin(min);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple2.setZ(min - random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple3DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.setZ(min - random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(max + random.nextDouble());
            tuple1.setY(max + random.nextDouble());
            tuple1.setZ(max + random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple1.set((Tuple3DReadOnly)tuple2);
            tuple1.clipToMinMax(min, max);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple2.setZ(min - random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(max + random.nextDouble());
            tuple2.setY(max + random.nextDouble());
            tuple2.setZ(max + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple3DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
    }

    @Test
    public void testClipToMaxNorm() throws Exception {
        RotationMatrix rotationMatrix;
        double tupleNorm;
        double maxNorm;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            maxNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)10.0);
            tupleNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Tuple3DBasics expectedTuple = (Tuple3DBasics)this.createTuple(1.0, 0.0, 0.0);
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix.transform((Tuple3DReadOnly)expectedTuple, expectedTuple);
            Tuple3DBasics actualTuple = (Tuple3DBasics)this.createEmptyTuple();
            actualTuple.setAndScale(tupleNorm, (Tuple3DReadOnly)expectedTuple);
            if (maxNorm > tupleNorm) {
                expectedTuple.scale(tupleNorm);
                Assertions.assertFalse((boolean)actualTuple.clipToMaxNorm(maxNorm));
            } else {
                expectedTuple.scale(maxNorm);
                Assertions.assertTrue((boolean)actualTuple.clipToMaxNorm(maxNorm));
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i + ", maxNorm: " + maxNorm), (EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)(5.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            maxNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0E-7);
            tupleNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Tuple3DBasics actualTuple = (Tuple3DBasics)this.createTuple(tupleNorm, 0.0, 0.0);
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix.transform((Tuple3DReadOnly)actualTuple, actualTuple);
            Assertions.assertTrue((boolean)actualTuple.clipToMaxNorm(maxNorm));
            EuclidCoreTestTools.assertTuple3DIsSetToZero((String)("Iteration: " + i + ", maxNorm: " + maxNorm), (Tuple3DReadOnly)actualTuple);
        }
    }

    @Test
    public void testAdd() throws Exception {
        double z;
        double y;
        double x;
        double zOld;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple3 = (Tuple3DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.addX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)yOld, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)zOld, (double)this.getEpsilon());
            tuple1.addY(y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)zOld, (double)this.getEpsilon());
            tuple1.addZ(z);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + z), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.add(x, y, z);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + z), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.add((Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + tuple2.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple3.setZ(random.nextDouble());
            tuple1.add((Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() + tuple3.getZ()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSub() throws Exception {
        double z;
        double y;
        double x;
        double zOld;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple3 = (Tuple3DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.subX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)yOld, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)zOld, (double)this.getEpsilon());
            tuple1.subY(y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)zOld, (double)this.getEpsilon());
            tuple1.subZ(z);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - z), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            tuple1.set(xOld, yOld, zOld);
            tuple1.sub(x, y, z);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - z), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.sub((Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - tuple2.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.sub((Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() - tuple3.getZ()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testScale() throws Exception {
        double zOld;
        double yOld;
        double xOld;
        double scale;
        double zOld2;
        double yOld2;
        double xOld2;
        int i;
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple3 = (Tuple3DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            zOld2 = random.nextDouble();
            double scale2 = random.nextDouble();
            tuple1.set(xOld2, yOld2, zOld2);
            tuple1.scale(scale2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld2 * scale2), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            zOld2 = random.nextDouble();
            double scaleX = random.nextDouble();
            double scaleY = random.nextDouble();
            double scaleZ = random.nextDouble();
            tuple1.set(xOld2, yOld2, zOld2);
            tuple1.scale(scaleX, scaleY, scaleZ);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scaleX), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scaleY), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld2 * scaleZ), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.setAndScale(scale, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale + tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld * scale + tuple2.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale + tuple3.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple3DReadOnly)tuple1);
            tuple1.scaleAdd(scale, (Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale + tuple3.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.scaleSub(scale, (Tuple3DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale - tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld * scale - tuple2.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.scaleSub(scale, (Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale - tuple3.getZ()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple3DReadOnly)tuple1);
            tuple1.scaleSub(scale, (Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale - tuple3.getZ()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        double alpha;
        int i;
        Random random = new Random(621541L);
        Tuple3DBasics tuple1 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple2 = (Tuple3DBasics)this.createEmptyTuple();
        Tuple3DBasics tuple3 = (Tuple3DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            double xOld = random.nextDouble();
            double yOld = random.nextDouble();
            double zOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple1.interpolate((Tuple3DReadOnly)tuple2, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)xOld, (double)tuple2.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)yOld, (double)tuple2.getY(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)EuclidCoreTools.interpolate((double)zOld, (double)tuple2.getZ(), (double)alpha), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.interpolate((Tuple3DReadOnly)tuple2, (Tuple3DReadOnly)tuple3, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)tuple2.getX(), (double)tuple3.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)tuple2.getY(), (double)tuple3.getY(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)EuclidCoreTools.interpolate((double)tuple2.getZ(), (double)tuple3.getZ(), (double)alpha), (double)this.getEpsilon());
        }
    }
}

