/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Sphere3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    void testConstructors() throws Exception {
        Sphere3D sphere3D;
        Point3D center;
        double radius;
        int i;
        Random random = new Random(19889566L);
        Sphere3D sphere3D2 = new Sphere3D();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)sphere3D2.getPosition());
        Assertions.assertEquals((double)1.0, (double)sphere3D2.getRadius());
        for (i = 0; i < 1000; ++i) {
            radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Sphere3D sphere3D3 = new Sphere3D(radius);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)sphere3D3.getPosition());
            Assertions.assertEquals((double)radius, (double)sphere3D3.getRadius());
        }
        for (i = 0; i < 1000; ++i) {
            radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            center = EuclidCoreRandomTools.nextPoint3D((Random)random);
            sphere3D = new Sphere3D((Point3DReadOnly)center, radius);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)center, (EuclidGeometry)sphere3D.getPosition(), (double)1.0E-12);
            Assertions.assertEquals((double)radius, (double)sphere3D.getRadius());
        }
        for (i = 0; i < 1000; ++i) {
            radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            center = EuclidCoreRandomTools.nextPoint3D((Random)random);
            sphere3D = new Sphere3D(center.getX(), center.getY(), center.getZ(), radius);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)center, (EuclidGeometry)sphere3D.getPosition(), (double)1.0E-12);
            Assertions.assertEquals((double)radius, (double)sphere3D.getRadius());
        }
        for (i = 0; i < 1000; ++i) {
            Sphere3D original = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D copy = new Sphere3D((Sphere3DReadOnly)original);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)copy, (double)1.0E-12);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(16324321L);
        for (int i = 0; i < 1000; ++i) {
            Sphere3D sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)sphere3D.containsNaN());
            Assertions.assertFalse((boolean)sphere3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)Double.isNaN(sphere3D.getRadius()));
            sphere3D.setToNaN();
            Assertions.assertTrue((boolean)sphere3D.containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertTrue((boolean)Double.isNaN(sphere3D.getRadius()));
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Sphere3D sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)sphere3D.getPosition(), 1.0E-12));
            Assertions.assertNotEquals((double)0.0, (double)sphere3D.getRadius());
            sphere3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertEquals((double)0.0, (double)sphere3D.getRadius());
        }
    }

    @Test
    void testSetters() throws Exception {
        Sphere3D actual;
        Sphere3D expected;
        int i;
        Random random = new Random(45837543L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextSphere3D((Random)random);
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set(expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextSphere3D((Random)random);
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Sphere3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextSphere3D((Random)random);
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set(expected.getPosition().getX(), expected.getPosition().getY(), expected.getPosition().getZ(), expected.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Sphere3D().set(1.0, 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextSphere3D((Random)random);
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Point3DReadOnly)expected.getPosition(), expected.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Sphere3D().set(1.0, 1.0, 1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        double distanceFromCenter;
        Vector3D direction;
        Sphere3D sphere3D;
        int i;
        Random random = new Random(12116892L);
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() * sphere3D.getRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertTrue((boolean)sphere3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() + sphere3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertFalse((boolean)sphere3D.isPointInside((Point3DReadOnly)pointOutside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        double distanceFromCenter;
        Vector3D direction;
        Sphere3D sphere3D;
        int i;
        Random random = new Random(2309819L);
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() * sphere3D.getRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            expectedClosestPoint.scaleAdd(sphere3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            expectedNormal.setAndNormalize((Tuple3DReadOnly)direction);
            Assertions.assertTrue((boolean)sphere3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() + sphere3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            expectedClosestPoint.scaleAdd(sphere3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            expectedNormal.setAndNormalize((Tuple3DReadOnly)direction);
            Assertions.assertFalse((boolean)sphere3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Sphere3D expected;
        Sphere3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            expected = new Sphere3D((Sphere3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            expected = new Sphere3D((Sphere3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Sphere3D expected;
        Sphere3D original;
        Sphere3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            original = new Sphere3D((Sphere3DReadOnly)actual);
            expected = new Sphere3D((Sphere3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextSphere3D((Random)random);
            original = new Sphere3D((Sphere3DReadOnly)actual);
            expected = new Sphere3D((Sphere3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testDistance() throws Exception {
        double distanceFromCenter;
        Vector3D direction;
        Sphere3D sphere3D;
        int i;
        Random random = new Random(12116892L);
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() * sphere3D.getRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertEquals((double)0.0, (double)sphere3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() + sphere3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertEquals((double)(distanceFromCenter - sphere3D.getRadius()), (double)sphere3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        double distanceFromCenter;
        Vector3D direction;
        Sphere3D sphere3D;
        int i;
        Random random = new Random(12116892L);
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() * sphere3D.getRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertEquals((double)(distanceFromCenter - sphere3D.getRadius()), (double)sphere3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() + sphere3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertEquals((double)(distanceFromCenter - sphere3D.getRadius()), (double)sphere3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        double distanceFromCenter;
        Vector3D direction;
        Sphere3D sphere3D;
        int i;
        Random random = new Random(9560362L);
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() * sphere3D.getRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Assertions.assertNull((Object)sphere3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            distanceFromCenter = random.nextDouble() + sphere3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            Point3D expectedProjection = new Point3D();
            expectedProjection.scaleAdd(sphere3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphere3D.getPosition());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)sphere3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testIntersectionWith() throws Exception {
        Sphere3D sphere3D;
        int i;
        Random random = new Random(10688467L);
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Point3D expectedIntersection1 = new Point3D();
            Point3D expectedIntersection2 = new Point3D();
            expectedIntersection1.add((Tuple3DReadOnly)sphere3D.getPosition(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)sphere3D.getRadius()));
            expectedIntersection2.add((Tuple3DReadOnly)sphere3D.getPosition(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)sphere3D.getRadius()));
            Line3D line = new Line3D((Point3DReadOnly)expectedIntersection1, (Point3DReadOnly)expectedIntersection2);
            line.getPoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)line.getDirection(), (Tuple3DReadOnly)line.getPoint());
            Point3D actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            Assertions.assertEquals((int)2, (int)sphere3D.intersectionWith((Line3DReadOnly)line, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Vector3D normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnSphere = new Point3D();
            pointOnSphere.setAndScale(sphere3D.getRadius(), (Tuple3DReadOnly)normal);
            pointOnSphere.add((Tuple3DReadOnly)sphere3D.getPosition());
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            Point3D pointOnLine = new Point3D();
            pointOnLine.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSphere);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnLine);
            Line3D line = new Line3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((int)0, (int)sphere3D.intersectionWith((Line3DReadOnly)line, null, null));
        }
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(34201L);
        double epsilon = 1.0E-7;
        Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random);
        double radius = random.nextDouble();
        Sphere3D firstSphere = new Sphere3D(center.getX(), center.getY(), center.getZ(), radius);
        Sphere3D secondSphere = new Sphere3D(center.getX(), center.getY(), center.getZ(), radius);
        Assertions.assertTrue((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
        Assertions.assertTrue((boolean)secondSphere.geometricallyEquals((EuclidGeometry)firstSphere, epsilon));
        Assertions.assertTrue((boolean)firstSphere.geometricallyEquals((EuclidGeometry)firstSphere, epsilon));
        Assertions.assertTrue((boolean)secondSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
        for (i = 0; i < 1000; ++i) {
            center = EuclidCoreRandomTools.nextPoint3D((Random)random);
            radius = random.nextDouble();
            firstSphere = new Sphere3D((Point3DReadOnly)center, radius);
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius + epsilon * 0.99);
            Assertions.assertTrue((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius - epsilon * 0.99);
            Assertions.assertTrue((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            center = EuclidCoreRandomTools.nextPoint3D((Random)random);
            radius = random.nextDouble();
            firstSphere = new Sphere3D((Point3DReadOnly)center, radius);
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius + epsilon * 1.01);
            Assertions.assertFalse((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius - epsilon * 1.01);
            Assertions.assertFalse((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            center = EuclidCoreRandomTools.nextPoint3D((Random)random);
            radius = random.nextDouble();
            firstSphere = new Sphere3D((Point3DReadOnly)center, radius);
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius);
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            secondSphere.getPosition().add((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
            secondSphere = new Sphere3D((Point3DReadOnly)center, radius);
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            secondSphere.getPosition().add((Tuple3DReadOnly)translation);
            Assertions.assertFalse((boolean)firstSphere.geometricallyEquals((EuclidGeometry)secondSphere, epsilon));
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        for (int i = 0; i < 1000; ++i) {
            Sphere3D sphere = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = sphere.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            Assertions.assertTrue((boolean)sphere.isPointInside(supportingVertex, 1.0E-12));
            supportingVertexTranslated.scaleAdd(1.0E-6, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)sphere.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-12));
            supportingVertexTranslated.scaleAdd(0.01, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Vector3D expectedNormal = new Vector3D();
            expectedNormal.sub((Tuple3DReadOnly)supportingVertexTranslated, (Tuple3DReadOnly)supportingVertex);
            expectedNormal.normalize();
            Vector3D actualNormal = new Vector3D();
            sphere.evaluatePoint3DCollision((Point3DReadOnly)supportingVertexTranslated, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testGetBoundingBox() throws Exception {
        Random random = new Random(36342L);
        for (int i = 0; i < 1000; ++i) {
            Sphere3D sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(sphere3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = sphere3D.getBoundingBox();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBoundingBox, (EuclidGeometry)actualBoundingBox, (double)1.0E-12);
        }
    }
}

