/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Triangle3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.convexPolytope.tools.IcoSphereFactory;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidPolytopeToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testIsPoint3DOnSideOfLine3D() throws Exception {
        int i;
        Random random = new Random(243234L);
        for (i = 0; i < 1000; ++i) {
            Line3D line3D = EuclidGeometryRandomTools.nextLine3D((Random)random);
            Line2D line2D = new Line2D((Point2DReadOnly)new Point2D((Tuple3DReadOnly)line3D.getPoint()), (Vector2DReadOnly)new Vector2D((Tuple3DReadOnly)line3D.getDirection()));
            Point3D query3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point2D query2D = new Point2D((Tuple3DReadOnly)query3D);
            Axis3D planeNormal = Axis3D.Z;
            boolean testForLeftSide = random.nextBoolean();
            boolean expected = EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query2D, (Point2DReadOnly)line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection(), (boolean)testForLeftSide);
            boolean actual = EuclidPolytopeTools.isPoint3DOnSideOfLine3D((Point3DReadOnly)query3D, (Point3DReadOnly)line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection(), (Vector3DReadOnly)planeNormal, (boolean)testForLeftSide);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
        for (i = 0; i < 1000; ++i) {
            Plane3D plane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
            Vector3D firstTangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)plane.getNormal(), (boolean)true);
            Vector3D secondTangent = new Vector3D();
            secondTangent.cross((Tuple3DReadOnly)firstTangent, (Tuple3DReadOnly)plane.getNormal());
            Point3D firstPointOnLine = new Point3D();
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)firstTangent, (Tuple3DReadOnly)plane.getPoint());
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)secondTangent, (Tuple3DReadOnly)firstPointOnLine);
            Point3D secondPointOnLine = new Point3D();
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)firstTangent, (Tuple3DReadOnly)plane.getPoint());
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)secondTangent, (Tuple3DReadOnly)secondPointOnLine);
            Line3D line = new Line3D((Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
            Vector3D orthogonalToLinePointingLeft = new Vector3D();
            orthogonalToLinePointingLeft.cross((Tuple3DReadOnly)plane.getNormal(), (Tuple3DReadOnly)line.getDirection());
            Point3D pointOnLeftSide = new Point3D();
            pointOnLeftSide.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0), (Tuple3DReadOnly)line.getDirection(), (Tuple3DReadOnly)line.getPoint());
            pointOnLeftSide.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)orthogonalToLinePointingLeft, (Tuple3DReadOnly)pointOnLeftSide);
            Point3D pointOnRightSide = new Point3D();
            pointOnRightSide.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0), (Tuple3DReadOnly)line.getDirection(), (Tuple3DReadOnly)line.getPoint());
            pointOnRightSide.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)orthogonalToLinePointingLeft, (Tuple3DReadOnly)pointOnRightSide);
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            pointOnLeftSide.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)plane.getNormal(), (Tuple3DReadOnly)pointOnLeftSide);
            pointOnRightSide.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)plane.getNormal(), (Tuple3DReadOnly)pointOnRightSide);
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)plane.getNormal(), (Tuple3DReadOnly)firstPointOnLine);
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)plane.getNormal(), (Tuple3DReadOnly)secondPointOnLine);
            line = new Line3D((Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D((Point3DReadOnly)pointOnLeftSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)pointOnRightSide, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Vector3DReadOnly)plane.getNormal()));
        }
    }

    @Test
    void testGetSilhouette() throws Exception {
        Random random = new Random(454353L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001);
            Face3D aFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            Point3D observer = new Point3D((Tuple3DReadOnly)aFace.getCentroid());
            Vector3D tangential = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)aFace.getNormal(), (boolean)true);
            observer.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)tangential, (Tuple3DReadOnly)observer);
            observer.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)10.0), (Tuple3DReadOnly)aFace.getNormal(), (Tuple3DReadOnly)observer);
            ArrayList<HalfEdge3D> expectedSilhouette = new ArrayList<HalfEdge3D>();
            for (HalfEdge3D edge : convexPolytope3D.getHalfEdges()) {
                boolean isEdgeFaceVisible = ((Face3D)edge.getFace()).canObserverSeeFace((Point3DReadOnly)observer, epsilon);
                boolean isTwinFaceVisible = ((Face3D)((HalfEdge3D)edge.getTwin()).getFace()).canObserverSeeFace((Point3DReadOnly)observer, epsilon);
                if (isEdgeFaceVisible || !isTwinFaceVisible) continue;
                expectedSilhouette.add(edge);
            }
            List actualSilhouette = EuclidPolytopeTools.computeSilhouette((List)convexPolytope3D.getFaces(), (Point3DReadOnly)observer, (double)epsilon);
            if (expectedSilhouette.isEmpty()) {
                Assertions.assertNull((Object)actualSilhouette);
                continue;
            }
            Assertions.assertEquals((int)expectedSilhouette.size(), (int)actualSilhouette.size());
            for (HalfEdge3D expectedSilhouetteEdge : expectedSilhouette) {
                Assertions.assertTrue((boolean)actualSilhouette.contains(expectedSilhouetteEdge));
            }
        }
    }

    @Test
    void testTetrahedronVolume() throws Exception {
        Random random = new Random(9654L);
        for (int i = 0; i < 1000; ++i) {
            Point3D a = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D b = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D c = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D d = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            double ab2 = a.distanceSquared((Point3DReadOnly)b);
            double ac2 = a.distanceSquared((Point3DReadOnly)c);
            double ad2 = a.distanceSquared((Point3DReadOnly)d);
            double bc2 = b.distanceSquared((Point3DReadOnly)c);
            double cd2 = c.distanceSquared((Point3DReadOnly)d);
            double db2 = d.distanceSquared((Point3DReadOnly)b);
            DMatrixRMaj matrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 0.0, ab2, ac2, ad2}, {1.0, ab2, 0.0, bc2, db2}, {1.0, ac2, bc2, 0.0, cd2}, {1.0, ad2, db2, cd2, 0.0}});
            double volume1 = EuclidCoreTools.squareRoot((double)(CommonOps_DDRM.det((DMatrixRMaj)matrix) / 288.0));
            Plane3D basePlane = new Plane3D((Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d);
            double height = basePlane.distance((Point3DReadOnly)a);
            double baseArea = EuclidGeometryTools.triangleArea((Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d);
            double volume2 = baseArea * height / 3.0;
            Assertions.assertEquals((double)volume1, (double)volume2, (double)1.0E-7);
            Vector3D v1 = new Vector3D();
            Vector3D v2 = new Vector3D();
            Vector3D v3 = new Vector3D();
            v1.sub((Tuple3DReadOnly)b, (Tuple3DReadOnly)a);
            v2.sub((Tuple3DReadOnly)c, (Tuple3DReadOnly)a);
            v3.sub((Tuple3DReadOnly)d, (Tuple3DReadOnly)a);
            Vector3D temp = new Vector3D();
            temp.cross((Tuple3DReadOnly)v2, (Tuple3DReadOnly)v3);
            double volume3 = Math.abs(temp.dot((Tuple3DReadOnly)v1) / 6.0);
            Assertions.assertEquals((double)volume2, (double)volume3, (double)1.0E-12);
            Assertions.assertEquals((double)volume3, (double)EuclidShapeTools.tetrahedronVolume((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d), (double)1.0E-12);
        }
    }

    @Test
    void testIcosahedronEdgeRadiusCalculation() throws Exception {
        Random random = new Random(3645646L);
        for (int i = 0; i < 1000; ++i) {
            IcoSphereFactory.TriangleMesh3D icosahedron = IcoSphereFactory.newIcoSphere((int)0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            icosahedron.getVertices().forEach(vertex -> vertex.scale(radius));
            for (Triangle3D triangle : icosahedron.getAllTriangles()) {
                double actualEdgeLength = EuclidShapeTools.icosahedronEdgeLength((double)radius);
                Assertions.assertEquals((double)triangle.getAB(), (double)actualEdgeLength, (double)1.0E-12);
                Assertions.assertEquals((double)triangle.getBC(), (double)actualEdgeLength, (double)1.0E-12);
                Assertions.assertEquals((double)triangle.getCA(), (double)actualEdgeLength, (double)1.0E-12);
                Assertions.assertEquals((double)radius, (double)EuclidShapeTools.icosahedronRadius((double)triangle.getAB()), (double)1.0E-12);
                Assertions.assertEquals((double)radius, (double)EuclidShapeTools.icosahedronRadius((double)triangle.getBC()), (double)1.0E-12);
                Assertions.assertEquals((double)radius, (double)EuclidShapeTools.icosahedronRadius((double)triangle.getCA()), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testIsConvexPolygonConcyclic() {
        int numberOfVertices;
        int i;
        Random random = new Random(4365L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(20);
            List concyclicPoints = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (double)10.0, (double)1.0, (int)numberOfVertices, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            if (random.nextBoolean()) {
                Collections.reverse(concyclicPoints);
            }
            if (concyclicPoints.isEmpty()) {
                Assertions.assertFalse((boolean)EuclidPolytopeTools.isConvexPolygon3DConcyclic((List)concyclicPoints, (int)numberOfVertices, (double)1.0E-12), (String)("Iteration " + i));
                continue;
            }
            Assertions.assertTrue((boolean)EuclidPolytopeTools.isConvexPolygon3DConcyclic((List)concyclicPoints, (int)numberOfVertices, (double)1.0E-12), (String)("Iteration " + i));
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(16) + 4;
            Point3D circumcenter = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            List notConcyclicPoints = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (Point3DReadOnly)circumcenter, (double)1.0, (int)numberOfVertices, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            if (random.nextBoolean()) {
                Collections.reverse(notConcyclicPoints);
            }
            Point3D vertexUnmodified = new Point3D((Tuple3DReadOnly)notConcyclicPoints.get(random.nextInt(numberOfVertices)));
            Point3D vertex = (Point3D)notConcyclicPoints.get(random.nextInt(numberOfVertices));
            UnitVector3D directionAway = new UnitVector3D();
            directionAway.sub((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)circumcenter);
            double distanceOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0E-12, (double)1.0);
            vertex.scaleAdd(distanceOutside, (Tuple3DReadOnly)directionAway, (Tuple3DReadOnly)vertex);
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isConvexPolygon3DConcyclic((List)notConcyclicPoints, (int)numberOfVertices, (double)1.0E-12), (String)("Iteration " + i));
            vertex.set(vertexUnmodified);
            double radius = vertex.distance((Point3DReadOnly)circumcenter);
            double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0E-12, (double)radius);
            vertex.scaleAdd(-distanceInside, (Tuple3DReadOnly)directionAway, (Tuple3DReadOnly)vertex);
            Assertions.assertFalse((boolean)EuclidPolytopeTools.isConvexPolygon3DConcyclic((List)notConcyclicPoints, (int)numberOfVertices, (double)1.0E-12), (String)("Iteration " + i));
        }
    }
}

