/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class AxisAngleConversionTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testQuaternionToAxisAngle() throws Exception {
        int i;
        Random random = new Random(51651L);
        AxisAngle axisAngle = new AxisAngle();
        Quaternion quaternion = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            double ux = EuclidCoreRandomTools.nextDouble((Random)random);
            double uy = EuclidCoreRandomTools.nextDouble((Random)random);
            double uz = EuclidCoreRandomTools.nextDouble((Random)random);
            double norm = EuclidCoreTools.norm((double)ux, (double)uy, (double)uz);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            double qs = EuclidCoreTools.cos((double)(angle / 2.0));
            double qx = (ux /= norm) * EuclidCoreTools.sin((double)(angle / 2.0));
            double qy = (uy /= norm) * EuclidCoreTools.sin((double)(angle / 2.0));
            double qz = (uz /= norm) * EuclidCoreTools.sin((double)(angle / 2.0));
            quaternion.setUnsafe(qx, qy, qz, qs);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
            if (axisAngle.getAngle() * angle < 0.0) {
                axisAngle.negate();
            }
            Assertions.assertEquals((double)ux, (double)axisAngle.getX(), (double)1.0E-12);
            Assertions.assertEquals((double)uy, (double)axisAngle.getY(), (double)1.0E-12);
            Assertions.assertEquals((double)uz, (double)axisAngle.getZ(), (double)1.0E-12);
            Assertions.assertEquals((double)angle, (double)axisAngle.getAngle(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            AxisAngle originalAxisAngle = new AxisAngle();
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (double)(Math.PI * 2), (AxisAngleBasics)originalAxisAngle);
            double qs = EuclidCoreTools.cos((double)(originalAxisAngle.getAngle() / 2.0));
            double qx = originalAxisAngle.getX() * EuclidCoreTools.sin((double)(originalAxisAngle.getAngle() / 2.0));
            double qy = originalAxisAngle.getY() * EuclidCoreTools.sin((double)(originalAxisAngle.getAngle() / 2.0));
            double qz = originalAxisAngle.getZ() * EuclidCoreTools.sin((double)(originalAxisAngle.getAngle() / 2.0));
            quaternion.setUnsafe(qx, qy, qz, qs);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)originalAxisAngle, (Orientation3DReadOnly)axisAngle, (double)1.0E-12);
        }
        double ux = EuclidCoreRandomTools.nextDouble((Random)random);
        double uy = EuclidCoreRandomTools.nextDouble((Random)random);
        double uz = EuclidCoreRandomTools.nextDouble((Random)random);
        double norm = EuclidCoreTools.norm((double)ux, (double)uy, (double)uz);
        ux /= norm;
        uy /= norm;
        uz /= norm;
        double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
        double scale = random.nextDouble();
        double qs = scale * EuclidCoreTools.cos((double)(angle / 2.0));
        double qx = scale * ux * EuclidCoreTools.sin((double)(angle / 2.0));
        double qy = scale * uy * EuclidCoreTools.sin((double)(angle / 2.0));
        double qz = scale * uz * EuclidCoreTools.sin((double)(angle / 2.0));
        quaternion.setUnsafe(qx, qy, qz, qs);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        if (axisAngle.getAngle() * angle < 0.0) {
            axisAngle.negate();
        }
        Assertions.assertEquals((double)ux, (double)axisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)uy, (double)axisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)uz, (double)axisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)angle, (double)axisAngle.getAngle(), (double)1.0E-12);
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        EuclidCoreTestTools.assertAxisAngleIsSetToZero((AxisAngleReadOnly)axisAngle);
        quaternion.setUnsafe(0.0, 0.0, 0.0, Double.NaN);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
        quaternion.setUnsafe(0.0, 0.0, Double.NaN, 0.0);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
        quaternion.setUnsafe(0.0, Double.NaN, 0.0, 0.0);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
        quaternion.setUnsafe(Double.NaN, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)axisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
    }

    @Test
    public void testRotationVectorToAxisAngle() throws Exception {
        int i;
        Random random = new Random(2135L);
        AxisAngle expectedAxisAngle = new AxisAngle();
        AxisAngle actualAxisAngle = new AxisAngle();
        double minMaxAngleRange = Math.PI * 2;
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (double)minMaxAngleRange, (AxisAngleBasics)expectedAxisAngle);
            double rx = expectedAxisAngle.getX() * expectedAxisAngle.getAngle();
            double ry = expectedAxisAngle.getY() * expectedAxisAngle.getAngle();
            double rz = expectedAxisAngle.getZ() * expectedAxisAngle.getAngle();
            AxisAngleConversion.convertRotationVectorToAxisAngle((double)rx, (double)ry, (double)rz, (AxisAngleBasics)actualAxisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-12);
        }
        AxisAngleConversion.convertRotationVectorToAxisAngle((double)0.0, (double)0.0, (double)0.0, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleIsSetToZero((AxisAngleReadOnly)actualAxisAngle);
        AxisAngleConversion.convertRotationVectorToAxisAngle((double)Double.NaN, (double)0.0, (double)0.0, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        AxisAngleConversion.convertRotationVectorToAxisAngle((double)0.0, (double)Double.NaN, (double)0.0, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        AxisAngleConversion.convertRotationVectorToAxisAngle((double)0.0, (double)0.0, (double)Double.NaN, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D rotationVectorCopy = new Vector3D((Tuple3DReadOnly)rotationVector);
            AxisAngleConversion.convertRotationVectorToAxisAngle((double)rotationVector.getX(), (double)rotationVector.getY(), (double)rotationVector.getZ(), (AxisAngleBasics)expectedAxisAngle);
            AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)rotationVector, (AxisAngleBasics)actualAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)1.0E-12);
            Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
        }
    }

    @Test
    public void testMatrixToAxisAngle() throws Exception {
        double m21;
        double m12;
        double m02;
        double m20;
        double m10;
        double m01;
        double m22;
        double m11;
        double m00;
        int i;
        Random random = new Random(2135L);
        AxisAngle expectedAxisAngle = new AxisAngle();
        AxisAngle actualAxisAngle = new AxisAngle();
        double minMaxAngleRange = Math.PI;
        RotationMatrix rotationMatrix = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (double)minMaxAngleRange, (AxisAngleBasics)expectedAxisAngle);
            double ux = expectedAxisAngle.getX();
            double uy = expectedAxisAngle.getY();
            double uz = expectedAxisAngle.getZ();
            double angle = expectedAxisAngle.getAngle();
            m00 = EuclidCoreTools.cos((double)angle) + ux * ux * (1.0 - EuclidCoreTools.cos((double)angle));
            m11 = EuclidCoreTools.cos((double)angle) + uy * uy * (1.0 - EuclidCoreTools.cos((double)angle));
            m22 = EuclidCoreTools.cos((double)angle) + uz * uz * (1.0 - EuclidCoreTools.cos((double)angle));
            m01 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) - uz * EuclidCoreTools.sin((double)angle);
            m10 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) + uz * EuclidCoreTools.sin((double)angle);
            m20 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - uy * EuclidCoreTools.sin((double)angle);
            m02 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + uy * EuclidCoreTools.sin((double)angle);
            m12 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - ux * EuclidCoreTools.sin((double)angle);
            m21 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + ux * EuclidCoreTools.sin((double)angle);
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle.setAngle(Math.PI);
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomVector.normalize();
            expectedAxisAngle.setX(randomVector.getX());
            expectedAxisAngle.setY(randomVector.getY());
            expectedAxisAngle.setZ(randomVector.getZ());
            double ux = expectedAxisAngle.getX();
            double uy = expectedAxisAngle.getY();
            double uz = expectedAxisAngle.getZ();
            double angle = expectedAxisAngle.getAngle();
            m00 = EuclidCoreTools.cos((double)angle) + ux * ux * (1.0 - EuclidCoreTools.cos((double)angle));
            m11 = EuclidCoreTools.cos((double)angle) + uy * uy * (1.0 - EuclidCoreTools.cos((double)angle));
            m22 = EuclidCoreTools.cos((double)angle) + uz * uz * (1.0 - EuclidCoreTools.cos((double)angle));
            m01 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) - uz * EuclidCoreTools.sin((double)angle);
            m10 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) + uz * EuclidCoreTools.sin((double)angle);
            m20 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - uy * EuclidCoreTools.sin((double)angle);
            m02 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + uy * EuclidCoreTools.sin((double)angle);
            m12 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - ux * EuclidCoreTools.sin((double)angle);
            m21 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + ux * EuclidCoreTools.sin((double)angle);
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-12);
        }
        m22 = 1.0;
        m11 = 1.0;
        m00 = 1.0;
        m12 = 0.0;
        m02 = 0.0;
        m01 = 0.0;
        m21 = 0.0;
        m20 = 0.0;
        m10 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleIsSetToZero((AxisAngleReadOnly)actualAxisAngle);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = -1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = -1.0;
        m21 = 0.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = 0.0;
        m01 = -1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        double sqrt2Over2 = EuclidCoreTools.squareRoot((double)2.0) / 2.0;
        m00 = 0.0;
        m01 = 1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 1.0;
        m21 = 0.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = 1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        Assertions.assertEquals((double)0.0, (double)actualAxisAngle.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualAxisAngle.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualAxisAngle.getAngle(), (double)1.0E-12);
        rotationMatrix.setUnsafe(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)actualAxisAngle);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)actualAxisAngle);
    }

    @Test
    public void testYawPitchRollToAxisAngle() throws Exception {
        AxisAngle expectedAxisAngle = new AxisAngle();
        AxisAngle actualAxisAngle = new AxisAngle();
        RotationMatrix rotationMatrix = new RotationMatrix();
        double deltaAngle = 0.3141592653589793;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double pitch = -1.5707963267948966; pitch <= 1.5707963267948966; pitch += deltaAngle) {
                for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                    double cYaw = EuclidCoreTools.cos((double)yaw);
                    double sYaw = EuclidCoreTools.sin((double)yaw);
                    double cPitch = EuclidCoreTools.cos((double)pitch);
                    double sPitch = EuclidCoreTools.sin((double)pitch);
                    double cRoll = EuclidCoreTools.cos((double)roll);
                    double sRoll = EuclidCoreTools.sin((double)roll);
                    double m00 = cYaw * cPitch;
                    double m01 = cYaw * sPitch * sRoll - sYaw * cRoll;
                    double m02 = cYaw * sPitch * cRoll + sYaw * sRoll;
                    double m10 = sYaw * cPitch;
                    double m11 = sYaw * sPitch * sRoll + cYaw * cRoll;
                    double m12 = sYaw * sPitch * cRoll - cYaw * sRoll;
                    double m20 = -sPitch;
                    double m21 = cPitch * sRoll;
                    double m22 = cPitch * cRoll;
                    rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
                    AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)rotationMatrix, (AxisAngleBasics)expectedAxisAngle);
                    AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yaw, (double)pitch, (double)roll, (AxisAngleBasics)actualAxisAngle);
                    EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-12);
                }
            }
        }
    }
}

