/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox2D;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox3D;
import us.ihmc.euclid.referenceFrame.FrameOrientation2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameRotationMatrix;
import us.ihmc.euclid.referenceFrame.FrameUnitVector2D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFrameTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreFactoriesTest;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class EuclidFrameFactoriesTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testNewLinkedFramePoint2DReadOnly() {
        int i;
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        double[] scale = new double[1];
        FramePoint2D originalTuple = new FramePoint2D();
        FramePoint2DReadOnly actual = EuclidFrameFactories.newLinkedFramePoint2DReadOnly(() -> scale[0], (FrameTuple2DReadOnly)originalTuple);
        for (int i2 = 0; i2 < 1000; ++i2) {
            originalTuple.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            scale[0] = random.nextDouble();
            FramePoint2D expected = new FramePoint2D((FrameTuple2DReadOnly)originalTuple);
            expected.scale(scale[0]);
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint2D expected = new FramePoint2D();
        FramePoint2DReadOnly actual2 = EuclidFrameFactories.newLinkedFramePoint2DReadOnly(() -> ((FramePoint2D)expected).getReferenceFrame(), () -> ((FramePoint2D)expected).getX(), () -> ((FramePoint2D)expected).getY());
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual2);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        expected = new FramePoint2D();
        actual2 = EuclidFrameFactories.newLinkedFramePoint2DReadOnly(() -> ((FramePoint2D)expected).getReferenceFrame(), (Point2DReadOnly)expected);
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedFrameVector2DReadOnly() {
        int i;
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        double[] scale = new double[1];
        FrameVector2D originalTuple = new FrameVector2D();
        FrameVector2DReadOnly actual = EuclidFrameFactories.newLinkedFrameVector2DReadOnly(() -> scale[0], (FrameTuple2DReadOnly)originalTuple);
        for (int i2 = 0; i2 < 1000; ++i2) {
            originalTuple.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            scale[0] = random.nextDouble();
            FrameVector2D expected = new FrameVector2D((FrameTuple2DReadOnly)originalTuple);
            expected.scale(scale[0]);
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector2D expected = new FrameVector2D();
        FrameVector2DReadOnly actual2 = EuclidFrameFactories.newLinkedFrameVector2DReadOnly(() -> ((FrameVector2D)expected).getReferenceFrame(), () -> ((FrameVector2D)expected).getX(), () -> ((FrameVector2D)expected).getY());
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual2);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        expected = new FrameVector2D();
        actual2 = EuclidFrameFactories.newLinkedFrameVector2DReadOnly(() -> ((FrameVector2D)expected).getReferenceFrame(), (Vector2DReadOnly)expected);
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedFrameUnitVector2DReadOnly() {
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector2D expected = new FrameUnitVector2D();
        FrameUnitVector2DReadOnly actual = EuclidFrameFactories.newLinkedFrameUnitVector2DReadOnly(() -> ((FrameUnitVector2D)expected).getReferenceFrame(), (UnitVector2DReadOnly)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameUnitVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewLinkedFramePoint3DReadOnly() {
        int i;
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        double[] scale = new double[1];
        FramePoint3D originalTuple = new FramePoint3D();
        FramePoint3DReadOnly actual = EuclidFrameFactories.newLinkedFramePoint3DReadOnly(() -> scale[0], (FrameTuple3DReadOnly)originalTuple);
        for (int i2 = 0; i2 < 1000; ++i2) {
            originalTuple.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            scale[0] = random.nextDouble();
            FramePoint3D expected = new FramePoint3D((FrameTuple3DReadOnly)originalTuple);
            expected.scale(scale[0]);
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint3D expected = new FramePoint3D();
        FramePoint3DReadOnly actual2 = EuclidFrameFactories.newLinkedFramePoint3DReadOnly(() -> ((FramePoint3D)expected).getReferenceFrame(), () -> ((FramePoint3D)expected).getX(), () -> ((FramePoint3D)expected).getY(), () -> ((FramePoint3D)expected).getZ());
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual2);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        expected = new FramePoint3D();
        actual2 = EuclidFrameFactories.newLinkedFramePoint3DReadOnly(() -> ((FramePoint3D)expected).getReferenceFrame(), (Point3DReadOnly)expected);
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedFrameVector3DReadOnly() {
        int i;
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        double[] scale = new double[1];
        FrameVector3D originalTuple = new FrameVector3D();
        FrameVector3DReadOnly actual = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(() -> scale[0], (FrameTuple3DReadOnly)originalTuple);
        for (int i2 = 0; i2 < 1000; ++i2) {
            originalTuple.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            scale[0] = random.nextDouble();
            FrameVector3D expected = new FrameVector3D((FrameTuple3DReadOnly)originalTuple);
            expected.scale(scale[0]);
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector3D expected = new FrameVector3D();
        FrameVector3DReadOnly actual2 = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(() -> ((FrameVector3D)expected).getReferenceFrame(), () -> ((FrameVector3D)expected).getX(), () -> ((FrameVector3D)expected).getY(), () -> ((FrameVector3D)expected).getZ());
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual2);
        }
        frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        expected = new FrameVector3D();
        actual2 = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(() -> ((FrameVector3D)expected).getReferenceFrame(), (Vector3DReadOnly)expected);
        for (i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedFrameUnitVector3DReadOnly() {
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector3D expected = new FrameUnitVector3D();
        FrameUnitVector3DReadOnly actual = EuclidFrameFactories.newLinkedFrameUnitVector3DReadOnly(() -> ((FrameUnitVector3D)expected).getReferenceFrame(), (UnitVector3DReadOnly)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameUnitVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewLinkedFrameRotationMatrixReadOnly() {
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameRotationMatrix expected = new FrameRotationMatrix();
        FrameRotationMatrixReadOnly actual = EuclidFrameFactories.newLinkedFrameRotationMatrixReadOnly(() -> ((FrameRotationMatrix)expected).getReferenceFrame(), (RotationMatrixReadOnly)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameRotationMatrixReadOnly)EuclidFrameRandomTools.nextFrameRotationMatrix((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameMatrix3D((FrameMatrix3DReadOnly)expected, (FrameMatrix3DReadOnly)actual);
        }
    }

    @Test
    public void testNewLinkedFrameQuaternionReadOnly() {
        Random random = new Random(5416L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameQuaternion expected = new FrameQuaternion();
        FrameQuaternionReadOnly actual = EuclidFrameFactories.newLinkedFrameQuaternionReadOnly(() -> ((FrameQuaternion)expected).getReferenceFrame(), (QuaternionReadOnly)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple4D((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedFramePoint2D() {
        Random random = new Random(43L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint2D originalTuple = new FramePoint2D();
        FramePoint2DReadOnly actual = EuclidFrameFactories.newNegativeLinkedFramePoint2D((FramePoint2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            FramePoint2D expected = new FramePoint2D((FrameTuple2DReadOnly)originalTuple);
            expected.negate();
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedFrameVector2D() {
        Random random = new Random(43L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector2D originalTuple = new FrameVector2D();
        FrameVector2DReadOnly actual = EuclidFrameFactories.newNegativeLinkedFrameVector2D((FrameVector2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            FrameVector2D expected = new FrameVector2D((FrameTuple2DReadOnly)originalTuple);
            expected.negate();
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedFramePoint3D() {
        Random random = new Random(43L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint3D originalTuple = new FramePoint3D();
        FramePoint3DReadOnly actual = EuclidFrameFactories.newNegativeLinkedFramePoint3D((FramePoint3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            FramePoint3D expected = new FramePoint3D((FrameTuple3DReadOnly)originalTuple);
            expected.negate();
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedFrameVector3D() {
        Random random = new Random(43L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector3D originalTuple = new FrameVector3D();
        FrameVector3DReadOnly actual = EuclidFrameFactories.newNegativeLinkedFrameVector3D((FrameVector3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            FrameVector3D expected = new FrameVector3D((FrameTuple3DReadOnly)originalTuple);
            expected.negate();
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFramePoint2DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFramePoint2DBasics copy = EuclidFrameFactories.newFixedFramePoint2DBasics(() -> referenceFrame);
            copy.set((Tuple2DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFramePoint2DBasics next = EuclidFrameFactories.newFixedFramePoint2DBasics(() -> referenceFrame);
            next.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextPoint2D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFramePoint2DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint2D expected = new FramePoint2D();
        FixedFramePoint2DBasics actual = EuclidFrameFactories.newLinkedFixedFramePoint2DBasics(() -> ((FramePoint2D)expected).getReferenceFrame(), (Point2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameVector2DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameVector2DBasics copy = EuclidFrameFactories.newFixedFrameVector2DBasics(() -> referenceFrame);
            copy.set((Tuple2DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameVector2DBasics next = EuclidFrameFactories.newFixedFrameVector2DBasics(() -> referenceFrame);
            next.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextVector2D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameVector2DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector2D expected = new FrameVector2D();
        FixedFrameVector2DBasics actual = EuclidFrameFactories.newLinkedFixedFrameVector2DBasics(() -> ((FrameVector2D)expected).getReferenceFrame(), (Vector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewLinkedFixedFramePoint3DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint3D expected = new FramePoint3D();
        FixedFramePoint3DBasics actual = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics(() -> ((FramePoint3D)expected).getReferenceFrame(), (Point3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameVector3DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameVector3DBasics copy = EuclidFrameFactories.newFixedFrameVector3DBasics(() -> referenceFrame);
            copy.set((Tuple3DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameVector3DBasics next = EuclidFrameFactories.newFixedFrameVector3DBasics(() -> referenceFrame);
            next.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextVector3D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameVector3DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector3D expected = new FrameVector3D();
        FixedFrameVector3DBasics actual = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics(() -> ((FrameVector3D)expected).getReferenceFrame(), (Vector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameUnitVector2DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameUnitVector2DBasics copy = EuclidFrameFactories.newFixedFrameUnitVector2DBasics(() -> referenceFrame);
            copy.set((Tuple2DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameUnitVector2DBasics next = EuclidFrameFactories.newFixedFrameUnitVector2DBasics(() -> referenceFrame);
            next.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextUnitVector2D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameUnitVector2DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector2D expected = new FrameUnitVector2D();
        FixedFrameUnitVector2DBasics actual = EuclidFrameFactories.newLinkedFixedFrameUnitVector2DBasics(() -> ((FrameUnitVector2D)expected).getReferenceFrame(), (UnitVector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple2DReadOnly)EuclidFrameRandomTools.nextFrameUnitVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameUnitVector3DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameUnitVector3DBasics copy = EuclidFrameFactories.newFixedFrameUnitVector3DBasics(() -> referenceFrame);
            copy.set((Tuple3DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameUnitVector3DBasics next = EuclidFrameFactories.newFixedFrameUnitVector3DBasics(() -> referenceFrame);
            next.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextUnitVector3D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameUnitVector3DBasics() {
        Random random = new Random(983456L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector3D expected = new FrameUnitVector3D();
        FixedFrameUnitVector3DBasics actual = EuclidFrameFactories.newLinkedFixedFrameUnitVector3DBasics(() -> ((FrameUnitVector3D)expected).getReferenceFrame(), (UnitVector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameUnitVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameOrientation2DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameOrientation2DBasics copy = EuclidFrameFactories.newFixedFrameOrientation2DBasics(() -> referenceFrame);
            copy.set((Orientation2DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameOrientation2DBasics next = EuclidFrameFactories.newFixedFrameOrientation2DBasics(() -> referenceFrame);
            next.set((Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextOrientation2D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameOrientation2DBasics() {
        Random random = new Random(435346L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameOrientation2D expected = new FrameOrientation2D();
        FixedFrameOrientation2DBasics actual = EuclidFrameFactories.newLinkedFixedFrameOrientation2DBasics(() -> ((FrameOrientation2D)expected).getReferenceFrame(), (Orientation2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameOrientation2DReadOnly)EuclidFrameRandomTools.nextFrameOrientation2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameOrientation2D((FrameOrientation2DReadOnly)expected, (FrameOrientation2DReadOnly)actual);
            actual.set((Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random));
            this.thoroughAssertionsFrameOrientation2D((FrameOrientation2DReadOnly)expected, (FrameOrientation2DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameQuaternionBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameQuaternionBasics copy = EuclidFrameFactories.newFixedFrameQuaternionBasics(() -> referenceFrame);
            copy.set((QuaternionReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameQuaternionBasics next = EuclidFrameFactories.newFixedFrameQuaternionBasics(() -> referenceFrame);
            next.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextQuaternion, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameQuaternionBasics() {
        Random random = new Random(435346L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameQuaternion expected = new FrameQuaternion();
        FixedFrameQuaternionBasics actual = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics(() -> ((FrameQuaternion)expected).getReferenceFrame(), (QuaternionBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameTuple4D((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual);
            actual.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            this.thoroughAssertionsFrameTuple4D((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameRotationMatrixBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameRotationMatrixBasics copy = EuclidFrameFactories.newFixedFrameRotationMatrixBasics(() -> referenceFrame);
            copy.set((RotationMatrixReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameRotationMatrixBasics next = EuclidFrameFactories.newFixedFrameRotationMatrixBasics(() -> referenceFrame);
            next.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidCoreRandomTools::nextRotationMatrix, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameRotationMatrixBasics() {
        Random random = new Random(435346L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameRotationMatrix expected = new FrameRotationMatrix();
        FixedFrameRotationMatrixBasics actual = EuclidFrameFactories.newLinkedFixedFrameRotationMatrixBasics(() -> ((FrameRotationMatrix)expected).getReferenceFrame(), (RotationMatrixBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameRotationMatrixReadOnly)EuclidFrameRandomTools.nextFrameRotationMatrix((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameMatrix3D((FrameMatrix3DReadOnly)expected, (FrameMatrix3DReadOnly)actual);
            actual.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            this.thoroughAssertionsFrameMatrix3D((FrameMatrix3DReadOnly)expected, (FrameMatrix3DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameBoudingBox2DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameBoundingBox2DBasics copy = EuclidFrameFactories.newFixedFrameBoundingBox2DBasics(() -> referenceFrame);
            copy.set((BoundingBox2DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameBoundingBox2DBasics next = EuclidFrameFactories.newFixedFrameBoundingBox2DBasics(() -> referenceFrame);
            next.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidGeometryRandomTools::nextBoundingBox2D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameBoudingBox2DBasics() {
        Random random = new Random(435346L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameBoundingBox2D expected = new FrameBoundingBox2D();
        FixedFrameBoundingBox2DBasics actual = EuclidFrameFactories.newLinkedFixedFrameBoundingBox2DBasics(() -> ((FrameBoundingBox2D)expected).getReferenceFrame(), (BoundingBox2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameBoundingBox2DReadOnly)EuclidFrameRandomTools.nextFrameBoundingBox2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameBoundingBox2D((FrameBoundingBox2DReadOnly)expected, (FrameBoundingBox2DReadOnly)actual);
            actual.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            this.thoroughAssertionsFrameBoundingBox2D((FrameBoundingBox2DReadOnly)expected, (FrameBoundingBox2DReadOnly)actual);
        }
    }

    @Test
    public void testNewFixedFrameBoudingBox3DBasics() throws Throwable {
        FrameTypeCopier frameTypeCopier = (referenceFrame, framelessObject) -> {
            FixedFrameBoundingBox3DBasics copy = EuclidFrameFactories.newFixedFrameBoundingBox3DBasics(() -> referenceFrame);
            copy.set((BoundingBox3DReadOnly)framelessObject);
            return copy;
        };
        RandomFrameTypeBuilder frameTypeBuilder = (random, referenceFrame) -> {
            FixedFrameBoundingBox3DBasics next = EuclidFrameFactories.newFixedFrameBoundingBox3DBasics(() -> referenceFrame);
            next.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            return next;
        };
        EuclidFrameAPITester test = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("toString", new Class[]{String.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        test.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, EuclidGeometryRandomTools::nextBoundingBox3D, (Predicate)methodFilter, 10);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        test.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testNewLinkedFixedFrameBoudingBox3DBasics() {
        Random random = new Random(435346L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameBoundingBox3D expected = new FrameBoundingBox3D();
        FixedFrameBoundingBox3DBasics actual = EuclidFrameFactories.newLinkedFixedFrameBoundingBox3DBasics(() -> ((FrameBoundingBox3D)expected).getReferenceFrame(), (BoundingBox3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.setIncludingFrame((FrameBoundingBox3DReadOnly)EuclidFrameRandomTools.nextFrameBoundingBox3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames))));
            this.thoroughAssertionsFrameBoundingBox3D((FrameBoundingBox3DReadOnly)expected, (FrameBoundingBox3DReadOnly)actual);
            actual.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            this.thoroughAssertionsFrameBoundingBox3D((FrameBoundingBox3DReadOnly)expected, (FrameBoundingBox3DReadOnly)actual);
        }
    }

    @Test
    public void testNewObservableFramePoint2DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint2D expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FramePoint2D source = new FramePoint2D(expected.getReferenceFrame());
        Consumer<Axis2D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        FramePoint2DReadOnly observable = EuclidFrameFactories.newObservableFramePoint2DReadOnly(valueAccessedListener, (FramePoint2DReadOnly)source);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FramePoint2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Point2DBasics)source, false);
        FramePoint2DReadOnly observable2 = EuclidFrameFactories.newObservableFramePoint2DReadOnly(valueAccessedListener2, (FramePoint2DReadOnly)source);
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFramePoint3DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint3D expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FramePoint3D source = new FramePoint3D(expected.getReferenceFrame());
        Consumer<Axis3D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        FramePoint3DReadOnly observable = EuclidFrameFactories.newObservableFramePoint3DReadOnly(valueAccessedListener, (FramePoint3DReadOnly)source);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FramePoint3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Point3DBasics)source);
        FramePoint3DReadOnly observable2 = EuclidFrameFactories.newObservableFramePoint3DReadOnly(valueAccessedListener2, (FramePoint3DReadOnly)source);
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFrameVector2DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector2D expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameVector2D source = new FrameVector2D(expected.getReferenceFrame());
        Consumer<Axis2D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        FrameVector2DReadOnly observable = EuclidFrameFactories.newObservableFrameVector2DReadOnly(valueAccessedListener, (FrameVector2DReadOnly)source);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FrameVector2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Vector2DBasics)source, false);
        FrameVector2DReadOnly observable2 = EuclidFrameFactories.newObservableFrameVector2DReadOnly(valueAccessedListener2, (FrameVector2DReadOnly)source);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFrameVector3DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector3D expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameVector3D source = new FrameVector3D(expected.getReferenceFrame());
        Consumer<Axis3D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        FrameVector3DReadOnly observable = EuclidFrameFactories.newObservableFrameVector3DReadOnly(valueAccessedListener, (FrameVector3DReadOnly)source);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FrameVector3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Vector3DBasics)source);
        FrameVector3DReadOnly observable2 = EuclidFrameFactories.newObservableFrameVector3DReadOnly(valueAccessedListener2, (FrameVector3DReadOnly)source);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFrameUnitVector2DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector2D expected = EuclidFrameRandomTools.nextFrameUnitVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameUnitVector2D source = new FrameUnitVector2D(expected.getReferenceFrame());
        Consumer<Axis2D> valueAccessedListener = axis -> source.setIncludingFrame((FrameTuple2DReadOnly)expected);
        FrameUnitVector2DReadOnly observable = EuclidFrameFactories.newObservableFrameUnitVector2DReadOnly(valueAccessedListener, (FrameUnitVector2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFrameUnitVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FrameUnitVector2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Vector2DBasics)source, false);
        FrameUnitVector2DReadOnly observable2 = EuclidFrameFactories.newObservableFrameUnitVector2DReadOnly(valueAccessedListener2, (FrameUnitVector2DReadOnly)source);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFrameUnitVector3DReadOnly() {
        Random random = new Random(45L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector3D expected = EuclidFrameRandomTools.nextFrameUnitVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameUnitVector3D source = new FrameUnitVector3D(expected.getReferenceFrame());
        Consumer<Axis3D> valueAccessedListener = axis -> source.setIncludingFrame((FrameTuple3DReadOnly)expected);
        FrameUnitVector3DReadOnly observable = EuclidFrameFactories.newObservableFrameUnitVector3DReadOnly(valueAccessedListener, (FrameUnitVector3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)observable);
        expected = EuclidFrameRandomTools.nextFrameUnitVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        source = new FrameUnitVector3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Vector3DBasics)source);
        FrameUnitVector3DReadOnly observable2 = EuclidFrameFactories.newObservableFrameUnitVector3DReadOnly(valueAccessedListener2, (FrameUnitVector3DReadOnly)source);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableFramePoint2DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint2D expected = new FramePoint2D();
        FixedFramePoint2DBasics actual = EuclidFrameFactories.newObservableFixedFramePoint2DBasics(null, null, (FixedFramePoint2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        FramePoint2D source = new FramePoint2D();
        FixedFramePoint2DBasics observable = EuclidFrameFactories.newObservableFixedFramePoint2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFramePoint2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FramePoint2D source2 = new FramePoint2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Point2DBasics)source2, false);
        FixedFramePoint2DBasics observable2 = EuclidFrameFactories.newObservableFixedFramePoint2DBasics(null, valueAccessedListener, (FixedFramePoint2DBasics)source2);
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservableFramePoint3DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FramePoint3D expected = new FramePoint3D();
        FixedFramePoint3DBasics actual = EuclidFrameFactories.newObservableFixedFramePoint3DBasics(null, null, (FixedFramePoint3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        FramePoint3D source = new FramePoint3D();
        FixedFramePoint3DBasics observable = EuclidFrameFactories.newObservableFixedFramePoint3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFramePoint3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FramePoint3D source2 = new FramePoint3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Point3DBasics)source2);
        FixedFramePoint3DBasics observable2 = EuclidFrameFactories.newObservableFixedFramePoint3DBasics(null, valueAccessedListener, (FixedFramePoint3DBasics)source2);
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableFrameVector2DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector2D expected = new FrameVector2D();
        FixedFrameVector2DBasics actual = EuclidFrameFactories.newObservableFixedFrameVector2DBasics(null, null, (FixedFrameVector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        FrameVector2D source = new FrameVector2D();
        FixedFrameVector2DBasics observable = EuclidFrameFactories.newObservableFixedFrameVector2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFrameVector2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameVector2D source2 = new FrameVector2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Vector2DBasics)source2, false);
        FixedFrameVector2DBasics observable2 = EuclidFrameFactories.newObservableFixedFrameVector2DBasics(null, valueAccessedListener, (FixedFrameVector2DBasics)source2);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservableFrameVector3DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameVector3D expected = new FrameVector3D();
        FixedFrameVector3DBasics actual = EuclidFrameFactories.newObservableFixedFrameVector3DBasics(null, null, (FixedFrameVector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        FrameVector3D source = new FrameVector3D();
        FixedFrameVector3DBasics observable = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFrameVector3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameVector3D source2 = new FrameVector3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Vector3DBasics)source2);
        FixedFrameVector3DBasics observable2 = EuclidFrameFactories.newObservableFixedFrameVector3DBasics(null, valueAccessedListener, (FixedFrameVector3DBasics)source2);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableFrameUnitVector2DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector2D expected = new FrameUnitVector2D();
        FixedFrameUnitVector2DBasics actual = EuclidFrameFactories.newObservableFixedFrameUnitVector2DBasics(null, null, (FixedFrameUnitVector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
            actual.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            this.thoroughAssertionsFrameTuple2D((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        FrameUnitVector2D source = new FrameUnitVector2D();
        FixedFrameUnitVector2DBasics observable = EuclidFrameFactories.newObservableFixedFrameUnitVector2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFrameUnitVector2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFrameUnitVector2D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameUnitVector2D source2 = new FrameUnitVector2D((FrameTuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Vector2DBasics)source2, false);
        FixedFrameUnitVector2DBasics observable2 = EuclidFrameFactories.newObservableFixedFrameUnitVector2DBasics(null, valueAccessedListener, (FixedFrameUnitVector2DBasics)source2);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservableFrameUnitVector3DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameUnitVector3D expected = new FrameUnitVector3D();
        FixedFrameUnitVector3DBasics actual = EuclidFrameFactories.newObservableFixedFrameUnitVector3DBasics(null, null, (FixedFrameUnitVector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
            actual.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            this.thoroughAssertionsFrameTuple3D((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        FrameUnitVector3D source = new FrameUnitVector3D();
        FixedFrameUnitVector3DBasics observable = EuclidFrameFactories.newObservableFixedFrameUnitVector3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (FixedFrameUnitVector3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFrameUnitVector3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameUnitVector3D source2 = new FrameUnitVector3D((FrameTuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Vector3DBasics)source2);
        FixedFrameUnitVector3DBasics observable2 = EuclidFrameFactories.newObservableFixedFrameUnitVector3DBasics(null, valueAccessedListener, (FixedFrameUnitVector3DBasics)source2);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableRotationMatrixBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameRotationMatrix expected = new FrameRotationMatrix((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames));
        FixedFrameRotationMatrixBasics actual = EuclidFrameFactories.newObservableFixedFrameRotationMatrixBasics(null, null, (FixedFrameRotationMatrixBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            this.thoroughAssertionsFrameMatrix3D((FrameMatrix3DReadOnly)expected, (FrameMatrix3DReadOnly)actual);
            actual.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            this.thoroughAssertionsFrameMatrix3D((FrameMatrix3DReadOnly)expected, (FrameMatrix3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false};
        boolean[][] accessTrace = new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}};
        FrameRotationMatrix source = EuclidFrameRandomTools.nextFrameRotationMatrix((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FixedFrameRotationMatrixBasics observable = EuclidFrameFactories.newObservableFixedFrameRotationMatrixBasics(() -> {
            changeTrace[0] = true;
        }, (row, col) -> {
            accessTrace[row.ordinal()][col.ordinal()] = true;
        }, (FixedFrameRotationMatrixBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        observable.transpose();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.setToNaN();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.setToZero();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        for (int row2 = 0; row2 < 3; ++row2) {
            for (int col2 = 0; col2 < 3; ++col2) {
                observable.getElement(row2, col2);
                Assertions.assertTrue((boolean)accessTrace[row2][col2]);
                accessTrace[row2][col2] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            }
        }
        expected = EuclidFrameRandomTools.nextFrameRotationMatrix((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameRotationMatrix source2 = new FrameRotationMatrix((FrameRotationMatrixReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        BiConsumer<Axis3D, Axis3D> valueAccessedListener = (row, col) -> transform.transform((RotationMatrixBasics)source2);
        FixedFrameRotationMatrixBasics observable2 = EuclidFrameFactories.newObservableFixedFrameRotationMatrixBasics(null, valueAccessedListener, (FixedFrameRotationMatrixBasics)source2);
        for (int row3 = 0; row3 < 3; ++row3) {
            for (int col3 = 0; col3 < 3; ++col3) {
                transform.transform((RotationMatrixBasics)expected);
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)observable2.getElement(row3, col3));
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)source2.getElement(row3, col3));
            }
        }
    }

    @Test
    public void testNewObservableFrameQuaternionBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameQuaternion expected = new FrameQuaternion((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames));
        FixedFrameQuaternionBasics actual = EuclidFrameFactories.newObservableFixedFrameQuaternionBasics(null, null, (FixedFrameQuaternionBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            this.thoroughAssertionsFrameTuple4D((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual);
            actual.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            this.thoroughAssertionsFrameTuple4D((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false};
        boolean[] accessTrace = new boolean[]{false, false, false, false};
        FrameQuaternion source = new FrameQuaternion((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames));
        FixedFrameQuaternionBasics observable = EuclidFrameFactories.newObservableFixedFrameQuaternionBasics(() -> {
            changeTrace[0] = true;
        }, index -> {
            accessTrace[index] = true;
        }, (FixedFrameQuaternionBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        observable.setToZero();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        for (int i = 0; i < 4; ++i) {
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames)));
        FrameQuaternion source2 = new FrameQuaternion((FrameQuaternionReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        IntConsumer valueAccessedListener = index -> transform.transform((Orientation3DBasics)source2);
        FixedFrameQuaternionBasics observable2 = EuclidFrameFactories.newObservableFixedFrameQuaternionBasics(null, (IntConsumer)valueAccessedListener, (FixedFrameQuaternionBasics)source2);
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getS(), (double)observable2.getS());
        Assertions.assertEquals((double)expected.getS(), (double)source2.getS());
    }

    @Test
    public void testNewObservableFixedFrameBoundingBox2DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameBoundingBox2D expected = new FrameBoundingBox2D((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames));
        FixedFrameBoundingBox2DBasics actual = EuclidFrameFactories.newObservableFixedFrameBoundingBox2DBasics(null, null, (FixedFrameBoundingBox2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            this.thoroughAssertionsFrameBoundingBox2D((FrameBoundingBox2DReadOnly)expected, (FrameBoundingBox2DReadOnly)actual);
            actual.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            this.thoroughAssertionsFrameBoundingBox2D((FrameBoundingBox2DReadOnly)expected, (FrameBoundingBox2DReadOnly)actual);
        }
        EnumMap<Bound, boolean[]> changeTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        EnumMap<Bound, boolean[]> accessTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        for (Bound bound2 : Bound.values) {
            changeTraceMap.put(bound2, new boolean[]{false, false});
            accessTraceMap.put(bound2, new boolean[]{false, false});
        }
        FrameBoundingBox2D source = new FrameBoundingBox2D();
        FixedFrameBoundingBox2DBasics observable = EuclidFrameFactories.newObservableFixedFrameBoundingBox2DBasics((axis, bound, newValue) -> {
            ((boolean[])changeTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (axis, bound) -> {
            ((boolean[])accessTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (FixedFrameBoundingBox2DBasics)source);
        EnumMap<Bound, FixedFramePoint2DBasics> boundPoints = new EnumMap<Bound, FixedFramePoint2DBasics>(Bound.class);
        boundPoints.put(Bound.MIN, observable.getMinPoint());
        boundPoints.put(Bound.MAX, observable.getMaxPoint());
        for (Bound bound3 : Bound.values) {
            boolean[] changeTrace = (boolean[])changeTraceMap.get(bound3);
            boolean[] accessTraces = (boolean[])accessTraceMap.get(bound3);
            Point2DBasics boundPoint = (Point2DBasics)boundPoints.get(bound3);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            for (int i = 0; i < 2; ++i) {
                double value = random.nextDouble();
                boundPoint.setElement(i, value);
                Assertions.assertTrue((boolean)changeTrace[i]);
                changeTrace[i] = false;
                boundPoint.setElement(i, value);
                Assertions.assertFalse((boolean)changeTrace[i]);
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
                boundPoint.getElement(i);
                Assertions.assertTrue((boolean)accessTraces[i]);
                accessTraces[i] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            }
        }
    }

    @Test
    public void testNewObservableFixedFrameBoundingBox3DBasics() {
        Random random = new Random(4367L);
        Object[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameBoundingBox3D expected = new FrameBoundingBox3D((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])frames));
        FixedFrameBoundingBox3DBasics actual = EuclidFrameFactories.newObservableFixedFrameBoundingBox3DBasics(null, null, (FixedFrameBoundingBox3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            this.thoroughAssertionsFrameBoundingBox3D((FrameBoundingBox3DReadOnly)expected, (FrameBoundingBox3DReadOnly)actual);
            actual.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            this.thoroughAssertionsFrameBoundingBox3D((FrameBoundingBox3DReadOnly)expected, (FrameBoundingBox3DReadOnly)actual);
        }
        EnumMap<Bound, boolean[]> changeTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        EnumMap<Bound, boolean[]> accessTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        for (Bound bound2 : Bound.values) {
            changeTraceMap.put(bound2, new boolean[]{false, false, false});
            accessTraceMap.put(bound2, new boolean[]{false, false, false});
        }
        FrameBoundingBox3D source = new FrameBoundingBox3D();
        FixedFrameBoundingBox3DBasics observable = EuclidFrameFactories.newObservableFixedFrameBoundingBox3DBasics((axis, bound, newValue) -> {
            ((boolean[])changeTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (axis, bound) -> {
            ((boolean[])accessTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (FixedFrameBoundingBox3DBasics)source);
        EnumMap<Bound, FixedFramePoint3DBasics> boundPoints = new EnumMap<Bound, FixedFramePoint3DBasics>(Bound.class);
        boundPoints.put(Bound.MIN, observable.getMinPoint());
        boundPoints.put(Bound.MAX, observable.getMaxPoint());
        for (Bound bound3 : Bound.values) {
            boolean[] changeTrace = (boolean[])changeTraceMap.get(bound3);
            boolean[] accessTraces = (boolean[])accessTraceMap.get(bound3);
            Point3DBasics boundPoint = (Point3DBasics)boundPoints.get(bound3);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            for (int i = 0; i < 3; ++i) {
                double value = random.nextDouble();
                boundPoint.setElement(i, value);
                Assertions.assertTrue((boolean)changeTrace[i]);
                changeTrace[i] = false;
                boundPoint.setElement(i, value);
                Assertions.assertFalse((boolean)changeTrace[i]);
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
                boundPoint.getElement(i);
                Assertions.assertTrue((boolean)accessTraces[i]);
                accessTraces[i] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            }
        }
    }

    private void thoroughAssertionsFrameTuple2D(FrameTuple2DReadOnly expected, FrameTuple2DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameTuple3D(FrameTuple3DReadOnly expected, FrameTuple3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameTuple4D(FrameTuple4DReadOnly expected, FrameTuple4DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameMatrix3D(FrameMatrix3DReadOnly expected, FrameMatrix3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameBoundingBox2D(FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameBoundingBox3D(FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    private void thoroughAssertionsFrameOrientation2D(FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }
}

