/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public class FrameVertex2DSupplierTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testCreatingEmptySupplier() {
        FrameVertex2DSupplier expected = FrameVertex2DSupplier.emptyFrameVertex2DSupplier();
        FrameVertex2DSupplier actual = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])new FramePoint2DReadOnly[0]);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
        actual = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])new FramePoint2DReadOnly[0], (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
        actual = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])new FramePoint2DReadOnly[0], (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
        actual = FrameVertex2DSupplier.asFrameVertex2DSupplier(Collections.emptyList());
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
        actual = FrameVertex2DSupplier.asFrameVertex2DSupplier(Collections.emptyList(), (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
        actual = FrameVertex2DSupplier.asFrameVertex2DSupplier(Collections.emptyList(), (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-12));
    }

    @Test
    public void testAsFrameVertex2DSupplier() throws Exception {
        int j;
        FrameVertex2DSupplier supplier;
        List subList;
        int listSize;
        int numberOfVertices;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            FrameVertex2DSupplier supplier2 = FrameVertex2DSupplier.asFrameVertex2DSupplier(original);
            Assertions.assertEquals((int)numberOfVertices, (int)supplier2.getNumberOfVertices());
            for (int j2 = 0; j2 < numberOfVertices; ++j2) {
                Assertions.assertTrue((original.get(j2) == supplier2.getVertex(j2) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices2 = random.nextInt(listSize);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < listSize) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            FrameVertex2DSupplier supplier3 = FrameVertex2DSupplier.asFrameVertex2DSupplier(original, (int)numberOfVertices2);
            Assertions.assertEquals((int)numberOfVertices2, (int)supplier3.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices2);
            for (int j3 = 0; j3 < numberOfVertices2; ++j3) {
                Assertions.assertTrue((subList.get(j3) == supplier3.getVertex(j3) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices3 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices3);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < listSize) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            supplier = FrameVertex2DSupplier.asFrameVertex2DSupplier(original, (int)startIndex, (int)numberOfVertices3);
            Assertions.assertEquals((int)numberOfVertices3, (int)supplier.getNumberOfVertices());
            List subList2 = original.subList(startIndex, startIndex + numberOfVertices3);
            for (j = 0; j < numberOfVertices3; ++j) {
                Assertions.assertTrue((subList2.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            FrameVertex2DSupplier supplier4 = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])original.toArray(new FramePoint2DReadOnly[0]));
            Assertions.assertEquals((int)numberOfVertices, (int)supplier4.getNumberOfVertices());
            for (int j4 = 0; j4 < numberOfVertices; ++j4) {
                Assertions.assertTrue((original.get(j4) == supplier4.getVertex(j4) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices4 = random.nextInt(listSize);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < listSize) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            FrameVertex2DSupplier supplier5 = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])original.toArray(new FramePoint2DReadOnly[0]), (int)numberOfVertices4);
            Assertions.assertEquals((int)numberOfVertices4, (int)supplier5.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices4);
            for (int j5 = 0; j5 < numberOfVertices4; ++j5) {
                Assertions.assertTrue((subList.get(j5) == supplier5.getVertex(j5) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices5 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices5);
            ArrayList<FramePoint2D> original = new ArrayList<FramePoint2D>();
            while (original.size() < listSize) {
                original.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame));
            }
            supplier = FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])original.toArray(new FramePoint2DReadOnly[0]), (int)startIndex, (int)numberOfVertices5);
            Assertions.assertEquals((int)numberOfVertices5, (int)supplier.getNumberOfVertices());
            List subList3 = original.subList(startIndex, startIndex + numberOfVertices5);
            for (j = 0; j < numberOfVertices5; ++j) {
                Assertions.assertTrue((subList3.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame)).collect(Collectors.toList());
            List listAPrime = listA.stream().map(FramePoint2D::new).collect(Collectors.toList());
            List listSizeA = IntStream.range(0, sizeA).mapToObj(v -> EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame)).collect(Collectors.toList());
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).equals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA)));
            Assertions.assertTrue((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).equals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listAPrime)));
            Assertions.assertFalse((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).equals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listSizeA)));
            Assertions.assertFalse((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).equals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listB)));
        }
    }

    @Test
    public void testEpsilonquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame)).collect(Collectors.toList());
            List<FramePoint2D> listAPrime = listA.stream().map(FramePoint2D::new).collect(Collectors.toList());
            listAPrime.forEach(p -> p.add(EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon), EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon)));
            List<FramePoint2D> listSizeA = listA.stream().map(FramePoint2D::new).collect(Collectors.toList());
            listSizeA.forEach(p -> p.add((random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0)), (random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0))));
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).epsilonEquals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA), epsilon), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).epsilonEquals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listAPrime), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).epsilonEquals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listSizeA), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)FrameVertex2DSupplier.asFrameVertex2DSupplier(listA).epsilonEquals((EuclidFrameGeometry)FrameVertex2DSupplier.asFrameVertex2DSupplier(listB), epsilon), (String)("Iteration: " + i));
        }
    }
}

