/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose2D;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;

public abstract class FramePose2DReadOnlyTest<T extends FramePose2DReadOnly> {
    public abstract T createFramePose(ReferenceFrame var1, Pose2DReadOnly var2);

    public final T createEmptyFramePose(ReferenceFrame referenceFrame) {
        return this.createFramePose(referenceFrame, (Pose2DReadOnly)new Pose2D());
    }

    public final T createRandomFramePose(Random random) {
        return this.createRandomFramePose(random, ReferenceFrame.getWorldFrame());
    }

    public final T createRandomFramePose(Random random, ReferenceFrame referenceFrame) {
        return this.createFramePose(referenceFrame, (Pose2DReadOnly)EuclidGeometryRandomTools.nextPose2D((Random)random));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFramePose, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePose2DReadOnly.class, Pose2DReadOnly.class, true);
    }
}

