/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePlane3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FramePlane3DTest {
    private static ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static double epsilon = 1.0E-14;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testIsOnOrAbove() {
        FramePlane3D plane = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        FramePoint3D q = new FramePoint3D(worldFrame, 0.0, 0.0, 2.0);
        Assertions.assertTrue((boolean)plane.isOnOrAbove((FramePoint3DReadOnly)q));
        q = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)plane.isOnOrAbove((FramePoint3DReadOnly)q));
        q = new FramePoint3D(worldFrame, 0.0, 0.0, -2.0);
        Assertions.assertFalse((boolean)plane.isOnOrAbove((FramePoint3DReadOnly)q));
    }

    @Test
    public void testIsOnOrBelow() {
        FramePlane3D plane = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        FramePoint3D q = new FramePoint3D(worldFrame, 0.0, 0.0, -2.0);
        Assertions.assertTrue((boolean)plane.isOnOrBelow((FramePoint3DReadOnly)q));
        q.set(0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)plane.isOnOrBelow((FramePoint3DReadOnly)q));
    }

    @Test
    public void testOrthogonalProjection() {
        FramePoint3D point = new FramePoint3D(worldFrame, 1.0, 2.0, -3.0);
        FramePoint3D expectedPoint = new FramePoint3D(worldFrame, 1.0, 2.0, 0.0);
        FramePlane3D plane = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        Assertions.assertTrue((boolean)expectedPoint.epsilonEquals((EuclidGeometry)plane.orthogonalProjectionCopy((Point3DReadOnly)point), 1.0E-14));
        point.set(3.0, 3.0, -4.0);
        plane.getPoint().set(1.0, 1.0, 1.0);
        plane.getNormal().set(2.0, 0.0, 0.0);
        expectedPoint.set(1.0, 3.0, -4.0);
        Assertions.assertTrue((boolean)expectedPoint.epsilonEquals((EuclidGeometry)plane.orthogonalProjectionCopy((Point3DReadOnly)point), 1.0E-14));
    }

    @Test
    public void testDistance() {
        FramePoint3D point = new FramePoint3D(worldFrame, 1.0, 1.0, 1.0);
        FramePlane3D plane = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        Assertions.assertEquals((double)1.0, (double)plane.distance((FramePoint3DReadOnly)point), (double)1.0E-14);
        point.set(0.0, 0.0, 0.0);
        plane.getNormal().set(1.0, 1.0, 0.0);
        plane.getPoint().set(1.0, 1.0, 0.0);
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)plane.distance((FramePoint3DReadOnly)point), (double)epsilon);
    }

    @Test
    public void testApplyTransform() {
        RigidBodyTransform transformation = new RigidBodyTransform();
        transformation.setRotationYawAndZeroTranslation(2.3);
        FramePlane3D plane = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane.applyTransform((Transform)transformation);
        FrameVector3D expectedNormal = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FramePoint3D expectedPoint = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)plane.epsilonEquals((EuclidFrameGeometry)new FramePlane3D((FramePoint3DReadOnly)expectedPoint, (FrameVector3DReadOnly)expectedNormal), epsilon));
        RigidBodyTransform transformation2 = new RigidBodyTransform();
        transformation2.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        FramePlane3D plane2 = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane2.applyTransform((Transform)transformation2);
        expectedNormal.set(0.0, 0.0, 1.0);
        expectedPoint.set(1.0, 2.0, 3.0);
        Assertions.assertTrue((boolean)plane2.epsilonEquals((EuclidFrameGeometry)new FramePlane3D((FramePoint3DReadOnly)expectedPoint, (FrameVector3DReadOnly)expectedNormal), epsilon));
        RigidBodyTransform transformation3 = new RigidBodyTransform();
        transformation3.setRotationPitchAndZeroTranslation(1.5707963267948966);
        transformation3.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        FramePlane3D plane3 = new FramePlane3D(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane3.applyTransform((Transform)transformation3);
        expectedNormal.set(1.0, 0.0, 0.0);
        expectedPoint.set(1.0, 2.0, 3.0);
        Assertions.assertTrue((boolean)plane3.epsilonEquals((EuclidFrameGeometry)new FramePlane3D((FramePoint3DReadOnly)expectedPoint, (FrameVector3DReadOnly)expectedNormal), epsilon));
    }

    @Test
    public void testIntersectionWithLine() {
        FrameVector3D normal = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FramePoint3D point = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        FramePlane3D plane = new FramePlane3D((FramePoint3DReadOnly)point, (FrameVector3DReadOnly)normal);
        FramePoint3D origin = new FramePoint3D(worldFrame, 0.0, 1.0, -1.0);
        FrameVector3D direction = new FrameVector3D(worldFrame, 1.0, 0.0, 1.0);
        FrameLine3D line = new FrameLine3D((FramePoint3DReadOnly)origin, (FrameVector3DReadOnly)direction);
        FramePoint3D pointToPack = new FramePoint3D(worldFrame);
        plane.intersectionWith((FrameLine3DReadOnly)line, (FramePoint3DBasics)pointToPack);
        FramePoint3D expectedIntersection = new FramePoint3D(worldFrame, 1.0, 1.0, 0.0);
        Assertions.assertTrue((boolean)pointToPack.epsilonEquals((EuclidFrameGeometry)expectedIntersection, epsilon));
    }
}

