/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox2D;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox2DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;

public class FrameBoundingBox2DTest
extends FrameBoundingBox2DReadOnlyTest<FrameBoundingBox2D> {
    @Override
    public FrameBoundingBox2D createFrameBoundingBox(ReferenceFrame referenceFrame, BoundingBox2DReadOnly boundingBox) {
        return new FrameBoundingBox2D(referenceFrame, boundingBox);
    }

    @Test
    public void testConsistencyWithBoundingBox2D() {
        FrameTypeCopier frameTypeBuilder = (frame, boundingBox) -> this.createFrameBoundingBox(frame, (BoundingBox2DReadOnly)boundingBox);
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidGeometryRandomTools::nextBoundingBox2D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{BoundingBox2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{BoundingBox2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{BoundingBox2D.class, Double.TYPE}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !Modifier.isStatic(m.getModifiers()));
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameBoundingBox2D.class, BoundingBox2D.class, false, 1, methodFilter);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameBoundingBox2D, 10);
    }
}

