/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Axis3DTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testOrdinals() {
        Assertions.assertEquals((int)Axis3D.X.ordinal(), (int)0);
        Assertions.assertEquals((int)Axis3D.Y.ordinal(), (int)1);
        Assertions.assertEquals((int)Axis3D.Z.ordinal(), (int)2);
    }

    @Test
    public void testDot() {
        Random random = new Random(3249783L);
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 3; ++j) {
                Axis3D axis = Axis3D.values[j];
                Vector3D axisVector = new Vector3D((Tuple3DReadOnly)axis);
                Vector3D otherVector = EuclidCoreRandomTools.nextVector3D((Random)random);
                Assertions.assertEquals((double)axisVector.dot((Tuple3DReadOnly)otherVector), (double)axis.dot((Tuple3DReadOnly)otherVector));
            }
        }
    }

    @Test
    public void testGetElement() {
        Random random = new Random(436566L);
        for (int i = 0; i < 1000; ++i) {
            Point3D point3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Assertions.assertEquals((double)point3D.getX(), (double)Axis3D.X.extract((Tuple3DReadOnly)point3D));
            Assertions.assertEquals((double)point3D.getY(), (double)Axis3D.Y.extract((Tuple3DReadOnly)point3D));
            Assertions.assertEquals((double)point3D.getZ(), (double)Axis3D.Z.extract((Tuple3DReadOnly)point3D));
            for (int j = 0; j < 3; ++j) {
                Assertions.assertEquals((double)point3D.getElement(j), (double)Axis3D.values[j].extract((Tuple3DReadOnly)point3D));
            }
        }
    }

    @Test
    public void testSetElement() {
        Random random = new Random(436566L);
        for (int i = 0; i < 1000; ++i) {
            Point3D original = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D actual = new Point3D((Tuple3DReadOnly)original);
            Point3D expected = new Point3D((Tuple3DReadOnly)original);
            double newValue = random.nextDouble();
            for (int j = 0; j < 3; ++j) {
                Axis3D.values[j].insert((Tuple3DBasics)actual, newValue);
                expected.setElement(j, newValue);
                Assertions.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testVectorValues() {
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(1.0, 0.0, 0.0), (EuclidGeometry)Axis3D.X, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 1.0, 0.0), (EuclidGeometry)Axis3D.Y, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), (EuclidGeometry)Axis3D.Z, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(-1.0, 0.0, 0.0), (EuclidGeometry)Axis3D.X.negated(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, -1.0, 0.0), (EuclidGeometry)Axis3D.Y.negated(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, -1.0), (EuclidGeometry)Axis3D.Z.negated(), (double)0.0);
    }

    @Test
    public void testNextAndPrevious() {
        Assertions.assertEquals((Object)Axis3D.X.next(), (Object)Axis3D.Y);
        Assertions.assertEquals((Object)Axis3D.Y.next(), (Object)Axis3D.Z);
        Assertions.assertEquals((Object)Axis3D.Z.next(), (Object)Axis3D.X);
        Assertions.assertEquals((Object)Axis3D.X.previous(), (Object)Axis3D.Z);
        Assertions.assertEquals((Object)Axis3D.Y.previous(), (Object)Axis3D.X);
        Assertions.assertEquals((Object)Axis3D.Z.previous(), (Object)Axis3D.Y);
    }
}

