/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.QuaternionBasicsTest;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class QuaternionTest
extends QuaternionBasicsTest<Quaternion> {
    public static final double EPS = 1.0E-14;

    @Test
    public void testQuaternion() {
        int i;
        Random random = new Random(613615L);
        Quaternion quaternion = new Quaternion();
        Quaternion expected = new Quaternion();
        expected.setToZero();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)expected, (double)1.0E-14);
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternionCopy;
            quaternion = quaternionCopy = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion quaternion2 = new Quaternion((QuaternionReadOnly)quaternion);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)quaternion2, (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)quaternionCopy, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.normalizeAndLimitToPi();
            quaternion = new Quaternion(expected.getX(), expected.getY(), expected.getZ(), expected.getS());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)expected, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double[] quaternionArray = new double[]{expected.getX(), expected.getY(), expected.getZ(), expected.getS()};
            quaternion = new Quaternion(quaternionArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)quaternion, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrixCopy;
            RotationMatrix rotationMatrix = rotationMatrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            quaternion = new Quaternion((Orientation3DReadOnly)rotationMatrix);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)quaternion, (double)1.0E-14);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVectorCopy;
            Vector3D rotationVector = rotationVectorCopy = EuclidCoreRandomTools.nextRotationVector((Random)random);
            quaternion = new Quaternion((Vector3DReadOnly)rotationVector);
            QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)rotationVector, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)expected, (double)1.0E-14);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)rotationVector, (Vector3DReadOnly)rotationVectorCopy, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            quaternion = new Quaternion(yaw, pitch, roll);
            QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)expected, (double)1.0E-14);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
        int newHashCode = q.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)q.hashCode());
        int previousHashCode = q.hashCode();
        for (int i = 0; i < 1000; ++i) {
            double qx = q.getX();
            double qy = q.getY();
            double qz = q.getZ();
            double qs = q.getS();
            switch (random.nextInt(4)) {
                case 0: {
                    qx = random.nextDouble();
                    break;
                }
                case 1: {
                    qy = random.nextDouble();
                    break;
                }
                case 2: {
                    qz = random.nextDouble();
                    break;
                }
                case 3: {
                    qs = random.nextDouble();
                }
            }
            q.setUnsafe(qx, qy, qz, qs);
            newHashCode = q.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    public Quaternion createEmptyTuple() {
        return new Quaternion();
    }

    @Override
    public Quaternion createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextQuaternion((Random)random);
    }

    @Override
    public Quaternion createTuple(double x, double y, double z, double s) {
        Quaternion quaternion = new Quaternion();
        quaternion.setUnsafe(x, y, z, s);
        return quaternion;
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }
}

