/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasicsTest;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Tuple4DBasicsTest;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public abstract class QuaternionBasicsTest<T extends QuaternionBasics>
extends Tuple4DBasicsTest<T> {
    public static final double EPS = 1.0E-14;

    @Test
    public void testIsUnitary() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics q1 = (QuaternionBasics)this.createRandomTuple(random);
            Assertions.assertTrue((boolean)q1.isUnitary(this.getEpsilon()));
            QuaternionBasics q2 = (QuaternionBasics)this.createRandomTuple(random);
            q1 = (QuaternionBasics)this.createTuple(q2.getX(), q2.getY(), q2.getZ(), q2.getS());
            Assertions.assertTrue((boolean)q1.isUnitary(this.getEpsilon()));
            double delta = 20.0 * EuclidCoreTools.squareRoot((double)this.getEpsilon());
            q1 = (QuaternionBasics)this.createTuple(delta + q2.getX(), q2.getY(), q2.getZ(), q2.getS());
            Assertions.assertFalse((boolean)q1.isUnitary(this.getEpsilon()));
            q1 = (QuaternionBasics)this.createTuple(q2.getX(), delta + q2.getY(), q2.getZ(), q2.getS());
            Assertions.assertFalse((boolean)q1.isUnitary(this.getEpsilon()));
            q1 = (QuaternionBasics)this.createTuple(q2.getX(), q2.getY(), delta + q2.getZ(), q2.getS());
            Assertions.assertFalse((boolean)q1.isUnitary(this.getEpsilon()));
            q1 = (QuaternionBasics)this.createTuple(q2.getX(), q2.getY(), q2.getZ(), delta + q2.getS());
            Assertions.assertFalse((boolean)q1.isUnitary(this.getEpsilon()));
        }
    }

    @Test
    public void testIsOrientation2D() throws Exception {
        Random random = new Random(23905872L);
        for (int i = 0; i < 1000; ++i) {
            double qx = random.nextDouble();
            double qy = random.nextDouble();
            double qz = random.nextDouble();
            double qs = random.nextDouble();
            QuaternionBasics quaternion = (QuaternionBasics)this.createEmptyTuple();
            quaternion.set(qx, qy, qz, qs);
            Assertions.assertFalse((boolean)quaternion.isOrientation2D(this.getEpsilon()));
            quaternion.set(0.0, qy, qz, qs);
            Assertions.assertFalse((boolean)quaternion.isOrientation2D(this.getEpsilon()));
            quaternion.set(qx, 0.0, qz, qs);
            Assertions.assertFalse((boolean)quaternion.isOrientation2D(this.getEpsilon()));
            quaternion.set(0.0, 0.0, qz, qs);
            Assertions.assertTrue((boolean)quaternion.isOrientation2D(this.getEpsilon()));
            quaternion.set(2.0 * this.getEpsilon(), 0.0, qz, qs);
            Assertions.assertFalse((boolean)quaternion.isOrientation2D(this.getEpsilon()));
            quaternion.set(0.0, 2.0 * this.getEpsilon(), qz, qs);
            Assertions.assertFalse((boolean)quaternion.isOrientation2D(this.getEpsilon()));
        }
    }

    @Test
    public void testCheckIfOrientation2D() throws Exception {
        Random random = new Random(23905872L);
        for (int i = 0; i < 1000; ++i) {
            double qx = random.nextDouble();
            double qy = random.nextDouble();
            double qz = random.nextDouble();
            double qs = random.nextDouble();
            QuaternionBasics quaternion = (QuaternionBasics)this.createEmptyTuple();
            quaternion.set(qx, qy, qz, qs);
            try {
                quaternion.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            catch (NotAnOrientation2DException notAnOrientation2DException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            quaternion.set(0.0, qy, qz, qs);
            try {
                quaternion.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            catch (NotAnOrientation2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            quaternion.set(qx, 0.0, qz, qs);
            try {
                quaternion.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            catch (NotAnOrientation2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException");
            }
            quaternion.set(0.0, 0.0, qz, qs);
            quaternion.checkIfOrientation2D(this.getEpsilon());
        }
    }

    @Test
    public void testDistance() throws Exception {
        int j;
        QuaternionReadOnly q1;
        int i;
        Random random = new Random(1651L);
        Quaternion qDiff = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            q1 = (QuaternionReadOnly)this.createRandomTuple(random);
            for (j = 0; j < 1000; ++j) {
                QuaternionReadOnly q2 = (QuaternionReadOnly)this.createRandomTuple(random);
                qDiff.difference(q1, q2);
                double expectedAngle = qDiff.angle();
                double actualAngle = q1.distance((Orientation3DReadOnly)q2);
                Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)this.getEpsilon());
                Assertions.assertEquals((double)0.0, (double)q1.distance((Orientation3DReadOnly)q1));
                Assertions.assertEquals((double)0.0, (double)q1.distance((Orientation3DReadOnly)new Quaternion(q1)), (double)this.getEpsilon());
            }
        }
        for (i = 0; i < 1000; ++i) {
            q1 = (QuaternionReadOnly)this.createRandomTuple(random);
            for (j = 0; j < 1000; ++j) {
                double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2));
                AxisAngle aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), expectedAngle);
                QuaternionBasics q2 = (QuaternionBasics)this.createEmptyTuple();
                q2.set((Orientation3DReadOnly)aa);
                q2.preMultiply(q1);
                double actualAngle = q1.distance((Orientation3DReadOnly)q2);
                Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)this.getEpsilon());
            }
        }
    }

    @Test
    public void testAngle() throws Exception {
        Random random = new Random(1223L);
        for (int i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            axisAngle.setAngle(angle);
            Quaternion quaternion = new Quaternion((Orientation3DReadOnly)axisAngle);
            Assertions.assertEquals((double)quaternion.angle(), (double)Math.abs(angle), (double)1.0E-14);
        }
    }

    @Test
    public void testGetAngle() {
        Random random = new Random(65445L);
        double expectedAngle = Math.PI * 2 * random.nextDouble();
        double c = EuclidCoreTools.cos((double)(expectedAngle / 2.0));
        double s = EuclidCoreTools.sin((double)(expectedAngle / 2.0));
        Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        Quaternion q = new Quaternion();
        double qx = s * axis.getX();
        double qy = s * axis.getY();
        double qz = s * axis.getZ();
        double qs = c;
        q.setUnsafe(qx, qy, qz, qs);
        Assertions.assertEquals((double)expectedAngle, (double)q.angle(), (double)this.getEpsilon());
    }

    @Test
    public void testGetRotationVector() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics quaternion = (QuaternionBasics)this.createRandomTuple(random);
            Vector3D expectedRotationVector = new Vector3D();
            Vector3D actualRotationVector = new Vector3D();
            RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)expectedRotationVector);
            quaternion.getRotationVector((Vector3DBasics)actualRotationVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedRotationVector, (EuclidGeometry)actualRotationVector, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetYawPitchRoll() {
        Random random = new Random(654651351L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics quaternion = (QuaternionBasics)this.createRandomTuple(random);
            Vector3D eulerAngles = new Vector3D();
            quaternion.getEuler((Tuple3DBasics)eulerAngles);
            Vector3D expectedEulerAngles = new Vector3D();
            YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)expectedEulerAngles);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedEulerAngles, (EuclidGeometry)eulerAngles, (double)this.getEpsilon());
            double yaw = quaternion.getYaw();
            double expectedYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
            Assertions.assertEquals((double)yaw, (double)expectedYaw, (double)this.getEpsilon());
            double pitch = quaternion.getPitch();
            double expectedPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
            Assertions.assertEquals((double)pitch, (double)expectedPitch, (double)this.getEpsilon());
            double roll = quaternion.getRoll();
            double expectedRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
            Assertions.assertEquals((double)roll, (double)expectedRoll, (double)this.getEpsilon());
        }
    }

    @Test
    public void testTransform() {
        Matrix3D matrixActual;
        Matrix3D matrixExpected;
        Matrix3D matrixOriginal;
        int i;
        float qs;
        float qz;
        double theta;
        Vector3D expectedTuple;
        Vector3D actualTuple;
        Vector3D tuple;
        int i2;
        Random random = new Random(6787L);
        QuaternionBasics quaternion = (QuaternionBasics)this.createEmptyTuple();
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.transform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.transform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = new Vector3D((Tuple3DReadOnly)tuple);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.addTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedTuple = new Vector3D((Tuple3DReadOnly)actualTuple);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.addTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            qz = (float)EuclidCoreTools.sin((double)(0.5 * theta));
            qs = (float)EuclidCoreTools.cos((double)(0.5 * theta));
            quaternion = (QuaternionBasics)this.createTuple(0.0, 0.0, qz, qs);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            quaternion.transform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            quaternion.transform((Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            quaternion.transform((Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            qz = (float)EuclidCoreTools.sin((double)(0.5 * theta));
            qs = (float)EuclidCoreTools.cos((double)(0.5 * theta));
            quaternion = (QuaternionBasics)this.createTuple(0.0, 0.0, qz, qs);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            quaternion.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            quaternion.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            quaternion.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.transform((Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException i3) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.transform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.transform((Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.transform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            Quaternion qOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qExpected = new Quaternion();
            Quaternion qActual = new Quaternion();
            qExpected.multiply((QuaternionReadOnly)quaternion, (QuaternionReadOnly)qOriginal);
            quaternion.transform((Orientation3DReadOnly)qOriginal, (Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
            qActual.set(qOriginal);
            quaternion.transform((Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            Vector4D vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Vector4D vectorExpected = new Vector4D();
            Vector4D vectorActual = new Vector4D();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            quaternion.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
            vectorActual.set(vectorOriginal);
            quaternion.transform((Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrixExpected = new Matrix3D();
            matrixActual = new Matrix3D();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixExpected);
            quaternion.transform((Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual.set(matrixOriginal);
            quaternion.transform((Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            matrixOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            matrixExpected = new RotationMatrix();
            matrixActual = new RotationMatrix();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixExpected);
            quaternion.transform((RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual.set((RotationMatrix)matrixOriginal);
            quaternion.transform((RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testInverseTransform() {
        Quaternion expected;
        Quaternion actual;
        Quaternion original;
        int i;
        float qs;
        float qz;
        double theta;
        Vector3D expectedTuple;
        Vector3D actualTuple;
        Vector3D tuple;
        int i2;
        Random random = new Random(6787L);
        QuaternionBasics quaternion = (QuaternionBasics)this.createEmptyTuple();
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.inverseTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            quaternion.inverseTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            qz = (float)EuclidCoreTools.sin((double)(0.5 * theta));
            qs = (float)EuclidCoreTools.cos((double)(0.5 * theta));
            quaternion = (QuaternionBasics)this.createTuple(0.0, 0.0, qz, qs);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            quaternion.inverseTransform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            quaternion.inverseTransform((Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            quaternion.inverseTransform((Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            qz = (float)EuclidCoreTools.sin((double)(0.5 * theta));
            qs = (float)EuclidCoreTools.cos((double)(0.5 * theta));
            quaternion = (QuaternionBasics)this.createTuple(0.0, 0.0, qz, qs);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            quaternion.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            quaternion.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            quaternion.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.inverseTransform((Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException i3) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.inverseTransform((Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        try {
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternion.inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            quaternion.inverseTransform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            quaternion.inverseTransform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            quaternion.inverseTransform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            quaternion.inverseTransform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            quaternion.inverseTransform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            quaternion.inverseTransform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)original, (RotationMatrixBasics)expected);
            quaternion.inverseTransform((RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            quaternion = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)original, (RotationMatrixBasics)expected);
            quaternion.inverseTransform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Override
    @Test
    public void testNegate() throws Exception {
        super.testNegate();
        Random random = new Random(621541L);
        QuaternionBasics tuple1 = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics tuple2 = (QuaternionBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                for (double signZ = -1.0; signZ <= 1.0; signZ += 2.0) {
                    for (double signS = -1.0; signS <= 1.0; signS += 2.0) {
                        QuaternionBasics original = (QuaternionBasics)this.createRandomTuple(random);
                        double xOriginal = signX * original.getX();
                        double yOriginal = signY * original.getY();
                        double zOriginal = signZ * original.getZ();
                        double sOriginal = signS * original.getS();
                        tuple1 = (QuaternionBasics)this.createTuple(xOriginal, yOriginal, zOriginal, sOriginal);
                        tuple2.setToNaN();
                        tuple2.setAndNegate((QuaternionReadOnly)tuple1);
                        Assertions.assertEquals((double)tuple2.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple2.getS(), (double)(-sOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getX(), (double)xOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)yOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)zOriginal, (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)sOriginal, (double)this.getEpsilon());
                        tuple1.negate();
                        Assertions.assertEquals((double)tuple1.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getZ(), (double)(-zOriginal), (double)this.getEpsilon());
                        Assertions.assertEquals((double)tuple1.getS(), (double)(-sOriginal), (double)this.getEpsilon());
                    }
                }
            }
        }
    }

    @Override
    @Test
    public void testNormalize() {
        super.testNormalize();
        Quaternion expected = new Quaternion();
        Quaternion actual = new Quaternion();
        actual.setUnsafe(0.0, 0.0, 0.0, 0.0);
        actual.normalize();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        Quaternion q = new Quaternion();
        q.setUnsafe(1.0, 1.0, 1.0, 1.0);
        actual.setAndNormalize((QuaternionReadOnly)q);
        Assertions.assertTrue((boolean)actual.isUnitary(this.getEpsilon()));
        q.setUnsafe(1.0, 1.0, 1.0, 1.0);
        actual.setAndNormalize((Orientation3DReadOnly)q);
        Assertions.assertTrue((boolean)actual.isUnitary(this.getEpsilon()));
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(621541L);
        QuaternionBasics quaternion = (QuaternionBasics)this.createRandomTuple(random);
        quaternion.setToZero();
        QuaternionBasics zeroQ = (QuaternionBasics)this.createTuple(0.0, 0.0, 0.0, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)zeroQ, (double)this.getEpsilon());
    }

    @Test
    public void testConjugate() {
        Random random = new Random(65445L);
        QuaternionBasics quaternionCopy = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics quaternion = (QuaternionBasics)this.createRandomTuple(random);
            quaternionCopy.set((QuaternionReadOnly)quaternion);
            quaternion.conjugate();
            Assertions.assertEquals((double)quaternion.getX(), (double)(-quaternionCopy.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)quaternion.getY(), (double)(-quaternionCopy.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)quaternion.getZ(), (double)(-quaternionCopy.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)quaternion.getS(), (double)quaternionCopy.getS(), (double)this.getEpsilon());
            QuaternionBasics quaternion2 = (QuaternionBasics)this.createEmptyTuple();
            quaternion2.setAndConjugate((QuaternionReadOnly)quaternionCopy);
            Assertions.assertEquals((double)quaternion2.getX(), (double)(-quaternionCopy.getX()));
            Assertions.assertEquals((double)quaternion2.getY(), (double)(-quaternionCopy.getY()));
            Assertions.assertEquals((double)quaternion2.getZ(), (double)(-quaternionCopy.getZ()));
            Assertions.assertEquals((double)quaternion2.getS(), (double)quaternionCopy.getS());
        }
    }

    @Test
    public void testInverse() {
        Random random = new Random(15461L);
        Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        double sinHalfTheta = EuclidCoreTools.sin((double)(theta / 2.0));
        double cosHalfTheta = EuclidCoreTools.cos((double)(theta / 2.0));
        double qx = axis.getX() * sinHalfTheta;
        double qy = axis.getY() * sinHalfTheta;
        double qz = axis.getZ() * sinHalfTheta;
        double qs = cosHalfTheta;
        QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
        qExpected.setUnsafe(-qx, -qy, -qz, qs);
        QuaternionBasics qActual = (QuaternionBasics)this.createEmptyTuple();
        qActual.setUnsafe(qx, qy, qz, qs);
        qActual.inverse();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        double scale = random.nextDouble();
        qActual.setUnsafe(scale * qx, scale * qy, scale * qz, scale * qs);
        qActual.inverse();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI, (double)(Math.PI * 2));
        sinHalfTheta = EuclidCoreTools.sin((double)(theta / 2.0));
        cosHalfTheta = EuclidCoreTools.cos((double)(theta / 2.0));
        qx = axis.getX() * sinHalfTheta;
        qy = axis.getY() * sinHalfTheta;
        qz = axis.getZ() * sinHalfTheta;
        qs = cosHalfTheta;
        qExpected.setUnsafe(-qx, -qy, -qz, qs);
        qActual.setUnsafe(qx, qy, qz, qs);
        qActual.inverse();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        QuaternionBasics qOriginal = (QuaternionBasics)this.createRandomTuple(random);
        qExpected.set((QuaternionReadOnly)qOriginal);
        qExpected.inverse();
        qActual.setAndInvert((Orientation3DReadOnly)qOriginal);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
    }

    @Test
    public void testNormalizeAndLimitToPi() {
        Random random = new Random(15461L);
        Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        double sinHalfTheta = EuclidCoreTools.sin((double)(theta / 2.0));
        double cosHalfTheta = EuclidCoreTools.cos((double)(theta / 2.0));
        double qx = axis.getX() * sinHalfTheta;
        double qy = axis.getY() * sinHalfTheta;
        double qz = axis.getZ() * sinHalfTheta;
        double qs = cosHalfTheta;
        QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
        qExpected.setUnsafe(qx, qy, qz, qs);
        QuaternionBasics qActual = (QuaternionBasics)this.createEmptyTuple();
        qActual.setUnsafe(qx, qy, qz, qs);
        qActual.normalizeAndLimitToPi();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        double scale = random.nextDouble();
        qActual.setUnsafe(scale * qx, scale * qy, scale * qz, scale * qs);
        qActual.normalizeAndLimitToPi();
        Assertions.assertEquals((double)1.0, (double)qActual.norm(), (double)this.getEpsilon());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        for (int i = 0; i < 1000; ++i) {
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI, (double)(Math.PI * 2));
            sinHalfTheta = EuclidCoreTools.sin((double)(theta / 2.0));
            cosHalfTheta = EuclidCoreTools.cos((double)(theta / 2.0));
            qx = axis.getX() * sinHalfTheta;
            qy = axis.getY() * sinHalfTheta;
            qz = axis.getZ() * sinHalfTheta;
            qs = cosHalfTheta;
            qExpected.setUnsafe(qx, qy, qz, qs);
            qActual.setUnsafe(qx, qy, qz, qs);
            qActual.normalizeAndLimitToPi();
            if (Math.abs(qExpected.angle()) < Math.PI) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
                continue;
            }
            Assertions.assertTrue((Math.abs(qActual.angle()) < Math.PI ? 1 : 0) != 0);
            qExpected.negate();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPow() throws Exception {
        Random random = new Random(541651L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics original = (QuaternionBasics)this.createRandomTuple(random);
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            AxisAngle axisAngle = new AxisAngle((Orientation3DReadOnly)original);
            axisAngle.setAngle(alpha * axisAngle.getAngle());
            QuaternionBasics expected = (QuaternionBasics)this.createEmptyTuple();
            expected.set((Orientation3DReadOnly)axisAngle);
            QuaternionBasics actual = (QuaternionBasics)this.createEmptyTuple();
            actual.set((QuaternionReadOnly)original);
            actual.pow(alpha);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Override
    public void testSetDoubles() {
        Random random = new Random(621541L);
        QuaternionBasics quaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            double s = random.nextDouble();
            quaternion.set(x, y, z, s);
            Assertions.assertNotEquals((double)quaternion.getX(), (double)x);
            Assertions.assertNotEquals((double)quaternion.getY(), (double)y);
            Assertions.assertNotEquals((double)quaternion.getZ(), (double)z);
            Assertions.assertNotEquals((double)quaternion.getS(), (double)s);
            Assertions.assertEquals((double)1.0, (double)quaternion.norm(), (double)this.getEpsilon());
            QuaternionBasics original = (QuaternionBasics)this.createRandomTuple(random);
            x = original.getX();
            y = original.getY();
            z = original.getZ();
            s = original.getS();
            quaternion.set(x, y, z, s);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)quaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetAxisAngle() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)expectedQuaternion);
            actualQuaternion.set((Orientation3DReadOnly)axisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetRotationMatrix() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)expectedQuaternion);
            actualQuaternion.set((Orientation3DReadOnly)rotationMatrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetRotationVector() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)rotationVector, (QuaternionBasics)expectedQuaternion);
            actualQuaternion.setRotationVector((Vector3DReadOnly)rotationVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetEuler() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            Vector3D eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
            QuaternionConversion.convertYawPitchRollToQuaternion((double)eulerAngles.getZ(), (double)eulerAngles.getY(), (double)eulerAngles.getX(), (QuaternionBasics)expectedQuaternion);
            actualQuaternion.setEuler((Vector3DReadOnly)eulerAngles);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
            actualQuaternion.setToZero();
            actualQuaternion.setEuler(eulerAngles.getX(), eulerAngles.getY(), eulerAngles.getZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetYawQuaternion() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            actualQuaternion.setToYawOrientation(yaw);
            expectedQuaternion.set((Orientation3DReadOnly)new AxisAngle(0.0, 0.0, 1.0, yaw));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetPitchQuaternion() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            actualQuaternion.setToPitchOrientation(pitch);
            expectedQuaternion.set((Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, pitch));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetRollQuaternion() {
        Random random = new Random(574631L);
        QuaternionBasics actualQuaternion = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expectedQuaternion = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            actualQuaternion.setToRollOrientation(roll);
            expectedQuaternion.set((Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, roll));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDifference() {
        Random random = new Random(65445L);
        QuaternionBasics diff = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics expected = (QuaternionBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics q1 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics q2 = (QuaternionBasics)this.createRandomTuple(random);
            diff.difference((QuaternionReadOnly)q1, (QuaternionReadOnly)q2);
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)diff, (EuclidGeometry)expected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testMultiply() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics qOther1 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qOther2 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qActual = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
            qActual.set((QuaternionReadOnly)qOther1);
            qExpected.set((QuaternionReadOnly)qOther1);
            qActual.multiply((QuaternionReadOnly)qOther2);
            QuaternionTools.multiply((QuaternionReadOnly)qExpected, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
            qActual.multiply((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2);
            QuaternionTools.multiply((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testMultiplyConjugate() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics qOther1 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qOther2 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qActual = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
            qExpected.set((QuaternionReadOnly)qOther1);
            qExpected.conjugate();
            qExpected.multiply((QuaternionReadOnly)qOther2);
            qActual.set((QuaternionReadOnly)qOther1);
            qActual.multiplyConjugateThis((QuaternionReadOnly)qOther2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
            qExpected.set((QuaternionReadOnly)qOther1);
            QuaternionBasics qOther2Conjugated = (QuaternionBasics)this.createEmptyTuple();
            qOther2Conjugated.setAndConjugate((QuaternionReadOnly)qOther2);
            qExpected.multiply((QuaternionReadOnly)qOther2Conjugated);
            qActual.set((QuaternionReadOnly)qOther1);
            qActual.multiplyConjugateOther((QuaternionReadOnly)qOther2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        QuaternionBasics original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasics expected = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics actual = (QuaternionBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics yawRotation = (QuaternionBasics)this.createEmptyTuple();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawRotation.setToYawOrientation(yaw);
            QuaternionTools.multiply((QuaternionReadOnly)original, (QuaternionReadOnly)yawRotation, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics pitchRotation = (QuaternionBasics)this.createEmptyTuple();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchRotation.setToPitchOrientation(pitch);
            QuaternionTools.multiply((QuaternionReadOnly)original, (QuaternionReadOnly)pitchRotation, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics rollRotation = (QuaternionBasics)this.createEmptyTuple();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollRotation.setToRollOrientation(roll);
            QuaternionTools.multiply((QuaternionReadOnly)original, (QuaternionReadOnly)rollRotation, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        QuaternionBasics original;
        int i;
        Random random = new Random(35454L);
        QuaternionBasics expected = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics actual = (QuaternionBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics yawRotation = (QuaternionBasics)this.createEmptyTuple();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawRotation.setToYawOrientation(yaw);
            QuaternionTools.multiply((QuaternionReadOnly)yawRotation, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics pitchRotation = (QuaternionBasics)this.createEmptyTuple();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchRotation.setToPitchOrientation(pitch);
            QuaternionTools.multiply((QuaternionReadOnly)pitchRotation, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics rollRotation = (QuaternionBasics)this.createEmptyTuple();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollRotation.setToRollOrientation(roll);
            QuaternionTools.multiply((QuaternionReadOnly)rollRotation, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPreMultiply() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics qOther1 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qOther2 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qActual = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
            qActual.set((QuaternionReadOnly)qOther1);
            qExpected.set((QuaternionReadOnly)qOther1);
            qActual.preMultiply((QuaternionReadOnly)qOther2);
            QuaternionTools.multiply((QuaternionReadOnly)qOther2, (QuaternionReadOnly)qExpected, (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPreMultiplyConjugate() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            QuaternionBasics qOther1 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qOther2 = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qActual = (QuaternionBasics)this.createRandomTuple(random);
            QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
            qExpected.set((QuaternionReadOnly)qOther1);
            qExpected.conjugate();
            qExpected.preMultiply((QuaternionReadOnly)qOther2);
            qActual.set((QuaternionReadOnly)qOther1);
            qActual.preMultiplyConjugateThis((QuaternionReadOnly)qOther2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
            qExpected.set((QuaternionReadOnly)qOther1);
            QuaternionBasics qOther2Conjugated = (QuaternionBasics)this.createEmptyTuple();
            qOther2Conjugated.setAndConjugate((QuaternionReadOnly)qOther2);
            qExpected.preMultiply((QuaternionReadOnly)qOther2Conjugated);
            qActual.set((QuaternionReadOnly)qOther1);
            qActual.preMultiplyConjugateOther((QuaternionReadOnly)qOther2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qActual, (EuclidGeometry)qExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        double alpha;
        int i;
        Random random = new Random(723459L);
        QuaternionBasics q0 = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics qf = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics qActual = (QuaternionBasics)this.createEmptyTuple();
        QuaternionBasics qExpected = (QuaternionBasics)this.createEmptyTuple();
        double epsilon = 10.0 * this.getEpsilon();
        for (i = 0; i < 1000; ++i) {
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            qActual.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha);
            qExpected.setToZero();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)q0);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)qf);
            qActual.set((QuaternionReadOnly)q0);
            qActual.interpolate((QuaternionReadOnly)qf, alpha);
            qExpected.setToZero();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)q0);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)qf);
        }
        for (i = 0; i < 1000; ++i) {
            q0 = (QuaternionBasics)this.createRandomTuple(random);
            qf.set((QuaternionReadOnly)q0);
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            qActual.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha);
            qExpected.set((QuaternionReadOnly)q0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
            qActual.set((QuaternionReadOnly)q0);
            qActual.interpolate((QuaternionReadOnly)qf, alpha);
            qExpected.set((QuaternionReadOnly)q0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            double angle0 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double anglef = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle0, (QuaternionBasics)q0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)anglef, (QuaternionBasics)qf);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double angleInterpolated = (1.0 - alpha2) * angle0 + alpha2 * anglef;
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angleInterpolated, (QuaternionBasics)qExpected);
            qActual.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
            qActual.set((QuaternionReadOnly)q0);
            qActual.interpolate((QuaternionReadOnly)qf, alpha2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            q0 = (QuaternionBasics)this.createRandomTuple(random);
            qf = (QuaternionBasics)this.createRandomTuple(random);
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            qExpected.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha);
            qActual.interpolate((QuaternionReadOnly)qf, (QuaternionReadOnly)q0, 1.0 - alpha);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qExpected, (Orientation3DReadOnly)qActual, (double)epsilon);
            qActual.set((QuaternionReadOnly)qf);
            qActual.interpolate((QuaternionReadOnly)q0, 1.0 - alpha);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qExpected, (Orientation3DReadOnly)qActual, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            q0 = (QuaternionBasics)this.createRandomTuple(random);
            qf = (QuaternionBasics)this.createRandomTuple(random);
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Quaternion qDiff = new Quaternion();
            if (q0.dot((Tuple4DReadOnly)qf) < 0.0) {
                Quaternion qfCopy = new Quaternion((QuaternionReadOnly)qf);
                qfCopy.negate();
                qDiff.difference((QuaternionReadOnly)q0, (QuaternionReadOnly)qfCopy);
            } else {
                qDiff.difference((QuaternionReadOnly)q0, (QuaternionReadOnly)qf);
            }
            AxisAngle axisAngleDiff = new AxisAngle((Orientation3DReadOnly)qDiff);
            axisAngleDiff.setAngle(axisAngleDiff.getAngle() * alpha);
            qDiff.set((Orientation3DReadOnly)axisAngleDiff);
            qExpected.multiply((QuaternionReadOnly)q0, (QuaternionReadOnly)qDiff);
            qActual.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qExpected, (Orientation3DReadOnly)qActual, (double)epsilon);
            qActual.set((QuaternionReadOnly)q0);
            qActual.interpolate((QuaternionReadOnly)qf, alpha);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qExpected, (Orientation3DReadOnly)qActual, (double)epsilon);
        }
    }

    @Test
    public void testApplyTransform() {
        QuaternionBasics actual;
        QuaternionBasics expected;
        QuaternionBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            expected.prepend((Orientation3DReadOnly)transform.getRotation());
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            expected.preMultiply((QuaternionReadOnly)transform.getRotation());
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            expected.prepend((Orientation3DReadOnly)transform.getLinearTransform().getAsQuaternion());
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyInverseTransform() {
        QuaternionBasics actual;
        QuaternionBasics expected;
        QuaternionBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (QuaternionBasics)this.createRandomTuple(random);
            expected = (QuaternionBasics)this.createEmptyTuple();
            actual = (QuaternionBasics)this.createEmptyTuple();
            expected.set((QuaternionReadOnly)original);
            actual.set((QuaternionReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Quaternion quaternionT;
        AxisAngle aa;
        double angleDiff;
        double epsilon;
        QuaternionBasics quaternionB;
        QuaternionBasics quaternionA;
        int i;
        Quaternion quaternionC = new Quaternion();
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            quaternionB = (QuaternionBasics)this.createRandomTuple(random);
            quaternionC.difference((QuaternionReadOnly)quaternionA, (QuaternionReadOnly)quaternionB);
            double angle = quaternionC.angle();
            angle = EuclidCoreTools.trimAngleMinusPiToPi((double)angle);
            if (Math.abs(angle) <= this.getEpsilon()) {
                Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0, (double)1000.0) * this.getEpsilon();
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternionT = new Quaternion((Orientation3DReadOnly)aa);
            quaternionT.preMultiply((QuaternionReadOnly)quaternionA);
            quaternionB = (QuaternionBasics)this.createTuple(quaternionT.getX(), quaternionT.getY(), quaternionT.getZ(), quaternionT.getS());
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            quaternionB.negate();
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionA, 0.0));
            Assertions.assertTrue((boolean)quaternionB.geometricallyEquals((EuclidGeometry)quaternionB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0, (double)1000.0) * this.getEpsilon();
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternionT = new Quaternion((Orientation3DReadOnly)aa);
            quaternionT.preMultiply((QuaternionReadOnly)quaternionA);
            quaternionB = (QuaternionBasics)this.createTuple(quaternionT.getX(), quaternionT.getY(), quaternionT.getZ(), quaternionT.getS());
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            quaternionB.negate();
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionA, 0.0));
            Assertions.assertTrue((boolean)quaternionB.geometricallyEquals((EuclidGeometry)quaternionB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2));
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternionT = new Quaternion((Orientation3DReadOnly)aa);
            quaternionT.preMultiply((QuaternionReadOnly)quaternionA);
            quaternionB = (QuaternionBasics)this.createTuple(quaternionT.getX(), quaternionT.getY(), quaternionT.getZ(), quaternionT.getS());
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            quaternionB.negate();
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionA, 0.0));
            Assertions.assertTrue((boolean)quaternionB.geometricallyEquals((EuclidGeometry)quaternionB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)3.079992797637052);
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            quaternionT = new Quaternion((Orientation3DReadOnly)aa);
            quaternionT.preMultiply((QuaternionReadOnly)quaternionA);
            quaternionB = (QuaternionBasics)this.createTuple(quaternionT.getX(), quaternionT.getY(), quaternionT.getZ(), quaternionT.getS());
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            quaternionB.negate();
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionA, 0.0));
            Assertions.assertTrue((boolean)quaternionB.geometricallyEquals((EuclidGeometry)quaternionB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI, (double)(Math.PI * 2));
            quaternionA = (QuaternionBasics)this.createRandomTuple(random);
            quaternionB = (QuaternionBasics)this.createRandomTuple(random);
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
            quaternionB.negate();
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals((EuclidGeometry)quaternionB, epsilon), (String)("Epsilon = " + epsilon));
        }
    }

    @Test
    public void testOrientation3DBasicsFeatures() throws Throwable {
        Orientation3DBasicsTest test = new Orientation3DBasicsTest(){

            @Override
            public Orientation3DBasics createEmptyOrientation3DBasics() {
                return (Orientation3DBasics)QuaternionBasicsTest.this.createEmptyTuple();
            }

            @Override
            public double getEpsilon() {
                return QuaternionBasicsTest.this.getEpsilon();
            }
        };
        for (Method testMethod : test.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            try {
                testMethod.invoke((Object)test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

