/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3DTroublesomeDatasetLibrary;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.ConvexPolytope3DTroublesomeDataset;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.convexPolytope.tools.IcoSphereFactory;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class ConvexPolytope3DTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstrustingAPolytope() {
        Random random = new Random(4533543L);
        ConvexPolytope3D polytope = new ConvexPolytope3D();
        Assertions.assertEquals((int)0, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)0, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)0, (int)polytope.getNumberOfFaces());
        ArrayList<Point3D> pointsAdded = new ArrayList<Point3D>();
        Point3D firstVertex = EuclidCoreRandomTools.nextPoint3D((Random)random);
        polytope.addVertex((Point3DReadOnly)firstVertex);
        pointsAdded.add(firstVertex);
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)firstVertex, (EuclidGeometry)polytope.getCentroid(), (double)1.0E-12);
        for (int vertexIndex = 0; vertexIndex < pointsAdded.size(); ++vertexIndex) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)pointsAdded.get(vertexIndex)), (EuclidGeometry)polytope.getVertex(vertexIndex), (double)1.0E-12);
        }
        polytope.addVertex((Point3DReadOnly)firstVertex);
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        Point3D secondVertex = EuclidCoreRandomTools.nextPoint3D((Random)random);
        polytope.addVertex((Point3DReadOnly)secondVertex);
        pointsAdded.add(secondVertex);
        Assertions.assertEquals((int)2, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)2, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)EuclidGeometryTools.averagePoint3Ds(pointsAdded), (EuclidGeometry)polytope.getCentroid(), (double)1.0E-12);
        for (int vertexIndex = 0; vertexIndex < pointsAdded.size(); ++vertexIndex) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)pointsAdded.get(vertexIndex)), (EuclidGeometry)polytope.getVertex(vertexIndex), (double)1.0E-12);
        }
        for (int i = 0; i < 1000; ++i) {
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, pointsAdded);
            polytope.addVertex((Point3DReadOnly)pointInside);
            Assertions.assertEquals((int)2, (int)polytope.getNumberOfVertices());
            Assertions.assertEquals((int)2, (int)polytope.getNumberOfEdges());
            Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        }
        Point3D thirdVertex = EuclidCoreRandomTools.nextPoint3D((Random)random);
        polytope.addVertex((Point3DReadOnly)thirdVertex);
        pointsAdded.add(thirdVertex);
        Assertions.assertEquals((int)3, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)3, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        Point3D expectedCentroid = EuclidGeometryTools.averagePoint3Ds(pointsAdded);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)polytope.getCentroid(), (double)1.0E-12);
        for (int vertexIndex = 0; vertexIndex < pointsAdded.size(); ++vertexIndex) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)pointsAdded.get(vertexIndex)), (EuclidGeometry)polytope.getVertex(vertexIndex), (double)1.0E-12);
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)((Face3D)polytope.getFace(0)).getCentroid(), (double)1.0E-12);
        Vector3D expectedNormal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstVertex, (Point3DReadOnly)secondVertex, (Point3DReadOnly)thirdVertex);
        if (expectedNormal.dot((Tuple3DReadOnly)((Face3D)polytope.getFace(0)).getNormal()) < 0.0) {
            expectedNormal.negate();
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)((Face3D)polytope.getFace(0)).getNormal(), (double)1.0E-12);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, pointsAdded);
            polytope.addVertex((Point3DReadOnly)pointInside);
            Assertions.assertEquals((int)3, (int)polytope.getNumberOfVertices());
            Assertions.assertEquals((int)3, (int)polytope.getNumberOfEdges());
            Assertions.assertEquals((int)1, (int)polytope.getNumberOfFaces());
        }
        Point3D fourthVertex = EuclidCoreRandomTools.nextPoint3D((Random)random);
        polytope.addVertex((Point3DReadOnly)fourthVertex);
        pointsAdded.add(fourthVertex);
        Assertions.assertEquals((int)4, (int)polytope.getNumberOfVertices());
        Assertions.assertEquals((int)6, (int)polytope.getNumberOfEdges());
        Assertions.assertEquals((int)4, (int)polytope.getNumberOfFaces());
        expectedCentroid = EuclidGeometryTools.averagePoint3Ds(pointsAdded);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)polytope.getCentroid(), (double)1.0E-12);
        for (int vertexIndex = 0; vertexIndex < polytope.getVertices().size(); ++vertexIndex) {
            Vertex3D vertex = (Vertex3D)polytope.getVertex(vertexIndex);
            Assertions.assertTrue((boolean)polytope.getVertices().stream().noneMatch(otherVertex -> otherVertex != vertex && otherVertex.epsilonEquals((EuclidGeometry)vertex, 1.0E-12)));
            Assertions.assertTrue((boolean)pointsAdded.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)vertex, 1.0E-12)));
            for (HalfEdge3D edge : vertex.getAssociatedEdges()) {
                Assertions.assertTrue((edge.getOrigin() == vertex ? 1 : 0) != 0);
            }
        }
        for (int edgeIndex = 0; edgeIndex < polytope.getHalfEdges().size(); ++edgeIndex) {
            HalfEdge3D edge = (HalfEdge3D)polytope.getHalfEdge(edgeIndex);
            Assertions.assertTrue((boolean)polytope.getHalfEdges().stream().noneMatch(otherEdge -> otherEdge != edge && otherEdge.epsilonEquals((EuclidGeometry)edge, 1.0E-12)));
            Assertions.assertTrue((boolean)pointsAdded.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)edge.getOrigin(), 1.0E-12)));
            Assertions.assertTrue((boolean)pointsAdded.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)edge.getDestination(), 1.0E-12)));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getOrigin(), (EuclidGeometry)((HalfEdge3D)edge.getTwin()).getDestination(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getDestination(), (EuclidGeometry)((HalfEdge3D)edge.getTwin()).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getOrigin(), (EuclidGeometry)((HalfEdge3D)edge.getPrevious()).getDestination(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getDestination(), (EuclidGeometry)((HalfEdge3D)edge.getNext()).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getOrigin(), (EuclidGeometry)((HalfEdge3D)((HalfEdge3D)edge.getPrevious()).getTwin()).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getDestination(), (EuclidGeometry)((HalfEdge3D)((HalfEdge3D)edge.getNext()).getTwin()).getDestination(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getOrigin(), (EuclidGeometry)((HalfEdge3D)((HalfEdge3D)edge.getTwin()).getNext()).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)edge.getDestination(), (EuclidGeometry)((HalfEdge3D)((HalfEdge3D)edge.getTwin()).getPrevious()).getDestination(), (double)1.0E-12);
            Assertions.assertTrue((((HalfEdge3D)edge.getTwin()).getTwin() == edge ? 1 : 0) != 0);
            Assertions.assertTrue((((HalfEdge3D)edge.getNext()).getPrevious() == edge ? 1 : 0) != 0);
            Assertions.assertTrue((((HalfEdge3D)edge.getPrevious()).getNext() == edge ? 1 : 0) != 0);
        }
        for (int faceIndex = 0; faceIndex < polytope.getFaces().size(); ++faceIndex) {
            Face3D face = (Face3D)polytope.getFace(faceIndex);
            Assertions.assertTrue((boolean)polytope.getFaces().stream().noneMatch(otherFace -> otherFace != face && otherFace.epsilonEquals((EuclidGeometry)face, 1.0E-12)));
            for (HalfEdge3D edge : face.getEdges()) {
                Assertions.assertTrue((boolean)pointsAdded.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)edge.getOrigin(), 1.0E-12)));
                Assertions.assertTrue((boolean)pointsAdded.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)edge.getDestination(), 1.0E-12)));
            }
        }
        for (int i = 0; i < 1000; ++i) {
            Point3D pointInside = EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)firstVertex, (Point3DReadOnly)secondVertex, (Point3DReadOnly)thirdVertex, (Point3DReadOnly)fourthVertex);
            Assertions.assertTrue((boolean)polytope.isPointInside((Point3DReadOnly)pointInside, 1.0E-12));
            polytope.addVertex((Point3DReadOnly)pointInside);
            Assertions.assertEquals((int)4, (int)polytope.getNumberOfVertices());
            Assertions.assertEquals((int)6, (int)polytope.getNumberOfEdges());
            Assertions.assertEquals((int)4, (int)polytope.getNumberOfFaces());
        }
    }

    @Test
    void testConstructingTetrahedron() throws Exception {
        Vector3D sideXMinusNormal;
        Random random = new Random(34636L);
        Point3D top = new Point3D(0.0, 0.0, 1.0);
        Point3D bottomP0 = new Point3D(-0.5, -0.5, 0.0);
        Point3D bottomP1 = new Point3D(0.5, -0.5, 0.0);
        Point3D bottomP2 = new Point3D(0.0, 0.5, 0.0);
        ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP0);
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP1);
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP2);
        convexPolytope3D.addVertex((Point3DReadOnly)top);
        Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(top));
        Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP0));
        Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP1));
        Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP2));
        Assertions.assertEquals((int)4, (int)convexPolytope3D.getNumberOfVertices());
        Assertions.assertEquals((int)6, (int)convexPolytope3D.getNumberOfEdges());
        Assertions.assertEquals((int)4, (int)convexPolytope3D.getNumberOfFaces());
        Vector3D bottomNormal = new Vector3D(0.0, 0.0, -1.0);
        Vector3D sideYMinusNormal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)top, (Point3DReadOnly)bottomP0, (Point3DReadOnly)bottomP1);
        if (sideYMinusNormal.getY() > 0.0) {
            sideYMinusNormal.negate();
        }
        if ((sideXMinusNormal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)top, (Point3DReadOnly)bottomP0, (Point3DReadOnly)bottomP2)).getX() > 0.0) {
            sideXMinusNormal.negate();
        }
        Vector3D sideXPlusNormal = new Vector3D((Tuple3DReadOnly)sideXMinusNormal);
        sideXPlusNormal.setX(-sideXPlusNormal.getX());
        for (int faceIndex = 0; faceIndex < 4; ++faceIndex) {
            Face3D face = (Face3D)convexPolytope3D.getFace(faceIndex);
            Vector3D normal = face.getNormal();
            if (normal.epsilonEquals((EuclidGeometry)bottomNormal, 1.0E-12)) {
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP0));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP1));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP2));
                continue;
            }
            if (normal.epsilonEquals((EuclidGeometry)sideYMinusNormal, 1.0E-12)) {
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(top));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP0));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP1));
                continue;
            }
            if (normal.epsilonEquals((EuclidGeometry)sideXMinusNormal, 1.0E-12)) {
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(top));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP0));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP2));
                continue;
            }
            if (normal.epsilonEquals((EuclidGeometry)sideXPlusNormal, 1.0E-12)) {
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(top));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP0));
                Assertions.assertTrue((boolean)convexPolytope3D.getVertices().contains(bottomP1));
                continue;
            }
            Assertions.fail((String)("Unexpected face normal: " + (Vector3DBasics)normal));
        }
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Point3D> vertices = new ArrayList<Point3D>();
            vertices.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            vertices.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            vertices.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            vertices.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            ConvexPolytope3D convexPolytope3D2 = new ConvexPolytope3D();
            vertices.forEach(vertex -> convexPolytope3D2.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)4, (int)convexPolytope3D2.getNumberOfVertices());
            Assertions.assertEquals((int)6, (int)convexPolytope3D2.getNumberOfEdges());
            Assertions.assertEquals((int)4, (int)convexPolytope3D2.getNumberOfFaces());
            HalfEdge3D edge = (HalfEdge3D)convexPolytope3D2.getHalfEdge(random.nextInt(convexPolytope3D2.getNumberOfEdges()));
            Point3DBasics newVertex = edge.pointOnLineGivenPercentage(1.0 + random.nextDouble());
            Vertex3D expectedVertexRemoved = (Vertex3D)edge.getDestination();
            convexPolytope3D2.addVertex((Point3DReadOnly)newVertex);
            String errorMessage = "Iteration: " + i;
            Assertions.assertEquals((int)4, (int)convexPolytope3D2.getNumberOfVertices(), (String)errorMessage);
            Assertions.assertEquals((int)6, (int)convexPolytope3D2.getNumberOfEdges(), (String)errorMessage);
            Assertions.assertEquals((int)4, (int)convexPolytope3D2.getNumberOfFaces(), (String)errorMessage);
            Assertions.assertTrue((boolean)convexPolytope3D2.getVertices().stream().anyMatch(vertex -> vertex.epsilonEquals((EuclidGeometry)newVertex, 1.0E-12)), (String)errorMessage);
            Assertions.assertFalse((boolean)convexPolytope3D2.getVertices().contains(expectedVertexRemoved), (String)errorMessage);
        }
    }

    @Test
    void testConstructingCube() throws Exception {
        Random random = new Random(5464566L);
        for (int i = 0; i < 1000; ++i) {
            Point3D bottomP0 = new Point3D(-0.5, -0.5, 0.0);
            Point3D bottomP1 = new Point3D(-0.5, 0.5, 0.0);
            Point3D bottomP2 = new Point3D(0.5, 0.5, 0.0);
            Point3D bottomP3 = new Point3D(0.5, -0.5, 0.0);
            Point3D topP0 = new Point3D(-0.5, -0.5, 1.0);
            Point3D topP1 = new Point3D(-0.5, 0.5, 1.0);
            Point3D topP2 = new Point3D(0.5, 0.5, 1.0);
            Point3D topP3 = new Point3D(0.5, -0.5, 1.0);
            Vector3D bottomNormal = new Vector3D(0.0, 0.0, -1.0);
            Vector3D topNormal = new Vector3D(0.0, 0.0, 1.0);
            Vector3D xPlusSideNormal = new Vector3D(1.0, 0.0, 0.0);
            Vector3D xMinusSideNormal = new Vector3D(-1.0, 0.0, 0.0);
            Vector3D yPlusSideNormal = new Vector3D(0.0, 1.0, 0.0);
            Vector3D yMinusSideNormal = new Vector3D(0.0, -1.0, 0.0);
            Point3D bottomCenter = new Point3D(0.0, 0.0, 0.0);
            Point3D topCenter = new Point3D(0.0, 0.0, 1.0);
            Point3D xPlusSideCenter = new Point3D(0.5, 0.0, 0.5);
            Point3D xMinusSideCenter = new Point3D(-0.5, 0.0, 0.5);
            Point3D yPlusSideCenter = new Point3D(0.0, 0.5, 0.5);
            Point3D yMinusSideCenter = new Point3D(0.0, -0.5, 0.5);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(bottomP0, bottomP1, bottomP2, bottomP3, topP0, topP1, topP2, topP3, bottomNormal, topNormal, xPlusSideNormal, xMinusSideNormal, yPlusSideNormal, yMinusSideNormal, bottomCenter, topCenter, xPlusSideCenter, xMinusSideCenter, yPlusSideCenter, yMinusSideCenter).forEach(o -> o.applyTransform((Transform)transform));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            convexPolytope3D.addVertex((Point3DReadOnly)bottomP0);
            convexPolytope3D.addVertex((Point3DReadOnly)bottomP1);
            convexPolytope3D.addVertex((Point3DReadOnly)bottomP2);
            convexPolytope3D.addVertex((Point3DReadOnly)bottomP3);
            convexPolytope3D.addVertex((Point3DReadOnly)topP0);
            convexPolytope3D.addVertex((Point3DReadOnly)topP1);
            convexPolytope3D.addVertex((Point3DReadOnly)topP2);
            convexPolytope3D.addVertex((Point3DReadOnly)topP3);
            Assertions.assertEquals((int)6, (int)convexPolytope3D.getNumberOfFaces());
            Assertions.assertEquals((int)8, (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)12, (int)convexPolytope3D.getNumberOfEdges());
            List allFaces = convexPolytope3D.getFaces();
            allFaces.forEach(face -> Assertions.assertEquals((int)4, (int)face.getNumberOfEdges()));
            Face3D bottomFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)bottomNormal, 1.0E-12)).findFirst().get();
            Face3D topFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)topNormal, 1.0E-12)).findFirst().get();
            Face3D xPlusSideFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)xPlusSideNormal, 1.0E-12)).findFirst().get();
            Face3D xMinusSideFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)xMinusSideNormal, 1.0E-12)).findFirst().get();
            Face3D yPlusSideFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)yPlusSideNormal, 1.0E-12)).findFirst().get();
            Face3D yMinusSideFace = allFaces.stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)yMinusSideNormal, 1.0E-12)).findFirst().get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomCenter, (EuclidGeometry)bottomFace.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)topCenter, (EuclidGeometry)topFace.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)xPlusSideCenter, (EuclidGeometry)xPlusSideFace.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)xMinusSideCenter, (EuclidGeometry)xMinusSideFace.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)yPlusSideCenter, (EuclidGeometry)yPlusSideFace.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)yMinusSideCenter, (EuclidGeometry)yMinusSideFace.getCentroid(), (double)1.0E-12);
            Assertions.assertTrue((boolean)bottomFace.getVertices().containsAll(Arrays.asList(bottomP0, bottomP1, bottomP2, bottomP3)));
            Assertions.assertTrue((boolean)topFace.getVertices().containsAll(Arrays.asList(topP0, topP1, topP2, topP3)));
            Assertions.assertTrue((boolean)xPlusSideFace.getVertices().containsAll(Arrays.asList(topP2, topP3, bottomP2, bottomP3)));
            Assertions.assertTrue((boolean)xMinusSideFace.getVertices().containsAll(Arrays.asList(topP0, topP1, bottomP0, bottomP1)));
            Assertions.assertTrue((boolean)yPlusSideFace.getVertices().containsAll(Arrays.asList(topP1, topP2, bottomP1, bottomP2)));
            Assertions.assertTrue((boolean)yMinusSideFace.getVertices().containsAll(Arrays.asList(topP0, topP3, bottomP0, bottomP3)));
            convexPolytope3D.getHalfEdges().forEach(edge -> Assertions.assertNotNull((Object)edge.getTwin()));
            convexPolytope3D.getHalfEdges().forEach(edge -> Assertions.assertNotNull((Object)edge.getNext()));
            convexPolytope3D.getHalfEdges().forEach(edge -> Assertions.assertNotNull((Object)edge.getPrevious()));
            convexPolytope3D.getVertices().forEach(vertex -> Assertions.assertEquals((int)3, (int)vertex.getNumberOfAssociatedEdges()));
        }
    }

    @Test
    void testConstructingIcosahedron() throws Exception {
        Vertex3D b1;
        Vertex3D a1;
        Vertex3D b0;
        Vertex3D a0;
        Vertex3D c;
        Vertex3D b;
        Vertex3D a;
        Vector3D normalDirectionGuess;
        ArrayList shuffledVertices;
        ConvexPolytope3D convexPolytope3D;
        int i;
        Random random = new Random(23423L);
        IcoSphereFactory.TriangleMesh3D icosahedron = IcoSphereFactory.newIcoSphere((int)0);
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = new ConvexPolytope3D();
            shuffledVertices = new ArrayList(icosahedron.getVertices());
            Collections.shuffle(shuffledVertices, random);
            shuffledVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)12, (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)30, (int)convexPolytope3D.getNumberOfEdges());
            Assertions.assertEquals((int)20, (int)convexPolytope3D.getNumberOfFaces());
            for (Vertex3DReadOnly vertex2 : convexPolytope3D.getVertices()) {
                Assertions.assertTrue((boolean)icosahedron.getVertices().stream().anyMatch(p -> p.epsilonEquals((EuclidGeometry)vertex2, 1.0E-12)));
            }
            for (Face3D face : convexPolytope3D.getFaces()) {
                Assertions.assertEquals((int)3, (int)face.getNumberOfEdges());
                normalDirectionGuess = new Vector3D();
                normalDirectionGuess.sub((Tuple3DReadOnly)face.getCentroid(), (Tuple3DReadOnly)convexPolytope3D.getCentroid());
                Assertions.assertTrue((normalDirectionGuess.dot((Tuple3DReadOnly)face.getNormal()) > 0.0 ? 1 : 0) != 0);
                a = (Vertex3D)face.getVertex(0);
                b = (Vertex3D)face.getVertex(1);
                c = (Vertex3D)face.getVertex(2);
                Assertions.assertTrue((boolean)icosahedron.getAllTriangles().stream().anyMatch(triangle -> triangle.geometricallyEquals((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, 1.0E-12)));
            }
            for (HalfEdge3D edge : convexPolytope3D.getHalfEdges()) {
                Assertions.assertNotNull((Object)edge.getTwin());
                a0 = (Vertex3D)edge.getOrigin();
                b0 = (Vertex3D)edge.getDestination();
                a1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getDestination();
                b1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getOrigin();
                Assertions.assertTrue((a0 == a1 ? 1 : 0) != 0);
                Assertions.assertTrue((b0 == b1 ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)((Vertex3D)edge.getOrigin()).getAssociatedEdges().contains(edge));
            }
        }
        for (i = 0; i < 1000; ++i) {
            icosahedron = IcoSphereFactory.newIcoSphere((int)0);
            icosahedron.applyTransform((Transform)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            convexPolytope3D = new ConvexPolytope3D();
            shuffledVertices = new ArrayList(icosahedron.getVertices());
            Collections.shuffle(shuffledVertices, random);
            shuffledVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)12, (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)30, (int)convexPolytope3D.getNumberOfEdges());
            Assertions.assertEquals((int)20, (int)convexPolytope3D.getNumberOfFaces());
            for (Vertex3DReadOnly vertex2 : convexPolytope3D.getVertices()) {
                Assertions.assertTrue((boolean)icosahedron.getVertices().stream().anyMatch(p -> p.epsilonEquals((EuclidGeometry)vertex2, 1.0E-12)));
            }
            for (Face3D face : convexPolytope3D.getFaces()) {
                Assertions.assertEquals((int)3, (int)face.getNumberOfEdges());
                normalDirectionGuess = new Vector3D();
                normalDirectionGuess.sub((Tuple3DReadOnly)face.getCentroid(), (Tuple3DReadOnly)convexPolytope3D.getCentroid());
                Assertions.assertTrue((normalDirectionGuess.dot((Tuple3DReadOnly)face.getNormal()) > 0.0 ? 1 : 0) != 0);
                a = (Vertex3D)face.getVertex(0);
                b = (Vertex3D)face.getVertex(1);
                c = (Vertex3D)face.getVertex(2);
                Assertions.assertTrue((boolean)icosahedron.getAllTriangles().stream().anyMatch(triangle -> triangle.geometricallyEquals((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, 1.0E-12)));
            }
            for (HalfEdge3D edge : convexPolytope3D.getHalfEdges()) {
                Assertions.assertNotNull((Object)edge.getTwin());
                a0 = (Vertex3D)edge.getOrigin();
                b0 = (Vertex3D)edge.getDestination();
                a1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getDestination();
                b1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getOrigin();
                Assertions.assertTrue((a0 == a1 ? 1 : 0) != 0);
                Assertions.assertTrue((b0 == b1 ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)((Vertex3D)edge.getOrigin()).getAssociatedEdges().contains(edge));
            }
        }
    }

    @Test
    void testConstructingIcosphere() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 100; ++i) {
            IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)(random.nextInt(2) + 1));
            icoSphere.applyTransform((Transform)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            ArrayList shuffledVertices = new ArrayList(icoSphere.getVertices());
            Collections.shuffle(shuffledVertices, random);
            shuffledVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)icoSphere.getNumberOfVertices(), (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)(icoSphere.getNumberOfTriangles() * 3 / 2), (int)convexPolytope3D.getNumberOfEdges());
            Assertions.assertEquals((int)icoSphere.getNumberOfTriangles(), (int)convexPolytope3D.getNumberOfFaces());
            for (Vertex3DReadOnly vertex2 : convexPolytope3D.getVertices()) {
                Assertions.assertTrue((boolean)icoSphere.getVertices().stream().anyMatch(p -> p.epsilonEquals((EuclidGeometry)vertex2, 1.0E-12)));
            }
            for (Face3D face : convexPolytope3D.getFaces()) {
                Assertions.assertEquals((int)3, (int)face.getNumberOfEdges());
                Vector3D normalDirectionGuess = new Vector3D();
                normalDirectionGuess.sub((Tuple3DReadOnly)face.getCentroid(), (Tuple3DReadOnly)convexPolytope3D.getCentroid());
                Assertions.assertTrue((normalDirectionGuess.dot((Tuple3DReadOnly)face.getNormal()) > 0.0 ? 1 : 0) != 0);
                Vertex3D a = (Vertex3D)face.getVertex(0);
                Vertex3D b = (Vertex3D)face.getVertex(1);
                Vertex3D c = (Vertex3D)face.getVertex(2);
                Assertions.assertTrue((boolean)icoSphere.getAllTriangles().stream().anyMatch(triangle -> triangle.geometricallyEquals((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, 1.0E-12)));
            }
            for (HalfEdge3D edge : convexPolytope3D.getHalfEdges()) {
                Assertions.assertNotNull((Object)edge.getTwin());
                Vertex3D a0 = (Vertex3D)edge.getOrigin();
                Vertex3D b0 = (Vertex3D)edge.getDestination();
                Vertex3D a1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getDestination();
                Vertex3D b1 = (Vertex3D)((HalfEdge3D)edge.getTwin()).getOrigin();
                Assertions.assertTrue((a0 == a1 ? 1 : 0) != 0);
                Assertions.assertTrue((b0 == b1 ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)((Vertex3D)edge.getOrigin()).getAssociatedEdges().contains(edge));
            }
        }
    }

    @Test
    void testConstructingCone() throws Exception {
        ArrayList<Point3D> bottom;
        Point3D top;
        int i;
        Random random = new Random(435L);
        for (i = 0; i < 1000; ++i) {
            Object vertex22;
            top = new Point3D(0.0, 0.0, 1.0);
            bottom = new ArrayList<Point3D>();
            int bottomSize = 10;
            double deltaTheta = Math.PI * 2 / (double)bottomSize;
            for (double theta = 0.0; theta < Math.PI * 2; theta += deltaTheta) {
                bottom.add(new Point3D(EuclidCoreTools.cos((double)theta), EuclidCoreTools.sin((double)theta), 0.0));
            }
            Assertions.assertEquals((int)bottomSize, (int)bottom.size());
            ArrayList<Point3D> allVertices = new ArrayList<Point3D>(bottom);
            allVertices.add(top);
            Collections.shuffle(allVertices, random);
            Vector3D bottomNormal = new Vector3D(0.0, 0.0, -1.0);
            Point3D bottomCentroid = new Point3D(0.0, 0.0, 0.0);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            allVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            bottomNormal.applyTransform((Transform)transform);
            bottomCentroid.applyTransform((Transform)transform);
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            allVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)allVertices.size(), (int)convexPolytope3D.getNumberOfVertices());
            Optional<Face3D> searchResult = convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == bottomSize).findFirst();
            Assertions.assertTrue((boolean)searchResult.isPresent());
            Face3D bottomFace = searchResult.get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomNormal, (EuclidGeometry)bottomFace.getNormal(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomCentroid, (EuclidGeometry)bottomFace.getCentroid(), (double)1.0E-12);
            for (Object vertex22 : bottomFace.getVertices()) {
                Assertions.assertTrue((boolean)bottom.stream().anyMatch(arg_0 -> ConvexPolytope3DTest.lambda$testConstructingCone$33((Vertex3D)vertex22, arg_0)));
            }
            List sideFaces = convexPolytope3D.getFaces().stream().filter(face -> face != bottomFace).collect(Collectors.toList());
            vertex22 = sideFaces.iterator();
            while (vertex22.hasNext()) {
                Face3D sideFace = (Face3D)vertex22.next();
                Assertions.assertEquals((int)3, (int)sideFace.getNumberOfEdges());
                Assertions.assertTrue((boolean)sideFace.getVertices().stream().anyMatch(vertex -> vertex.epsilonEquals((EuclidGeometry)top, 1.0E-12)));
            }
        }
        for (i = 0; i < 1000; ++i) {
            Object vertex32;
            top = new Point3D(0.0, 0.0, 1.0);
            bottom = new ArrayList();
            ArrayList<Point3D> intermediate = new ArrayList<Point3D>();
            int bottomSize = 10;
            double deltaTheta = Math.PI * 2 / (double)bottomSize;
            double bottomRadius = 1.0;
            double intermediateZ = 0.5;
            double intermediateRadius = bottomRadius * (top.getZ() - intermediateZ) / top.getZ();
            for (double theta = 0.0; theta < Math.PI * 2; theta += deltaTheta) {
                bottom.add(new Point3D(bottomRadius * EuclidCoreTools.cos((double)theta), bottomRadius * EuclidCoreTools.sin((double)theta), 0.0));
                intermediate.add(new Point3D(intermediateRadius * EuclidCoreTools.cos((double)theta), intermediateRadius * EuclidCoreTools.sin((double)theta), intermediateZ));
            }
            Assertions.assertEquals((int)bottomSize, (int)bottom.size());
            ArrayList<Point3D> truncatedConeVertices = new ArrayList<Point3D>();
            truncatedConeVertices.addAll(bottom);
            truncatedConeVertices.addAll(intermediate);
            Collections.shuffle(intermediate, random);
            Vector3D bottomNormal = new Vector3D(0.0, 0.0, -1.0);
            Point3D bottomCentroid = new Point3D(0.0, 0.0, 0.0);
            Vector3D intermediateNormal = new Vector3D(0.0, 0.0, 1.0);
            Point3D intermediateCentroid = new Point3D(0.0, 0.0, intermediateZ);
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            truncatedConeVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)truncatedConeVertices.size(), (int)convexPolytope3D.getNumberOfVertices());
            Optional<Face3D> searchResult = convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == bottomSize).filter(face -> EuclidCoreTools.epsilonEquals((double)0.0, (double)((Vertex3D)face.getVertex(0)).getZ(), (double)1.0E-12)).findFirst();
            Assertions.assertTrue((boolean)searchResult.isPresent());
            Face3D bottomFace = searchResult.get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomNormal, (EuclidGeometry)bottomFace.getNormal(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomCentroid, (EuclidGeometry)bottomFace.getCentroid(), (double)1.0E-12);
            for (Object vertex32 : bottomFace.getVertices()) {
                Assertions.assertTrue((boolean)bottom.stream().anyMatch(arg_0 -> ConvexPolytope3DTest.lambda$testConstructingCone$39((Vertex3D)vertex32, arg_0)));
            }
            searchResult = convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == bottomSize).filter(face -> EuclidCoreTools.epsilonEquals((double)intermediateZ, (double)((Vertex3D)face.getVertex(0)).getZ(), (double)1.0E-12)).findFirst();
            Assertions.assertTrue((boolean)searchResult.isPresent());
            Face3D intermediateFace = searchResult.get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)intermediateNormal, (EuclidGeometry)intermediateFace.getNormal(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)intermediateCentroid, (EuclidGeometry)intermediateFace.getCentroid(), (double)1.0E-12);
            vertex32 = intermediateFace.getVertices().iterator();
            while (vertex32.hasNext()) {
                Vertex3D vertex4 = (Vertex3D)vertex32.next();
                Assertions.assertTrue((boolean)intermediate.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)vertex4, 1.0E-12)));
            }
            List sideFaces = convexPolytope3D.getFaces().stream().filter(face -> face != bottomFace).filter(face -> face != intermediateFace).collect(Collectors.toList());
            for (Face3D sideFace : sideFaces) {
                Assertions.assertEquals((int)4, (int)sideFace.getNumberOfEdges());
                Assertions.assertEquals((long)2L, (long)sideFace.getVertices().stream().filter(v -> EuclidCoreTools.epsilonEquals((double)0.0, (double)v.getZ(), (double)1.0E-12)).count());
                Assertions.assertEquals((long)2L, (long)sideFace.getVertices().stream().filter(v -> EuclidCoreTools.epsilonEquals((double)intermediateZ, (double)v.getZ(), (double)1.0E-12)).count());
            }
            convexPolytope3D.addVertex((Point3DReadOnly)top);
            Assertions.assertEquals((int)(bottomSize + 1), (int)convexPolytope3D.getNumberOfVertices());
        }
    }

    @Test
    void testConstructingCylinder() throws Exception {
        Random random = new Random(34L);
        for (int i = 0; i < 1000; ++i) {
            List vertices;
            Object sideFace2;
            Object vertex22;
            double topZ = 1.0;
            ArrayList<Point3D> bottom = new ArrayList<Point3D>();
            int bottomSize = 10;
            double deltaTheta = Math.PI * 2 / (double)bottomSize;
            for (double theta = 0.0; theta < Math.PI * 2; theta += deltaTheta) {
                bottom.add(new Point3D(EuclidCoreTools.cos((double)theta), EuclidCoreTools.sin((double)theta), 0.0));
            }
            Assertions.assertEquals((int)bottomSize, (int)bottom.size());
            List top = bottom.stream().map(Point3D::new).peek(p -> p.setZ(topZ)).collect(Collectors.toList());
            ArrayList<Object> allVertices = new ArrayList<Object>();
            allVertices.addAll(top);
            allVertices.addAll(bottom);
            Collections.shuffle(allVertices, random);
            Vector3D bottomNormal = new Vector3D(0.0, 0.0, -1.0);
            Point3D bottomCentroid = new Point3D(0.0, 0.0, 0.0);
            Vector3D topNormal = new Vector3D(0.0, 0.0, 1.0);
            Point3D topCentroid = new Point3D(0.0, 0.0, topZ);
            double extensionZ = 0.3;
            Point3D aboveTop = new Point3D(0.0, 0.0, topZ + extensionZ);
            Point3D belowBottom = new Point3D(0.0, 0.0, -extensionZ);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            allVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            Arrays.asList(bottomNormal, bottomCentroid, topNormal, topCentroid, aboveTop, belowBottom).forEach(o -> o.applyTransform((Transform)transform));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            allVertices.forEach(vertex -> convexPolytope3D.addVertex((Point3DReadOnly)vertex));
            Assertions.assertEquals((int)allVertices.size(), (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)(bottomSize + 2), (int)convexPolytope3D.getNumberOfFaces());
            Optional<Face3D> searchResult = convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == bottomSize).filter(face -> face.getCentroid().epsilonEquals((EuclidGeometry)bottomCentroid, 1.0E-12)).findFirst();
            Assertions.assertTrue((boolean)searchResult.isPresent());
            Face3D bottomFace = searchResult.get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bottomNormal, (EuclidGeometry)bottomFace.getNormal(), (double)1.0E-12);
            for (Object vertex22 : bottomFace.getVertices()) {
                Assertions.assertTrue((boolean)bottom.stream().anyMatch(arg_0 -> ConvexPolytope3DTest.lambda$testConstructingCylinder$52((Vertex3D)vertex22, arg_0)));
            }
            searchResult = convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == bottomSize).filter(face -> face.getCentroid().epsilonEquals((EuclidGeometry)topCentroid, 1.0E-12)).findFirst();
            Assertions.assertTrue((boolean)searchResult.isPresent());
            Face3D topFace = searchResult.get();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)topNormal, (EuclidGeometry)topFace.getNormal(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)topCentroid, (EuclidGeometry)topFace.getCentroid(), (double)1.0E-12);
            vertex22 = topFace.getVertices().iterator();
            while (vertex22.hasNext()) {
                Vertex3D vertex3 = (Vertex3D)vertex22.next();
                Assertions.assertTrue((boolean)top.stream().anyMatch(point -> point.epsilonEquals((EuclidGeometry)vertex3, 1.0E-12)));
            }
            List sideFaces = convexPolytope3D.getFaces().stream().filter(face -> face != bottomFace).filter(face -> face != topFace).collect(Collectors.toList());
            for (Object sideFace2 : sideFaces) {
                Assertions.assertEquals((int)4, (int)sideFace2.getNumberOfEdges());
                List vertices2 = sideFace2.getVertices();
                Assertions.assertEquals((long)2L, (long)vertices2.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)0.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)bottomCentroid, (Point3DReadOnly)topCentroid), (double)1.0E-12)).count());
                Assertions.assertEquals((long)2L, (long)vertices2.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)1.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)bottomCentroid, (Point3DReadOnly)topCentroid), (double)1.0E-12)).count());
            }
            convexPolytope3D.addVertex((Point3DReadOnly)aboveTop);
            Assertions.assertEquals((int)(allVertices.size() + 1), (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)(2 * bottomSize + 1), (int)convexPolytope3D.getNumberOfFaces());
            Assertions.assertTrue((boolean)convexPolytope3D.getFaces().contains(bottomFace));
            Assertions.assertFalse((boolean)convexPolytope3D.getFaces().contains(topFace));
            Assertions.assertTrue((boolean)convexPolytope3D.getFaces().containsAll(sideFaces));
            List topConeFaces = convexPolytope3D.getFaces().stream().filter(face -> face != bottomFace && !sideFaces.contains(face)).collect(Collectors.toList());
            for (Face3D topConeFace : topConeFaces) {
                Assertions.assertEquals((int)3, (int)topConeFace.getNumberOfEdges());
                vertices = topConeFace.getVertices();
                Assertions.assertEquals((long)1L, (long)vertices.stream().filter(v -> aboveTop.epsilonEquals((EuclidGeometry)v, 1.0E-12)).count());
                Assertions.assertEquals((long)2L, (long)vertices.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)0.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)topCentroid, (Point3DReadOnly)aboveTop), (double)1.0E-12)).count());
            }
            sideFace2 = sideFaces.iterator();
            while (sideFace2.hasNext()) {
                Face3D sideFace3 = (Face3D)sideFace2.next();
                Assertions.assertEquals((int)4, (int)sideFace3.getNumberOfEdges());
                vertices = sideFace3.getVertices();
                Assertions.assertEquals((long)2L, (long)vertices.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)0.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)bottomCentroid, (Point3DReadOnly)topCentroid), (double)1.0E-12)).count());
                Assertions.assertEquals((long)2L, (long)vertices.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)1.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)bottomCentroid, (Point3DReadOnly)topCentroid), (double)1.0E-12)).count());
            }
            convexPolytope3D.addVertex((Point3DReadOnly)belowBottom);
            Assertions.assertEquals((int)(allVertices.size() + 2), (int)convexPolytope3D.getNumberOfVertices());
            Assertions.assertEquals((int)(3 * bottomSize), (int)convexPolytope3D.getNumberOfFaces());
            Assertions.assertFalse((boolean)convexPolytope3D.getFaces().contains(bottomFace));
            Assertions.assertFalse((boolean)convexPolytope3D.getFaces().contains(topFace));
            Assertions.assertTrue((boolean)convexPolytope3D.getFaces().containsAll(topConeFaces));
            Assertions.assertTrue((boolean)convexPolytope3D.getFaces().containsAll(sideFaces));
            List bottomConeFaces = convexPolytope3D.getFaces().stream().filter(face -> !topConeFaces.contains(face) && !sideFaces.contains(face)).collect(Collectors.toList());
            for (Face3D bottomConeFace : bottomConeFaces) {
                Assertions.assertEquals((int)3, (int)bottomConeFace.getNumberOfEdges());
                List vertices3 = bottomConeFace.getVertices();
                Assertions.assertEquals((long)1L, (long)vertices3.stream().filter(v -> belowBottom.epsilonEquals((EuclidGeometry)v, 1.0E-12)).count());
                Assertions.assertEquals((long)2L, (long)vertices3.stream().filter(v -> EuclidCoreTools.epsilonEquals((double)0.0, (double)EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)v, (Point3DReadOnly)bottomCentroid, (Point3DReadOnly)belowBottom), (double)1.0E-12)).count());
            }
            convexPolytope3D.getHalfEdges().forEach(edge -> Assertions.assertNotNull((Object)edge.getTwin()));
        }
    }

    @Test
    void testGetClosestFace() throws Exception {
        Random random = new Random(34656L);
        Point3D top = new Point3D(0.0, 0.0, 1.0);
        Point3D bottomP0 = new Point3D(-0.5, -0.5, 0.0);
        Point3D bottomP1 = new Point3D(0.5, -0.5, 0.0);
        Point3D bottomP2 = new Point3D(0.0, 0.5, 0.0);
        ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP0);
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP1);
        convexPolytope3D.addVertex((Point3DReadOnly)bottomP2);
        convexPolytope3D.addVertex((Point3DReadOnly)top);
        for (int i = 0; i < 1000; ++i) {
            for (int faceIndex = 0; faceIndex < 4; ++faceIndex) {
                Point3D pointOnFace;
                Face3D face = (Face3D)convexPolytope3D.getFace(faceIndex);
                Assertions.assertTrue((face == convexPolytope3D.getClosestFace((Point3DReadOnly)(pointOnFace = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face.getVertex(0), (Point3DReadOnly)face.getVertex(1), (Point3DReadOnly)face.getVertex(2)))) ? 1 : 0) != 0, (String)("Iteration " + i + ", face index: " + faceIndex));
                Point3D pointOutside = new Point3D();
                pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOnFace);
                Assertions.assertTrue((face == convexPolytope3D.getClosestFace((Point3DReadOnly)pointOutside) ? 1 : 0) != 0, (String)("Iteration " + i + ", face index: " + faceIndex));
            }
        }
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D2 = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            Point3D point = new Point3D();
            Face3D face = (Face3D)convexPolytope3D2.getFace(random.nextInt(convexPolytope3D2.getNumberOfFaces()));
            HalfEdge3D edge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            point.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D2.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination()));
            Face3D expectedClosestFace = (Face3D)convexPolytope3D2.getFaces().stream().sorted((f1, f2) -> -Double.compare(f1.signedDistanceFromSupportPlane((Point3DReadOnly)point), f2.signedDistanceFromSupportPlane((Point3DReadOnly)point))).findFirst().get();
            Face3D actualClosestFace = (Face3D)convexPolytope3D2.getClosestFace((Point3DReadOnly)point);
            Assertions.assertTrue((expectedClosestFace == actualClosestFace ? 1 : 0) != 0, (String)("Iteration " + i));
            point = new Point3D();
            Point3D a = new Point3D((Tuple3DReadOnly)convexPolytope3D2.getVertex(random.nextInt(convexPolytope3D2.getNumberOfVertices())));
            Point3D b = new Point3D((Tuple3DReadOnly)convexPolytope3D2.getVertex(random.nextInt(convexPolytope3D2.getNumberOfVertices())));
            Point3D c = new Point3D((Tuple3DReadOnly)convexPolytope3D2.getVertex(random.nextInt(convexPolytope3D2.getNumberOfVertices())));
            Point3D d = new Point3D((Tuple3DReadOnly)convexPolytope3D2.getVertex(random.nextInt(convexPolytope3D2.getNumberOfVertices())));
            Vector3D toInside = new Vector3D();
            for (Point3D vertex : Arrays.asList(a, b, c, d)) {
                toInside.sub((Tuple3DReadOnly)convexPolytope3D2.getCentroid(), (Tuple3DReadOnly)vertex);
                toInside.scale(convexPolytope3D2.getConstructionEpsilon() / toInside.norm());
                vertex.add((Tuple3DReadOnly)toInside);
            }
            point.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d));
            expectedClosestFace = (Face3D)convexPolytope3D2.getFaces().stream().sorted((f1, f2) -> -Double.compare(f1.signedDistanceFromSupportPlane((Point3DReadOnly)point), f2.signedDistanceFromSupportPlane((Point3DReadOnly)point))).findFirst().get();
            actualClosestFace = (Face3D)convexPolytope3D2.getClosestFace((Point3DReadOnly)point);
            Assertions.assertTrue((expectedClosestFace == actualClosestFace ? 1 : 0) != 0, (String)("Iteration " + i));
            expectedClosestFace = (Face3D)convexPolytope3D2.getFaces().stream().sorted((f1, f2) -> Double.compare(f1.distance((Point3DReadOnly)point), f2.distance((Point3DReadOnly)point))).findFirst().get();
            Assertions.assertTrue((expectedClosestFace == actualClosestFace ? 1 : 0) != 0, (String)("Iteration " + i));
            point = new Point3D();
            expectedClosestFace = (Face3D)convexPolytope3D2.getFace(random.nextInt(convexPolytope3D2.getNumberOfFaces()));
            edge = (HalfEdge3D)expectedClosestFace.getEdge(random.nextInt(expectedClosestFace.getNumberOfEdges()));
            point.set(EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)expectedClosestFace.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination()));
            point.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)expectedClosestFace.getNormal(), (Tuple3DReadOnly)point);
            actualClosestFace = (Face3D)convexPolytope3D2.getClosestFace((Point3DReadOnly)point);
            Assertions.assertTrue((expectedClosestFace == actualClosestFace ? 1 : 0) != 0, (String)("Iteration " + i));
            point = new Point3D();
            HalfEdge3D closestEdge = (HalfEdge3D)convexPolytope3D2.getHalfEdge(random.nextInt(convexPolytope3D2.getNumberOfHalfEdges()));
            Vector3D towardOutside = new Vector3D();
            Vector3D normalA = ((Face3D)closestEdge.getFace()).getNormal();
            Vector3D normalB = ((Face3D)((HalfEdge3D)closestEdge.getTwin()).getFace()).getNormal();
            towardOutside.interpolate((Tuple3DReadOnly)normalA, (Tuple3DReadOnly)normalB, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            towardOutside.normalize();
            point.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            point.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)point);
            actualClosestFace = (Face3D)convexPolytope3D2.getClosestFace((Point3DReadOnly)point);
            Assertions.assertTrue((closestEdge.getFace() == actualClosestFace || ((HalfEdge3D)closestEdge.getTwin()).getFace() == actualClosestFace ? 1 : 0) != 0, (String)("Iteration " + i));
            point = new Point3D();
            Vertex3D closestVertex = (Vertex3D)convexPolytope3D2.getVertex(random.nextInt(convexPolytope3D2.getNumberOfVertices()));
            towardOutside = new Vector3D();
            for (int edgeIndex = 0; edgeIndex < closestVertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
                towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)((HalfEdge3D)closestVertex.getAssociatedEdge(edgeIndex)).getFace()).getNormal(), (Tuple3DReadOnly)towardOutside);
            }
            towardOutside.normalize();
            point.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)closestVertex);
            actualClosestFace = (Face3D)convexPolytope3D2.getClosestFace((Point3DReadOnly)point);
            Assertions.assertTrue((boolean)actualClosestFace.getVertices().contains(closestVertex), (String)("Iteration " + i));
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        Random random = new Random(5434543L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            Point3D point = new Point3D();
            Face3D face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            HalfEdge3D edge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            point.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination()));
            double expectedDistance = Double.NEGATIVE_INFINITY;
            for (Face3D face2 : convexPolytope3D.getFaces()) {
                expectedDistance = Math.max(expectedDistance, EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)face2.getCentroid(), (Vector3DReadOnly)face2.getNormal()));
            }
            double actualDistance = convexPolytope3D.signedDistance((Point3DReadOnly)point);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12, (String)("Iteration " + i));
            point = new Point3D();
            AbstractVertex3D a = convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            AbstractVertex3D b = convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            AbstractVertex3D c = convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            AbstractVertex3D d = convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            point.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d));
            expectedDistance = Double.NEGATIVE_INFINITY;
            for (Face3D face2 : convexPolytope3D.getFaces()) {
                expectedDistance = Math.max(expectedDistance, EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)face2.getCentroid(), (Vector3DReadOnly)face2.getNormal()));
            }
            actualDistance = convexPolytope3D.signedDistance((Point3DReadOnly)point);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12, (String)("Iteration " + i));
            double expectedDistance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D point2 = new Point3D();
            Face3D face3 = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            HalfEdge3D edge2 = (HalfEdge3D)face3.getEdge(random.nextInt(face3.getNumberOfEdges()));
            point2.set(EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face3.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination()));
            point2.scaleAdd(expectedDistance2, (Tuple3DReadOnly)face3.getNormal(), (Tuple3DReadOnly)point2);
            actualDistance = convexPolytope3D.signedDistance((Point3DReadOnly)point2);
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12, (String)("Iteration " + i));
            expectedDistance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            point2 = new Point3D();
            HalfEdge3D edge3 = (HalfEdge3D)convexPolytope3D.getHalfEdge(random.nextInt(convexPolytope3D.getNumberOfHalfEdges()));
            Vector3D towardOutside = new Vector3D();
            Vector3D normalA = ((Face3D)edge3.getFace()).getNormal();
            Vector3D normalB = ((Face3D)((HalfEdge3D)edge3.getTwin()).getFace()).getNormal();
            towardOutside.interpolate((Tuple3DReadOnly)normalA, (Tuple3DReadOnly)normalB, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            towardOutside.normalize();
            point2.interpolate((Tuple3DReadOnly)edge3.getOrigin(), (Tuple3DReadOnly)edge3.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            point2.scaleAdd(expectedDistance2, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)point2);
            actualDistance = convexPolytope3D.signedDistance((Point3DReadOnly)point2);
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12, (String)("Iteration " + i + ", naive method: " + ((Face3D)convexPolytope3D.getClosestFace((Point3DReadOnly)point2)).distance((Point3DReadOnly)point2)));
            expectedDistance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            point2 = new Point3D();
            Vertex3D vertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            towardOutside = new Vector3D();
            for (int edgeIndex = 0; edgeIndex < vertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
                towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)((HalfEdge3D)vertex.getAssociatedEdge(edgeIndex)).getFace()).getNormal(), (Tuple3DReadOnly)towardOutside);
            }
            towardOutside.normalize();
            point2.scaleAdd(expectedDistance2, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)vertex);
            actualDistance = convexPolytope3D.signedDistance((Point3DReadOnly)point2);
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12, (String)("Iteration " + i));
        }
    }

    @Test
    void testApplyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            int faceIndex;
            IcoSphereFactory.TriangleMesh3D icosahedron = IcoSphereFactory.newIcoSphere((int)0);
            ConvexPolytope3D originalPolytope = new ConvexPolytope3D();
            icosahedron.getVertices().forEach(vertex -> originalPolytope.addVertex((Point3DReadOnly)vertex));
            ConvexPolytope3D actualPolytope = new ConvexPolytope3D();
            icosahedron.getVertices().forEach(vertex -> actualPolytope.addVertex((Point3DReadOnly)vertex));
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actualPolytope.applyTransform((Transform)transform);
            icosahedron.applyTransform((Transform)transform);
            ConvexPolytope3D expectedPolytope = new ConvexPolytope3D();
            icosahedron.getVertices().forEach(vertex -> expectedPolytope.addVertex((Point3DReadOnly)vertex));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolytope, (EuclidGeometry)actualPolytope, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolytope.getCentroid(), (EuclidGeometry)actualPolytope.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPolytope.getBoundingBox(), (EuclidGeometry)actualPolytope.getBoundingBox(), (double)1.0E-12);
            for (faceIndex = 0; faceIndex < expectedPolytope.getNumberOfFaces(); ++faceIndex) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)expectedPolytope.getFace(faceIndex)).getCentroid(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)expectedPolytope.getFace(faceIndex)).getNormal(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getNormal(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)expectedPolytope.getFace(faceIndex)).getBoundingBox(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getBoundingBox(), (double)1.0E-12);
                Assertions.assertEquals((double)((Face3D)expectedPolytope.getFace(faceIndex)).getArea(), (double)((Face3D)actualPolytope.getFace(faceIndex)).getArea(), (double)1.0E-12);
            }
            actualPolytope.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope, (EuclidGeometry)actualPolytope, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getCentroid(), (EuclidGeometry)actualPolytope.getCentroid(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getBoundingBox(), (EuclidGeometry)actualPolytope.getBoundingBox(), (double)1.0E-12);
            for (faceIndex = 0; faceIndex < originalPolytope.getNumberOfFaces(); ++faceIndex) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)originalPolytope.getFace(faceIndex)).getCentroid(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)originalPolytope.getFace(faceIndex)).getNormal(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getNormal(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)((Face3D)originalPolytope.getFace(faceIndex)).getBoundingBox(), (EuclidGeometry)((Face3D)actualPolytope.getFace(faceIndex)).getBoundingBox(), (double)1.0E-12);
                Assertions.assertEquals((double)((Face3D)originalPolytope.getFace(faceIndex)).getArea(), (double)((Face3D)actualPolytope.getFace(faceIndex)).getArea(), (double)1.0E-12);
            }
        }
    }

    @Test
    void testSetConvexPolytope3D() throws Exception {
        Random random = new Random(234543L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D originalPolytope = EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random);
            ConvexPolytope3D copyPolytope = new ConvexPolytope3D();
            copyPolytope.set(originalPolytope);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope, (EuclidGeometry)copyPolytope, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getBoundingBox(), (EuclidGeometry)copyPolytope.getBoundingBox(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getCentroid(), (EuclidGeometry)copyPolytope.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)originalPolytope.getVolume(), (double)copyPolytope.getVolume(), (double)1.0E-12);
            for (int faceIndex = 0; faceIndex < originalPolytope.getNumberOfFaces(); ++faceIndex) {
                Face3D copyFace;
                Face3D originalFace = (Face3D)originalPolytope.getFace(faceIndex);
                Assertions.assertTrue((originalFace != (copyFace = (Face3D)copyPolytope.getFace(faceIndex)) ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getCentroid(), (EuclidGeometry)copyFace.getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getNormal(), (EuclidGeometry)copyFace.getNormal(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getBoundingBox(), (EuclidGeometry)copyFace.getBoundingBox(), (double)1.0E-12);
                Assertions.assertEquals((double)originalFace.getArea(), (double)copyFace.getArea(), (double)1.0E-12);
            }
            for (int edgeIndex = 0; edgeIndex < originalPolytope.getHalfEdges().size(); ++edgeIndex) {
                HalfEdge3D originalEdge = (HalfEdge3D)originalPolytope.getHalfEdge(edgeIndex);
                HalfEdge3D copyEdge = (HalfEdge3D)copyPolytope.getHalfEdge(edgeIndex);
                HalfEdge3D originalNext = (HalfEdge3D)originalEdge.getNext();
                HalfEdge3D originalPrevious = (HalfEdge3D)originalEdge.getPrevious();
                HalfEdge3D originalTwin = (HalfEdge3D)originalEdge.getTwin();
                Face3D originalFace = (Face3D)originalEdge.getFace();
                HalfEdge3D copyNext = (HalfEdge3D)copyEdge.getNext();
                HalfEdge3D copyPrevious = (HalfEdge3D)copyEdge.getPrevious();
                HalfEdge3D copyTwin = (HalfEdge3D)copyEdge.getTwin();
                Face3D copyFace = (Face3D)copyEdge.getFace();
                Assertions.assertTrue((originalEdge.getOrigin() != copyEdge.getOrigin() ? 1 : 0) != 0);
                Assertions.assertTrue((originalEdge.getDestination() != copyEdge.getDestination() ? 1 : 0) != 0);
                Assertions.assertTrue((originalEdge != copyEdge ? 1 : 0) != 0);
                Assertions.assertTrue((originalNext != copyNext ? 1 : 0) != 0);
                Assertions.assertTrue((originalPrevious != copyPrevious ? 1 : 0) != 0);
                Assertions.assertTrue((originalTwin != copyTwin ? 1 : 0) != 0);
                Assertions.assertTrue((originalFace != copyFace ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalEdge, (EuclidGeometry)copyEdge, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalNext, (EuclidGeometry)copyNext, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPrevious, (EuclidGeometry)copyPrevious, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalTwin, (EuclidGeometry)copyTwin, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace, (EuclidGeometry)copyFace, (double)1.0E-12);
            }
            for (int vertexIndex = 0; vertexIndex < originalPolytope.getNumberOfVertices(); ++vertexIndex) {
                Vertex3D copyVertex;
                Vertex3D originalVertex = (Vertex3D)originalPolytope.getVertex(vertexIndex);
                Assertions.assertTrue((originalVertex != (copyVertex = (Vertex3D)copyPolytope.getVertex(vertexIndex)) ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalVertex, (EuclidGeometry)copyVertex, (double)1.0E-12);
                for (int edgeIndex = 0; edgeIndex < originalVertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
                    HalfEdge3D copyEdge;
                    HalfEdge3D originalEdge = (HalfEdge3D)originalVertex.getAssociatedEdge(edgeIndex);
                    Assertions.assertTrue((originalEdge != (copyEdge = (HalfEdge3D)copyVertex.getAssociatedEdge(edgeIndex)) ? 1 : 0) != 0);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)originalEdge, (EuclidGeometry)copyEdge, (double)1.0E-12);
                }
            }
        }
    }

    @Test
    void testCopyConstructor() throws Exception {
        Random random = new Random(9574938L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D originalPolytope = EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random);
            ConvexPolytope3D copyPolytope = new ConvexPolytope3D((ConvexPolytope3DReadOnly)originalPolytope);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope, (EuclidGeometry)copyPolytope, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getBoundingBox(), (EuclidGeometry)copyPolytope.getBoundingBox(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPolytope.getCentroid(), (EuclidGeometry)copyPolytope.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)originalPolytope.getVolume(), (double)copyPolytope.getVolume(), (double)1.0E-12);
            for (int faceIndex = 0; faceIndex < originalPolytope.getNumberOfFaces(); ++faceIndex) {
                Face3D copyFace;
                Face3D originalFace = (Face3D)originalPolytope.getFace(faceIndex);
                Assertions.assertTrue((originalFace != (copyFace = (Face3D)copyPolytope.getFace(faceIndex)) ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getCentroid(), (EuclidGeometry)copyFace.getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getNormal(), (EuclidGeometry)copyFace.getNormal(), (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace.getBoundingBox(), (EuclidGeometry)copyFace.getBoundingBox(), (double)1.0E-12);
                Assertions.assertEquals((double)originalFace.getArea(), (double)copyFace.getArea(), (double)1.0E-12);
            }
            for (int edgeIndex = 0; edgeIndex < originalPolytope.getHalfEdges().size(); ++edgeIndex) {
                HalfEdge3D originalEdge = (HalfEdge3D)originalPolytope.getHalfEdge(edgeIndex);
                HalfEdge3D copyEdge = (HalfEdge3D)copyPolytope.getHalfEdge(edgeIndex);
                HalfEdge3D originalNext = (HalfEdge3D)originalEdge.getNext();
                HalfEdge3D originalPrevious = (HalfEdge3D)originalEdge.getPrevious();
                HalfEdge3D originalTwin = (HalfEdge3D)originalEdge.getTwin();
                Face3D originalFace = (Face3D)originalEdge.getFace();
                HalfEdge3D copyNext = (HalfEdge3D)copyEdge.getNext();
                HalfEdge3D copyPrevious = (HalfEdge3D)copyEdge.getPrevious();
                HalfEdge3D copyTwin = (HalfEdge3D)copyEdge.getTwin();
                Face3D copyFace = (Face3D)copyEdge.getFace();
                Assertions.assertTrue((originalEdge.getOrigin() != copyEdge.getOrigin() ? 1 : 0) != 0);
                Assertions.assertTrue((originalEdge.getDestination() != copyEdge.getDestination() ? 1 : 0) != 0);
                Assertions.assertTrue((originalEdge != copyEdge ? 1 : 0) != 0);
                Assertions.assertTrue((originalNext != copyNext ? 1 : 0) != 0);
                Assertions.assertTrue((originalPrevious != copyPrevious ? 1 : 0) != 0);
                Assertions.assertTrue((originalTwin != copyTwin ? 1 : 0) != 0);
                Assertions.assertTrue((originalFace != copyFace ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalEdge, (EuclidGeometry)copyEdge, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalNext, (EuclidGeometry)copyNext, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalPrevious, (EuclidGeometry)copyPrevious, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalTwin, (EuclidGeometry)copyTwin, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFace, (EuclidGeometry)copyFace, (double)1.0E-12);
            }
            for (int vertexIndex = 0; vertexIndex < originalPolytope.getNumberOfVertices(); ++vertexIndex) {
                Vertex3D copyVertex;
                Vertex3D originalVertex = (Vertex3D)originalPolytope.getVertex(vertexIndex);
                Assertions.assertTrue((originalVertex != (copyVertex = (Vertex3D)copyPolytope.getVertex(vertexIndex)) ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalVertex, (EuclidGeometry)copyVertex, (double)1.0E-12);
                for (int edgeIndex = 0; edgeIndex < originalVertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
                    HalfEdge3D copyEdge;
                    HalfEdge3D originalEdge = (HalfEdge3D)originalVertex.getAssociatedEdge(edgeIndex);
                    Assertions.assertTrue((originalEdge != (copyEdge = (HalfEdge3D)copyVertex.getAssociatedEdge(edgeIndex)) ? 1 : 0) != 0);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)originalEdge, (EuclidGeometry)copyEdge, (double)1.0E-12);
                }
            }
        }
    }

    @Test
    void testBoundingBox() throws Exception {
        Random random = new Random(435354237L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random);
            convexPolytope3D.getVertices().forEach(vertex -> Assertions.assertTrue((boolean)convexPolytope3D.getBoundingBox().isInsideInclusive((Point3DReadOnly)vertex)));
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            convexPolytope3D.getVertices().forEach(vertex -> expectedBoundingBox.updateToIncludePoint((Point3DReadOnly)vertex));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBoundingBox, (EuclidGeometry)convexPolytope3D.getBoundingBox(), (double)1.0E-12);
        }
    }

    @Test
    void testCentroidAndVolume() throws Exception {
        int i;
        Random random = new Random(45L);
        for (i = 0; i < 1000; ++i) {
            Point3D a = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D b = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D c = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            Point3D d = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(a, b, c, d).forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{a, b, c, d}));
            Point3D expectedCentroid = EuclidGeometryTools.averagePoint3Ds(Arrays.asList(a, b, c, d));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)EuclidShapeTools.tetrahedronVolume((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c, (Point3DReadOnly)d), (double)convexPolytope3D.getVolume(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            List cylinderVertices = EuclidPolytopeFactories.newCylinderVertices((double)length, (double)radius, (int)50);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            cylinderVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)cylinderVertices));
            Point3D expectedCentroid = new Point3D((Tuple3DReadOnly)transform.getTranslation());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            double expectedVolume = EuclidShapeTools.cylinderVolume((double)length, (double)radius);
            Assertions.assertEquals((double)expectedVolume, (double)convexPolytope3D.getVolume(), (double)(0.003 * expectedVolume));
        }
        for (i = 0; i < 1000; ++i) {
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            List icosahedronVertices = EuclidPolytopeFactories.newIcosahedronVertices((double)radius);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            icosahedronVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)icosahedronVertices));
            Point3D expectedCentroid = new Point3D((Tuple3DReadOnly)transform.getTranslation());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)EuclidShapeTools.icosahedronVolume((double)EuclidShapeTools.icosahedronEdgeLength((double)radius)), (double)convexPolytope3D.getVolume(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double height = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            int numberOfDivisions = 50;
            List coneVertices = EuclidPolytopeFactories.newConeVertices((double)height, (double)radius, (int)numberOfDivisions);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            coneVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)coneVertices));
            Assertions.assertEquals((long)1L, (long)convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == numberOfDivisions).count());
            Point3D expectedCentroid = new Point3D(0.0, 0.0, height / 4.0);
            expectedCentroid.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            double expectedVolume = EuclidShapeTools.coneVolume((double)height, (double)radius);
            Assertions.assertEquals((double)expectedVolume, (double)convexPolytope3D.getVolume(), (double)(0.003 * expectedVolume));
        }
        for (i = 0; i < 1000; ++i) {
            double height = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double baseLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double baseWidth = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            List pyramidVertices = EuclidPolytopeFactories.newPyramidVertices((double)height, (double)baseLength, (double)baseWidth);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            pyramidVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)pyramidVertices));
            Assertions.assertEquals((long)1L, (long)convexPolytope3D.getFaces().stream().filter(face -> face.getNumberOfEdges() == 4).count());
            Point3D expectedCentroid = new Point3D(0.0, 0.0, height / 4.0);
            expectedCentroid.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)EuclidShapeTools.pyramidVolume((double)height, (double)baseLength, (double)baseWidth), (double)convexPolytope3D.getVolume(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double coneHeight = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            int numberOfDivisions = 50;
            List shapeVertices = EuclidPolytopeFactories.newCylinderVertices((double)cylinderLength, (double)radius, (int)numberOfDivisions);
            shapeVertices.add(new Point3D(0.0, 0.0, 0.5 * cylinderLength + coneHeight));
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)shapeVertices));
            Assertions.assertEquals((int)(2 * numberOfDivisions + 1), (int)convexPolytope3D.getNumberOfVertices());
            double coneVolume = EuclidShapeTools.coneVolume((double)coneHeight, (double)radius);
            double cylinderVolume = EuclidShapeTools.cylinderVolume((double)cylinderLength, (double)radius);
            Point3D coneCentroid = new Point3D(0.0, 0.0, 0.5 * cylinderLength + coneHeight / 4.0);
            Point3D cylinderCentroid = new Point3D();
            double shapeVolume = coneVolume + cylinderVolume;
            Point3D shapeCentroid = new Point3D();
            shapeCentroid.setAndScale(coneVolume / shapeVolume, (Tuple3DReadOnly)coneCentroid);
            shapeCentroid.scaleAdd(cylinderVolume / shapeVolume, (Tuple3DReadOnly)cylinderCentroid, (Tuple3DReadOnly)shapeCentroid);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)shapeCentroid, (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            Assertions.assertEquals((double)shapeVolume, (double)convexPolytope3D.getVolume(), (double)(0.003 * shapeVolume));
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(3409736L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertNull((Object)convexPolytope3D.getSupportingVertex((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random)));
                continue;
            }
            Vector3D supportDirection = new Vector3D();
            supportDirection.set((Tuple3DReadOnly)Axis3D.X);
            Vertex3DReadOnly expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v2.getX(), v1.getX())).findFirst().get();
            Vertex3DReadOnly actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.X);
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.getX(), v2.getX())).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v2.getY(), v1.getY())).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.getY(), v2.getY())).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v2.getZ(), v1.getZ())).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.Z);
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.getZ(), v2.getZ())).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set(EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0)));
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v2.dot((Vector3DReadOnly)supportDirection), v1.dot((Vector3DReadOnly)supportDirection))).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set(EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0)));
            Point3D pointFarFarAway = new Point3D();
            pointFarFarAway.scaleAdd(10000.0, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)convexPolytope3D.getCentroid());
            expectedSupportVertex = (Vertex3DReadOnly)convexPolytope3D.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.distance((Point3DReadOnly)pointFarFarAway), v2.distance((Point3DReadOnly)pointFarFarAway))).findFirst().get();
            actualSupportVertex = convexPolytope3D.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((expectedSupportVertex == actualSupportVertex ? 1 : 0) != 0, (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        Point3DBasics actualProjection;
        Point3DBasics expectedProjection;
        Point3D pointOutside;
        HalfEdge3D edge2;
        Face3D face;
        ConvexPolytope3D convexPolytope3D;
        int i;
        Random random = new Random(34535L);
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertNull((Object)convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random)));
                continue;
            }
            face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            pointOutside = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOutside);
            expectedProjection = face.orthogonalProjectionCopy((Point3DReadOnly)pointOutside);
            actualProjection = convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertNull((Object)convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random)));
                continue;
            }
            face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Point3D pointInside = EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
            Point3DBasics actualProjection2 = convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside);
            Assertions.assertNull((Object)actualProjection2);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertNull((Object)convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random)));
                continue;
            }
            Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
            Face3D secondFace = (Face3D)((HalfEdge3D)closestEdge.getTwin()).getFace();
            Vector3D towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)firstFace.getNormal(), (Tuple3DReadOnly)secondFace.getNormal(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            towardOutside.normalize();
            Point3D pointOutside2 = new Point3D();
            pointOutside2.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOutside2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOutside2);
            Point3DBasics expectedProjection2 = closestEdge.orthogonalProjectionCopy((Point3DReadOnly)pointOutside2);
            Point3DBasics actualProjection3 = convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection2, (EuclidGeometry)actualProjection3, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertNull((Object)convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random)));
                continue;
            }
            Vertex3D closestVertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            Vector3D towardOutside = new Vector3D();
            closestVertex.getAssociatedEdges().stream().forEach(edge -> towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)edge.getFace()).getNormal(), (Tuple3DReadOnly)towardOutside));
            towardOutside.normalize();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)closestVertex);
            expectedProjection = closestVertex;
            actualProjection = convexPolytope3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        HalfEdge3D edge2;
        Face3D face;
        Point3D point;
        ConvexPolytope3D convexPolytope3D;
        int i;
        Random random = new Random(3435L);
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal);
                expectedClosestPoint.set((Tuple3DReadOnly)convexPolytope3D.getVertex(0));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 2) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                expectedClosestPoint.set(EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)convexPolytope3D.getVertex(0), (Point3DReadOnly)convexPolytope3D.getVertex(1)));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Point3D pointOnFace = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOnFace);
            expectedClosestPoint.set(pointOnFace);
            expectedNormal.set(face.getNormal());
            Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal);
                expectedClosestPoint.set((Tuple3DReadOnly)convexPolytope3D.getVertex(0));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 2) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                expectedClosestPoint.set(EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)convexPolytope3D.getVertex(0), (Point3DReadOnly)convexPolytope3D.getVertex(1)));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Point3D pointInside = EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
            Face3D closestFace = (Face3D)convexPolytope3D.getFaces().stream().sorted((f1, f2) -> Double.compare(f1.distance((Point3DReadOnly)pointInside), f2.distance((Point3DReadOnly)pointInside))).findFirst().get();
            expectedClosestPoint.set(EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointInside, (Point3DReadOnly)closestFace.getCentroid(), (Vector3DReadOnly)closestFace.getNormal()));
            expectedNormal.set(closestFace.getNormal());
            if (convexPolytope3D.getNumberOfFaces() == 1) {
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
            } else {
                Assertions.assertTrue((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal);
                expectedClosestPoint.set((Tuple3DReadOnly)convexPolytope3D.getVertex(0));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 2) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                expectedClosestPoint.set(EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)convexPolytope3D.getVertex(0), (Point3DReadOnly)convexPolytope3D.getVertex(1)));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
            HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
            Vector3D towardOutside = new Vector3D();
            if (closestEdge.getTwin() != null) {
                Face3D secondFace = (Face3D)((HalfEdge3D)closestEdge.getTwin()).getFace();
                towardOutside.interpolate((Tuple3DReadOnly)firstFace.getNormal(), (Tuple3DReadOnly)secondFace.getNormal(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            } else {
                Vector3D faceNormal = new Vector3D((Tuple3DReadOnly)firstFace.getNormal());
                towardOutside.cross((Tuple3DReadOnly)faceNormal, (Tuple3DReadOnly)closestEdge.getDirection(false));
                if (random.nextBoolean()) {
                    faceNormal.negate();
                }
                towardOutside.interpolate((Tuple3DReadOnly)faceNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            }
            towardOutside.normalize();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set(pointOnEdge);
            expectedNormal.set(towardOutside);
            Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal);
                expectedClosestPoint.set((Tuple3DReadOnly)convexPolytope3D.getVertex(0));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 2) {
                point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)5.0);
                expectedClosestPoint.set(EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)convexPolytope3D.getVertex(0), (Point3DReadOnly)convexPolytope3D.getVertex(1)));
                expectedNormal.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)expectedClosestPoint);
                expectedNormal.normalize();
                Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
                continue;
            }
            Vertex3D closestVertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            Vector3D towardOutside = new Vector3D();
            closestVertex.getAssociatedEdges().stream().forEach(edge -> towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)edge.getFace()).getNormal(), (Tuple3DReadOnly)towardOutside));
            towardOutside.normalize();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)closestVertex);
            expectedClosestPoint.set((Tuple3DReadOnly)closestVertex);
            expectedNormal.set(towardOutside);
            Assertions.assertFalse((boolean)convexPolytope3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal), (String)("Iteration: " + i));
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testFaceNormalAndVertexOrdering() throws Exception {
        Random random = new Random(34535L);
        for (int i = 0; i < 1000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextPointCloud3D((Random)random, (double)5.0, (double)5.0, (int)4);
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)vertices));
            List normals = tetrahedron.getFaces().stream().map(face -> new Vector3D((Tuple3DReadOnly)face.getNormal())).collect(Collectors.toList());
            for (int j = 0; j < tetrahedron.getNumberOfFaces(); ++j) {
                EuclidCoreTestTools.assertEquals((String)("Iteration: " + i + ", face index: " + j), (EuclidGeometry)((EuclidGeometry)normals.get(j)), (EuclidGeometry)((Face3D)tetrahedron.getFace(j)).getNormal(), (double)1.0E-12);
            }
        }
    }

    @Test
    void testGeneralIntegrityOfRandomConvexPolytope3D() throws Exception {
        Random random = new Random(206422882L);
        for (int i = 0; i < 1000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((ConvexPolytope3DReadOnly)convexPolytope3D);
            convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((ConvexPolytope3DReadOnly)convexPolytope3D);
        }
    }

    @Test
    void testTroublesomeDatasets() throws Exception {
        ArrayList<ConvexPolytope3DTroublesomeDataset> datasets = new ArrayList<ConvexPolytope3DTroublesomeDataset>();
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug1Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug1Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug2Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug2OriginalV2());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug2OriginalV3());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug2Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug3Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug3OriginalV2());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug3Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug4Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug4Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug5());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug6());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug6V2());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug6V3());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug6V4());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug7Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetEPAFaceNormalIntegrityBug8Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetEPAFaceNormalIntegrityBug8Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetEPAFaceNormalIntegrityBug8SimplifiedV2());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetEPAFaceNormalIntegrityBug9Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetEPAFaceNormalIntegrityBug9Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug10Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug10Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug11Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug11Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug12Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKNullPointerExceptionBug12Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug13Original());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrityBug13Simplified());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.DatasetGJKFaceNormalIntegrity_20190228_220911());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190302_160115());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_111711());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_120656());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_122006());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_142536());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_154201());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_165341());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_172836());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190303_180109());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190317_143836());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190317_161948());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190321_222438());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_122756());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_124929());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_150735());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_190624());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_193234());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_195449());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_213507());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190323_224417());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190324_182459());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190324_185429());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190325_205801());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190327_205357());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190327_211921());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190327_213133());
        datasets.add(new ConvexPolytope3DTroublesomeDatasetLibrary.ConvexPolytope3DTroublesomeDataset_20190327_214757());
        for (int i = 0; i < datasets.size(); ++i) {
            ConvexPolytope3DTroublesomeDataset dataset = (ConvexPolytope3DTroublesomeDataset)datasets.get(i);
            String messagePrefix = "Dataset: " + dataset.getClass().getSimpleName();
            try {
                ConvexPolytope3D convexPolytope3D = dataset.getConvexPolytope3D();
                EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((String)messagePrefix, (ConvexPolytope3DReadOnly)convexPolytope3D);
                convexPolytope3D.addVertex((Point3DReadOnly)dataset.getTroublesomePoint());
                EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((String)messagePrefix, (ConvexPolytope3DReadOnly)convexPolytope3D);
                continue;
            }
            catch (AssertionError | Exception e) {
                throw new AssertionFailedError(messagePrefix, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ boolean lambda$testConstructingCylinder$52(Vertex3D vertex, Point3D point) {
        return point.epsilonEquals((EuclidGeometry)vertex, 1.0E-12);
    }

    private static /* synthetic */ boolean lambda$testConstructingCone$39(Vertex3D vertex, Point3D point) {
        return point.epsilonEquals((EuclidGeometry)vertex, 1.0E-12);
    }

    private static /* synthetic */ boolean lambda$testConstructingCone$33(Vertex3D vertex, Point3D point) {
        return point.epsilonEquals((EuclidGeometry)vertex, 1.0E-12);
    }
}

