/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.EuclidShapeCollisionTools;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.PointShape3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.Torus3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidEllipsoid3DTools;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeCollisionToolsTest {
    private static final double EPSILON = 5.0E-10;

    @Test
    public void testPointShape3DBox3D() throws Exception {
        EuclidShape3DCollisionResult actual;
        EuclidShape3DCollisionResult expected;
        PointShape3D pointShape3D;
        Bound bound;
        Axis3D axis;
        Box3D box3D;
        int i;
        Random random = new Random(235425L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            axis = Axis3D.values[random.nextInt(3)];
            bound = Bound.values()[random.nextInt(2)];
            Point3D pointOnAFace = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])EuclidShapeCollisionToolsTest.getBox3DFaceVertices(axis, bound, (Box3DReadOnly)box3D));
            Vector3D shiftDirection = new Vector3D((Tuple3DReadOnly)EuclidShapeCollisionToolsTest.getAxis(axis, (Shape3DPoseReadOnly)box3D.getPose()));
            if (bound == Bound.MIN) {
                shiftDirection.negate();
            }
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)shiftDirection, (Tuple3DReadOnly)pointOnAFace);
            PointShape3D pointShape3D2 = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected2 = new EuclidShape3DCollisionResult();
            expected2.setToNaN();
            expected2.setShapeA((Shape3DReadOnly)pointShape3D2);
            expected2.setShapeB((Shape3DReadOnly)box3D);
            expected2.setShapesAreColliding(false);
            expected2.setSignedDistance(distance);
            expected2.getPointOnA().set((Tuple3DReadOnly)pointShape3D2);
            expected2.getNormalOnA().setAndNegate((Tuple3DReadOnly)shiftDirection);
            expected2.getPointOnB().set(pointOnAFace);
            expected2.getNormalOnB().set(shiftDirection);
            EuclidShape3DCollisionResult actual2 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DBox3DCollision((PointShape3DReadOnly)pointShape3D2, (Box3DReadOnly)box3D, (EuclidShape3DCollisionResultBasics)actual2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)actual2, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            axis = Axis3D.values[random.nextInt(3)];
            bound = Bound.values()[random.nextInt(2)];
            Plane3D closestFacePlane = EuclidShapeCollisionToolsTest.getBox3DFacePlane(axis, bound, (Box3DReadOnly)box3D);
            ArrayList<Point3D> faceVerticesAndFarthestIn = new ArrayList<Point3D>(Arrays.asList(EuclidShapeCollisionToolsTest.getBox3DFaceVertices(axis, bound, (Box3DReadOnly)box3D)));
            double minHalfSize = 0.5 * EuclidCoreTools.min((double)box3D.getSizeX(), (double)box3D.getSizeY(), (double)box3D.getSizeZ());
            Point3D farthestInside = new Point3D();
            farthestInside.scaleAdd(-minHalfSize, (Tuple3DReadOnly)closestFacePlane.getNormal(), (Tuple3DReadOnly)closestFacePlane.getPoint());
            faceVerticesAndFarthestIn.add(farthestInside);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, faceVerticesAndFarthestIn);
            Point3D pointOnFace = new Point3D();
            closestFacePlane.orthogonalProjection((Point3DReadOnly)pointInside, (Point3DBasics)pointOnFace);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)box3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(-closestFacePlane.distance((Point3DReadOnly)pointInside));
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)closestFacePlane.getNormal());
            expected.getPointOnB().set(pointOnFace);
            expected.getNormalOnB().set((Tuple3DReadOnly)closestFacePlane.getNormal());
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DBox3DCollision((PointShape3DReadOnly)pointShape3D, (Box3DReadOnly)box3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Bound xBound = Bound.values()[random.nextInt(2)];
            Bound yBound = Bound.values()[random.nextInt(2)];
            Bound zBound = Bound.values()[random.nextInt(2)];
            Point3D closestVertex = EuclidShapeCollisionToolsTest.getVertex(xBound, yBound, zBound, (Box3DReadOnly)box3D);
            Vector3D xDirection = new Vector3D((Tuple3DReadOnly)box3D.getPose().getXAxis());
            if (xBound == Bound.MIN) {
                xDirection.negate();
            }
            Vector3D yDirection = new Vector3D((Tuple3DReadOnly)box3D.getPose().getYAxis());
            if (yBound == Bound.MIN) {
                yDirection.negate();
            }
            Vector3D zDirection = new Vector3D((Tuple3DReadOnly)box3D.getPose().getZAxis());
            if (zBound == Bound.MIN) {
                zDirection.negate();
            }
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)closestVertex);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)xDirection, (Tuple3DReadOnly)pointOutside);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)yDirection, (Tuple3DReadOnly)pointOutside);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)zDirection, (Tuple3DReadOnly)pointOutside);
            Vector3D normal = new Vector3D();
            normal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)closestVertex);
            normal.normalize();
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)box3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(pointOutside.distance((Point3DReadOnly)closestVertex));
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(closestVertex);
            expected.getNormalOnB().set(normal);
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DBox3DCollision((PointShape3DReadOnly)pointShape3D, (Box3DReadOnly)box3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Axis3D edgeAxis = Axis3D.values[random.nextInt(3)];
            Axis3D otherAxis1 = edgeAxis.previous();
            Axis3D otherAxis2 = otherAxis1.previous();
            double signAxis1 = random.nextBoolean() ? -1.0 : 1.0;
            double signAxis2 = random.nextBoolean() ? -1.0 : 1.0;
            Vector3D direction1 = new Vector3D();
            direction1.setAndScale(signAxis1, (Tuple3DReadOnly)EuclidShapeCollisionToolsTest.getAxis(otherAxis1, (Shape3DPoseReadOnly)box3D.getPose()));
            Vector3D direction2 = new Vector3D();
            direction2.setAndScale(signAxis2, (Tuple3DReadOnly)EuclidShapeCollisionToolsTest.getAxis(otherAxis2, (Shape3DPoseReadOnly)box3D.getPose()));
            Point3D edgeCenter = new Point3D((Tuple3DReadOnly)box3D.getPosition());
            edgeCenter.scaleAdd(0.5 * signAxis1 * otherAxis1.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)direction1, (Tuple3DReadOnly)edgeCenter);
            edgeCenter.scaleAdd(0.5 * signAxis2 * otherAxis2.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)direction2, (Tuple3DReadOnly)edgeCenter);
            Point3D pointOnEdge = new Point3D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5);
            pointOnEdge.scaleAdd(alpha * edgeAxis.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)EuclidShapeCollisionToolsTest.getAxis(edgeAxis, (Shape3DPoseReadOnly)box3D.getPose()), (Tuple3DReadOnly)edgeCenter);
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)pointOnEdge);
            pointOutside.scaleAdd(signAxis1 * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)direction1, (Tuple3DReadOnly)pointOutside);
            pointOutside.scaleAdd(signAxis2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)direction2, (Tuple3DReadOnly)pointOutside);
            Vector3D normal = new Vector3D();
            normal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)pointOnEdge);
            normal.normalize();
            PointShape3D pointShape3D3 = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected3 = new EuclidShape3DCollisionResult();
            expected3.setToNaN();
            expected3.setShapeA((Shape3DReadOnly)pointShape3D3);
            expected3.setShapeB((Shape3DReadOnly)box3D);
            expected3.setShapesAreColliding(false);
            expected3.setSignedDistance(pointOutside.distance((Point3DReadOnly)pointOnEdge));
            expected3.getPointOnA().set(pointOutside);
            expected3.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected3.getPointOnB().set(pointOnEdge);
            expected3.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual3 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DBox3DCollision((PointShape3DReadOnly)pointShape3D3, (Box3DReadOnly)box3D, (EuclidShape3DCollisionResultBasics)actual3);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((EuclidShape3DCollisionResultReadOnly)expected3, (EuclidShape3DCollisionResultReadOnly)actual3, (double)5.0E-10);
        }
    }

    @Test
    public void testPointShape3DCapsule3D() throws Exception {
        EuclidShape3DCollisionResult actual;
        Point3D pointOnSurface;
        Vector3D normal;
        EuclidShape3DCollisionResult actual2;
        EuclidShape3DCollisionResult expected;
        PointShape3D pointShape3D;
        Point3D pointOnSurface2;
        Vector3D normal2;
        Point3D endCenter;
        UnitVector3DBasics capsuleAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(5411L);
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            capsuleAxis = capsule3D.getAxis();
            double endSign = random.nextBoolean() ? -1.0 : 1.0;
            endCenter = new Point3D();
            endCenter.scaleAdd(0.5 * endSign * capsule3D.getLength(), (Tuple3DReadOnly)capsuleAxis, (Tuple3DReadOnly)capsule3D.getPosition());
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsuleAxis, (boolean)false);
            normal2 = new Vector3D();
            normal2.setAndScale(endSign, (Tuple3DReadOnly)capsuleAxis);
            normal2.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            normal2.normalize();
            pointOnSurface2 = new Point3D();
            pointOnSurface2.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)normal2, (Tuple3DReadOnly)endCenter);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal2, (Tuple3DReadOnly)pointOnSurface2);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)capsule3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(distance);
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal2);
            expected.getPointOnB().set(pointOnSurface2);
            expected.getNormalOnB().set(normal2);
            actual2 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCapsule3DCollision((PointShape3DReadOnly)pointShape3D, (Capsule3DReadOnly)capsule3D, (EuclidShape3DCollisionResultBasics)actual2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual2, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            capsuleAxis = capsule3D.getAxis();
            Point3D pointOnAxis = new Point3D();
            pointOnAxis.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * capsule3D.getLength())), (Tuple3DReadOnly)capsuleAxis, (Tuple3DReadOnly)capsule3D.getPosition());
            normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsuleAxis, (boolean)true);
            pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnAxis);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D2 = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected2 = new EuclidShape3DCollisionResult();
            expected2.setToNaN();
            expected2.setShapeA((Shape3DReadOnly)pointShape3D2);
            expected2.setShapeB((Shape3DReadOnly)capsule3D);
            expected2.setShapesAreColliding(false);
            expected2.setSignedDistance(distance);
            expected2.getPointOnA().set(pointOutside);
            expected2.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected2.getPointOnB().set(pointOnSurface);
            expected2.getNormalOnB().set(normal);
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCapsule3DCollision((PointShape3DReadOnly)pointShape3D2, (Capsule3DReadOnly)capsule3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            capsuleAxis = capsule3D.getAxis();
            double endSign = random.nextBoolean() ? -1.0 : 1.0;
            endCenter = new Point3D();
            endCenter.scaleAdd(0.5 * endSign * capsule3D.getLength(), (Tuple3DReadOnly)capsuleAxis, (Tuple3DReadOnly)capsule3D.getPosition());
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsuleAxis, (boolean)false);
            normal2 = new Vector3D();
            normal2.setAndScale(endSign, (Tuple3DReadOnly)capsuleAxis);
            normal2.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            normal2.normalize();
            pointOnSurface2 = new Point3D();
            pointOnSurface2.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)normal2, (Tuple3DReadOnly)endCenter);
            Point3D pointInside = new Point3D();
            pointInside.interpolate((Tuple3DReadOnly)endCenter, (Tuple3DReadOnly)pointOnSurface2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            double distance = pointOnSurface2.distance((Point3DReadOnly)pointInside);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)capsule3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(-distance);
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal2);
            expected.getPointOnB().set(pointOnSurface2);
            expected.getNormalOnB().set(normal2);
            actual2 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCapsule3DCollision((PointShape3DReadOnly)pointShape3D, (Capsule3DReadOnly)capsule3D, (EuclidShape3DCollisionResultBasics)actual2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual2, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            capsuleAxis = capsule3D.getAxis();
            Point3D pointOnAxis = new Point3D();
            pointOnAxis.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * capsule3D.getLength())), (Tuple3DReadOnly)capsuleAxis, (Tuple3DReadOnly)capsule3D.getPosition());
            normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsuleAxis, (boolean)true);
            pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnAxis);
            Point3D pointInside = new Point3D();
            pointInside.interpolate((Tuple3DReadOnly)pointOnAxis, (Tuple3DReadOnly)pointOnSurface, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            double distance = pointInside.distance((Point3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D3 = new PointShape3D((Tuple3DReadOnly)pointInside);
            EuclidShape3DCollisionResult expected3 = new EuclidShape3DCollisionResult();
            expected3.setToNaN();
            expected3.setShapeA((Shape3DReadOnly)pointShape3D3);
            expected3.setShapeB((Shape3DReadOnly)capsule3D);
            expected3.setShapesAreColliding(true);
            expected3.setSignedDistance(-distance);
            expected3.getPointOnA().set(pointInside);
            expected3.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected3.getPointOnB().set(pointOnSurface);
            expected3.getNormalOnB().set(normal);
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCapsule3DCollision((PointShape3DReadOnly)pointShape3D3, (Capsule3DReadOnly)capsule3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected3, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
    }

    @Test
    public void testPointShape3DCylinder3D() throws Exception {
        EuclidShape3DCollisionResult expected;
        PointShape3D pointShape3D;
        Point3D endCenter;
        UnitVector3DBasics cylinderAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(42352L);
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            cylinderAxis = cylinder3D.getAxis();
            double endSign = random.nextBoolean() ? -1.0 : 1.0;
            endCenter = new Point3D();
            endCenter.scaleAdd(0.5 * endSign * cylinder3D.getLength(), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinderAxis, (boolean)true);
            Point3D pointOnSurface = new Point3D();
            double distanceFromCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            pointOnSurface.scaleAdd(distanceFromCenter, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)endCenter);
            Vector3D normal = new Vector3D();
            normal.setAndScale(endSign, (Tuple3DReadOnly)cylinderAxis);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D2 = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected2 = new EuclidShape3DCollisionResult();
            expected2.setToNaN();
            expected2.setShapeA((Shape3DReadOnly)pointShape3D2);
            expected2.setShapeB((Shape3DReadOnly)cylinder3D);
            expected2.setShapesAreColliding(false);
            expected2.setSignedDistance(distance);
            expected2.getPointOnA().set(pointOutside);
            expected2.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected2.getPointOnB().set(pointOnSurface);
            expected2.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCylinder3DCollision((PointShape3DReadOnly)pointShape3D2, (Cylinder3DReadOnly)cylinder3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            cylinderAxis = cylinder3D.getAxis();
            Point3D pointOnAxis = new Point3D();
            pointOnAxis.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * cylinder3D.getLength())), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
            Vector3D normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinderAxis, (boolean)true);
            Point3D pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnAxis);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D3 = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected3 = new EuclidShape3DCollisionResult();
            expected3.setToNaN();
            expected3.setShapeA((Shape3DReadOnly)pointShape3D3);
            expected3.setShapeB((Shape3DReadOnly)cylinder3D);
            expected3.setShapesAreColliding(false);
            expected3.setSignedDistance(distance);
            expected3.getPointOnA().set(pointOutside);
            expected3.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected3.getPointOnB().set(pointOnSurface);
            expected3.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCylinder3DCollision((PointShape3DReadOnly)pointShape3D3, (Cylinder3DReadOnly)cylinder3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected3, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            cylinderAxis = cylinder3D.getAxis();
            double endSign = random.nextBoolean() ? -1.0 : 1.0;
            endCenter = new Point3D();
            endCenter.scaleAdd(0.5 * endSign * cylinder3D.getLength(), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinderAxis, (boolean)true);
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)endCenter);
            Vector3D normal = new Vector3D();
            normal.setAndScale(endSign, (Tuple3DReadOnly)cylinderAxis);
            normal.interpolate((Tuple3DReadOnly)orthogonalToAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnEdge);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)cylinder3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(distance);
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnEdge);
            expected.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCylinder3DCollision((PointShape3DReadOnly)pointShape3D, (Cylinder3DReadOnly)cylinder3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            cylinderAxis = cylinder3D.getAxis();
            double endSign = random.nextBoolean() ? -1.0 : 1.0;
            endCenter = new Point3D();
            endCenter.scaleAdd(0.5 * endSign * cylinder3D.getLength(), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
            Vector3D normal = new Vector3D();
            normal.setAndScale(endSign, (Tuple3DReadOnly)cylinderAxis);
            Plane3D endPlane = new Plane3D((Point3DReadOnly)endCenter, (Vector3DReadOnly)normal);
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinderAxis, (boolean)true);
            ArrayList<Point3D> regionToExplore = new ArrayList<Point3D>();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)endCenter);
            Point3D pointOnEdgeOpposideSide = new Point3D();
            pointOnEdgeOpposideSide.scaleAdd(-cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)endCenter);
            regionToExplore.add(pointOnEdge);
            regionToExplore.add(pointOnEdgeOpposideSide);
            if (cylinder3D.getRadius() < 0.5 * cylinder3D.getLength()) {
                Point3D farthestPointInside = new Point3D();
                maxDistanceIn = cylinder3D.getRadius();
                farthestPointInside.scaleAdd(-endSign * maxDistanceIn, (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)endCenter);
                regionToExplore.add(farthestPointInside);
            } else {
                Point3D farthestInsideCenter = new Point3D();
                maxDistanceIn = 0.5 * cylinder3D.getLength();
                farthestInsideCenter.scaleAdd(-endSign * maxDistanceIn, (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)endCenter);
                double radius = cylinder3D.getRadius() - 0.5 * cylinder3D.getLength();
                Point3D farthestInside1 = new Point3D();
                Point3D farthestInside2 = new Point3D();
                farthestInside1.scaleAdd(radius, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)farthestInsideCenter);
                farthestInside2.scaleAdd(-radius, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)farthestInsideCenter);
                regionToExplore.add(farthestInside1);
                regionToExplore.add(farthestInside2);
            }
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, regionToExplore);
            Point3D pointOnSurface = new Point3D();
            endPlane.orthogonalProjection((Point3DReadOnly)pointInside, (Point3DBasics)pointOnSurface);
            double distance = pointOnSurface.distance((Point3DReadOnly)pointInside);
            PointShape3D pointShape3D4 = new PointShape3D((Tuple3DReadOnly)pointInside);
            EuclidShape3DCollisionResult expected4 = new EuclidShape3DCollisionResult();
            expected4.setToNaN();
            expected4.setShapeA((Shape3DReadOnly)pointShape3D4);
            expected4.setShapeB((Shape3DReadOnly)cylinder3D);
            expected4.setShapesAreColliding(true);
            expected4.setSignedDistance(-distance);
            expected4.getPointOnA().set(pointInside);
            expected4.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected4.getPointOnB().set(pointOnSurface);
            expected4.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCylinder3DCollision((PointShape3DReadOnly)pointShape3D4, (Cylinder3DReadOnly)cylinder3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected4, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            cylinderAxis = cylinder3D.getAxis();
            Vector3D normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinderAxis, (boolean)true);
            Point3D centerOnSurface = new Point3D();
            centerOnSurface.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)cylinder3D.getPosition());
            ArrayList<Point3D> regionToExplore = new ArrayList<Point3D>();
            Point3D pointOnOneEnd = new Point3D();
            pointOnOneEnd.scaleAdd(0.5 * cylinder3D.getLength(), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)centerOnSurface);
            Point3D pointOnEdgeOtherEnd = new Point3D();
            pointOnEdgeOtherEnd.scaleAdd(-0.5 * cylinder3D.getLength(), (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)centerOnSurface);
            regionToExplore.add(pointOnOneEnd);
            regionToExplore.add(pointOnEdgeOtherEnd);
            if (cylinder3D.getRadius() < 0.5 * cylinder3D.getLength()) {
                double positionFromCenter = 0.5 * cylinder3D.getLength() - cylinder3D.getRadius();
                Point3D farthestInside1 = new Point3D();
                Point3D farthestInside2 = new Point3D();
                farthestInside1.scaleAdd(positionFromCenter, (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
                farthestInside2.scaleAdd(-positionFromCenter, (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)cylinder3D.getPosition());
                regionToExplore.add(farthestInside1);
                regionToExplore.add(farthestInside2);
            } else {
                Point3D farthestInside = new Point3D();
                double minDistanceFromAxis = cylinder3D.getRadius() - 0.5 * cylinder3D.getLength();
                farthestInside.scaleAdd(minDistanceFromAxis, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)cylinder3D.getPosition());
                regionToExplore.add(farthestInside);
            }
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, regionToExplore);
            Point3D pointOnSurface = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointInside, (Point3DReadOnly)centerOnSurface, (Vector3DReadOnly)normal);
            double distance = pointOnSurface.distance((Point3DReadOnly)pointInside);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)cylinder3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(-distance);
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnSurface);
            expected.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DCylinder3DCollision((PointShape3DReadOnly)pointShape3D, (Cylinder3DReadOnly)cylinder3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
    }

    @Test
    public void testPointShape3DEllipsoid3D() throws Exception {
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(54652L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.01, (double)1.0);
            Axis3D localAxis = Axis3D.values[random.nextInt(3)];
            double sign = random.nextBoolean() ? -1.0 : 1.0;
            double radius = localAxis.dot((Tuple3DReadOnly)ellipsoid3D.getRadii());
            Vector3D normal = new Vector3D();
            normal.setAndScale(sign, (Tuple3DReadOnly)EuclidShapeCollisionToolsTest.getAxis(localAxis, (Shape3DPoseReadOnly)ellipsoid3D.getPose()));
            Point3D pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(radius, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)ellipsoid3D.getPosition());
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)ellipsoid3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(distance);
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnSurface);
            expected.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DEllipsoid3DCollision((PointShape3DReadOnly)pointShape3D, (Ellipsoid3DReadOnly)ellipsoid3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
            Point3D pointInsideWorld = new Point3D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.9995);
            pointInsideWorld.interpolate((Tuple3DReadOnly)pointOnSurface, (Tuple3DReadOnly)ellipsoid3D.getPosition(), alpha);
            Point3D pointInsideLocal = new Point3D((Tuple3DReadOnly)pointInsideWorld);
            ellipsoid3D.transformToLocal((Transformable)pointInsideLocal);
            PointShape3D pointShape3D2 = new PointShape3D((Tuple3DReadOnly)pointInsideWorld);
            EuclidShape3DCollisionResult expected2 = new EuclidShape3DCollisionResult();
            expected2.setToNaN();
            expected2.setShapeA((Shape3DReadOnly)pointShape3D2);
            expected2.setShapeB((Shape3DReadOnly)ellipsoid3D);
            expected2.setShapesAreColliding(true);
            expected2.setSignedDistance(EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointInsideLocal, (Point3DBasics)expected2.getPointOnB()));
            ellipsoid3D.transformToWorld((Transformable)expected2.getPointOnB());
            expected2.getPointOnA().set(pointInsideWorld);
            expected2.getNormalOnB().sub((Tuple3DReadOnly)expected2.getPointOnB(), (Tuple3DReadOnly)pointInsideWorld);
            expected2.getNormalOnB().normalize();
            expected2.getNormalOnA().setAndNegate((Tuple3DReadOnly)expected2.getNormalOnB());
            EuclidShape3DCollisionResult actual2 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DEllipsoid3DCollision((PointShape3DReadOnly)pointShape3D2, (Ellipsoid3DReadOnly)ellipsoid3D, (EuclidShape3DCollisionResultBasics)actual2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)actual2, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.1, (double)1.0);
            Vector3D unitVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnSurface = new Point3D((Tuple3DReadOnly)unitVector);
            Vector3D normal = new Vector3D((Tuple3DReadOnly)unitVector);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            Point3D pointInside = new Point3D();
            pointInside.interpolate((Tuple3DReadOnly)pointOnSurface, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOnSurface.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            normal.scale(1.0 / ellipsoid3D.getRadiusX(), 1.0 / ellipsoid3D.getRadiusY(), 1.0 / ellipsoid3D.getRadiusZ());
            normal.normalize();
            pointOutside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            pointInside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            pointOnSurface.applyTransform((Transform)ellipsoid3D.getPose());
            normal.applyTransform((Transform)ellipsoid3D.getPose());
            pointOutside.applyTransform((Transform)ellipsoid3D.getPose());
            pointInside.applyTransform((Transform)ellipsoid3D.getPose());
            PointShape3D pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            Point3D pointOutsideLocal = new Point3D((Tuple3DReadOnly)pointOutside);
            ellipsoid3D.transformToLocal((Transformable)pointOutsideLocal);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)ellipsoid3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointOutsideLocal, (Point3DBasics)expected.getPointOnB()));
            ellipsoid3D.transformToWorld((Transformable)expected.getPointOnB());
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnB().sub((Tuple3DReadOnly)expected.getPointOnA(), (Tuple3DReadOnly)expected.getPointOnB());
            expected.getNormalOnB().normalize();
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)expected.getNormalOnB());
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DEllipsoid3DCollision((PointShape3DReadOnly)pointShape3D, (Ellipsoid3DReadOnly)ellipsoid3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            Point3D pointInsideLocal = new Point3D((Tuple3DReadOnly)pointInside);
            ellipsoid3D.transformToLocal((Transformable)pointInsideLocal);
            expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)ellipsoid3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointInsideLocal, (Point3DBasics)expected.getPointOnB()));
            ellipsoid3D.transformToWorld((Transformable)expected.getPointOnB());
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnB().sub((Tuple3DReadOnly)expected.getPointOnB(), (Tuple3DReadOnly)expected.getPointOnA());
            expected.getNormalOnB().normalize();
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)expected.getNormalOnB());
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DEllipsoid3DCollision((PointShape3DReadOnly)pointShape3D, (Ellipsoid3DReadOnly)ellipsoid3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
    }

    @Test
    public void testPointShape3DRamp3D() throws Exception {
        Vector3D bottomNormal;
        Point3D frontRightVertex;
        Vector3D rearNormal;
        Vector3D normal;
        Vector3D rampNormal;
        Point3D frontLeftVertex;
        Vector3D normal2;
        Vector3D rampNormal2;
        Vector3D rightNormal;
        Vector3D leftNormal;
        Point3D pointOnRightEdge;
        Point3D pointOnLeftEdge;
        Vector3D bottomNormal2;
        Vector3D normal3;
        Vector3D normal4;
        Point3D pointOnSurface;
        Ramp3D ramp3D;
        int i;
        Random random = new Random(346536L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnSurface = new Point3D();
            pointOnSurface.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOnSurface.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            ramp3D.getPose().transform((Point3DBasics)pointOnSurface);
            normal4 = new Vector3D();
            normal4.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnSurface, (Vector3DReadOnly)normal4);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnSurface = new Point3D();
            pointOnSurface.setX(ramp3D.getSizeX());
            pointOnSurface.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOnSurface.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.getPose().transform((Point3DBasics)pointOnSurface);
            normal4 = new Vector3D();
            normal4.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnSurface, (Vector3DReadOnly)normal4);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnSurface = new Point3D();
            double distanceOnSlope = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getRampLength());
            pointOnSurface.setX(distanceOnSlope * EuclidCoreTools.cos((double)ramp3D.getRampIncline()));
            pointOnSurface.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOnSurface.setZ(distanceOnSlope * EuclidCoreTools.sin((double)ramp3D.getRampIncline()));
            ramp3D.getPose().transform((Point3DBasics)pointOnSurface);
            normal3 = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)normal3);
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnSurface, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnFrontEdge = new Point3D();
            pointOnFrontEdge.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            ramp3D.getPose().transform((Point3DBasics)pointOnFrontEdge);
            Vector3D rampNormal3 = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal3);
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)rampNormal3, (Tuple3DReadOnly)bottomNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnFrontEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnLeftEdge = new Point3D();
            pointOnLeftEdge.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOnLeftEdge.setY(0.5 * ramp3D.getSizeY());
            ramp3D.getPose().transform((Point3DBasics)pointOnLeftEdge);
            Vector3D leftNormal2 = new Vector3D();
            leftNormal2.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)leftNormal2, (Tuple3DReadOnly)bottomNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnLeftEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnRightEdge = new Point3D();
            pointOnRightEdge.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOnRightEdge.setY(-0.5 * ramp3D.getSizeY());
            ramp3D.getPose().transform((Point3DBasics)pointOnRightEdge);
            Vector3D rightNormal2 = new Vector3D();
            rightNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)rightNormal2, (Tuple3DReadOnly)bottomNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnRightEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnRearEdge = new Point3D();
            pointOnRearEdge.setX(ramp3D.getSizeX());
            pointOnRearEdge.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            ramp3D.getPose().transform((Point3DBasics)pointOnRearEdge);
            Vector3D backNormal = new Vector3D();
            backNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)backNormal, (Tuple3DReadOnly)bottomNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnRearEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnLeftEdge = new Point3D();
            pointOnLeftEdge.setX(ramp3D.getSizeX());
            pointOnLeftEdge.setY(0.5 * ramp3D.getSizeY());
            pointOnLeftEdge.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.getPose().transform((Point3DBasics)pointOnLeftEdge);
            Vector3D backNormal = new Vector3D();
            backNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            leftNormal = new Vector3D();
            leftNormal.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)backNormal, (Tuple3DReadOnly)leftNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnLeftEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnRightEdge = new Point3D();
            pointOnRightEdge.setX(ramp3D.getSizeX());
            pointOnRightEdge.setY(-0.5 * ramp3D.getSizeY());
            pointOnRightEdge.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.getPose().transform((Point3DBasics)pointOnRightEdge);
            Vector3D backNormal = new Vector3D();
            backNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            rightNormal = new Vector3D();
            rightNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)backNormal, (Tuple3DReadOnly)rightNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnRightEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnTopEdge = new Point3D();
            pointOnTopEdge.setX(ramp3D.getSizeX());
            pointOnTopEdge.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOnTopEdge.setZ(ramp3D.getSizeZ());
            ramp3D.getPose().transform((Point3DBasics)pointOnTopEdge);
            Vector3D backNormal = new Vector3D();
            backNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            Vector3D rampNormal4 = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal4);
            normal3 = new Vector3D();
            normal3.interpolate((Tuple3DReadOnly)backNormal, (Tuple3DReadOnly)rampNormal4, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal3.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnTopEdge, (Vector3DReadOnly)normal3);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnLeftEdge = new Point3D();
            double distanceOnSlope = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getRampLength());
            pointOnLeftEdge.setX(distanceOnSlope * EuclidCoreTools.cos((double)ramp3D.getRampIncline()));
            pointOnLeftEdge.setY(0.5 * ramp3D.getSizeY());
            pointOnLeftEdge.setZ(distanceOnSlope * EuclidCoreTools.sin((double)ramp3D.getRampIncline()));
            ramp3D.getPose().transform((Point3DBasics)pointOnLeftEdge);
            Vector3D leftNormal3 = new Vector3D();
            leftNormal3.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            rampNormal2 = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal2);
            normal2 = new Vector3D();
            normal2.interpolate((Tuple3DReadOnly)leftNormal3, (Tuple3DReadOnly)rampNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal2.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnLeftEdge, (Vector3DReadOnly)normal2);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOnLeftEdge = new Point3D();
            double distanceOnSlope = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getRampLength());
            pointOnLeftEdge.setX(distanceOnSlope * EuclidCoreTools.cos((double)ramp3D.getRampIncline()));
            pointOnLeftEdge.setY(-0.5 * ramp3D.getSizeY());
            pointOnLeftEdge.setZ(distanceOnSlope * EuclidCoreTools.sin((double)ramp3D.getRampIncline()));
            ramp3D.getPose().transform((Point3DBasics)pointOnLeftEdge);
            Vector3D rightNormal3 = new Vector3D();
            rightNormal3.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            rampNormal2 = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal2);
            normal2 = new Vector3D();
            normal2.interpolate((Tuple3DReadOnly)rightNormal3, (Tuple3DReadOnly)rampNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal2.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)pointOnLeftEdge, (Vector3DReadOnly)normal2);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontLeftVertex = new Point3D();
            frontLeftVertex.setX(0.0);
            frontLeftVertex.setY(0.5 * ramp3D.getSizeY());
            frontLeftVertex.setZ(0.0);
            ramp3D.getPose().transform((Point3DBasics)frontLeftVertex);
            Vector3D leftNormal4 = new Vector3D();
            leftNormal4.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            rampNormal = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal);
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)bottomNormal2, (Tuple3DReadOnly)rampNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)leftNormal4, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontLeftVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontLeftVertex = new Point3D();
            frontLeftVertex.setX(0.0);
            frontLeftVertex.setY(-0.5 * ramp3D.getSizeY());
            frontLeftVertex.setZ(0.0);
            ramp3D.getPose().transform((Point3DBasics)frontLeftVertex);
            Vector3D rightNormal4 = new Vector3D();
            rightNormal4.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal2 = new Vector3D();
            bottomNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            rampNormal = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal);
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)bottomNormal2, (Tuple3DReadOnly)rampNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)rightNormal4, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontLeftVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontLeftVertex = new Point3D();
            frontLeftVertex.setX(ramp3D.getSizeX());
            frontLeftVertex.setY(0.5 * ramp3D.getSizeY());
            frontLeftVertex.setZ(ramp3D.getSizeZ());
            ramp3D.getPose().transform((Point3DBasics)frontLeftVertex);
            Vector3D leftNormal5 = new Vector3D();
            leftNormal5.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            rearNormal = new Vector3D();
            rearNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            rampNormal = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal);
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)rearNormal, (Tuple3DReadOnly)rampNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)leftNormal5, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontLeftVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontRightVertex = new Point3D();
            frontRightVertex.setX(ramp3D.getSizeX());
            frontRightVertex.setY(-0.5 * ramp3D.getSizeY());
            frontRightVertex.setZ(ramp3D.getSizeZ());
            ramp3D.getPose().transform((Point3DBasics)frontRightVertex);
            Vector3D rightNormal5 = new Vector3D();
            rightNormal5.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            rearNormal = new Vector3D();
            rearNormal.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            rampNormal = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)rampNormal);
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)rearNormal, (Tuple3DReadOnly)rampNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)rightNormal5, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontRightVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontRightVertex = new Point3D();
            frontRightVertex.setX(ramp3D.getSizeX());
            frontRightVertex.setY(0.5 * ramp3D.getSizeY());
            ramp3D.getPose().transform((Point3DBasics)frontRightVertex);
            Vector3D rearNormal2 = new Vector3D();
            rearNormal2.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            leftNormal = new Vector3D();
            leftNormal.set((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal = new Vector3D();
            bottomNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)bottomNormal, (Tuple3DReadOnly)rearNormal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)leftNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontRightVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            frontRightVertex = new Point3D();
            frontRightVertex.setX(ramp3D.getSizeX());
            frontRightVertex.setY(-0.5 * ramp3D.getSizeY());
            ramp3D.getPose().transform((Point3DBasics)frontRightVertex);
            Vector3D rearNormal3 = new Vector3D();
            rearNormal3.set((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            rightNormal = new Vector3D();
            rightNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            bottomNormal = new Vector3D();
            bottomNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            normal = new Vector3D();
            normal.interpolate((Tuple3DReadOnly)bottomNormal, (Tuple3DReadOnly)rearNormal3, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            normal.interpolate((Tuple3DReadOnly)rightNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            normal.normalize();
            EuclidShapeCollisionToolsTest.buildPointOutsideAndPerformAssertion(random, i, (Ramp3DReadOnly)ramp3D, (Point3DReadOnly)frontRightVertex, (Vector3DReadOnly)normal);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double halfWidth = 0.5 * ramp3D.getSizeY();
            Point3D bottomPoint = new Point3D(0.0, 0.0, 0.0);
            Point3D rearPoint = new Point3D(ramp3D.getSizeX(), 0.0, 0.0);
            Point3D slopePoint = new Point3D(0.0, 0.0, 0.0);
            Point3D leftPoint = new Point3D(0.0, halfWidth, 0.0);
            Point3D rightPoint = new Point3D(0.0, -halfWidth, 0.0);
            Arrays.asList(bottomPoint, rearPoint, slopePoint, leftPoint, rightPoint).forEach(arg_0 -> ((Shape3DPose)ramp3D.getPose()).transform(arg_0));
            Vector3D bottomNormal3 = new Vector3D();
            bottomNormal3.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            Vector3D rearNormal4 = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            Vector3D slopeNormal = new Vector3D();
            ramp3D.getRampSurfaceNormal((Vector3DBasics)slopeNormal);
            Vector3D leftNormal6 = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D rightNormal6 = new Vector3D();
            rightNormal6.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Plane3D bottomFace = new Plane3D((Point3DReadOnly)bottomPoint, (Vector3DReadOnly)bottomNormal3);
            Plane3D rearFace = new Plane3D((Point3DReadOnly)rearPoint, (Vector3DReadOnly)rearNormal4);
            Plane3D slopeFace = new Plane3D((Point3DReadOnly)slopePoint, (Vector3DReadOnly)slopeNormal);
            Plane3D leftFace = new Plane3D((Point3DReadOnly)leftPoint, (Vector3DReadOnly)leftNormal6);
            Plane3D rightFace = new Plane3D((Point3DReadOnly)rightPoint, (Vector3DReadOnly)rightNormal6);
            List<Plane3D> faces = Arrays.asList(bottomFace, rearFace, slopeFace, leftFace, rightFace);
            List<Point3D> vertices = Arrays.asList(new Point3D(0.0, -halfWidth, 0.0), new Point3D(0.0, halfWidth, 0.0), new Point3D(ramp3D.getSizeX(), -halfWidth, 0.0), new Point3D(ramp3D.getSizeX(), halfWidth, 0.0), new Point3D(ramp3D.getSizeX(), -halfWidth, ramp3D.getSizeZ()), new Point3D(ramp3D.getSizeX(), halfWidth, ramp3D.getSizeZ()));
            vertices.forEach(arg_0 -> ((Shape3DPose)ramp3D.getPose()).transform(arg_0));
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, vertices);
            Plane3D closestFace = (Plane3D)faces.stream().sorted((a, b) -> Double.compare(a.distance((Point3DReadOnly)pointInside), b.distance((Point3DReadOnly)pointInside))).findFirst().get();
            Point3DBasics pointOnSurface2 = closestFace.orthogonalProjectionCopy((Point3DReadOnly)pointInside);
            double depth = closestFace.distance((Point3DReadOnly)pointInside);
            PointShape3D pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)ramp3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(-depth);
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)closestFace.getNormal());
            expected.getPointOnB().set((Tuple3DReadOnly)pointOnSurface2);
            expected.getNormalOnB().set((Tuple3DReadOnly)closestFace.getNormal());
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DRamp3DCollision((PointShape3DReadOnly)pointShape3D, (Ramp3DReadOnly)ramp3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
    }

    private static void buildPointOutsideAndPerformAssertion(Random random, int iteration, Ramp3DReadOnly ramp3D, Point3DReadOnly pointOnShape, Vector3DReadOnly normal) {
        double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
        Point3D pointOutside = new Point3D();
        pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnShape);
        PointShape3D pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
        EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
        expected.setToNaN();
        expected.setShapeA((Shape3DReadOnly)pointShape3D);
        expected.setShapeB((Shape3DReadOnly)ramp3D);
        expected.setShapesAreColliding(false);
        expected.setSignedDistance(distance);
        expected.getPointOnA().set(pointOutside);
        expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
        expected.getPointOnB().set((Tuple3DReadOnly)pointOnShape);
        expected.getNormalOnB().set((Tuple3DReadOnly)normal);
        EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
        EuclidShapeCollisionTools.evaluatePointShape3DRamp3DCollision((PointShape3DReadOnly)pointShape3D, (Ramp3DReadOnly)ramp3D, (EuclidShape3DCollisionResultBasics)actual);
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + iteration + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
    }

    @Test
    public void testPointShape3DSphere3D() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            Sphere3D sphere3D = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Vector3D normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(sphere3D.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)sphere3D.getPosition());
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)sphere3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(distance);
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnSurface);
            expected.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DSphere3DCollision((PointShape3DReadOnly)pointShape3D, (Sphere3DReadOnly)sphere3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
            Point3D pointInside = new Point3D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.9995);
            pointInside.interpolate((Tuple3DReadOnly)pointOnSurface, (Tuple3DReadOnly)sphere3D.getPosition(), alpha);
            double distance2 = pointInside.distance((Point3DReadOnly)pointOnSurface);
            PointShape3D pointShape3D2 = new PointShape3D((Tuple3DReadOnly)pointInside);
            EuclidShape3DCollisionResult expected2 = new EuclidShape3DCollisionResult();
            expected2.setToNaN();
            expected2.setShapeA((Shape3DReadOnly)pointShape3D2);
            expected2.setShapeB((Shape3DReadOnly)sphere3D);
            expected2.setShapesAreColliding(true);
            expected2.setSignedDistance(-distance2);
            expected2.getPointOnA().set(pointInside);
            expected2.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected2.getPointOnB().set(pointOnSurface);
            expected2.getNormalOnB().set(normal);
            EuclidShape3DCollisionResult actual2 = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DSphere3DCollision((PointShape3DReadOnly)pointShape3D2, (Sphere3DReadOnly)sphere3D, (EuclidShape3DCollisionResultBasics)actual2);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected2, (EuclidShape3DCollisionResultReadOnly)actual2, (double)5.0E-10);
        }
    }

    @Test
    public void testPointShape3DTorus3D() throws Exception {
        EuclidShape3DCollisionResult actual;
        PointShape3D pointShape3D;
        Point3D pointOnSurface;
        Vector3D normal;
        Vector3D tubeDirection;
        Point3D pointOnTubeAxis;
        Vector3D orthogonalToAxis;
        UnitVector3DBasics torusAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(45645L);
        for (i = 0; i < 1000; ++i) {
            double distance;
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            torusAxis = torus3D.getAxis();
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torusAxis, (boolean)true);
            pointOnTubeAxis = new Point3D();
            pointOnTubeAxis.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeDirection = new Vector3D();
            tubeDirection.cross((Tuple3DReadOnly)torusAxis, (Tuple3DReadOnly)orthogonalToAxis);
            if (random.nextBoolean()) {
                tubeDirection.negate();
            }
            normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeDirection, (boolean)true);
            pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(torus3D.getTubeRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnTubeAxis);
            if (normal.dot((Tuple3DReadOnly)orthogonalToAxis) < 0.0) {
                double angle = orthogonalToAxis.angle((Vector3DReadOnly)normal);
                double maxDistance = torus3D.getRadius() / EuclidCoreTools.cos((double)angle) - torus3D.getTubeRadius();
                if (maxDistance < 0.0) {
                    --i;
                    continue;
                }
                distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)maxDistance);
            } else {
                distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            }
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnSurface);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointOutside);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)torus3D);
            expected.setShapesAreColliding(false);
            expected.setSignedDistance(distance);
            expected.getPointOnA().set(pointOutside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnSurface);
            expected.getNormalOnB().set(normal);
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DTorus3DCollision((PointShape3DReadOnly)pointShape3D, (Torus3DReadOnly)torus3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            torusAxis = torus3D.getAxis();
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torusAxis, (boolean)true);
            pointOnTubeAxis = new Point3D();
            pointOnTubeAxis.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeDirection = new Vector3D();
            tubeDirection.cross((Tuple3DReadOnly)torusAxis, (Tuple3DReadOnly)orthogonalToAxis);
            if (random.nextBoolean()) {
                tubeDirection.negate();
            }
            normal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeDirection, (boolean)true);
            pointOnSurface = new Point3D();
            pointOnSurface.scaleAdd(torus3D.getTubeRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnTubeAxis);
            Point3D pointInside = new Point3D();
            pointInside.interpolate((Tuple3DReadOnly)pointOnSurface, (Tuple3DReadOnly)pointOnTubeAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            double distance = pointOnSurface.distance((Point3DReadOnly)pointInside);
            pointShape3D = new PointShape3D((Tuple3DReadOnly)pointInside);
            EuclidShape3DCollisionResult expected = new EuclidShape3DCollisionResult();
            expected.setToNaN();
            expected.setShapeA((Shape3DReadOnly)pointShape3D);
            expected.setShapeB((Shape3DReadOnly)torus3D);
            expected.setShapesAreColliding(true);
            expected.setSignedDistance(-distance);
            expected.getPointOnA().set(pointInside);
            expected.getNormalOnA().setAndNegate((Tuple3DReadOnly)normal);
            expected.getPointOnB().set(pointOnSurface);
            expected.getNormalOnB().set(normal);
            actual = new EuclidShape3DCollisionResult();
            EuclidShapeCollisionTools.evaluatePointShape3DTorus3DCollision((PointShape3DReadOnly)pointShape3D, (Torus3DReadOnly)torus3D, (EuclidShape3DCollisionResultBasics)actual);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals((String)("Iteration: " + i + "\n"), (EuclidShape3DCollisionResultReadOnly)expected, (EuclidShape3DCollisionResultReadOnly)actual, (double)5.0E-10);
        }
    }

    public static Vector3DReadOnly getAxis(Axis3D axis, Shape3DPoseReadOnly shape3DPose) {
        switch (axis) {
            case X: {
                return shape3DPose.getXAxis();
            }
            case Y: {
                return shape3DPose.getYAxis();
            }
            case Z: {
                return shape3DPose.getZAxis();
            }
        }
        throw new RuntimeException("Unknown axis: " + axis);
    }

    public static Point3D getVertex(Bound xBound, Bound yBound, Bound zBound, Box3DReadOnly box3D) {
        double xShift = 0.5 * (xBound == Bound.MAX ? 1.0 : -1.0) * box3D.getSizeX();
        double yShift = 0.5 * (yBound == Bound.MAX ? 1.0 : -1.0) * box3D.getSizeY();
        double zShift = 0.5 * (zBound == Bound.MAX ? 1.0 : -1.0) * box3D.getSizeZ();
        Point3D vertex = new Point3D((Tuple3DReadOnly)box3D.getPosition());
        vertex.scaleAdd(xShift, (Tuple3DReadOnly)box3D.getPose().getXAxis(), (Tuple3DReadOnly)vertex);
        vertex.scaleAdd(yShift, (Tuple3DReadOnly)box3D.getPose().getYAxis(), (Tuple3DReadOnly)vertex);
        vertex.scaleAdd(zShift, (Tuple3DReadOnly)box3D.getPose().getZAxis(), (Tuple3DReadOnly)vertex);
        return vertex;
    }

    public static Plane3D getBox3DFacePlane(Axis3D axis, Bound bound, Box3DReadOnly box3D) {
        Plane3D facePlane = new Plane3D();
        Vector3D faceNormal = new Vector3D((Tuple3DReadOnly)axis);
        if (bound == Bound.MIN) {
            faceNormal.negate();
        }
        Point3D faceCenter = new Point3D();
        faceCenter.scaleAdd(faceNormal.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)axis, (Tuple3DReadOnly)faceCenter);
        faceCenter.scale(0.5);
        facePlane.set((Point3DReadOnly)faceCenter, (Vector3DReadOnly)faceNormal);
        facePlane.applyTransform((Transform)box3D.getPose());
        return facePlane;
    }

    public static Point3D[] getBox3DFaceVertices(Axis3D axis, Bound bound, Box3DReadOnly box3D) {
        Point3D[] faceVertices = new Point3D[4];
        Axis3D otherAxis1 = axis.previous();
        Axis3D otherAxis2 = otherAxis1.previous();
        for (int i = 0; i < 4; ++i) {
            Point3D vertex = new Point3D();
            if (bound == Bound.MAX) {
                vertex.scaleAdd(axis.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)axis, (Tuple3DReadOnly)vertex);
            } else {
                vertex.scaleAdd(-axis.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)axis, (Tuple3DReadOnly)vertex);
            }
            if ((i & 1) == 0) {
                vertex.scaleAdd(otherAxis1.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)otherAxis1, (Tuple3DReadOnly)vertex);
            } else {
                vertex.scaleAdd(-otherAxis1.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)otherAxis1, (Tuple3DReadOnly)vertex);
            }
            if ((i & 2) == 0) {
                vertex.scaleAdd(otherAxis2.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)otherAxis2, (Tuple3DReadOnly)vertex);
            } else {
                vertex.scaleAdd(-otherAxis2.dot((Tuple3DReadOnly)box3D.getSize()), (Tuple3DReadOnly)otherAxis2, (Tuple3DReadOnly)vertex);
            }
            vertex.scale(0.5);
            box3D.getPose().transform((Point3DBasics)vertex);
            faceVertices[i] = vertex;
        }
        return faceVertices;
    }
}

