/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.Matrix3DBasicsTest;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;

public class Matrix3DTest
extends Matrix3DBasicsTest<Matrix3D> {
    public static final double EPS = 1.0E-10;

    @Test
    public void testMatrix3D() {
        double[] matrixArray;
        int k;
        Random random = new Random(65431L);
        Matrix3D matrix = new Matrix3D();
        for (k = 0; k < 1000; ++k) {
            Matrix3D matrixCopy;
            matrixArray = new double[9];
            double[] matrixArrayCopy = new double[9];
            for (int i = 0; i < matrixArray.length; ++i) {
                matrixArray[i] = matrixArrayCopy[i] = random.nextDouble();
            }
            matrix = matrixCopy = new Matrix3D(matrixArray);
            Matrix3D expectedMatrix = new Matrix3D();
            expectedMatrix.set(matrixArray);
            for (int j = 0; j < matrixArray.length; ++j) {
                Assertions.assertTrue((matrixArray[j] == matrixArrayCopy[j] ? 1 : 0) != 0);
            }
            Assertions.assertTrue((matrix.getM00() == matrixArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM01() == matrixArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM02() == matrixArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM10() == matrixArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM11() == matrixArray[4] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM12() == matrixArray[5] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM20() == matrixArray[6] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM21() == matrixArray[7] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM22() == matrixArray[8] ? 1 : 0) != 0);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrixCopy, (double)1.0E-10);
        }
        for (int i = 0; i < 1000; ++i) {
            Matrix3D expectedMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrix = new Matrix3D(expectedMatrix.getM00(), expectedMatrix.getM01(), expectedMatrix.getM02(), expectedMatrix.getM10(), expectedMatrix.getM11(), expectedMatrix.getM12(), expectedMatrix.getM20(), expectedMatrix.getM21(), expectedMatrix.getM22());
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
        }
        for (k = 0; k < 1000; ++k) {
            matrixArray = new double[9];
            for (int i = 0; i < matrixArray.length; ++i) {
                matrixArray[i] = random.nextDouble();
            }
            matrix = new Matrix3D(matrixArray);
            Matrix3D matrix2 = new Matrix3D((Matrix3DReadOnly)matrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrix2, (double)1.0E-10);
            Assertions.assertTrue((matrix.getM00() == matrixArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM01() == matrixArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM02() == matrixArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM10() == matrixArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM11() == matrixArray[4] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM12() == matrixArray[5] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM20() == matrixArray[6] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM21() == matrixArray[7] ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM22() == matrixArray[8] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetToZero() {
        int column;
        int row;
        Random random = new Random(564L);
        Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertFalse((matrix.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        matrix.setToZero();
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((matrix.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        Matrix3D matrix = this.createRandomMatrix(random);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        double small = 0.999 * epsilon;
        double big = 1.001 * epsilon;
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00 + small, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01 + small, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02 + small, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10 + small, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11 + small, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12 + small, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20 + small, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 + small, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 + small), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00 - small, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01 - small, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02 - small, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10 - small, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11 - small, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12 - small, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20 - small, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 - small, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 - small), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00 + big, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01 + big, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02 + big, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10 + big, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11 + big, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12 + big, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20 + big, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 + big, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 + big), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00 - big, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01 - big, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02 - big, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10 - big, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11 - big, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12 - big, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20 - big, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 - big, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.geometricallyEquals((EuclidGeometry)this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 - big), epsilon));
    }

    @Override
    public Matrix3D createEmptyMatrix() {
        return new Matrix3D();
    }

    @Override
    public Matrix3D createMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return new Matrix3D(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    public Matrix3D createRandomMatrix(Random random) {
        return EuclidCoreRandomTools.nextMatrix3D((Random)random);
    }
}

