/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class CyclingConversionTest {
    private static final double EPSILON = 1.0E-12;
    private static final double EPSILON_WITH_YPR = 1.0E-11;
    private static final boolean DEBUG = false;

    @Test
    public void testCyclesIgnoringYawPitchRollWhenNaN() throws Exception {
        Random random = new Random(165416L);
        AllRotations[] rotationsToGoThrough = AllRotations.values();
        this.performConversionCycles(random, rotationsToGoThrough, 1000, 1000, 1.0E-11);
    }

    @Test
    public void testCyclesAllExceptYawPitchRoll() throws Exception {
        Random random = new Random(165416L);
        AllRotations[] rotationsToGoThrough = new AllRotations[]{AllRotations.QUATERNION, AllRotations.AXISANGLE, AllRotations.MATRIX, AllRotations.VECTOR};
        this.performConversionCycles(random, rotationsToGoThrough, 1000, 1000, 1.0E-12);
    }

    private void performConversionCycles(Random random, AllRotations[] rotationsToGoThrough, int numberOfCycles, int numberOfConversionsPerCycle, double epsilon) {
        boolean goingThroughYawPitchRoll = false;
        for (AllRotations allRotations : rotationsToGoThrough) {
            if (allRotations != AllRotations.YAW_PITCH_ROLL) continue;
            goingThroughYawPitchRoll = true;
        }
        for (int cycle = 0; cycle < numberOfCycles; ++cycle) {
            int initialIndex = random.nextInt(rotationsToGoThrough.length);
            AllRotations initialRotationType = rotationsToGoThrough[initialIndex];
            RotationMatrix originalMatrix = null;
            AxisAngle originalAxisAngle = null;
            Quaternion originalQuaternion = null;
            Vector3D originalRotationVector = null;
            YawPitchRoll originalYawPitchRoll = null;
            switch (initialRotationType) {
                case MATRIX: {
                    originalMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                    initialRotationType.rotationHolder = new RotationMatrix((Matrix3DReadOnly)originalMatrix);
                    break;
                }
                case AXISANGLE: {
                    originalAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
                    initialRotationType.rotationHolder = new AxisAngle((Orientation3DReadOnly)originalAxisAngle);
                    break;
                }
                case QUATERNION: {
                    originalQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
                    initialRotationType.rotationHolder = new Quaternion((QuaternionReadOnly)originalQuaternion);
                    break;
                }
                case VECTOR: {
                    originalRotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
                    initialRotationType.rotationHolder = new Vector3D((Tuple3DReadOnly)originalRotationVector);
                    break;
                }
                case YAW_PITCH_ROLL: {
                    originalYawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
                    initialRotationType.rotationHolder = new YawPitchRoll((Orientation3DReadOnly)originalYawPitchRoll);
                    break;
                }
                default: {
                    throw AllRotations.exception(initialRotationType);
                }
            }
            if (originalMatrix == null) {
                originalMatrix = initialRotationType.convertToMatrix();
            }
            if (originalAxisAngle == null) {
                originalAxisAngle = initialRotationType.convertToAxisAngle();
            }
            if (originalQuaternion == null) {
                originalQuaternion = initialRotationType.convertToQuaternion();
            }
            if (originalRotationVector == null) {
                originalRotationVector = initialRotationType.convertToRotationVector();
            }
            if (originalYawPitchRoll == null) {
                originalYawPitchRoll = initialRotationType.convertToYawPitchRoll();
            }
            boolean isYawPitchRollNaN = originalYawPitchRoll.containsNaN();
            AllRotations previousRotationType = initialRotationType;
            for (int i = 0; i < numberOfConversionsPerCycle; ++i) {
                int nextIndex = isYawPitchRollNaN && goingThroughYawPitchRoll ? random.nextInt(rotationsToGoThrough.length - 2) : random.nextInt(rotationsToGoThrough.length - 1);
                AllRotations nextRotationType = rotationsToGoThrough[nextIndex];
                if (nextIndex >= previousRotationType.ordinal()) {
                    nextRotationType = rotationsToGoThrough[nextIndex + 1];
                }
                nextRotationType.rotationHolder = previousRotationType.convertTo(nextRotationType);
                switch (nextRotationType) {
                    case MATRIX: {
                        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)originalMatrix, (Matrix3DReadOnly)((Matrix3DReadOnly)nextRotationType.rotationHolder), (double)epsilon);
                        break;
                    }
                    case AXISANGLE: {
                        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)originalAxisAngle, (Orientation3DReadOnly)((AxisAngleReadOnly)nextRotationType.rotationHolder), (double)epsilon);
                        break;
                    }
                    case QUATERNION: {
                        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)originalQuaternion, (Orientation3DReadOnly)((QuaternionReadOnly)nextRotationType.rotationHolder), (double)epsilon);
                        break;
                    }
                    case VECTOR: {
                        EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)originalRotationVector, (Vector3DReadOnly)((Vector3DReadOnly)nextRotationType.rotationHolder), (double)epsilon);
                        break;
                    }
                    case YAW_PITCH_ROLL: {
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)originalYawPitchRoll, (EuclidGeometry)((YawPitchRollReadOnly)nextRotationType.rotationHolder), (double)epsilon);
                    }
                }
                previousRotationType = nextRotationType;
            }
        }
    }

    private static enum AllRotations {
        MATRIX(new RotationMatrix()),
        AXISANGLE(new AxisAngle()),
        QUATERNION(new Quaternion()),
        VECTOR(new Vector3D()),
        YAW_PITCH_ROLL(new YawPitchRoll());

        Object rotationHolder;

        private AllRotations(Object rotationHolder) {
            this.rotationHolder = rotationHolder;
        }

        Object convertTo(AllRotations rotationTypeToConvertTo) {
            switch (rotationTypeToConvertTo) {
                case MATRIX: {
                    return this.convertToMatrix();
                }
                case AXISANGLE: {
                    return this.convertToAxisAngle();
                }
                case QUATERNION: {
                    return this.convertToQuaternion();
                }
                case VECTOR: {
                    return this.convertToRotationVector();
                }
                case YAW_PITCH_ROLL: {
                    return this.convertToYawPitchRoll();
                }
            }
            throw AllRotations.exception(this);
        }

        Matrix3DReadOnly convertToMatrix() {
            RotationMatrix matrix = new RotationMatrix();
            switch (this) {
                case MATRIX: {
                    matrix.set((Matrix3DReadOnly)this.rotationHolder);
                    break;
                }
                case AXISANGLE: {
                    RotationMatrixConversion.convertAxisAngleToMatrix((AxisAngleReadOnly)((AxisAngleReadOnly)this.rotationHolder), (CommonMatrix3DBasics)matrix);
                    break;
                }
                case QUATERNION: {
                    RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)((QuaternionReadOnly)this.rotationHolder), (CommonMatrix3DBasics)matrix);
                    break;
                }
                case VECTOR: {
                    RotationMatrixConversion.convertRotationVectorToMatrix((Vector3DReadOnly)((Vector3DReadOnly)this.rotationHolder), (CommonMatrix3DBasics)matrix);
                    break;
                }
                case YAW_PITCH_ROLL: {
                    RotationMatrixConversion.convertYawPitchRollToMatrix((YawPitchRollReadOnly)((YawPitchRollReadOnly)this.rotationHolder), (CommonMatrix3DBasics)matrix);
                    break;
                }
                default: {
                    throw AllRotations.exception(this);
                }
            }
            return matrix;
        }

        AxisAngleReadOnly convertToAxisAngle() {
            AxisAngle axisAngle = new AxisAngle();
            switch (this) {
                case MATRIX: {
                    AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)((RotationMatrixReadOnly)this.rotationHolder), (AxisAngleBasics)axisAngle);
                    break;
                }
                case AXISANGLE: {
                    axisAngle.set((AxisAngleReadOnly)this.rotationHolder);
                    break;
                }
                case QUATERNION: {
                    AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)((QuaternionReadOnly)this.rotationHolder), (AxisAngleBasics)axisAngle);
                    break;
                }
                case VECTOR: {
                    AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)((Vector3DReadOnly)this.rotationHolder), (AxisAngleBasics)axisAngle);
                    break;
                }
                case YAW_PITCH_ROLL: {
                    AxisAngleConversion.convertYawPitchRollToAxisAngle((YawPitchRollReadOnly)((YawPitchRollReadOnly)this.rotationHolder), (AxisAngleBasics)axisAngle);
                    break;
                }
                default: {
                    throw AllRotations.exception(this);
                }
            }
            return axisAngle;
        }

        QuaternionReadOnly convertToQuaternion() {
            Quaternion quaternion = new Quaternion();
            switch (this) {
                case MATRIX: {
                    QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)((RotationMatrixReadOnly)this.rotationHolder), (QuaternionBasics)quaternion);
                    break;
                }
                case AXISANGLE: {
                    QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)((AxisAngleReadOnly)this.rotationHolder), (QuaternionBasics)quaternion);
                    break;
                }
                case QUATERNION: {
                    quaternion.set((QuaternionReadOnly)this.rotationHolder);
                    break;
                }
                case VECTOR: {
                    QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)((Vector3DReadOnly)this.rotationHolder), (QuaternionBasics)quaternion);
                    break;
                }
                case YAW_PITCH_ROLL: {
                    QuaternionConversion.convertYawPitchRollToQuaternion((YawPitchRollReadOnly)((YawPitchRollReadOnly)this.rotationHolder), (QuaternionBasics)quaternion);
                    break;
                }
                default: {
                    throw AllRotations.exception(this);
                }
            }
            return quaternion;
        }

        Vector3DReadOnly convertToRotationVector() {
            Vector3D rotationVector = new Vector3D();
            switch (this) {
                case MATRIX: {
                    RotationVectorConversion.convertMatrixToRotationVector((RotationMatrixReadOnly)((RotationMatrixReadOnly)this.rotationHolder), (Vector3DBasics)rotationVector);
                    break;
                }
                case AXISANGLE: {
                    RotationVectorConversion.convertAxisAngleToRotationVector((AxisAngleReadOnly)((AxisAngleReadOnly)this.rotationHolder), (Vector3DBasics)rotationVector);
                    break;
                }
                case QUATERNION: {
                    RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)((QuaternionReadOnly)this.rotationHolder), (Vector3DBasics)rotationVector);
                    break;
                }
                case VECTOR: {
                    rotationVector.set((Tuple3DReadOnly)((Vector3DReadOnly)this.rotationHolder));
                    break;
                }
                case YAW_PITCH_ROLL: {
                    RotationVectorConversion.convertYawPitchRollToRotationVector((YawPitchRollReadOnly)((YawPitchRollReadOnly)this.rotationHolder), (Vector3DBasics)rotationVector);
                    break;
                }
                default: {
                    throw AllRotations.exception(this);
                }
            }
            return rotationVector;
        }

        YawPitchRollReadOnly convertToYawPitchRoll() {
            YawPitchRoll yawPitchRoll = new YawPitchRoll();
            switch (this) {
                case MATRIX: {
                    YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)((RotationMatrixReadOnly)this.rotationHolder), (YawPitchRollBasics)yawPitchRoll);
                    break;
                }
                case AXISANGLE: {
                    YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)((AxisAngleReadOnly)this.rotationHolder), (YawPitchRollBasics)yawPitchRoll);
                    break;
                }
                case QUATERNION: {
                    YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)((QuaternionReadOnly)this.rotationHolder), (YawPitchRollBasics)yawPitchRoll);
                    break;
                }
                case VECTOR: {
                    YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)((Vector3DReadOnly)this.rotationHolder), (YawPitchRollBasics)yawPitchRoll);
                    break;
                }
                case YAW_PITCH_ROLL: {
                    yawPitchRoll.set((YawPitchRollReadOnly)this.rotationHolder);
                    break;
                }
                default: {
                    throw AllRotations.exception(this);
                }
            }
            return yawPitchRoll;
        }

        private static RuntimeException exception(AllRotations badEnumValue) {
            return new RuntimeException("Should not get there, enum value: " + badEnumValue);
        }
    }
}

