/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.SingularValueDecomposition3DTest;
import us.ihmc.euclid.tools.SymmetricEigenDecomposition3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public class SymmetricEigenDecomposition3DTest {
    private static final boolean VERBOSE = false;
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void test() {
        int i;
        Random random = new Random(7634534L);
        SymmetricEigenDecomposition3D eigenEuclid = new SymmetricEigenDecomposition3D();
        long ejmlTotalTime = 0L;
        long euclidTotalTime = 0L;
        for (i = 0; i < 50000; ++i) {
            new SymmetricEigenDecomposition3D().decompose((Matrix3DReadOnly)EuclidCoreRandomTools.nextSymmetricMatrix3D((Random)random));
            SymmetricEigenDecomposition3DTest.ejmlEigenDecomposition((Matrix3DReadOnly)EuclidCoreRandomTools.nextSymmetricMatrix3D((Random)random), (Matrix3DBasics)new Matrix3D(), (Vector3DBasics)new Vector3D());
        }
        for (i = 0; i < 10000; ++i) {
            Matrix3D A = EuclidCoreRandomTools.nextSymmetricMatrix3D((Random)random, (double)5.0);
            long start = System.nanoTime();
            eigenEuclid.decompose((Matrix3DReadOnly)A);
            long end = System.nanoTime();
            euclidTotalTime += end - start;
            double varEpsilon = Math.max(1.0, Math.abs(A.determinant())) * 1.0E-12;
            Matrix3DBasics Qeuclid = eigenEuclid.getEigenVectors(null);
            Vector3D lambdaeuclid = eigenEuclid.getEigenValues();
            Matrix3D Qejml = new Matrix3D();
            Vector3D lambdaejml = new Vector3D();
            ejmlTotalTime += SymmetricEigenDecomposition3DTest.ejmlEigenDecomposition((Matrix3DReadOnly)A, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml);
            this.performAssertions(i, (Matrix3DReadOnly)A, Qeuclid, (Vector3DBasics)lambdaeuclid, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml, varEpsilon);
        }
        double euclidAverageMilllis = (double)euclidTotalTime / 1000000.0 / 10000.0;
        double ejmlAverageMilllis = (double)ejmlTotalTime / 1000000.0 / 10000.0;
    }

    @Test
    public void testBug1() {
        Matrix3D A = new Matrix3D(0.280869573417775, 0.22209595557825876, -0.20616245115304577, 0.22209595557825876, 0.4569467556886334, 0.14004653376258522, -0.20616245115304577, 0.14004653376258522, 0.47781756775292855);
        SymmetricEigenDecomposition3D eigenEuclid = new SymmetricEigenDecomposition3D();
        Assertions.assertTrue((boolean)eigenEuclid.decompose((Matrix3DReadOnly)A));
        double varEpsilon = Math.max(1.0, Math.abs(A.determinant())) * 1.0E-12;
        Matrix3DBasics Qeuclid = eigenEuclid.getEigenVectors(null);
        Vector3D lambdaeuclid = eigenEuclid.getEigenValues();
        Matrix3D Qejml = new Matrix3D();
        Vector3D lambdaejml = new Vector3D();
        SymmetricEigenDecomposition3DTest.ejmlEigenDecomposition((Matrix3DReadOnly)A, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml);
        this.performAssertions(0, (Matrix3DReadOnly)A, Qeuclid, (Vector3DBasics)lambdaeuclid, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml, varEpsilon);
    }

    @Test
    public void testBug2() {
        Matrix3D A = new Matrix3D(1.8570857023973861E-6, -5.783382514121337E-6, 0.0, -5.783382514121337E-6, 1.801075376406469E-5, 0.0, 0.0, 0.0, 0.003445569794329082);
        SymmetricEigenDecomposition3D eigenEuclid = new SymmetricEigenDecomposition3D();
        Assertions.assertTrue((boolean)eigenEuclid.decompose((Matrix3DReadOnly)A));
        Matrix3DBasics Qeuclid = eigenEuclid.getEigenVectors(null);
        Vector3D lambdaeuclid = eigenEuclid.getEigenValues();
        Matrix3D Qejml = new Matrix3D();
        Vector3D lambdaejml = new Vector3D();
        SymmetricEigenDecomposition3DTest.ejmlEigenDecomposition((Matrix3DReadOnly)A, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml);
        this.performAssertions(0, (Matrix3DReadOnly)A, Qeuclid, (Vector3DBasics)lambdaeuclid, (Matrix3DBasics)Qejml, (Vector3DBasics)lambdaejml, 1.0E-12);
    }

    private void performAssertions(int i, Matrix3DReadOnly A, Matrix3DBasics Qeuclid, Vector3DBasics lambdaeuclid, Matrix3DBasics Qejml, Vector3DBasics lambdaejml, double epsilon) {
        for (int col = 0; col < 3; ++col) {
            if (!(SingularValueDecomposition3DTest.columnDot(col, (Matrix3DReadOnly)Qejml, (Matrix3DReadOnly)Qeuclid) < 0.0)) continue;
            SingularValueDecomposition3DTest.negateColumn(col, Qejml);
        }
        Matrix3D A_output = new Matrix3D();
        A_output.set((Matrix3DReadOnly)Qeuclid);
        A_output.multiply((Matrix3DReadOnly)new Matrix3D(lambdaeuclid.getX(), 0.0, 0.0, 0.0, lambdaeuclid.getY(), 0.0, 0.0, 0.0, lambdaeuclid.getZ()));
        A_output.multiplyTransposeOther((Matrix3DReadOnly)Qeuclid);
        String messagePrefix = "Iteration: " + i;
        EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)A, (Matrix3DReadOnly)A_output, (double)epsilon);
        EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)lambdaejml, (EuclidGeometry)lambdaeuclid, (double)epsilon);
        if (EuclidCoreTools.epsilonEquals((double)lambdaejml.getX(), (double)lambdaejml.getY(), (double)epsilon)) {
            if (!EuclidCoreTools.epsilonEquals((double)lambdaejml.getY(), (double)lambdaejml.getZ(), (double)epsilon)) {
                Vector3D zColumnEJML = new Vector3D();
                Vector3D zColumnEuclid = new Vector3D();
                Qejml.getColumn(2, (Tuple3DBasics)zColumnEJML);
                Qeuclid.getColumn(2, (Tuple3DBasics)zColumnEuclid);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)zColumnEJML, (EuclidGeometry)zColumnEuclid, (double)epsilon);
            }
        } else if (!EuclidCoreTools.epsilonEquals((double)lambdaejml.getY(), (double)lambdaejml.getZ(), (double)epsilon)) {
            EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)Qejml, (Matrix3DReadOnly)Qeuclid, (double)epsilon);
        } else {
            Vector3D xColumnEJML = new Vector3D();
            Vector3D xColumnEuclid = new Vector3D();
            Qejml.getColumn(0, (Tuple3DBasics)xColumnEJML);
            Qeuclid.getColumn(0, (Tuple3DBasics)xColumnEuclid);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)xColumnEJML, (EuclidGeometry)xColumnEuclid, (double)epsilon);
        }
    }

    private static long ejmlEigenDecomposition(Matrix3DReadOnly A, Matrix3DBasics Q, Vector3DBasics lambda) {
        double tempDouble;
        int tempInt;
        DMatrixRMaj A_ejml = new DMatrixRMaj(3, 3);
        A.get((DMatrix)A_ejml);
        EigenDecomposition_F64 eigenEJML = DecompositionFactory_DDRM.eig((int)3, (boolean)true, (boolean)true);
        long start = System.nanoTime();
        eigenEJML.decompose((Matrix)A_ejml);
        long end = System.nanoTime();
        int[] order = new int[]{0, 1, 2};
        double rho0 = eigenEJML.getEigenvalue(0).getReal();
        double rho1 = eigenEJML.getEigenvalue(1).getReal();
        double rho2 = eigenEJML.getEigenvalue(2).getReal();
        if (Math.abs(rho0) < Math.abs(rho1)) {
            tempInt = order[0];
            order[0] = order[1];
            order[1] = tempInt;
            tempDouble = rho0;
            rho0 = rho1;
            rho1 = tempDouble;
        }
        if (Math.abs(rho0) < Math.abs(rho2)) {
            tempInt = order[0];
            order[0] = order[2];
            order[2] = tempInt;
            tempDouble = rho0;
            rho0 = rho2;
            rho2 = tempDouble;
        }
        if (Math.abs(rho1) < Math.abs(rho2)) {
            tempInt = order[1];
            order[1] = order[2];
            order[2] = tempInt;
        }
        int col = 0;
        for (int i : order) {
            lambda.setElement(col, eigenEJML.getEigenvalue(i).getReal());
            double x = ((DMatrixRMaj)eigenEJML.getEigenVector(i)).get(0);
            double y = ((DMatrixRMaj)eigenEJML.getEigenVector(i)).get(1);
            double z = ((DMatrixRMaj)eigenEJML.getEigenVector(i)).get(2);
            Q.setColumn(col, x, y, z);
            ++col;
        }
        return end - start;
    }
}

