/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class QuaternionToolsTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testDistance() throws Exception {
        int i;
        Random random = new Random(3212423L);
        for (i = 0; i < 1000; ++i) {
            Quaternion randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            RotationMatrix randomRotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion randomMatrixConverted = new Quaternion((Orientation3DReadOnly)randomRotationMatrix);
            double expectedDistance_1 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (RotationMatrixReadOnly)randomRotationMatrix);
            double actualDistance_1 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (QuaternionReadOnly)randomMatrixConverted, (boolean)true);
            YawPitchRoll randomYawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            Quaternion randomYawPitchRollConverted = new Quaternion((Orientation3DReadOnly)randomYawPitchRoll);
            double expectedDistance_2 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (QuaternionReadOnly)randomYawPitchRollConverted, (boolean)false);
            double actualDistance_2 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (YawPitchRollReadOnly)randomYawPitchRoll, (boolean)false);
            AxisAngle randomAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Quaternion randomAxisAngleConverted = new Quaternion((Orientation3DReadOnly)randomAxisAngle);
            double expectedDistance_3 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (QuaternionReadOnly)randomAxisAngleConverted, (boolean)false);
            double actualDistance_3 = QuaternionTools.distance((QuaternionReadOnly)randomQuaternion, (AxisAngleReadOnly)randomAxisAngle, (boolean)false);
            Assertions.assertEquals((double)actualDistance_1, (double)expectedDistance_1, (double)1.0E-12);
            Assertions.assertEquals((double)actualDistance_2, (double)expectedDistance_2, (double)1.0E-12);
            Assertions.assertEquals((double)actualDistance_3, (double)expectedDistance_3, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double withQuaternionResult = QuaternionTools.distance((QuaternionReadOnly)quaternion, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)orientation), (boolean)false);
            double withRotationMatrixResult = QuaternionTools.distance((QuaternionReadOnly)quaternion, (Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false);
            double notCastedResult = QuaternionTools.distance((QuaternionReadOnly)quaternion, (Orientation3DReadOnly)orientation, (boolean)false);
            if (Math.abs(notCastedResult) <= Math.PI) {
                Assertions.assertEquals((double)notCastedResult, (double)withRotationMatrixResult, (double)1.0E-12);
                continue;
            }
            Assertions.assertEquals((double)notCastedResult, (double)withQuaternionResult, (double)1.0E-12);
        }
        double min = Math.PI;
        double max = Math.PI * 2;
        for (int i2 = 0; i2 < 1000; ++i2) {
            double randomAngle = ThreadLocalRandom.current().nextDouble(min, max);
            AxisAngle aa1 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle distance = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            distance.setAngle(randomAngle);
            AxisAngle aa2 = new AxisAngle();
            AxisAngleTools.multiply((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)distance, (AxisAngleBasics)aa2);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double actual = QuaternionTools.distance((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (boolean)true);
            distance.setAngle(actual);
            AxisAngle aa3 = new AxisAngle();
            AxisAngleTools.multiply((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)distance, (AxisAngleBasics)aa3);
            Quaternion q3 = new Quaternion((Orientation3DReadOnly)aa3);
            distance.setAngle(-actual);
            AxisAngle aa4 = new AxisAngle();
            AxisAngleTools.multiply((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)distance, (AxisAngleBasics)aa4);
            Quaternion q4 = new Quaternion((Orientation3DReadOnly)aa4);
            Assertions.assertFalse((boolean)q2.geometricallyEquals((EuclidGeometry)q3, 1.0E-12));
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)q2, (Orientation3DReadOnly)q4, (double)1.0E-12);
            Orientation3DBasics orientation3D = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double distanceLimit = QuaternionTools.distance((QuaternionReadOnly)q1, (Orientation3DReadOnly)orientation3D, (boolean)true);
            double distanceNoLimit = QuaternionTools.distance((QuaternionReadOnly)q1, (Orientation3DReadOnly)orientation3D, (boolean)false);
            Assertions.assertTrue((distanceLimit <= Math.PI ? 1 : 0) != 0);
            Assertions.assertEquals((double)Math.abs(EuclidCoreTools.trimAngleMinusPiToPi((double)distanceNoLimit)), (double)distanceLimit, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Quaternion q;
        int i;
        Random random = new Random(394865L);
        Quaternion qExpected = new Quaternion();
        Quaternion qActual = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qNeutral = new Quaternion();
            Quaternion qNeutralCopy = new Quaternion();
            qExpected.set(q);
            QuaternionTools.multiply((QuaternionReadOnly)q, (QuaternionReadOnly)qNeutral, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)qNeutral.equals((EuclidGeometry)qNeutralCopy));
            QuaternionTools.multiply((QuaternionReadOnly)qNeutral, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qInv = new Quaternion((QuaternionReadOnly)q);
            qInv.conjugate();
            qExpected.setToZero();
            QuaternionTools.multiply((QuaternionReadOnly)q, (QuaternionReadOnly)qInv, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            QuaternionTools.multiply((QuaternionReadOnly)qInv, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double angle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Quaternion q1 = new Quaternion();
            Quaternion q2 = new Quaternion();
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle1, (QuaternionBasics)q1);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle2, (QuaternionBasics)q2);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(angle1 + angle2), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q1, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q2, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            QuaternionTools.multiply((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            QuaternionTools.multiply((QuaternionReadOnly)q2, (QuaternionReadOnly)q1, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (QuaternionBasics)qActual);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(2.0 * angle), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qActual, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            QuaternionTools.multiply((QuaternionReadOnly)qActual, (QuaternionReadOnly)qActual, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyConjugateLeft() throws Exception {
        Quaternion q;
        int i;
        Random random = new Random(394865L);
        Quaternion qExpected = new Quaternion();
        Quaternion qActual = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qNeutral = new Quaternion();
            Quaternion qNeutralCopy = new Quaternion();
            qExpected.set(q);
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)qNeutral, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)qNeutral.equals((EuclidGeometry)qNeutralCopy));
            qExpected.conjugate();
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q, (QuaternionReadOnly)qNeutral, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            q = new Quaternion();
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (QuaternionBasics)q);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(2.0 * angle), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qInv = new Quaternion((QuaternionReadOnly)q);
            qInv.conjugate();
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)qInv, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q, (QuaternionReadOnly)qInv, (QuaternionBasics)qActual);
            qExpected.conjugate();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double angle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Quaternion q1 = new Quaternion();
            Quaternion q2 = new Quaternion();
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle1, (QuaternionBasics)q1);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle2, (QuaternionBasics)q2);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(angle2 - angle1), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q1, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q2, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            qExpected.conjugate();
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q2, (QuaternionReadOnly)q1, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qActual, (double)1.0E-12);
            qExpected.setToZero();
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)qActual, (QuaternionReadOnly)qActual, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyConjugateRight() throws Exception {
        Quaternion q;
        int i;
        Random random = new Random(394865L);
        Quaternion qExpected = new Quaternion();
        Quaternion qActual = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qNeutral = new Quaternion();
            Quaternion qNeutralCopy = new Quaternion();
            qExpected.set(q);
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)q, (QuaternionReadOnly)qNeutral, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)qNeutral.equals((EuclidGeometry)qNeutralCopy));
            qExpected.conjugate();
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)qNeutral, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            q = new Quaternion();
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (QuaternionBasics)q);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(2.0 * angle), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            qActual = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qInv = new Quaternion((QuaternionReadOnly)q);
            qInv.conjugate();
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)q, (QuaternionReadOnly)qInv, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)qInv, (QuaternionReadOnly)q, (QuaternionBasics)qActual);
            qExpected.conjugate();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double angle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Quaternion q1 = new Quaternion();
            Quaternion q2 = new Quaternion();
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle1, (QuaternionBasics)q1);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle2, (QuaternionBasics)q2);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(angle1 - angle2), (QuaternionBasics)qExpected);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q1, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)q2, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qExpected, (double)1.0E-12);
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
            qExpected.conjugate();
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)q2, (QuaternionReadOnly)q1, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            QuaternionConversion.convertAxisAngleToQuaternion((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)qActual, (double)1.0E-12);
            qExpected.setToZero();
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)qActual, (QuaternionReadOnly)qActual, (QuaternionBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyWithVector4D() throws Exception {
        Quaternion qResult;
        Quaternion q2;
        Quaternion q1;
        int i;
        Random random = new Random(394865L);
        Vector4D vectorExpected = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        for (i = 0; i < 1000; ++i) {
            q1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            q2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            qResult = new Quaternion();
            QuaternionTools.multiply((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qResult);
            vectorExpected.set((Tuple4DReadOnly)qResult);
            QuaternionTools.multiply((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)vectorActual);
            if (vectorActual.dot((Tuple4DReadOnly)vectorExpected) < 0.0) {
                vectorActual.negate();
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            q1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            q2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            qResult = new Quaternion();
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qResult);
            vectorExpected.set((Tuple4DReadOnly)qResult);
            QuaternionTools.multiplyConjugateLeft((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)vectorActual);
            if (vectorActual.dot((Tuple4DReadOnly)vectorExpected) < 0.0) {
                vectorActual.negate();
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            q1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            q2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            qResult = new Quaternion();
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (QuaternionBasics)qResult);
            vectorExpected.set((Tuple4DReadOnly)qResult);
            QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)vectorActual);
            if (vectorActual.dot((Tuple4DReadOnly)vectorExpected) < 0.0) {
                vectorActual.negate();
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
        }
    }

    @Test
    public void testNormalizeAndLimitToPi() throws Exception {
        AxisAngle axisAngle;
        int i;
        Random random = new Random(3294862L);
        Quaternion qExpected = new Quaternion();
        Quaternion qActual = new Quaternion();
        for (i = 0; i < 10000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)Math.PI);
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)qExpected);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            qExpected.setUnsafe(qExpected.getX() * scale, qExpected.getY() * scale, qExpected.getZ() * scale, qExpected.getS() * scale);
            qActual.set(qExpected);
            qExpected.normalize();
            qActual.normalizeAndLimitToPi();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            double sign = random.nextBoolean() ? -1.0 : 1.0;
            axisAngle.setAngle(sign * EuclidCoreRandomTools.nextDouble((Random)random, (double)3.141592653590793, (double)(Math.PI * 2)));
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)qExpected);
            Assertions.assertTrue((qExpected.getS() < 0.0 ? 1 : 0) != 0);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            qExpected.setUnsafe(qExpected.getX() * scale, qExpected.getY() * scale, qExpected.getZ() * scale, qExpected.getS() * scale);
            qActual.set(qExpected);
            qExpected.normalize();
            qActual.normalizeAndLimitToPi();
            Assertions.assertFalse((boolean)qExpected.epsilonEquals((EuclidGeometry)qActual, 1.0E-12));
            Assertions.assertTrue((qExpected.dot((Tuple4DReadOnly)qActual) < 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((qActual.getS() > 0.0 ? 1 : 0) != 0);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)qActual, (AxisAngleBasics)axisAngle);
            Assertions.assertTrue((axisAngle.getAngle() < Math.PI && axisAngle.getAngle() > -Math.PI ? 1 : 0) != 0);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)qExpected, (AxisAngleBasics)axisAngle);
            Assertions.assertTrue((axisAngle.getAngle() > Math.PI || axisAngle.getAngle() < -Math.PI ? 1 : 0) != 0);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qExpected, (Orientation3DReadOnly)qActual, (double)1.0E-12);
        }
    }

    @Test
    public void testTransformATuple() throws Exception {
        Random random = new Random(4536L);
        Quaternion quaternion = new Quaternion();
        Vector3D tupleExpected = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleOriginal = new Vector3D();
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        quaternion.setToZero();
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        quaternion.set(0.0, 0.0, 0.0, -1.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setY(-tupleExpected.getY());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(1.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setY(-tupleExpected.getY());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(-1.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(0.0, 1.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(0.0, -1.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.set(0.0, 0.0, 1.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.set(0.0, 0.0, -1.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        for (int i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleActual.set(tupleOriginal);
            Vector4D pureQuaternion = new Vector4D();
            pureQuaternion.set(tupleOriginal.getX(), tupleOriginal.getY(), tupleOriginal.getZ(), 0.0);
            QuaternionTools.multiply((Tuple4DReadOnly)quaternion, (Tuple4DReadOnly)pureQuaternion, (Vector4DBasics)pureQuaternion);
            QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)pureQuaternion, (Tuple4DReadOnly)quaternion, (Vector4DBasics)pureQuaternion);
            tupleExpected.setX(pureQuaternion.getX());
            tupleExpected.setY(pureQuaternion.getY());
            tupleExpected.setZ(pureQuaternion.getZ());
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        }
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.setUnsafe(10.0, 10.0, 10.0, 10.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        Assertions.assertEquals((double)tupleExpected.norm(), (double)tupleActual.norm(), (double)1.0E-12);
    }

    @Test
    public void testInverseTransformATuple() throws Exception {
        int i;
        Random random = new Random(4536L);
        Quaternion quaternion = new Quaternion();
        Vector3D tupleExpected = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleOriginal = new Vector3D();
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        quaternion.setToZero();
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        quaternion.set(0.0, 0.0, 0.0, -1.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setY(-tupleExpected.getY());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(1.0, 0.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setY(-tupleExpected.getY());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(-1.0, 0.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(0.0, 1.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setZ(-tupleExpected.getZ());
        quaternion.set(0.0, -1.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.set(0.0, 0.0, 1.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.set(0.0, 0.0, -1.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleActual.set(tupleOriginal);
            Vector4D pureQuaternion = new Vector4D();
            pureQuaternion.set(tupleOriginal.getX(), tupleOriginal.getY(), tupleOriginal.getZ(), 0.0);
            QuaternionTools.multiplyConjugateLeft((Tuple4DReadOnly)quaternion, (Tuple4DReadOnly)pureQuaternion, (Vector4DBasics)pureQuaternion);
            QuaternionTools.multiply((Tuple4DReadOnly)pureQuaternion, (Tuple4DReadOnly)quaternion, (Vector4DBasics)pureQuaternion);
            tupleExpected.setX(pureQuaternion.getX());
            tupleExpected.setY(pureQuaternion.getY());
            tupleExpected.setZ(pureQuaternion.getZ());
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleActual.set(tupleExpected);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-12));
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-12));
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        }
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set(tupleExpected);
        tupleExpected.setX(-tupleExpected.getX());
        tupleExpected.setY(-tupleExpected.getY());
        quaternion.setUnsafe(10.0, 10.0, 10.0, 10.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
        Assertions.assertEquals((double)tupleExpected.norm(), (double)tupleActual.norm(), (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleExpected, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleExpected, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
    }

    @Test
    public void testAddTransformATuple() throws Exception {
        Quaternion quaternion;
        int i;
        Random random = new Random(28346L);
        Vector3D tupleExpected = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Vector3D tupleOriginal = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleActual.set((Tuple3DReadOnly)tupleExpected);
            Vector3D tupleTransformed = new Vector3D();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
            tupleExpected.add((Tuple3DReadOnly)tupleTransformed);
            double corrupt = random.nextDouble() + 0.5;
            double qx = corrupt * quaternion.getX();
            double qy = corrupt * quaternion.getY();
            double qz = corrupt * quaternion.getZ();
            double qs = corrupt * quaternion.getS();
            quaternion.setUnsafe(qx, qy, qz, qs);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.set((Tuple3DReadOnly)tupleActual);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleExpected);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        }
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set((Tuple3DReadOnly)tupleExpected);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.addTransform((QuaternionReadOnly)quaternion2, (Tuple3DReadOnly)tupleExpected, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
    }

    @Test
    public void testSubTransformATuple() throws Exception {
        Quaternion quaternion;
        int i;
        Random random = new Random(28346L);
        Vector3D tupleExpected = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Vector3D tupleOriginal = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
            tupleActual.set((Tuple3DReadOnly)tupleExpected);
            Vector3D tupleTransformed = new Vector3D();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
            tupleExpected.sub((Tuple3DReadOnly)tupleTransformed);
            double corrupt = random.nextDouble() + 0.5;
            double qx = corrupt * quaternion.getX();
            double qy = corrupt * quaternion.getY();
            double qz = corrupt * quaternion.getZ();
            double qs = corrupt * quaternion.getS();
            quaternion.setUnsafe(qx, qy, qz, qs);
            QuaternionTools.subTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.set((Tuple3DReadOnly)tupleActual);
            QuaternionTools.subTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleExpected);
            QuaternionTools.subTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
        }
        tupleExpected = EuclidCoreRandomTools.nextRotationVector((Random)random);
        tupleActual.set((Tuple3DReadOnly)tupleExpected);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.subTransform((QuaternionReadOnly)quaternion2, (Tuple3DReadOnly)tupleExpected, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
    }

    @Test
    public void testTransformATuple2D() throws Exception {
        Random random = new Random(2356L);
        Quaternion quaternion = new Quaternion();
        Vector2D tupleOriginal = new Vector2D();
        Vector2D tupleExpected = new Vector2D();
        Vector2D tupleActual = new Vector2D();
        quaternion.set(1.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException notAnOrientation2DException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        quaternion.set(0.0, 1.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        for (int i = 0; i < 1000; ++i) {
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Vector2D tupleOriginalCopy = new Vector2D((Tuple2DReadOnly)tupleOriginal);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            quaternion.setToZero();
            double corrupt = random.nextDouble() + 0.5;
            quaternion.setUnsafe(0.0, 0.0, EuclidCoreTools.sin((double)(yaw / 2.0)) * corrupt, EuclidCoreTools.cos((double)(yaw / 2.0)) * corrupt);
            tupleExpected.setX(EuclidCoreTools.cos((double)yaw) * tupleOriginal.getX() - EuclidCoreTools.sin((double)yaw) * tupleOriginal.getY());
            tupleExpected.setY(EuclidCoreTools.sin((double)yaw) * tupleOriginal.getX() + EuclidCoreTools.cos((double)yaw) * tupleOriginal.getY());
            tupleActual.set((Tuple2DReadOnly)tupleOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            tupleActual.setToZero();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)tupleOriginal.equals((EuclidGeometry)tupleOriginalCopy));
        }
        tupleExpected = EuclidCoreRandomTools.nextVector2D((Random)random);
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleExpected, (Tuple2DBasics)tupleActual, (boolean)false);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
    }

    @Test
    public void testInverseTransformATuple2D() throws Exception {
        Random random = new Random(2356L);
        Quaternion quaternion = new Quaternion();
        Vector2D tupleOriginal = new Vector2D();
        Vector2D tupleExpected = new Vector2D();
        Vector2D tupleActual = new Vector2D();
        quaternion.set(1.0, 0.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException notAnOrientation2DException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        quaternion.set(0.0, 1.0, 0.0, 0.0);
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        try {
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        catch (NotAnOrientation2DException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
        }
        for (int i = 0; i < 1000; ++i) {
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            quaternion.setToZero();
            quaternion.set(0.0, 0.0, EuclidCoreTools.sin((double)(yaw / 2.0)), EuclidCoreTools.cos((double)(yaw / 2.0)));
            tupleExpected.set((Tuple2DReadOnly)tupleOriginal);
            tupleActual.set((Tuple2DReadOnly)tupleOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            Vector2D tupleTransformed = new Vector2D();
            Vector2D tupleTransformedCopy = new Vector2D();
            tupleActual.setToZero();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed, (boolean)true);
            tupleTransformedCopy.set((Tuple2DReadOnly)tupleTransformed);
            Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tupleOriginal, (Tuple2DReadOnly)tupleTransformed, (double)1.0E-12));
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tupleTransformed, (Tuple2DBasics)tupleActual, (boolean)true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tupleExpected, (EuclidGeometry)tupleActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)tupleTransformed.equals((EuclidGeometry)tupleTransformedCopy));
        }
    }

    @Test
    public void testTransformAVector4D() throws Exception {
        Random random = new Random(35656L);
        Vector4D vectorOriginal = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        Vector4D vectorExpected = new Vector4D();
        for (int i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Vector3D vector3D = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), vectorOriginal.getZ());
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)vector3D, (Tuple3DBasics)vector3D);
            vectorExpected.set((Vector3DReadOnly)vector3D);
            vectorExpected.setS(vectorOriginal.getS());
            double corrupt = random.nextDouble() + 0.5;
            double qx = corrupt * quaternion.getX();
            double qy = corrupt * quaternion.getY();
            double qz = corrupt * quaternion.getZ();
            double qs = corrupt * quaternion.getS();
            quaternion.setUnsafe(qx, qy, qz, qs);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
            vectorActual.set(vectorOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorActual, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorActual, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorOriginal, (EuclidGeometry)vectorActual, (double)1.0E-12);
        }
        vectorExpected = EuclidCoreRandomTools.nextVector4D((Random)random);
        Quaternion quaternion = new Quaternion();
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorExpected, (Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-12);
    }

    @Test
    public void testTransformAQuaternion() throws Exception {
        Random random = new Random(2352L);
        Quaternion quaternion = new Quaternion();
        Quaternion quaternionOriginal = new Quaternion();
        Quaternion quaternionExpected = new Quaternion();
        Quaternion quaternionActual = new Quaternion();
        for (int i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            quaternionOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternionOriginal, (QuaternionBasics)quaternionExpected);
            Assertions.assertFalse((boolean)quaternionOriginal.epsilonEquals((EuclidGeometry)quaternionExpected, 1.0E-12));
            quaternionActual.set(quaternionOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternionActual, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            quaternionActual.setToNaN();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternionOriginal, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternionActual, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionOriginal, (EuclidGeometry)quaternionActual, (double)1.0E-12);
        }
    }

    @Test
    public void testTransformAMatrix() throws Exception {
        Random random = new Random(2352L);
        Quaternion quaternion = new Quaternion();
        RotationMatrix matrix = new RotationMatrix();
        Matrix3D matrixOriginal = new Matrix3D();
        Matrix3D matrixOriginalCopy = new Matrix3D();
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix.set((Orientation3DReadOnly)quaternion);
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrixOriginalCopy.set(matrixOriginal);
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrixOriginal, (CommonMatrix3DBasics)matrixExpected);
            Assertions.assertFalse((boolean)matrixExpected.epsilonEquals((EuclidGeometry)matrixOriginal, 1.0E-12));
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)matrixExpected);
            Assertions.assertFalse((boolean)matrixExpected.epsilonEquals((EuclidGeometry)matrixOriginal, 1.0E-12));
            double corrupt = random.nextDouble() + 0.5;
            double qx = corrupt * quaternion.getX();
            double qy = corrupt * quaternion.getY();
            double qz = corrupt * quaternion.getZ();
            double qs = corrupt * quaternion.getS();
            quaternion.setUnsafe(qx, qy, qz, qs);
            matrixActual.set(matrixOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixActual, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
            matrixActual.setToNaN();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)matrixOriginal.equals((EuclidGeometry)matrixOriginalCopy));
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixActual, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixOriginal, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
        }
        matrixExpected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        QuaternionTools.transform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixExpected, (Matrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
    }

    @Test
    public void testTransformARotationMatrix() throws Exception {
        Random random = new Random(345L);
        Quaternion quaternion = new Quaternion();
        RotationMatrix matrix = new RotationMatrix();
        RotationMatrix matrixOriginal = new RotationMatrix();
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix matrixActual = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix.set((Orientation3DReadOnly)quaternion);
            matrixOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)matrix, (RotationMatrixReadOnly)matrixOriginal, (CommonMatrix3DBasics)matrixExpected);
            Assertions.assertFalse((boolean)matrixExpected.epsilonEquals((EuclidGeometry)matrixOriginal, 1.0E-12));
            double corrupt = random.nextDouble() + 0.5;
            double qx = corrupt * quaternion.getX();
            double qy = corrupt * quaternion.getY();
            double qz = corrupt * quaternion.getZ();
            double qs = corrupt * quaternion.getS();
            quaternion.setUnsafe(qx, qy, qz, qs);
            matrixActual.set(matrixOriginal);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)matrixActual, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
            matrixActual.setToNaN();
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)matrixActual, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixOriginal, (Matrix3DReadOnly)matrixActual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyQuaternionMatrixResultPutInQuaternion() throws Exception {
        Quaternion conjugate;
        int i;
        Random random = new Random(3466L);
        Quaternion quaternion = new Quaternion();
        RotationMatrix matrix = new RotationMatrix();
        Quaternion quaternionExpected = new Quaternion();
        Quaternion quaternionActual = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix matrixCopy = new RotationMatrix((RotationMatrixReadOnly)matrix);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)matrix), (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (boolean)false, (Orientation3DReadOnly)matrix, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)matrix.equals((EuclidGeometry)matrixCopy));
            quaternionActual.set(quaternion);
            QuaternionTools.multiply((QuaternionReadOnly)quaternionActual, (boolean)false, (Orientation3DReadOnly)matrix, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)matrix.equals((EuclidGeometry)matrixCopy));
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            conjugate = new Quaternion((QuaternionReadOnly)quaternion);
            conjugate.conjugate();
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            QuaternionTools.multiply((QuaternionReadOnly)conjugate, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)matrix), (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (boolean)true, (Orientation3DReadOnly)matrix, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix transposed = new RotationMatrix((RotationMatrixReadOnly)matrix);
            transposed.transpose();
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)transposed), (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (boolean)false, (Orientation3DReadOnly)matrix, (boolean)true, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)quaternionExpected, (Orientation3DReadOnly)quaternionActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            conjugate = new Quaternion((QuaternionReadOnly)quaternion);
            conjugate.conjugate();
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix transposed = new RotationMatrix((RotationMatrixReadOnly)matrix);
            transposed.transpose();
            QuaternionTools.multiply((QuaternionReadOnly)conjugate, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)transposed), (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((QuaternionReadOnly)quaternion, (boolean)true, (Orientation3DReadOnly)matrix, (boolean)true, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)quaternionExpected, (Orientation3DReadOnly)quaternionActual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyMatrixQuaternionResultPutInQuaternion() throws Exception {
        Quaternion conjugate;
        int i;
        Random random = new Random(3466L);
        Quaternion quaternion = new Quaternion();
        RotationMatrix matrix = new RotationMatrix();
        Quaternion quaternionExpected = new Quaternion();
        Quaternion quaternionActual = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix matrixCopy = new RotationMatrix((RotationMatrixReadOnly)matrix);
            QuaternionTools.multiply((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)matrix), (QuaternionReadOnly)quaternion, (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((Orientation3DReadOnly)matrix, (boolean)false, (QuaternionReadOnly)quaternion, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)matrix.equals((EuclidGeometry)matrixCopy));
            quaternionActual.set(quaternion);
            QuaternionTools.multiply((Orientation3DReadOnly)matrix, (boolean)false, (QuaternionReadOnly)quaternionActual, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
            Assertions.assertTrue((boolean)matrix.equals((EuclidGeometry)matrixCopy));
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            conjugate = new Quaternion((QuaternionReadOnly)quaternion);
            conjugate.conjugate();
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            QuaternionTools.multiply((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)matrix), (QuaternionReadOnly)conjugate, (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((Orientation3DReadOnly)matrix, (boolean)false, (QuaternionReadOnly)quaternion, (boolean)true, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix transposed = new RotationMatrix((RotationMatrixReadOnly)matrix);
            transposed.transpose();
            QuaternionTools.multiply((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)transposed), (QuaternionReadOnly)quaternion, (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((Orientation3DReadOnly)matrix, (boolean)true, (QuaternionReadOnly)quaternion, (boolean)false, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)quaternionExpected, (Orientation3DReadOnly)quaternionActual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            conjugate = new Quaternion((QuaternionReadOnly)quaternion);
            conjugate.conjugate();
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix transposed = new RotationMatrix((RotationMatrixReadOnly)matrix);
            transposed.transpose();
            QuaternionTools.multiply((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)transposed), (QuaternionReadOnly)conjugate, (QuaternionBasics)quaternionExpected);
            QuaternionTools.multiply((Orientation3DReadOnly)matrix, (boolean)true, (QuaternionReadOnly)quaternion, (boolean)true, (QuaternionBasics)quaternionActual);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)quaternionExpected, (Orientation3DReadOnly)quaternionActual, (double)1.0E-12);
        }
    }
}

