/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public abstract class FramePose3DReadOnlyTest<T extends FramePose3DReadOnly> {
    public abstract T createFramePose(ReferenceFrame var1, Pose3DReadOnly var2);

    public final T createEmptyFramePose(ReferenceFrame referenceFrame) {
        return this.createFramePose(referenceFrame, (Pose3DReadOnly)new Pose3D());
    }

    public final T createRandomPose(Random random) {
        return this.createRandomFramePose(random, ReferenceFrame.getWorldFrame());
    }

    public final T createRandomFramePose(Random random, ReferenceFrame referenceFrame) {
        return this.createFramePose(referenceFrame, (Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random));
    }

    public final T createRandom2DFramePose(Random random, ReferenceFrame referenceFrame) {
        Pose3D pose = new Pose3D();
        pose.getOrientation().setYawPitchRoll(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), 0.0, 0.0);
        pose.getPosition().set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
        return this.createFramePose(referenceFrame, (Pose3DReadOnly)pose);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFramePose, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        for (Method method : Transform.class.getDeclaredMethods()) {
            signaturesToIgnore.add(new MethodSignature(method.getName(), (Class[])method.getParameterTypes()));
        }
        for (Method method : RigidBodyTransformReadOnly.class.getDeclaredMethods()) {
            signaturesToIgnore.add(new MethodSignature(method.getName(), (Class[])method.getParameterTypes()));
        }
        for (Method method : RigidBodyTransformBasics.class.getDeclaredMethods()) {
            signaturesToIgnore.add(new MethodSignature(method.getName(), (Class[])method.getParameterTypes()));
        }
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePose3DReadOnly.class, Pose3DReadOnly.class, true, 1, methodFilter);
    }
}

