/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.Location;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class EuclidGeometryToolsTest {
    private static final double EPSILON = 1.0E-12;
    private static final double LARGE_EPSILON = 3.0E-8;

    @Test
    public void testAngleFromFirstToSecondVector2D() throws Exception {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D firstVector = EuclidCoreRandomTools.nextVector2D((Random)random);
            Vector2D secondVector = EuclidCoreRandomTools.nextVector2D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedAngle = firstVector.angle((Vector2DReadOnly)secondVector);
            double actualAngle = EuclidGeometryTools.angleFromFirstToSecondVector2D((double)firstVector.getX(), (double)firstVector.getY(), (double)secondVector.getX(), (double)secondVector.getY());
            EuclidCoreTestTools.assertAngleEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleFromXForwardToVector2D() throws Exception {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D xForward = new Vector2D(1.0, 0.0);
            Vector2D vector = EuclidCoreRandomTools.nextVector2D((Random)random);
            vector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedAngle = xForward.angle((Vector2DReadOnly)vector);
            double actualAngle = EuclidGeometryTools.angleFromXForwardToVector2D((Vector2DReadOnly)vector);
            EuclidCoreTestTools.assertAngleEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
            actualAngle = EuclidGeometryTools.angleFromXForwardToVector2D((double)vector.getX(), (double)vector.getY());
            EuclidCoreTestTools.assertAngleEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleFromFirstToSecondVector3D() throws Exception {
        double expectedAngle;
        Vector3D firstVector;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D secondVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedAngle = firstVector.angle((Vector3DReadOnly)secondVector);
            double actualAngle = EuclidGeometryTools.angleFromFirstToSecondVector3D((double)firstVector.getX(), (double)firstVector.getY(), (double)firstVector.getZ(), (double)secondVector.getX(), (double)secondVector.getY(), (double)secondVector.getZ());
            EuclidCoreTestTools.assertAngleEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0));
            Vector3D axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)3.1315926535897933);
            if (random.nextBoolean()) {
                expectedAngle = -expectedAngle;
            }
            Vector3D secondVector = new Vector3D();
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, expectedAngle));
            rotationMatrix.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            double actualAngle = EuclidGeometryTools.angleFromFirstToSecondVector3D((double)firstVector.getX(), (double)firstVector.getY(), (double)firstVector.getZ(), (double)secondVector.getX(), (double)secondVector.getY(), (double)secondVector.getZ());
            Assertions.assertEquals((double)Math.abs(expectedAngle), (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAreLine2DsCollinear() throws Exception {
        int i;
        Random random = new Random(232L);
        for (i = 0; i < 1000; ++i) {
            Vector2D lineDirection1 = EuclidCoreRandomTools.nextVector2D((Random)random);
            lineDirection1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            Vector2D lineDirection2 = new Vector2D();
            RotationMatrixTools.applyYawRotation((double)rotationAngle, (Tuple2DReadOnly)lineDirection1, (Tuple2DBasics)lineDirection2);
            lineDirection2.normalize();
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Point2D firstPointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D secondPointOnLine1 = new Point2D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)firstPointOnLine1);
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection1);
            orthogonal.normalize();
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double distanceEspilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D firstPointOnLine2 = new Point2D();
            firstPointOnLine2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)firstPointOnLine1);
            Point2D secondPointOnLine2 = new Point2D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            boolean expectedCollinear = rotationAngle < angleEpsilon && distance < distanceEspilon;
            boolean actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Vector2DReadOnly)lineDirection2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            orthogonal.normalize();
            double angleEpsilon = 1.0E-6;
            Point2D firstPointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D secondPointOnLine1 = new Point2D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)firstPointOnLine1);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double distanceEspilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D firstPointOnLine2 = new Point2D();
            firstPointOnLine2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)firstPointOnLine1);
            Point2D secondPointOnLine2 = new Point2D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)firstPointOnLine2);
            firstPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)firstPointOnLine2);
            boolean expectedCollinear = distance < distanceEspilon;
            boolean actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)firstPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)firstPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
        }
    }

    @Test
    public void testAreLine3DsCollinear() throws Exception {
        int i;
        Random random = new Random(2312L);
        for (i = 0; i < 1000; ++i) {
            Vector3D lineDirection1 = EuclidCoreRandomTools.nextRotationVector((Random)random);
            lineDirection1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection1, (boolean)true);
            AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)orthogonal, rotationAngle);
            Vector3D lineDirection2 = new Vector3D();
            axisAngle.transform((Tuple3DReadOnly)lineDirection1, (Tuple3DBasics)lineDirection2);
            lineDirection2.normalize();
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Point3D firstPointOnLine1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D secondPointOnLine1 = new Point3D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)firstPointOnLine1);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double distanceEspilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D firstPointOnLine2 = new Point3D();
            firstPointOnLine2.scaleAdd(distance, (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)firstPointOnLine1);
            Point3D secondPointOnLine2 = new Point3D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)firstPointOnLine2);
            boolean expectedCollinear = rotationAngle < angleEpsilon && distance < distanceEspilon;
            boolean actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)firstPointOnLine2, (Vector3DReadOnly)lineDirection2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D lineDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection, (boolean)true);
            double angleEpsilon = 1.0E-6;
            Point3D firstPointOnLine1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D secondPointOnLine1 = new Point3D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine1);
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double distanceEspilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D firstPointOnLine2 = new Point3D();
            firstPointOnLine2.scaleAdd(distance, (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)firstPointOnLine1);
            Point3D secondPointOnLine2 = new Point3D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine2);
            firstPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine2);
            boolean expectedCollinear = distance < distanceEspilon;
            boolean actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)firstPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)firstPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
            actualCollinear = EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine1, (double)angleEpsilon, (double)distanceEspilon);
            Assertions.assertEquals((Object)expectedCollinear, (Object)actualCollinear);
        }
    }

    @Test
    public void testArePlane3DsCoincident() throws Exception {
        Random random = new Random(232L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnPlane2 = new Point3D();
            Vector3D planeNormal2 = new Vector3D();
            double distanceEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double distanceBetweenPlanes = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            pointOnPlane2.scaleAdd(distanceBetweenPlanes, (Tuple3DReadOnly)planeNormal1, (Tuple3DReadOnly)pointOnPlane1);
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal1, (boolean)true);
            double angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            AxisAngle rotationAxisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle);
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.set((Orientation3DReadOnly)rotationAxisAngle);
            rotationMatrix.transform((Tuple3DReadOnly)planeNormal1, (Tuple3DBasics)planeNormal2);
            boolean expectedCoincidentResult = Math.abs(distanceBetweenPlanes) < distanceEpsilon && rotationAngle < angleEpsilon;
            boolean actualCoincidentResult = EuclidGeometryTools.arePlane3DsCoincident((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)angleEpsilon, (double)distanceEpsilon);
            Assertions.assertEquals((Object)expectedCoincidentResult, (Object)actualCoincidentResult);
        }
    }

    @Test
    public void testAreVector2DsParallel() throws Exception {
        Vector2D secondVector;
        double rotationAngle;
        double angleEpsilon;
        Vector2D firstVector;
        int i;
        Random random = new Random(232L);
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector2D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            secondVector = new Vector2D();
            RotationMatrixTools.applyYawRotation((double)rotationAngle, (Tuple2DReadOnly)firstVector, (Tuple2DBasics)secondVector);
            secondVector.normalize();
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector, (double)angleEpsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector2D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948965E-6);
            rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948965E-6);
            if (Math.abs(rotationAngle - angleEpsilon) < 1.0E-7) continue;
            secondVector = new Vector2D();
            RotationMatrixTools.applyYawRotation((double)rotationAngle, (Tuple2DReadOnly)firstVector, (Tuple2DBasics)secondVector);
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector, (double)angleEpsilon));
        }
        Vector2D unitVector = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
        firstVector = new Vector2D((Tuple2DReadOnly)unitVector);
        Vector2D secondVector2 = new Vector2D((Tuple2DReadOnly)unitVector);
        firstVector.scale(9.0E-8);
        Assertions.assertFalse((boolean)EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector2, (double)1.5707963267948966));
        Assertions.assertFalse((boolean)EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)secondVector2, (Vector2DReadOnly)firstVector, (double)1.5707963267948966));
        EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector2, (double)0.0);
        try {
            EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector2, (double)-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector2, (double)1.5707963267948968);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAreVector3DsParallel() throws Exception {
        Vector3D secondVector;
        RotationMatrix rotationMatrix;
        AxisAngle rotationAxisAngle;
        double rotationAngle;
        double angleEpsilon;
        Vector3D rotationAxis;
        Vector3D firstVector;
        int i;
        Random random = new Random(232L);
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            rotationAxisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle);
            rotationMatrix = new RotationMatrix();
            rotationMatrix.set((Orientation3DReadOnly)rotationAxisAngle);
            secondVector = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            secondVector.normalize();
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (double)angleEpsilon));
            secondVector.negate();
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (double)angleEpsilon));
            firstVector.negate();
            secondVector.negate();
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (double)angleEpsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.normalize();
            rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            angleEpsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948965E-6);
            rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948965E-6);
            if (Math.abs(rotationAngle - angleEpsilon) < 1.0E-7) continue;
            rotationAxisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle);
            rotationMatrix = new RotationMatrix();
            rotationMatrix.set((Orientation3DReadOnly)rotationAxisAngle);
            secondVector = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            Assertions.assertEquals((Object)(rotationAngle < angleEpsilon ? 1 : 0), (Object)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (double)angleEpsilon));
        }
        Vector3D unitVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        firstVector = new Vector3D((Tuple3DReadOnly)unitVector);
        Vector3D secondVector2 = new Vector3D((Tuple3DReadOnly)unitVector);
        firstVector.scale(9.0E-8);
        Assertions.assertFalse((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector2, (double)1.5707963267948966));
        Assertions.assertFalse((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)secondVector2, (Vector3DReadOnly)firstVector, (double)1.5707963267948966));
        EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector2, (double)0.0);
        try {
            EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector2, (double)-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector2, (double)1.5707963267948968);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAveragePoint2Ds() throws Exception {
        Assertions.assertNull((Object)EuclidGeometryTools.averagePoint2Ds(new ArrayList()));
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Point2D a = new Point2D(1.0, 4.6);
        Point2D b = new Point2D(5.2, 6.0);
        Point2D c = new Point2D(3.7, 2.0);
        points.add(a);
        points.add(b);
        points.add(c);
        double expectedReturn1 = 3.3;
        double expectedReturn2 = 4.2;
        Point2D actualReturn = EuclidGeometryTools.averagePoint2Ds(points);
        double actualReturn1 = actualReturn.getX();
        double actualReturn2 = actualReturn.getY();
        Assertions.assertEquals((double)expectedReturn1, (double)actualReturn1, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn2, (double)actualReturn2, (double)1.0E-12, (String)"return value");
        ArrayList<Point2D> points1 = new ArrayList<Point2D>();
        Point2D a1 = new Point2D(0.0, 0.0);
        Point2D b1 = new Point2D(0.0, 0.0);
        Point2D c1 = new Point2D(0.0, 0.0);
        points1.add(a1);
        points1.add(b1);
        points1.add(c1);
        double expectedReturn11 = 0.0;
        double expectedReturn12 = 0.0;
        Point2D actualReturn01 = EuclidGeometryTools.averagePoint2Ds(points1);
        double actualReturn11 = actualReturn01.getX();
        double actualReturn12 = actualReturn01.getY();
        Assertions.assertEquals((double)expectedReturn11, (double)actualReturn11, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn12, (double)actualReturn12, (double)1.0E-12, (String)"return value");
        ArrayList<Point2D> points2 = new ArrayList<Point2D>();
        Point2D a2 = new Point2D(-1.0, -4.6);
        Point2D b2 = new Point2D(-5.2, -6.0);
        Point2D c2 = new Point2D(-3.7, -2.0);
        points2.add(a2);
        points2.add(b2);
        points2.add(c2);
        double expectedReturn21 = -3.3;
        double expectedReturn22 = -4.2;
        Point2D actualReturn02 = EuclidGeometryTools.averagePoint2Ds(points2);
        double actualReturn21 = actualReturn02.getX();
        double actualReturn22 = actualReturn02.getY();
        Assertions.assertEquals((double)expectedReturn21, (double)actualReturn21, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn22, (double)actualReturn22, (double)1.0E-12, (String)"return value");
    }

    @Test
    public void testAveragePoint3Ds() throws Exception {
        Assertions.assertNull((Object)EuclidGeometryTools.averagePoint3Ds(new ArrayList()));
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        Point3D a = new Point3D(4.3, 5.6, 3.6);
        Point3D b = new Point3D(8.1, 8.4, 0.0);
        Point3D c = new Point3D(5.6, 1.0, 4.5);
        points.add(a);
        points.add(b);
        points.add(c);
        double expectedReturn1 = 6.0;
        double expectedReturn2 = 5.0;
        double expectedReturn3 = 2.7;
        Point3D actualReturn = EuclidGeometryTools.averagePoint3Ds(points);
        double actualReturn1 = actualReturn.getX();
        double actualReturn2 = actualReturn.getY();
        double actualReturn3 = actualReturn.getZ();
        Assertions.assertEquals((double)expectedReturn1, (double)actualReturn1, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn2, (double)actualReturn2, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn3, (double)actualReturn3, (double)1.0E-12, (String)"return value");
        ArrayList<Point3D> points1 = new ArrayList<Point3D>();
        Point3D a1 = new Point3D(0.0, 0.0, 0.0);
        Point3D b1 = new Point3D(0.0, 0.0, 0.0);
        Point3D c1 = new Point3D(0.0, 0.0, 0.0);
        points1.add(a1);
        points1.add(b1);
        points1.add(c1);
        double expectedReturn11 = 0.0;
        double expectedReturn12 = 0.0;
        double expectedReturn13 = 0.0;
        Point3D actualReturn01 = EuclidGeometryTools.averagePoint3Ds(points1);
        double actualReturn11 = actualReturn01.getX();
        double actualReturn12 = actualReturn01.getY();
        double actualReturn13 = actualReturn01.getZ();
        Assertions.assertEquals((double)expectedReturn11, (double)actualReturn11, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn12, (double)actualReturn12, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn13, (double)actualReturn13, (double)1.0E-12, (String)"return value");
    }

    @Test
    public void testAverageTwoPoint3Ds() throws Exception {
        Point3D a = new Point3D(5.8, 9.9, 4.5);
        Point3D b = new Point3D(5.6, 8.1, 5.5);
        double expectedReturn1 = 5.7;
        double expectedReturn2 = 9.0;
        double expectedReturn3 = 5.0;
        Point3D actualReturn = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)a, (Point3DReadOnly)b);
        double actualReturn1 = actualReturn.getX();
        double actualReturn2 = actualReturn.getY();
        double actualReturn3 = actualReturn.getZ();
        Assertions.assertEquals((double)expectedReturn1, (double)actualReturn1, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn2, (double)actualReturn2, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn3, (double)actualReturn3, (double)1.0E-12, (String)"return value");
        Point3D a1 = new Point3D(-5.0, -5.0, -5.0);
        Point3D b1 = new Point3D(-5.0, -5.0, -5.0);
        double expectedReturn11 = -5.0;
        double expectedReturn12 = -5.0;
        double expectedReturn13 = -5.0;
        Point3D actualReturn01 = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)a1, (Point3DReadOnly)b1);
        double actualReturn11 = actualReturn01.getX();
        double actualReturn12 = actualReturn01.getY();
        double actualReturn13 = actualReturn01.getZ();
        Assertions.assertEquals((double)expectedReturn11, (double)actualReturn11, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn12, (double)actualReturn12, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn13, (double)actualReturn13, (double)1.0E-12, (String)"return value");
        Point3D a2 = new Point3D(0.0, 0.0, 0.0);
        Point3D b2 = new Point3D(0.0, 0.0, 0.0);
        double expectedReturn21 = 0.0;
        double expectedReturn22 = 0.0;
        double expectedReturn23 = 0.0;
        Point3D actualReturn02 = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)a2, (Point3DReadOnly)b2);
        double actualReturn21 = actualReturn02.getX();
        double actualReturn22 = actualReturn02.getY();
        double actualReturn23 = actualReturn02.getZ();
        Assertions.assertEquals((double)expectedReturn21, (double)actualReturn21, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn22, (double)actualReturn22, (double)1.0E-12, (String)"return value");
        Assertions.assertEquals((double)expectedReturn23, (double)actualReturn23, (double)1.0E-12, (String)"return value");
    }

    @Test
    public void testOrientation3DFromZUpToVector3D() throws Exception {
        Random random = new Random(3465764L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D vector = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI);
            Vector3D expectedAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)true);
            Quaternion expectedQuaternion = new Quaternion();
            expectedQuaternion.set((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)expectedAxis, expectedAngle));
            expectedQuaternion.transform((Tuple3DBasics)vector);
            vector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0));
            Quaternion actualQuaternion = new Quaternion();
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)vector, (Orientation3DBasics)actualQuaternion);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)actualQuaternion, (double)1.0E-12);
        }
    }

    @Test
    public void testAxisAngleFromFirstToSecondVector3D() throws Exception {
        AxisAngle expectedAxisAngle;
        Vector3D expectedAxis;
        double expectedAngle;
        Vector3D actualAxis;
        AxisAngle actualAxisAngle;
        Vector3D secondVector;
        AxisAngle expectedAxisAngle2;
        Vector3D expectedAxis2;
        double expectedAngle2;
        Vector3D firstVector;
        int i;
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedAngle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI);
            expectedAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            expectedAxisAngle2 = new AxisAngle((Vector3DReadOnly)expectedAxis2, expectedAngle2);
            secondVector = new Vector3D();
            expectedAxisAngle2.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            actualAxisAngle = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)actualAxisAngle);
            actualAxis = new Vector3D(actualAxisAngle.getX(), actualAxisAngle.getY(), actualAxisAngle.getZ());
            Assertions.assertEquals((double)1.0, (double)actualAxis.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)firstVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)secondVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)firstVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)secondVector), (double)1.0E-12);
            if (actualAxisAngle.getAngle() * expectedAxisAngle2.getAngle() < 0.0) {
                expectedAxis2.negate();
                expectedAngle2 = -expectedAngle2;
                expectedAxisAngle2.set((Vector3DReadOnly)expectedAxis2, expectedAngle2);
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle2, (EuclidGeometry)actualAxisAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedAngle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)0.001);
            if (random.nextBoolean()) {
                expectedAngle2 = -expectedAngle2;
            }
            expectedAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            expectedAxisAngle2 = new AxisAngle((Vector3DReadOnly)expectedAxis2, expectedAngle2);
            secondVector = new Vector3D();
            expectedAxisAngle2.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            actualAxisAngle = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)actualAxisAngle);
            actualAxis = new Vector3D(actualAxisAngle.getX(), actualAxisAngle.getY(), actualAxisAngle.getZ());
            Assertions.assertEquals((double)1.0, (double)actualAxis.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)firstVector), (double)1.0E-10);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)secondVector), (double)1.0E-10);
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)firstVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)secondVector), (double)1.0E-12);
            if (actualAxisAngle.getAngle() * expectedAxisAngle2.getAngle() < 0.0) {
                expectedAxis2.negate();
                expectedAngle2 = -expectedAngle2;
                expectedAxisAngle2.set((Vector3DReadOnly)expectedAxis2, expectedAngle2);
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle2, (EuclidGeometry)actualAxisAngle, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            expectedAngle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-5, (double)0.001);
            if (random.nextBoolean()) {
                expectedAngle2 = -expectedAngle2;
            }
            expectedAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstVector, (boolean)true);
            expectedAxisAngle2 = new AxisAngle((Vector3DReadOnly)expectedAxis2, expectedAngle2 += Math.PI);
            secondVector = new Vector3D();
            expectedAxisAngle2.transform((Tuple3DReadOnly)firstVector, (Tuple3DBasics)secondVector);
            secondVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            actualAxisAngle = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)actualAxisAngle);
            actualAxis = new Vector3D(actualAxisAngle.getX(), actualAxisAngle.getY(), actualAxisAngle.getZ());
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)firstVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)expectedAxis2.dot((Tuple3DReadOnly)secondVector), (double)1.0E-12);
            Assertions.assertEquals((double)1.0, (double)actualAxis.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)firstVector), (double)1.0E-10);
            Assertions.assertEquals((double)0.0, (double)actualAxis.dot((Tuple3DReadOnly)secondVector), (double)1.0E-10);
            if (actualAxisAngle.getAngle() * expectedAxisAngle2.getAngle() < 0.0) {
                expectedAxis2.negate();
                expectedAngle2 = -expectedAngle2;
                expectedAxisAngle2.set((Vector3DReadOnly)expectedAxis2, expectedAngle2);
            }
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle2, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D secondVector2 = new Vector3D((Tuple3DReadOnly)firstVector);
            firstVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            secondVector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            expectedAngle = 0.0;
            expectedAxis = new Vector3D(1.0, 0.0, 0.0);
            expectedAxisAngle = new AxisAngle((Vector3DReadOnly)expectedAxis, expectedAngle);
            actualAxisAngle = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector2, (Orientation3DBasics)actualAxisAngle);
            actualAxis = new Vector3D(actualAxisAngle.getX(), actualAxisAngle.getY(), actualAxisAngle.getZ());
            Assertions.assertEquals((double)1.0, (double)actualAxis.norm(), (double)1.0E-12);
            if (actualAxisAngle.getAngle() * expectedAxisAngle.getAngle() < 0.0) {
                expectedAxis.negate();
                expectedAngle = -expectedAngle;
                expectedAxisAngle.set((Vector3DReadOnly)expectedAxis, expectedAngle);
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D referenceNormal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D rotatedNormal = new Vector3D();
            referenceNormal.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rotatedNormal.setAndNegate((Tuple3DReadOnly)referenceNormal);
            rotatedNormal.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            expectedAngle = Math.PI;
            expectedAxis = new Vector3D(1.0, 0.0, 0.0);
            expectedAxisAngle = new AxisAngle((Vector3DReadOnly)expectedAxis, expectedAngle);
            actualAxisAngle = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)referenceNormal, (Vector3DReadOnly)rotatedNormal, (Orientation3DBasics)actualAxisAngle);
            actualAxis = new Vector3D(actualAxisAngle.getX(), actualAxisAngle.getY(), actualAxisAngle.getZ());
            Assertions.assertEquals((double)1.0, (double)actualAxis.norm(), (double)1.0E-12);
            if (actualAxisAngle.getAngle() * expectedAxisAngle.getAngle() < 0.0) {
                expectedAxis.negate();
                expectedAngle = -expectedAngle;
                expectedAxisAngle.set((Vector3DReadOnly)expectedAxis, expectedAngle);
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D zUp = new Vector3D(0.0, 0.0, 1.0);
            Vector3D vector = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            AxisAngle expectedAxisAngle3 = new AxisAngle();
            AxisAngle actualAxisAngle2 = new AxisAngle();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)zUp, (Vector3DReadOnly)vector, (Orientation3DBasics)expectedAxisAngle3);
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)vector, (Orientation3DBasics)actualAxisAngle2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle3, (EuclidGeometry)actualAxisAngle2, (double)1.0E-12);
            actualAxisAngle2 = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)vector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle3, (EuclidGeometry)actualAxisAngle2, (double)1.0E-12);
        }
    }

    @Test
    public void testClosestPoint3DsBetweenTwoLine3Ds() throws Exception {
        double expectedMinimumDistance;
        Vector3D orthogonalToLine1;
        Vector3D lineDirection2;
        Point3D lineStart2;
        Vector3D lineDirection1;
        Point3D lineStart1;
        int i;
        Point3D expectedPointOnLine1ToPack = new Point3D();
        Point3D expectedPointOnLine2ToPack = new Point3D();
        Point3D actualPointOnLine1ToPack = new Point3D();
        Point3D actualPointOnLine2ToPack = new Point3D();
        Random random = new Random(116L);
        for (i = 0; i < 1000; ++i) {
            lineStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            lineDirection1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            lineStart2 = new Point3D((Tuple3DReadOnly)lineStart1);
            lineDirection2 = new Vector3D((Tuple3DReadOnly)lineDirection1);
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            orthogonalToLine1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineStart2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLine1, (Tuple3DReadOnly)lineStart1);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05, (double)3.0915926535897933);
            AxisAngle axisAngleAroundShiftVector = new AxisAngle((Vector3DReadOnly)orthogonalToLine1, rotationAngle);
            axisAngleAroundShiftVector.transform((Tuple3DBasics)lineDirection2);
            expectedPointOnLine1ToPack.set(lineStart1);
            expectedPointOnLine2ToPack.set(lineStart2);
            double actualMinimumDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualPointOnLine1ToPack, (Point3DBasics)actualPointOnLine2ToPack);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine1ToPack, (EuclidGeometry)actualPointOnLine1ToPack, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine2ToPack, (EuclidGeometry)actualPointOnLine2ToPack, (double)1.0E-10);
            lineStart1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)lineStart1);
            lineStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)lineStart2);
            actualMinimumDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualPointOnLine1ToPack, (Point3DBasics)actualPointOnLine2ToPack);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine1ToPack, (EuclidGeometry)actualPointOnLine1ToPack, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine2ToPack, (EuclidGeometry)actualPointOnLine2ToPack, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            lineStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            lineStart2 = new Point3D((Tuple3DReadOnly)lineStart1);
            lineDirection2 = new Vector3D((Tuple3DReadOnly)lineDirection1);
            orthogonalToLine1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineStart2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLine1, (Tuple3DReadOnly)lineStart1);
            double actualMinimumDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualPointOnLine1ToPack, (Point3DBasics)actualPointOnLine2ToPack);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            lineStart1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)lineStart1);
            lineStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)lineStart2);
            actualMinimumDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualPointOnLine1ToPack, (Point3DBasics)actualPointOnLine2ToPack);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            lineDirection1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0));
            Point3D intersection = new Point3D();
            intersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)lineStart1);
            expectedPointOnLine1ToPack.set(intersection);
            expectedPointOnLine2ToPack.set(intersection);
            Point3D lineStart22 = new Point3D((Tuple3DReadOnly)intersection);
            Vector3D lineDirection22 = EuclidCoreRandomTools.nextVector3D((Random)random);
            lineDirection22.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineStart22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection22, (Tuple3DReadOnly)lineStart22);
            double actualMinimumDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart22, (Vector3DReadOnly)lineDirection22, (Point3DBasics)actualPointOnLine1ToPack, (Point3DBasics)actualPointOnLine2ToPack);
            Assertions.assertEquals((double)0.0, (double)actualMinimumDistance, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine1ToPack, (EuclidGeometry)actualPointOnLine1ToPack, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLine2ToPack, (EuclidGeometry)actualPointOnLine2ToPack, (double)1.0E-10);
        }
    }

    @Test
    public void testClosestPoint2DsBetweenTwoLineSegment2Ds() throws Exception {
        Vector2D shiftVector;
        Vector2D orthogonalToLineSegment1;
        Vector2D oppositeOflineSegmentDirection1;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        int i;
        Point2D expectedPointOnLineSegment1 = new Point2D();
        Point2D expectedPointOnLineSegment2 = new Point2D();
        Point2D actualPointOnLineSegment1 = new Point2D();
        Point2D actualPointOnLineSegment2 = new Point2D();
        Vector2D lineSegmentDirection1 = new Vector2D();
        Vector2D lineSegmentDirection2 = new Vector2D();
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            Vector2D orthogonalToLineSegment12 = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection1);
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)orthogonalToLineSegment12, (Tuple2DReadOnly)expectedPointOnLineSegment1);
            lineSegmentDirection2.set(lineSegmentDirection1);
            Point2D lineSegmentStart2 = new Point2D();
            Point2D lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            double eps = 1.0E-10;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)eps);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)eps);
            double shiftStartFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-10.0);
            double shiftEndFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(shiftStartFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(shiftEndFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            expectedPointOnLineSegment2.set(lineSegmentEnd2);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            orthogonalToLineSegment1 = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection1);
            shiftVector = new Vector2D();
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)expectedPointOnLineSegment1);
            lineSegmentDirection2 = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)shiftVector);
            Point2D lineSegmentStart2 = new Point2D();
            Point2D lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            orthogonalToLineSegment1 = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection1);
            shiftVector = new Vector2D();
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)expectedPointOnLineSegment1);
            Point2D lineSegmentStart2 = new Point2D((Tuple2DReadOnly)expectedPointOnLineSegment2);
            Vector2D orthogonalToShiftVector = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)shiftVector);
            lineSegmentDirection2.interpolate((Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)orthogonalToShiftVector, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D lineSegmentEnd2 = new Point2D();
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DBasics)actualPointOnLineSegment1, (Point2DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
    }

    @Test
    public void testClosestPoint3DsBetweenTwoLineSegment3Ds() throws Exception {
        Vector3D shiftVector;
        Vector3D oppositeOflineSegmentDirection1;
        Vector3D orthogonalToLineSegment1;
        Point3D lineSegmentEnd1;
        Point3D lineSegmentStart1;
        int i;
        Point3D expectedPointOnLineSegment1 = new Point3D();
        Point3D expectedPointOnLineSegment2 = new Point3D();
        Point3D actualPointOnLineSegment1 = new Point3D();
        Point3D actualPointOnLineSegment2 = new Point3D();
        Vector3D lineSegmentDirection1 = new Vector3D();
        Vector3D lineSegmentDirection2 = new Vector3D();
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.interpolate((Tuple3DReadOnly)lineSegmentStart1, (Tuple3DReadOnly)lineSegmentEnd1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            orthogonalToLineSegment1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)orthogonalToLineSegment1, (Tuple3DReadOnly)expectedPointOnLineSegment1);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05, (double)3.0915926535897933);
            AxisAngle rotationAroundShiftVector = new AxisAngle((Vector3DReadOnly)orthogonalToLineSegment1, rotationAngle);
            rotationAroundShiftVector.transform((Tuple3DReadOnly)lineSegmentDirection1, (Tuple3DBasics)lineSegmentDirection2);
            Point3D lineSegmentStart2 = new Point3D();
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            double eps = 1.0E-10;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)eps);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)eps);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            orthogonalToLineSegment1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)orthogonalToLineSegment1, (Tuple3DReadOnly)expectedPointOnLineSegment1);
            lineSegmentDirection2.set(lineSegmentDirection1);
            Point3D lineSegmentStart2 = new Point3D();
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            double eps = 1.0E-10;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)eps);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)eps);
            double shiftStartFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-10.0);
            double shiftEndFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(shiftStartFromExpected, (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(shiftEndFromExpected, (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            expectedPointOnLineSegment2.set(lineSegmentEnd2);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector3D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple3DReadOnly)lineSegmentDirection1);
            Vector3D orthogonalToLineSegment12 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            shiftVector = new Vector3D();
            shiftVector.interpolate((Tuple3DReadOnly)orthogonalToLineSegment12, (Tuple3DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)expectedPointOnLineSegment1);
            lineSegmentDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)shiftVector, (boolean)true);
            Point3D lineSegmentStart2 = new Point3D();
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            expectedPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector3D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple3DReadOnly)lineSegmentDirection1);
            Vector3D orthogonalToLineSegment13 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            shiftVector = new Vector3D();
            shiftVector.interpolate((Tuple3DReadOnly)orthogonalToLineSegment13, (Tuple3DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            expectedPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)expectedPointOnLineSegment1);
            Point3D lineSegmentStart2 = new Point3D((Tuple3DReadOnly)expectedPointOnLineSegment2);
            Vector3D orthogonalToShiftVector = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)shiftVector, (boolean)true);
            lineSegmentDirection2.interpolate((Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)orthogonalToShiftVector, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)expectedPointOnLineSegment2);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
            EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2, (Point3DBasics)actualPointOnLineSegment1, (Point3DBasics)actualPointOnLineSegment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment1, (EuclidGeometry)actualPointOnLineSegment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnLineSegment2, (EuclidGeometry)actualPointOnLineSegment2, (double)1.0E-12);
        }
    }

    @Test
    public void testTriangleArea() throws Exception {
        Point2D c;
        Point2D b;
        Point2D a;
        int i;
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextPoint2D((Random)random);
            a.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            b = new Point2D();
            c = new Point2D();
            Point2D d = new Point2D();
            Vector2D rectangleLength = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Vector2D rectangleWidth = new Vector2D(-rectangleLength.getY(), rectangleLength.getX());
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double width = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            rectangleLength.scale(length);
            rectangleWidth.scale(width);
            b.add((Tuple2DReadOnly)a, (Tuple2DReadOnly)rectangleLength);
            c.add((Tuple2DReadOnly)b, (Tuple2DReadOnly)rectangleWidth);
            d.add((Tuple2DReadOnly)a, (Tuple2DReadOnly)rectangleWidth);
            double expectedArea = 0.5 * length * width;
            double actualArea = EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            actualArea = EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)c, (Point2DReadOnly)d);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            actualArea = EuclidGeometryTools.triangleArea((Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DReadOnly)d);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            actualArea = EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)d);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)a, (Point2DReadOnly)c), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            a = EuclidCoreRandomTools.nextPoint2D((Random)random);
            b = EuclidCoreRandomTools.nextPoint2D((Random)random);
            c = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double lengthA = a.distance((Point2DReadOnly)b);
            double lengthB = b.distance((Point2DReadOnly)c);
            double lengthC = c.distance((Point2DReadOnly)a);
            double areaMethod1 = EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
            double areaMethod2 = EuclidGeometryTools.triangleAreaHeron1((double)lengthA, (double)lengthB, (double)lengthC);
            double areaMethod3 = EuclidGeometryTools.triangleAreaHeron1((double)lengthA, (double)lengthB, (double)lengthC);
            Assertions.assertEquals((double)areaMethod1, (double)areaMethod2, (double)1.0E-12);
            Assertions.assertEquals((double)areaMethod1, (double)areaMethod3, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D a2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D b2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D c2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double expectedArea = EuclidGeometryTools.triangleArea((Point2DReadOnly)a2D, (Point2DReadOnly)b2D, (Point2DReadOnly)c2D);
            Point3D a3D = new Point3D((Tuple2DReadOnly)a2D);
            Point3D b3D = new Point3D((Tuple2DReadOnly)b2D);
            Point3D c3D = new Point3D((Tuple2DReadOnly)c2D);
            double actualArea = EuclidGeometryTools.triangleArea((Point3DReadOnly)a3D, (Point3DReadOnly)b3D, (Point3DReadOnly)c3D);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Stream.of(a3D, b3D, c3D).forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            actualArea = EuclidGeometryTools.triangleArea((Point3DReadOnly)a3D, (Point3DReadOnly)b3D, (Point3DReadOnly)c3D);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
        }
    }

    @Test
    public void testTriangleCircumscribedCircle() {
        Point2D circumcenter;
        Point2D C;
        Point2D A;
        Point2D actual;
        Point2D C2;
        Point2D B;
        Point2D A2;
        Point2D expected;
        int i;
        Random random = new Random(3456436L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            A2 = new Point2D();
            B = new Point2D();
            C2 = new Point2D();
            A2.scaleAdd(radius, (Tuple2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random), (Tuple2DReadOnly)expected);
            B.scaleAdd(radius, (Tuple2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random), (Tuple2DReadOnly)expected);
            C2.scaleAdd(radius, (Tuple2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random), (Tuple2DReadOnly)expected);
            actual = new Point2D();
            EuclidGeometryTools.triangleCircumcenter((Point2DReadOnly)A2, (Point2DReadOnly)B, (Point2DReadOnly)C2, (Point2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            A = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D B2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            C = EuclidCoreRandomTools.nextPoint2D((Random)random);
            circumcenter = new Point2D();
            EuclidGeometryTools.triangleCircumcenter((Point2DReadOnly)A, (Point2DReadOnly)B2, (Point2DReadOnly)C, (Point2DBasics)circumcenter);
            Assertions.assertEquals((double)circumcenter.distance((Point2DReadOnly)A), (double)circumcenter.distance((Point2DReadOnly)B2), (double)1.0E-12);
            Assertions.assertEquals((double)circumcenter.distance((Point2DReadOnly)A), (double)circumcenter.distance((Point2DReadOnly)C), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            int numberOfVertices = random.nextInt(20) + 3;
            List concyclicPolygon = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (Point2DReadOnly)expected, (double)1.0, (int)numberOfVertices);
            A2 = (Point2D)concyclicPolygon.get(random.nextInt(numberOfVertices));
            B = (Point2D)concyclicPolygon.get(random.nextInt(numberOfVertices));
            while (B == A2) {
                B = (Point2D)concyclicPolygon.get(random.nextInt(numberOfVertices));
            }
            C2 = (Point2D)concyclicPolygon.get(random.nextInt(numberOfVertices));
            while (C2 == B || C2 == A2) {
                C2 = (Point2D)concyclicPolygon.get(random.nextInt(numberOfVertices));
            }
            actual = new Point2D();
            EuclidGeometryTools.triangleCircumcenter((Point2DReadOnly)A2, (Point2DReadOnly)B, (Point2DReadOnly)C2, (Point2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            A2 = new Point3D();
            B = new Point3D();
            C2 = new Point3D();
            Vector3D normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            A2.scaleAdd(radius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true), (Tuple3DReadOnly)expected);
            B.scaleAdd(radius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true), (Tuple3DReadOnly)expected);
            C2.scaleAdd(radius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true), (Tuple3DReadOnly)expected);
            Point3D actual2 = new Point3D();
            EuclidGeometryTools.triangleCircumcenter((Point3DReadOnly)A2, (Point3DReadOnly)B, (Point3DReadOnly)C2, (Point3DBasics)actual2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual2, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            A = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D B3 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            C = EuclidCoreRandomTools.nextPoint3D((Random)random);
            circumcenter = new Point3D();
            EuclidGeometryTools.triangleCircumcenter((Point3DReadOnly)A, (Point3DReadOnly)B3, (Point3DReadOnly)C, (Point3DBasics)circumcenter);
            Assertions.assertEquals((double)circumcenter.distance((Point3DReadOnly)A), (double)circumcenter.distance((Point3DReadOnly)B3), (double)1.0E-12);
            Assertions.assertEquals((double)circumcenter.distance((Point3DReadOnly)A), (double)circumcenter.distance((Point3DReadOnly)C), (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceBetweenPoint2Ds() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPoint = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D secondPoint = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedDistance = firstPoint.distance((Point2DReadOnly)secondPoint);
            double actualDistance = EuclidGeometryTools.distanceBetweenPoint2Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)secondPoint.getX(), (double)secondPoint.getY());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceBetweenPoint2Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (Point2DReadOnly)secondPoint);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceSquaredBetweenPoint2Ds() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPoint = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D secondPoint = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedDistance = firstPoint.distanceSquared((Point2DReadOnly)secondPoint);
            double actualDistance = EuclidGeometryTools.distanceSquaredBetweenPoint2Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)secondPoint.getX(), (double)secondPoint.getY());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceSquaredBetweenPoint2Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (Point2DReadOnly)secondPoint);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceBetweenPoint3Ds() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D firstPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D secondPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedDistance = firstPoint.distance((Point3DReadOnly)secondPoint);
            double actualDistance = EuclidGeometryTools.distanceBetweenPoint3Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)firstPoint.getZ(), (double)secondPoint.getX(), (double)secondPoint.getY(), (double)secondPoint.getZ());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceBetweenPoint3Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)firstPoint.getZ(), (Point3DReadOnly)secondPoint);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceSquaredBetweenPoint3Ds() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D firstPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D secondPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            secondPoint.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double expectedDistance = firstPoint.distanceSquared((Point3DReadOnly)secondPoint);
            double actualDistance = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)firstPoint.getZ(), (double)secondPoint.getX(), (double)secondPoint.getY(), (double)secondPoint.getZ());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)firstPoint.getX(), (double)firstPoint.getY(), (double)firstPoint.getZ(), (Point3DReadOnly)secondPoint);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceBetweenTwoLine3Ds() throws Exception {
        double expectedMinimumDistance;
        Vector3D orthogonalToLine1;
        Vector3D lineDirection2;
        Point3D lineStart2;
        Vector3D lineDirection1;
        Point3D lineStart1;
        int i;
        Point3D closestPointOnLine1 = new Point3D();
        Point3D closestPointOnLine2 = new Point3D();
        Random random = new Random(176L);
        for (i = 0; i < 1000; ++i) {
            lineStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0));
            lineStart2 = new Point3D((Tuple3DReadOnly)lineStart1);
            lineDirection2 = new Vector3D((Tuple3DReadOnly)lineDirection1);
            orthogonalToLine1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineStart2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLine1, (Tuple3DReadOnly)lineStart1);
            AxisAngle axisAngleAroundShiftVector = new AxisAngle((Vector3DReadOnly)orthogonalToLine1, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            RotationMatrix rotationMatrixAroundShiftVector = new RotationMatrix();
            rotationMatrixAroundShiftVector.set((Orientation3DReadOnly)axisAngleAroundShiftVector);
            rotationMatrixAroundShiftVector.transform((Tuple3DBasics)lineDirection2);
            closestPointOnLine1.set(lineStart1);
            closestPointOnLine2.set(lineStart2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            lineStart1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)lineStart1);
            lineStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)lineStart2);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            lineStart2 = new Point3D((Tuple3DReadOnly)lineStart1);
            lineDirection2 = new Vector3D((Tuple3DReadOnly)lineDirection1);
            orthogonalToLine1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineStart2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLine1, (Tuple3DReadOnly)lineStart1);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            lineStart1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection1, (Tuple3DReadOnly)lineStart1);
            lineStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)lineStart2);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLine3Ds((Point3DReadOnly)lineStart1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)lineStart2, (Vector3DReadOnly)lineDirection2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceBetweenTwoLineSegment2Ds() throws Exception {
        double distance;
        Vector2D orthogonal;
        double alpha2;
        double alpha1;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Vector2D lineDirection2;
        Point2D pointOnLineSegment1;
        Point2D lineSegmentEnd12;
        Point2D lineSegmentStart12;
        int i;
        Random random = new Random(46344L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointOnLineSegment1 = new Point2D();
            pointOnLineSegment1.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, 0.0, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart2, lineSegmentEnd2, 3.0E-8);
            double alphaClose = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaFar = alphaClose + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineSegmentStart2.scaleAdd(alphaClose, (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(alphaFar, (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            double expectedDistance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart2, lineSegmentEnd2, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLineSegment1 = new Point2D((Tuple2DReadOnly)lineSegmentStart12);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, 0.0, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart2, lineSegmentEnd2, 3.0E-8);
        }
        for (i = 0; i < 1000; ++i) {
            double expectedDistance;
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart22 = new Point2D();
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart22.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, alpha12);
            lineSegmentEnd22.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, alpha22);
            if (0.0 < alpha12 && alpha12 < 1.0 || 0.0 < alpha22 && alpha22 < 1.0 || alpha12 * alpha22 < 0.0) {
                expectedDistance = 0.0;
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart22, lineSegmentEnd22, 1.0E-12);
            } else {
                expectedDistance = alpha12 < 0.0 ? (alpha12 < alpha22 ? lineSegmentEnd22.distance((Point2DReadOnly)lineSegmentStart12) : lineSegmentStart22.distance((Point2DReadOnly)lineSegmentStart12)) : (alpha12 > alpha22 ? lineSegmentEnd22.distance((Point2DReadOnly)lineSegmentEnd12) : lineSegmentStart22.distance((Point2DReadOnly)lineSegmentEnd12));
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart22, lineSegmentEnd22, 1.0E-12);
            }
            Vector2D orthogonal2 = new Vector2D();
            orthogonal2.sub((Tuple2DReadOnly)lineSegmentEnd12, (Tuple2DReadOnly)lineSegmentStart12);
            orthogonal2.set(-orthogonal2.getY(), orthogonal2.getX());
            orthogonal2.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart22.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal2, (Tuple2DReadOnly)lineSegmentStart22);
            lineSegmentEnd22.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal2, (Tuple2DReadOnly)lineSegmentEnd22);
            expectedDistance = EuclidCoreTools.norm((double)expectedDistance, (double)distance2);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart12, lineSegmentEnd12, lineSegmentStart22, lineSegmentEnd22, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double expectedDistance;
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentStart1 = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart23 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart23.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                expectedDistance = 0.0;
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart23, lineSegmentEnd2, 1.0E-12);
            } else {
                expectedDistance = alpha1 < 0.0 ? (alpha1 < alpha2 ? lineSegmentEnd2.distance((Point2DReadOnly)lineSegmentStart1) : lineSegmentStart23.distance((Point2DReadOnly)lineSegmentStart1)) : (alpha1 > alpha2 ? lineSegmentEnd2.distance((Point2DReadOnly)lineSegmentEnd1) : lineSegmentStart23.distance((Point2DReadOnly)lineSegmentEnd1));
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart23, lineSegmentEnd2, 1.0E-12);
            }
            orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart23.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart23);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            expectedDistance = EuclidCoreTools.norm((double)expectedDistance, (double)distance);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart23, lineSegmentEnd2, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double expectedDistance;
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentStart1 = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            lineSegmentEnd1 = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart24 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart24.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                expectedDistance = 0.0;
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart24, lineSegmentEnd2, 1.0E-12);
            } else {
                expectedDistance = alpha1 < 0.0 ? (alpha1 < alpha2 ? lineSegmentEnd2.distance((Point2DReadOnly)lineSegmentStart1) : lineSegmentStart24.distance((Point2DReadOnly)lineSegmentStart1)) : (alpha1 > alpha2 ? lineSegmentEnd2.distance((Point2DReadOnly)lineSegmentEnd1) : lineSegmentStart24.distance((Point2DReadOnly)lineSegmentEnd1));
                this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart24, lineSegmentEnd2, 1.0E-12);
            }
            orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart24.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart24);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            expectedDistance = EuclidCoreTools.norm((double)expectedDistance, (double)distance);
            this.assertDistanceBetweenTwoLineSegment2Ds(i, expectedDistance, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart24, lineSegmentEnd2, 1.0E-12);
        }
    }

    private void assertDistanceBetweenTwoLineSegment2Ds(int iteration, double expectedDistance, Point2D lineSegmentStart1, Point2D lineSegmentEnd1, Point2D lineSegmentStart2, Point2D lineSegmentEnd2, double epsilon) {
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1), (double)epsilon, (String)("Itertation " + iteration));
        Assertions.assertEquals((double)expectedDistance, (double)EuclidGeometryTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1), (double)epsilon, (String)("Itertation " + iteration));
    }

    @Test
    public void testDistanceBetweenTwoLineSegment3Ds() throws Exception {
        Vector3D shiftVector;
        Vector3D oppositeOflineSegmentDirection1;
        Point3D lineSegmentEnd2;
        double expectedMinimumDistance;
        Vector3D orthogonalToLineSegment1;
        Point3D lineSegmentEnd1;
        Point3D lineSegmentStart1;
        int i;
        Point3D closestPointOnLineSegment1 = new Point3D();
        Point3D closestPointOnLineSegment2 = new Point3D();
        Vector3D lineSegmentDirection1 = new Vector3D();
        Vector3D lineSegmentDirection2 = new Vector3D();
        Random random = new Random(11762L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.interpolate((Tuple3DReadOnly)lineSegmentStart1, (Tuple3DReadOnly)lineSegmentEnd1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            orthogonalToLineSegment1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            closestPointOnLineSegment2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLineSegment1, (Tuple3DReadOnly)closestPointOnLineSegment1);
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            AxisAngle rotationAroundShiftVector = new AxisAngle((Vector3DReadOnly)orthogonalToLineSegment1, rotationAngle);
            rotationAroundShiftVector.transform((Tuple3DReadOnly)lineSegmentDirection1, (Tuple3DBasics)lineSegmentDirection2);
            Point3D lineSegmentStart2 = new Point3D();
            Point3D lineSegmentEnd22 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd22);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            orthogonalToLineSegment1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            closestPointOnLineSegment2.scaleAdd(expectedMinimumDistance, (Tuple3DReadOnly)orthogonalToLineSegment1, (Tuple3DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2.set(lineSegmentDirection1);
            Point3D lineSegmentStart2 = new Point3D();
            lineSegmentEnd2 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            double shiftStartFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-10.0);
            double shiftEndFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(shiftStartFromExpected, (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(shiftEndFromExpected, (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            closestPointOnLineSegment2.set(lineSegmentEnd2);
            expectedMinimumDistance = closestPointOnLineSegment1.distance((Point3DReadOnly)closestPointOnLineSegment2);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector3D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple3DReadOnly)lineSegmentDirection1);
            Vector3D orthogonalToLineSegment12 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            shiftVector = new Vector3D();
            shiftVector.interpolate((Tuple3DReadOnly)orthogonalToLineSegment12, (Tuple3DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)shiftVector, (boolean)true);
            Point3D lineSegmentStart2 = new Point3D();
            lineSegmentEnd2 = new Point3D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance2 = closestPointOnLineSegment1.distance((Point3DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance2, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance2, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2);
            Assertions.assertEquals((double)expectedMinimumDistance2, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd2, (Point3DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance2, (double)actualMinimumDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple3DReadOnly)lineSegmentEnd1, (Tuple3DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector3D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple3DReadOnly)lineSegmentDirection1);
            Vector3D orthogonalToLineSegment13 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection1, (boolean)true);
            shiftVector = new Vector3D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            shiftVector.interpolate((Tuple3DReadOnly)orthogonalToLineSegment13, (Tuple3DReadOnly)oppositeOflineSegmentDirection1, alpha);
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)closestPointOnLineSegment1);
            Point3D lineSegmentStart2 = new Point3D((Tuple3DReadOnly)closestPointOnLineSegment2);
            Vector3D orthogonalToShiftVector = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)shiftVector, (boolean)true);
            lineSegmentDirection2.interpolate((Tuple3DReadOnly)shiftVector, (Tuple3DReadOnly)orthogonalToShiftVector, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point3D lineSegmentEnd23 = new Point3D();
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            lineSegmentEnd23.scaleAdd(alpha2, (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance3 = closestPointOnLineSegment1.distance((Point3DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd23);
            Assertions.assertEquals((double)expectedMinimumDistance3, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentEnd23, (Point3DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance3, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd23);
            Assertions.assertEquals((double)expectedMinimumDistance3, (double)actualMinimumDistance, (double)1.0E-12);
            actualMinimumDistance = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd23, (Point3DReadOnly)lineSegmentStart2);
            Assertions.assertEquals((double)expectedMinimumDistance3, (double)actualMinimumDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint2DToLine2D() throws Exception {
        Random random = new Random(243234L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random);
            pointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            orthogonal.normalize();
            if (random.nextBoolean()) {
                orthogonal.negate();
            }
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D query = new Point2D();
            query.scaleAdd(expectedDistance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnLine);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)query);
            double actualDistance = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            lineDirection.normalize();
            lineDirection.scale(9.99999E-13);
            expectedDistance = pointOnLine.distance((Point2DReadOnly)query);
            actualDistance = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint2DToLineSegment2D() throws Exception {
        Point2D point = new Point2D(10.0, 2.0);
        Point2D lineStart = new Point2D(4.0, 2.0);
        Point2D lineEnd = new Point2D(10.0, 10.0);
        double expectedReturn = 4.8;
        double actualReturn = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)point, (Point2DReadOnly)lineStart, (Point2DReadOnly)lineEnd);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)Double.MIN_VALUE, (String)"return value");
        Point2D point1 = new Point2D(10.0, 10.0);
        Point2D lineStart1 = new Point2D(4.0, 2.0);
        Point2D lineEnd1 = new Point2D(4.0, 2.0);
        double expectedReturn1 = 10.0;
        double actualReturn1 = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)point1, (Point2DReadOnly)lineStart1, (Point2DReadOnly)lineEnd1);
        Assertions.assertEquals((double)expectedReturn1, (double)actualReturn1, (double)Double.MIN_VALUE, (String)"return value");
        Point2D point2 = new Point2D(1.0, 1.0);
        Point2D lineStart2 = new Point2D(5.0, 5.0);
        Point2D lineEnd2 = new Point2D(5.0, 5.0);
        double expectedReturn2 = lineStart2.distance((Point2DReadOnly)point2);
        double actualReturn2 = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)point2, (Point2DReadOnly)lineStart2, (Point2DReadOnly)lineEnd2);
        Assertions.assertEquals((double)expectedReturn2, (double)actualReturn2, (double)1.0E-12, (String)"return value");
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal, (Vector2DBasics)orthogonal);
            orthogonal.normalize();
            Point2D projection = new Point2D();
            Point2D testPoint = new Point2D();
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            double expectedDistance = projection.distance((Point2DReadOnly)testPoint);
            double actualDistance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            projection.set(lineSegmentStart);
            expectedDistance = projection.distance((Point2DReadOnly)testPoint);
            actualDistance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            projection.set(lineSegmentEnd);
            expectedDistance = projection.distance((Point2DReadOnly)testPoint);
            actualDistance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint2DToRay2D() throws Exception {
        double actualDistance;
        double expectedDistance;
        Point2D query;
        Vector2D orthogonalToRay;
        Vector2D rayDirection;
        Point2D rayOrigin;
        int i;
        Random random = new Random(43254L);
        for (i = 0; i < 1000; ++i) {
            rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            orthogonalToRay = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)rayDirection);
            orthogonalToRay.normalize();
            query = new Point2D();
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonalToRay, (Tuple2DReadOnly)query);
            expectedDistance = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            actualDistance = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)query, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            orthogonalToRay = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)rayDirection);
            orthogonalToRay.normalize();
            query = new Point2D();
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonalToRay, (Tuple2DReadOnly)query);
            expectedDistance = query.distance((Point2DReadOnly)rayOrigin);
            actualDistance = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)query, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint3DToLine3D() throws Exception {
        Random random = new Random(1176L);
        Point3D point = new Point3D(10.0, 2.0, 0.0);
        Point3D lineStart = new Point3D(4.0, 2.0, 0.0);
        Point3D lineEnd = new Point3D(10.0, 10.0, 0.0);
        double expectedReturn = 4.8;
        double actualReturn = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)point, (Point3DReadOnly)lineStart, (Point3DReadOnly)lineEnd);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)Double.MIN_VALUE, (String)"return value");
        Point3D point1 = new Point3D(10.0, 10.0, 0.0);
        Point3D lineStart1 = new Point3D(4.0, 2.0, 0.0);
        Point3D lineEnd1 = new Point3D(4.0, 2.0, 0.0);
        double expectedReturn1 = 10.0;
        double actualReturn1 = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)point1, (Point3DReadOnly)lineStart1, (Point3DReadOnly)lineEnd1);
        Assertions.assertEquals((double)expectedReturn1, (double)actualReturn1, (double)Double.MIN_VALUE, (String)"return value");
        for (int i = 0; i < 1000; ++i) {
            Point3D firstPointOnLine = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D secondPointOnLine = EuclidCoreRandomTools.nextPoint3D((Random)random);
            secondPointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)secondPointOnLine, (Tuple3DReadOnly)firstPointOnLine);
            Vector3D orthogonalVector = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection, (boolean)true);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D query = new Point3D();
            query.interpolate((Tuple3DReadOnly)firstPointOnLine, (Tuple3DReadOnly)secondPointOnLine, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            query.scaleAdd(expectedDistance, (Tuple3DReadOnly)orthogonalVector, (Tuple3DReadOnly)query);
            double actualDistance = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)query, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)query, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            lineDirection.normalize();
            lineDirection.scale(9.99999E-13);
            expectedDistance = firstPointOnLine.distance((Point3DReadOnly)query);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)query, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint3DToLineSegment3D() throws Exception {
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection, (boolean)true);
            Point3D projection = new Point3D();
            Point3D testPoint = new Point3D();
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            double expectedDistance = projection.distance((Point3DReadOnly)testPoint);
            double actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentStart.getZ(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY(), (double)lineSegmentEnd.getZ());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            projection.set(lineSegmentStart);
            expectedDistance = projection.distance((Point3DReadOnly)testPoint);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentStart.getZ(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY(), (double)lineSegmentEnd.getZ());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            projection.set(lineSegmentEnd);
            expectedDistance = projection.distance((Point3DReadOnly)testPoint);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)testPoint.getX(), (double)testPoint.getY(), (double)testPoint.getZ(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentStart.getZ(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY(), (double)lineSegmentEnd.getZ());
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceFromPoint3DToPlane3D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D secondPointOnPlane = new Point3D();
            secondPointOnPlane.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D point = new Point3D();
            double scalar = expectedDistance / planeNormal.norm();
            if (random.nextBoolean()) {
                scalar = -scalar;
            }
            point.scaleAdd(scalar, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)secondPointOnPlane);
            double actualDistance = EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            actualDistance = EuclidGeometryTools.distanceFromPoint3DToPlane3D((double)point.getX(), (double)point.getY(), (double)point.getZ(), (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testSignedDistanceFromPoint3DToPlane3D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D secondPointOnPlane = new Point3D();
            secondPointOnPlane.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            Point3D point = new Point3D();
            point.scaleAdd(expectedDistance / planeNormal.norm(), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)secondPointOnPlane);
            double actualDistance = EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceSquaredFromPoint2DToLineSegment2D() throws Exception {
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal, (Vector2DBasics)orthogonal);
            orthogonal.normalize();
            Point2D projection = new Point2D();
            Point2D testPoint = new Point2D();
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            double expectedSquaredDistance = projection.distanceSquared((Point2DReadOnly)testPoint);
            double actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY());
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            projection.set(lineSegmentStart);
            expectedSquaredDistance = projection.distanceSquared((Point2DReadOnly)testPoint);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY());
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            expectedSquaredDistance = projection.distanceSquared((Point2DReadOnly)testPoint);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            projection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)projection);
            projection.set(lineSegmentEnd);
            expectedSquaredDistance = projection.distanceSquared((Point2DReadOnly)testPoint);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY());
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)testPoint.getX(), (double)testPoint.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDistanceSquaredFromPoint3DToLineSegment3D() throws Exception {
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection, (boolean)true);
            Point3D projection = new Point3D();
            Point3D testPoint = new Point3D();
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            double expectedSquaredDistance = projection.distanceSquared((Point3DReadOnly)testPoint);
            double actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            projection.set(lineSegmentStart);
            expectedSquaredDistance = projection.distanceSquared((Point3DReadOnly)testPoint);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
            projection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)projection);
            projection.set(lineSegmentEnd);
            expectedSquaredDistance = projection.distanceSquared((Point3DReadOnly)testPoint);
            actualSquaredDistance = EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedSquaredDistance, (double)actualSquaredDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testDoesLineSegment3DIntersectPlane3D() throws Exception {
        Random random = new Random(1176L);
        Point3D endPoint0 = new Point3D();
        Point3D endPoint1 = new Point3D();
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D randomLinePlaneIntersection = new Point3D();
            randomLinePlaneIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            Vector3D lineDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
            endPoint1.set(endPoint0);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
            endPoint0.set(randomLinePlaneIntersection);
            endPoint1.set(endPoint0);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
        }
        Point3D pointOnPlane = new Point3D();
        Vector3D planeNormal = new Vector3D(0.0, 0.0, 1.0);
        Point3D randomLinePlaneIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random);
        randomLinePlaneIntersection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
        randomLinePlaneIntersection.setZ(0.0);
        Vector3D lineDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        if (lineDirection.dot((Tuple3DReadOnly)planeNormal) < 0.0) {
            lineDirection.negate();
        }
        endPoint0.set(randomLinePlaneIntersection);
        endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
        Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
        Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
        endPoint0.set(randomLinePlaneIntersection);
        endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)randomLinePlaneIntersection);
        Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1));
        Assertions.assertFalse((boolean)EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0));
    }

    @Test
    public void testDoLine2DAndLineSegment2DIntersect() throws Exception {
        Vector2D lineDirection;
        Vector2D lineDirection2;
        Point2D pointOnLine;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, random.nextDouble());
            lineDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection2.getX(), (double)lineDirection2.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection2.getX(), (double)lineDirection2.getY(), (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, 1.0 + random.nextDouble());
            lineDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection2.getX(), (double)lineDirection2.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection2.getX(), (double)lineDirection2.getY(), (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection.normalize();
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            Point2D pointOnLine2 = new Point2D();
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart);
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine2);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine2.getX(), (double)pointOnLine2.getY(), (double)lineDirection.getX(), (double)lineDirection.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine2.getX(), (double)pointOnLine2.getY(), (double)lineDirection.getX(), (double)lineDirection.getY(), (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection.normalize();
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D pointOnLine3 = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            pointOnLine3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine3);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine3, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine3, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine3.getX(), (double)pointOnLine3.getY(), (double)lineDirection.getX(), (double)lineDirection.getY(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLine3.getX(), (double)pointOnLine3.getY(), (double)lineDirection.getX(), (double)lineDirection.getY(), (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
    }

    @Test
    public void testDoLineSegment2DsIntersect() throws Exception {
        double distance;
        Vector2D orthogonal;
        double alpha1;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Vector2D lineDirection2;
        Point2D pointOnLineSegment1;
        Point2D lineSegmentEnd12;
        Point2D lineSegmentStart12;
        int i;
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLineSegment1 = new Point2D();
            pointOnLineSegment1.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLineSegment1 = new Point2D((Tuple2DReadOnly)lineSegmentStart12);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLineSegment1);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd12 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd12.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart22 = new Point2D();
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart22.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, alpha12);
            lineSegmentEnd22.interpolate((Tuple2DReadOnly)lineSegmentStart12, (Tuple2DReadOnly)lineSegmentEnd12, alpha2);
            if (0.0 < alpha12 && alpha12 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha12 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
            }
            Vector2D orthogonal2 = new Vector2D();
            orthogonal2.sub((Tuple2DReadOnly)lineSegmentEnd12, (Tuple2DReadOnly)lineSegmentStart12);
            orthogonal2.set(-orthogonal2.getY(), orthogonal2.getX());
            orthogonal2.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart22.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal2, (Tuple2DReadOnly)lineSegmentStart22);
            lineSegmentEnd22.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal2, (Tuple2DReadOnly)lineSegmentEnd22);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart12, (Point2DReadOnly)lineSegmentEnd12, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22));
        }
        for (i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentStart1 = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart23 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart23.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
            }
            orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart23.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart23);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart23, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart23));
        }
        for (i = 0; i < 1000; ++i) {
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentStart1 = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            lineSegmentEnd1 = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart24 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart24.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
            }
            orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart24.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart24);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart24, (Point2DReadOnly)lineSegmentEnd2));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart24));
        }
    }

    @Test
    public void testDotProduct() throws Exception {
        double actualDotProduct;
        double expectedDotProduct;
        Vector2D vector2;
        Vector2D vector1;
        Point2D end2;
        Point2D start2;
        Point2D end1;
        Point2D start1;
        int i;
        Random random = new Random(32424L);
        for (i = 0; i < 1000; ++i) {
            start1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            start1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            end1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            end1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            start2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            start2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            end2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            end2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            vector1 = new Vector2D();
            vector1.sub((Tuple2DReadOnly)end1, (Tuple2DReadOnly)start1);
            vector2 = new Vector2D();
            vector2.sub((Tuple2DReadOnly)end2, (Tuple2DReadOnly)start2);
            expectedDotProduct = vector1.dot((Tuple2DReadOnly)vector2);
            actualDotProduct = EuclidGeometryTools.dotProduct((Point2DReadOnly)start1, (Point2DReadOnly)end1, (Point2DReadOnly)start2, (Point2DReadOnly)end2);
            Assertions.assertEquals((double)expectedDotProduct, (double)actualDotProduct, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            start1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            start1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            end1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            end1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            start2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            start2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            end2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            end2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            vector1 = new Vector3D();
            vector1.sub((Tuple3DReadOnly)end1, (Tuple3DReadOnly)start1);
            vector2 = new Vector3D();
            vector2.sub((Tuple3DReadOnly)end2, (Tuple3DReadOnly)start2);
            expectedDotProduct = vector1.dot((Tuple3DReadOnly)vector2);
            actualDotProduct = EuclidGeometryTools.dotProduct((Point3DReadOnly)start1, (Point3DReadOnly)end1, (Point3DReadOnly)start2, (Point3DReadOnly)end2);
            Assertions.assertEquals((double)expectedDotProduct, (double)actualDotProduct, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionBetweenLine2DAndBoundingBox2D() throws Exception {
        Vector2D boxSize;
        int i;
        Random random = new Random(4353435L);
        for (i = 0; i < 1000; ++i) {
            for (int hoveringAxisIndex = 0; hoveringAxisIndex < 2; ++hoveringAxisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    boundingBoxMax.absolute();
                    boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
                    Point2D firstPointOnLine = new Point2D();
                    Point2D secondPointOnLine = new Point2D();
                    Vector2D lineDirection = new Vector2D();
                    int otherIndex = (hoveringAxisIndex + 1) % 2;
                    Point3D alphaStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D alphaEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    if (random.nextBoolean()) {
                        alphaStart.setElement(otherIndex, 0.0);
                        alphaEnd.setElement(otherIndex, 1.0);
                    } else {
                        alphaStart.setElement(otherIndex, 1.0);
                        alphaEnd.setElement(otherIndex, 0.0);
                    }
                    firstPointOnLine.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaStart.getX()));
                    firstPointOnLine.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaStart.getY()));
                    secondPointOnLine.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaEnd.getX()));
                    secondPointOnLine.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaEnd.getY()));
                    lineDirection.sub((Tuple2DReadOnly)secondPointOnLine, (Tuple2DReadOnly)firstPointOnLine);
                    Point2D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D actualFirstIntersection = new Point2D((Tuple2DReadOnly)expectedFirstIntersection);
                    Point2D actualSecondIntersection = new Point2D((Tuple2DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Axis2D[] hoveringAxisIndex = Axis2D.values();
            int hoveringDirection = hoveringAxisIndex.length;
            for (int j = 0; j < hoveringDirection; ++j) {
                Axis2D edgeAxis = hoveringAxisIndex[j];
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.1, (double)10.0);
                        Vector2D lineDirection = new Vector2D();
                        Point2D boxEdgePoint = new Point2D();
                        Point2D pointOutsideBox = new Point2D();
                        Point2D firstPointOnLine = new Point2D();
                        Point2D secondPointOnLine = new Point2D();
                        pointOutsideBox.add((Tuple2DReadOnly)boxPosition, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)(-0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(0)), (double)(-0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(1))));
                        pointOutsideBox.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0)));
                        boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis)));
                        boxEdgePoint.setElement(edgeAxis.other(), boxPosition.getElement(edgeAxis.other()) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis.other()));
                        Point2D boundingBoxMin = new Point2D();
                        Point2D boundingBoxMax = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        Point2D actualFirstIntersection = new Point2D();
                        Point2D actualSecondIntersection = new Point2D();
                        firstPointOnLine.set(pointOutsideBox);
                        secondPointOnLine.set(boxEdgePoint);
                        lineDirection.sub((Tuple2DReadOnly)secondPointOnLine, (Tuple2DReadOnly)firstPointOnLine);
                        Point2D expectedIntersection = new Point2D();
                        expectedIntersection.set(boxEdgePoint);
                        int expectedNumberOfIntersections = 1;
                        int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualFirstIntersection, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                        actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, null, null);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                        actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualFirstIntersection, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                        actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, null, null);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D edgeAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.1, (double)10.0);
                        Point2D firstEdgePoint = new Point2D();
                        Point2D secondEdgePoint = new Point2D();
                        firstEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis)));
                        firstEdgePoint.setElement(edgeAxis.other(), boxPosition.getElement(edgeAxis.other()) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis.other()));
                        secondEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis)));
                        secondEdgePoint.setElement(edgeAxis.other(), boxPosition.getElement(edgeAxis.other()) + -1.0 * edgeDirection * 0.5 * boxSize.getElement(edgeAxis.other()));
                        Vector2D lineDirection = new Vector2D();
                        lineDirection.sub((Tuple2DReadOnly)secondEdgePoint, (Tuple2DReadOnly)firstEdgePoint);
                        Vector2D invLineDirection = new Vector2D();
                        invLineDirection.sub((Tuple2DReadOnly)firstEdgePoint, (Tuple2DReadOnly)secondEdgePoint);
                        Point2D boundingBoxMin = new Point2D();
                        Point2D boundingBoxMax = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        Point2D actualIntersection1 = new Point2D();
                        Point2D actualIntersection2 = new Point2D();
                        Point2D expectedIntersection1 = new Point2D();
                        expectedIntersection1.set(firstEdgePoint);
                        Point2D expectedIntersection2 = new Point2D();
                        expectedIntersection2.set(secondEdgePoint);
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstEdgePoint, (Point2DReadOnly)secondEdgePoint, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        this.assertPointIsOnBoundingBoxFace(actualIntersection1, boundingBoxMin, boundingBoxMax, 1.0E-12);
                        this.assertPointIsOnBoundingBoxFace(expectedIntersection1, boundingBoxMin, boundingBoxMax, 1.0E-12);
                        this.assertPointIsOnBoundingBoxFace(actualIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                        this.assertPointIsOnBoundingBoxFace(expectedIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstEdgePoint, (Point2DReadOnly)secondEdgePoint, null, null);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstEdgePoint, (Vector2DReadOnly)lineDirection, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstEdgePoint, (Vector2DReadOnly)lineDirection, null, null);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        Point2D firstPointOutsideBox = new Point2D();
                        Point2D secondPointOutsideBox = new Point2D();
                        firstPointOutsideBox.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0), (Tuple2DReadOnly)invLineDirection, (Tuple2DReadOnly)firstEdgePoint);
                        secondPointOutsideBox.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)secondEdgePoint);
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOutsideBox, (Point2DReadOnly)secondPointOutsideBox, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)secondPointOutsideBox, (Point2DReadOnly)firstPointOutsideBox, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOutsideBox, (Point2DReadOnly)secondPointOutsideBox, null, null);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
            Point2D insidePoint = new Point2D();
            insidePoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insidePoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            Point2D outsidePoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            int index = random.nextInt(2);
            if (random.nextBoolean()) {
                outsidePoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                outsidePoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            Vector2D lineDirection1 = new Vector2D();
            lineDirection1.sub((Tuple2DReadOnly)outsidePoint, (Tuple2DReadOnly)insidePoint);
            Vector2D lineDirection2 = new Vector2D();
            lineDirection2.sub((Tuple2DReadOnly)insidePoint, (Tuple2DReadOnly)outsidePoint);
            Point2D originalFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D firstIntersection = new Point2D((Tuple2DReadOnly)originalFirstIntersection);
            Point2D secondIntersection = new Point2D((Tuple2DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsidePoint, (Point2DReadOnly)insidePoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsidePoint, (Point2DReadOnly)insidePoint, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsidePoint, (Vector2DReadOnly)lineDirection1, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsidePoint, (Vector2DReadOnly)lineDirection2, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)insidePoint, (Vector2DReadOnly)lineDirection1, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)insidePoint, (Vector2DReadOnly)lineDirection2, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)firstIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)secondIntersection, (Point2DReadOnly)insidePoint, (Point2DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
        }
    }

    @Test
    public void testIntersectionBetweenLineSegment2DAndBoundingBox2D() throws Exception {
        Point2D firstPointOnLine;
        Point2D firstIntersection;
        Point2D originalFirstIntersection;
        Point2D outsideEndpoint;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        Point2D boundingBoxMax;
        int i;
        Random random = new Random(564654L);
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
            lineSegmentStart = new Point2D();
            lineSegmentEnd = new Point2D();
            double alphaStartX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaStartY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lineSegmentStart.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaStartX));
            lineSegmentStart.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaStartY));
            double alphaEndX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaEndY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lineSegmentEnd.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaEndX));
            lineSegmentEnd.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaEndY));
            Point2D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D actualFirstIntersection = new Point2D((Tuple2DReadOnly)expectedFirstIntersection);
            Point2D actualSecondIntersection = new Point2D((Tuple2DReadOnly)expectedSecondIntersection);
            int expectedNumberOfIntersections = 0;
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
            actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D boundingBoxMax2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    boundingBoxMax2.absolute();
                    boundingBoxMax2.add((Tuple2DReadOnly)boundingBoxMin);
                    Point2D lineSegmentStart2 = new Point2D();
                    Point2D lineSegmentEnd2 = new Point2D();
                    Point2D alphaStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    lineSegmentStart2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaStart.getX()));
                    lineSegmentStart2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaStart.getY()));
                    Point2D alphaEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaEnd.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaEnd.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    lineSegmentEnd2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaEnd.getX()));
                    lineSegmentEnd2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaEnd.getY()));
                    Point2D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D actualFirstIntersection = new Point2D((Tuple2DReadOnly)expectedFirstIntersection);
                    Point2D actualSecondIntersection = new Point2D((Tuple2DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalFirstIntersection2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D firstIntersection2 = new Point2D((Tuple2DReadOnly)originalFirstIntersection2);
            Point2D secondIntersection = new Point2D((Tuple2DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)firstIntersection2, (Point2DBasics)secondIntersection);
            switch (numberOfIntersections) {
                case 0: {
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)firstIntersection2);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
                    break;
                }
                case 1: {
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection2, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
                    break;
                }
                case 2: {
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection2, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    break;
                }
                default: {
                    Assertions.fail((String)("Not expecting a number of intersections different than 0, 1, or 2. Got:" + numberOfIntersections));
                }
            }
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
            Point2D insideEndpoint = new Point2D();
            insideEndpoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insideEndpoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            outsideEndpoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            int index = random.nextInt(2);
            if (random.nextBoolean()) {
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            originalFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            firstIntersection = new Point2D((Tuple2DReadOnly)originalFirstIntersection);
            Point2D secondIntersection = new Point2D((Tuple2DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)insideEndpoint, (Point2DReadOnly)outsideEndpoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, insideEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsideEndpoint, (Point2DReadOnly)insideEndpoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, insideEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsideEndpoint, (Point2DReadOnly)insideEndpoint, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple2DReadOnly)boundingBoxMin);
            Point2D onFaceEndpoint = new Point2D();
            onFaceEndpoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            outsideEndpoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            int index = random.nextInt(2);
            if (random.nextBoolean()) {
                onFaceEndpoint.setElement(index, boundingBoxMax.getElement(index));
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                onFaceEndpoint.setElement(index, boundingBoxMin.getElement(index));
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            originalFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            firstIntersection = new Point2D((Tuple2DReadOnly)originalFirstIntersection);
            Point2D secondIntersection = new Point2D((Tuple2DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)onFaceEndpoint, (Point2DReadOnly)outsideEndpoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)outsideEndpoint, (Point2DReadOnly)onFaceEndpoint, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D edgeAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        Vector2D boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.1, (double)10.0);
                        Vector2D lineDirection = new Vector2D();
                        Point2D boxEdgePoint = new Point2D();
                        Point2D pointOutsideBox = new Point2D();
                        firstPointOnLine = new Point2D();
                        Point2D secondPointOnLine = new Point2D();
                        pointOutsideBox.add((Tuple2DReadOnly)boxPosition, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)(-0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(0)), (double)(-0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(1))));
                        pointOutsideBox.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0)));
                        boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + axisDirection * (0.5 * boxSize.getElement(edgeAxis)));
                        boxEdgePoint.setElement(edgeAxis.other(), boxPosition.getElement(edgeAxis.other()) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis.other()));
                        Point2D boundingBoxMin = new Point2D();
                        Point2D boundingBoxMax3 = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax3.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        Point2D actualFirstIntersection = new Point2D();
                        Point2D actualSecondIntersection = new Point2D();
                        lineDirection.sub((Tuple2DReadOnly)boxEdgePoint, (Tuple2DReadOnly)pointOutsideBox);
                        firstPointOnLine.set(pointOutsideBox);
                        secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)boxEdgePoint);
                        Point2D expectedIntersection = new Point2D();
                        expectedIntersection.set(boxEdgePoint);
                        int expectedNumberOfIntersections = 1;
                        int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax3, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualFirstIntersection, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                        actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax3, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, null, null);
                        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        Vector2D boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                        Point2D boundingBoxMin = new Point2D();
                        Point2D boundingBoxMax4 = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax4.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        Vector2D lineDirection = new Vector2D();
                        firstPointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax4.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax4.getY());
                        firstPointOnLine.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                        Point2D boxEdgePoint = new Point2D();
                        boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                        boxEdgePoint.setElement(hoveringAxis.other(), boxPosition.getElement(hoveringAxis.other()) + edgeDirection * (0.5 * boxSize.getElement(hoveringAxis.other())));
                        lineDirection.sub((Tuple2DReadOnly)boxEdgePoint, (Tuple2DReadOnly)firstPointOnLine);
                        Point2D expectedIntersection1 = new Point2D();
                        expectedIntersection1.set(firstPointOnLine);
                        Point2D expectedIntersection2 = new Point2D();
                        expectedIntersection2.set(boxEdgePoint);
                        Point2D secondPointOnLine = new Point2D();
                        secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)boxEdgePoint);
                        Point2D actualIntersection1 = new Point2D();
                        Point2D actualIntersection2 = new Point2D();
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax4, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax4, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, null, null);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        expectedIntersection1.set(boxEdgePoint);
                        expectedIntersection2.set(firstPointOnLine);
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax4, (Point2DReadOnly)secondPointOnLine, (Point2DReadOnly)firstPointOnLine, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax4, (Point2DReadOnly)secondPointOnLine, (Point2DReadOnly)firstPointOnLine, null, null);
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D boundingBoxMax5 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax5.absolute();
            boundingBoxMax5.add((Tuple2DReadOnly)boundingBoxMin);
            Point2D onFaceEndpoint1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax5.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax5.getY());
            Point2D onFaceEndpoint2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax5.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax5.getY());
            int index = random.nextInt(2);
            if (random.nextBoolean()) {
                onFaceEndpoint1.setElement(index, boundingBoxMax5.getElement(index));
                onFaceEndpoint2.setElement(index, boundingBoxMax5.getElement(index));
            } else {
                onFaceEndpoint1.setElement(index, boundingBoxMin.getElement(index));
                onFaceEndpoint2.setElement(index, boundingBoxMin.getElement(index));
            }
            originalFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D originalSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            firstIntersection = new Point2D((Tuple2DReadOnly)originalFirstIntersection);
            Point2D secondIntersection = new Point2D((Tuple2DReadOnly)originalSecondIntersection);
            Point2D originalFirstPoint = new Point2D((Tuple2DReadOnly)onFaceEndpoint1);
            Point2D originalSecondPoint = new Point2D((Tuple2DReadOnly)onFaceEndpoint2);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax5, (Point2DReadOnly)onFaceEndpoint1, (Point2DReadOnly)onFaceEndpoint2, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax5, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax5, 1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)firstIntersection, (EuclidGeometry)onFaceEndpoint1, (double)3.0E-8);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)secondIntersection, (EuclidGeometry)onFaceEndpoint2, (double)3.0E-8);
            firstIntersection.setToNaN();
            secondIntersection.setToNaN();
            onFaceEndpoint2.set(originalFirstPoint);
            onFaceEndpoint1.set(originalSecondPoint);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax5, (Point2DReadOnly)onFaceEndpoint1, (Point2DReadOnly)onFaceEndpoint2, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax5, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax5, 1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)firstIntersection, (EuclidGeometry)onFaceEndpoint1, (double)3.0E-8);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)secondIntersection, (EuclidGeometry)onFaceEndpoint2, (double)3.0E-8);
            firstIntersection.setToNaN();
            secondIntersection.setToNaN();
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(), (Point2DReadOnly)new Point2D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(), (Point2DReadOnly)new Point2D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(-1.0, 0.0), (Point2DReadOnly)new Point2D(), (Point2DReadOnly)new Point2D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(0.0, -1.0), (Point2DReadOnly)new Point2D(), (Point2DReadOnly)new Point2D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(), (Point2DReadOnly)new Point2D(), null, null);
    }

    private void assertPointIsOnBoundingBoxFace(Point2D query, Point2D boundingBoxMin, Point2D boundingBoxMax, double epsilon) {
        for (int i = 0; i < 2; ++i) {
            if (!(Math.abs(query.getElement(i) - boundingBoxMin.getElement(i)) < epsilon) && !(Math.abs(query.getElement(i) - boundingBoxMax.getElement(i)) < epsilon)) continue;
            int nextIndex = (i + 1) % 2;
            Assertions.assertTrue((boundingBoxMin.getElement(nextIndex) <= query.getElement(nextIndex) + epsilon && query.getElement(nextIndex) <= boundingBoxMax.getElement(nextIndex) + epsilon ? 1 : 0) != 0);
            return;
        }
        Assertions.fail((String)"The query does not belong to any face of the bounding box.");
    }

    private void assertPointIsBetweenEndPointsOfLineSegment(Point2D query, Point2D lineSegmentStart, Point2D lineSegmentEnd, double epsilon) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)query, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        Assertions.assertTrue((percentage >= -epsilon && percentage <= 1.0 + epsilon ? 1 : 0) != 0);
        double distance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)query, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        Assertions.assertEquals((double)0.0, (double)distance, (double)epsilon);
    }

    @Test
    public void testIntersectionBetweenLine2DAndLineSegment2D() throws Exception {
        Vector2D lineDirection;
        Point2D pointOnLine;
        boolean success;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        double epsilon = 1.0E-11;
        Random random = new Random(23423L);
        Point2D actualIntersection = new Point2D();
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D pointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            Vector2D lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D();
            lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineLineIntersection = new Point2D();
            lineLineIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0));
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)lineLineIntersection);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertFalse((boolean)success);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection);
            actualIntersection.setToZero();
            Assertions.assertNull((Object)EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertFalse((boolean)success);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection);
            actualIntersection.setToZero();
            Assertions.assertNull((Object)EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            lineLineIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0, (double)0.0));
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)lineLineIntersection);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertFalse((boolean)success);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection);
            actualIntersection.setToZero();
            Assertions.assertNull((Object)EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertFalse((boolean)success);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection);
            actualIntersection.setToZero();
            Assertions.assertNull((Object)EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D();
            lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D expectedIntersection = new Point2D();
            expectedIntersection.set(lineSegmentStart);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)expectedIntersection);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            expectedIntersection.set(lineSegmentEnd);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)expectedIntersection);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection.normalize();
            if (random.nextBoolean()) {
                lineDirection.negate();
            }
            Vector2D orthogonal = new Vector2D(-lineDirection.getY(), lineDirection.getY());
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnLine);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertFalse((boolean)success);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection);
            actualIntersection.setToZero();
            Assertions.assertNull((Object)EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            pointOnLine = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection.normalize();
            if (random.nextBoolean()) {
                lineDirection.negate();
            }
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentStart, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentStart, (EuclidGeometry)actualIntersection, (double)epsilon);
            success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentEnd, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentEnd, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
    }

    @Test
    public void testIntersectionBetweenLine3DAndBoundingBox3D() throws Exception {
        int i;
        Random random = new Random(4353435L);
        for (i = 0; i < 1000; ++i) {
            for (int hoveringAxisIndex = 0; hoveringAxisIndex < 3; ++hoveringAxisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    boundingBoxMax.absolute();
                    boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
                    Point3D firstPointOnLine = new Point3D();
                    Point3D secondPointOnLine = new Point3D();
                    Vector3D lineDirection = new Vector3D();
                    int otherIndex = (hoveringAxisIndex + random.nextInt(2) + 1) % 3;
                    Point3D alphaStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D alphaEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    if (random.nextBoolean()) {
                        alphaStart.setElement(otherIndex, 0.0);
                        alphaEnd.setElement(otherIndex, 1.0);
                    } else {
                        alphaStart.setElement(otherIndex, 1.0);
                        alphaEnd.setElement(otherIndex, 0.0);
                    }
                    firstPointOnLine.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaStart.getX()));
                    firstPointOnLine.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaStart.getY()));
                    firstPointOnLine.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)alphaStart.getZ()));
                    secondPointOnLine.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaEnd.getX()));
                    secondPointOnLine.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaEnd.getY()));
                    secondPointOnLine.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)alphaEnd.getZ()));
                    lineDirection.sub((Tuple3DReadOnly)secondPointOnLine, (Tuple3DReadOnly)firstPointOnLine);
                    Point3D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D actualFirstIntersection = new Point3D((Tuple3DReadOnly)expectedFirstIntersection);
                    Point3D actualSecondIntersection = new Point3D((Tuple3DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Point3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            Point3D boxPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                            Vector3D boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0E-4, (double)10.0);
                            Vector3D lineDirection = new Vector3D();
                            Point3D boxEdgePoint = new Point3D();
                            Point3D firstPointOnLine = new Point3D();
                            Point3D secondPointOnLine = new Point3D();
                            firstPointOnLine.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            firstPointOnLine.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0)));
                            boxEdgePoint.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            boxEdgePoint.setElement((Axis3D)edgeAxis, boxPosition.getElement((Axis3D)edgeAxis) + edgeDirection * 0.5 * boxSize.getElement((Axis3D)edgeAxis));
                            boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            Point3D boundingBoxMin = new Point3D();
                            Point3D boundingBoxMax = new Point3D();
                            boundingBoxMin.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            Point3D actualFirstIntersection = new Point3D();
                            Point3D actualSecondIntersection = new Point3D();
                            secondPointOnLine.set(boxEdgePoint);
                            lineDirection.sub((Tuple3DReadOnly)secondPointOnLine, (Tuple3DReadOnly)firstPointOnLine);
                            Point3D expectedIntersection = new Point3D();
                            expectedIntersection.set(boxEdgePoint);
                            int expectedNumberOfIntersections = 1;
                            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualFirstIntersection, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                            actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null, null);
                            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                            actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualFirstIntersection, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                            actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, null, null);
                            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
            Point3D insidePoint = new Point3D();
            insidePoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insidePoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insidePoint.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            Point3D outsidePoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            int index = random.nextInt(3);
            if (random.nextBoolean()) {
                outsidePoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                outsidePoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            Vector3D lineDirection1 = new Vector3D();
            lineDirection1.sub((Tuple3DReadOnly)outsidePoint, (Tuple3DReadOnly)insidePoint);
            Vector3D lineDirection2 = new Vector3D();
            lineDirection2.sub((Tuple3DReadOnly)insidePoint, (Tuple3DReadOnly)outsidePoint);
            Point3D originalFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D firstIntersection = new Point3D((Tuple3DReadOnly)originalFirstIntersection);
            Point3D secondIntersection = new Point3D((Tuple3DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsidePoint, (Point3DReadOnly)insidePoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsidePoint, (Point3DReadOnly)insidePoint, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsidePoint, (Vector3DReadOnly)lineDirection1, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsidePoint, (Vector3DReadOnly)lineDirection2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)insidePoint, (Vector3DReadOnly)lineDirection1, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)insidePoint, (Vector3DReadOnly)lineDirection2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)insidePoint, (Point3DReadOnly)outsidePoint), (double)1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            for (int index = 0; index < 3; ++index) {
                for (int index2 = 0; index2 < 3; ++index2) {
                    if (index == index2) continue;
                    Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    boundingBoxMax.absolute();
                    boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
                    Point3D firstEdgePoint = new Point3D();
                    Point3D secondEdgePoint = new Point3D();
                    firstEdgePoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)random.nextDouble()));
                    firstEdgePoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)random.nextDouble()));
                    firstEdgePoint.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)random.nextDouble()));
                    secondEdgePoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)random.nextDouble()));
                    secondEdgePoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)random.nextDouble()));
                    secondEdgePoint.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)random.nextDouble()));
                    if (random.nextBoolean()) {
                        firstEdgePoint.setElement(index, boundingBoxMin.getElement(index));
                    } else {
                        firstEdgePoint.setElement(index, boundingBoxMax.getElement(index));
                    }
                    if (random.nextBoolean()) {
                        secondEdgePoint.setElement(index2, boundingBoxMin.getElement(index2));
                    } else {
                        secondEdgePoint.setElement(index2, boundingBoxMax.getElement(index2));
                    }
                    Vector3D lineDirection = new Vector3D();
                    Vector3D invlineDirection = new Vector3D();
                    lineDirection.sub((Tuple3DReadOnly)secondEdgePoint, (Tuple3DReadOnly)firstEdgePoint);
                    invlineDirection.sub((Tuple3DReadOnly)firstEdgePoint, (Tuple3DReadOnly)secondEdgePoint);
                    Point3D firstIntersection = new Point3D();
                    Point3D secondIntersection = new Point3D();
                    Point3D expectedIntersection1 = new Point3D();
                    expectedIntersection1.set(firstEdgePoint);
                    Point3D expectedIntersection2 = new Point3D();
                    expectedIntersection2.set(secondEdgePoint);
                    int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstEdgePoint, (Point3DReadOnly)secondEdgePoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)firstEdgePoint, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)secondEdgePoint, (EuclidGeometry)secondIntersection, (double)3.0E-8);
                    Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)firstIntersection, (Point3DReadOnly)expectedIntersection1, (Point3DReadOnly)secondEdgePoint), (double)1.0E-12);
                    Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)secondIntersection, (Point3DReadOnly)expectedIntersection2, (Point3DReadOnly)secondEdgePoint), (double)1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstEdgePoint, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(secondEdgePoint, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstEdgePoint, (Point3DReadOnly)secondEdgePoint, null, null);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
                    Point3D firstPointOutsideBox = new Point3D();
                    Point3D secondPointOutsideBox = new Point3D();
                    firstPointOutsideBox.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0), (Tuple3DReadOnly)invlineDirection, (Tuple3DReadOnly)firstEdgePoint);
                    secondPointOutsideBox.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)secondEdgePoint);
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOutsideBox, (Point3DReadOnly)secondPointOutsideBox, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)secondIntersection, (double)3.0E-8);
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)secondPointOutsideBox, (Point3DReadOnly)firstPointOutsideBox, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)secondIntersection, (double)3.0E-8);
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOutsideBox, (Point3DReadOnly)secondPointOutsideBox, null, null);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting 2 intersections");
                }
            }
        }
    }

    @Test
    public void testIntersectionBetweenLine3DAndCylinder3D() throws Exception {
        Point3D pointOnCylinder;
        int numberOfIntersections;
        Point3D actualIntersection1;
        Point3D secondPointOnLine;
        Vector3D lineDirection;
        double cylinderTopZ;
        Point3D cylinderPosition;
        double cylinderRadius;
        double cylinderLength;
        int i;
        Vector3D lineDirection2;
        int numberOfIntersections2;
        RigidBodyTransform transform;
        Point3D secondIntersection;
        Point3D firstIntersection;
        Vector3D lineDirection3;
        Point3D secondPointOnLine2;
        Point3D firstPointOnLine;
        double cylinderTopZ2;
        Vector3D cylinderAxis;
        Point3D cylinderPosition2;
        double cylinderRadius2;
        double cylinderLength2;
        int i2;
        Random random = new Random(65226L);
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            firstPointOnLine = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)firstPointOnLine, (Tuple3DBasics)firstPointOnLine);
            secondPointOnLine2 = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)secondPointOnLine2, (Tuple3DBasics)secondPointOnLine2);
            lineDirection3 = new Vector3D();
            lineDirection3.sub((Tuple3DReadOnly)secondPointOnLine2, (Tuple3DReadOnly)firstPointOnLine);
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection3, (Tuple3DReadOnly)firstPointOnLine);
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection3, (Tuple3DReadOnly)secondPointOnLine2);
            lineDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            cylinderAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, firstPointOnLine, secondPointOnLine2, lineDirection3).forEach(transformable -> transformable.applyTransform((Transform)transform));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection3, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            double cylinderBottomZ = -0.5 * cylinderLength2;
            firstPointOnLine = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)firstPointOnLine, (Tuple3DBasics)firstPointOnLine);
            secondPointOnLine2 = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)secondPointOnLine2, (Tuple3DBasics)secondPointOnLine2);
            lineDirection3 = new Vector3D();
            lineDirection3.sub((Tuple3DReadOnly)secondPointOnLine2, (Tuple3DReadOnly)firstPointOnLine);
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection3, (Tuple3DReadOnly)firstPointOnLine);
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection3, (Tuple3DReadOnly)secondPointOnLine2);
            lineDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            cylinderAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, firstPointOnLine, secondPointOnLine2, lineDirection3).forEach(transformable -> transformable.applyTransform((Transform)transform));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection3, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D firstPointOnLine2 = new Point3D(cylinderRadius2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0), 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ2));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)firstPointOnLine2, (Tuple3DBasics)firstPointOnLine2);
            Vector3D fromCylinderToPoint = new Vector3D((Tuple3DReadOnly)firstPointOnLine2);
            fromCylinderToPoint.setZ(0.0);
            lineDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fromCylinderToPoint, (boolean)true);
            Point3D secondPointOnLine3 = new Point3D();
            secondPointOnLine3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)firstPointOnLine2);
            firstPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)firstPointOnLine2);
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            cylinderAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D firstIntersection2 = new Point3D();
            Point3D secondIntersection2 = new Point3D();
            RigidBodyTransform transform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, firstPointOnLine2, secondPointOnLine3, lineDirection2).forEach(transformable -> transformable.applyTransform((Transform)transform2));
            int numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine3, (Point3DBasics)firstIntersection2, (Point3DBasics)secondIntersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)firstIntersection2, (Point3DBasics)secondIntersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D expectedIntersection1 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection1, (Tuple3DBasics)expectedIntersection1);
            Point3D expectedIntersection2 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection2, (Tuple3DBasics)expectedIntersection2);
            lineDirection2 = new Vector3D();
            lineDirection2.sub((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)expectedIntersection1);
            lineDirection2.normalize();
            Point3D firstPointOnLine3 = new Point3D();
            Point3D secondPointOnLine4 = new Point3D();
            firstPointOnLine3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)expectedIntersection1);
            secondPointOnLine4.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection2, (Tuple3DReadOnly)firstPointOnLine3);
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            cylinderAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actualIntersection12 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            RigidBodyTransform transform3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, firstPointOnLine3, secondPointOnLine4, lineDirection2, expectedIntersection1, expectedIntersection2).forEach(transformable -> transformable.applyTransform((Transform)transform3));
            int numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine3, (Point3DReadOnly)secondPointOnLine4, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections4);
            numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine3, (Vector3DReadOnly)lineDirection2, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections4);
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine3, (Point3DReadOnly)secondPointOnLine4, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection12, (double)1.0E-11);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)1.0E-11);
            actualIntersection12.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine3, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection12, (double)1.0E-11);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)1.0E-11);
            actualIntersection12.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)secondPointOnLine4, (Point3DReadOnly)firstPointOnLine3, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection12, (double)1.0E-11);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)1.0E-11);
            actualIntersection12.setToNaN();
            actualIntersection2.setToNaN();
            lineDirection2.negate();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine3, (Vector3DReadOnly)lineDirection2, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection12, (double)1.0E-11);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)1.0E-11);
        }
        ArrayList<Double> errors = new ArrayList<Double>();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis2 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D expectedIntersection1 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection1, (Tuple3DBasics)expectedIntersection1);
            Point3D expectedIntersection2 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection2, (Tuple3DBasics)expectedIntersection2);
            lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)expectedIntersection1);
            lineDirection.normalize();
            Point3D firstPointOnLine4 = new Point3D();
            secondPointOnLine = new Point3D();
            firstPointOnLine4.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection1);
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine4);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)2.0));
            cylinderAxis2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)2.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            RigidBodyTransform transform4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis2, firstPointOnLine4, secondPointOnLine, lineDirection, expectedIntersection1, expectedIntersection2).forEach(transformable -> transformable.applyTransform((Transform)transform4));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)firstPointOnLine4, (Point3DReadOnly)secondPointOnLine, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)firstPointOnLine4, (Vector3DReadOnly)lineDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)firstPointOnLine4, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)firstPointOnLine4, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)secondPointOnLine, (Point3DReadOnly)firstPointOnLine4, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineDirection.negate();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)firstPointOnLine4, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection2));
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)3.0E-11);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis3 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderTopZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnTop);
            lineDirection.normalize();
            Point3D firstPointOnLine5 = new Point3D();
            secondPointOnLine = new Point3D();
            firstPointOnLine5.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnTop);
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine5);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            cylinderAxis3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            RigidBodyTransform transform5 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis3, firstPointOnLine5, secondPointOnLine, lineDirection, pointOnTop, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform5));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)firstPointOnLine5, (Point3DReadOnly)secondPointOnLine, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)firstPointOnLine5, (Vector3DReadOnly)lineDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)firstPointOnLine5, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)firstPointOnLine5, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)secondPointOnLine, (Point3DReadOnly)firstPointOnLine5, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineDirection.negate();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)firstPointOnLine5, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis4 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D pointOnBottom = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom, (Tuple3DBasics)pointOnBottom);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnBottom);
            lineDirection.normalize();
            Point3D firstPointOnLine6 = new Point3D();
            secondPointOnLine = new Point3D();
            firstPointOnLine6.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnBottom);
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine6);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            cylinderAxis4.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            RigidBodyTransform transform6 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis4, firstPointOnLine6, secondPointOnLine, lineDirection, pointOnBottom, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform6));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)firstPointOnLine6, (Point3DReadOnly)secondPointOnLine, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)firstPointOnLine6, (Vector3DReadOnly)lineDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)firstPointOnLine6, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)firstPointOnLine6, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)secondPointOnLine, (Point3DReadOnly)firstPointOnLine6, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineDirection.negate();
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)firstPointOnLine6, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
    }

    @Test
    public void testIntersectionBetweenLine3DAndEllipsoid3D() throws Exception {
        int numberOfIntersections;
        Point3D intersection2;
        Point3D intersection1;
        Point3D secondPointOnLine;
        double sqrtSumOfSquares;
        double radiusZ;
        double radiusY;
        double radiusX;
        int i;
        Random random = new Random(7654L);
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            Point3D pointOnEllipsoid = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid.getX() / radiusX), (double)(pointOnEllipsoid.getY() / radiusY), (double)(pointOnEllipsoid.getZ() / radiusZ));
            pointOnEllipsoid.scale(1.0 / sqrtSumOfSquares);
            Vector3D normalAtPoint = new Vector3D((Tuple3DReadOnly)pointOnEllipsoid);
            normalAtPoint.scale(1.0 / (radiusX * radiusX), 1.0 / (radiusY * radiusY), 1.0 / (radiusZ * radiusZ));
            normalAtPoint.normalize();
            Point3D firstPointOnLine = new Point3D();
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0), (Tuple3DReadOnly)normalAtPoint, (Tuple3DReadOnly)pointOnEllipsoid);
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAtPoint, (boolean)true);
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine);
            secondPointOnLine = new Point3D();
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine);
            intersection1 = new Point3D();
            intersection2 = new Point3D();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            Point3D pointOnEllipsoid1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid1.getX() / radiusX), (double)(pointOnEllipsoid1.getY() / radiusY), (double)(pointOnEllipsoid1.getZ() / radiusZ));
            pointOnEllipsoid1.scale(1.0 / sqrtSumOfSquares);
            Point3D pointOnEllipsoid2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid2.getX() / radiusX), (double)(pointOnEllipsoid2.getY() / radiusY), (double)(pointOnEllipsoid2.getZ() / radiusZ));
            pointOnEllipsoid2.scale(1.0 / sqrtSumOfSquares);
            Vector3D lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)pointOnEllipsoid2, (Tuple3DReadOnly)pointOnEllipsoid1);
            lineDirection.normalize();
            Point3D firstPointOnLine = new Point3D();
            secondPointOnLine = new Point3D();
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnEllipsoid1);
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)firstPointOnLine);
            intersection1 = new Point3D();
            intersection2 = new Point3D();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection2, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)secondPointOnLine, (Point3DReadOnly)firstPointOnLine, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection2, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection2, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineDirection.negate();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)secondPointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection2, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
        }
    }

    @Test
    public void testIntersectionBetweenLine3DAndPlane3D() throws Exception {
        Vector3D planeNormal;
        Point3D pointOnPlane;
        int i;
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D expectedIntersection = new Point3D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            Vector3D lineDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D pointOnLine = new Point3D();
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            Point3D actualIntersection = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            double epsilon = 1.0E-12;
            if (Math.abs(lineDirection.angle((Vector3DReadOnly)planeNormal)) > 1.5697963267948967) {
                epsilon = 1.0E-11;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)false);
            Point3D pointOnLine = new Point3D();
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnPlane);
            Point3D actualIntersection = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertNull((Object)actualIntersection);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)pointOnLine);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertNull((Object)actualIntersection);
        }
    }

    @Test
    public void testIntersectionBetweenLineSegment3DAndBoundingBox3D() throws Exception {
        Point3D expectedIntersection1;
        Point3D secondIntersection;
        Point3D firstIntersection;
        Point3D outsideEndpoint;
        Point3D lineSegmentEnd;
        Point3D lineSegmentStart;
        Point3D boundingBoxMax;
        int i;
        Random random = new Random(564654L);
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
            lineSegmentStart = new Point3D();
            lineSegmentEnd = new Point3D();
            double alphaStartX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaStartY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaStartZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lineSegmentStart.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaStartX));
            lineSegmentStart.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaStartY));
            lineSegmentStart.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)alphaStartZ));
            double alphaEndX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaEndY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaEndZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lineSegmentEnd.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)alphaEndX));
            lineSegmentEnd.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)alphaEndY));
            lineSegmentEnd.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)alphaEndZ));
            Point3D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D actualFirstIntersection = new Point3D((Tuple3DReadOnly)expectedFirstIntersection);
            Point3D actualSecondIntersection = new Point3D((Tuple3DReadOnly)expectedSecondIntersection);
            int expectedNumberOfIntersections = 0;
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
            actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D boundingBoxMax2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    boundingBoxMax2.absolute();
                    boundingBoxMax2.add((Tuple3DReadOnly)boundingBoxMin);
                    Point3D lineSegmentStart2 = new Point3D();
                    Point3D lineSegmentEnd2 = new Point3D();
                    Point3D alphaStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    lineSegmentStart2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaStart.getX()));
                    lineSegmentStart2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaStart.getY()));
                    lineSegmentStart2.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax2.getZ(), (double)alphaStart.getZ()));
                    Point3D alphaEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaEnd.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaEnd.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    lineSegmentEnd2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaEnd.getX()));
                    lineSegmentEnd2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaEnd.getY()));
                    lineSegmentEnd2.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax2.getZ(), (double)alphaEnd.getZ()));
                    Point3D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D actualFirstIntersection = new Point3D((Tuple3DReadOnly)expectedFirstIntersection);
                    Point3D actualSecondIntersection = new Point3D((Tuple3DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax2, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax2, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
            lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D firstIntersection2 = new Point3D((Tuple3DReadOnly)originalFirstIntersection);
            Point3D secondIntersection2 = new Point3D((Tuple3DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersection2, (Point3DBasics)secondIntersection2);
            switch (numberOfIntersections) {
                case 0: {
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection2);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
                    break;
                }
                case 1: {
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection2, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
                    break;
                }
                case 2: {
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection2, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection2, lineSegmentStart, lineSegmentEnd, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(secondIntersection2, boundingBoxMin, boundingBoxMax, 1.0E-12);
                    break;
                }
                default: {
                    Assertions.fail((String)("Not expecting a number of intersections different than 0, 1, or 2. Got:" + numberOfIntersections));
                }
            }
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin);
            Point3D insideEndpoint = new Point3D();
            insideEndpoint.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insideEndpoint.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            insideEndpoint.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax.getZ(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            outsideEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            int index = random.nextInt(3);
            if (random.nextBoolean()) {
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            Point3D originalFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            firstIntersection = new Point3D((Tuple3DReadOnly)originalFirstIntersection);
            Point3D secondIntersection3 = new Point3D((Tuple3DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)insideEndpoint, (Point3DReadOnly)outsideEndpoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection3);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, insideEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection3);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection3.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsideEndpoint, (Point3DReadOnly)insideEndpoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection3);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, insideEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax, 1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection3);
            int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)outsideEndpoint, (Point3DReadOnly)insideEndpoint, null, null);
            Assertions.assertEquals((int)numberOfIntersections, (int)actualNumberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D axis : Axis3D.values) {
                for (Axis3D edgeAxis : Axis3D.values) {
                    for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                        if (axis.ordinal() == edgeAxis.ordinal()) continue;
                        Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                        Point3D boundingBoxMax3 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                        boundingBoxMax3.absolute();
                        boundingBoxMax3.add((Tuple3DReadOnly)boundingBoxMin);
                        Point3D onEdgePoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax3.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax3.getY(), (double)boundingBoxMin.getZ(), (double)boundingBoxMax3.getZ());
                        if (random.nextBoolean()) {
                            onEdgePoint.setElement(axis, boundingBoxMax3.getElement(axis));
                            if (axisDirection > 0.0) {
                                onEdgePoint.setElement(edgeAxis, boundingBoxMax3.getElement(edgeAxis));
                            } else {
                                onEdgePoint.setElement(edgeAxis, boundingBoxMin.getElement(edgeAxis));
                            }
                        } else {
                            onEdgePoint.setElement(axis, boundingBoxMin.getElement(axis));
                            if (axisDirection > 0.0) {
                                onEdgePoint.setElement(edgeAxis, boundingBoxMax3.getElement(edgeAxis));
                            } else {
                                onEdgePoint.setElement(edgeAxis, boundingBoxMin.getElement(edgeAxis));
                            }
                        }
                        Point3D outsideEndpoint2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                        outsideEndpoint2.scaleAdd(axisDirection, (Tuple3DReadOnly)outsideEndpoint2, (Tuple3DReadOnly)onEdgePoint);
                        outsideEndpoint2.setElement(axis, onEdgePoint.getElement(axis));
                        Point3D firstIntersection3 = new Point3D();
                        secondIntersection = new Point3D();
                        expectedIntersection1 = new Point3D();
                        expectedIntersection1.set(onEdgePoint);
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax3, (Point3DReadOnly)onEdgePoint, (Point3DReadOnly)outsideEndpoint2, (Point3DBasics)firstIntersection3, (Point3DBasics)secondIntersection);
                        Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)firstIntersection3, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                        this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection3, onEdgePoint, outsideEndpoint2, 1.0E-12);
                        this.assertPointIsOnBoundingBoxFace(firstIntersection3, boundingBoxMin, boundingBoxMax3, 1.0E-12);
                        firstIntersection3.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax3, (Point3DReadOnly)outsideEndpoint2, (Point3DReadOnly)onEdgePoint, (Point3DBasics)firstIntersection3, (Point3DBasics)secondIntersection);
                        Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
                        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)firstIntersection3, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                        this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection3, onEdgePoint, outsideEndpoint2, 1.0E-12);
                        this.assertPointIsOnBoundingBoxFace(firstIntersection3, boundingBoxMin, boundingBoxMax3, 1.0E-12);
                        firstIntersection3.setToNaN();
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D boundingBoxMax4 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax4.absolute();
            boundingBoxMax4.add((Tuple3DReadOnly)boundingBoxMin);
            Point3D onFaceEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax4.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax4.getY(), (double)boundingBoxMin.getZ(), (double)boundingBoxMax4.getZ());
            outsideEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            int index = random.nextInt(3);
            if (random.nextBoolean()) {
                onFaceEndpoint.setElement(index, boundingBoxMax4.getElement(index));
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax4.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0)));
            } else {
                onFaceEndpoint.setElement(index, boundingBoxMin.getElement(index));
                outsideEndpoint.setElement(index, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(index), (double)boundingBoxMax4.getElement(index), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0)));
            }
            Point3D originalFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            firstIntersection = new Point3D((Tuple3DReadOnly)originalFirstIntersection);
            Point3D secondIntersection4 = new Point3D((Tuple3DReadOnly)originalSecondIntersection);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax4, (Point3DReadOnly)onFaceEndpoint, (Point3DReadOnly)outsideEndpoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection4);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax4, 1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection4);
            firstIntersection.set(originalFirstIntersection);
            secondIntersection4.set(originalSecondIntersection);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax4, (Point3DReadOnly)outsideEndpoint, (Point3DReadOnly)onFaceEndpoint, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection4);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)"Was expecting only one intersection");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint, outsideEndpoint, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax4, 1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection4);
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D axis : Axis3D.values) {
                for (Axis3D edgeAxis : Axis3D.values) {
                    if (axis.ordinal() == edgeAxis.ordinal()) continue;
                    Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D boundingBoxMax5 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    boundingBoxMax5.absolute();
                    boundingBoxMax5.add((Tuple3DReadOnly)boundingBoxMin);
                    Point3D onFaceEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax5.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax5.getY(), (double)boundingBoxMin.getZ(), (double)boundingBoxMax5.getZ());
                    Point3D onEdgePoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax5.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax5.getY(), (double)boundingBoxMin.getZ(), (double)boundingBoxMax5.getZ());
                    if (random.nextBoolean()) {
                        onFaceEndpoint.setElement(axis, boundingBoxMax5.getElement(axis));
                        onEdgePoint.setElement(axis, boundingBoxMax5.getElement(axis));
                        if (random.nextBoolean()) {
                            onEdgePoint.setElement(edgeAxis, boundingBoxMax5.getElement(edgeAxis));
                        } else {
                            onEdgePoint.setElement(edgeAxis, boundingBoxMin.getElement(edgeAxis));
                        }
                    } else {
                        onFaceEndpoint.setElement(axis, boundingBoxMin.getElement(axis));
                        onEdgePoint.setElement(axis, boundingBoxMin.getElement(axis));
                        if (random.nextBoolean()) {
                            onEdgePoint.setElement(edgeAxis, boundingBoxMin.getElement(edgeAxis));
                        } else {
                            onEdgePoint.setElement(edgeAxis, boundingBoxMax5.getElement(edgeAxis));
                        }
                    }
                    Point3D outsideEndpoint3 = new Point3D();
                    Vector3D rayDirection = new Vector3D();
                    rayDirection.sub((Tuple3DReadOnly)onEdgePoint, (Tuple3DReadOnly)onFaceEndpoint);
                    outsideEndpoint3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)onEdgePoint);
                    Point3D firstIntersection4 = new Point3D();
                    secondIntersection = new Point3D();
                    expectedIntersection1 = new Point3D();
                    expectedIntersection1.set(onFaceEndpoint);
                    Point3D expectedIntersection2 = new Point3D();
                    expectedIntersection2.set(onEdgePoint);
                    int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax5, (Point3DReadOnly)onFaceEndpoint, (Point3DReadOnly)outsideEndpoint3, (Point3DBasics)firstIntersection4, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)firstIntersection4, (double)3.0E-8);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)secondIntersection, (double)3.0E-8);
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection4, onFaceEndpoint, outsideEndpoint3, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection4, boundingBoxMin, boundingBoxMax5, 1.0E-12);
                    firstIntersection4.setToNaN();
                    secondIntersection.setToNaN();
                    expectedIntersection1.set(onEdgePoint);
                    expectedIntersection2.set(onFaceEndpoint);
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax5, (Point3DReadOnly)outsideEndpoint3, (Point3DReadOnly)onFaceEndpoint, (Point3DBasics)firstIntersection4, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)firstIntersection4, (double)3.0E-8);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)secondIntersection, (double)3.0E-8);
                    this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection4, onFaceEndpoint, outsideEndpoint3, 1.0E-12);
                    this.assertPointIsOnBoundingBoxFace(firstIntersection4, boundingBoxMin, boundingBoxMax5, 1.0E-12);
                    firstIntersection4.setToNaN();
                    secondIntersection.setToNaN();
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D boundingBoxMax6 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax6.absolute();
            boundingBoxMax6.add((Tuple3DReadOnly)boundingBoxMin);
            Point3D onFaceEndpoint1 = new Point3D();
            Point3D onFaceEndpoint2 = new Point3D();
            onFaceEndpoint1.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax6.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint1.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax6.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint1.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax6.getZ(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax6.getX(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax6.getY(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            onFaceEndpoint2.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin.getZ(), (double)boundingBoxMax6.getZ(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            int index = random.nextInt(3);
            if (random.nextBoolean()) {
                onFaceEndpoint1.setElement(index, boundingBoxMax6.getElement(index));
                onFaceEndpoint2.setElement(index, boundingBoxMax6.getElement(index));
            } else {
                onFaceEndpoint1.setElement(index, boundingBoxMin.getElement(index));
                onFaceEndpoint2.setElement(index, boundingBoxMin.getElement(index));
            }
            Point3D originalFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D originalSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            firstIntersection = new Point3D((Tuple3DReadOnly)originalFirstIntersection);
            Point3D secondIntersection5 = new Point3D((Tuple3DReadOnly)originalSecondIntersection);
            Point3D originalFirstPoint = new Point3D((Tuple3DReadOnly)onFaceEndpoint1);
            Point3D originalSecondPoint = new Point3D((Tuple3DReadOnly)onFaceEndpoint2);
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax6, (Point3DReadOnly)onFaceEndpoint1, (Point3DReadOnly)onFaceEndpoint2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection5);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection5, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax6, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection5, boundingBoxMin, boundingBoxMax6, 1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)firstIntersection, (EuclidGeometry)onFaceEndpoint1, (double)3.0E-8);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)secondIntersection5, (EuclidGeometry)onFaceEndpoint2, (double)3.0E-8);
            onFaceEndpoint2.set(originalFirstPoint);
            onFaceEndpoint1.set(originalSecondPoint);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax6, (Point3DReadOnly)onFaceEndpoint1, (Point3DReadOnly)onFaceEndpoint2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection5);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)"Was expecting two intersections");
            this.assertPointIsBetweenEndPointsOfLineSegment(firstIntersection, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsBetweenEndPointsOfLineSegment(secondIntersection5, onFaceEndpoint1, onFaceEndpoint2, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax6, 1.0E-12);
            this.assertPointIsOnBoundingBoxFace(secondIntersection5, boundingBoxMin, boundingBoxMax6, 1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)firstIntersection, (EuclidGeometry)onFaceEndpoint1, (double)3.0E-8);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)secondIntersection5, (EuclidGeometry)onFaceEndpoint2, (double)3.0E-8);
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 1.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 1.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(-1.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, -1.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, -1.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Point3DReadOnly)new Point3D(), null, null);
    }

    private void assertPointIsOnBoundingBoxFace(Point3D query, Point3D boundingBoxMin, Point3D boundingBoxMax, double epsilon) {
        for (Axis3D axis : Axis3D.values) {
            if (!EuclidCoreTools.epsilonEquals((double)query.getElement(axis), (double)boundingBoxMin.getElement(axis), (double)epsilon) && !EuclidCoreTools.epsilonEquals((double)query.getElement(axis), (double)boundingBoxMax.getElement(axis), (double)epsilon)) continue;
            Axis3D nextAxis = axis.next();
            Assertions.assertTrue((boundingBoxMin.getElement(nextAxis) <= query.getElement(nextAxis) + epsilon && query.getElement(nextAxis) <= boundingBoxMax.getElement(nextAxis) + epsilon ? 1 : 0) != 0);
            Axis3D prevAxis = axis.previous();
            Assertions.assertTrue((boundingBoxMin.getElement(prevAxis) <= query.getElement(prevAxis) + epsilon && query.getElement(prevAxis) <= boundingBoxMax.getElement(prevAxis) + epsilon ? 1 : 0) != 0);
            return;
        }
        Assertions.fail((String)"The query does not belong to any face of the bounding box.");
    }

    private void assertPointIsBetweenEndPointsOfLineSegment(Point3D query, Point3D lineSegmentStart, Point3D lineSegmentEnd, double epsilon) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
        Assertions.assertTrue((percentage >= -epsilon && percentage <= 1.0 + epsilon ? 1 : 0) != 0);
        double distance = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
        Assertions.assertEquals((double)0.0, (double)distance, (double)epsilon);
    }

    @Test
    public void testIntersectionBetweenLineSegment3DAndCylinder3D() throws Exception {
        Point3D pointOnCylinder;
        int numberOfIntersections;
        Point3D actualIntersection2;
        Point3D actualIntersection1;
        double cylinderTopZ;
        Point3D cylinderPosition;
        double cylinderRadius;
        double cylinderLength;
        int i;
        Point3D pointOnTop;
        int numberOfIntersections2;
        RigidBodyTransform transform;
        Point3D secondIntersection;
        Point3D firstIntersection;
        Vector3D lineSegmentDirection;
        Point3D lineSegmentEnd;
        Point3D lineSegmentStart;
        double cylinderTopZ2;
        Vector3D cylinderAxis;
        Point3D cylinderPosition2;
        double cylinderRadius2;
        double cylinderLength2;
        int i2;
        Random random = new Random(65226L);
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            lineSegmentStart = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)lineSegmentStart, (Tuple3DBasics)lineSegmentStart);
            lineSegmentEnd = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)lineSegmentEnd, (Tuple3DBasics)lineSegmentEnd);
            lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentStart.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentEnd.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentEnd);
            lineSegmentDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            RigidBodyTransform transform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, lineSegmentStart, lineSegmentEnd).forEach(transformable -> transformable.applyTransform((Transform)transform2));
            int numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            double cylinderBottomZ = -0.5 * cylinderLength2;
            lineSegmentStart = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)lineSegmentStart, (Tuple3DBasics)lineSegmentStart);
            lineSegmentEnd = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)lineSegmentEnd, (Tuple3DBasics)lineSegmentEnd);
            lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentStart.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentEnd.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentEnd);
            lineSegmentDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            int numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D lineSegmentStart2 = new Point3D(cylinderRadius2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0), 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ2));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)lineSegmentStart2, (Tuple3DBasics)lineSegmentStart2);
            Vector3D fromCylinderToPoint = new Vector3D((Tuple3DReadOnly)lineSegmentStart2);
            fromCylinderToPoint.setZ(0.0);
            Vector3D lineSegmentDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fromCylinderToPoint, (boolean)true);
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)lineSegmentStart2);
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection2, (Tuple3DReadOnly)lineSegmentStart2);
            lineSegmentDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D firstIntersection2 = new Point3D();
            Point3D secondIntersection2 = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, lineSegmentStart2, lineSegmentEnd2).forEach(transformable -> transformable.applyTransform((Transform)transform));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)firstIntersection2, (Point3DBasics)secondIntersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D pointOnBottom = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom, (Tuple3DBasics)pointOnBottom);
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            Point3D lineSegmentStart3 = new Point3D();
            Point3D lineSegmentEnd3 = new Point3D();
            Point3D actualIntersection12 = new Point3D();
            Point3D actualIntersection22 = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, lineSegmentStart3, lineSegmentEnd3, pointOnBottom, pointOnTop).forEach(transformable -> transformable.applyTransform((Transform)transform));
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection22, (double)1.0E-12);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection22, (Point3DBasics)actualIntersection12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection22, (double)1.0E-12);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            lineSegmentStart3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd3.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnTop, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart3, (Point3DReadOnly)lineSegmentEnd3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentEnd3, (Point3DReadOnly)lineSegmentStart3, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection22);
            actualIntersection12.setToNaN();
            actualIntersection22.setToNaN();
        }
        ArrayList<Double> errors = new ArrayList<Double>();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis2 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D pointOnCylinder1 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder1, (Tuple3DBasics)pointOnCylinder1);
            Point3D pointOnCylinder2 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder2, (Tuple3DBasics)pointOnCylinder2);
            Point3D lineSegmentStart4 = new Point3D();
            Point3D lineSegmentEnd4 = new Point3D();
            actualIntersection1 = new Point3D();
            actualIntersection2 = new Point3D();
            RigidBodyTransform transform3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis2, lineSegmentStart4, lineSegmentEnd4, pointOnCylinder1, pointOnCylinder2).forEach(transformable -> transformable.applyTransform((Transform)transform3));
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder2.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder2.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder2, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder2.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder2, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder2.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd4.interpolate((Tuple3DReadOnly)pointOnCylinder1, (Tuple3DReadOnly)pointOnCylinder2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentStart4, (Point3DReadOnly)lineSegmentEnd4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)lineSegmentEnd4, (Point3DReadOnly)lineSegmentStart4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis3 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderTopZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            Point3D lineSegmentStart5 = new Point3D();
            Point3D lineSegmentEnd5 = new Point3D();
            actualIntersection1 = new Point3D();
            actualIntersection2 = new Point3D();
            RigidBodyTransform transform4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis3, lineSegmentStart5, lineSegmentEnd5, pointOnTop, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform4));
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection2, (Point3DBasics)actualIntersection1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection2));
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            lineSegmentStart5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd5.interpolate((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentStart5, (Point3DReadOnly)lineSegmentEnd5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)lineSegmentEnd5, (Point3DReadOnly)lineSegmentStart5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection1.setToNaN();
            actualIntersection2.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis4 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D pointOnBottom = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom, (Tuple3DBasics)pointOnBottom);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            Vector3D lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnBottom);
            lineDirection.normalize();
            Point3D lineSegmentStart6 = new Point3D();
            Point3D lineSegmentEnd6 = new Point3D();
            Point3D actualIntersection13 = new Point3D();
            Point3D actualIntersection23 = new Point3D();
            RigidBodyTransform transform5 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis4, lineSegmentStart6, lineSegmentEnd6, pointOnBottom, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform5));
            lineSegmentStart6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            int numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections5);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection23, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection23));
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentEnd6, (Point3DReadOnly)lineSegmentStart6, (Point3DBasics)actualIntersection23, (Point3DBasics)actualIntersection13);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection23, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection23));
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            lineSegmentStart6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections5);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentEnd6, (Point3DReadOnly)lineSegmentStart6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            lineSegmentStart6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections5);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentEnd6, (Point3DReadOnly)lineSegmentStart6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection13, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection13));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            lineSegmentStart6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections5);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection13);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentEnd6, (Point3DReadOnly)lineSegmentStart6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection13);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            lineSegmentStart6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd6.interpolate((Tuple3DReadOnly)pointOnBottom, (Tuple3DReadOnly)pointOnCylinder, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections5);
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentStart6, (Point3DReadOnly)lineSegmentEnd6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection13);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
            EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)lineSegmentEnd6, (Point3DReadOnly)lineSegmentStart6, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection13);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
            actualIntersection13.setToNaN();
            actualIntersection23.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
    }

    @Test
    public void testIntersectionBetweenLineSegment3DAndEllipsoid3D() throws Exception {
        double sqrtSumOfSquares;
        double radiusZ;
        double radiusY;
        double radiusX;
        int i;
        Random random = new Random(23454L);
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            Point3D pointOnEllipsoid = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid.getX() / radiusX), (double)(pointOnEllipsoid.getY() / radiusY), (double)(pointOnEllipsoid.getZ() / radiusZ));
            pointOnEllipsoid.scale(1.0 / sqrtSumOfSquares);
            Vector3D normalAtPoint = new Vector3D((Tuple3DReadOnly)pointOnEllipsoid);
            normalAtPoint.scale(1.0 / (radiusX * radiusX), 1.0 / (radiusY * radiusY), 1.0 / (radiusZ * radiusZ));
            normalAtPoint.normalize();
            Point3D lineSegmentStart = new Point3D();
            lineSegmentStart.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0), (Tuple3DReadOnly)normalAtPoint, (Tuple3DReadOnly)pointOnEllipsoid);
            Vector3D lineSegmentDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAtPoint, (boolean)true);
            lineSegmentStart.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentStart);
            Point3D lineSegmentEnd = new Point3D();
            lineSegmentEnd.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineSegmentDirection, (Tuple3DReadOnly)lineSegmentStart);
            Point3D intersection1 = new Point3D();
            Point3D intersection2 = new Point3D();
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            Point3D pointOnEllipsoid1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid1.getX() / radiusX), (double)(pointOnEllipsoid1.getY() / radiusY), (double)(pointOnEllipsoid1.getZ() / radiusZ));
            pointOnEllipsoid1.scale(1.0 / sqrtSumOfSquares);
            Point3D pointOnEllipsoid2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid2.getX() / radiusX), (double)(pointOnEllipsoid2.getY() / radiusY), (double)(pointOnEllipsoid2.getZ() / radiusZ));
            pointOnEllipsoid2.scale(1.0 / sqrtSumOfSquares);
            Point3D intersection1 = new Point3D();
            Point3D intersection2 = new Point3D();
            Point3D lineSegmentStart = new Point3D();
            Point3D lineSegmentEnd = new Point3D();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection2, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection2, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            lineSegmentStart.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentEnd, (Point3DReadOnly)lineSegmentStart, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
        }
    }

    @Test
    public void testIntersectionBetweenLineSegment3DAndPlane3D() throws Exception {
        Vector3D planeNormal;
        Point3D pointOnPlane;
        int i;
        Point3D endPoint0 = new Point3D();
        Point3D endPoint1 = new Point3D();
        Random random = new Random(1175L);
        for (i = 0; i < 1000; ++i) {
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D expectedIntersection = new Point3D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            Vector3D lineDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            Point3D actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)1.0E-11);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)1.0E-11);
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1);
            Assertions.assertNull((Object)actualIntersection);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint1, (Point3DReadOnly)endPoint0);
            Assertions.assertNull((Object)actualIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)false);
            endPoint0.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnPlane);
            endPoint1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnPlane);
            Point3D actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1);
            Assertions.assertNull((Object)actualIntersection);
            double distanceAwayFromPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            endPoint0.scaleAdd(distanceAwayFromPlane, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)endPoint0);
            endPoint1.scaleAdd(distanceAwayFromPlane, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)endPoint0);
            actualIntersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)endPoint0, (Point3DReadOnly)endPoint1);
            Assertions.assertNull((Object)actualIntersection);
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndBoundingBox2D() throws Exception {
        Point2D boxEdgePoint;
        Point2D rayOrigin;
        Vector2D rayDirection;
        Point2D boundingBoxMax;
        Vector2D boxSize;
        Vector2D rayDirection2;
        int i;
        Random random = new Random(4353435L);
        for (i = 0; i < 1000; ++i) {
            for (int hoveringAxisIndex = 0; hoveringAxisIndex < 2; ++hoveringAxisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D boundingBoxMax2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    boundingBoxMax2.absolute();
                    boundingBoxMax2.add((Tuple2DReadOnly)boundingBoxMin);
                    Point2D rayOrigin2 = new Point2D();
                    Point2D pointOnRay = new Point2D();
                    Vector2D rayDirection3 = new Vector2D();
                    int otherIndex = (hoveringAxisIndex + 1) % 2;
                    Point2D alphaStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D alphaEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    if (random.nextBoolean()) {
                        alphaStart.setElement(otherIndex, 0.0);
                        alphaEnd.setElement(otherIndex, 1.0);
                    } else {
                        alphaStart.setElement(otherIndex, 1.0);
                        alphaEnd.setElement(otherIndex, 0.0);
                    }
                    rayOrigin2.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaStart.getX()));
                    rayOrigin2.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaStart.getY()));
                    pointOnRay.setX(EuclidCoreTools.interpolate((double)boundingBoxMin.getX(), (double)boundingBoxMax2.getX(), (double)alphaEnd.getX()));
                    pointOnRay.setY(EuclidCoreTools.interpolate((double)boundingBoxMin.getY(), (double)boundingBoxMax2.getY(), (double)alphaEnd.getY()));
                    rayDirection3.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin2);
                    Point2D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    Point2D actualFirstIntersection = new Point2D((Tuple2DReadOnly)expectedFirstIntersection);
                    Point2D actualSecondIntersection = new Point2D((Tuple2DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax2, (Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection3, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax2, (Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection3, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                Point2D boundingBoxMax3 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                boundingBoxMax3.absolute();
                boundingBoxMax3.add((Tuple2DReadOnly)boundingBoxMin);
                int nextAxis = (axisIndex + 1) % 2;
                Point2D rayOrigin3 = new Point2D();
                rayDirection2 = new Vector2D();
                Vector2D axisDirection = new Vector2D();
                axisDirection.setElement(axisIndex, 1.0);
                Vector2D orthogonalToAxis = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)axisDirection);
                if (random.nextBoolean()) {
                    rayOrigin3.setElement(axisIndex, boundingBoxMax3.getElement(axisIndex) + random.nextDouble());
                    rayDirection2.interpolate((Tuple2DReadOnly)axisDirection, (Tuple2DReadOnly)orthogonalToAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                } else {
                    rayOrigin3.setElement(axisIndex, boundingBoxMin.getElement(axisIndex) - random.nextDouble());
                    axisDirection.negate();
                    rayDirection2.interpolate((Tuple2DReadOnly)axisDirection, (Tuple2DReadOnly)orthogonalToAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                }
                rayOrigin3.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(nextAxis), (double)boundingBoxMax3.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax3, (Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, null, null);
                Assertions.assertEquals((int)0, (int)numberOfIntersections);
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                        Point2D boundingBoxMin = new Point2D();
                        boundingBoxMax = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        rayDirection = new Vector2D();
                        Point2D pointOnRay = new Point2D();
                        Point2D rayOrigin4 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax.getY());
                        rayOrigin4.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                        pointOnRay.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize.getElement(hoveringAxis)));
                        pointOnRay.setElement(hoveringAxis.other(), boxPosition.getElement(hoveringAxis.other()) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis.other()) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                        rayDirection.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin4);
                        Point2D firstIntersection = new Point2D();
                        Point2D secondIntersection = new Point2D();
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)firstIntersection);
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection, null, null);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D boundingBoxMax4 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            boundingBoxMax4.absolute();
            boundingBoxMax4.add((Tuple2DReadOnly)boundingBoxMin);
            Point2D rayOrigin5 = new Point2D();
            for (int axis = 0; axis < 2; ++axis) {
                rayOrigin5.setElement(axis, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(axis), (double)boundingBoxMax4.getElement(axis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            }
            Vector2D rayDirection4 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D firstIntersection = new Point2D();
            Point2D secondIntersection = new Point2D();
            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax4, (Point2DReadOnly)rayOrigin5, (Vector2DReadOnly)rayDirection4, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax4, 1.0E-12);
            this.assertPointIsOnRay(firstIntersection, rayOrigin5, rayDirection4, 1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                    Vector2D boxSize2 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                    Point2D boundingBoxMin = new Point2D();
                    Point2D boundingBoxMax5 = new Point2D();
                    boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize2, (Tuple2DReadOnly)boxPosition);
                    boundingBoxMax5.scaleAdd(0.5, (Tuple2DReadOnly)boxSize2, (Tuple2DReadOnly)boxPosition);
                    Point2D rayOrigin6 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax5.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax5.getY());
                    rayOrigin6.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize2.getElement(hoveringAxis));
                    Point2D pointOnRay = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                    pointOnRay.setElement(hoveringAxis, rayOrigin6.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                    rayDirection = new Vector2D();
                    rayDirection.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin6);
                    Point2D expectedIntersection = new Point2D();
                    expectedIntersection.set(rayOrigin6);
                    Point2D firstIntersection = new Point2D();
                    Point2D secondIntersection = new Point2D();
                    int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax5, (Point2DReadOnly)rayOrigin6, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
                    firstIntersection.setToNaN();
                    numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax5, (Point2DReadOnly)rayOrigin6, (Vector2DReadOnly)rayDirection, null, null);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis2D edgeAxis : Axis2D.values()) {
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                            Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                            Vector2D boxSize3 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                            Point2D boundingBoxMin = new Point2D();
                            Point2D boundingBoxMax6 = new Point2D();
                            boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize3, (Tuple2DReadOnly)boxPosition);
                            boundingBoxMax6.scaleAdd(0.5, (Tuple2DReadOnly)boxSize3, (Tuple2DReadOnly)boxPosition);
                            Point2D rayOrigin7 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax6.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax6.getY());
                            rayOrigin7.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize3.getElement(hoveringAxis));
                            rayOrigin7.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize3.getElement(edgeAxis));
                            Point2D pointOnRay = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                            pointOnRay.setElement(hoveringAxis, rayOrigin7.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                            Vector2D rayDirection5 = new Vector2D();
                            rayDirection5.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin7);
                            Point2D expectedIntersection = new Point2D();
                            expectedIntersection.set(rayOrigin7);
                            Point2D firstIntersection = new Point2D();
                            Point2D secondIntersection = new Point2D();
                            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax6, (Point2DReadOnly)rayOrigin7, (Vector2DReadOnly)rayDirection5, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
                            firstIntersection.setToNaN();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax6, (Point2DReadOnly)rayOrigin7, (Vector2DReadOnly)rayDirection5, null, null);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        boxSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                        Point2D boundingBoxMin = new Point2D();
                        boundingBoxMax = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax.scaleAdd(0.5, (Tuple2DReadOnly)boxSize, (Tuple2DReadOnly)boxPosition);
                        rayDirection = new Vector2D();
                        rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax.getY());
                        rayOrigin.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                        boxEdgePoint = new Point2D();
                        boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis)));
                        boxEdgePoint.setElement(hoveringAxis.other(), boxPosition.getElement(hoveringAxis.other()) + edgeDirection * (0.5 * boxSize.getElement(hoveringAxis.other())));
                        rayDirection.sub((Tuple2DReadOnly)boxEdgePoint, (Tuple2DReadOnly)rayOrigin);
                        Point2D expectedIntersection = new Point2D();
                        expectedIntersection.set(boxEdgePoint);
                        Point2D actualIntersection1 = new Point2D();
                        Point2D actualIntersection2 = new Point2D();
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualIntersection2);
                        actualIntersection1.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, null, null);
                        Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                Point2D boundingBoxMin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                Point2D boundingBoxMax7 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                boundingBoxMax7.absolute();
                boundingBoxMax7.add((Tuple2DReadOnly)boundingBoxMin);
                int nextAxis = (axisIndex + 1) % 2;
                Point2D rayOrigin8 = new Point2D();
                rayDirection2 = new Vector2D();
                Point2D pointOnRay = new Point2D();
                if (random.nextBoolean()) {
                    rayOrigin8.setElement(axisIndex, boundingBoxMax7.getElement(axisIndex) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
                    pointOnRay.setElement(axisIndex, boundingBoxMax7.getElement(axisIndex));
                } else {
                    rayOrigin8.setElement(axisIndex, boundingBoxMin.getElement(axisIndex) - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
                    pointOnRay.setElement(axisIndex, boundingBoxMin.getElement(axisIndex));
                }
                pointOnRay.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(nextAxis), (double)boundingBoxMax7.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayOrigin8.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin.getElement(nextAxis), (double)boundingBoxMax7.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayDirection2.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin8);
                rayDirection2.normalize();
                rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
                Point2D firstIntersection = new Point2D();
                Point2D secondIntersection = new Point2D();
                int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax7, (Point2DReadOnly)rayOrigin8, (Vector2DReadOnly)rayDirection2, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
                Assertions.assertEquals((int)2, (int)numberOfIntersections);
                this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin, boundingBoxMax7, 1.0E-12);
                this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin, boundingBoxMax7, 1.0E-12);
                this.assertPointIsOnRay(firstIntersection, rayOrigin8, pointOnRay, 1.0E-12);
                this.assertPointIsOnRay(secondIntersection, rayOrigin8, pointOnRay, 1.0E-12);
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis2D hoveringAxis : Axis2D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                        Point2D boxPosition = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
                        Vector2D boxSize4 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.001, (double)10.0);
                        Point2D boundingBoxMin = new Point2D();
                        boundingBoxMax = new Point2D();
                        boundingBoxMin.scaleAdd(-0.5, (Tuple2DReadOnly)boxSize4, (Tuple2DReadOnly)boxPosition);
                        boundingBoxMax.scaleAdd(0.5, (Tuple2DReadOnly)boxSize4, (Tuple2DReadOnly)boxPosition);
                        rayDirection = new Vector2D();
                        rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)boundingBoxMin.getX(), (double)boundingBoxMax.getX(), (double)boundingBoxMin.getY(), (double)boundingBoxMax.getY());
                        rayOrigin.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                        boxEdgePoint = new Point2D();
                        boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                        boxEdgePoint.setElement(hoveringAxis.other(), boxPosition.getElement(hoveringAxis.other()) + edgeDirection * (0.5 * boxSize4.getElement(hoveringAxis.other())));
                        rayDirection.sub((Tuple2DReadOnly)boxEdgePoint, (Tuple2DReadOnly)rayOrigin);
                        Point2D expectedIntersection1 = new Point2D();
                        expectedIntersection1.set(rayOrigin);
                        Point2D expectedIntersection2 = new Point2D();
                        expectedIntersection2.set(boxEdgePoint);
                        Point2D actualIntersection1 = new Point2D();
                        Point2D actualIntersection2 = new Point2D();
                        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, null, null);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)boxEdgePoint);
                        rayDirection.negate();
                        expectedIntersection1.set(boxEdgePoint);
                        Point2D boxEdgePoint2 = new Point2D();
                        boxEdgePoint2.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                        boxEdgePoint2.setElement(hoveringAxis.other(), boxPosition.getElement(hoveringAxis.other()) - edgeDirection * (0.5 * boxSize4.getElement(hoveringAxis.other())));
                        expectedIntersection2.set(boxEdgePoint2);
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)actualIntersection1, (Point2DBasics)actualIntersection2);
                        Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                        actualIntersection1.setToNaN();
                        actualIntersection2.setToNaN();
                        numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, null, null);
                    }
                }
            }
        }
    }

    private void assertPointIsOnRay(Point2D query, Point2D rayOrigin, Vector2D rayDirection, double epsilon) {
        Point2D pointOnRay = new Point2D();
        pointOnRay.add((Tuple2DReadOnly)rayOrigin, (Tuple2DReadOnly)rayDirection);
        this.assertPointIsOnRay(query, rayOrigin, pointOnRay, epsilon);
    }

    private void assertPointIsOnRay(Point2D query, Point2D rayOrigin, Point2D pointOnRay, double epsilon) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)query, (Point2DReadOnly)rayOrigin, (Point2DReadOnly)pointOnRay);
        Assertions.assertTrue((percentage >= -epsilon ? 1 : 0) != 0);
        double distance = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)rayOrigin, (Point2DReadOnly)pointOnRay);
        Assertions.assertEquals((double)0.0, (double)distance, (double)epsilon);
    }

    @Test
    public void testDoRay2DAndLineSegment2DIntersect() throws Exception {
        double distance;
        double alpha1;
        Point2D rayOrigin;
        Point2D rayOrigin2;
        Vector2D rayDirection;
        Point2D intersection;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        Point2D lineSegmentEnd2;
        Vector2D rayDirection2;
        Point2D rayOrigin3;
        int i;
        Random random = new Random(116L);
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D pointOnRay = new Point2D();
            pointOnRay.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            double alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2), (String)("Iteration: " + i));
            alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            intersection = new Point2D();
            intersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart3 = new Point2D();
            Point2D lineSegmentEnd3 = new Point2D();
            lineSegmentStart3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd3, (Point2DReadOnly)lineSegmentStart3), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            intersection = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart4 = new Point2D();
            Point2D lineSegmentEnd4 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart4.scaleAdd(alpha12, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd4.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd4, (Tuple2DReadOnly)lineSegmentStart4);
            if (0.0 < alpha12 || 0.0 < alpha2 || alpha12 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4), (String)("Iteration: " + i));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4), (String)("Iteration: " + i));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4), (String)("Iteration: " + i));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4), (String)("Iteration: " + i));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart4);
            lineSegmentEnd4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd4);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection = new Vector2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart5 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart5.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5), (String)("Iteration: " + i));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5), (String)("Iteration: " + i));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart5.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart5);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            rayDirection = new Vector2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart6 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart6.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
                Assertions.assertTrue((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6), (String)("Iteration: " + i));
            } else {
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
                Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6), (String)("Iteration: " + i));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart6.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart6);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6), (String)("Iteration: " + i));
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndLineSegment2D() throws Exception {
        double distance;
        double alpha1;
        Point2D rayOrigin;
        Point2D rayOrigin2;
        Vector2D rayDirection;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        Point2D lineSegmentEnd2;
        Point2D expectedIntersection;
        Vector2D rayDirection2;
        Point2D rayOrigin3;
        int i;
        Random random = new Random(3242L);
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedIntersection = new Point2D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            double alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin3, rayDirection2, lineSegmentStart2, lineSegmentEnd2);
            alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart3 = new Point2D();
            Point2D lineSegmentEnd3 = new Point2D();
            lineSegmentStart3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(rayOrigin3, rayOrigin3, rayDirection2, lineSegmentStart3, lineSegmentEnd3);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedIntersection = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart4 = new Point2D();
            Point2D lineSegmentEnd4 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart4.scaleAdd(alpha12, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd4.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd4, (Tuple2DReadOnly)lineSegmentStart4);
            if (0.0 < alpha12 || 0.0 < alpha2 || alpha12 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart4);
            lineSegmentEnd4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd4);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
        }
        for (i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection = new Vector2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart5 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart5.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart5.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart5);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            rayDirection = new Vector2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart6 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart6.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart6.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart6);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D rayOrigin4 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            rayDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D front1 = new Point2D();
            Point2D front2 = new Point2D();
            Point2D back1 = new Point2D();
            Point2D back2 = new Point2D();
            front1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            front2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            back1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            back2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            Point2D expectedIntersection2 = new Point2D();
            Point2D actualIntersection = new Point2D();
            expectedIntersection2.set(front1);
            boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front1, (Point2DReadOnly)front2, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front2);
            success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front2, (Point2DReadOnly)front1, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front1);
            success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)back1, (Point2DReadOnly)front1, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front2);
            success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front2, (Point2DReadOnly)back1, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
        }
    }

    private void assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(boolean intersectionExist, Point2D rayOrigin, Vector2D rayDirection, Point2D lineSegmentStart, Point2D lineSegmentEnd) {
        Point2D actualIntersection;
        Point2D intersectionThatMayContainOnlyNaNs = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart)) != null == intersectionExist ? 1 : 0) != 0);
    }

    private void assertAllCombinationsOfTwoLineSegmentsIntersection(Point2D expectedIntersection, Point2D rayOrigin, Vector2D rayDirection, Point2D lineSegmentStart, Point2D lineSegmentEnd) {
        double epsilon = 1.0E-12;
        Vector2D direction1 = new Vector2D();
        direction1.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
        Vector2D direction2 = new Vector2D();
        Point2D lss2 = lineSegmentStart;
        Point2D lse2 = lineSegmentEnd;
        direction2.sub((Tuple2DReadOnly)lse2, (Tuple2DReadOnly)lss2);
        if (Math.abs(rayDirection.dot((Tuple2DReadOnly)direction2)) > 0.9999) {
            epsilon = 1.0E-10;
        }
        Point2D actualIntersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
    }

    @Test
    public void testIntersectionBetweenRay3DAndBoundingBox3D() throws Exception {
        int numberOfIntersections;
        Point3D expectedIntersection;
        Point3D boundingBoxMin;
        Vector3D boxSize;
        Point3D boxPosition;
        Vector3D rayDirection;
        Point3D rayOrigin;
        int i;
        Random random = new Random(4353435L);
        for (i = 0; i < 1000; ++i) {
            for (int hoveringAxisIndex = 0; hoveringAxisIndex < 3; ++hoveringAxisIndex) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point3D boundingBoxMin2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    boundingBoxMax.absolute();
                    boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin2);
                    rayOrigin = new Point3D();
                    Point3D pointOnRay = new Point3D();
                    Vector3D rayDirection2 = new Vector3D();
                    int otherIndex = (hoveringAxisIndex + random.nextInt(2) + 1) % 3;
                    Point3D alphaStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D alphaEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    if (hoveringDirection > 0.0) {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                    } else {
                        alphaStart.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                        alphaEnd.setElement(hoveringAxisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                    }
                    if (random.nextBoolean()) {
                        alphaStart.setElement(otherIndex, 0.0);
                        alphaEnd.setElement(otherIndex, 1.0);
                    } else {
                        alphaStart.setElement(otherIndex, 1.0);
                        alphaEnd.setElement(otherIndex, 0.0);
                    }
                    rayOrigin.setX(EuclidCoreTools.interpolate((double)boundingBoxMin2.getX(), (double)boundingBoxMax.getX(), (double)alphaStart.getX()));
                    rayOrigin.setY(EuclidCoreTools.interpolate((double)boundingBoxMin2.getY(), (double)boundingBoxMax.getY(), (double)alphaStart.getY()));
                    rayOrigin.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin2.getZ(), (double)boundingBoxMax.getZ(), (double)alphaStart.getZ()));
                    pointOnRay.setX(EuclidCoreTools.interpolate((double)boundingBoxMin2.getX(), (double)boundingBoxMax.getX(), (double)alphaEnd.getX()));
                    pointOnRay.setY(EuclidCoreTools.interpolate((double)boundingBoxMin2.getY(), (double)boundingBoxMax.getY(), (double)alphaEnd.getY()));
                    pointOnRay.setZ(EuclidCoreTools.interpolate((double)boundingBoxMin2.getZ(), (double)boundingBoxMax.getZ(), (double)alphaEnd.getZ()));
                    rayDirection2.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin);
                    Point3D expectedFirstIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D expectedSecondIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    Point3D actualFirstIntersection = new Point3D((Tuple3DReadOnly)expectedFirstIntersection);
                    Point3D actualSecondIntersection = new Point3D((Tuple3DReadOnly)expectedSecondIntersection);
                    int expectedNumberOfIntersections = 0;
                    int actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin2, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                    actualNumberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin2, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
                    Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                Point3D boundingBoxMin3 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                boundingBoxMax.absolute();
                boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin3);
                int nextAxis = (axisIndex + 1) % 3;
                int nextNextAxis = (axisIndex + 2) % 3;
                rayOrigin = new Point3D();
                Vector3D rayDirection3 = new Vector3D();
                Vector3D axisDirection = new Vector3D();
                axisDirection.setElement(axisIndex, 1.0);
                Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)axisDirection, (boolean)true);
                if (random.nextBoolean()) {
                    rayOrigin.setElement(axisIndex, boundingBoxMax.getElement(axisIndex) + random.nextDouble());
                    rayDirection3.interpolate((Tuple3DReadOnly)axisDirection, (Tuple3DReadOnly)orthogonalToAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                } else {
                    rayOrigin.setElement(axisIndex, boundingBoxMin3.getElement(axisIndex) - random.nextDouble());
                    axisDirection.negate();
                    rayDirection3.interpolate((Tuple3DReadOnly)axisDirection, (Tuple3DReadOnly)orthogonalToAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                }
                rayOrigin.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin3.getElement(nextAxis), (double)boundingBoxMax.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayOrigin.setElement(nextNextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin3.getElement(nextNextAxis), (double)boundingBoxMax.getElement(nextNextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                int numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin3, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection3, null, null);
                Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                        Point3D boxPosition2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                        Vector3D boxSize2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                        Point3D boundingBoxMin4 = new Point3D();
                        Point3D boundingBoxMax = new Point3D();
                        boundingBoxMin4.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize2, (Tuple3DReadOnly)boxPosition2);
                        boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize2, (Tuple3DReadOnly)boxPosition2);
                        rayDirection = new Vector3D();
                        Point3D rayOrigin2 = new Point3D();
                        rayOrigin2.add((Tuple3DReadOnly)boxPosition2, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize2.getElement(0)), (double)(0.5 * boxSize2.getElement(1)), (double)(0.5 * boxSize2.getElement(2))));
                        rayOrigin2.setElement(hoveringAxis, boxPosition2.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize2.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                        Point3D pointOnRay = new Point3D();
                        pointOnRay.scaleAdd(axisDirection * 0.5, (Tuple3DReadOnly)boxSize2, (Tuple3DReadOnly)boxPosition2);
                        pointOnRay.scaleAdd(axisDirection, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)pointOnRay);
                        pointOnRay.setElement(hoveringAxis, boxPosition2.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize2.getElement(hoveringAxis)));
                        rayDirection.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin2);
                        Point3D firstIntersection = new Point3D();
                        Point3D secondIntersection = new Point3D();
                        int numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin4, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                        numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin4, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection, null, null);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            Point3D boundingBoxMin5 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            boundingBoxMax.absolute();
            boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin5);
            Point3D rayOrigin3 = new Point3D();
            for (int axis = 0; axis < 3; ++axis) {
                rayOrigin3.setElement(axis, EuclidCoreTools.interpolate((double)boundingBoxMin5.getElement(axis), (double)boundingBoxMax.getElement(axis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
            }
            Vector3D rayDirection4 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Point3D firstIntersection = new Point3D();
            Point3D secondIntersection = new Point3D();
            int numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin5, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin3, (Vector3DReadOnly)rayDirection4, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections4);
            this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin5, boundingBoxMax, 1.0E-12);
            this.assertPointIsOnRay(firstIntersection, rayOrigin3, rayDirection4, 1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    Point3D boxPosition3 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                    Vector3D boxSize3 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                    Point3D boundingBoxMin6 = new Point3D();
                    Point3D boundingBoxMax = new Point3D();
                    boundingBoxMin6.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize3, (Tuple3DReadOnly)boxPosition3);
                    boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize3, (Tuple3DReadOnly)boxPosition3);
                    Point3D rayOrigin4 = new Point3D();
                    rayOrigin4.add((Tuple3DReadOnly)boxPosition3, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize3.getElement(0)), (double)(0.5 * boxSize3.getElement(1)), (double)(0.5 * boxSize3.getElement(2))));
                    rayOrigin4.setElement(hoveringAxis, boxPosition3.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize3.getElement(hoveringAxis));
                    Point3D pointOnRay = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    pointOnRay.setElement(hoveringAxis, rayOrigin4.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                    rayDirection = new Vector3D();
                    rayDirection.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin4);
                    Point3D expectedIntersection2 = new Point3D();
                    expectedIntersection2.set((Tuple3DReadOnly)rayOrigin4);
                    Point3D firstIntersection = new Point3D();
                    Point3D secondIntersection = new Point3D();
                    int numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin6, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections5, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                    firstIntersection.setToNaN();
                    numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin6, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection, null, null);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections5, (String)("Iteration: " + i));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                            boxPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                            boundingBoxMin = new Point3D();
                            Point3D boundingBoxMax = new Point3D();
                            boundingBoxMin.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            Point3D rayOrigin5 = new Point3D();
                            rayOrigin5.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin5.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayOrigin5.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            Point3D pointOnRay = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                            pointOnRay.setElement(hoveringAxis, rayOrigin5.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                            Vector3D rayDirection5 = new Vector3D();
                            rayDirection5.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin5);
                            expectedIntersection = new Point3D();
                            expectedIntersection.set((Tuple3DReadOnly)rayOrigin5);
                            Point3D firstIntersection = new Point3D();
                            Point3D secondIntersection = new Point3D();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection5, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                            firstIntersection.setToNaN();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection5, null, null);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            boxPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                            boundingBoxMin = new Point3D();
                            Point3D boundingBoxMax = new Point3D();
                            boundingBoxMin.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            Vector3D rayDirection6 = new Vector3D();
                            Point3D boxEdgePoint = new Point3D();
                            Point3D rayOrigin6 = new Point3D();
                            rayOrigin6.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin6.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0)));
                            boxEdgePoint.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayDirection6.sub((Tuple3DReadOnly)boxEdgePoint, (Tuple3DReadOnly)rayOrigin6);
                            expectedIntersection = new Point3D();
                            expectedIntersection.set(boxEdgePoint);
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection6, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
                            actualIntersection1.setToNaN();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection6, null, null);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                Point3D boundingBoxMin7 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                Point3D boundingBoxMax = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                boundingBoxMax.absolute();
                boundingBoxMax.add((Tuple3DReadOnly)boundingBoxMin7);
                int nextAxis = (axisIndex + 1) % 3;
                int nextNextAxis = (axisIndex + 2) % 3;
                rayOrigin = new Point3D();
                Vector3D rayDirection7 = new Vector3D();
                Point3D pointOnRay = new Point3D();
                if (random.nextBoolean()) {
                    rayOrigin.setElement(axisIndex, boundingBoxMax.getElement(axisIndex) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
                    pointOnRay.setElement(axisIndex, boundingBoxMax.getElement(axisIndex));
                } else {
                    rayOrigin.setElement(axisIndex, boundingBoxMin7.getElement(axisIndex) - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
                    pointOnRay.setElement(axisIndex, boundingBoxMin7.getElement(axisIndex));
                }
                pointOnRay.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin7.getElement(nextAxis), (double)boundingBoxMax.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                pointOnRay.setElement(nextNextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin7.getElement(nextNextAxis), (double)boundingBoxMax.getElement(nextNextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayOrigin.setElement(nextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin7.getElement(nextAxis), (double)boundingBoxMax.getElement(nextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayOrigin.setElement(nextNextAxis, EuclidCoreTools.interpolate((double)boundingBoxMin7.getElement(nextNextAxis), (double)boundingBoxMax.getElement(nextNextAxis), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0)));
                rayDirection7.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin);
                rayDirection7.normalize();
                rayDirection7.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
                Point3D firstIntersection = new Point3D();
                Point3D secondIntersection = new Point3D();
                int numberOfIntersections6 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin7, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection7, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                Assertions.assertEquals((int)2, (int)numberOfIntersections6);
                this.assertPointIsOnBoundingBoxFace(firstIntersection, boundingBoxMin7, boundingBoxMax, 1.0E-12);
                this.assertPointIsOnBoundingBoxFace(secondIntersection, boundingBoxMin7, boundingBoxMax, 1.0E-12);
                this.assertPointIsOnRay(firstIntersection, rayOrigin, pointOnRay, 1.0E-12);
                this.assertPointIsOnRay(secondIntersection, rayOrigin, pointOnRay, 1.0E-12);
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            boxPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                            boundingBoxMin = new Point3D();
                            Point3D boundingBoxMax = new Point3D();
                            boundingBoxMin.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize, (Tuple3DReadOnly)boxPosition);
                            Vector3D rayDirection8 = new Vector3D();
                            Point3D rayOrigin7 = new Point3D();
                            Point3D boxEdgePoint = new Point3D();
                            rayOrigin7.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin7.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            boxEdgePoint.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayDirection8.sub((Tuple3DReadOnly)boxEdgePoint, (Tuple3DReadOnly)rayOrigin7);
                            Point3D expectedIntersection1 = new Point3D();
                            expectedIntersection1.set(rayOrigin7);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set(boxEdgePoint);
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            int numberOfIntersections7 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection8, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections7, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                            numberOfIntersections7 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection8, null, null);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections7, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis1 : Axis3D.values()) {
                        if (edgeAxis1.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection1 = -1.0; edgeDirection1 <= 1.0; edgeDirection1 += 2.0) {
                            for (Point3D edgeAxis2 : Axis3D.values()) {
                                if (edgeAxis2.ordinal() == hoveringAxis.ordinal() || edgeAxis1.ordinal() == edgeAxis2.ordinal()) continue;
                                for (double edgeDirection2 = -1.0; edgeDirection2 <= 1.0; edgeDirection2 += 2.0) {
                                    Point3D boxPosition4 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                                    Vector3D boxSize4 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                                    Point3D boundingBoxMin8 = new Point3D();
                                    Point3D boundingBoxMax = new Point3D();
                                    boundingBoxMin8.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize4, (Tuple3DReadOnly)boxPosition4);
                                    boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize4, (Tuple3DReadOnly)boxPosition4);
                                    Vector3D rayDirection9 = new Vector3D();
                                    Point3D rayOrigin8 = new Point3D();
                                    Point3D boxEdgePoint1 = new Point3D();
                                    Point3D boxEdgePoint2 = new Point3D();
                                    boxEdgePoint1.add((Tuple3DReadOnly)boxPosition4, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize4.getElement(0)), (double)(0.5 * boxSize4.getElement(1)), (double)(0.5 * boxSize4.getElement(2))));
                                    boxEdgePoint1.setElement(hoveringAxis, boxPosition4.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                                    boxEdgePoint1.setElement(edgeAxis1, boxPosition4.getElement(edgeAxis1) + edgeDirection1 * 0.5 * boxSize4.getElement(edgeAxis1));
                                    boxEdgePoint2.add((Tuple3DReadOnly)boxPosition4, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize4.getElement(0)), (double)(0.5 * boxSize4.getElement(1)), (double)(0.5 * boxSize4.getElement(2))));
                                    boxEdgePoint2.setElement(hoveringAxis, boxPosition4.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                                    boxEdgePoint2.setElement((Axis3D)edgeAxis2, boxPosition4.getElement((Axis3D)edgeAxis2) + edgeDirection2 * 0.5 * boxSize4.getElement((Axis3D)edgeAxis2));
                                    rayDirection9.sub((Tuple3DReadOnly)boxEdgePoint2, (Tuple3DReadOnly)boxEdgePoint1);
                                    rayDirection9.normalize();
                                    double maxDiagnoal = Math.max(boxSize4.getX(), boxSize4.getY());
                                    maxDiagnoal = Math.max(maxDiagnoal, boxSize4.getZ());
                                    rayOrigin8.scaleAdd(-1.0 * Math.sqrt(3.0) * maxDiagnoal, (Tuple3DReadOnly)rayDirection9, (Tuple3DReadOnly)boxEdgePoint2);
                                    Point3D expectedIntersection1 = new Point3D();
                                    expectedIntersection1.set(boxEdgePoint1);
                                    Point3D expectedIntersection2 = new Point3D();
                                    expectedIntersection2.set(boxEdgePoint2);
                                    Point3D actualIntersection1 = new Point3D();
                                    Point3D actualIntersection2 = new Point3D();
                                    int numberOfIntersections8 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin8, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection9, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                                    Assertions.assertEquals((int)2, (int)numberOfIntersections8, (String)("Iteration: " + i));
                                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                                    actualIntersection1.setToNaN();
                                    actualIntersection2.setToNaN();
                                    numberOfIntersections8 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin8, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection9, null, null);
                                    Assertions.assertEquals((int)2, (int)numberOfIntersections8, (String)("Iteration: " + i));
                                }
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection1 = -1.0; edgeDirection1 <= 1.0; edgeDirection1 += 2.0) {
                            boxPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
                            Vector3D boxSize5 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.001, (double)10.0);
                            Point3D boundingBoxMin9 = new Point3D();
                            Point3D boundingBoxMax = new Point3D();
                            boundingBoxMin9.scaleAdd(-0.5, (Tuple3DReadOnly)boxSize5, (Tuple3DReadOnly)boxPosition);
                            boundingBoxMax.scaleAdd(0.5, (Tuple3DReadOnly)boxSize5, (Tuple3DReadOnly)boxPosition);
                            Vector3D rayDirection10 = new Vector3D();
                            Point3D rayOrigin9 = new Point3D();
                            Point3D boxCornerPoint1 = new Point3D();
                            Point3D boxCornerPoint2 = new Point3D();
                            boxCornerPoint1.scaleAdd(0.5, (Tuple3DReadOnly)boxSize5, (Tuple3DReadOnly)boxPosition);
                            boxCornerPoint1.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize5.getElement(hoveringAxis));
                            boxCornerPoint2.set(boxCornerPoint1);
                            boxCornerPoint1.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection1 * 0.5 * boxSize5.getElement(edgeAxis));
                            boxCornerPoint2.setElement(edgeAxis, boxPosition.getElement(edgeAxis) - 1.0 * edgeDirection1 * 0.5 * boxSize5.getElement(edgeAxis));
                            rayDirection10.sub((Tuple3DReadOnly)boxCornerPoint2, (Tuple3DReadOnly)boxCornerPoint1);
                            rayDirection10.normalize();
                            double maxDiagnoal = Math.max(boxSize5.getX(), boxSize5.getY());
                            maxDiagnoal = Math.max(maxDiagnoal, boxSize5.getZ());
                            rayOrigin9.scaleAdd(-1.0 * (maxDiagnoal *= Math.sqrt(3.0)), (Tuple3DReadOnly)rayDirection10, (Tuple3DReadOnly)boxCornerPoint2);
                            Point3D expectedIntersection1 = new Point3D();
                            expectedIntersection1.set(boxCornerPoint1);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set(boxCornerPoint2);
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            int numberOfIntersections9 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin9, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection10, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections9, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                            numberOfIntersections9 = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin9, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection10, null, null);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections9, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
    }

    private void assertPointIsOnRay(Point3D query, Point3D rayOrigin, Vector3D rayDirection, double epsilon) {
        Point3D pointOnRay = new Point3D();
        pointOnRay.add((Tuple3DReadOnly)rayOrigin, (Tuple3DReadOnly)rayDirection);
        this.assertPointIsOnRay(query, rayOrigin, pointOnRay, epsilon);
    }

    private void assertPointIsOnRay(Point3D query, Point3D rayOrigin, Point3D pointOnRay, double epsilon) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)rayOrigin, (Point3DReadOnly)pointOnRay);
        Assertions.assertTrue((percentage >= -epsilon ? 1 : 0) != 0);
        double distance = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)query, (Point3DReadOnly)rayOrigin, (Point3DReadOnly)pointOnRay);
        Assertions.assertEquals((double)0.0, (double)distance, (double)epsilon);
    }

    @Test
    public void testIntersectionBetweenRay3DAndBox3DEdgeCases() throws Exception {
        Random random = new Random(65226L);
        int successCounter = 0;
        int failureCounter = 0;
        double successRate = 0.0;
        double rateThreshold = 99.9;
        for (int i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            Point3D boxPosition = new Point3D();
                            Vector3D boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0, (double)10.0);
                            Quaternion boxOrientation = new Quaternion();
                            Vector3D rayDirection = new Vector3D();
                            Point3D boxEdgePoint = new Point3D();
                            Point3D rayOrigin = new Point3D();
                            rayOrigin.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0)));
                            boxEdgePoint.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayDirection.sub((Tuple3DReadOnly)boxEdgePoint, (Tuple3DReadOnly)rayOrigin);
                            Point3D expectedIntersection = new Point3D();
                            expectedIntersection.set(boxEdgePoint);
                            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                            Arrays.asList(boxPosition, boxOrientation, rayOrigin, rayDirection, expectedIntersection).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform));
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            if (numberOfIntersections == 1) {
                                ++successCounter;
                                EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
                                actualIntersection1.setToNaN();
                                numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, null, null);
                                Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                                continue;
                            }
                            ++failureCounter;
                            if (numberOfIntersections != 2) continue;
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                        }
                    }
                }
            }
        }
        successRate = 100.0 / (double)(successCounter + failureCounter) * (double)successCounter;
        Assertions.assertTrue((successRate >= rateThreshold ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionBetweenRay3DAndBox3D() throws Exception {
        int numberOfIntersections;
        Vector3D boxSize;
        Point3D boxPosition;
        RigidBodyTransform transform;
        Point3D expectedIntersection;
        Vector3D rayDirection;
        Point3D pointOnRay;
        Point3D rayOrigin;
        Quaternion boxOrientation;
        Vector3D boxSize2;
        Point3D boxPosition2;
        int i;
        Random random = new Random(65226L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(), null, null));
        for (i = 0; i < 1000; ++i) {
            for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                for (Axis3D hoveringAxis : Axis3D.values()) {
                    boxPosition2 = new Point3D();
                    boxSize2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                    Vector3D rayDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)hoveringAxis, (boolean)true);
                    Quaternion boxOrientation2 = new Quaternion();
                    Point3D rayOrigin2 = new Point3D();
                    rayOrigin2.add((Tuple3DReadOnly)boxPosition2, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
                    rayOrigin2.setElement(hoveringAxis, boxPosition2.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize2.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                    RigidBodyTransform transform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                    Arrays.asList(boxPosition2, boxOrientation2, rayOrigin2, rayDirection2).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform2));
                    Point3D firstIntersection = new Point3D();
                    Point3D secondIntersection = new Point3D();
                    int numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition2, (Orientation3DReadOnly)boxOrientation2, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection2, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                    numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition2, (Orientation3DReadOnly)boxOrientation2, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection2, null, null);
                    Assertions.assertEquals((int)0, (int)numberOfIntersections2, (String)("Iteration: " + i));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    boxPosition2 = new Point3D();
                    boxSize2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                    boxOrientation = new Quaternion();
                    rayOrigin = new Point3D();
                    rayOrigin.add((Tuple3DReadOnly)boxPosition2, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
                    rayOrigin.setElement(hoveringAxis, boxPosition2.getElement(hoveringAxis) + axisDirection * (0.5 * boxSize2.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                    pointOnRay = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    pointOnRay.setElement(hoveringAxis, rayOrigin.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                    rayDirection = new Vector3D();
                    rayDirection.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin);
                    RigidBodyTransform transform3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                    Arrays.asList(boxPosition2, boxOrientation, rayOrigin, rayDirection).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform3));
                    Point3D firstIntersection = new Point3D();
                    Point3D secondIntersection = new Point3D();
                    int numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition2, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                    numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition2, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, null, null);
                    Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                        Point3D boxPosition3 = new Point3D();
                        Vector3D boxSize3 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                        Quaternion boxOrientation3 = new Quaternion();
                        rayDirection = new Vector3D();
                        Point3D rayOrigin3 = new Point3D();
                        rayOrigin3.add((Tuple3DReadOnly)boxPosition3, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize3.getElement(0)), (double)(0.5 * boxSize3.getElement(1)), (double)(0.5 * boxSize3.getElement(2))));
                        rayOrigin3.setElement(hoveringAxis, boxPosition3.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize3.getElement(hoveringAxis) + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0)));
                        Point3D pointOnRay2 = new Point3D();
                        pointOnRay2.scaleAdd(axisDirection * 0.5, (Tuple3DReadOnly)boxSize3, (Tuple3DReadOnly)boxPosition3);
                        pointOnRay2.scaleAdd(axisDirection, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)pointOnRay2);
                        pointOnRay2.setElement(hoveringAxis, boxPosition3.getElement(hoveringAxis) + hoveringDirection * (0.5 * boxSize3.getElement(hoveringAxis)));
                        rayDirection.sub((Tuple3DReadOnly)pointOnRay2, (Tuple3DReadOnly)rayOrigin3);
                        RigidBodyTransform transform4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                        Arrays.asList(boxPosition3, boxOrientation3, rayOrigin3, rayDirection).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform4));
                        Point3D firstIntersection = new Point3D();
                        Point3D secondIntersection = new Point3D();
                        int numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition3, (Orientation3DReadOnly)boxOrientation3, (Vector3DReadOnly)boxSize3, (Point3DReadOnly)rayOrigin3, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i));
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
                        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                        numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition3, (Orientation3DReadOnly)boxOrientation3, (Vector3DReadOnly)boxSize3, (Point3DReadOnly)rayOrigin3, (Vector3DReadOnly)rayDirection, null, null);
                        Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i));
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    Point3D boxPosition4 = new Point3D();
                    boxSize2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                    boxOrientation = new Quaternion();
                    rayOrigin = new Point3D();
                    rayOrigin.add((Tuple3DReadOnly)boxPosition4, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize2.getElement(0)), (double)(0.5 * boxSize2.getElement(1)), (double)(0.5 * boxSize2.getElement(2))));
                    rayOrigin.setElement(hoveringAxis, boxPosition4.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize2.getElement(hoveringAxis));
                    pointOnRay = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    pointOnRay.setElement(hoveringAxis, rayOrigin.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                    rayDirection = new Vector3D();
                    rayDirection.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin);
                    expectedIntersection = new Point3D();
                    expectedIntersection.set((Tuple3DReadOnly)rayOrigin);
                    transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                    Arrays.asList(boxPosition4, boxOrientation, rayOrigin, rayDirection, expectedIntersection).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform));
                    Point3D firstIntersection = new Point3D();
                    Point3D secondIntersection = new Point3D();
                    int numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition4, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections5, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                    firstIntersection.setToNaN();
                    numberOfIntersections5 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition4, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize2, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, null, null);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections5, (String)("Iteration: " + i));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                            boxPosition = new Point3D();
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0E-4, (double)10.0);
                            Quaternion boxOrientation4 = new Quaternion();
                            Point3D rayOrigin4 = new Point3D();
                            rayOrigin4.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin4.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayOrigin4.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            Point3D pointOnRay3 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                            pointOnRay3.setElement(hoveringAxis, rayOrigin4.getElement(hoveringAxis) + axisDirection * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
                            Vector3D rayDirection3 = new Vector3D();
                            rayDirection3.sub((Tuple3DReadOnly)pointOnRay3, (Tuple3DReadOnly)rayOrigin4);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set((Tuple3DReadOnly)rayOrigin4);
                            RigidBodyTransform transform5 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                            Arrays.asList(boxPosition, boxOrientation4, rayOrigin4, rayDirection3, expectedIntersection2, pointOnRay3).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform5));
                            Point3D firstIntersection = new Point3D();
                            Point3D secondIntersection = new Point3D();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation4, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection3, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)firstIntersection, (double)3.0E-8);
                            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
                            firstIntersection.setToNaN();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation4, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection3, null, null);
                            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double hoveringDirection = -1.0; hoveringDirection <= 1.0; hoveringDirection += 2.0) {
                    Point3D boxPosition5 = new Point3D();
                    Vector3D boxSize4 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                    Quaternion boxOrientation5 = new Quaternion();
                    Vector3D rayDirection4 = new Vector3D();
                    Point3D rayOrigin5 = new Point3D();
                    Point3D pointOnBox = new Point3D();
                    rayOrigin5.add((Tuple3DReadOnly)boxPosition5, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize4.getElement(0) - 0.001), (double)(0.5 * boxSize4.getElement(1) - 0.001), (double)(0.5 * boxSize4.getElement(2) - 0.001)));
                    pointOnBox.add((Tuple3DReadOnly)boxPosition5, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize4.getElement(0)), (double)(0.5 * boxSize4.getElement(1)), (double)(0.5 * boxSize4.getElement(2))));
                    pointOnBox.setElement(hoveringAxis, boxPosition5.getElement(hoveringAxis) + hoveringDirection * 0.5 * boxSize4.getElement(hoveringAxis));
                    rayDirection4.sub((Tuple3DReadOnly)pointOnBox, (Tuple3DReadOnly)rayOrigin5);
                    expectedIntersection = new Point3D();
                    expectedIntersection.set(pointOnBox);
                    transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                    Arrays.asList(boxPosition5, boxOrientation5, rayOrigin5, rayDirection4, expectedIntersection).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform));
                    int numberOfIntersections6 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition5, (Orientation3DReadOnly)boxOrientation5, (Vector3DReadOnly)boxSize4, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection4, null, null);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections6, (String)("Iteration: " + i));
                    Point3D actualIntersection1 = new Point3D();
                    Point3D actualIntersection2 = new Point3D();
                    numberOfIntersections6 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition5, (Orientation3DReadOnly)boxOrientation5, (Vector3DReadOnly)boxSize4, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection4, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                    Assertions.assertEquals((int)1, (int)numberOfIntersections6, (String)("Iteration: " + i));
                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                    EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
                    actualIntersection1.setToNaN();
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis1 : Axis3D.values()) {
                for (double axis1Direction = -1.0; axis1Direction <= 1.0; axis1Direction += 2.0) {
                    for (Axis3D hoveringAxis2 : Axis3D.values()) {
                        if (hoveringAxis1.ordinal() == hoveringAxis2.ordinal()) continue;
                        for (double axis2Direction = -1.0; axis2Direction <= 1.0; axis2Direction += 2.0) {
                            boxPosition = new Point3D();
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                            Quaternion boxOrientation6 = new Quaternion();
                            Vector3D rayDirection5 = new Vector3D();
                            Point3D pointOnBox1 = new Point3D();
                            Point3D pointOnBox2 = new Point3D();
                            pointOnBox1.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            pointOnBox1.setElement(hoveringAxis1, boxPosition.getElement(hoveringAxis1) + axis1Direction * (0.5 * boxSize.getElement(hoveringAxis1)));
                            pointOnBox2.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            pointOnBox2.setElement(hoveringAxis2, boxPosition.getElement(hoveringAxis2) + axis2Direction * (0.5 * boxSize.getElement(hoveringAxis2)));
                            rayDirection5.sub((Tuple3DReadOnly)pointOnBox2, (Tuple3DReadOnly)pointOnBox1);
                            Point3D rayOrigin6 = new Point3D();
                            rayOrigin6.scaleAdd(-1.0 * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0), (Tuple3DReadOnly)rayDirection5, (Tuple3DReadOnly)pointOnBox1);
                            Point3D expectedIntersection1 = new Point3D();
                            expectedIntersection1.set(pointOnBox1);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set(pointOnBox2);
                            RigidBodyTransform transform6 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                            Arrays.asList(boxPosition, boxOrientation6, rayOrigin6, rayDirection5, expectedIntersection1, expectedIntersection2).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform6));
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation6, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection5, null, null);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation6, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection5, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection = -1.0; edgeDirection <= 1.0; edgeDirection += 2.0) {
                            boxPosition = new Point3D();
                            boxSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                            Quaternion boxOrientation7 = new Quaternion();
                            Vector3D rayDirection6 = new Vector3D();
                            Point3D rayOrigin7 = new Point3D();
                            Point3D boxEdgePoint = new Point3D();
                            rayOrigin7.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            rayOrigin7.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            boxEdgePoint.add((Tuple3DReadOnly)boxPosition, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize.getElement(0)), (double)(0.5 * boxSize.getElement(1)), (double)(0.5 * boxSize.getElement(2))));
                            boxEdgePoint.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection * 0.5 * boxSize.getElement(edgeAxis));
                            boxEdgePoint.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize.getElement(hoveringAxis));
                            rayDirection6.sub((Tuple3DReadOnly)boxEdgePoint, (Tuple3DReadOnly)rayOrigin7);
                            Point3D expectedIntersection1 = new Point3D();
                            expectedIntersection1.set(rayOrigin7);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set(boxEdgePoint);
                            RigidBodyTransform transform7 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                            Arrays.asList(boxPosition, boxOrientation7, rayOrigin7, rayDirection6, expectedIntersection1, expectedIntersection2).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform7));
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            int numberOfIntersections7 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation7, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection6, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections7, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                            numberOfIntersections7 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation7, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection6, null, null);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections7, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis1 : Axis3D.values()) {
                        if (edgeAxis1.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection1 = -1.0; edgeDirection1 <= 1.0; edgeDirection1 += 2.0) {
                            for (Point3D edgeAxis2 : Axis3D.values()) {
                                if (edgeAxis2.ordinal() == hoveringAxis.ordinal() || edgeAxis1.ordinal() == edgeAxis2.ordinal()) continue;
                                for (double edgeDirection2 = -1.0; edgeDirection2 <= 1.0; edgeDirection2 += 2.0) {
                                    Point3D boxPosition6 = new Point3D();
                                    Vector3D boxSize5 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                                    Quaternion boxOrientation8 = new Quaternion();
                                    Vector3D rayDirection7 = new Vector3D();
                                    Point3D rayOrigin8 = new Point3D();
                                    Point3D boxEdgePoint1 = new Point3D();
                                    Point3D boxEdgePoint2 = new Point3D();
                                    boxEdgePoint1.add((Tuple3DReadOnly)boxPosition6, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize5.getElement(0)), (double)(0.5 * boxSize5.getElement(1)), (double)(0.5 * boxSize5.getElement(2))));
                                    boxEdgePoint1.setElement(hoveringAxis, boxPosition6.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize5.getElement(hoveringAxis));
                                    boxEdgePoint1.setElement(edgeAxis1, boxPosition6.getElement(edgeAxis1) + edgeDirection1 * 0.5 * boxSize5.getElement(edgeAxis1));
                                    boxEdgePoint2.add((Tuple3DReadOnly)boxPosition6, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * boxSize5.getElement(0)), (double)(0.5 * boxSize5.getElement(1)), (double)(0.5 * boxSize5.getElement(2))));
                                    boxEdgePoint2.setElement(hoveringAxis, boxPosition6.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize5.getElement(hoveringAxis));
                                    boxEdgePoint2.setElement((Axis3D)edgeAxis2, boxPosition6.getElement((Axis3D)edgeAxis2) + edgeDirection2 * 0.5 * boxSize5.getElement((Axis3D)edgeAxis2));
                                    rayDirection7.sub((Tuple3DReadOnly)boxEdgePoint2, (Tuple3DReadOnly)boxEdgePoint1);
                                    rayDirection7.normalize();
                                    double maxDiagnoal = Math.max(boxSize5.getX(), boxSize5.getY());
                                    maxDiagnoal = Math.max(maxDiagnoal, boxSize5.getZ());
                                    rayOrigin8.scaleAdd(-1.0 * Math.sqrt(3.0) * maxDiagnoal, (Tuple3DReadOnly)rayDirection7, (Tuple3DReadOnly)boxEdgePoint2);
                                    Point3D expectedIntersection1 = new Point3D();
                                    expectedIntersection1.set(boxEdgePoint1);
                                    Point3D expectedIntersection2 = new Point3D();
                                    expectedIntersection2.set(boxEdgePoint2);
                                    RigidBodyTransform transform8 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                                    Arrays.asList(boxPosition6, boxOrientation8, rayOrigin8, rayDirection7, expectedIntersection1, expectedIntersection2).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform8));
                                    Point3D actualIntersection1 = new Point3D();
                                    Point3D actualIntersection2 = new Point3D();
                                    int numberOfIntersections8 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition6, (Orientation3DReadOnly)boxOrientation8, (Vector3DReadOnly)boxSize5, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection7, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                                    Assertions.assertEquals((int)2, (int)numberOfIntersections8, (String)("Iteration: " + i));
                                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                                    EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                                    actualIntersection1.setToNaN();
                                    actualIntersection2.setToNaN();
                                    numberOfIntersections8 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition6, (Orientation3DReadOnly)boxOrientation8, (Vector3DReadOnly)boxSize5, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection7, null, null);
                                    Assertions.assertEquals((int)2, (int)numberOfIntersections8, (String)("Iteration: " + i));
                                }
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (Axis3D hoveringAxis : Axis3D.values()) {
                for (double axisDirection = -1.0; axisDirection <= 1.0; axisDirection += 2.0) {
                    for (Axis3D edgeAxis : Axis3D.values()) {
                        if (edgeAxis.ordinal() == hoveringAxis.ordinal()) continue;
                        for (double edgeDirection1 = -1.0; edgeDirection1 <= 1.0; edgeDirection1 += 2.0) {
                            boxPosition = new Point3D();
                            Vector3D boxSize6 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.01, (double)10.0);
                            Quaternion boxOrientation9 = new Quaternion();
                            Vector3D rayDirection8 = new Vector3D();
                            Point3D rayOrigin9 = new Point3D();
                            Point3D boxCornerPoint1 = new Point3D();
                            Point3D boxCornerPoint2 = new Point3D();
                            boxCornerPoint1.scaleAdd(0.5, (Tuple3DReadOnly)boxSize6, (Tuple3DReadOnly)boxPosition);
                            boxCornerPoint1.setElement(hoveringAxis, boxPosition.getElement(hoveringAxis) + axisDirection * 0.5 * boxSize6.getElement(hoveringAxis));
                            boxCornerPoint2.set(boxCornerPoint1);
                            boxCornerPoint1.setElement(edgeAxis, boxPosition.getElement(edgeAxis) + edgeDirection1 * 0.5 * boxSize6.getElement(edgeAxis));
                            boxCornerPoint2.setElement(edgeAxis, boxPosition.getElement(edgeAxis) - 1.0 * edgeDirection1 * 0.5 * boxSize6.getElement(edgeAxis));
                            rayDirection8.sub((Tuple3DReadOnly)boxCornerPoint2, (Tuple3DReadOnly)boxCornerPoint1);
                            rayDirection8.normalize();
                            double maxDiagnoal = Math.max(boxSize6.getX(), boxSize6.getY());
                            maxDiagnoal = Math.max(maxDiagnoal, boxSize6.getZ());
                            rayOrigin9.scaleAdd(-1.0 * (maxDiagnoal *= Math.sqrt(3.0)), (Tuple3DReadOnly)rayDirection8, (Tuple3DReadOnly)boxCornerPoint2);
                            Point3D expectedIntersection1 = new Point3D();
                            expectedIntersection1.set(boxCornerPoint1);
                            Point3D expectedIntersection2 = new Point3D();
                            expectedIntersection2.set(boxCornerPoint2);
                            RigidBodyTransform transform9 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
                            Arrays.asList(boxPosition, boxOrientation9, rayOrigin9, rayDirection8, expectedIntersection1, expectedIntersection2).forEach(transformable -> ((Transformable)transformable).applyTransform((Transform)transform9));
                            Point3D actualIntersection1 = new Point3D();
                            Point3D actualIntersection2 = new Point3D();
                            int numberOfIntersections9 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation9, (Vector3DReadOnly)boxSize6, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection8, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections9, (String)("Iteration: " + i));
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
                            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection2, (double)3.0E-8);
                            actualIntersection1.setToNaN();
                            actualIntersection2.setToNaN();
                            numberOfIntersections9 = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation9, (Vector3DReadOnly)boxSize6, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection8, null, null);
                            Assertions.assertEquals((int)2, (int)numberOfIntersections9, (String)("Iteration: " + i));
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testIntersectionBetweenRay3DAndCylinder3D() throws Exception {
        Point3D pointOnBottom;
        Point3D pointOnCylinder;
        int numberOfIntersections;
        Point3D actualIntersection1;
        Vector3D rayDirection;
        Point3D expectedIntersection2;
        Point3D expectedIntersection1;
        double cylinderTopZ;
        Point3D cylinderPosition;
        double cylinderRadius;
        double cylinderLength;
        int i;
        Point3D pointOnBottom2;
        Point3D pointOnTop;
        int numberOfIntersections2;
        Point3D actualIntersection2;
        Point3D rayOrigin;
        Vector3D rayDirection2;
        int numberOfIntersections3;
        RigidBodyTransform transform;
        Point3D secondIntersection;
        Point3D firstIntersection;
        Vector3D rayDirection3;
        Point3D pointOnRay;
        Point3D rayOrigin2;
        double cylinderTopZ2;
        Vector3D cylinderAxis;
        Point3D cylinderPosition2;
        double cylinderRadius2;
        double cylinderLength2;
        int i2;
        Random random = new Random(65226L);
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            rayOrigin2 = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)rayOrigin2, (Tuple3DBasics)rayOrigin2);
            pointOnRay = new Point3D(cylinderRadius2, 0.0, cylinderTopZ2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnRay, (Tuple3DBasics)pointOnRay);
            rayDirection3 = new Vector3D();
            rayDirection3.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin2);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection3, (Tuple3DReadOnly)rayOrigin2);
            pointOnRay.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection3, (Tuple3DReadOnly)pointOnRay);
            rayDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin2, rayDirection3).forEach(transformable -> transformable.applyTransform((Transform)transform));
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection3, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            double cylinderBottomZ = -0.5 * cylinderLength2;
            rayOrigin2 = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)rayOrigin2, (Tuple3DBasics)rayOrigin2);
            pointOnRay = new Point3D(cylinderRadius2, 0.0, cylinderBottomZ - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnRay, (Tuple3DBasics)pointOnRay);
            rayDirection3 = new Vector3D();
            rayDirection3.sub((Tuple3DReadOnly)pointOnRay, (Tuple3DReadOnly)rayOrigin2);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection3, (Tuple3DReadOnly)rayOrigin2);
            pointOnRay.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection3, (Tuple3DReadOnly)pointOnRay);
            rayDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            firstIntersection = new Point3D();
            secondIntersection = new Point3D();
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin2, rayDirection3).forEach(transformable -> transformable.applyTransform((Transform)transform));
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection3, (Point3DBasics)firstIntersection, (Point3DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection);
            numberOfIntersections3 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin2, (Vector3DReadOnly)rayDirection3, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections3, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D rayOrigin3 = new Point3D(cylinderRadius2 + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)1.0), 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ2));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)rayOrigin3, (Tuple3DBasics)rayOrigin3);
            Vector3D fromCylinderToPoint = new Vector3D((Tuple3DReadOnly)rayOrigin3);
            fromCylinderToPoint.setZ(0.0);
            rayDirection2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)fromCylinderToPoint, (boolean)true);
            rayOrigin3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)rayOrigin3);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D firstIntersection2 = new Point3D();
            Point3D secondIntersection2 = new Point3D();
            RigidBodyTransform transform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin3, rayDirection2).forEach(transformable -> transformable.applyTransform((Transform)transform2));
            int numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin3, (Vector3DReadOnly)rayDirection2, (Point3DBasics)firstIntersection2, (Point3DBasics)secondIntersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i2));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)firstIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)secondIntersection2);
            numberOfIntersections4 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin3, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections4, (String)("Iteration: " + i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D expectedIntersection12 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection12, (Tuple3DBasics)expectedIntersection12);
            Point3D expectedIntersection22 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection22, (Tuple3DBasics)expectedIntersection22);
            rayDirection2 = new Vector3D();
            rayDirection2.sub((Tuple3DReadOnly)expectedIntersection22, (Tuple3DReadOnly)expectedIntersection12);
            rayDirection2.normalize();
            rayOrigin = new Point3D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)expectedIntersection12);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actualIntersection12 = new Point3D();
            actualIntersection2 = new Point3D();
            RigidBodyTransform transform3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin, rayDirection2, expectedIntersection12, expectedIntersection22).forEach(transformable -> transformable.applyTransform((Transform)transform3));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualIntersection12, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection12, (EuclidGeometry)actualIntersection12, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection22, (EuclidGeometry)actualIntersection2, (double)1.0E-12);
            actualIntersection12.setToNaN();
            actualIntersection2.setToNaN();
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            Point3D expectedIntersection = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection, (Tuple3DBasics)expectedIntersection);
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            rayDirection2 = new Vector3D();
            rayDirection2.sub((Tuple3DReadOnly)expectedIntersection, (Tuple3DReadOnly)pointOnTop);
            rayDirection2.normalize();
            rayOrigin = new Point3D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)expectedIntersection.distance((Point3DReadOnly)pointOnTop)), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)pointOnTop);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actualIntersection13 = new Point3D();
            actualIntersection2 = new Point3D();
            RigidBodyTransform transform4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin, rayDirection2, expectedIntersection, pointOnTop).forEach(transformable -> transformable.applyTransform((Transform)transform4));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualIntersection13, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection13, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection13.setToNaN();
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            pointOnBottom2 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom2, (Tuple3DBasics)pointOnBottom2);
            Point3D expectedIntersection = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection, (Tuple3DBasics)expectedIntersection);
            rayDirection2 = new Vector3D();
            rayDirection2.sub((Tuple3DReadOnly)expectedIntersection, (Tuple3DReadOnly)pointOnBottom2);
            rayDirection2.normalize();
            rayOrigin = new Point3D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)pointOnBottom2.distance((Point3DReadOnly)expectedIntersection)), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)pointOnBottom2);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actualIntersection14 = new Point3D();
            actualIntersection2 = new Point3D();
            RigidBodyTransform transform5 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin, rayDirection2, expectedIntersection, pointOnBottom2).forEach(transformable -> transformable.applyTransform((Transform)transform5));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualIntersection14, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection14, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            actualIntersection14.setToNaN();
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            cylinderLength2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition2 = new Point3D();
            cylinderAxis = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ2 = 0.5 * cylinderLength2;
            double cylinderBottomZ = -0.5 * cylinderLength2;
            pointOnBottom2 = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom2, (Tuple3DBasics)pointOnBottom2);
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderRadius2), 0.0, cylinderTopZ2);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            rayDirection2 = new Vector3D();
            rayDirection2.sub((Tuple3DReadOnly)pointOnTop, (Tuple3DReadOnly)pointOnBottom2);
            rayDirection2.normalize();
            rayOrigin = new Point3D();
            Point3D actualIntersection15 = new Point3D();
            actualIntersection2 = new Point3D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)pointOnTop);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            RigidBodyTransform transform6 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition2, cylinderAxis, rayOrigin, rayDirection2, pointOnTop, pointOnBottom2).forEach(transformable -> transformable.applyTransform((Transform)transform6));
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualIntersection15, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection15);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
            rayDirection2.negate();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)rayDirection2, (Tuple3DReadOnly)pointOnBottom2);
            numberOfIntersections2 = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections2);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength2, (double)cylinderRadius2, (Point3DReadOnly)cylinderPosition2, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection2, (Point3DBasics)actualIntersection15, (Point3DBasics)actualIntersection2);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection15);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection2);
        }
        ArrayList<Double> errors = new ArrayList<Double>();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis2 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            expectedIntersection1 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection1, (Tuple3DBasics)expectedIntersection1);
            expectedIntersection2 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection2, (Tuple3DBasics)expectedIntersection2);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)expectedIntersection1);
            rayDirection.normalize();
            Point3D rayOrigin4 = new Point3D();
            rayOrigin4.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)expectedIntersection1);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection22 = new Point3D();
            RigidBodyTransform transform7 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis2, rayOrigin4, rayDirection, expectedIntersection1, expectedIntersection2).forEach(transformable -> transformable.applyTransform((Transform)transform7));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis2, (Point3DReadOnly)rayOrigin4, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection22, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection22));
            actualIntersection1.setToNaN();
            actualIntersection22.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis3 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            Point3D pointOnCylinder1 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder1, (Tuple3DBasics)pointOnCylinder1);
            Point3D pointOnCylinder2 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder2, (Tuple3DBasics)pointOnCylinder2);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnCylinder2, (Tuple3DReadOnly)pointOnCylinder1);
            rayDirection.normalize();
            Point3D rayOrigin5 = new Point3D();
            rayOrigin5.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)pointOnCylinder1.distance((Point3DReadOnly)pointOnCylinder2)), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)pointOnCylinder1);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection23 = new Point3D();
            RigidBodyTransform transform8 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis3, rayOrigin5, rayDirection, pointOnCylinder1, pointOnCylinder2).forEach(transformable -> transformable.applyTransform((Transform)transform8));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis3, (Point3DReadOnly)rayOrigin5, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection23);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder2, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder2.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection23);
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.5E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis4 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            expectedIntersection1 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection1, (Tuple3DBasics)expectedIntersection1);
            expectedIntersection2 = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)expectedIntersection2, (Tuple3DBasics)expectedIntersection2);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)expectedIntersection1);
            rayDirection.normalize();
            Point3D rayOrigin6 = new Point3D();
            rayOrigin6.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)expectedIntersection1);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection24 = new Point3D();
            RigidBodyTransform transform9 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis4, rayOrigin6, rayDirection, expectedIntersection1, expectedIntersection2).forEach(transformable -> transformable.applyTransform((Transform)transform9));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis4, (Point3DReadOnly)rayOrigin6, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection24);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection1, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(expectedIntersection1.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection24, (double)3.0E-8);
            errors.add(expectedIntersection2.distance((Point3DReadOnly)actualIntersection24));
            actualIntersection1.setToNaN();
            actualIntersection24.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)6.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis5 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderTopZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnTop);
            rayDirection.normalize();
            Point3D rayOrigin7 = new Point3D();
            rayOrigin7.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)pointOnTop);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection25 = new Point3D();
            RigidBodyTransform transform10 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis5, rayOrigin7, rayDirection, pointOnTop, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform10));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis5, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis5, (Point3DReadOnly)rayOrigin7, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection25);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection25, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection25));
            actualIntersection1.setToNaN();
            actualIntersection25.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis6 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            pointOnTop = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderTopZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnTop, (Tuple3DBasics)pointOnTop);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnTop);
            rayDirection.normalize();
            Point3D rayOrigin8 = new Point3D();
            rayOrigin8.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)pointOnCylinder.distance((Point3DReadOnly)pointOnTop)), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)pointOnTop);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection26 = new Point3D();
            RigidBodyTransform transform11 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis6, rayOrigin8, rayDirection, pointOnTop, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform11));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis6, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis6, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection26);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection26);
            actualIntersection1.setToNaN();
            rayDirection.negate();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis6, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis6, (Point3DReadOnly)rayOrigin8, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection26);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnTop, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnTop.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection26);
            actualIntersection1.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis7 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            pointOnBottom = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom, (Tuple3DBasics)pointOnBottom);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnBottom);
            rayDirection.normalize();
            Point3D rayOrigin9 = new Point3D();
            rayOrigin9.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)pointOnBottom);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection27 = new Point3D();
            RigidBodyTransform transform12 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis7, rayOrigin9, rayDirection, pointOnBottom, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform12));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis7, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis7, (Point3DReadOnly)rayOrigin9, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection27);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection27, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection27));
            actualIntersection1.setToNaN();
            actualIntersection27.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
        errors = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            cylinderLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            cylinderPosition = new Point3D();
            Vector3D cylinderAxis8 = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            cylinderTopZ = 0.5 * cylinderLength;
            double cylinderBottomZ = -0.5 * cylinderLength;
            pointOnBottom = new Point3D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinderRadius), 0.0, cylinderBottomZ);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnBottom, (Tuple3DBasics)pointOnBottom);
            pointOnCylinder = new Point3D(cylinderRadius, 0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)cylinderBottomZ, (double)cylinderTopZ));
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple3DReadOnly)pointOnCylinder, (Tuple3DBasics)pointOnCylinder);
            rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnCylinder, (Tuple3DReadOnly)pointOnBottom);
            rayDirection.normalize();
            Point3D rayOrigin10 = new Point3D();
            rayOrigin10.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)pointOnCylinder.distance((Point3DReadOnly)pointOnBottom)), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)pointOnBottom);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            actualIntersection1 = new Point3D();
            Point3D actualIntersection28 = new Point3D();
            RigidBodyTransform transform13 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Arrays.asList(cylinderPosition, cylinderAxis8, rayOrigin10, rayDirection, pointOnBottom, pointOnCylinder).forEach(transformable -> transformable.applyTransform((Transform)transform13));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis8, (Point3DReadOnly)rayOrigin10, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis8, (Point3DReadOnly)rayOrigin10, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection28);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnCylinder, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnCylinder.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection28);
            actualIntersection1.setToNaN();
            rayDirection.negate();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis8, (Point3DReadOnly)rayOrigin10, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis8, (Point3DReadOnly)rayOrigin10, (Vector3DReadOnly)rayDirection, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection28);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnBottom, (EuclidGeometry)actualIntersection1, (double)3.0E-8);
            errors.add(pointOnBottom.distance((Point3DReadOnly)actualIntersection1));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualIntersection28);
            actualIntersection1.setToNaN();
        }
        Assertions.assertEquals((double)0.0, (double)errors.stream().collect(Collectors.averagingDouble(Double::doubleValue)), (double)1.0E-12);
    }

    @Test
    public void testIntersectionBetweenRay3DAndEllipsoid3D() throws Exception {
        int numberOfIntersections;
        Point3D intersection2;
        Point3D intersection1;
        double sqrtSumOfSquares;
        double radiusZ;
        double radiusY;
        double radiusX;
        int i;
        Random random = new Random(7654L);
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            Point3D pointOnEllipsoid = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid.getX() / radiusX), (double)(pointOnEllipsoid.getY() / radiusY), (double)(pointOnEllipsoid.getZ() / radiusZ));
            pointOnEllipsoid.scale(1.0 / sqrtSumOfSquares);
            Vector3D normalAtPoint = new Vector3D((Tuple3DReadOnly)pointOnEllipsoid);
            normalAtPoint.scale(1.0 / (radiusX * radiusX), 1.0 / (radiusY * radiusY), 1.0 / (radiusZ * radiusZ));
            normalAtPoint.normalize();
            Point3D rayOrigin = new Point3D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-4, (double)10.0), (Tuple3DReadOnly)normalAtPoint, (Tuple3DReadOnly)pointOnEllipsoid);
            Vector3D rayDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAtPoint, (boolean)true);
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)rayDirection, (Tuple3DReadOnly)rayOrigin);
            intersection1 = new Point3D();
            intersection2 = new Point3D();
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, null, null);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
        }
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0);
            Point3D pointOnEllipsoid1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid1.getX() / radiusX), (double)(pointOnEllipsoid1.getY() / radiusY), (double)(pointOnEllipsoid1.getZ() / radiusZ));
            pointOnEllipsoid1.scale(1.0 / sqrtSumOfSquares);
            Point3D pointOnEllipsoid2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)10.0);
            sqrtSumOfSquares = EuclidCoreTools.norm((double)(pointOnEllipsoid2.getX() / radiusX), (double)(pointOnEllipsoid2.getY() / radiusY), (double)(pointOnEllipsoid2.getZ() / radiusZ));
            pointOnEllipsoid2.scale(1.0 / sqrtSumOfSquares);
            Vector3D rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnEllipsoid2, (Tuple3DReadOnly)pointOnEllipsoid1);
            rayDirection.normalize();
            Point3D rayOrigin = new Point3D();
            intersection1 = new Point3D();
            intersection2 = new Point3D();
            rayOrigin.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid1, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection2, (double)3.0E-8);
            intersection1.setToNaN();
            intersection2.setToNaN();
            rayOrigin.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)pointOnEllipsoid2, (EuclidGeometry)intersection1, (double)3.0E-8);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
            rayOrigin.interpolate((Tuple3DReadOnly)pointOnEllipsoid1, (Tuple3DReadOnly)pointOnEllipsoid2, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)intersection1, (Point3DBasics)intersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection1);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)intersection2);
            intersection1.setToNaN();
            intersection2.setToNaN();
        }
    }

    @Test
    public void testIntersectionBetweenTwoLine2Ds() throws Exception {
        Point2D actualIntersection;
        Point2D secondPointOnLine2;
        Point2D firstPointOnLine2;
        Vector2D lineDirection2;
        Point2D expectedIntersection;
        Point2D secondPointOnLine1;
        Vector2D lineDirection1;
        Point2D firstPointOnLine1;
        int i;
        Random random = new Random(1176L);
        double epsilon = 1.0E-12;
        for (i = 0; i < 1000; ++i) {
            firstPointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            secondPointOnLine1 = new Point2D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)firstPointOnLine1);
            expectedIntersection = new Point2D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)firstPointOnLine1);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            firstPointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            secondPointOnLine2 = new Point2D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            epsilon = Math.abs(lineDirection1.dot((Tuple2DReadOnly)lineDirection2) / lineDirection1.norm() / lineDirection2.norm()) > 0.9995 ? 1.0E-11 : 1.0E-12;
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Vector2DReadOnly)lineDirection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            firstPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Vector2DReadOnly)lineDirection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            firstPointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            secondPointOnLine1 = new Point2D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)firstPointOnLine1);
            Vector2D lineDirection22 = new Vector2D((Tuple2DReadOnly)lineDirection1);
            if (random.nextBoolean()) {
                lineDirection22.negate();
            }
            Point2D firstPointOnLine22 = new Point2D((Tuple2DReadOnly)firstPointOnLine1);
            Point2D secondPointOnLine22 = new Point2D();
            Vector2D orthogonal = new Vector2D(-lineDirection1.getY(), lineDirection1.getX());
            firstPointOnLine22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)firstPointOnLine22);
            firstPointOnLine22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection22, (Tuple2DReadOnly)firstPointOnLine22);
            secondPointOnLine22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection22, (Tuple2DReadOnly)firstPointOnLine22);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine22, (Vector2DReadOnly)lineDirection22);
            Assertions.assertNull((Object)actualIntersection);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine22, (Point2DReadOnly)secondPointOnLine22);
            Assertions.assertNull((Object)actualIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            firstPointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            secondPointOnLine1 = new Point2D();
            secondPointOnLine1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)firstPointOnLine1);
            expectedIntersection = new Point2D();
            expectedIntersection.set(firstPointOnLine1);
            lineDirection2 = new Vector2D((Tuple2DReadOnly)lineDirection1);
            firstPointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            secondPointOnLine2 = new Point2D();
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Vector2DReadOnly)lineDirection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            firstPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            secondPointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)firstPointOnLine2);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Vector2DReadOnly)lineDirection2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        }
    }

    @Test
    public void testIntersectionBetweenTwoLineSegment2Ds() throws Exception {
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Vector2D lineDirection2;
        Point2D expectedIntersection;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        int i;
        Random random = new Random(3242L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfTwoLineSegmentsIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedIntersection = new Point2D((Tuple2DReadOnly)lineSegmentStart1);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart22 = new Point2D();
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart22.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd22.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfTwoLineSegmentsIntersectionAllCombinations(true, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
            } else {
                this.assertOnlyExistenceOfTwoLineSegmentsIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart22.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart22);
            lineSegmentEnd22.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd22);
            this.assertOnlyExistenceOfTwoLineSegmentsIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D a = new Point2D();
            Point2D b = new Point2D();
            Point2D c = new Point2D();
            Point2D d = new Point2D();
            double alphaA = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double alphaB = alphaA + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaC = alphaB + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaD = alphaC + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            a.scaleAdd(alphaA, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            b.scaleAdd(alphaB, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            c.scaleAdd(alphaC, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            d.scaleAdd(alphaD, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            Point2D expectedIntersection2 = new Point2D();
            Point2D actualIntersection = new Point2D();
            expectedIntersection2.set(b);
            boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)a, (Point2DReadOnly)d, (Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(c);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)a, (Point2DReadOnly)d, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)d, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(c);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)d, (Point2DReadOnly)a, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DReadOnly)a, (Point2DReadOnly)d, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(c);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a, (Point2DReadOnly)d, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DReadOnly)d, (Point2DReadOnly)a, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(c);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)d, (Point2DReadOnly)a, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)a, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)d, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)a, (Point2DReadOnly)c, (Point2DReadOnly)d, (Point2DReadOnly)b, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)c, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)d, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(b);
            success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)c, (Point2DReadOnly)a, (Point2DReadOnly)d, (Point2DReadOnly)b, (Point2DBasics)actualIntersection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection2, (EuclidGeometry)actualIntersection, (double)1.0E-12);
        }
    }

    private void assertOnlyExistenceOfTwoLineSegmentsIntersectionAllCombinations(boolean intersectionExist, Point2D lineSegmentStart1, Point2D lineSegmentEnd1, Point2D lineSegmentStart2, Point2D lineSegmentEnd2) {
        Point2D actualIntersection;
        Point2D lss1 = lineSegmentStart1;
        Point2D lse1 = lineSegmentEnd1;
        Point2D lss2 = lineSegmentStart2;
        Point2D lse = lineSegmentEnd2;
        Point2D intersectionThatMayContainOnlyNaNs = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lse, (Point2DReadOnly)lss2)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lse, (Point2DReadOnly)lss2)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1)) != null == intersectionExist ? 1 : 0) != 0);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DBasics)intersectionThatMayContainOnlyNaNs);
        Assertions.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        if (!intersectionExist) {
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)intersectionThatMayContainOnlyNaNs);
            intersectionThatMayContainOnlyNaNs.setToZero();
        }
        Assertions.assertTrue(((actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse, (Point2DReadOnly)lss2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1)) != null == intersectionExist ? 1 : 0) != 0);
    }

    private void assertAllCombinationsOfTwoLineSegmentsIntersection(Point2D expectedIntersection, Point2D lineSegmentStart1, Point2D lineSegmentEnd1, Point2D lineSegmentStart2, Point2D lineSegmentEnd2) {
        double epsilon = 1.0E-12;
        Vector2D direction1 = new Vector2D();
        Point2D lss1 = lineSegmentStart1;
        Point2D lse1 = lineSegmentEnd1;
        direction1.sub((Tuple2DReadOnly)lse1, (Tuple2DReadOnly)lss1);
        Vector2D direction2 = new Vector2D();
        Point2D lss2 = lineSegmentStart2;
        Point2D lse2 = lineSegmentEnd2;
        direction2.sub((Tuple2DReadOnly)lse2, (Tuple2DReadOnly)lss2);
        if (Math.abs(direction1.dot((Tuple2DReadOnly)direction2)) > 0.9999) {
            epsilon = 1.0E-10;
        }
        Point2D actualIntersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DBasics)actualIntersection);
        Assertions.assertTrue((boolean)success);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss1, (Point2DReadOnly)lse1, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse1, (Point2DReadOnly)lss1, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DReadOnly)lss1, (Point2DReadOnly)lse1);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
        actualIntersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DReadOnly)lse1, (Point2DReadOnly)lss1);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
    }

    @Test
    public void testIntersectionBetweenTwoPlane3Ds() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector3D firstParallelToPlane1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal1, (boolean)true);
            Vector3D secondParallelToPlane1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal1, (boolean)true);
            Point3D firstPointOnIntersection = new Point3D();
            Point3D secondPointOnIntersection = new Point3D();
            firstPointOnIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)firstParallelToPlane1, (Tuple3DReadOnly)pointOnPlane1);
            secondPointOnIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)secondParallelToPlane1, (Tuple3DReadOnly)firstPointOnIntersection);
            Vector3D expectedIntersectionDirection = new Vector3D();
            expectedIntersectionDirection.sub((Tuple3DReadOnly)secondPointOnIntersection, (Tuple3DReadOnly)firstPointOnIntersection);
            expectedIntersectionDirection.normalize();
            double rotationAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngle rotationAxisAngle = new AxisAngle((Vector3DReadOnly)expectedIntersectionDirection, rotationAngle);
            Vector3D planeNormal2 = new Vector3D();
            rotationAxisAngle.transform((Tuple3DReadOnly)planeNormal1, (Tuple3DBasics)planeNormal2);
            planeNormal2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Point3D pointOnPlane2 = new Point3D();
            Vector3D parallelToPlane2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal2, (boolean)true);
            pointOnPlane2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane2, (Tuple3DReadOnly)firstPointOnIntersection);
            Point3D actualPointOnIntersection = new Point3D();
            Vector3D actualIntersectionDirection = new Vector3D();
            boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (Point3DBasics)actualPointOnIntersection, (Vector3DBasics)actualIntersectionDirection);
            boolean areParallel = EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)planeNormal1, (Vector3DReadOnly)planeNormal2, (double)1.0E-6);
            Assertions.assertNotEquals((Object)areParallel, (Object)success);
            if (areParallel) continue;
            if (expectedIntersectionDirection.dot((Tuple3DReadOnly)actualIntersectionDirection) < 0.0) {
                expectedIntersectionDirection.negate();
            }
            String message = "Angle between vectors " + expectedIntersectionDirection.angle((Vector3DReadOnly)actualIntersectionDirection);
            Assertions.assertTrue((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)expectedIntersectionDirection, (Vector3DReadOnly)actualIntersectionDirection, (double)1.0E-7), (String)message);
            Assertions.assertEquals((double)1.0, (double)actualIntersectionDirection.norm(), (double)1.0E-12);
            if (planeNormal1.dot((Tuple3DReadOnly)planeNormal2) < 0.0) {
                planeNormal1.negate();
            }
            double epsilon = 1.0E-9;
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 0.15) {
                epsilon = 1.0E-8;
            }
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 0.05) {
                epsilon = 1.0E-7;
            }
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 0.03) {
                epsilon = 1.0E-6;
            }
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 0.001) {
                epsilon = 1.0E-5;
            }
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 1.0E-4) {
                epsilon = 1.0E-4;
            }
            if (planeNormal1.angle((Vector3DReadOnly)planeNormal2) < 5.0E-5) {
                epsilon = 0.001;
            }
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)actualPointOnIntersection, (Point3DReadOnly)firstPointOnIntersection, (Vector3DReadOnly)expectedIntersectionDirection), (double)epsilon);
        }
        Point3D pointOnPlane1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        Point3D pointOnPlane2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        Vector3D unitVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        Vector3D planeNormal1 = new Vector3D((Tuple3DReadOnly)unitVector);
        Vector3D planeNormal2 = new Vector3D((Tuple3DReadOnly)unitVector);
        planeNormal1.scale(9.0E-13);
        Assertions.assertFalse((boolean)EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)1.5707963267948966, (Point3DBasics)new Point3D(), (Vector3DBasics)new Vector3D()));
        Assertions.assertFalse((boolean)EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (double)1.5707963267948966, (Point3DBasics)new Point3D(), (Vector3DBasics)new Vector3D()));
        try {
            EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)-4.9E-324, (Point3DBasics)new Point3D(), (Vector3DBasics)new Vector3D());
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)1.5707963267948968, (Point3DBasics)new Point3D(), (Vector3DBasics)new Vector3D());
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testIsFormingTriangle() throws Exception {
        double a = 1.0;
        double b = 10.0;
        boolean actual = EuclidGeometryTools.isFormingTriangle((double)b, (double)a, (double)a);
        Assertions.assertEquals((Object)false, (Object)actual);
        a = 1.0;
        actual = EuclidGeometryTools.isFormingTriangle((double)a, (double)a, (double)a);
        Assertions.assertEquals((Object)true, (Object)actual);
        Random random = new Random(3242L);
        for (int i = 0; i < 1000; ++i) {
            Point2D point0 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            point0.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D point1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            point1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D point2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            point2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            double d01 = point0.distance((Point2DReadOnly)point1);
            double d12 = point1.distance((Point2DReadOnly)point2);
            double d20 = point2.distance((Point2DReadOnly)point0);
            a = d01;
            b = d12;
            double c = d20;
            Assertions.assertTrue((boolean)EuclidGeometryTools.isFormingTriangle((double)a, (double)b, (double)c));
            a = d12 + d20 + random.nextDouble();
            b = d12;
            c = d20;
            Assertions.assertFalse((boolean)EuclidGeometryTools.isFormingTriangle((double)a, (double)b, (double)c));
            a = d01;
            b = d01 + d20 + random.nextDouble();
            c = d20;
            Assertions.assertFalse((boolean)EuclidGeometryTools.isFormingTriangle((double)a, (double)b, (double)c));
            a = d01;
            b = d12;
            c = d01 + d12 + random.nextDouble();
            Assertions.assertFalse((boolean)EuclidGeometryTools.isFormingTriangle((double)a, (double)b, (double)c));
        }
        Assertions.assertFalse((boolean)EuclidGeometryTools.isFormingTriangle((double)0.0, (double)0.0, (double)0.0));
        try {
            EuclidGeometryTools.isFormingTriangle((double)-4.9E-324, (double)1.0, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.isFormingTriangle((double)1.0, (double)-4.9E-324, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.isFormingTriangle((double)1.0, (double)1.0, (double)-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testIsPoint2DInsideTriangleABC() throws Exception {
        Point2D inside = new Point2D();
        Point2D outside = new Point2D();
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = EuclidCoreRandomTools.nextPoint2D((Random)random);
            a.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D b = EuclidCoreRandomTools.nextPoint2D((Random)random);
            b.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D c = EuclidCoreRandomTools.nextPoint2D((Random)random);
            c.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)a, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)a, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)b, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)c, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)c, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            inside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            inside.interpolate((Tuple2DReadOnly)inside, (Tuple2DReadOnly)c, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            outside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            outside.interpolate((Tuple2DReadOnly)outside, (Tuple2DReadOnly)c, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            outside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            outside.interpolate((Tuple2DReadOnly)outside, (Tuple2DReadOnly)c, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            outside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            outside.interpolate((Tuple2DReadOnly)outside, (Tuple2DReadOnly)c, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
            outside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            outside.interpolate((Tuple2DReadOnly)outside, (Tuple2DReadOnly)c, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)outside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
        }
        Point2D a = new Point2D(1.0, 0.0);
        Point2D b = new Point2D(1.0, 1.0);
        Point2D c = new Point2D(0.0, 1.0);
        inside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)b, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
        inside.interpolate((Tuple2DReadOnly)a, (Tuple2DReadOnly)c, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
        inside.interpolate((Tuple2DReadOnly)b, (Tuple2DReadOnly)c, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)inside, (Point2DReadOnly)c, (Point2DReadOnly)b, (Point2DReadOnly)a));
    }

    @Test
    public void testIsPoint2DOnLine2D() throws Exception {
        Random random = new Random(2342334L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            orthogonal.normalize();
            Point2D query = new Point2D((Tuple2DReadOnly)pointOnLine);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            double shift = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0) * 1.0E-8;
            query.scaleAdd(shift, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)query);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            query = new Point2D((Tuple2DReadOnly)pointOnLine);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            shift = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * 1.0E-8;
            if (random.nextBoolean()) {
                shift = -shift;
            }
            query.scaleAdd(shift, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)query);
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
        }
    }

    @Test
    public void testIsPoint2DOnLineSegment2D() throws Exception {
        Point2D queryShifted;
        Point2D queryOnLineSegment;
        Vector2D orthogonal;
        Vector2D lineSegmentDirection;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        Random random = new Random(2342334L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection);
            queryOnLineSegment = new Point2D();
            queryOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, random.nextDouble());
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryOnLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryOnLineSegment, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            queryShifted = new Point2D();
            double shift = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0) * 1.0E-8;
            queryShifted.scaleAdd(shift, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)queryOnLineSegment);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            shift = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * 1.0E-8;
            if (random.nextBoolean()) {
                shift = -shift;
            }
            queryShifted.scaleAdd(shift, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)queryOnLineSegment);
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection);
            queryOnLineSegment = new Point2D((Tuple2DReadOnly)lineSegmentEnd);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryOnLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryOnLineSegment, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            queryShifted = new Point2D();
            Vector2D shift = new Vector2D();
            if (random.nextBoolean()) {
                orthogonal.negate();
            }
            shift.interpolate((Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)orthogonal, random.nextDouble());
            shift.normalize();
            shift.scale(random.nextDouble() * 1.0E-8);
            queryShifted.add((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)shift);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
            shift.normalize();
            shift.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * 1.0E-8);
            queryShifted.add((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)shift);
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)queryShifted, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart), (String)("Iteration: " + i));
        }
    }

    @Test
    public void testIsPoint2DOnSideOfLine2D() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random);
            pointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonalToTheLeft = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            orthogonalToTheLeft.normalize();
            Vector2D orthogonalToTheRight = new Vector2D();
            orthogonalToTheRight.setAndNegate((Tuple2DReadOnly)orthogonalToTheLeft);
            Point2D secondPointOnLine = new Point2D();
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            Point2D query = new Point2D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            query.scaleAdd(alpha, (Tuple2DReadOnly)orthogonalToTheLeft, (Tuple2DReadOnly)secondPointOnLine);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)false));
            query.scaleAdd(alpha, (Tuple2DReadOnly)orthogonalToTheRight, (Tuple2DReadOnly)secondPointOnLine);
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)true));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)false));
            query.set(pointOnLine);
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)query, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)false));
        }
    }

    @Test
    public void testIsPoint3DOnSideOfPlane3D() throws Exception {
        Vector3D orthogonal;
        Point3D pointOnPlane;
        Vector3D planeNormal;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            planeNormal = EuclidCoreRandomTools.nextVector3D((Random)random);
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointOnPlane, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, null);
            double shift = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-17, (double)1.0);
            Point3D pointAbove = new Point3D();
            pointAbove.scaleAdd(shift, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)pointOnPlane);
            Point3D pointBelow = new Point3D();
            pointBelow.scaleAdd(-shift, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)pointOnPlane);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointAbove, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, Location.ABOVE);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointBelow, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, Location.BELOW);
            orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            pointAbove.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointAbove);
            pointBelow.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointBelow);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointAbove, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, Location.ABOVE);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointBelow, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, Location.BELOW);
        }
        for (i = 0; i < 1000; ++i) {
            planeNormal = Axis3D.values[random.nextInt(3)];
            pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)pointOnPlane, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, null);
            Axis3D otherAxis1 = planeNormal.previous();
            Axis3D otherAxis2 = otherAxis1.previous();
            Vector3D orthogonal1 = new Vector3D((Tuple3DReadOnly)otherAxis1);
            Vector3D orthogonal2 = new Vector3D((Tuple3DReadOnly)otherAxis2);
            if (random.nextBoolean()) {
                orthogonal1.negate();
            }
            if (random.nextBoolean()) {
                orthogonal2.negate();
            }
            orthogonal = new Vector3D();
            orthogonal.interpolate((Tuple3DReadOnly)orthogonal1, (Tuple3DReadOnly)orthogonal2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point3D anotherPointOnPlane = new Point3D();
            anotherPointOnPlane.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointOnPlane);
            EuclidGeometryToolsTest.performAssertionsForPoint3DOnSideOfPlane3D(random, (Point3DReadOnly)anotherPointOnPlane, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, null);
        }
    }

    private static void performAssertionsForPoint3DOnSideOfPlane3D(Random random, Point3DReadOnly query, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Location expected) {
        double queryX = query.getX();
        double queryY = query.getY();
        double queryZ = query.getZ();
        double pointOnPlaneX = pointOnPlane.getX();
        double pointOnPlaneY = pointOnPlane.getY();
        double pointOnPlaneZ = pointOnPlane.getZ();
        double planeNormalX = planeNormal.getX();
        double planeNormalY = planeNormal.getY();
        double planeNormalZ = planeNormal.getZ();
        Vector3D planeFirstTangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)false);
        planeFirstTangent.scale(EuclidCoreRandomTools.nextDouble((Random)random));
        Vector3D planeSecondTangent = new Vector3D();
        planeSecondTangent.cross((Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)planeFirstTangent);
        planeSecondTangent.interpolate((Tuple3DReadOnly)planeFirstTangent, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.9));
        planeFirstTangent.negate();
        planeSecondTangent.interpolate((Tuple3DReadOnly)planeFirstTangent, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.9));
        planeFirstTangent.negate();
        double planeFirstTangentX = planeFirstTangent.getX();
        double planeFirstTangentY = planeFirstTangent.getY();
        double planeFirstTangentZ = planeFirstTangent.getZ();
        double planeSecondTangentX = planeSecondTangent.getX();
        double planeSecondTangentY = planeSecondTangent.getY();
        double planeSecondTangentZ = planeSecondTangent.getZ();
        if (expected == null) {
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAbovePlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeFirstTangentX, (double)planeFirstTangentY, (double)planeFirstTangentZ, (double)planeSecondTangentX, (double)planeSecondTangentY, (double)planeSecondTangentZ, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeFirstTangentX, (double)planeFirstTangentY, (double)planeFirstTangentZ, (double)planeSecondTangentX, (double)planeSecondTangentY, (double)planeSecondTangentZ, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAbovePlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
            Assertions.assertFalse((boolean)EuclidGeometryTools.isPoint3DBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
            return;
        }
        boolean isAboveExpectedResult = expected == Location.ABOVE;
        boolean isBelowExpectedResult = expected == Location.BELOW;
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAbovePlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeFirstTangentX, (double)planeFirstTangentY, (double)planeFirstTangentZ, (double)planeSecondTangentX, (double)planeSecondTangentY, (double)planeSecondTangentZ, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)true));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAbovePlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
        Assertions.assertEquals((Object)isAboveExpectedResult, (Object)EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeFirstTangentX, (double)planeFirstTangentY, (double)planeFirstTangentZ, (double)planeSecondTangentX, (double)planeSecondTangentY, (double)planeSecondTangentZ, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent, (boolean)false));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DBelowPlane3D((double)queryX, (double)queryY, (double)queryZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
        Assertions.assertEquals((Object)isBelowExpectedResult, (Object)EuclidGeometryTools.isPoint3DBelowPlane3D((Point3DReadOnly)query, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent));
    }

    @Test
    public void testNormal3DFromThreePoint3Ds() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expectedPlaneNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D firstPointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            firstPointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D secondPointOnPlane = new Point3D();
            Point3D thirdPointOnPlane = new Point3D();
            Vector3D secondOrthogonalToNormal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)expectedPlaneNormal, (boolean)true);
            Vector3D thirdOrthogonalToNormal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)expectedPlaneNormal, (boolean)true);
            secondPointOnPlane.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToNormal, (Tuple3DReadOnly)firstPointOnPlane);
            thirdPointOnPlane.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0), (Tuple3DReadOnly)thirdOrthogonalToNormal, (Tuple3DReadOnly)firstPointOnPlane);
            Vector3D actualPlaneNormal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane);
            if (expectedPlaneNormal.dot((Tuple3DReadOnly)actualPlaneNormal) < 0.0) {
                actualPlaneNormal.negate();
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPlaneNormal, (EuclidGeometry)actualPlaneNormal, (double)1.0E-12);
            Assertions.assertNull((Object)EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)firstPointOnPlane));
        }
    }

    @Test
    public void testOrthogonalProjectionOnLine2D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random);
            firstPointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D secondPointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random);
            secondPointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)secondPointOnLine, (Tuple2DReadOnly)firstPointOnLine);
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D expectionProjection = new Point2D();
            expectionProjection.interpolate((Tuple2DReadOnly)firstPointOnLine, (Tuple2DReadOnly)secondPointOnLine, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D perpendicularToLineDirection = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            perpendicularToLineDirection.normalize();
            Point2D testPoint = new Point2D();
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)perpendicularToLineDirection, (Tuple2DReadOnly)expectionProjection);
            Point2D actualProjection = new Point2D();
            boolean success = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectionProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            success = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectionProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectionProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectionProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            lineDirection.normalize();
            lineDirection.scale(9.0E-13);
            Assertions.assertNull((Object)EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection));
            Assertions.assertFalse((boolean)EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)new Point2D()));
            secondPointOnLine.add((Tuple2DReadOnly)firstPointOnLine, (Tuple2DReadOnly)lineDirection);
            Assertions.assertNull((Object)EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine));
            Assertions.assertFalse((boolean)EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)testPoint, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)new Point2D()));
        }
    }

    @Test
    public void testOrthogonalProjectionOnLine3D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnLine = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Point3D expectedProjection = new Point3D();
            expectedProjection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnLine);
            Vector3D perpendicularToLineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection, (boolean)true);
            Point3D testPoint = new Point3D();
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)perpendicularToLineDirection, (Tuple3DReadOnly)expectedProjection);
            Point3D actualProjection = new Point3D();
            boolean success = EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)testPoint, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)testPoint, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            lineDirection.normalize();
            lineDirection.scale(9.0E-13);
            Assertions.assertFalse((boolean)EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)testPoint, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)actualProjection));
            Assertions.assertNull((Object)EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)testPoint, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection));
        }
    }

    @Test
    public void testOrthogonalProjectionOnLineSegment2D() throws Exception {
        Random random = new Random(232L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal, (Vector2DBasics)orthogonal);
            orthogonal.normalize();
            Point2D expectedProjection = new Point2D();
            Point2D testPoint = new Point2D();
            Point2D actualProjection = new Point2D();
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            boolean success = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentStart);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentEnd);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            testPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            expectedProjection.set(lineSegmentStart);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            lineSegmentDirection.scale(9.0E-13);
            lineSegmentEnd.add((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentDirection);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
    }

    @Test
    public void testOrthogonalProjectionOnLineSegment3D() throws Exception {
        Random random = new Random(232L);
        for (int i = 0; i < 1000; ++i) {
            Point3D lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentStart.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random);
            lineSegmentEnd.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection, (boolean)true);
            Point3D expectedProjection = new Point3D();
            Point3D testPoint = new Point3D();
            Point3D actualProjection = new Point3D();
            expectedProjection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)expectedProjection);
            boolean success = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentStart);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentEnd);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            testPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expectedProjection.set(lineSegmentStart);
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            lineSegmentDirection.scale(9.0E-13);
            lineSegmentEnd.add((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentDirection);
            success = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
    }

    @Test
    public void testOrthogonalProjectionOnPlane3D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointOnPlane.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector3D planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector3D parallelToPlane = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            Point3D expectedProjection = new Point3D();
            expectedProjection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)parallelToPlane, (Tuple3DReadOnly)pointOnPlane);
            Point3D pointToProject = new Point3D();
            double distanceOffPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            pointToProject.scaleAdd(distanceOffPlane, (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)expectedProjection);
            Point3D actualProjection = new Point3D();
            boolean success = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            actualProjection = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
            planeNormal.normalize();
            planeNormal.scale(9.0E-13);
            Assertions.assertFalse((boolean)EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)actualProjection));
            Assertions.assertNull((Object)EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal));
        }
    }

    @Test
    public void testPercentageAlongLine2D() throws Exception {
        Vector2D lineDirection;
        Point2D pointOnLine;
        int i;
        Random random = new Random(43L);
        for (i = 0; i < 1000; ++i) {
            pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Point2D pointAlreadyOnLine = new Point2D();
            double expectedPercentage = 0.0;
            double actualPercentage = EuclidGeometryTools.percentageAlongLine2D((Point2DReadOnly)pointOnLine, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointOnLine.getX(), (double)pointOnLine.getY(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection.getX(), (double)lineDirection.getY());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = 1.0;
            pointAlreadyOnLine.add((Tuple2DReadOnly)pointOnLine, (Tuple2DReadOnly)lineDirection);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((Point2DReadOnly)pointAlreadyOnLine, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection.getX(), (double)lineDirection.getY());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            pointAlreadyOnLine.scaleAdd(expectedPercentage, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((Point2DReadOnly)pointAlreadyOnLine, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection.getX(), (double)lineDirection.getY());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Vector2D orthogonalToLine = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            if (random.nextBoolean()) {
                orthogonalToLine.negate();
            }
            orthogonalToLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0) / orthogonalToLine.norm());
            Point2D pointAlreadyOnLine = new Point2D();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            pointAlreadyOnLine.scaleAdd(expectedPercentage, (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            pointAlreadyOnLine.add((Tuple2DReadOnly)orthogonalToLine);
            double actualPercentage = EuclidGeometryTools.percentageAlongLine2D((Point2DReadOnly)pointAlreadyOnLine, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine2D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)lineDirection.getX(), (double)lineDirection.getY());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
    }

    @Test
    public void testPercentageAlongLineSegment2D() throws Exception {
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        Random random = new Random(23424L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D pointOnLineSegment = new Point2D();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOnLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOnLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOnLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D pointOffLineSegment = new Point2D();
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection);
            orthogonal.normalize();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOffLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOffLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)pointOffLineSegment, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0E-12);
            Point2D lineSegmentEnd2 = new Point2D();
            lineSegmentEnd2.add((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentDirection);
            double expectedPercentage = 0.0;
            Point2D testPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)testPoint, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd2);
            Assertions.assertTrue((expectedPercentage == actualPercentage ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPercentageAlongLine3D() throws Exception {
        Vector3D lineDirection;
        Point3D pointOnLine;
        int i;
        Random random = new Random(43L);
        for (i = 0; i < 1000; ++i) {
            pointOnLine = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            lineDirection = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Point3D pointAlreadyOnLine = new Point3D();
            double expectedPercentage = 0.0;
            double actualPercentage = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointOnLine, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (double)lineDirection.getX(), (double)lineDirection.getY(), (double)lineDirection.getZ());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = 1.0;
            pointAlreadyOnLine.add((Tuple3DReadOnly)pointOnLine, (Tuple3DReadOnly)lineDirection);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointAlreadyOnLine, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (double)lineDirection.getX(), (double)lineDirection.getY(), (double)lineDirection.getZ());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            pointAlreadyOnLine.scaleAdd(expectedPercentage, (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnLine);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointAlreadyOnLine, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (double)lineDirection.getX(), (double)lineDirection.getY(), (double)lineDirection.getZ());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnLine = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            lineDirection = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D orthogonalToLine = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineDirection, (boolean)true);
            orthogonalToLine.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D pointAlreadyOnLine = new Point3D();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            pointAlreadyOnLine.scaleAdd(expectedPercentage, (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnLine);
            pointAlreadyOnLine.add((Tuple3DReadOnly)orthogonalToLine);
            double actualPercentage = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointAlreadyOnLine, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            actualPercentage = EuclidGeometryTools.percentageAlongLine3D((double)pointAlreadyOnLine.getX(), (double)pointAlreadyOnLine.getY(), (double)pointAlreadyOnLine.getZ(), (double)pointOnLine.getX(), (double)pointOnLine.getY(), (double)pointOnLine.getZ(), (double)lineDirection.getX(), (double)lineDirection.getY(), (double)lineDirection.getZ());
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
    }

    @Test
    public void testPercentageAlongLineSegment3D() throws Exception {
        Point3D lineSegmentEnd;
        Point3D lineSegmentStart;
        int i;
        Random random = new Random(23424L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D pointOnLineSegment = new Point3D();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOnLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOnLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOnLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOnLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOnLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOnLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0);
            Point3D pointOffLineSegment = new Point3D();
            Vector3D lineSegmentDirection = new Vector3D();
            lineSegmentDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegmentDirection, (boolean)true);
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOffLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointOffLineSegment);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOffLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOffLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointOffLineSegment);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOffLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOffLineSegment.interpolate((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointOffLineSegment);
            actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)pointOffLineSegment, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D lineSegmentDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0E-12);
            Point3D lineSegmentEnd2 = new Point3D();
            lineSegmentEnd2.add((Tuple3DReadOnly)lineSegmentStart, (Tuple3DReadOnly)lineSegmentDirection);
            double expectedPercentage = 0.0;
            Point3D testPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double actualPercentage = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)testPoint, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd2);
            Assertions.assertTrue((expectedPercentage == actualPercentage ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPerpendicularBisector2D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D expectedBisectorStart = new Point2D();
            expectedBisectorStart.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, 0.5);
            Vector2D expectedBisectorDirection = new Vector2D();
            expectedBisectorDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)expectedBisectorDirection, (Vector2DBasics)expectedBisectorDirection);
            expectedBisectorDirection.normalize();
            Point2D actualBisectorStart = new Point2D();
            Vector2D actualBisectorDirection = new Vector2D();
            boolean success = EuclidGeometryTools.perpendicularBisector2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualBisectorStart, (Vector2DBasics)actualBisectorDirection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBisectorStart, (EuclidGeometry)actualBisectorStart, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBisectorDirection, (EuclidGeometry)actualBisectorDirection, (double)1.0E-12);
            Point2D pointOnBisector = new Point2D();
            pointOnBisector.scaleAdd(1.0, (Tuple2DReadOnly)actualBisectorDirection, (Tuple2DReadOnly)actualBisectorStart);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)pointOnBisector, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            lineSegmentDirection.scale(9.0E-13);
            lineSegmentEnd.add((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentDirection);
            Assertions.assertFalse((boolean)EuclidGeometryTools.perpendicularBisector2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualBisectorStart, (Vector2DBasics)actualBisectorDirection));
        }
    }

    @Test
    public void testPerpendicularBisectorSegment2D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D lineSegmentMidpoint = new Point2D();
            lineSegmentMidpoint.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, 0.5);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            double bisectorSegmentHalfLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D bisectorSegmentStart = new Point2D();
            Point2D bisectorSegmentEnd = new Point2D();
            Vector2D bisectorDirection = new Vector2D();
            boolean success = EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength, (Point2DBasics)bisectorSegmentStart, (Point2DBasics)bisectorSegmentEnd);
            Assertions.assertTrue((boolean)success);
            bisectorDirection.sub((Tuple2DReadOnly)bisectorSegmentEnd, (Tuple2DReadOnly)bisectorSegmentStart);
            Assertions.assertEquals((double)(2.0 * bisectorSegmentHalfLength), (double)bisectorDirection.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)lineSegmentDirection.dot((Tuple2DReadOnly)bisectorDirection), (double)1.0E-12);
            Assertions.assertEquals((double)bisectorSegmentHalfLength, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            Assertions.assertEquals((double)bisectorSegmentHalfLength, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentMidpoint, (EuclidGeometry)EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentMidpoint, (EuclidGeometry)EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            List bisectorSegmentEndpoints = EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength);
            bisectorSegmentStart = (Point2D)bisectorSegmentEndpoints.get(0);
            bisectorSegmentEnd = (Point2D)bisectorSegmentEndpoints.get(1);
            bisectorDirection.sub((Tuple2DReadOnly)bisectorSegmentEnd, (Tuple2DReadOnly)bisectorSegmentStart);
            Assertions.assertEquals((double)(2.0 * bisectorSegmentHalfLength), (double)bisectorDirection.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)lineSegmentDirection.dot((Tuple2DReadOnly)bisectorDirection), (double)1.0E-12);
            Assertions.assertEquals((double)bisectorSegmentHalfLength, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            Assertions.assertEquals((double)bisectorSegmentHalfLength, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentMidpoint, (EuclidGeometry)EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)bisectorSegmentStart, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentMidpoint, (EuclidGeometry)EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)bisectorSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd), (double)1.0E-12);
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineSegmentDirection.normalize();
            lineSegmentDirection.scale(9.0E-13);
            lineSegmentEnd.add((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentDirection);
            Assertions.assertNull((Object)EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength));
            Assertions.assertFalse((boolean)EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength, (Point2DBasics)bisectorSegmentStart, (Point2DBasics)bisectorSegmentEnd));
        }
    }

    @Test
    public void testPerpedicularVector2D() throws Exception {
        Vector2D vector = new Vector2D(15.0, 10.0);
        Vector2D expectedReturn = new Vector2D(-10.0, 15.0);
        Vector2D actualReturn = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vector);
        Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"return value");
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            vector = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Vector2D perpendicularVector = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vector);
            Assertions.assertEquals((double)vector.norm(), (double)perpendicularVector.norm(), (double)1.0E-12);
            Assertions.assertEquals((double)(vector.norm() * vector.norm()), (double)vector.cross((Tuple2DReadOnly)perpendicularVector), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)vector.dot((Tuple2DReadOnly)perpendicularVector), (double)1.0E-12);
            Assertions.assertEquals((double)1.5707963267948966, (double)vector.angle((Vector2DReadOnly)perpendicularVector), (double)1.0E-12);
        }
    }

    @Test
    public void testPerpendicularVector3DFromLine3DToPoint3D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expectedPerpendicularVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedPerpendicularVector.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point3D expectedIntersection = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)expectedPerpendicularVector, (boolean)true);
            Point3D firstPointOnLine = new Point3D();
            firstPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            Point3D secondPointOnLine = new Point3D();
            secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)expectedIntersection);
            Point3D point = new Point3D();
            point.add((Tuple3DReadOnly)expectedIntersection, (Tuple3DReadOnly)expectedPerpendicularVector);
            Point3D actualIntersection = new Point3D();
            double epsilon = 1.0E-12;
            if (firstPointOnLine.distance((Point3DReadOnly)secondPointOnLine) < 5.0E-4) {
                epsilon = 1.0E-10;
            }
            Vector3D actualPerpendicularVector = EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualIntersection);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedIntersection, (EuclidGeometry)actualIntersection, (double)epsilon);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPerpendicularVector, (EuclidGeometry)actualPerpendicularVector, (double)epsilon);
            actualPerpendicularVector = EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPerpendicularVector, (EuclidGeometry)actualPerpendicularVector, (double)epsilon);
            lineDirection.normalize();
            lineDirection.scale(9.0E-13);
            secondPointOnLine.add((Tuple3DReadOnly)firstPointOnLine, (Tuple3DReadOnly)lineDirection);
            Assertions.assertNull((Object)EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)actualIntersection));
        }
    }

    @Test
    public void testPythagorasGetCathetus() throws Exception {
        try {
            EuclidGeometryTools.pythagorasGetCathetus((double)-4.9E-324, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.pythagorasGetCathetus((double)1.0, (double)-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.pythagorasGetCathetus((double)1.0, (double)2.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        EuclidGeometryTools.pythagorasGetCathetus((double)1.0, (double)1.0);
        Random random = new Random(23434L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = new Point2D();
            Point2D b = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0), 0.0);
            Point2D c = new Point2D(0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0));
            double hypotenuseC = b.distance((Point2DReadOnly)c);
            double cathetusA = a.distance((Point2DReadOnly)b);
            double expectedCathetusB = a.distance((Point2DReadOnly)c);
            double actualCathetusB = EuclidGeometryTools.pythagorasGetCathetus((double)hypotenuseC, (double)cathetusA);
            Assertions.assertEquals((double)expectedCathetusB, (double)actualCathetusB, (double)1.0E-12);
        }
    }

    @Test
    public void testPythagorasGetHypotenuse() throws Exception {
        try {
            EuclidGeometryTools.pythagorasGetHypotenuse((double)-4.9E-324, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.pythagorasGetHypotenuse((double)1.0, (double)-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Random random = new Random(23434L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = new Point2D();
            Point2D b = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0), 0.0);
            Point2D c = new Point2D(0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)10.0));
            double cathetusA = a.distance((Point2DReadOnly)b);
            double cathetusB = a.distance((Point2DReadOnly)c);
            double expectedHypotenuseC = b.distance((Point2DReadOnly)c);
            double actualHypotenuseC = EuclidGeometryTools.pythagorasGetHypotenuse((double)cathetusA, (double)cathetusB);
            Assertions.assertEquals((double)expectedHypotenuseC, (double)actualHypotenuseC, (double)1.0E-12);
        }
    }

    @Test
    public void testRadiusOfArc() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            double expectedArcRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)100.0);
            double chordAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * -3), (double)(Math.PI * 3));
            double chordLength = 2.0 * expectedArcRadius * EuclidCoreTools.sin((double)(0.5 * chordAngle));
            double actualArcRadius = EuclidGeometryTools.radiusOfArc((double)chordLength, (double)chordAngle);
            Assertions.assertEquals((double)expectedArcRadius, (double)actualArcRadius, (double)1.0E-12);
        }
        Assertions.assertTrue((boolean)Double.isNaN(EuclidGeometryTools.radiusOfArc((double)1.0, (double)0.0)));
        Assertions.assertTrue((boolean)Double.isNaN(EuclidGeometryTools.radiusOfArc((double)1.0, (double)Math.PI)));
        Assertions.assertTrue((boolean)Double.isNaN(EuclidGeometryTools.radiusOfArc((double)1.0, (double)(-Math.PI))));
    }

    @Test
    public void testSignedDistanceFromPoint2DToLine2D() throws Exception {
        Random random = new Random(243234L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Point2D secondPointOnLine = new Point2D();
            secondPointOnLine.add((Tuple2DReadOnly)firstPointOnLine, (Tuple2DReadOnly)lineDirection);
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineDirection);
            orthogonal.normalize();
            boolean expectingNegativeSign = random.nextBoolean();
            if (expectingNegativeSign) {
                orthogonal.negate();
            }
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D query = new Point2D();
            query.scaleAdd(expectedDistance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)firstPointOnLine);
            query.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)query);
            double actualDistance = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)(expectingNegativeSign ? -actualDistance : actualDistance), (double)1.0E-12, (String)("Iteration: " + i));
            actualDistance = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Assertions.assertEquals((double)expectedDistance, (double)(expectingNegativeSign ? -actualDistance : actualDistance), (double)1.0E-12, (String)("Iteration: " + i));
            lineDirection.normalize();
            lineDirection.scale(9.989999999999999E-13);
            secondPointOnLine.add((Tuple2DReadOnly)firstPointOnLine, (Tuple2DReadOnly)lineDirection);
            expectedDistance = firstPointOnLine.distance((Point2DReadOnly)query);
            actualDistance = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12, (String)("Iteration: " + i));
            actualDistance = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)query, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12, (String)("Iteration: " + i));
        }
    }

    @Test
    public void testSphere3DPositionFromThreePoints() {
        Point3D p3;
        Point3D p2;
        Point3D p1;
        double sphere3DRadius;
        int i;
        Random random = new Random(23498675L);
        for (i = 0; i < 1000; ++i) {
            sphere3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D expected = new Point3D();
            p1 = new Point3D();
            p2 = new Point3D();
            p3 = new Point3D();
            p1.scaleAdd(sphere3DRadius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random), (Tuple3DReadOnly)expected);
            p2.scaleAdd(sphere3DRadius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random), (Tuple3DReadOnly)expected);
            p3.scaleAdd(sphere3DRadius, (Tuple3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random), (Tuple3DReadOnly)expected);
            Vector3D p1ToSphere = new Vector3D();
            p1ToSphere.sub((Tuple3DReadOnly)p1, (Tuple3DReadOnly)expected);
            Vector3D normal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)p1, (Point3DReadOnly)p2, (Point3DReadOnly)p3);
            boolean isCounterClockwiseWinding = p1ToSphere.dot((Tuple3DReadOnly)normal) < 0.0;
            Point3D actual = new Point3D();
            boolean success = isCounterClockwiseWinding ? EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)p1, (Point3DReadOnly)p2, (Point3DReadOnly)p3, (double)sphere3DRadius, (Point3DBasics)actual) : EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)p1, (Point3DReadOnly)p3, (Point3DReadOnly)p2, (double)sphere3DRadius, (Point3DBasics)actual);
            Assertions.assertTrue((boolean)success, (String)("Iteration " + i));
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)3.0E-8);
        }
        for (i = 0; i < 1000; ++i) {
            sphere3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D sphere3DPosition = new Point3D();
            p1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            p2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            p3 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double lengthA = p1.distance((Point3DReadOnly)p2);
            double lengthB = p2.distance((Point3DReadOnly)p3);
            double lengthC = p3.distance((Point3DReadOnly)p1);
            double circumradius = EuclidGeometryTools.triangleCircumradius((double)lengthA, (double)lengthB, (double)lengthC);
            boolean success = EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)p1, (Point3DReadOnly)p2, (Point3DReadOnly)p3, (double)sphere3DRadius, (Point3DBasics)sphere3DPosition);
            Assertions.assertEquals((Object)(circumradius <= sphere3DRadius ? 1 : 0), (Object)success);
            if (!success) continue;
            double d1 = sphere3DPosition.distance((Point3DReadOnly)p1);
            double d2 = sphere3DPosition.distance((Point3DReadOnly)p2);
            double d3 = sphere3DPosition.distance((Point3DReadOnly)p3);
            Assertions.assertEquals((double)d1, (double)d2, (double)1.0E-12);
            Assertions.assertEquals((double)d1, (double)d3, (double)1.0E-12);
            Assertions.assertEquals((double)d1, (double)sphere3DRadius, (double)1.0E-12);
        }
    }

    @Test
    public void testTopVertex3DOfIsoscelesTriangle3D() throws Exception {
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Point3D expectedB = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0);
            Point3D a = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D ba = new Vector3D();
            ba.sub((Tuple3DReadOnly)a, (Tuple3DReadOnly)expectedB);
            double abcAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.5707963267948966);
            Vector3D triangleNormal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)ba, (boolean)true);
            triangleNormal.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            AxisAngle abcAxisAngle = new AxisAngle((Vector3DReadOnly)triangleNormal, abcAngle);
            RotationMatrix abcRotationMatrix = new RotationMatrix();
            abcRotationMatrix.set((Orientation3DReadOnly)abcAxisAngle);
            Vector3D bc = new Vector3D();
            abcRotationMatrix.transform((Tuple3DReadOnly)ba, (Tuple3DBasics)bc);
            Point3D c = new Point3D();
            c.add((Tuple3DReadOnly)bc, (Tuple3DReadOnly)expectedB);
            double epsilon = 1.0E-11;
            Point3D actualB = new Point3D();
            EuclidGeometryTools.topVertex3DOfIsoscelesTriangle3D((Point3DReadOnly)a, (Point3DReadOnly)c, (Vector3DReadOnly)triangleNormal, (double)abcAngle, (Point3DBasics)actualB);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedB, (EuclidGeometry)actualB, (double)epsilon);
            Assertions.assertEquals((double)abcAngle, (double)ba.angle((Vector3DReadOnly)bc), (double)epsilon);
        }
    }

    @Test
    public void testTriangleBisector2D() throws Exception {
        Point2D c;
        Point2D b;
        Point2D a;
        Vector2D small;
        int i;
        Random random = new Random(1176L);
        for (i = 0; i < 1000; ++i) {
            Point2D a2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D b2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D c2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D ba = new Vector2D();
            ba.sub((Tuple2DReadOnly)a2, (Tuple2DReadOnly)b2);
            Vector2D bc = new Vector2D();
            bc.sub((Tuple2DReadOnly)c2, (Tuple2DReadOnly)b2);
            double abcAngle = ba.angle((Vector2DReadOnly)bc);
            Point2D x = new Point2D();
            Vector2D bx = new Vector2D();
            boolean success = EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a2, (Point2DReadOnly)b2, (Point2DReadOnly)c2, (Point2DBasics)x);
            Assertions.assertTrue((boolean)success);
            bx.sub((Tuple2DReadOnly)x, (Tuple2DReadOnly)b2);
            double abxAngle = ba.angle((Vector2DReadOnly)bx);
            Assertions.assertEquals((double)(0.5 * abcAngle), (double)abxAngle, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)x, (Point2DReadOnly)a2, (Point2DReadOnly)c2), (double)1.0E-12);
            x = EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a2, (Point2DReadOnly)b2, (Point2DReadOnly)c2);
            bx.sub((Tuple2DReadOnly)x, (Tuple2DReadOnly)b2);
            abxAngle = ba.angle((Vector2DReadOnly)bx);
            Assertions.assertEquals((double)(0.5 * abcAngle), (double)abxAngle, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)x, (Point2DReadOnly)a2, (Point2DReadOnly)c2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            small = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.0E-13);
            a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            b = new Point2D();
            b.add((Tuple2DReadOnly)a, (Tuple2DReadOnly)small);
            c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Assertions.assertFalse((boolean)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DBasics)new Point2D()));
            Assertions.assertNull((Object)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        }
        for (i = 0; i < 1000; ++i) {
            small = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.0E-13);
            a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            c.add((Tuple2DReadOnly)b, (Tuple2DReadOnly)small);
            Assertions.assertFalse((boolean)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DBasics)new Point2D()));
            Assertions.assertNull((Object)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        }
        for (i = 0; i < 1000; ++i) {
            small = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.0E-13);
            a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            b = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            c.add((Tuple2DReadOnly)a, (Tuple2DReadOnly)small);
            Assertions.assertFalse((boolean)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c, (Point2DBasics)new Point2D()));
            Assertions.assertNull((Object)EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        }
    }

    @Test
    public void testTriangleIsoscelesHeight() {
        Random random = new Random(8734L);
        for (int i = 0; i < 1000; ++i) {
            double legLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double baseLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(2.0 * legLength));
            double height = EuclidGeometryTools.triangleIsoscelesHeight((double)legLength, (double)baseLength);
            double rightTriangleArea = EuclidGeometryTools.triangleAreaHeron1((double)legLength, (double)height, (double)(0.5 * baseLength));
            double isoscelesTriangleArea = EuclidGeometryTools.triangleAreaHeron1((double)legLength, (double)legLength, (double)baseLength);
            Assertions.assertEquals((double)(2.0 * rightTriangleArea), (double)isoscelesTriangleArea, (double)1.0E-12);
            double pythagorasHeight = EuclidGeometryTools.pythagorasGetCathetus((double)legLength, (double)(0.5 * baseLength));
            Assertions.assertEquals((double)height, (double)pythagorasHeight, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> EuclidGeometryTools.triangleIsoscelesHeight((double)0.5, (double)1.1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EuclidGeometryTools.triangleIsoscelesHeight((double)-0.1, (double)1.1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EuclidGeometryTools.triangleIsoscelesHeight((double)0.1, (double)-0.1));
    }

    @Test
    public void testUnknownTriangleAngleByLawOfCosine() throws Exception {
        Random random = new Random(34534L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D b = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D ab = new Vector2D();
            ab.sub((Tuple2DReadOnly)b, (Tuple2DReadOnly)a);
            Vector2D ba = new Vector2D();
            ba.sub((Tuple2DReadOnly)a, (Tuple2DReadOnly)b);
            Vector2D ac = new Vector2D();
            ac.sub((Tuple2DReadOnly)c, (Tuple2DReadOnly)a);
            Vector2D ca = new Vector2D();
            ca.sub((Tuple2DReadOnly)a, (Tuple2DReadOnly)c);
            Vector2D bc = new Vector2D();
            bc.sub((Tuple2DReadOnly)c, (Tuple2DReadOnly)b);
            Vector2D cb = new Vector2D();
            cb.sub((Tuple2DReadOnly)b, (Tuple2DReadOnly)c);
            double abLength = ab.norm();
            double acLength = ac.norm();
            double bcLength = bc.norm();
            double abc = Math.abs(ba.angle((Vector2DReadOnly)bc));
            double bca = Math.abs(cb.angle((Vector2DReadOnly)ca));
            double cab = Math.abs(ac.angle((Vector2DReadOnly)ab));
            Assertions.assertEquals((double)cab, (double)EuclidGeometryTools.unknownTriangleAngleByLawOfCosine((double)abLength, (double)acLength, (double)bcLength), (double)1.0E-12);
            Assertions.assertEquals((double)bca, (double)EuclidGeometryTools.unknownTriangleAngleByLawOfCosine((double)acLength, (double)bcLength, (double)abLength), (double)1.0E-12);
            Assertions.assertEquals((double)abc, (double)EuclidGeometryTools.unknownTriangleAngleByLawOfCosine((double)abLength, (double)bcLength, (double)acLength), (double)1.0E-12);
        }
    }

    @Test
    public void testUnknownTriangleSideLengthByLawOfCosine() throws Exception {
        Random random = new Random(34534L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D b = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D ab = new Vector2D();
            ab.sub((Tuple2DReadOnly)b, (Tuple2DReadOnly)a);
            Vector2D ba = new Vector2D();
            ba.sub((Tuple2DReadOnly)a, (Tuple2DReadOnly)b);
            Vector2D ac = new Vector2D();
            ac.sub((Tuple2DReadOnly)c, (Tuple2DReadOnly)a);
            Vector2D ca = new Vector2D();
            ca.sub((Tuple2DReadOnly)a, (Tuple2DReadOnly)c);
            Vector2D bc = new Vector2D();
            bc.sub((Tuple2DReadOnly)c, (Tuple2DReadOnly)b);
            Vector2D cb = new Vector2D();
            cb.sub((Tuple2DReadOnly)b, (Tuple2DReadOnly)c);
            double abLength = ab.norm();
            double acLength = ac.norm();
            double bcLength = bc.norm();
            double abc = Math.abs(ba.angle((Vector2DReadOnly)bc));
            double bca = Math.abs(cb.angle((Vector2DReadOnly)ca));
            double cab = Math.abs(ac.angle((Vector2DReadOnly)ab));
            Assertions.assertEquals((double)bcLength, (double)EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)abLength, (double)acLength, (double)cab), (double)1.0E-12);
            Assertions.assertEquals((double)abLength, (double)EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)acLength, (double)bcLength, (double)bca), (double)1.0E-12);
            Assertions.assertEquals((double)acLength, (double)EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)abLength, (double)bcLength, (double)abc), (double)1.0E-12);
        }
        try {
            EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)-4.9E-324, (double)1.0, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)1.0, (double)-4.9E-324, (double)1.0);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)1.0, (double)1.0, (double)3.1415926535897936);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

