/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class EuclidCoreTestToolsTest {
    private static final String MESSAGE_PREFIX = "blop";
    private static final String FORMAT = EuclidCoreIOTools.getStringFormat((int)15, (int)12);
    private static final double EPSILON = 1.0E-4;

    @Test
    public void testAssertRotationVectorGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertRotationVectorGeometricallyEquals";
        Class<Vector3DReadOnly> argumentsClass = Vector3DReadOnly.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertEquals";
        Class<EuclidGeometry> argumentsClass = EuclidGeometry.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertGeometricallyEquals";
        Class<EuclidGeometry> argumentsClass = EuclidGeometry.class;
        Point3D expected = null;
        Point3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = new Point3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertPoint2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertPoint2DGeometricallyEquals";
        Class<Point2DReadOnly> argumentsClass = Point2DReadOnly.class;
        Point2D expected = null;
        Point2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextPoint2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = EuclidCoreRandomTools.nextPoint2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = new Point2D((Tuple2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector2DGeometricallyEquals";
        Class<Vector2DReadOnly> argumentsClass = Vector2DReadOnly.class;
        Vector2D expected = null;
        Vector2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = new Vector2D((Tuple2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertPoint3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertPoint3DGeometricallyEquals";
        Class<Point3DReadOnly> argumentsClass = Point3DReadOnly.class;
        Point3D expected = null;
        Point3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = new Point3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector3DGeometricallyEquals";
        Class<Vector3DReadOnly> argumentsClass = Vector3DReadOnly.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector4DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector4DGeometricallyEquals";
        Class<Vector4DReadOnly> argumentsClass = Vector4DReadOnly.class;
        Vector4D expected = null;
        Vector4D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = new Vector4D((Tuple4DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertMatrix3DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertMatrix3DEquals";
        Class<Matrix3DReadOnly> argumentsClass = Matrix3DReadOnly.class;
        Matrix3D expected = null;
        Matrix3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = new Matrix3D((Matrix3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertOrientation3DGeometricallyEquals() throws Throwable {
        Random random = new Random(345234L);
        String methodName = "assertOrientation3DGeometricallyEquals";
        Class<Orientation3DReadOnly> argumentsClass = Orientation3DReadOnly.class;
        Orientation3DBasics expected = null;
        Orientation3DBasics actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextOrientation3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation3D((Random)random);
        actual = EuclidCoreRandomTools.nextOrientation3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation3D((Random)random);
        AxisAngle actualAxisAngle = new AxisAngle((Orientation3DReadOnly)expected);
        RotationMatrix actualRotationMatrix = new RotationMatrix((Orientation3DReadOnly)expected);
        Quaternion actualQuaternion = new Quaternion((Orientation3DReadOnly)expected);
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll((Orientation3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actualAxisAngle, 1.0E-4);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actualRotationMatrix, 1.0E-4);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actualQuaternion, 1.0E-4);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actualYawPitchRoll, 1.0E-4);
    }

    private static void assertAssertionMethodsBehaveProperly(boolean failExpected, String methodName, Class<?> argumentsClass, Object expected, Object actual, double epsilon) throws Throwable {
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(EuclidCoreTestTools.class, failExpected, methodName, argumentsClass, expected, actual, epsilon);
    }

    public static void assertAssertionMethodsBehaveProperly(Class<?> assertionClassHolder, boolean failExpected, String methodName, Class<?> argumentsClass, Object expected, Object actual, double epsilon) throws Throwable {
        Method assertionMethod3;
        Method assertionMethod2;
        block17: {
            Method assertionMethod1 = assertionClassHolder.getMethod(methodName, argumentsClass, argumentsClass, Double.TYPE);
            assertionMethod2 = assertionClassHolder.getMethod(methodName, String.class, argumentsClass, argumentsClass, Double.TYPE);
            assertionMethod3 = assertionClassHolder.getMethod(methodName, String.class, argumentsClass, argumentsClass, Double.TYPE, String.class);
            try {
                try {
                    assertionMethod1.invoke(null, expected, actual, epsilon);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
                }
                if (failExpected) {
                    EuclidCoreTestToolsTest.didNotThrowAssertionError();
                }
            }
            catch (AssertionError e) {
                if (failExpected) break block17;
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
        }
        try {
            try {
                assertionMethod2.invoke(null, MESSAGE_PREFIX, expected, actual, epsilon);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
            }
            if (failExpected) {
                EuclidCoreTestToolsTest.didNotThrowAssertionError();
            }
        }
        catch (AssertionError e) {
            if (!failExpected) {
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
            Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(MESSAGE_PREFIX));
        }
        try {
            try {
                assertionMethod3.invoke(null, MESSAGE_PREFIX, expected, actual, epsilon, FORMAT);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
            }
            if (failExpected) {
                EuclidCoreTestToolsTest.didNotThrowAssertionError();
            }
        }
        catch (AssertionError e) {
            if (!failExpected) {
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
            Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(MESSAGE_PREFIX));
        }
    }

    private static void handleInvokationExceptions(String methodName, Exception e) throws Throwable {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)e;
            if (invocationTargetException.getTargetException() instanceof AssertionError) {
                throw (AssertionError)((Object)invocationTargetException.getTargetException());
            }
            throw invocationTargetException.getTargetException();
        }
        throw e;
    }

    private static void unexpectedlyThrewAssertionError(AssertionError e) {
        Assertions.fail((String)("Should NOT have thrown an " + AssertionError.class.getSimpleName() + ": " + e));
    }

    private static void didNotThrowAssertionError() {
        Assertions.fail((String)("Should have thrown an " + AssertionError.class.getSimpleName()));
    }
}

