/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameShapeAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRamp3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameRamp3DTest {
    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{RigidBodyTransformReadOnly.class, Vector3DReadOnly.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameRamp3DReadOnly.class, Ramp3DReadOnly.class, false, 1, methodFilter);
        tester.assertOverloadingWithFrameObjects(FixedFrameRamp3DBasics.class, Ramp3DBasics.class, false, 1, methodFilter);
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Ramp3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Ramp3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Ramp3D.class, Double.TYPE}));
        methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameRamp3D.class, Ramp3D.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{FixedFrameBoundingBox3DBasics.class}));
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{ReferenceFrame.class, FrameBoundingBox3DBasics.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(EuclidFrameShapeRandomTools::nextFrameRamp3D, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithRamp3D() {
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().contains("IntermediateVariableSupplier") && !m.getName().contains("Listener") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((frame, ramp) -> new FrameRamp3D(frame, (Ramp3DReadOnly)((Ramp3D)ramp)), EuclidShapeRandomTools::nextRamp3D, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameRamp3D, 10);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameRamp3D, 10);
    }
}

