/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox3D;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox3DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;

public class FrameBoundingBox3DTest
extends FrameBoundingBox3DReadOnlyTest<FrameBoundingBox3D> {
    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Override
    public FrameBoundingBox3D createFrameBoundingBox(ReferenceFrame referenceFrame, BoundingBox3DReadOnly boundingBox) {
        return new FrameBoundingBox3D(referenceFrame, boundingBox);
    }

    @Test
    public void testConsistencyWithBoundingBox3D() {
        FrameTypeCopier frameTypeBuilder = (frame, boundingBox) -> this.createFrameBoundingBox(frame, (BoundingBox3DReadOnly)boundingBox);
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidGeometryRandomTools::nextBoundingBox3D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{BoundingBox3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{BoundingBox3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{BoundingBox3D.class, Double.TYPE}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !Modifier.isStatic(m.getModifiers()));
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameBoundingBox3D.class, BoundingBox3D.class, false, 1, methodFilter);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameBoundingBox3D, 10);
    }
}

